define("Core/defined",[],(function(){"use strict";return function(e){return null!=e}})),define("Core/DeveloperError",["./defined"],(function(e){"use strict";function t(e){var t;this.name="DeveloperError",this.message=e;try{throw new Error}catch(e){t=e.stack}this.stack=t}return e(Object.create)&&(t.prototype=Object.create(Error.prototype),t.prototype.constructor=t),t.prototype.toString=function(){var t=this.name+": "+this.message;return e(this.stack)&&(t+="\n"+this.stack.toString()),t},t.throwInstantiationError=function(){throw new t("This function defines an interface and should not be called directly.")},t})),define("Core/Check",["./defined","./DeveloperError"],(function(e,t){"use strict";var r={};function n(e,t,r){return"Expected "+r+" to be typeof "+t+", actual typeof was "+e}return r.typeOf={},r.defined=function(r,n){if(!e(n))throw new t(function(e){return e+" is required, actual value was undefined"}(r))},r.typeOf.func=function(e,r){if("function"!=typeof r)throw new t(n(typeof r,"function",e))},r.typeOf.string=function(e,r){if("string"!=typeof r)throw new t(n(typeof r,"string",e))},r.typeOf.number=function(e,r){if("number"!=typeof r)throw new t(n(typeof r,"number",e))},r.typeOf.number.lessThan=function(e,n,i){if(r.typeOf.number(e,n),n>=i)throw new t("Expected "+e+" to be less than "+i+", actual value was "+n)},r.typeOf.number.lessThanOrEquals=function(e,n,i){if(r.typeOf.number(e,n),n>i)throw new t("Expected "+e+" to be less than or equal to "+i+", actual value was "+n)},r.typeOf.number.greaterThan=function(e,n,i){if(r.typeOf.number(e,n),n<=i)throw new t("Expected "+e+" to be greater than "+i+", actual value was "+n)},r.typeOf.number.greaterThanOrEquals=function(e,n,i){if(r.typeOf.number(e,n),n<i)throw new t("Expected "+e+" to be greater than or equal to"+i+", actual value was "+n)},r.typeOf.object=function(e,r){if("object"!=typeof r)throw new t(n(typeof r,"object",e))},r.typeOf.bool=function(e,r){if("boolean"!=typeof r)throw new t(n(typeof r,"boolean",e))},r.typeOf.number.equals=function(e,n,i,o){if(r.typeOf.number(e,i),r.typeOf.number(n,o),i!==o)throw new t(e+" must be equal to "+n+", the actual values are "+i+" and "+o)},r})),define("Core/freezeObject",["./defined"],(function(e){"use strict";var t=Object.freeze;return e(t)||(t=function(e){return e}),t})),define("Core/defaultValue",["./freezeObject"],(function(e){"use strict";function t(e,t){return null!=e?e:t}return t.EMPTY_OBJECT=e({}),t})),
/**
@license
mersenne-twister.js - https://gist.github.com/banksean/300494

   Copyright (C) 1997 - 2002, Makoto Matsumoto and Takuji Nishimura,
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:

     1. Redistributions of source code must retain the above copyright
        notice, this list of conditions and the following disclaimer.

     2. Redistributions in binary form must reproduce the above copyright
        notice, this list of conditions and the following disclaimer in the
        documentation and/or other materials provided with the distribution.

     3. The names of its contributors may not be used to endorse or promote
        products derived from this software without specific prior written
        permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
   A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
   EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
   PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
define("ThirdParty/mersenne-twister",[],(function(){var e=function(e){null==e&&(e=(new Date).getTime()),this.N=624,this.M=397,this.MATRIX_A=2567483615,this.UPPER_MASK=2147483648,this.LOWER_MASK=2147483647,this.mt=new Array(this.N),this.mti=this.N+1,this.init_genrand(e)};return e.prototype.init_genrand=function(e){for(this.mt[0]=e>>>0,this.mti=1;this.mti<this.N;this.mti++)e=this.mt[this.mti-1]^this.mt[this.mti-1]>>>30,this.mt[this.mti]=(1812433253*((4294901760&e)>>>16)<<16)+1812433253*(65535&e)+this.mti,this.mt[this.mti]>>>=0},e.prototype.genrand_int32=function(){var e,t=new Array(0,this.MATRIX_A);if(this.mti>=this.N){var r;for(this.mti==this.N+1&&this.init_genrand(5489),r=0;r<this.N-this.M;r++)e=this.mt[r]&this.UPPER_MASK|this.mt[r+1]&this.LOWER_MASK,this.mt[r]=this.mt[r+this.M]^e>>>1^t[1&e];for(;r<this.N-1;r++)e=this.mt[r]&this.UPPER_MASK|this.mt[r+1]&this.LOWER_MASK,this.mt[r]=this.mt[r+(this.M-this.N)]^e>>>1^t[1&e];e=this.mt[this.N-1]&this.UPPER_MASK|this.mt[0]&this.LOWER_MASK,this.mt[this.N-1]=this.mt[this.M-1]^e>>>1^t[1&e],this.mti=0}return e=this.mt[this.mti++],e^=e>>>11,e^=e<<7&2636928640,e^=e<<15&4022730752,(e^=e>>>18)>>>0},e.prototype.random=function(){return this.genrand_int32()*(1/4294967296)},e})),define("Core/Math",["../ThirdParty/mersenne-twister","./Check","./defaultValue","./defined","./DeveloperError"],(function(e,t,r,n,i){"use strict";var o={EPSILON1:.1,EPSILON2:.01,EPSILON3:.001,EPSILON4:1e-4,EPSILON5:1e-5,EPSILON6:1e-6,EPSILON7:1e-7,EPSILON8:1e-8,EPSILON9:1e-9,EPSILON10:1e-10,EPSILON11:1e-11,EPSILON12:1e-12,EPSILON13:1e-13,EPSILON14:1e-14,EPSILON15:1e-15,EPSILON16:1e-16,EPSILON17:1e-17,EPSILON18:1e-18,EPSILON19:1e-19,EPSILON20:1e-20,EPSILON21:1e-21,GRAVITATIONALPARAMETER:3986004418e5,SOLAR_RADIUS:6955e5,LUNAR_RADIUS:1737400,SIXTY_FOUR_KILOBYTES:65536};o.sign=r(Math.sign,(function(e){return 0==(e=+e)||e!=e?e:e>0?1:-1})),o.signNotZero=function(e){return e<0?-1:1},o.toSNorm=function(e,t){return t=r(t,255),Math.round((.5*o.clamp(e,-1,1)+.5)*t)},o.fromSNorm=function(e,t){return t=r(t,255),o.clamp(e,0,t)/t*2-1},o.sinh=r(Math.sinh,(function(e){return(Math.exp(e)-Math.exp(-e))/2})),o.cosh=r(Math.cosh,(function(e){return(Math.exp(e)+Math.exp(-e))/2})),o.lerp=function(e,t,r){return(1-r)*e+r*t},o.PI=Math.PI,o.ONE_OVER_PI=1/Math.PI,o.PI_OVER_TWO=Math.PI/2,o.PI_OVER_THREE=Math.PI/3,o.PI_OVER_FOUR=Math.PI/4,o.PI_OVER_SIX=Math.PI/6,o.THREE_PI_OVER_TWO=3*Math.PI/2,o.TWO_PI=2*Math.PI,o.ONE_OVER_TWO_PI=1/(2*Math.PI),o.RADIANS_PER_DEGREE=Math.PI/180,o.DEGREES_PER_RADIAN=180/Math.PI,o.RADIANS_PER_ARCSECOND=o.RADIANS_PER_DEGREE/3600,o.toRadians=function(e){if(!n(e))throw new i("degrees is required.");return e*o.RADIANS_PER_DEGREE},o.toDegrees=function(e){if(!n(e))throw new i("radians is required.");return e*o.DEGREES_PER_RADIAN},o.convertLongitudeRange=function(e){if(!n(e))throw new i("angle is required.");var t=o.TWO_PI,r=e-Math.floor(e/t)*t;return r<-Math.PI?r+t:r>=Math.PI?r-t:r},o.clampToLatitudeRange=function(e){if(!n(e))throw new i("angle is required.");return o.clamp(e,-1*o.PI_OVER_TWO,o.PI_OVER_TWO)},o.negativePiToPi=function(e){if(!n(e))throw new i("angle is required.");return o.zeroToTwoPi(e+o.PI)-o.PI},o.zeroToTwoPi=function(e){if(!n(e))throw new i("angle is required.");var t=o.mod(e,o.TWO_PI);return Math.abs(t)<o.EPSILON14&&Math.abs(e)>o.EPSILON14?o.TWO_PI:t},o.mod=function(e,t){if(!n(e))throw new i("m is required.");if(!n(t))throw new i("n is required.");return(e%t+t)%t},o.equalsEpsilon=function(e,t,o,a){if(!n(e))throw new i("left is required.");if(!n(t))throw new i("right is required.");if(!n(o))throw new i("relativeEpsilon is required.");a=r(a,o);var u=Math.abs(e-t);return u<=a||u<=o*Math.max(Math.abs(e),Math.abs(t))};var a=[1];o.factorial=function(e){if("number"!=typeof e||e<0)throw new i("A number greater than or equal to 0 is required.");var t=a.length;if(e>=t)for(var r=a[t-1],n=t;n<=e;n++)a.push(r*n);return a[e]},o.incrementWrap=function(e,t,o){if(o=r(o,0),!n(e))throw new i("n is required.");if(t<=o)throw new i("maximumValue must be greater than minimumValue.");return++e>t&&(e=o),e},o.isPowerOfTwo=function(e){if("number"!=typeof e||e<0)throw new i("A number greater than or equal to 0 is required.");return 0!==e&&0==(e&e-1)},o.nextPowerOfTwo=function(e){if("number"!=typeof e||e<0)throw new i("A number greater than or equal to 0 is required.");return--e,e|=e>>1,e|=e>>2,e|=e>>4,e|=e>>8,e|=e>>16,++e},o.clamp=function(e,t,r){if(!n(e))throw new i("value is required");if(!n(t))throw new i("min is required.");if(!n(r))throw new i("max is required.");return e<t?t:e>r?r:e};var u=new e;return o.setRandomNumberSeed=function(t){if(!n(t))throw new i("seed is required.");u=new e(t)},o.nextRandomNumber=function(){return u.random()},o.randomBetween=function(e,t){return o.nextRandomNumber()*(t-e)+e},o.acosClamped=function(e){if(!n(e))throw new i("value is required.");return Math.acos(o.clamp(e,-1,1))},o.asinClamped=function(e){if(!n(e))throw new i("value is required.");return Math.asin(o.clamp(e,-1,1))},o.chordLength=function(e,t){if(!n(e))throw new i("angle is required.");if(!n(t))throw new i("radius is required.");return 2*t*Math.sin(.5*e)},o.logBase=function(e,t){if(!n(e))throw new i("number is required.");if(!n(t))throw new i("base is required.");return Math.log(e)/Math.log(t)},o.cbrt=r(Math.cbrt,(function(e){var t=Math.pow(Math.abs(e),1/3);return e<0?-t:t})),o.log2=r(Math.log2,(function(e){return Math.log(e)*Math.LOG2E})),o.fog=function(e,t){var r=e*t;return 1-Math.exp(-r*r)},o.fastApproximateAtan=function(e){return t.typeOf.number("x",e),e*(-.1784*Math.abs(e)-.0663*e*e+1.0301)},o.fastApproximateAtan2=function(e,r){var n,a;t.typeOf.number("x",e),t.typeOf.number("y",r);var u=Math.abs(e);n=Math.abs(r),a=Math.max(u,n);var s=(n=Math.min(u,n))/a;if(isNaN(s))throw new i("either x or y must be nonzero");return u=o.fastApproximateAtan(s),u=Math.abs(r)>Math.abs(e)?o.PI_OVER_TWO-u:u,u=e<0?o.PI-u:u,u=r<0?-u:u},o})),define("Core/Cartesian3",["./Check","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],(function(e,t,r,n,i,o){"use strict";function a(e,r,n){this.x=t(e,0),this.y=t(r,0),this.z=t(n,0)}a.fromSpherical=function(n,i){e.typeOf.object("spherical",n),r(i)||(i=new a);var o=n.clock,u=n.cone,s=t(n.magnitude,1),c=s*Math.sin(u);return i.x=c*Math.cos(o),i.y=c*Math.sin(o),i.z=s*Math.cos(u),i},a.fromElements=function(e,t,n,i){return r(i)?(i.x=e,i.y=t,i.z=n,i):new a(e,t,n)},a.clone=function(e,t){if(r(e))return r(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t):new a(e.x,e.y,e.z)},a.fromCartesian4=a.clone,a.packedLength=3,a.pack=function(r,n,i){return e.typeOf.object("value",r),e.defined("array",n),i=t(i,0),n[i++]=r.x,n[i++]=r.y,n[i]=r.z,n},a.unpack=function(n,i,o){return e.defined("array",n),i=t(i,0),r(o)||(o=new a),o.x=n[i++],o.y=n[i++],o.z=n[i],o},a.packArray=function(t,n){e.defined("array",t);var i=t.length;r(n)?n.length=3*i:n=new Array(3*i);for(var o=0;o<i;++o)a.pack(t[o],n,3*o);return n},a.unpackArray=function(t,i){if(e.defined("array",t),e.typeOf.number.greaterThanOrEquals("array.length",t.length,3),t.length%3!=0)throw new n("array length must be a multiple of 3.");var o=t.length;r(i)?i.length=o/3:i=new Array(o/3);for(var u=0;u<o;u+=3){var s=u/3;i[s]=a.unpack(t,u,i[s])}return i},a.fromArray=a.unpack,a.maximumComponent=function(t){return e.typeOf.object("cartesian",t),Math.max(t.x,t.y,t.z)},a.minimumComponent=function(t){return e.typeOf.object("cartesian",t),Math.min(t.x,t.y,t.z)},a.minimumByComponent=function(t,r,n){return e.typeOf.object("first",t),e.typeOf.object("second",r),e.typeOf.object("result",n),n.x=Math.min(t.x,r.x),n.y=Math.min(t.y,r.y),n.z=Math.min(t.z,r.z),n},a.maximumByComponent=function(t,r,n){return e.typeOf.object("first",t),e.typeOf.object("second",r),e.typeOf.object("result",n),n.x=Math.max(t.x,r.x),n.y=Math.max(t.y,r.y),n.z=Math.max(t.z,r.z),n},a.magnitudeSquared=function(t){return e.typeOf.object("cartesian",t),t.x*t.x+t.y*t.y+t.z*t.z},a.magnitude=function(e){return Math.sqrt(a.magnitudeSquared(e))};var u=new a;a.distance=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),a.subtract(t,r,u),a.magnitude(u)},a.distanceSquared=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),a.subtract(t,r,u),a.magnitudeSquared(u)},a.normalize=function(t,r){e.typeOf.object("cartesian",t),e.typeOf.object("result",r);var i=a.magnitude(t);if(r.x=t.x/i,r.y=t.y/i,r.z=t.z/i,isNaN(r.x)||isNaN(r.y)||isNaN(r.z))throw new n("normalized result is not a number");return r},a.dot=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),t.x*r.x+t.y*r.y+t.z*r.z},a.multiplyComponents=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x*r.x,n.y=t.y*r.y,n.z=t.z*r.z,n},a.divideComponents=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x/r.x,n.y=t.y/r.y,n.z=t.z/r.z,n},a.add=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x+r.x,n.y=t.y+r.y,n.z=t.z+r.z,n},a.subtract=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x-r.x,n.y=t.y-r.y,n.z=t.z-r.z,n},a.multiplyByScalar=function(t,r,n){return e.typeOf.object("cartesian",t),e.typeOf.number("scalar",r),e.typeOf.object("result",n),n.x=t.x*r,n.y=t.y*r,n.z=t.z*r,n},a.divideByScalar=function(t,r,n){return e.typeOf.object("cartesian",t),e.typeOf.number("scalar",r),e.typeOf.object("result",n),n.x=t.x/r,n.y=t.y/r,n.z=t.z/r,n},a.negate=function(t,r){return e.typeOf.object("cartesian",t),e.typeOf.object("result",r),r.x=-t.x,r.y=-t.y,r.z=-t.z,r},a.abs=function(t,r){return e.typeOf.object("cartesian",t),e.typeOf.object("result",r),r.x=Math.abs(t.x),r.y=Math.abs(t.y),r.z=Math.abs(t.z),r};var s=new a;a.lerp=function(t,r,n,i){return e.typeOf.object("start",t),e.typeOf.object("end",r),e.typeOf.number("t",n),e.typeOf.object("result",i),a.multiplyByScalar(r,n,s),i=a.multiplyByScalar(t,1-n,i),a.add(s,i,i)};var c=new a,l=new a;a.angleBetween=function(t,r){e.typeOf.object("left",t),e.typeOf.object("right",r),a.normalize(t,c),a.normalize(r,l);var n=a.dot(c,l),i=a.magnitude(a.cross(c,l,c));return Math.atan2(i,n)};var f=new a;a.mostOrthogonalAxis=function(t,r){e.typeOf.object("cartesian",t),e.typeOf.object("result",r);var n=a.normalize(t,f);return a.abs(n,n),r=n.x<=n.y?n.x<=n.z?a.clone(a.UNIT_X,r):a.clone(a.UNIT_Z,r):n.y<=n.z?a.clone(a.UNIT_Y,r):a.clone(a.UNIT_Z,r)},a.projectVector=function(t,r,n){e.defined("a",t),e.defined("b",r),e.defined("result",n);var i=a.dot(t,r)/a.dot(r,r);return a.multiplyByScalar(r,i,n)},a.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z},a.equalsArray=function(e,t,r){return e.x===t[r]&&e.y===t[r+1]&&e.z===t[r+2]},a.equalsEpsilon=function(e,t,n,i){return e===t||r(e)&&r(t)&&o.equalsEpsilon(e.x,t.x,n,i)&&o.equalsEpsilon(e.y,t.y,n,i)&&o.equalsEpsilon(e.z,t.z,n,i)},a.cross=function(t,r,n){e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n);var i=t.x,o=t.y,a=t.z,u=r.x,s=r.y,c=r.z,l=o*c-a*s,f=a*u-i*c,p=i*s-o*u;return n.x=l,n.y=f,n.z=p,n},a.midpoint=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=.5*(t.x+r.x),n.y=.5*(t.y+r.y),n.z=.5*(t.z+r.z),n},a.fromDegrees=function(t,r,n,i,u){return e.typeOf.number("longitude",t),e.typeOf.number("latitude",r),t=o.toRadians(t),r=o.toRadians(r),a.fromRadians(t,r,n,i,u)};var p=new a,h=new a,d=new a(40680631590769,40680631590769,40408299984661.445);return a.fromRadians=function(n,i,o,u,s){e.typeOf.number("longitude",n),e.typeOf.number("latitude",i),o=t(o,0);var c=r(u)?u.radiiSquared:d,l=Math.cos(i);p.x=l*Math.cos(n),p.y=l*Math.sin(n),p.z=Math.sin(i),p=a.normalize(p,p),a.multiplyComponents(c,p,h);var f=Math.sqrt(a.dot(p,h));return h=a.divideByScalar(h,f,h),p=a.multiplyByScalar(p,o,p),r(s)||(s=new a),a.add(h,p,s)},a.fromDegreesArray=function(t,i,o){if(e.defined("coordinates",t),t.length<2||t.length%2!=0)throw new n("the number of coordinates must be a multiple of 2 and at least 2");var u=t.length;r(o)?o.length=u/2:o=new Array(u/2);for(var s=0;s<u;s+=2){var c=t[s],l=t[s+1],f=s/2;o[f]=a.fromDegrees(c,l,0,i,o[f])}return o},a.fromRadiansArray=function(t,i,o){if(e.defined("coordinates",t),t.length<2||t.length%2!=0)throw new n("the number of coordinates must be a multiple of 2 and at least 2");var u=t.length;r(o)?o.length=u/2:o=new Array(u/2);for(var s=0;s<u;s+=2){var c=t[s],l=t[s+1],f=s/2;o[f]=a.fromRadians(c,l,0,i,o[f])}return o},a.fromDegreesArrayHeights=function(t,i,o){if(e.defined("coordinates",t),t.length<3||t.length%3!=0)throw new n("the number of coordinates must be a multiple of 3 and at least 3");var u=t.length;r(o)?o.length=u/3:o=new Array(u/3);for(var s=0;s<u;s+=3){var c=t[s],l=t[s+1],f=t[s+2],p=s/3;o[p]=a.fromDegrees(c,l,f,i,o[p])}return o},a.fromRadiansArrayHeights=function(t,i,o){if(e.defined("coordinates",t),t.length<3||t.length%3!=0)throw new n("the number of coordinates must be a multiple of 3 and at least 3");var u=t.length;r(o)?o.length=u/3:o=new Array(u/3);for(var s=0;s<u;s+=3){var c=t[s],l=t[s+1],f=t[s+2],p=s/3;o[p]=a.fromRadians(c,l,f,i,o[p])}return o},a.ZERO=i(new a(0,0,0)),a.UNIT_X=i(new a(1,0,0)),a.UNIT_Y=i(new a(0,1,0)),a.UNIT_Z=i(new a(0,0,1)),a.prototype.clone=function(e){return a.clone(this,e)},a.prototype.equals=function(e){return a.equals(this,e)},a.prototype.equalsEpsilon=function(e,t,r){return a.equalsEpsilon(this,e,t,r)},a.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+")"},a})),define("Core/scaleToGeodeticSurface",["./Cartesian3","./defined","./DeveloperError","./Math"],(function(e,t,r,n){"use strict";var i=new e,o=new e;return function(a,u,s,c,l){if(!t(a))throw new r("cartesian is required.");if(!t(u))throw new r("oneOverRadii is required.");if(!t(s))throw new r("oneOverRadiiSquared is required.");if(!t(c))throw new r("centerToleranceSquared is required.");var f=a.x,p=a.y,h=a.z,d=u.x,y=u.y,m=u.z,E=f*f*d*d,O=p*p*y*y,v=h*h*m*m,w=E+O+v,_=Math.sqrt(1/w),g=e.multiplyByScalar(a,_,i);if(w<c)return isFinite(_)?e.clone(g,l):void 0;var T=s.x,b=s.y,R=s.z,A=o;A.x=g.x*T*2,A.y=g.y*b*2,A.z=g.z*R*2;var x,S,N,I,M,C,P,D=(1-_)*e.magnitude(a)/(.5*e.magnitude(A)),U=0;do{U=(x=E*(M=(S=1/(1+(D-=U)*T))*S)+O*(C=(N=1/(1+D*b))*N)+v*(P=(I=1/(1+D*R))*I)-1)/(-2*(E*(M*S)*T+O*(C*N)*b+v*(P*I)*R))}while(Math.abs(x)>n.EPSILON12);return t(l)?(l.x=f*S,l.y=p*N,l.z=h*I,l):new e(f*S,p*N,h*I)}})),define("Core/Cartographic",["./Cartesian3","./Check","./defaultValue","./defined","./freezeObject","./Math","./scaleToGeodeticSurface"],(function(e,t,r,n,i,o,a){"use strict";function u(e,t,n){this.longitude=r(e,0),this.latitude=r(t,0),this.height=r(n,0)}u.fromRadians=function(e,i,o,a){return t.typeOf.number("longitude",e),t.typeOf.number("latitude",i),o=r(o,0),n(a)?(a.longitude=e,a.latitude=i,a.height=o,a):new u(e,i,o)},u.fromDegrees=function(e,r,n,i){return t.typeOf.number("longitude",e),t.typeOf.number("latitude",r),e=o.toRadians(e),r=o.toRadians(r),u.fromRadians(e,r,n,i)};var s=new e,c=new e,l=new e,f=new e(1/6378137,1/6378137,1/6356752.314245179),p=new e(1/40680631590769,1/40680631590769,1/40408299984661.445),h=o.EPSILON1;return u.fromCartesian=function(t,r,i){var d=n(r)?r.oneOverRadii:f,y=n(r)?r.oneOverRadiiSquared:p,m=n(r)?r._centerToleranceSquared:h,E=a(t,d,y,m,c);if(n(E)){var O=e.multiplyComponents(E,y,s);O=e.normalize(O,O);var v=e.subtract(t,E,l),w=Math.atan2(O.y,O.x),_=Math.asin(O.z),g=o.sign(e.dot(v,t))*e.magnitude(v);return n(i)?(i.longitude=w,i.latitude=_,i.height=g,i):new u(w,_,g)}},u.toCartesian=function(r,n,i){return t.defined("cartographic",r),e.fromRadians(r.longitude,r.latitude,r.height,n,i)},u.clone=function(e,t){if(n(e))return n(t)?(t.longitude=e.longitude,t.latitude=e.latitude,t.height=e.height,t):new u(e.longitude,e.latitude,e.height)},u.equals=function(e,t){return e===t||n(e)&&n(t)&&e.longitude===t.longitude&&e.latitude===t.latitude&&e.height===t.height},u.equalsEpsilon=function(e,r,i){return t.typeOf.number("epsilon",i),e===r||n(e)&&n(r)&&Math.abs(e.longitude-r.longitude)<=i&&Math.abs(e.latitude-r.latitude)<=i&&Math.abs(e.height-r.height)<=i},u.ZERO=i(new u(0,0,0)),u.prototype.clone=function(e){return u.clone(this,e)},u.prototype.equals=function(e){return u.equals(this,e)},u.prototype.equalsEpsilon=function(e,t){return u.equalsEpsilon(this,e,t)},u.prototype.toString=function(){return"("+this.longitude+", "+this.latitude+", "+this.height+")"},u})),define("Core/defineProperties",["./defined"],(function(e){"use strict";var t=function(){try{return"x"in Object.defineProperty({},"x",{})}catch(e){return!1}}(),r=Object.defineProperties;return t&&e(r)||(r=function(e){return e}),r})),define("Core/Ellipsoid",["./Cartesian3","./Cartographic","./Check","./defaultValue","./defined","./defineProperties","./DeveloperError","./freezeObject","./Math","./scaleToGeodeticSurface"],(function(e,t,r,n,i,o,a,u,s,c){"use strict";function l(t,i,o,a){i=n(i,0),o=n(o,0),a=n(a,0),r.typeOf.number.greaterThanOrEquals("x",i,0),r.typeOf.number.greaterThanOrEquals("y",o,0),r.typeOf.number.greaterThanOrEquals("z",a,0),t._radii=new e(i,o,a),t._radiiSquared=new e(i*i,o*o,a*a),t._radiiToTheFourth=new e(i*i*i*i,o*o*o*o,a*a*a*a),t._oneOverRadii=new e(0===i?0:1/i,0===o?0:1/o,0===a?0:1/a),t._oneOverRadiiSquared=new e(0===i?0:1/(i*i),0===o?0:1/(o*o),0===a?0:1/(a*a)),t._minimumRadius=Math.min(i,o,a),t._maximumRadius=Math.max(i,o,a),t._centerToleranceSquared=s.EPSILON1,0!==t._radiiSquared.z&&(t._squaredXOverSquaredZ=t._radiiSquared.x/t._radiiSquared.z)}function f(e,t,r){this._radii=void 0,this._radiiSquared=void 0,this._radiiToTheFourth=void 0,this._oneOverRadii=void 0,this._oneOverRadiiSquared=void 0,this._minimumRadius=void 0,this._maximumRadius=void 0,this._centerToleranceSquared=void 0,this._squaredXOverSquaredZ=void 0,l(this,e,t,r)}o(f.prototype,{radii:{get:function(){return this._radii}},radiiSquared:{get:function(){return this._radiiSquared}},radiiToTheFourth:{get:function(){return this._radiiToTheFourth}},oneOverRadii:{get:function(){return this._oneOverRadii}},oneOverRadiiSquared:{get:function(){return this._oneOverRadiiSquared}},minimumRadius:{get:function(){return this._minimumRadius}},maximumRadius:{get:function(){return this._maximumRadius}}}),f.clone=function(t,r){if(i(t)){var n=t._radii;return i(r)?(e.clone(n,r._radii),e.clone(t._radiiSquared,r._radiiSquared),e.clone(t._radiiToTheFourth,r._radiiToTheFourth),e.clone(t._oneOverRadii,r._oneOverRadii),e.clone(t._oneOverRadiiSquared,r._oneOverRadiiSquared),r._minimumRadius=t._minimumRadius,r._maximumRadius=t._maximumRadius,r._centerToleranceSquared=t._centerToleranceSquared,r):new f(n.x,n.y,n.z)}},f.fromCartesian3=function(e,t){return i(t)||(t=new f),i(e)?(l(t,e.x,e.y,e.z),t):t},f.WGS84=u(new f(6378137,6378137,6356752.314245179)),f.UNIT_SPHERE=u(new f(1,1,1)),f.MOON=u(new f(s.LUNAR_RADIUS,s.LUNAR_RADIUS,s.LUNAR_RADIUS)),f.prototype.clone=function(e){return f.clone(this,e)},f.packedLength=e.packedLength,f.pack=function(t,i,o){return r.typeOf.object("value",t),r.defined("array",i),o=n(o,0),e.pack(t._radii,i,o),i},f.unpack=function(t,i,o){r.defined("array",t),i=n(i,0);var a=e.unpack(t,i);return f.fromCartesian3(a,o)},f.prototype.geocentricSurfaceNormal=e.normalize,f.prototype.geodeticSurfaceNormalCartographic=function(t,n){r.typeOf.object("cartographic",t);var o=t.longitude,a=t.latitude,u=Math.cos(a),s=u*Math.cos(o),c=u*Math.sin(o),l=Math.sin(a);return i(n)||(n=new e),n.x=s,n.y=c,n.z=l,e.normalize(n,n)},f.prototype.geodeticSurfaceNormal=function(t,r){return i(r)||(r=new e),r=e.multiplyComponents(t,this._oneOverRadiiSquared,r),e.normalize(r,r)};var p=new e,h=new e;f.prototype.cartographicToCartesian=function(t,r){var n=p,o=h;this.geodeticSurfaceNormalCartographic(t,n),e.multiplyComponents(this._radiiSquared,n,o);var a=Math.sqrt(e.dot(n,o));return e.divideByScalar(o,a,o),e.multiplyByScalar(n,t.height,n),i(r)||(r=new e),e.add(o,n,r)},f.prototype.cartographicArrayToCartesianArray=function(e,t){r.defined("cartographics",e);var n=e.length;i(t)?t.length=n:t=new Array(n);for(var o=0;o<n;o++)t[o]=this.cartographicToCartesian(e[o],t[o]);return t};var d=new e,y=new e,m=new e;return f.prototype.cartesianToCartographic=function(r,n){var o=this.scaleToGeodeticSurface(r,y);if(i(o)){var a=this.geodeticSurfaceNormal(o,d),u=e.subtract(r,o,m),c=Math.atan2(a.y,a.x),l=Math.asin(a.z),f=s.sign(e.dot(u,r))*e.magnitude(u);return i(n)?(n.longitude=c,n.latitude=l,n.height=f,n):new t(c,l,f)}},f.prototype.cartesianArrayToCartographicArray=function(e,t){r.defined("cartesians",e);var n=e.length;i(t)?t.length=n:t=new Array(n);for(var o=0;o<n;++o)t[o]=this.cartesianToCartographic(e[o],t[o]);return t},f.prototype.scaleToGeodeticSurface=function(e,t){return c(e,this._oneOverRadii,this._oneOverRadiiSquared,this._centerToleranceSquared,t)},f.prototype.scaleToGeocentricSurface=function(t,n){r.typeOf.object("cartesian",t),i(n)||(n=new e);var o=t.x,a=t.y,u=t.z,s=this._oneOverRadiiSquared,c=1/Math.sqrt(o*o*s.x+a*a*s.y+u*u*s.z);return e.multiplyByScalar(t,c,n)},f.prototype.transformPositionToScaledSpace=function(t,r){return i(r)||(r=new e),e.multiplyComponents(t,this._oneOverRadii,r)},f.prototype.transformPositionFromScaledSpace=function(t,r){return i(r)||(r=new e),e.multiplyComponents(t,this._radii,r)},f.prototype.equals=function(t){return this===t||i(t)&&e.equals(this._radii,t._radii)},f.prototype.toString=function(){return this._radii.toString()},f.prototype.getSurfaceNormalIntersectionWithZAxis=function(t,o,u){if(r.typeOf.object("position",t),!s.equalsEpsilon(this._radii.x,this._radii.y,s.EPSILON15))throw new a("Ellipsoid must be an ellipsoid of revolution (radii.x == radii.y)");r.typeOf.number.greaterThan("Ellipsoid.radii.z",this._radii.z,0),o=n(o,0);var c=this._squaredXOverSquaredZ;if(i(u)||(u=new e),u.x=0,u.y=0,u.z=t.z*(1-c),!(Math.abs(u.z)>=this._radii.z-o))return u},f})),define("Core/arrayFill",["./Check","./defaultValue","./defined"],(function(e,t,r){"use strict";return function(n,i,o,a){if(e.defined("array",n),e.defined("value",i),r(o)&&e.typeOf.number("start",o),r(a)&&e.typeOf.number("end",a),"function"==typeof n.fill)return n.fill(i,o,a);for(var u=n.length>>>0,s=t(o,0),c=s<0?Math.max(u+s,0):Math.min(s,u),l=t(a,u),f=l<0?Math.max(u+l,0):Math.min(l,u);c<f;)n[c]=i,c++;return n}})),define("Core/Cartesian2",["./Check","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],(function(e,t,r,n,i,o){"use strict";function a(e,r){this.x=t(e,0),this.y=t(r,0)}a.fromElements=function(e,t,n){return r(n)?(n.x=e,n.y=t,n):new a(e,t)},a.clone=function(e,t){if(r(e))return r(t)?(t.x=e.x,t.y=e.y,t):new a(e.x,e.y)},a.fromCartesian3=a.clone,a.fromCartesian4=a.clone,a.packedLength=2,a.pack=function(r,n,i){return e.typeOf.object("value",r),e.defined("array",n),i=t(i,0),n[i++]=r.x,n[i]=r.y,n},a.unpack=function(n,i,o){return e.defined("array",n),i=t(i,0),r(o)||(o=new a),o.x=n[i++],o.y=n[i],o},a.packArray=function(t,n){e.defined("array",t);var i=t.length;r(n)?n.length=2*i:n=new Array(2*i);for(var o=0;o<i;++o)a.pack(t[o],n,2*o);return n},a.unpackArray=function(t,n){e.defined("array",t);var i=t.length;r(n)?n.length=i/2:n=new Array(i/2);for(var o=0;o<i;o+=2){var u=o/2;n[u]=a.unpack(t,o,n[u])}return n},a.fromArray=a.unpack,a.maximumComponent=function(t){return e.typeOf.object("cartesian",t),Math.max(t.x,t.y)},a.minimumComponent=function(t){return e.typeOf.object("cartesian",t),Math.min(t.x,t.y)},a.minimumByComponent=function(t,r,n){return e.typeOf.object("first",t),e.typeOf.object("second",r),e.typeOf.object("result",n),n.x=Math.min(t.x,r.x),n.y=Math.min(t.y,r.y),n},a.maximumByComponent=function(t,r,n){return e.typeOf.object("first",t),e.typeOf.object("second",r),e.typeOf.object("result",n),n.x=Math.max(t.x,r.x),n.y=Math.max(t.y,r.y),n},a.magnitudeSquared=function(t){return e.typeOf.object("cartesian",t),t.x*t.x+t.y*t.y},a.magnitude=function(e){return Math.sqrt(a.magnitudeSquared(e))};var u=new a;a.distance=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),a.subtract(t,r,u),a.magnitude(u)},a.distanceSquared=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),a.subtract(t,r,u),a.magnitudeSquared(u)},a.normalize=function(t,r){e.typeOf.object("cartesian",t),e.typeOf.object("result",r);var i=a.magnitude(t);if(r.x=t.x/i,r.y=t.y/i,isNaN(r.x)||isNaN(r.y))throw new n("normalized result is not a number");return r},a.dot=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),t.x*r.x+t.y*r.y},a.multiplyComponents=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x*r.x,n.y=t.y*r.y,n},a.divideComponents=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x/r.x,n.y=t.y/r.y,n},a.add=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x+r.x,n.y=t.y+r.y,n},a.subtract=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x-r.x,n.y=t.y-r.y,n},a.multiplyByScalar=function(t,r,n){return e.typeOf.object("cartesian",t),e.typeOf.number("scalar",r),e.typeOf.object("result",n),n.x=t.x*r,n.y=t.y*r,n},a.divideByScalar=function(t,r,n){return e.typeOf.object("cartesian",t),e.typeOf.number("scalar",r),e.typeOf.object("result",n),n.x=t.x/r,n.y=t.y/r,n},a.negate=function(t,r){return e.typeOf.object("cartesian",t),e.typeOf.object("result",r),r.x=-t.x,r.y=-t.y,r},a.abs=function(t,r){return e.typeOf.object("cartesian",t),e.typeOf.object("result",r),r.x=Math.abs(t.x),r.y=Math.abs(t.y),r};var s=new a;a.lerp=function(t,r,n,i){return e.typeOf.object("start",t),e.typeOf.object("end",r),e.typeOf.number("t",n),e.typeOf.object("result",i),a.multiplyByScalar(r,n,s),i=a.multiplyByScalar(t,1-n,i),a.add(s,i,i)};var c=new a,l=new a;a.angleBetween=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),a.normalize(t,c),a.normalize(r,l),o.acosClamped(a.dot(c,l))};var f=new a;return a.mostOrthogonalAxis=function(t,r){e.typeOf.object("cartesian",t),e.typeOf.object("result",r);var n=a.normalize(t,f);return a.abs(n,n),r=n.x<=n.y?a.clone(a.UNIT_X,r):a.clone(a.UNIT_Y,r)},a.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y},a.equalsArray=function(e,t,r){return e.x===t[r]&&e.y===t[r+1]},a.equalsEpsilon=function(e,t,n,i){return e===t||r(e)&&r(t)&&o.equalsEpsilon(e.x,t.x,n,i)&&o.equalsEpsilon(e.y,t.y,n,i)},a.ZERO=i(new a(0,0)),a.UNIT_X=i(new a(1,0)),a.UNIT_Y=i(new a(0,1)),a.prototype.clone=function(e){return a.clone(this,e)},a.prototype.equals=function(e){return a.equals(this,e)},a.prototype.equalsEpsilon=function(e,t,r){return a.equalsEpsilon(this,e,t,r)},a.prototype.toString=function(){return"("+this.x+", "+this.y+")"},a})),define("Core/GeographicProjection",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid"],(function(e,t,r,n,i,o,a){"use strict";function u(e){this._ellipsoid=r(e,a.WGS84),this._semimajorAxis=this._ellipsoid.maximumRadius,this._oneOverSemimajorAxis=1/this._semimajorAxis}return i(u.prototype,{ellipsoid:{get:function(){return this._ellipsoid}}}),u.prototype.project=function(t,r){var i=this._semimajorAxis,o=t.longitude*i,a=t.latitude*i,u=t.height;return n(r)?(r.x=o,r.y=a,r.z=u,r):new e(o,a,u)},u.prototype.unproject=function(e,r){if(!n(e))throw new o("cartesian is required");var i=this._oneOverSemimajorAxis,a=e.x*i,u=e.y*i,s=e.z;return n(r)?(r.longitude=a,r.latitude=u,r.height=s,r):new t(a,u,s)},u})),define("Core/Intersect",["./freezeObject"],(function(e){"use strict";return e({OUTSIDE:-1,INTERSECTING:0,INSIDE:1})})),define("Core/Rectangle",["./Cartographic","./Check","./defaultValue","./defined","./defineProperties","./Ellipsoid","./freezeObject","./Math"],(function(e,t,r,n,i,o,a,u){"use strict";function s(e,t,n,i){this.west=r(e,0),this.south=r(t,0),this.east=r(n,0),this.north=r(i,0)}i(s.prototype,{width:{get:function(){return s.computeWidth(this)}},height:{get:function(){return s.computeHeight(this)}}}),s.packedLength=4,s.pack=function(e,n,i){return t.typeOf.object("value",e),t.defined("array",n),i=r(i,0),n[i++]=e.west,n[i++]=e.south,n[i++]=e.east,n[i]=e.north,n},s.unpack=function(e,i,o){return t.defined("array",e),i=r(i,0),n(o)||(o=new s),o.west=e[i++],o.south=e[i++],o.east=e[i++],o.north=e[i],o},s.computeWidth=function(e){t.typeOf.object("rectangle",e);var r=e.east,n=e.west;return r<n&&(r+=u.TWO_PI),r-n},s.computeHeight=function(e){return t.typeOf.object("rectangle",e),e.north-e.south},s.fromDegrees=function(e,t,i,o,a){return e=u.toRadians(r(e,0)),t=u.toRadians(r(t,0)),i=u.toRadians(r(i,0)),o=u.toRadians(r(o,0)),n(a)?(a.west=e,a.south=t,a.east=i,a.north=o,a):new s(e,t,i,o)},s.fromRadians=function(e,t,i,o,a){return n(a)?(a.west=r(e,0),a.south=r(t,0),a.east=r(i,0),a.north=r(o,0),a):new s(e,t,i,o)},s.fromCartographicArray=function(e,r){t.defined("cartographics",e);for(var i=Number.MAX_VALUE,o=-Number.MAX_VALUE,a=Number.MAX_VALUE,c=-Number.MAX_VALUE,l=Number.MAX_VALUE,f=-Number.MAX_VALUE,p=0,h=e.length;p<h;p++){var d=e[p];i=Math.min(i,d.longitude),o=Math.max(o,d.longitude),l=Math.min(l,d.latitude),f=Math.max(f,d.latitude);var y=d.longitude>=0?d.longitude:d.longitude+u.TWO_PI;a=Math.min(a,y),c=Math.max(c,y)}return o-i>c-a&&(i=a,(o=c)>u.PI&&(o-=u.TWO_PI),i>u.PI&&(i-=u.TWO_PI)),n(r)?(r.west=i,r.south=l,r.east=o,r.north=f,r):new s(i,l,o,f)},s.fromCartesianArray=function(e,i,a){t.defined("cartesians",e),i=r(i,o.WGS84);for(var c=Number.MAX_VALUE,l=-Number.MAX_VALUE,f=Number.MAX_VALUE,p=-Number.MAX_VALUE,h=Number.MAX_VALUE,d=-Number.MAX_VALUE,y=0,m=e.length;y<m;y++){var E=i.cartesianToCartographic(e[y]);c=Math.min(c,E.longitude),l=Math.max(l,E.longitude),h=Math.min(h,E.latitude),d=Math.max(d,E.latitude);var O=E.longitude>=0?E.longitude:E.longitude+u.TWO_PI;f=Math.min(f,O),p=Math.max(p,O)}return l-c>p-f&&(c=f,(l=p)>u.PI&&(l-=u.TWO_PI),c>u.PI&&(c-=u.TWO_PI)),n(a)?(a.west=c,a.south=h,a.east=l,a.north=d,a):new s(c,h,l,d)},s.clone=function(e,t){if(n(e))return n(t)?(t.west=e.west,t.south=e.south,t.east=e.east,t.north=e.north,t):new s(e.west,e.south,e.east,e.north)},s.equalsEpsilon=function(e,r,i){return t.typeOf.number("absoluteEpsilon",i),e===r||n(e)&&n(r)&&Math.abs(e.west-r.west)<=i&&Math.abs(e.south-r.south)<=i&&Math.abs(e.east-r.east)<=i&&Math.abs(e.north-r.north)<=i},s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s.equals=function(e,t){return e===t||n(e)&&n(t)&&e.west===t.west&&e.south===t.south&&e.east===t.east&&e.north===t.north},s.prototype.equalsEpsilon=function(e,r){return t.typeOf.number("epsilon",r),s.equalsEpsilon(this,e,r)},s.validate=function(e){t.typeOf.object("rectangle",e);var r=e.north;t.typeOf.number.greaterThanOrEquals("north",r,-u.PI_OVER_TWO),t.typeOf.number.lessThanOrEquals("north",r,u.PI_OVER_TWO);var n=e.south;t.typeOf.number.greaterThanOrEquals("south",n,-u.PI_OVER_TWO),t.typeOf.number.lessThanOrEquals("south",n,u.PI_OVER_TWO);var i=e.west;t.typeOf.number.greaterThanOrEquals("west",i,-Math.PI),t.typeOf.number.lessThanOrEquals("west",i,Math.PI);var o=e.east;t.typeOf.number.greaterThanOrEquals("east",o,-Math.PI),t.typeOf.number.lessThanOrEquals("east",o,Math.PI)},s.southwest=function(r,i){return t.typeOf.object("rectangle",r),n(i)?(i.longitude=r.west,i.latitude=r.south,i.height=0,i):new e(r.west,r.south)},s.northwest=function(r,i){return t.typeOf.object("rectangle",r),n(i)?(i.longitude=r.west,i.latitude=r.north,i.height=0,i):new e(r.west,r.north)},s.northeast=function(r,i){return t.typeOf.object("rectangle",r),n(i)?(i.longitude=r.east,i.latitude=r.north,i.height=0,i):new e(r.east,r.north)},s.southeast=function(r,i){return t.typeOf.object("rectangle",r),n(i)?(i.longitude=r.east,i.latitude=r.south,i.height=0,i):new e(r.east,r.south)},s.center=function(r,i){t.typeOf.object("rectangle",r);var o=r.east,a=r.west;o<a&&(o+=u.TWO_PI);var s=u.negativePiToPi(.5*(a+o)),c=.5*(r.south+r.north);return n(i)?(i.longitude=s,i.latitude=c,i.height=0,i):new e(s,c)},s.intersection=function(e,r,i){t.typeOf.object("rectangle",e),t.typeOf.object("otherRectangle",r);var o=e.east,a=e.west,c=r.east,l=r.west;o<a&&c>0?o+=u.TWO_PI:c<l&&o>0&&(c+=u.TWO_PI),o<a&&l<0?l+=u.TWO_PI:c<l&&a<0&&(a+=u.TWO_PI);var f=u.negativePiToPi(Math.max(a,l)),p=u.negativePiToPi(Math.min(o,c));if(!((e.west<e.east||r.west<r.east)&&p<=f)){var h=Math.max(e.south,r.south),d=Math.min(e.north,r.north);if(!(h>=d))return n(i)?(i.west=f,i.south=h,i.east=p,i.north=d,i):new s(f,h,p,d)}},s.simpleIntersection=function(e,r,i){t.typeOf.object("rectangle",e),t.typeOf.object("otherRectangle",r);var o=Math.max(e.west,r.west),a=Math.max(e.south,r.south),u=Math.min(e.east,r.east),c=Math.min(e.north,r.north);if(!(a>=c||o>=u))return n(i)?(i.west=o,i.south=a,i.east=u,i.north=c,i):new s(o,a,u,c)},s.union=function(e,r,i){t.typeOf.object("rectangle",e),t.typeOf.object("otherRectangle",r),n(i)||(i=new s);var o=e.east,a=e.west,c=r.east,l=r.west;o<a&&c>0?o+=u.TWO_PI:c<l&&o>0&&(c+=u.TWO_PI),o<a&&l<0?l+=u.TWO_PI:c<l&&a<0&&(a+=u.TWO_PI);var f=u.convertLongitudeRange(Math.min(a,l)),p=u.convertLongitudeRange(Math.max(o,c));return i.west=f,i.south=Math.min(e.south,r.south),i.east=p,i.north=Math.max(e.north,r.north),i},s.expand=function(e,r,i){return t.typeOf.object("rectangle",e),t.typeOf.object("cartographic",r),n(i)||(i=new s),i.west=Math.min(e.west,r.longitude),i.south=Math.min(e.south,r.latitude),i.east=Math.max(e.east,r.longitude),i.north=Math.max(e.north,r.latitude),i},s.contains=function(e,r){t.typeOf.object("rectangle",e),t.typeOf.object("cartographic",r);var n=r.longitude,i=r.latitude,o=e.west,a=e.east;return a<o&&(a+=u.TWO_PI,n<0&&(n+=u.TWO_PI)),(n>o||u.equalsEpsilon(n,o,u.EPSILON14))&&(n<a||u.equalsEpsilon(n,a,u.EPSILON14))&&i>=e.south&&i<=e.north};var c=new e;return s.subsample=function(e,i,a,l){t.typeOf.object("rectangle",e),i=r(i,o.WGS84),a=r(a,0),n(l)||(l=[]);var f=0,p=e.north,h=e.south,d=e.east,y=e.west,m=c;m.height=a,m.longitude=y,m.latitude=p,l[f]=i.cartographicToCartesian(m,l[f]),f++,m.longitude=d,l[f]=i.cartographicToCartesian(m,l[f]),f++,m.latitude=h,l[f]=i.cartographicToCartesian(m,l[f]),f++,m.longitude=y,l[f]=i.cartographicToCartesian(m,l[f]),f++,m.latitude=p<0?p:h>0?h:0;for(var E=1;E<8;++E)m.longitude=-Math.PI+E*u.PI_OVER_TWO,s.contains(e,m)&&(l[f]=i.cartographicToCartesian(m,l[f]),f++);return 0===m.latitude&&(m.longitude=y,l[f]=i.cartographicToCartesian(m,l[f]),f++,m.longitude=d,l[f]=i.cartographicToCartesian(m,l[f]),f++),l.length=f,l},s.MAX_VALUE=a(new s(-Math.PI,-u.PI_OVER_TWO,Math.PI,u.PI_OVER_TWO)),s})),define("Core/BoundingRectangle",["./Cartesian2","./Cartographic","./Check","./defaultValue","./defined","./GeographicProjection","./Intersect","./Rectangle"],(function(e,t,r,n,i,o,a,u){"use strict";function s(e,t,r,i){this.x=n(e,0),this.y=n(t,0),this.width=n(r,0),this.height=n(i,0)}s.packedLength=4,s.pack=function(e,t,i){return r.typeOf.object("value",e),r.defined("array",t),i=n(i,0),t[i++]=e.x,t[i++]=e.y,t[i++]=e.width,t[i]=e.height,t},s.unpack=function(e,t,o){return r.defined("array",e),t=n(t,0),i(o)||(o=new s),o.x=e[t++],o.y=e[t++],o.width=e[t++],o.height=e[t],o},s.fromPoints=function(e,t){if(i(t)||(t=new s),!i(e)||0===e.length)return t.x=0,t.y=0,t.width=0,t.height=0,t;for(var r=e.length,n=e[0].x,o=e[0].y,a=e[0].x,u=e[0].y,c=1;c<r;c++){var l=e[c],f=l.x,p=l.y;n=Math.min(f,n),a=Math.max(f,a),o=Math.min(p,o),u=Math.max(p,u)}return t.x=n,t.y=o,t.width=a-n,t.height=u-o,t};var c=new o,l=new t,f=new t;return s.fromRectangle=function(t,r,o){if(i(o)||(o=new s),!i(t))return o.x=0,o.y=0,o.width=0,o.height=0,o;var a=(r=n(r,c)).project(u.southwest(t,l)),p=r.project(u.northeast(t,f));return e.subtract(p,a,p),o.x=a.x,o.y=a.y,o.width=p.x,o.height=p.y,o},s.clone=function(e,t){if(i(e))return i(t)?(t.x=e.x,t.y=e.y,t.width=e.width,t.height=e.height,t):new s(e.x,e.y,e.width,e.height)},s.union=function(e,t,n){r.typeOf.object("left",e),r.typeOf.object("right",t),i(n)||(n=new s);var o=Math.min(e.x,t.x),a=Math.min(e.y,t.y),u=Math.max(e.x+e.width,t.x+t.width),c=Math.max(e.y+e.height,t.y+t.height);return n.x=o,n.y=a,n.width=u-o,n.height=c-a,n},s.expand=function(e,t,n){r.typeOf.object("rectangle",e),r.typeOf.object("point",t),n=s.clone(e,n);var i=t.x-n.x,o=t.y-n.y;return i>n.width?n.width=i:i<0&&(n.width-=i,n.x=t.x),o>n.height?n.height=o:o<0&&(n.height-=o,n.y=t.y),n},s.intersect=function(e,t){r.typeOf.object("left",e),r.typeOf.object("right",t);var n=e.x,i=e.y,o=t.x,u=t.y;return n>o+t.width||n+e.width<o||i+e.height<u||i>u+t.height?a.OUTSIDE:a.INTERSECTING},s.equals=function(e,t){return e===t||i(e)&&i(t)&&e.x===t.x&&e.y===t.y&&e.width===t.width&&e.height===t.height},s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.intersect=function(e){return s.intersect(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s})),define("Core/Interval",["./defaultValue"],(function(e){"use strict";return function(t,r){this.start=e(t,0),this.stop=e(r,0)}})),define("Core/Matrix3",["./Cartesian3","./Check","./defaultValue","./defined","./defineProperties","./DeveloperError","./freezeObject","./Math"],(function(e,t,r,n,i,o,a,u){"use strict";function s(e,t,n,i,o,a,u,s,c){this[0]=r(e,0),this[1]=r(i,0),this[2]=r(u,0),this[3]=r(t,0),this[4]=r(o,0),this[5]=r(s,0),this[6]=r(n,0),this[7]=r(a,0),this[8]=r(c,0)}s.packedLength=9,s.pack=function(e,n,i){return t.typeOf.object("value",e),t.defined("array",n),i=r(i,0),n[i++]=e[0],n[i++]=e[1],n[i++]=e[2],n[i++]=e[3],n[i++]=e[4],n[i++]=e[5],n[i++]=e[6],n[i++]=e[7],n[i++]=e[8],n},s.unpack=function(e,i,o){return t.defined("array",e),i=r(i,0),n(o)||(o=new s),o[0]=e[i++],o[1]=e[i++],o[2]=e[i++],o[3]=e[i++],o[4]=e[i++],o[5]=e[i++],o[6]=e[i++],o[7]=e[i++],o[8]=e[i++],o},s.clone=function(e,t){if(n(e))return n(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t):new s(e[0],e[3],e[6],e[1],e[4],e[7],e[2],e[5],e[8])},s.fromArray=function(e,i,o){return t.defined("array",e),i=r(i,0),n(o)||(o=new s),o[0]=e[i],o[1]=e[i+1],o[2]=e[i+2],o[3]=e[i+3],o[4]=e[i+4],o[5]=e[i+5],o[6]=e[i+6],o[7]=e[i+7],o[8]=e[i+8],o},s.fromColumnMajorArray=function(e,r){return t.defined("values",e),s.clone(e,r)},s.fromRowMajorArray=function(e,r){return t.defined("values",e),n(r)?(r[0]=e[0],r[1]=e[3],r[2]=e[6],r[3]=e[1],r[4]=e[4],r[5]=e[7],r[6]=e[2],r[7]=e[5],r[8]=e[8],r):new s(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8])},s.fromQuaternion=function(e,r){t.typeOf.object("quaternion",e);var i=e.x*e.x,o=e.x*e.y,a=e.x*e.z,u=e.x*e.w,c=e.y*e.y,l=e.y*e.z,f=e.y*e.w,p=e.z*e.z,h=e.z*e.w,d=e.w*e.w,y=i-c-p+d,m=2*(o-h),E=2*(a+f),O=2*(o+h),v=-i+c-p+d,w=2*(l-u),_=2*(a-f),g=2*(l+u),T=-i-c+p+d;return n(r)?(r[0]=y,r[1]=O,r[2]=_,r[3]=m,r[4]=v,r[5]=g,r[6]=E,r[7]=w,r[8]=T,r):new s(y,m,E,O,v,w,_,g,T)},s.fromHeadingPitchRoll=function(e,r){t.typeOf.object("headingPitchRoll",e);var i=Math.cos(-e.pitch),o=Math.cos(-e.heading),a=Math.cos(e.roll),u=Math.sin(-e.pitch),c=Math.sin(-e.heading),l=Math.sin(e.roll),f=i*o,p=-a*c+l*u*o,h=l*c+a*u*o,d=i*c,y=a*o+l*u*c,m=-l*o+a*u*c,E=-u,O=l*i,v=a*i;return n(r)?(r[0]=f,r[1]=d,r[2]=E,r[3]=p,r[4]=y,r[5]=O,r[6]=h,r[7]=m,r[8]=v,r):new s(f,p,h,d,y,m,E,O,v)},s.fromScale=function(e,r){return t.typeOf.object("scale",e),n(r)?(r[0]=e.x,r[1]=0,r[2]=0,r[3]=0,r[4]=e.y,r[5]=0,r[6]=0,r[7]=0,r[8]=e.z,r):new s(e.x,0,0,0,e.y,0,0,0,e.z)},s.fromUniformScale=function(e,r){return t.typeOf.number("scale",e),n(r)?(r[0]=e,r[1]=0,r[2]=0,r[3]=0,r[4]=e,r[5]=0,r[6]=0,r[7]=0,r[8]=e,r):new s(e,0,0,0,e,0,0,0,e)},s.fromCrossProduct=function(e,r){return t.typeOf.object("vector",e),n(r)?(r[0]=0,r[1]=e.z,r[2]=-e.y,r[3]=-e.z,r[4]=0,r[5]=e.x,r[6]=e.y,r[7]=-e.x,r[8]=0,r):new s(0,-e.z,e.y,e.z,0,-e.x,-e.y,e.x,0)},s.fromRotationX=function(e,r){t.typeOf.number("angle",e);var i=Math.cos(e),o=Math.sin(e);return n(r)?(r[0]=1,r[1]=0,r[2]=0,r[3]=0,r[4]=i,r[5]=o,r[6]=0,r[7]=-o,r[8]=i,r):new s(1,0,0,0,i,-o,0,o,i)},s.fromRotationY=function(e,r){t.typeOf.number("angle",e);var i=Math.cos(e),o=Math.sin(e);return n(r)?(r[0]=i,r[1]=0,r[2]=-o,r[3]=0,r[4]=1,r[5]=0,r[6]=o,r[7]=0,r[8]=i,r):new s(i,0,o,0,1,0,-o,0,i)},s.fromRotationZ=function(e,r){t.typeOf.number("angle",e);var i=Math.cos(e),o=Math.sin(e);return n(r)?(r[0]=i,r[1]=o,r[2]=0,r[3]=-o,r[4]=i,r[5]=0,r[6]=0,r[7]=0,r[8]=1,r):new s(i,-o,0,o,i,0,0,0,1)},s.toArray=function(e,r){return t.typeOf.object("matrix",e),n(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8]]},s.getElementIndex=function(e,r){return t.typeOf.number.greaterThanOrEquals("row",r,0),t.typeOf.number.lessThanOrEquals("row",r,2),t.typeOf.number.greaterThanOrEquals("column",e,0),t.typeOf.number.lessThanOrEquals("column",e,2),3*e+r},s.getColumn=function(e,r,n){t.typeOf.object("matrix",e),t.typeOf.number.greaterThanOrEquals("index",r,0),t.typeOf.number.lessThanOrEquals("index",r,2),t.typeOf.object("result",n);var i=3*r,o=e[i],a=e[i+1],u=e[i+2];return n.x=o,n.y=a,n.z=u,n},s.setColumn=function(e,r,n,i){t.typeOf.object("matrix",e),t.typeOf.number.greaterThanOrEquals("index",r,0),t.typeOf.number.lessThanOrEquals("index",r,2),t.typeOf.object("cartesian",n),t.typeOf.object("result",i);var o=3*r;return(i=s.clone(e,i))[o]=n.x,i[o+1]=n.y,i[o+2]=n.z,i},s.getRow=function(e,r,n){t.typeOf.object("matrix",e),t.typeOf.number.greaterThanOrEquals("index",r,0),t.typeOf.number.lessThanOrEquals("index",r,2),t.typeOf.object("result",n);var i=e[r],o=e[r+3],a=e[r+6];return n.x=i,n.y=o,n.z=a,n},s.setRow=function(e,r,n,i){return t.typeOf.object("matrix",e),t.typeOf.number.greaterThanOrEquals("index",r,0),t.typeOf.number.lessThanOrEquals("index",r,2),t.typeOf.object("cartesian",n),t.typeOf.object("result",i),(i=s.clone(e,i))[r]=n.x,i[r+3]=n.y,i[r+6]=n.z,i};var c=new e;s.getScale=function(r,n){return t.typeOf.object("matrix",r),t.typeOf.object("result",n),n.x=e.magnitude(e.fromElements(r[0],r[1],r[2],c)),n.y=e.magnitude(e.fromElements(r[3],r[4],r[5],c)),n.z=e.magnitude(e.fromElements(r[6],r[7],r[8],c)),n};var l=new e;s.getMaximumScale=function(t){return s.getScale(t,l),e.maximumComponent(l)},s.multiply=function(e,r,n){t.typeOf.object("left",e),t.typeOf.object("right",r),t.typeOf.object("result",n);var i=e[0]*r[0]+e[3]*r[1]+e[6]*r[2],o=e[1]*r[0]+e[4]*r[1]+e[7]*r[2],a=e[2]*r[0]+e[5]*r[1]+e[8]*r[2],u=e[0]*r[3]+e[3]*r[4]+e[6]*r[5],s=e[1]*r[3]+e[4]*r[4]+e[7]*r[5],c=e[2]*r[3]+e[5]*r[4]+e[8]*r[5],l=e[0]*r[6]+e[3]*r[7]+e[6]*r[8],f=e[1]*r[6]+e[4]*r[7]+e[7]*r[8],p=e[2]*r[6]+e[5]*r[7]+e[8]*r[8];return n[0]=i,n[1]=o,n[2]=a,n[3]=u,n[4]=s,n[5]=c,n[6]=l,n[7]=f,n[8]=p,n},s.add=function(e,r,n){return t.typeOf.object("left",e),t.typeOf.object("right",r),t.typeOf.object("result",n),n[0]=e[0]+r[0],n[1]=e[1]+r[1],n[2]=e[2]+r[2],n[3]=e[3]+r[3],n[4]=e[4]+r[4],n[5]=e[5]+r[5],n[6]=e[6]+r[6],n[7]=e[7]+r[7],n[8]=e[8]+r[8],n},s.subtract=function(e,r,n){return t.typeOf.object("left",e),t.typeOf.object("right",r),t.typeOf.object("result",n),n[0]=e[0]-r[0],n[1]=e[1]-r[1],n[2]=e[2]-r[2],n[3]=e[3]-r[3],n[4]=e[4]-r[4],n[5]=e[5]-r[5],n[6]=e[6]-r[6],n[7]=e[7]-r[7],n[8]=e[8]-r[8],n},s.multiplyByVector=function(e,r,n){t.typeOf.object("matrix",e),t.typeOf.object("cartesian",r),t.typeOf.object("result",n);var i=r.x,o=r.y,a=r.z,u=e[0]*i+e[3]*o+e[6]*a,s=e[1]*i+e[4]*o+e[7]*a,c=e[2]*i+e[5]*o+e[8]*a;return n.x=u,n.y=s,n.z=c,n},s.multiplyByScalar=function(e,r,n){return t.typeOf.object("matrix",e),t.typeOf.number("scalar",r),t.typeOf.object("result",n),n[0]=e[0]*r,n[1]=e[1]*r,n[2]=e[2]*r,n[3]=e[3]*r,n[4]=e[4]*r,n[5]=e[5]*r,n[6]=e[6]*r,n[7]=e[7]*r,n[8]=e[8]*r,n},s.multiplyByScale=function(e,r,n){return t.typeOf.object("matrix",e),t.typeOf.object("scale",r),t.typeOf.object("result",n),n[0]=e[0]*r.x,n[1]=e[1]*r.x,n[2]=e[2]*r.x,n[3]=e[3]*r.y,n[4]=e[4]*r.y,n[5]=e[5]*r.y,n[6]=e[6]*r.z,n[7]=e[7]*r.z,n[8]=e[8]*r.z,n},s.negate=function(e,r){return t.typeOf.object("matrix",e),t.typeOf.object("result",r),r[0]=-e[0],r[1]=-e[1],r[2]=-e[2],r[3]=-e[3],r[4]=-e[4],r[5]=-e[5],r[6]=-e[6],r[7]=-e[7],r[8]=-e[8],r},s.transpose=function(e,r){t.typeOf.object("matrix",e),t.typeOf.object("result",r);var n=e[0],i=e[3],o=e[6],a=e[1],u=e[4],s=e[7],c=e[2],l=e[5],f=e[8];return r[0]=n,r[1]=i,r[2]=o,r[3]=a,r[4]=u,r[5]=s,r[6]=c,r[7]=l,r[8]=f,r};var f=[1,0,0],p=[2,2,1];function h(e){for(var t=0,r=0;r<3;++r){var n=e[s.getElementIndex(p[r],f[r])];t+=2*n*n}return Math.sqrt(t)}function d(e,t){for(var r=u.EPSILON15,n=0,i=1,o=0;o<3;++o){var a=Math.abs(e[s.getElementIndex(p[o],f[o])]);a>n&&(i=o,n=a)}var c=1,l=0,h=f[i],d=p[i];if(Math.abs(e[s.getElementIndex(d,h)])>r){var y,m=(e[s.getElementIndex(d,d)]-e[s.getElementIndex(h,h)])/2/e[s.getElementIndex(d,h)];l=(y=m<0?-1/(-m+Math.sqrt(1+m*m)):1/(m+Math.sqrt(1+m*m)))*(c=1/Math.sqrt(1+y*y))}return(t=s.clone(s.IDENTITY,t))[s.getElementIndex(h,h)]=t[s.getElementIndex(d,d)]=c,t[s.getElementIndex(d,h)]=l,t[s.getElementIndex(h,d)]=-l,t}var y=new s,m=new s;return s.computeEigenDecomposition=function(e,r){t.typeOf.object("matrix",e);var i=u.EPSILON20,o=0,a=0;n(r)||(r={});for(var c=r.unitary=s.clone(s.IDENTITY,r.unitary),l=r.diagonal=s.clone(e,r.diagonal),f=i*function(e){for(var t=0,r=0;r<9;++r){var n=e[r];t+=n*n}return Math.sqrt(t)}(l);a<10&&h(l)>f;)d(l,y),s.transpose(y,m),s.multiply(l,y,l),s.multiply(m,l,l),s.multiply(c,y,c),++o>2&&(++a,o=0);return r},s.abs=function(e,r){return t.typeOf.object("matrix",e),t.typeOf.object("result",r),r[0]=Math.abs(e[0]),r[1]=Math.abs(e[1]),r[2]=Math.abs(e[2]),r[3]=Math.abs(e[3]),r[4]=Math.abs(e[4]),r[5]=Math.abs(e[5]),r[6]=Math.abs(e[6]),r[7]=Math.abs(e[7]),r[8]=Math.abs(e[8]),r},s.determinant=function(e){t.typeOf.object("matrix",e);var r=e[0],n=e[3],i=e[6],o=e[1],a=e[4],u=e[7],s=e[2],c=e[5],l=e[8];return r*(a*l-c*u)+o*(c*i-n*l)+s*(n*u-a*i)},s.inverse=function(e,r){t.typeOf.object("matrix",e),t.typeOf.object("result",r);var n=e[0],i=e[1],a=e[2],c=e[3],l=e[4],f=e[5],p=e[6],h=e[7],d=e[8],y=s.determinant(e);if(Math.abs(y)<=u.EPSILON15)throw new o("matrix is not invertible");r[0]=l*d-h*f,r[1]=h*a-i*d,r[2]=i*f-l*a,r[3]=p*f-c*d,r[4]=n*d-p*a,r[5]=c*a-n*f,r[6]=c*h-p*l,r[7]=p*i-n*h,r[8]=n*l-c*i;var m=1/y;return s.multiplyByScalar(r,m,r)},s.equals=function(e,t){return e===t||n(e)&&n(t)&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[3]===t[3]&&e[4]===t[4]&&e[5]===t[5]&&e[6]===t[6]&&e[7]===t[7]&&e[8]===t[8]},s.equalsEpsilon=function(e,r,i){return t.typeOf.number("epsilon",i),e===r||n(e)&&n(r)&&Math.abs(e[0]-r[0])<=i&&Math.abs(e[1]-r[1])<=i&&Math.abs(e[2]-r[2])<=i&&Math.abs(e[3]-r[3])<=i&&Math.abs(e[4]-r[4])<=i&&Math.abs(e[5]-r[5])<=i&&Math.abs(e[6]-r[6])<=i&&Math.abs(e[7]-r[7])<=i&&Math.abs(e[8]-r[8])<=i},s.IDENTITY=a(new s(1,0,0,0,1,0,0,0,1)),s.ZERO=a(new s(0,0,0,0,0,0,0,0,0)),s.COLUMN0ROW0=0,s.COLUMN0ROW1=1,s.COLUMN0ROW2=2,s.COLUMN1ROW0=3,s.COLUMN1ROW1=4,s.COLUMN1ROW2=5,s.COLUMN2ROW0=6,s.COLUMN2ROW1=7,s.COLUMN2ROW2=8,i(s.prototype,{length:{get:function(){return s.packedLength}}}),s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s.equalsArray=function(e,t,r){return e[0]===t[r]&&e[1]===t[r+1]&&e[2]===t[r+2]&&e[3]===t[r+3]&&e[4]===t[r+4]&&e[5]===t[r+5]&&e[6]===t[r+6]&&e[7]===t[r+7]&&e[8]===t[r+8]},s.prototype.equalsEpsilon=function(e,t){return s.equalsEpsilon(this,e,t)},s.prototype.toString=function(){return"("+this[0]+", "+this[3]+", "+this[6]+")\n("+this[1]+", "+this[4]+", "+this[7]+")\n("+this[2]+", "+this[5]+", "+this[8]+")"},s})),define("Core/Cartesian4",["./Check","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],(function(e,t,r,n,i,o){"use strict";function a(e,r,n,i){this.x=t(e,0),this.y=t(r,0),this.z=t(n,0),this.w=t(i,0)}a.fromElements=function(e,t,n,i,o){return r(o)?(o.x=e,o.y=t,o.z=n,o.w=i,o):new a(e,t,n,i)},a.fromColor=function(t,n){return e.typeOf.object("color",t),r(n)?(n.x=t.red,n.y=t.green,n.z=t.blue,n.w=t.alpha,n):new a(t.red,t.green,t.blue,t.alpha)},a.clone=function(e,t){if(r(e))return r(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t.w=e.w,t):new a(e.x,e.y,e.z,e.w)},a.packedLength=4,a.pack=function(r,n,i){return e.typeOf.object("value",r),e.defined("array",n),i=t(i,0),n[i++]=r.x,n[i++]=r.y,n[i++]=r.z,n[i]=r.w,n},a.unpack=function(n,i,o){return e.defined("array",n),i=t(i,0),r(o)||(o=new a),o.x=n[i++],o.y=n[i++],o.z=n[i++],o.w=n[i],o},a.packArray=function(t,n){e.defined("array",t);var i=t.length;r(n)?n.length=4*i:n=new Array(4*i);for(var o=0;o<i;++o)a.pack(t[o],n,4*o);return n},a.unpackArray=function(t,n){e.defined("array",t);var i=t.length;r(n)?n.length=i/4:n=new Array(i/4);for(var o=0;o<i;o+=4){var u=o/4;n[u]=a.unpack(t,o,n[u])}return n},a.fromArray=a.unpack,a.maximumComponent=function(t){return e.typeOf.object("cartesian",t),Math.max(t.x,t.y,t.z,t.w)},a.minimumComponent=function(t){return e.typeOf.object("cartesian",t),Math.min(t.x,t.y,t.z,t.w)},a.minimumByComponent=function(t,r,n){return e.typeOf.object("first",t),e.typeOf.object("second",r),e.typeOf.object("result",n),n.x=Math.min(t.x,r.x),n.y=Math.min(t.y,r.y),n.z=Math.min(t.z,r.z),n.w=Math.min(t.w,r.w),n},a.maximumByComponent=function(t,r,n){return e.typeOf.object("first",t),e.typeOf.object("second",r),e.typeOf.object("result",n),n.x=Math.max(t.x,r.x),n.y=Math.max(t.y,r.y),n.z=Math.max(t.z,r.z),n.w=Math.max(t.w,r.w),n},a.magnitudeSquared=function(t){return e.typeOf.object("cartesian",t),t.x*t.x+t.y*t.y+t.z*t.z+t.w*t.w},a.magnitude=function(e){return Math.sqrt(a.magnitudeSquared(e))};var u=new a;a.distance=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),a.subtract(t,r,u),a.magnitude(u)},a.distanceSquared=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),a.subtract(t,r,u),a.magnitudeSquared(u)},a.normalize=function(t,r){e.typeOf.object("cartesian",t),e.typeOf.object("result",r);var i=a.magnitude(t);if(r.x=t.x/i,r.y=t.y/i,r.z=t.z/i,r.w=t.w/i,isNaN(r.x)||isNaN(r.y)||isNaN(r.z)||isNaN(r.w))throw new n("normalized result is not a number");return r},a.dot=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),t.x*r.x+t.y*r.y+t.z*r.z+t.w*r.w},a.multiplyComponents=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x*r.x,n.y=t.y*r.y,n.z=t.z*r.z,n.w=t.w*r.w,n},a.divideComponents=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x/r.x,n.y=t.y/r.y,n.z=t.z/r.z,n.w=t.w/r.w,n},a.add=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x+r.x,n.y=t.y+r.y,n.z=t.z+r.z,n.w=t.w+r.w,n},a.subtract=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x-r.x,n.y=t.y-r.y,n.z=t.z-r.z,n.w=t.w-r.w,n},a.multiplyByScalar=function(t,r,n){return e.typeOf.object("cartesian",t),e.typeOf.number("scalar",r),e.typeOf.object("result",n),n.x=t.x*r,n.y=t.y*r,n.z=t.z*r,n.w=t.w*r,n},a.divideByScalar=function(t,r,n){return e.typeOf.object("cartesian",t),e.typeOf.number("scalar",r),e.typeOf.object("result",n),n.x=t.x/r,n.y=t.y/r,n.z=t.z/r,n.w=t.w/r,n},a.negate=function(t,r){return e.typeOf.object("cartesian",t),e.typeOf.object("result",r),r.x=-t.x,r.y=-t.y,r.z=-t.z,r.w=-t.w,r},a.abs=function(t,r){return e.typeOf.object("cartesian",t),e.typeOf.object("result",r),r.x=Math.abs(t.x),r.y=Math.abs(t.y),r.z=Math.abs(t.z),r.w=Math.abs(t.w),r};var s=new a;a.lerp=function(t,r,n,i){return e.typeOf.object("start",t),e.typeOf.object("end",r),e.typeOf.number("t",n),e.typeOf.object("result",i),a.multiplyByScalar(r,n,s),i=a.multiplyByScalar(t,1-n,i),a.add(s,i,i)};var c=new a;a.mostOrthogonalAxis=function(t,r){e.typeOf.object("cartesian",t),e.typeOf.object("result",r);var n=a.normalize(t,c);return a.abs(n,n),r=n.x<=n.y?n.x<=n.z?n.x<=n.w?a.clone(a.UNIT_X,r):a.clone(a.UNIT_W,r):n.z<=n.w?a.clone(a.UNIT_Z,r):a.clone(a.UNIT_W,r):n.y<=n.z?n.y<=n.w?a.clone(a.UNIT_Y,r):a.clone(a.UNIT_W,r):n.z<=n.w?a.clone(a.UNIT_Z,r):a.clone(a.UNIT_W,r)},a.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z&&e.w===t.w},a.equalsArray=function(e,t,r){return e.x===t[r]&&e.y===t[r+1]&&e.z===t[r+2]&&e.w===t[r+3]},a.equalsEpsilon=function(e,t,n,i){return e===t||r(e)&&r(t)&&o.equalsEpsilon(e.x,t.x,n,i)&&o.equalsEpsilon(e.y,t.y,n,i)&&o.equalsEpsilon(e.z,t.z,n,i)&&o.equalsEpsilon(e.w,t.w,n,i)},a.ZERO=i(new a(0,0,0,0)),a.UNIT_X=i(new a(1,0,0,0)),a.UNIT_Y=i(new a(0,1,0,0)),a.UNIT_Z=i(new a(0,0,1,0)),a.UNIT_W=i(new a(0,0,0,1)),a.prototype.clone=function(e){return a.clone(this,e)},a.prototype.equals=function(e){return a.equals(this,e)},a.prototype.equalsEpsilon=function(e,t,r){return a.equalsEpsilon(this,e,t,r)},a.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"};var l=new Float32Array(1);return a.packFloat=function(t,n){if(e.typeOf.number("value",t),r(n)||(n=new a),l[0]=t,0===(t=l[0]))return a.clone(a.ZERO,n);var i,u=t<0?1:0;isFinite(t)?(t=Math.abs(t),i=Math.floor(o.logBase(t,10))+1,t/=Math.pow(10,i)):(t=.1,i=38);var s=256*t;return n.x=Math.floor(s),s=256*(s-n.x),n.y=Math.floor(s),s=256*(s-n.y),n.z=Math.floor(s),n.w=2*(i+38)+u,n},a.unpackFloat=function(t){e.typeOf.object("packedFloat",t);var r=t.w/2,n=Math.floor(r),i=2*(r-n);if(i=-(i=2*i-1),(n-=38)>=38)return i<0?Number.NEGATIVE_INFINITY:Number.POSITIVE_INFINITY;var o=i*t.x*(1/256);return o+=i*t.y*(1/65536),(o+=i*t.z*(1/16777216))*Math.pow(10,n)},a})),define("Core/RuntimeError",["./defined"],(function(e){"use strict";function t(e){var t;this.name="RuntimeError",this.message=e;try{throw new Error}catch(e){t=e.stack}this.stack=t}return e(Object.create)&&(t.prototype=Object.create(Error.prototype),t.prototype.constructor=t),t.prototype.toString=function(){var t=this.name+": "+this.message;return e(this.stack)&&(t+="\n"+this.stack.toString()),t},t})),define("Core/Matrix4",["./Cartesian3","./Cartesian4","./Check","./defaultValue","./defined","./defineProperties","./freezeObject","./Math","./Matrix3","./RuntimeError"],(function(e,t,r,n,i,o,a,u,s,c){"use strict";function l(e,t,r,i,o,a,u,s,c,l,f,p,h,d,y,m){this[0]=n(e,0),this[1]=n(o,0),this[2]=n(c,0),this[3]=n(h,0),this[4]=n(t,0),this[5]=n(a,0),this[6]=n(l,0),this[7]=n(d,0),this[8]=n(r,0),this[9]=n(u,0),this[10]=n(f,0),this[11]=n(y,0),this[12]=n(i,0),this[13]=n(s,0),this[14]=n(p,0),this[15]=n(m,0)}l.packedLength=16,l.pack=function(e,t,i){return r.typeOf.object("value",e),r.defined("array",t),i=n(i,0),t[i++]=e[0],t[i++]=e[1],t[i++]=e[2],t[i++]=e[3],t[i++]=e[4],t[i++]=e[5],t[i++]=e[6],t[i++]=e[7],t[i++]=e[8],t[i++]=e[9],t[i++]=e[10],t[i++]=e[11],t[i++]=e[12],t[i++]=e[13],t[i++]=e[14],t[i]=e[15],t},l.unpack=function(e,t,o){return r.defined("array",e),t=n(t,0),i(o)||(o=new l),o[0]=e[t++],o[1]=e[t++],o[2]=e[t++],o[3]=e[t++],o[4]=e[t++],o[5]=e[t++],o[6]=e[t++],o[7]=e[t++],o[8]=e[t++],o[9]=e[t++],o[10]=e[t++],o[11]=e[t++],o[12]=e[t++],o[13]=e[t++],o[14]=e[t++],o[15]=e[t],o},l.clone=function(e,t){if(i(e))return i(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t):new l(e[0],e[4],e[8],e[12],e[1],e[5],e[9],e[13],e[2],e[6],e[10],e[14],e[3],e[7],e[11],e[15])},l.fromArray=l.unpack,l.fromColumnMajorArray=function(e,t){return r.defined("values",e),l.clone(e,t)},l.fromRowMajorArray=function(e,t){return r.defined("values",e),i(t)?(t[0]=e[0],t[1]=e[4],t[2]=e[8],t[3]=e[12],t[4]=e[1],t[5]=e[5],t[6]=e[9],t[7]=e[13],t[8]=e[2],t[9]=e[6],t[10]=e[10],t[11]=e[14],t[12]=e[3],t[13]=e[7],t[14]=e[11],t[15]=e[15],t):new l(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15])},l.fromRotationTranslation=function(t,o,a){return r.typeOf.object("rotation",t),o=n(o,e.ZERO),i(a)?(a[0]=t[0],a[1]=t[1],a[2]=t[2],a[3]=0,a[4]=t[3],a[5]=t[4],a[6]=t[5],a[7]=0,a[8]=t[6],a[9]=t[7],a[10]=t[8],a[11]=0,a[12]=o.x,a[13]=o.y,a[14]=o.z,a[15]=1,a):new l(t[0],t[3],t[6],o.x,t[1],t[4],t[7],o.y,t[2],t[5],t[8],o.z,0,0,0,1)},l.fromTranslationQuaternionRotationScale=function(e,t,n,o){r.typeOf.object("translation",e),r.typeOf.object("rotation",t),r.typeOf.object("scale",n),i(o)||(o=new l);var a=n.x,u=n.y,s=n.z,c=t.x*t.x,f=t.x*t.y,p=t.x*t.z,h=t.x*t.w,d=t.y*t.y,y=t.y*t.z,m=t.y*t.w,E=t.z*t.z,O=t.z*t.w,v=t.w*t.w,w=c-d-E+v,_=2*(f-O),g=2*(p+m),T=2*(f+O),b=-c+d-E+v,R=2*(y-h),A=2*(p-m),x=2*(y+h),S=-c-d+E+v;return o[0]=w*a,o[1]=T*a,o[2]=A*a,o[3]=0,o[4]=_*u,o[5]=b*u,o[6]=x*u,o[7]=0,o[8]=g*s,o[9]=R*s,o[10]=S*s,o[11]=0,o[12]=e.x,o[13]=e.y,o[14]=e.z,o[15]=1,o},l.fromTranslationRotationScale=function(e,t){return r.typeOf.object("translationRotationScale",e),l.fromTranslationQuaternionRotationScale(e.translation,e.rotation,e.scale,t)},l.fromTranslation=function(e,t){return r.typeOf.object("translation",e),l.fromRotationTranslation(s.IDENTITY,e,t)},l.fromScale=function(e,t){return r.typeOf.object("scale",e),i(t)?(t[0]=e.x,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=e.y,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=e.z,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t):new l(e.x,0,0,0,0,e.y,0,0,0,0,e.z,0,0,0,0,1)},l.fromUniformScale=function(e,t){return r.typeOf.number("scale",e),i(t)?(t[0]=e,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=e,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=e,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t):new l(e,0,0,0,0,e,0,0,0,0,e,0,0,0,0,1)};var f=new e,p=new e,h=new e;l.fromCamera=function(t,n){r.typeOf.object("camera",t);var o=t.position,a=t.direction,u=t.up;r.typeOf.object("camera.position",o),r.typeOf.object("camera.direction",a),r.typeOf.object("camera.up",u),e.normalize(a,f),e.normalize(e.cross(f,u,p),p),e.normalize(e.cross(p,f,h),h);var s=p.x,c=p.y,d=p.z,y=f.x,m=f.y,E=f.z,O=h.x,v=h.y,w=h.z,_=o.x,g=o.y,T=o.z,b=s*-_+c*-g+d*-T,R=O*-_+v*-g+w*-T,A=y*_+m*g+E*T;return i(n)?(n[0]=s,n[1]=O,n[2]=-y,n[3]=0,n[4]=c,n[5]=v,n[6]=-m,n[7]=0,n[8]=d,n[9]=w,n[10]=-E,n[11]=0,n[12]=b,n[13]=R,n[14]=A,n[15]=1,n):new l(s,c,d,b,O,v,w,R,-y,-m,-E,A,0,0,0,1)},l.computePerspectiveFieldOfView=function(e,t,n,i,o){r.typeOf.number.greaterThan("fovY",e,0),r.typeOf.number.lessThan("fovY",e,Math.PI),r.typeOf.number.greaterThan("near",n,0),r.typeOf.number.greaterThan("far",i,0),r.typeOf.object("result",o);var a=1/Math.tan(.5*e),u=a/t,s=(i+n)/(n-i),c=2*i*n/(n-i);return o[0]=u,o[1]=0,o[2]=0,o[3]=0,o[4]=0,o[5]=a,o[6]=0,o[7]=0,o[8]=0,o[9]=0,o[10]=s,o[11]=-1,o[12]=0,o[13]=0,o[14]=c,o[15]=0,o},l.computeOrthographicOffCenter=function(e,t,n,i,o,a,u){r.typeOf.number("left",e),r.typeOf.number("right",t),r.typeOf.number("bottom",n),r.typeOf.number("top",i),r.typeOf.number("near",o),r.typeOf.number("far",a),r.typeOf.object("result",u);var s=1/(t-e),c=1/(i-n),l=1/(a-o),f=-(t+e)*s,p=-(i+n)*c,h=-(a+o)*l;return s*=2,c*=2,l*=-2,u[0]=s,u[1]=0,u[2]=0,u[3]=0,u[4]=0,u[5]=c,u[6]=0,u[7]=0,u[8]=0,u[9]=0,u[10]=l,u[11]=0,u[12]=f,u[13]=p,u[14]=h,u[15]=1,u},l.computePerspectiveOffCenter=function(e,t,n,i,o,a,u){r.typeOf.number("left",e),r.typeOf.number("right",t),r.typeOf.number("bottom",n),r.typeOf.number("top",i),r.typeOf.number("near",o),r.typeOf.number("far",a),r.typeOf.object("result",u);var s=2*o/(t-e),c=2*o/(i-n),l=(t+e)/(t-e),f=(i+n)/(i-n),p=-(a+o)/(a-o),h=-2*a*o/(a-o);return u[0]=s,u[1]=0,u[2]=0,u[3]=0,u[4]=0,u[5]=c,u[6]=0,u[7]=0,u[8]=l,u[9]=f,u[10]=p,u[11]=-1,u[12]=0,u[13]=0,u[14]=h,u[15]=0,u},l.computeInfinitePerspectiveOffCenter=function(e,t,n,i,o,a){r.typeOf.number("left",e),r.typeOf.number("right",t),r.typeOf.number("bottom",n),r.typeOf.number("top",i),r.typeOf.number("near",o),r.typeOf.object("result",a);var u=2*o/(t-e),s=2*o/(i-n),c=(t+e)/(t-e),l=(i+n)/(i-n),f=-2*o;return a[0]=u,a[1]=0,a[2]=0,a[3]=0,a[4]=0,a[5]=s,a[6]=0,a[7]=0,a[8]=c,a[9]=l,a[10]=-1,a[11]=-1,a[12]=0,a[13]=0,a[14]=f,a[15]=0,a},l.computeViewportTransformation=function(e,t,i,o){r.typeOf.object("result",o),e=n(e,n.EMPTY_OBJECT);var a=n(e.x,0),u=n(e.y,0),s=n(e.width,0),c=n(e.height,0);t=n(t,0);var l=.5*s,f=.5*c,p=.5*((i=n(i,1))-t),h=l,d=f,y=p,m=a+l,E=u+f,O=t+p;return o[0]=h,o[1]=0,o[2]=0,o[3]=0,o[4]=0,o[5]=d,o[6]=0,o[7]=0,o[8]=0,o[9]=0,o[10]=y,o[11]=0,o[12]=m,o[13]=E,o[14]=O,o[15]=1,o},l.computeView=function(t,n,i,o,a){return r.typeOf.object("position",t),r.typeOf.object("direction",n),r.typeOf.object("up",i),r.typeOf.object("right",o),r.typeOf.object("result",a),a[0]=o.x,a[1]=i.x,a[2]=-n.x,a[3]=0,a[4]=o.y,a[5]=i.y,a[6]=-n.y,a[7]=0,a[8]=o.z,a[9]=i.z,a[10]=-n.z,a[11]=0,a[12]=-e.dot(o,t),a[13]=-e.dot(i,t),a[14]=e.dot(n,t),a[15]=1,a},l.toArray=function(e,t){return r.typeOf.object("matrix",e),i(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15]]},l.getElementIndex=function(e,t){return r.typeOf.number.greaterThanOrEquals("row",t,0),r.typeOf.number.lessThanOrEquals("row",t,3),r.typeOf.number.greaterThanOrEquals("column",e,0),r.typeOf.number.lessThanOrEquals("column",e,3),4*e+t},l.getColumn=function(e,t,n){r.typeOf.object("matrix",e),r.typeOf.number.greaterThanOrEquals("index",t,0),r.typeOf.number.lessThanOrEquals("index",t,3),r.typeOf.object("result",n);var i=4*t,o=e[i],a=e[i+1],u=e[i+2],s=e[i+3];return n.x=o,n.y=a,n.z=u,n.w=s,n},l.setColumn=function(e,t,n,i){r.typeOf.object("matrix",e),r.typeOf.number.greaterThanOrEquals("index",t,0),r.typeOf.number.lessThanOrEquals("index",t,3),r.typeOf.object("cartesian",n),r.typeOf.object("result",i);var o=4*t;return(i=l.clone(e,i))[o]=n.x,i[o+1]=n.y,i[o+2]=n.z,i[o+3]=n.w,i},l.setTranslation=function(e,t,n){return r.typeOf.object("matrix",e),r.typeOf.object("translation",t),r.typeOf.object("result",n),n[0]=e[0],n[1]=e[1],n[2]=e[2],n[3]=e[3],n[4]=e[4],n[5]=e[5],n[6]=e[6],n[7]=e[7],n[8]=e[8],n[9]=e[9],n[10]=e[10],n[11]=e[11],n[12]=t.x,n[13]=t.y,n[14]=t.z,n[15]=e[15],n};var d=new e;l.setScale=function(t,n,i){r.typeOf.object("matrix",t),r.typeOf.object("scale",n),r.typeOf.object("result",i);var o=l.getScale(t,d),a=e.divideComponents(n,o,d);return l.multiplyByScale(t,a,i)},l.getRow=function(e,t,n){r.typeOf.object("matrix",e),r.typeOf.number.greaterThanOrEquals("index",t,0),r.typeOf.number.lessThanOrEquals("index",t,3),r.typeOf.object("result",n);var i=e[t],o=e[t+4],a=e[t+8],u=e[t+12];return n.x=i,n.y=o,n.z=a,n.w=u,n},l.setRow=function(e,t,n,i){return r.typeOf.object("matrix",e),r.typeOf.number.greaterThanOrEquals("index",t,0),r.typeOf.number.lessThanOrEquals("index",t,3),r.typeOf.object("cartesian",n),r.typeOf.object("result",i),(i=l.clone(e,i))[t]=n.x,i[t+4]=n.y,i[t+8]=n.z,i[t+12]=n.w,i};var y=new e;l.getScale=function(t,n){return r.typeOf.object("matrix",t),r.typeOf.object("result",n),n.x=e.magnitude(e.fromElements(t[0],t[1],t[2],y)),n.y=e.magnitude(e.fromElements(t[4],t[5],t[6],y)),n.z=e.magnitude(e.fromElements(t[8],t[9],t[10],y)),n};var m=new e;l.getMaximumScale=function(t){return l.getScale(t,m),e.maximumComponent(m)},l.multiply=function(e,t,n){r.typeOf.object("left",e),r.typeOf.object("right",t),r.typeOf.object("result",n);var i=e[0],o=e[1],a=e[2],u=e[3],s=e[4],c=e[5],l=e[6],f=e[7],p=e[8],h=e[9],d=e[10],y=e[11],m=e[12],E=e[13],O=e[14],v=e[15],w=t[0],_=t[1],g=t[2],T=t[3],b=t[4],R=t[5],A=t[6],x=t[7],S=t[8],N=t[9],I=t[10],M=t[11],C=t[12],P=t[13],D=t[14],U=t[15],L=i*w+s*_+p*g+m*T,q=o*w+c*_+h*g+E*T,F=a*w+l*_+d*g+O*T,j=u*w+f*_+y*g+v*T,B=i*b+s*R+p*A+m*x,z=o*b+c*R+h*A+E*x,G=a*b+l*R+d*A+O*x,V=u*b+f*R+y*A+v*x,H=i*S+s*N+p*I+m*M,W=o*S+c*N+h*I+E*M,X=a*S+l*N+d*I+O*M,k=u*S+f*N+y*I+v*M,Y=i*C+s*P+p*D+m*U,Z=o*C+c*P+h*D+E*U,K=a*C+l*P+d*D+O*U,Q=u*C+f*P+y*D+v*U;return n[0]=L,n[1]=q,n[2]=F,n[3]=j,n[4]=B,n[5]=z,n[6]=G,n[7]=V,n[8]=H,n[9]=W,n[10]=X,n[11]=k,n[12]=Y,n[13]=Z,n[14]=K,n[15]=Q,n},l.add=function(e,t,n){return r.typeOf.object("left",e),r.typeOf.object("right",t),r.typeOf.object("result",n),n[0]=e[0]+t[0],n[1]=e[1]+t[1],n[2]=e[2]+t[2],n[3]=e[3]+t[3],n[4]=e[4]+t[4],n[5]=e[5]+t[5],n[6]=e[6]+t[6],n[7]=e[7]+t[7],n[8]=e[8]+t[8],n[9]=e[9]+t[9],n[10]=e[10]+t[10],n[11]=e[11]+t[11],n[12]=e[12]+t[12],n[13]=e[13]+t[13],n[14]=e[14]+t[14],n[15]=e[15]+t[15],n},l.subtract=function(e,t,n){return r.typeOf.object("left",e),r.typeOf.object("right",t),r.typeOf.object("result",n),n[0]=e[0]-t[0],n[1]=e[1]-t[1],n[2]=e[2]-t[2],n[3]=e[3]-t[3],n[4]=e[4]-t[4],n[5]=e[5]-t[5],n[6]=e[6]-t[6],n[7]=e[7]-t[7],n[8]=e[8]-t[8],n[9]=e[9]-t[9],n[10]=e[10]-t[10],n[11]=e[11]-t[11],n[12]=e[12]-t[12],n[13]=e[13]-t[13],n[14]=e[14]-t[14],n[15]=e[15]-t[15],n},l.multiplyTransformation=function(e,t,n){r.typeOf.object("left",e),r.typeOf.object("right",t),r.typeOf.object("result",n);var i=e[0],o=e[1],a=e[2],u=e[4],s=e[5],c=e[6],l=e[8],f=e[9],p=e[10],h=e[12],d=e[13],y=e[14],m=t[0],E=t[1],O=t[2],v=t[4],w=t[5],_=t[6],g=t[8],T=t[9],b=t[10],R=t[12],A=t[13],x=t[14],S=i*m+u*E+l*O,N=o*m+s*E+f*O,I=a*m+c*E+p*O,M=i*v+u*w+l*_,C=o*v+s*w+f*_,P=a*v+c*w+p*_,D=i*g+u*T+l*b,U=o*g+s*T+f*b,L=a*g+c*T+p*b,q=i*R+u*A+l*x+h,F=o*R+s*A+f*x+d,j=a*R+c*A+p*x+y;return n[0]=S,n[1]=N,n[2]=I,n[3]=0,n[4]=M,n[5]=C,n[6]=P,n[7]=0,n[8]=D,n[9]=U,n[10]=L,n[11]=0,n[12]=q,n[13]=F,n[14]=j,n[15]=1,n},l.multiplyByMatrix3=function(e,t,n){r.typeOf.object("matrix",e),r.typeOf.object("rotation",t),r.typeOf.object("result",n);var i=e[0],o=e[1],a=e[2],u=e[4],s=e[5],c=e[6],l=e[8],f=e[9],p=e[10],h=t[0],d=t[1],y=t[2],m=t[3],E=t[4],O=t[5],v=t[6],w=t[7],_=t[8],g=i*h+u*d+l*y,T=o*h+s*d+f*y,b=a*h+c*d+p*y,R=i*m+u*E+l*O,A=o*m+s*E+f*O,x=a*m+c*E+p*O,S=i*v+u*w+l*_,N=o*v+s*w+f*_,I=a*v+c*w+p*_;return n[0]=g,n[1]=T,n[2]=b,n[3]=0,n[4]=R,n[5]=A,n[6]=x,n[7]=0,n[8]=S,n[9]=N,n[10]=I,n[11]=0,n[12]=e[12],n[13]=e[13],n[14]=e[14],n[15]=e[15],n},l.multiplyByTranslation=function(e,t,n){r.typeOf.object("matrix",e),r.typeOf.object("translation",t),r.typeOf.object("result",n);var i=t.x,o=t.y,a=t.z,u=i*e[0]+o*e[4]+a*e[8]+e[12],s=i*e[1]+o*e[5]+a*e[9]+e[13],c=i*e[2]+o*e[6]+a*e[10]+e[14];return n[0]=e[0],n[1]=e[1],n[2]=e[2],n[3]=e[3],n[4]=e[4],n[5]=e[5],n[6]=e[6],n[7]=e[7],n[8]=e[8],n[9]=e[9],n[10]=e[10],n[11]=e[11],n[12]=u,n[13]=s,n[14]=c,n[15]=e[15],n};var E=new e;l.multiplyByUniformScale=function(e,t,n){return r.typeOf.object("matrix",e),r.typeOf.number("scale",t),r.typeOf.object("result",n),E.x=t,E.y=t,E.z=t,l.multiplyByScale(e,E,n)},l.multiplyByScale=function(e,t,n){r.typeOf.object("matrix",e),r.typeOf.object("scale",t),r.typeOf.object("result",n);var i=t.x,o=t.y,a=t.z;return 1===i&&1===o&&1===a?l.clone(e,n):(n[0]=i*e[0],n[1]=i*e[1],n[2]=i*e[2],n[3]=0,n[4]=o*e[4],n[5]=o*e[5],n[6]=o*e[6],n[7]=0,n[8]=a*e[8],n[9]=a*e[9],n[10]=a*e[10],n[11]=0,n[12]=e[12],n[13]=e[13],n[14]=e[14],n[15]=1,n)},l.multiplyByVector=function(e,t,n){r.typeOf.object("matrix",e),r.typeOf.object("cartesian",t),r.typeOf.object("result",n);var i=t.x,o=t.y,a=t.z,u=t.w,s=e[0]*i+e[4]*o+e[8]*a+e[12]*u,c=e[1]*i+e[5]*o+e[9]*a+e[13]*u,l=e[2]*i+e[6]*o+e[10]*a+e[14]*u,f=e[3]*i+e[7]*o+e[11]*a+e[15]*u;return n.x=s,n.y=c,n.z=l,n.w=f,n},l.multiplyByPointAsVector=function(e,t,n){r.typeOf.object("matrix",e),r.typeOf.object("cartesian",t),r.typeOf.object("result",n);var i=t.x,o=t.y,a=t.z,u=e[0]*i+e[4]*o+e[8]*a,s=e[1]*i+e[5]*o+e[9]*a,c=e[2]*i+e[6]*o+e[10]*a;return n.x=u,n.y=s,n.z=c,n},l.multiplyByPoint=function(e,t,n){r.typeOf.object("matrix",e),r.typeOf.object("cartesian",t),r.typeOf.object("result",n);var i=t.x,o=t.y,a=t.z,u=e[0]*i+e[4]*o+e[8]*a+e[12],s=e[1]*i+e[5]*o+e[9]*a+e[13],c=e[2]*i+e[6]*o+e[10]*a+e[14];return n.x=u,n.y=s,n.z=c,n},l.multiplyByScalar=function(e,t,n){return r.typeOf.object("matrix",e),r.typeOf.number("scalar",t),r.typeOf.object("result",n),n[0]=e[0]*t,n[1]=e[1]*t,n[2]=e[2]*t,n[3]=e[3]*t,n[4]=e[4]*t,n[5]=e[5]*t,n[6]=e[6]*t,n[7]=e[7]*t,n[8]=e[8]*t,n[9]=e[9]*t,n[10]=e[10]*t,n[11]=e[11]*t,n[12]=e[12]*t,n[13]=e[13]*t,n[14]=e[14]*t,n[15]=e[15]*t,n},l.negate=function(e,t){return r.typeOf.object("matrix",e),r.typeOf.object("result",t),t[0]=-e[0],t[1]=-e[1],t[2]=-e[2],t[3]=-e[3],t[4]=-e[4],t[5]=-e[5],t[6]=-e[6],t[7]=-e[7],t[8]=-e[8],t[9]=-e[9],t[10]=-e[10],t[11]=-e[11],t[12]=-e[12],t[13]=-e[13],t[14]=-e[14],t[15]=-e[15],t},l.transpose=function(e,t){r.typeOf.object("matrix",e),r.typeOf.object("result",t);var n=e[1],i=e[2],o=e[3],a=e[6],u=e[7],s=e[11];return t[0]=e[0],t[1]=e[4],t[2]=e[8],t[3]=e[12],t[4]=n,t[5]=e[5],t[6]=e[9],t[7]=e[13],t[8]=i,t[9]=a,t[10]=e[10],t[11]=e[14],t[12]=o,t[13]=u,t[14]=s,t[15]=e[15],t},l.abs=function(e,t){return r.typeOf.object("matrix",e),r.typeOf.object("result",t),t[0]=Math.abs(e[0]),t[1]=Math.abs(e[1]),t[2]=Math.abs(e[2]),t[3]=Math.abs(e[3]),t[4]=Math.abs(e[4]),t[5]=Math.abs(e[5]),t[6]=Math.abs(e[6]),t[7]=Math.abs(e[7]),t[8]=Math.abs(e[8]),t[9]=Math.abs(e[9]),t[10]=Math.abs(e[10]),t[11]=Math.abs(e[11]),t[12]=Math.abs(e[12]),t[13]=Math.abs(e[13]),t[14]=Math.abs(e[14]),t[15]=Math.abs(e[15]),t},l.equals=function(e,t){return e===t||i(e)&&i(t)&&e[12]===t[12]&&e[13]===t[13]&&e[14]===t[14]&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[4]===t[4]&&e[5]===t[5]&&e[6]===t[6]&&e[8]===t[8]&&e[9]===t[9]&&e[10]===t[10]&&e[3]===t[3]&&e[7]===t[7]&&e[11]===t[11]&&e[15]===t[15]},l.equalsEpsilon=function(e,t,n){return r.typeOf.number("epsilon",n),e===t||i(e)&&i(t)&&Math.abs(e[0]-t[0])<=n&&Math.abs(e[1]-t[1])<=n&&Math.abs(e[2]-t[2])<=n&&Math.abs(e[3]-t[3])<=n&&Math.abs(e[4]-t[4])<=n&&Math.abs(e[5]-t[5])<=n&&Math.abs(e[6]-t[6])<=n&&Math.abs(e[7]-t[7])<=n&&Math.abs(e[8]-t[8])<=n&&Math.abs(e[9]-t[9])<=n&&Math.abs(e[10]-t[10])<=n&&Math.abs(e[11]-t[11])<=n&&Math.abs(e[12]-t[12])<=n&&Math.abs(e[13]-t[13])<=n&&Math.abs(e[14]-t[14])<=n&&Math.abs(e[15]-t[15])<=n},l.getTranslation=function(e,t){return r.typeOf.object("matrix",e),r.typeOf.object("result",t),t.x=e[12],t.y=e[13],t.z=e[14],t},l.getRotation=function(e,t){return r.typeOf.object("matrix",e),r.typeOf.object("result",t),t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[4],t[4]=e[5],t[5]=e[6],t[6]=e[8],t[7]=e[9],t[8]=e[10],t};var O=new s,v=new s,w=new t,_=new t(0,0,0,1);return l.inverse=function(e,n){r.typeOf.object("matrix",e),r.typeOf.object("result",n);var i=e[0],o=e[4],a=e[8],f=e[12],p=e[1],h=e[5],d=e[9],y=e[13],m=e[2],E=e[6],g=e[10],T=e[14],b=e[3],R=e[7],A=e[11],x=e[15],S=g*x,N=T*A,I=E*x,M=T*R,C=E*A,P=g*R,D=m*x,U=T*b,L=m*A,q=g*b,F=m*R,j=E*b,B=S*h+M*d+C*y-(N*h+I*d+P*y),z=N*p+D*d+q*y-(S*p+U*d+L*y),G=I*p+U*h+F*y-(M*p+D*h+j*y),V=P*p+L*h+j*d-(C*p+q*h+F*d),H=N*o+I*a+P*f-(S*o+M*a+C*f),W=S*i+U*a+L*f-(N*i+D*a+q*f),X=M*i+D*o+j*f-(I*i+U*o+F*f),k=C*i+q*o+F*a-(P*i+L*o+j*a),Y=(S=a*y)*R+(M=f*h)*A+(C=o*d)*x-((N=f*d)*R+(I=o*y)*A+(P=a*h)*x),Z=N*b+(D=i*y)*A+(q=a*p)*x-(S*b+(U=f*p)*A+(L=i*d)*x),K=I*b+U*R+(F=i*h)*x-(M*b+D*R+(j=o*p)*x),Q=P*b+L*R+j*A-(C*b+q*R+F*A),J=I*g+P*T+N*E-(C*T+S*E+M*g),$=L*T+S*m+U*g-(D*g+q*T+N*m),ee=D*E+j*T+M*m-(F*T+I*m+U*E),te=F*g+C*m+q*E-(L*E+j*g+P*m),re=i*B+o*z+a*G+f*V;if(Math.abs(re)<u.EPSILON21){if(s.equalsEpsilon(l.getRotation(e,O),v,u.EPSILON7)&&t.equals(l.getRow(e,3,w),_))return n[0]=0,n[1]=0,n[2]=0,n[3]=0,n[4]=0,n[5]=0,n[6]=0,n[7]=0,n[8]=0,n[9]=0,n[10]=0,n[11]=0,n[12]=-e[12],n[13]=-e[13],n[14]=-e[14],n[15]=1,n;throw new c("matrix is not invertible because its determinate is zero.")}return re=1/re,n[0]=B*re,n[1]=z*re,n[2]=G*re,n[3]=V*re,n[4]=H*re,n[5]=W*re,n[6]=X*re,n[7]=k*re,n[8]=Y*re,n[9]=Z*re,n[10]=K*re,n[11]=Q*re,n[12]=J*re,n[13]=$*re,n[14]=ee*re,n[15]=te*re,n},l.inverseTransformation=function(e,t){r.typeOf.object("matrix",e),r.typeOf.object("result",t);var n=e[0],i=e[1],o=e[2],a=e[4],u=e[5],s=e[6],c=e[8],l=e[9],f=e[10],p=e[12],h=e[13],d=e[14],y=-n*p-i*h-o*d,m=-a*p-u*h-s*d,E=-c*p-l*h-f*d;return t[0]=n,t[1]=a,t[2]=c,t[3]=0,t[4]=i,t[5]=u,t[6]=l,t[7]=0,t[8]=o,t[9]=s,t[10]=f,t[11]=0,t[12]=y,t[13]=m,t[14]=E,t[15]=1,t},l.IDENTITY=a(new l(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1)),l.ZERO=a(new l(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0)),l.COLUMN0ROW0=0,l.COLUMN0ROW1=1,l.COLUMN0ROW2=2,l.COLUMN0ROW3=3,l.COLUMN1ROW0=4,l.COLUMN1ROW1=5,l.COLUMN1ROW2=6,l.COLUMN1ROW3=7,l.COLUMN2ROW0=8,l.COLUMN2ROW1=9,l.COLUMN2ROW2=10,l.COLUMN2ROW3=11,l.COLUMN3ROW0=12,l.COLUMN3ROW1=13,l.COLUMN3ROW2=14,l.COLUMN3ROW3=15,o(l.prototype,{length:{get:function(){return l.packedLength}}}),l.prototype.clone=function(e){return l.clone(this,e)},l.prototype.equals=function(e){return l.equals(this,e)},l.equalsArray=function(e,t,r){return e[0]===t[r]&&e[1]===t[r+1]&&e[2]===t[r+2]&&e[3]===t[r+3]&&e[4]===t[r+4]&&e[5]===t[r+5]&&e[6]===t[r+6]&&e[7]===t[r+7]&&e[8]===t[r+8]&&e[9]===t[r+9]&&e[10]===t[r+10]&&e[11]===t[r+11]&&e[12]===t[r+12]&&e[13]===t[r+13]&&e[14]===t[r+14]&&e[15]===t[r+15]},l.prototype.equalsEpsilon=function(e,t){return l.equalsEpsilon(this,e,t)},l.prototype.toString=function(){return"("+this[0]+", "+this[4]+", "+this[8]+", "+this[12]+")\n("+this[1]+", "+this[5]+", "+this[9]+", "+this[13]+")\n("+this[2]+", "+this[6]+", "+this[10]+", "+this[14]+")\n("+this[3]+", "+this[7]+", "+this[11]+", "+this[15]+")"},l})),define("Core/BoundingSphere",["./Cartesian3","./Cartographic","./Check","./defaultValue","./defined","./Ellipsoid","./GeographicProjection","./Intersect","./Interval","./Math","./Matrix3","./Matrix4","./Rectangle"],(function(e,t,r,n,i,o,a,u,s,c,l,f,p){"use strict";function h(t,r){this.center=e.clone(n(t,e.ZERO)),this.radius=n(r,0)}var d=new e,y=new e,m=new e,E=new e,O=new e,v=new e,w=new e,_=new e,g=new e,T=new e,b=new e,R=new e,A=4/3*c.PI;h.fromPoints=function(t,r){if(i(r)||(r=new h),!i(t)||0===t.length)return r.center=e.clone(e.ZERO,r.center),r.radius=0,r;var n,o=e.clone(t[0],w),a=e.clone(o,d),u=e.clone(o,y),s=e.clone(o,m),c=e.clone(o,E),l=e.clone(o,O),f=e.clone(o,v),p=t.length;for(n=1;n<p;n++){e.clone(t[n],o);var A=o.x,x=o.y,S=o.z;A<a.x&&e.clone(o,a),A>c.x&&e.clone(o,c),x<u.y&&e.clone(o,u),x>l.y&&e.clone(o,l),S<s.z&&e.clone(o,s),S>f.z&&e.clone(o,f)}var N=e.magnitudeSquared(e.subtract(c,a,_)),I=e.magnitudeSquared(e.subtract(l,u,_)),M=e.magnitudeSquared(e.subtract(f,s,_)),C=a,P=c,D=N;I>D&&(D=I,C=u,P=l),M>D&&(D=M,C=s,P=f);var U=g;U.x=.5*(C.x+P.x),U.y=.5*(C.y+P.y),U.z=.5*(C.z+P.z);var L=e.magnitudeSquared(e.subtract(P,U,_)),q=Math.sqrt(L),F=T;F.x=a.x,F.y=u.y,F.z=s.z;var j=b;j.x=c.x,j.y=l.y,j.z=f.z;var B=e.midpoint(F,j,R),z=0;for(n=0;n<p;n++){e.clone(t[n],o);var G=e.magnitude(e.subtract(o,B,_));G>z&&(z=G);var V=e.magnitudeSquared(e.subtract(o,U,_));if(V>L){var H=Math.sqrt(V);L=(q=.5*(q+H))*q;var W=H-q;U.x=(q*U.x+W*o.x)/H,U.y=(q*U.y+W*o.y)/H,U.z=(q*U.z+W*o.z)/H}}return q<z?(e.clone(U,r.center),r.radius=q):(e.clone(B,r.center),r.radius=z),r};var x=new a,S=new e,N=new e,I=new t,M=new t;h.fromRectangle2D=function(e,t,r){return h.fromRectangleWithHeights2D(e,t,0,0,r)},h.fromRectangleWithHeights2D=function(t,r,o,a,u){if(i(u)||(u=new h),!i(t))return u.center=e.clone(e.ZERO,u.center),u.radius=0,u;r=n(r,x),p.southwest(t,I),I.height=o,p.northeast(t,M),M.height=a;var s=r.project(I,S),c=r.project(M,N),l=c.x-s.x,f=c.y-s.y,d=c.z-s.z;u.radius=.5*Math.sqrt(l*l+f*f+d*d);var y=u.center;return y.x=s.x+.5*l,y.y=s.y+.5*f,y.z=s.z+.5*d,u};var C=[];h.fromRectangle3D=function(t,r,a,u){if(r=n(r,o.WGS84),a=n(a,0),i(u)||(u=new h),!i(t))return u.center=e.clone(e.ZERO,u.center),u.radius=0,u;var s=p.subsample(t,r,a,C);return h.fromPoints(s,u)},h.fromVertices=function(t,o,a,u){if(i(u)||(u=new h),!i(t)||0===t.length)return u.center=e.clone(e.ZERO,u.center),u.radius=0,u;o=n(o,e.ZERO),a=n(a,3),r.typeOf.number.greaterThanOrEquals("stride",a,3);var s=w;s.x=t[0]+o.x,s.y=t[1]+o.y,s.z=t[2]+o.z;var c,l=e.clone(s,d),f=e.clone(s,y),p=e.clone(s,m),A=e.clone(s,E),x=e.clone(s,O),S=e.clone(s,v),N=t.length;for(c=0;c<N;c+=a){var I=t[c]+o.x,M=t[c+1]+o.y,C=t[c+2]+o.z;s.x=I,s.y=M,s.z=C,I<l.x&&e.clone(s,l),I>A.x&&e.clone(s,A),M<f.y&&e.clone(s,f),M>x.y&&e.clone(s,x),C<p.z&&e.clone(s,p),C>S.z&&e.clone(s,S)}var P=e.magnitudeSquared(e.subtract(A,l,_)),D=e.magnitudeSquared(e.subtract(x,f,_)),U=e.magnitudeSquared(e.subtract(S,p,_)),L=l,q=A,F=P;D>F&&(F=D,L=f,q=x),U>F&&(F=U,L=p,q=S);var j=g;j.x=.5*(L.x+q.x),j.y=.5*(L.y+q.y),j.z=.5*(L.z+q.z);var B=e.magnitudeSquared(e.subtract(q,j,_)),z=Math.sqrt(B),G=T;G.x=l.x,G.y=f.y,G.z=p.z;var V=b;V.x=A.x,V.y=x.y,V.z=S.z;var H=e.midpoint(G,V,R),W=0;for(c=0;c<N;c+=a){s.x=t[c]+o.x,s.y=t[c+1]+o.y,s.z=t[c+2]+o.z;var X=e.magnitude(e.subtract(s,H,_));X>W&&(W=X);var k=e.magnitudeSquared(e.subtract(s,j,_));if(k>B){var Y=Math.sqrt(k);B=(z=.5*(z+Y))*z;var Z=Y-z;j.x=(z*j.x+Z*s.x)/Y,j.y=(z*j.y+Z*s.y)/Y,j.z=(z*j.z+Z*s.z)/Y}}return z<W?(e.clone(j,u.center),u.radius=z):(e.clone(H,u.center),u.radius=W),u},h.fromEncodedCartesianVertices=function(t,r,n){if(i(n)||(n=new h),!i(t)||!i(r)||t.length!==r.length||0===t.length)return n.center=e.clone(e.ZERO,n.center),n.radius=0,n;var o=w;o.x=t[0]+r[0],o.y=t[1]+r[1],o.z=t[2]+r[2];var a,u=e.clone(o,d),s=e.clone(o,y),c=e.clone(o,m),l=e.clone(o,E),f=e.clone(o,O),p=e.clone(o,v),A=t.length;for(a=0;a<A;a+=3){var x=t[a]+r[a],S=t[a+1]+r[a+1],N=t[a+2]+r[a+2];o.x=x,o.y=S,o.z=N,x<u.x&&e.clone(o,u),x>l.x&&e.clone(o,l),S<s.y&&e.clone(o,s),S>f.y&&e.clone(o,f),N<c.z&&e.clone(o,c),N>p.z&&e.clone(o,p)}var I=e.magnitudeSquared(e.subtract(l,u,_)),M=e.magnitudeSquared(e.subtract(f,s,_)),C=e.magnitudeSquared(e.subtract(p,c,_)),P=u,D=l,U=I;M>U&&(U=M,P=s,D=f),C>U&&(U=C,P=c,D=p);var L=g;L.x=.5*(P.x+D.x),L.y=.5*(P.y+D.y),L.z=.5*(P.z+D.z);var q=e.magnitudeSquared(e.subtract(D,L,_)),F=Math.sqrt(q),j=T;j.x=u.x,j.y=s.y,j.z=c.z;var B=b;B.x=l.x,B.y=f.y,B.z=p.z;var z=e.midpoint(j,B,R),G=0;for(a=0;a<A;a+=3){o.x=t[a]+r[a],o.y=t[a+1]+r[a+1],o.z=t[a+2]+r[a+2];var V=e.magnitude(e.subtract(o,z,_));V>G&&(G=V);var H=e.magnitudeSquared(e.subtract(o,L,_));if(H>q){var W=Math.sqrt(H);q=(F=.5*(F+W))*F;var X=W-F;L.x=(F*L.x+X*o.x)/W,L.y=(F*L.y+X*o.y)/W,L.z=(F*L.z+X*o.z)/W}}return F<G?(e.clone(L,n.center),n.radius=F):(e.clone(z,n.center),n.radius=G),n},h.fromCornerPoints=function(t,n,o){r.typeOf.object("corner",t),r.typeOf.object("oppositeCorner",n),i(o)||(o=new h);var a=e.midpoint(t,n,o.center);return o.radius=e.distance(a,n),o},h.fromEllipsoid=function(t,n){return r.typeOf.object("ellipsoid",t),i(n)||(n=new h),e.clone(e.ZERO,n.center),n.radius=t.maximumRadius,n};var P=new e;h.fromBoundingSpheres=function(t,r){if(i(r)||(r=new h),!i(t)||0===t.length)return r.center=e.clone(e.ZERO,r.center),r.radius=0,r;var n=t.length;if(1===n)return h.clone(t[0],r);if(2===n)return h.union(t[0],t[1],r);var o,a=[];for(o=0;o<n;o++)a.push(t[o].center);var u=(r=h.fromPoints(a,r)).center,s=r.radius;for(o=0;o<n;o++){var c=t[o];s=Math.max(s,e.distance(u,c.center,P)+c.radius)}return r.radius=s,r};var D=new e,U=new e,L=new e;h.fromOrientedBoundingBox=function(t,n){r.defined("orientedBoundingBox",t),i(n)||(n=new h);var o=t.halfAxes,a=l.getColumn(o,0,D),u=l.getColumn(o,1,U),s=l.getColumn(o,2,L);return e.add(a,u,a),e.add(a,s,a),n.center=e.clone(t.center,n.center),n.radius=e.magnitude(a),n},h.clone=function(t,r){if(i(t))return i(r)?(r.center=e.clone(t.center,r.center),r.radius=t.radius,r):new h(t.center,t.radius)},h.packedLength=4,h.pack=function(e,t,i){r.typeOf.object("value",e),r.defined("array",t),i=n(i,0);var o=e.center;return t[i++]=o.x,t[i++]=o.y,t[i++]=o.z,t[i]=e.radius,t},h.unpack=function(e,t,o){r.defined("array",e),t=n(t,0),i(o)||(o=new h);var a=o.center;return a.x=e[t++],a.y=e[t++],a.z=e[t++],o.radius=e[t],o};var q=new e,F=new e;h.union=function(t,n,o){r.typeOf.object("left",t),r.typeOf.object("right",n),i(o)||(o=new h);var a=t.center,u=t.radius,s=n.center,c=n.radius,l=e.subtract(s,a,q),f=e.magnitude(l);if(u>=f+c)return t.clone(o),o;if(c>=f+u)return n.clone(o),o;var p=.5*(u+f+c),d=e.multiplyByScalar(l,(-u+p)/f,F);return e.add(d,a,d),e.clone(d,o.center),o.radius=p,o};var j=new e;h.expand=function(t,n,i){r.typeOf.object("sphere",t),r.typeOf.object("point",n),i=h.clone(t,i);var o=e.magnitude(e.subtract(n,i.center,j));return o>i.radius&&(i.radius=o),i},h.intersectPlane=function(t,n){r.typeOf.object("sphere",t),r.typeOf.object("plane",n);var i=t.center,o=t.radius,a=n.normal,s=e.dot(a,i)+n.distance;return s<-o?u.OUTSIDE:s<o?u.INTERSECTING:u.INSIDE},h.transform=function(e,t,n){return r.typeOf.object("sphere",e),r.typeOf.object("transform",t),i(n)||(n=new h),n.center=f.multiplyByPoint(t,e.center,n.center),n.radius=f.getMaximumScale(t)*e.radius,n};var B=new e;h.distanceSquaredTo=function(t,n){r.typeOf.object("sphere",t),r.typeOf.object("cartesian",n);var i=e.subtract(t.center,n,B);return e.magnitudeSquared(i)-t.radius*t.radius},h.transformWithoutScale=function(e,t,n){return r.typeOf.object("sphere",e),r.typeOf.object("transform",t),i(n)||(n=new h),n.center=f.multiplyByPoint(t,e.center,n.center),n.radius=e.radius,n};var z=new e;h.computePlaneDistances=function(t,n,o,a){r.typeOf.object("sphere",t),r.typeOf.object("position",n),r.typeOf.object("direction",o),i(a)||(a=new s);var u=e.subtract(t.center,n,z),c=e.dot(o,u);return a.start=c-t.radius,a.stop=c+t.radius,a};for(var G=new e,V=new e,H=new e,W=new e,X=new e,k=new t,Y=new Array(8),Z=0;Z<8;++Z)Y[Z]=new e;var K=new a;return h.projectTo2D=function(t,i,o){r.typeOf.object("sphere",t);var a=(i=n(i,K)).ellipsoid,u=t.center,s=t.radius,c=a.geodeticSurfaceNormal(u,G),l=e.cross(e.UNIT_Z,c,V);e.normalize(l,l);var f=e.cross(c,l,H);e.normalize(f,f),e.multiplyByScalar(c,s,c),e.multiplyByScalar(f,s,f),e.multiplyByScalar(l,s,l);var p=e.negate(f,X),d=e.negate(l,W),y=Y,m=y[0];e.add(c,f,m),e.add(m,l,m),m=y[1],e.add(c,f,m),e.add(m,d,m),m=y[2],e.add(c,p,m),e.add(m,d,m),m=y[3],e.add(c,p,m),e.add(m,l,m),e.negate(c,c),m=y[4],e.add(c,f,m),e.add(m,l,m),m=y[5],e.add(c,f,m),e.add(m,d,m),m=y[6],e.add(c,p,m),e.add(m,d,m),m=y[7],e.add(c,p,m),e.add(m,l,m);for(var E=y.length,O=0;O<E;++O){var v=y[O];e.add(u,v,v);var w=a.cartesianToCartographic(v,k);i.project(w,v)}var _=(u=(o=h.fromPoints(y,o)).center).x,g=u.y,T=u.z;return u.x=T,u.y=_,u.z=g,o},h.isOccluded=function(e,t){return r.typeOf.object("sphere",e),r.typeOf.object("occluder",t),!t.isBoundingSphereVisible(e)},h.equals=function(t,r){return t===r||i(t)&&i(r)&&e.equals(t.center,r.center)&&t.radius===r.radius},h.prototype.intersectPlane=function(e){return h.intersectPlane(this,e)},h.prototype.distanceSquaredTo=function(e){return h.distanceSquaredTo(this,e)},h.prototype.computePlaneDistances=function(e,t,r){return h.computePlaneDistances(this,e,t,r)},h.prototype.isOccluded=function(e){return h.isOccluded(this,e)},h.prototype.equals=function(e){return h.equals(this,e)},h.prototype.clone=function(e){return h.clone(this,e)},h.prototype.volume=function(){var e=this.radius;return A*e*e*e},h})),define("Core/Fullscreen",["./defined","./defineProperties"],(function(e,t){"use strict";var r,n={requestFullscreen:void 0,exitFullscreen:void 0,fullscreenEnabled:void 0,fullscreenElement:void 0,fullscreenchange:void 0,fullscreenerror:void 0},i={};return t(i,{element:{get:function(){if(i.supportsFullscreen())return document[n.fullscreenElement]}},changeEventName:{get:function(){if(i.supportsFullscreen())return n.fullscreenchange}},errorEventName:{get:function(){if(i.supportsFullscreen())return n.fullscreenerror}},enabled:{get:function(){if(i.supportsFullscreen())return document[n.fullscreenEnabled]}},fullscreen:{get:function(){if(i.supportsFullscreen())return null!==i.element}}}),i.supportsFullscreen=function(){if(e(r))return r;r=!1;var t=document.body;if("function"==typeof t.requestFullscreen)return n.requestFullscreen="requestFullscreen",n.exitFullscreen="exitFullscreen",n.fullscreenEnabled="fullscreenEnabled",n.fullscreenElement="fullscreenElement",n.fullscreenchange="fullscreenchange",n.fullscreenerror="fullscreenerror",r=!0;for(var i,o=["webkit","moz","o","ms","khtml"],a=0,u=o.length;a<u;++a){var s=o[a];("function"==typeof t[i=s+"RequestFullscreen"]||"function"==typeof t[i=s+"RequestFullScreen"])&&(n.requestFullscreen=i,r=!0),i=s+"ExitFullscreen","function"==typeof document[i]?n.exitFullscreen=i:(i=s+"CancelFullScreen","function"==typeof document[i]&&(n.exitFullscreen=i)),i=s+"FullscreenEnabled",void 0!==document[i]?n.fullscreenEnabled=i:(i=s+"FullScreenEnabled",void 0!==document[i]&&(n.fullscreenEnabled=i)),i=s+"FullscreenElement",void 0!==document[i]?n.fullscreenElement=i:(i=s+"FullScreenElement",void 0!==document[i]&&(n.fullscreenElement=i)),i=s+"fullscreenchange",void 0!==document["on"+i]&&("ms"===s&&(i="MSFullscreenChange"),n.fullscreenchange=i),i=s+"fullscreenerror",void 0!==document["on"+i]&&("ms"===s&&(i="MSFullscreenError"),n.fullscreenerror=i)}return r},i.requestFullscreen=function(e,t){i.supportsFullscreen()&&e[n.requestFullscreen]({vrDisplay:t})},i.exitFullscreen=function(){i.supportsFullscreen()&&document[n.exitFullscreen]()},i})),define("Core/FeatureDetection",["./defaultValue","./defined","./Fullscreen"],(function(e,t,r){"use strict";var n,i,o,a,u,s,c,l,f,p,h,d,y,m,E,O,v;function w(e){for(var t=e.split("."),r=0,n=t.length;r<n;++r)t[r]=parseInt(t[r],10);return t}function _(){if(!t(i)&&(i=!1,!R())){var e=/ Chrome\/([\.0-9]+)/.exec(n.userAgent);null!==e&&(i=!0,o=w(e[1]))}return i}function g(){if(!t(a)&&(a=!1,!_()&&!R()&&/ Safari\/[\.0-9]+/.test(n.userAgent))){var e=/ Version\/([\.0-9]+)/.exec(n.userAgent);null!==e&&(a=!0,u=w(e[1]))}return a}function T(){if(!t(s)){s=!1;var e=/ AppleWebKit\/([\.0-9]+)(\+?)/.exec(n.userAgent);null!==e&&(s=!0,(c=w(e[1])).isNightly=!!e[2])}return s}function b(){var e;return t(l)||(l=!1,"Microsoft Internet Explorer"===n.appName?null!==(e=/MSIE ([0-9]{1,}[\.0-9]{0,})/.exec(n.userAgent))&&(l=!0,f=w(e[1])):"Netscape"===n.appName&&null!==(e=/Trident\/.*rv:([0-9]{1,}[\.0-9]{0,})/.exec(n.userAgent))&&(l=!0,f=w(e[1]))),l}function R(){if(!t(p)){p=!1;var e=/ Edge\/([\.0-9]+)/.exec(n.userAgent);null!==e&&(p=!0,h=w(e[1]))}return p}function A(){if(!t(d)){d=!1;var e=/Firefox\/([\.0-9]+)/.exec(n.userAgent);null!==e&&(d=!0,y=w(e[1]))}return d}function x(){if(!t(v)){var e=document.createElement("canvas");e.setAttribute("style","image-rendering: -moz-crisp-edges;image-rendering: pixelated;");var r=e.style.imageRendering;(v=t(r)&&""!==r)&&(O=r)}return v}n="undefined"!=typeof navigator?navigator:{};var S=[];"undefined"!=typeof ArrayBuffer&&(S.push(Int8Array,Uint8Array,Int16Array,Uint16Array,Int32Array,Uint32Array,Float32Array,Float64Array),"undefined"!=typeof Uint8ClampedArray&&S.push(Uint8ClampedArray),"undefined"!=typeof CanvasPixelArray&&S.push(CanvasPixelArray));var N={isChrome:_,chromeVersion:function(){return _()&&o},isSafari:g,safariVersion:function(){return g()&&u},isWebkit:T,webkitVersion:function(){return T()&&c},isInternetExplorer:b,internetExplorerVersion:function(){return b()&&f},isEdge:R,edgeVersion:function(){return R()&&h},isFirefox:A,firefoxVersion:function(){return A()&&y},isWindows:function(){return t(m)||(m=/Windows/i.test(n.appVersion)),m},hardwareConcurrency:e(n.hardwareConcurrency,3),supportsPointerEvents:function(){return t(E)||(E=!A()&&"undefined"!=typeof PointerEvent&&(!t(n.pointerEnabled)||n.pointerEnabled)),E},supportsImageRenderingPixelated:x,imageRenderingValue:function(){return x()?O:void 0},typedArrayTypes:S,supportsFullscreen:function(){return r.supportsFullscreen()},supportsTypedArrays:function(){return"undefined"!=typeof ArrayBuffer},supportsWebWorkers:function(){return"undefined"!=typeof Worker},supportsWebAssembly:function(){return"undefined"!=typeof WebAssembly&&!N.isEdge()}};return N})),define("Core/WebGLConstants",["./freezeObject"],(function(e){"use strict";return e({DEPTH_BUFFER_BIT:256,STENCIL_BUFFER_BIT:1024,COLOR_BUFFER_BIT:16384,POINTS:0,LINES:1,LINE_LOOP:2,LINE_STRIP:3,TRIANGLES:4,TRIANGLE_STRIP:5,TRIANGLE_FAN:6,ZERO:0,ONE:1,SRC_COLOR:768,ONE_MINUS_SRC_COLOR:769,SRC_ALPHA:770,ONE_MINUS_SRC_ALPHA:771,DST_ALPHA:772,ONE_MINUS_DST_ALPHA:773,DST_COLOR:774,ONE_MINUS_DST_COLOR:775,SRC_ALPHA_SATURATE:776,FUNC_ADD:32774,BLEND_EQUATION:32777,BLEND_EQUATION_RGB:32777,BLEND_EQUATION_ALPHA:34877,FUNC_SUBTRACT:32778,FUNC_REVERSE_SUBTRACT:32779,BLEND_DST_RGB:32968,BLEND_SRC_RGB:32969,BLEND_DST_ALPHA:32970,BLEND_SRC_ALPHA:32971,CONSTANT_COLOR:32769,ONE_MINUS_CONSTANT_COLOR:32770,CONSTANT_ALPHA:32771,ONE_MINUS_CONSTANT_ALPHA:32772,BLEND_COLOR:32773,ARRAY_BUFFER:34962,ELEMENT_ARRAY_BUFFER:34963,ARRAY_BUFFER_BINDING:34964,ELEMENT_ARRAY_BUFFER_BINDING:34965,STREAM_DRAW:35040,STATIC_DRAW:35044,DYNAMIC_DRAW:35048,BUFFER_SIZE:34660,BUFFER_USAGE:34661,CURRENT_VERTEX_ATTRIB:34342,FRONT:1028,BACK:1029,FRONT_AND_BACK:1032,CULL_FACE:2884,BLEND:3042,DITHER:3024,STENCIL_TEST:2960,DEPTH_TEST:2929,SCISSOR_TEST:3089,POLYGON_OFFSET_FILL:32823,SAMPLE_ALPHA_TO_COVERAGE:32926,SAMPLE_COVERAGE:32928,NO_ERROR:0,INVALID_ENUM:1280,INVALID_VALUE:1281,INVALID_OPERATION:1282,OUT_OF_MEMORY:1285,CW:2304,CCW:2305,LINE_WIDTH:2849,ALIASED_POINT_SIZE_RANGE:33901,ALIASED_LINE_WIDTH_RANGE:33902,CULL_FACE_MODE:2885,FRONT_FACE:2886,DEPTH_RANGE:2928,DEPTH_WRITEMASK:2930,DEPTH_CLEAR_VALUE:2931,DEPTH_FUNC:2932,STENCIL_CLEAR_VALUE:2961,STENCIL_FUNC:2962,STENCIL_FAIL:2964,STENCIL_PASS_DEPTH_FAIL:2965,STENCIL_PASS_DEPTH_PASS:2966,STENCIL_REF:2967,STENCIL_VALUE_MASK:2963,STENCIL_WRITEMASK:2968,STENCIL_BACK_FUNC:34816,STENCIL_BACK_FAIL:34817,STENCIL_BACK_PASS_DEPTH_FAIL:34818,STENCIL_BACK_PASS_DEPTH_PASS:34819,STENCIL_BACK_REF:36003,STENCIL_BACK_VALUE_MASK:36004,STENCIL_BACK_WRITEMASK:36005,VIEWPORT:2978,SCISSOR_BOX:3088,COLOR_CLEAR_VALUE:3106,COLOR_WRITEMASK:3107,UNPACK_ALIGNMENT:3317,PACK_ALIGNMENT:3333,MAX_TEXTURE_SIZE:3379,MAX_VIEWPORT_DIMS:3386,SUBPIXEL_BITS:3408,RED_BITS:3410,GREEN_BITS:3411,BLUE_BITS:3412,ALPHA_BITS:3413,DEPTH_BITS:3414,STENCIL_BITS:3415,POLYGON_OFFSET_UNITS:10752,POLYGON_OFFSET_FACTOR:32824,TEXTURE_BINDING_2D:32873,SAMPLE_BUFFERS:32936,SAMPLES:32937,SAMPLE_COVERAGE_VALUE:32938,SAMPLE_COVERAGE_INVERT:32939,COMPRESSED_TEXTURE_FORMATS:34467,DONT_CARE:4352,FASTEST:4353,NICEST:4354,GENERATE_MIPMAP_HINT:33170,BYTE:5120,UNSIGNED_BYTE:5121,SHORT:5122,UNSIGNED_SHORT:5123,INT:5124,UNSIGNED_INT:5125,FLOAT:5126,DEPTH_COMPONENT:6402,ALPHA:6406,RGB:6407,RGBA:6408,LUMINANCE:6409,LUMINANCE_ALPHA:6410,UNSIGNED_SHORT_4_4_4_4:32819,UNSIGNED_SHORT_5_5_5_1:32820,UNSIGNED_SHORT_5_6_5:33635,FRAGMENT_SHADER:35632,VERTEX_SHADER:35633,MAX_VERTEX_ATTRIBS:34921,MAX_VERTEX_UNIFORM_VECTORS:36347,MAX_VARYING_VECTORS:36348,MAX_COMBINED_TEXTURE_IMAGE_UNITS:35661,MAX_VERTEX_TEXTURE_IMAGE_UNITS:35660,MAX_TEXTURE_IMAGE_UNITS:34930,MAX_FRAGMENT_UNIFORM_VECTORS:36349,SHADER_TYPE:35663,DELETE_STATUS:35712,LINK_STATUS:35714,VALIDATE_STATUS:35715,ATTACHED_SHADERS:35717,ACTIVE_UNIFORMS:35718,ACTIVE_ATTRIBUTES:35721,SHADING_LANGUAGE_VERSION:35724,CURRENT_PROGRAM:35725,NEVER:512,LESS:513,EQUAL:514,LEQUAL:515,GREATER:516,NOTEQUAL:517,GEQUAL:518,ALWAYS:519,KEEP:7680,REPLACE:7681,INCR:7682,DECR:7683,INVERT:5386,INCR_WRAP:34055,DECR_WRAP:34056,VENDOR:7936,RENDERER:7937,VERSION:7938,NEAREST:9728,LINEAR:9729,NEAREST_MIPMAP_NEAREST:9984,LINEAR_MIPMAP_NEAREST:9985,NEAREST_MIPMAP_LINEAR:9986,LINEAR_MIPMAP_LINEAR:9987,TEXTURE_MAG_FILTER:10240,TEXTURE_MIN_FILTER:10241,TEXTURE_WRAP_S:10242,TEXTURE_WRAP_T:10243,TEXTURE_2D:3553,TEXTURE:5890,TEXTURE_CUBE_MAP:34067,TEXTURE_BINDING_CUBE_MAP:34068,TEXTURE_CUBE_MAP_POSITIVE_X:34069,TEXTURE_CUBE_MAP_NEGATIVE_X:34070,TEXTURE_CUBE_MAP_POSITIVE_Y:34071,TEXTURE_CUBE_MAP_NEGATIVE_Y:34072,TEXTURE_CUBE_MAP_POSITIVE_Z:34073,TEXTURE_CUBE_MAP_NEGATIVE_Z:34074,MAX_CUBE_MAP_TEXTURE_SIZE:34076,TEXTURE0:33984,TEXTURE1:33985,TEXTURE2:33986,TEXTURE3:33987,TEXTURE4:33988,TEXTURE5:33989,TEXTURE6:33990,TEXTURE7:33991,TEXTURE8:33992,TEXTURE9:33993,TEXTURE10:33994,TEXTURE11:33995,TEXTURE12:33996,TEXTURE13:33997,TEXTURE14:33998,TEXTURE15:33999,TEXTURE16:34e3,TEXTURE17:34001,TEXTURE18:34002,TEXTURE19:34003,TEXTURE20:34004,TEXTURE21:34005,TEXTURE22:34006,TEXTURE23:34007,TEXTURE24:34008,TEXTURE25:34009,TEXTURE26:34010,TEXTURE27:34011,TEXTURE28:34012,TEXTURE29:34013,TEXTURE30:34014,TEXTURE31:34015,ACTIVE_TEXTURE:34016,REPEAT:10497,CLAMP_TO_EDGE:33071,MIRRORED_REPEAT:33648,FLOAT_VEC2:35664,FLOAT_VEC3:35665,FLOAT_VEC4:35666,INT_VEC2:35667,INT_VEC3:35668,INT_VEC4:35669,BOOL:35670,BOOL_VEC2:35671,BOOL_VEC3:35672,BOOL_VEC4:35673,FLOAT_MAT2:35674,FLOAT_MAT3:35675,FLOAT_MAT4:35676,SAMPLER_2D:35678,SAMPLER_CUBE:35680,VERTEX_ATTRIB_ARRAY_ENABLED:34338,VERTEX_ATTRIB_ARRAY_SIZE:34339,VERTEX_ATTRIB_ARRAY_STRIDE:34340,VERTEX_ATTRIB_ARRAY_TYPE:34341,VERTEX_ATTRIB_ARRAY_NORMALIZED:34922,VERTEX_ATTRIB_ARRAY_POINTER:34373,VERTEX_ATTRIB_ARRAY_BUFFER_BINDING:34975,IMPLEMENTATION_COLOR_READ_TYPE:35738,IMPLEMENTATION_COLOR_READ_FORMAT:35739,COMPILE_STATUS:35713,LOW_FLOAT:36336,MEDIUM_FLOAT:36337,HIGH_FLOAT:36338,LOW_INT:36339,MEDIUM_INT:36340,HIGH_INT:36341,FRAMEBUFFER:36160,RENDERBUFFER:36161,RGBA4:32854,RGB5_A1:32855,RGB565:36194,DEPTH_COMPONENT16:33189,STENCIL_INDEX:6401,STENCIL_INDEX8:36168,DEPTH_STENCIL:34041,RENDERBUFFER_WIDTH:36162,RENDERBUFFER_HEIGHT:36163,RENDERBUFFER_INTERNAL_FORMAT:36164,RENDERBUFFER_RED_SIZE:36176,RENDERBUFFER_GREEN_SIZE:36177,RENDERBUFFER_BLUE_SIZE:36178,RENDERBUFFER_ALPHA_SIZE:36179,RENDERBUFFER_DEPTH_SIZE:36180,RENDERBUFFER_STENCIL_SIZE:36181,FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE:36048,FRAMEBUFFER_ATTACHMENT_OBJECT_NAME:36049,FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL:36050,FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE:36051,COLOR_ATTACHMENT0:36064,DEPTH_ATTACHMENT:36096,STENCIL_ATTACHMENT:36128,DEPTH_STENCIL_ATTACHMENT:33306,NONE:0,FRAMEBUFFER_COMPLETE:36053,FRAMEBUFFER_INCOMPLETE_ATTACHMENT:36054,FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT:36055,FRAMEBUFFER_INCOMPLETE_DIMENSIONS:36057,FRAMEBUFFER_UNSUPPORTED:36061,FRAMEBUFFER_BINDING:36006,RENDERBUFFER_BINDING:36007,MAX_RENDERBUFFER_SIZE:34024,INVALID_FRAMEBUFFER_OPERATION:1286,UNPACK_FLIP_Y_WEBGL:37440,UNPACK_PREMULTIPLY_ALPHA_WEBGL:37441,CONTEXT_LOST_WEBGL:37442,UNPACK_COLORSPACE_CONVERSION_WEBGL:37443,BROWSER_DEFAULT_WEBGL:37444,COMPRESSED_RGB_S3TC_DXT1_EXT:33776,COMPRESSED_RGBA_S3TC_DXT1_EXT:33777,COMPRESSED_RGBA_S3TC_DXT3_EXT:33778,COMPRESSED_RGBA_S3TC_DXT5_EXT:33779,COMPRESSED_RGB_PVRTC_4BPPV1_IMG:35840,COMPRESSED_RGB_PVRTC_2BPPV1_IMG:35841,COMPRESSED_RGBA_PVRTC_4BPPV1_IMG:35842,COMPRESSED_RGBA_PVRTC_2BPPV1_IMG:35843,COMPRESSED_RGB_ETC1_WEBGL:36196,HALF_FLOAT_OES:36193,DOUBLE:5130,READ_BUFFER:3074,UNPACK_ROW_LENGTH:3314,UNPACK_SKIP_ROWS:3315,UNPACK_SKIP_PIXELS:3316,PACK_ROW_LENGTH:3330,PACK_SKIP_ROWS:3331,PACK_SKIP_PIXELS:3332,COLOR:6144,DEPTH:6145,STENCIL:6146,RED:6403,RGB8:32849,RGBA8:32856,RGB10_A2:32857,TEXTURE_BINDING_3D:32874,UNPACK_SKIP_IMAGES:32877,UNPACK_IMAGE_HEIGHT:32878,TEXTURE_3D:32879,TEXTURE_WRAP_R:32882,MAX_3D_TEXTURE_SIZE:32883,UNSIGNED_INT_2_10_10_10_REV:33640,MAX_ELEMENTS_VERTICES:33e3,MAX_ELEMENTS_INDICES:33001,TEXTURE_MIN_LOD:33082,TEXTURE_MAX_LOD:33083,TEXTURE_BASE_LEVEL:33084,TEXTURE_MAX_LEVEL:33085,MIN:32775,MAX:32776,DEPTH_COMPONENT24:33190,MAX_TEXTURE_LOD_BIAS:34045,TEXTURE_COMPARE_MODE:34892,TEXTURE_COMPARE_FUNC:34893,CURRENT_QUERY:34917,QUERY_RESULT:34918,QUERY_RESULT_AVAILABLE:34919,STREAM_READ:35041,STREAM_COPY:35042,STATIC_READ:35045,STATIC_COPY:35046,DYNAMIC_READ:35049,DYNAMIC_COPY:35050,MAX_DRAW_BUFFERS:34852,DRAW_BUFFER0:34853,DRAW_BUFFER1:34854,DRAW_BUFFER2:34855,DRAW_BUFFER3:34856,DRAW_BUFFER4:34857,DRAW_BUFFER5:34858,DRAW_BUFFER6:34859,DRAW_BUFFER7:34860,DRAW_BUFFER8:34861,DRAW_BUFFER9:34862,DRAW_BUFFER10:34863,DRAW_BUFFER11:34864,DRAW_BUFFER12:34865,DRAW_BUFFER13:34866,DRAW_BUFFER14:34867,DRAW_BUFFER15:34868,MAX_FRAGMENT_UNIFORM_COMPONENTS:35657,MAX_VERTEX_UNIFORM_COMPONENTS:35658,SAMPLER_3D:35679,SAMPLER_2D_SHADOW:35682,FRAGMENT_SHADER_DERIVATIVE_HINT:35723,PIXEL_PACK_BUFFER:35051,PIXEL_UNPACK_BUFFER:35052,PIXEL_PACK_BUFFER_BINDING:35053,PIXEL_UNPACK_BUFFER_BINDING:35055,FLOAT_MAT2x3:35685,FLOAT_MAT2x4:35686,FLOAT_MAT3x2:35687,FLOAT_MAT3x4:35688,FLOAT_MAT4x2:35689,FLOAT_MAT4x3:35690,SRGB:35904,SRGB8:35905,SRGB8_ALPHA8:35907,COMPARE_REF_TO_TEXTURE:34894,RGBA32F:34836,RGB32F:34837,RGBA16F:34842,RGB16F:34843,VERTEX_ATTRIB_ARRAY_INTEGER:35069,MAX_ARRAY_TEXTURE_LAYERS:35071,MIN_PROGRAM_TEXEL_OFFSET:35076,MAX_PROGRAM_TEXEL_OFFSET:35077,MAX_VARYING_COMPONENTS:35659,TEXTURE_2D_ARRAY:35866,TEXTURE_BINDING_2D_ARRAY:35869,R11F_G11F_B10F:35898,UNSIGNED_INT_10F_11F_11F_REV:35899,RGB9_E5:35901,UNSIGNED_INT_5_9_9_9_REV:35902,TRANSFORM_FEEDBACK_BUFFER_MODE:35967,MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS:35968,TRANSFORM_FEEDBACK_VARYINGS:35971,TRANSFORM_FEEDBACK_BUFFER_START:35972,TRANSFORM_FEEDBACK_BUFFER_SIZE:35973,TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN:35976,RASTERIZER_DISCARD:35977,MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS:35978,MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS:35979,INTERLEAVED_ATTRIBS:35980,SEPARATE_ATTRIBS:35981,TRANSFORM_FEEDBACK_BUFFER:35982,TRANSFORM_FEEDBACK_BUFFER_BINDING:35983,RGBA32UI:36208,RGB32UI:36209,RGBA16UI:36214,RGB16UI:36215,RGBA8UI:36220,RGB8UI:36221,RGBA32I:36226,RGB32I:36227,RGBA16I:36232,RGB16I:36233,RGBA8I:36238,RGB8I:36239,RED_INTEGER:36244,RGB_INTEGER:36248,RGBA_INTEGER:36249,SAMPLER_2D_ARRAY:36289,SAMPLER_2D_ARRAY_SHADOW:36292,SAMPLER_CUBE_SHADOW:36293,UNSIGNED_INT_VEC2:36294,UNSIGNED_INT_VEC3:36295,UNSIGNED_INT_VEC4:36296,INT_SAMPLER_2D:36298,INT_SAMPLER_3D:36299,INT_SAMPLER_CUBE:36300,INT_SAMPLER_2D_ARRAY:36303,UNSIGNED_INT_SAMPLER_2D:36306,UNSIGNED_INT_SAMPLER_3D:36307,UNSIGNED_INT_SAMPLER_CUBE:36308,UNSIGNED_INT_SAMPLER_2D_ARRAY:36311,DEPTH_COMPONENT32F:36012,DEPTH32F_STENCIL8:36013,FLOAT_32_UNSIGNED_INT_24_8_REV:36269,FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING:33296,FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE:33297,FRAMEBUFFER_ATTACHMENT_RED_SIZE:33298,FRAMEBUFFER_ATTACHMENT_GREEN_SIZE:33299,FRAMEBUFFER_ATTACHMENT_BLUE_SIZE:33300,FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE:33301,FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE:33302,FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE:33303,FRAMEBUFFER_DEFAULT:33304,UNSIGNED_INT_24_8:34042,DEPTH24_STENCIL8:35056,UNSIGNED_NORMALIZED:35863,DRAW_FRAMEBUFFER_BINDING:36006,READ_FRAMEBUFFER:36008,DRAW_FRAMEBUFFER:36009,READ_FRAMEBUFFER_BINDING:36010,RENDERBUFFER_SAMPLES:36011,FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER:36052,MAX_COLOR_ATTACHMENTS:36063,COLOR_ATTACHMENT1:36065,COLOR_ATTACHMENT2:36066,COLOR_ATTACHMENT3:36067,COLOR_ATTACHMENT4:36068,COLOR_ATTACHMENT5:36069,COLOR_ATTACHMENT6:36070,COLOR_ATTACHMENT7:36071,COLOR_ATTACHMENT8:36072,COLOR_ATTACHMENT9:36073,COLOR_ATTACHMENT10:36074,COLOR_ATTACHMENT11:36075,COLOR_ATTACHMENT12:36076,COLOR_ATTACHMENT13:36077,COLOR_ATTACHMENT14:36078,COLOR_ATTACHMENT15:36079,FRAMEBUFFER_INCOMPLETE_MULTISAMPLE:36182,MAX_SAMPLES:36183,HALF_FLOAT:5131,RG:33319,RG_INTEGER:33320,R8:33321,RG8:33323,R16F:33325,R32F:33326,RG16F:33327,RG32F:33328,R8I:33329,R8UI:33330,R16I:33331,R16UI:33332,R32I:33333,R32UI:33334,RG8I:33335,RG8UI:33336,RG16I:33337,RG16UI:33338,RG32I:33339,RG32UI:33340,VERTEX_ARRAY_BINDING:34229,R8_SNORM:36756,RG8_SNORM:36757,RGB8_SNORM:36758,RGBA8_SNORM:36759,SIGNED_NORMALIZED:36764,COPY_READ_BUFFER:36662,COPY_WRITE_BUFFER:36663,COPY_READ_BUFFER_BINDING:36662,COPY_WRITE_BUFFER_BINDING:36663,UNIFORM_BUFFER:35345,UNIFORM_BUFFER_BINDING:35368,UNIFORM_BUFFER_START:35369,UNIFORM_BUFFER_SIZE:35370,MAX_VERTEX_UNIFORM_BLOCKS:35371,MAX_FRAGMENT_UNIFORM_BLOCKS:35373,MAX_COMBINED_UNIFORM_BLOCKS:35374,MAX_UNIFORM_BUFFER_BINDINGS:35375,MAX_UNIFORM_BLOCK_SIZE:35376,MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS:35377,MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS:35379,UNIFORM_BUFFER_OFFSET_ALIGNMENT:35380,ACTIVE_UNIFORM_BLOCKS:35382,UNIFORM_TYPE:35383,UNIFORM_SIZE:35384,UNIFORM_BLOCK_INDEX:35386,UNIFORM_OFFSET:35387,UNIFORM_ARRAY_STRIDE:35388,UNIFORM_MATRIX_STRIDE:35389,UNIFORM_IS_ROW_MAJOR:35390,UNIFORM_BLOCK_BINDING:35391,UNIFORM_BLOCK_DATA_SIZE:35392,UNIFORM_BLOCK_ACTIVE_UNIFORMS:35394,UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES:35395,UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER:35396,UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER:35398,INVALID_INDEX:4294967295,MAX_VERTEX_OUTPUT_COMPONENTS:37154,MAX_FRAGMENT_INPUT_COMPONENTS:37157,MAX_SERVER_WAIT_TIMEOUT:37137,OBJECT_TYPE:37138,SYNC_CONDITION:37139,SYNC_STATUS:37140,SYNC_FLAGS:37141,SYNC_FENCE:37142,SYNC_GPU_COMMANDS_COMPLETE:37143,UNSIGNALED:37144,SIGNALED:37145,ALREADY_SIGNALED:37146,TIMEOUT_EXPIRED:37147,CONDITION_SATISFIED:37148,WAIT_FAILED:37149,SYNC_FLUSH_COMMANDS_BIT:1,VERTEX_ATTRIB_ARRAY_DIVISOR:35070,ANY_SAMPLES_PASSED:35887,ANY_SAMPLES_PASSED_CONSERVATIVE:36202,SAMPLER_BINDING:35097,RGB10_A2UI:36975,INT_2_10_10_10_REV:36255,TRANSFORM_FEEDBACK:36386,TRANSFORM_FEEDBACK_PAUSED:36387,TRANSFORM_FEEDBACK_ACTIVE:36388,TRANSFORM_FEEDBACK_BINDING:36389,COMPRESSED_R11_EAC:37488,COMPRESSED_SIGNED_R11_EAC:37489,COMPRESSED_RG11_EAC:37490,COMPRESSED_SIGNED_RG11_EAC:37491,COMPRESSED_RGB8_ETC2:37492,COMPRESSED_SRGB8_ETC2:37493,COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2:37494,COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2:37495,COMPRESSED_RGBA8_ETC2_EAC:37496,COMPRESSED_SRGB8_ALPHA8_ETC2_EAC:37497,TEXTURE_IMMUTABLE_FORMAT:37167,MAX_ELEMENT_INDEX:36203,TEXTURE_IMMUTABLE_LEVELS:33503,MAX_TEXTURE_MAX_ANISOTROPY_EXT:34047})})),define("Core/ComponentDatatype",["./defaultValue","./defined","./DeveloperError","./FeatureDetection","./freezeObject","./WebGLConstants"],(function(e,t,r,n,i,o){"use strict";if(!n.supportsTypedArrays())return{};var a={BYTE:o.BYTE,UNSIGNED_BYTE:o.UNSIGNED_BYTE,SHORT:o.SHORT,UNSIGNED_SHORT:o.UNSIGNED_SHORT,INT:o.INT,UNSIGNED_INT:o.UNSIGNED_INT,FLOAT:o.FLOAT,DOUBLE:o.DOUBLE,getSizeInBytes:function(e){if(!t(e))throw new r("value is required.");switch(e){case a.BYTE:return Int8Array.BYTES_PER_ELEMENT;case a.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case a.SHORT:return Int16Array.BYTES_PER_ELEMENT;case a.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case a.INT:return Int32Array.BYTES_PER_ELEMENT;case a.UNSIGNED_INT:return Uint32Array.BYTES_PER_ELEMENT;case a.FLOAT:return Float32Array.BYTES_PER_ELEMENT;case a.DOUBLE:return Float64Array.BYTES_PER_ELEMENT;default:throw new r("componentDatatype is not a valid value.")}},fromTypedArray:function(e){return e instanceof Int8Array?a.BYTE:e instanceof Uint8Array?a.UNSIGNED_BYTE:e instanceof Int16Array?a.SHORT:e instanceof Uint16Array?a.UNSIGNED_SHORT:e instanceof Int32Array?a.INT:e instanceof Uint32Array?a.UNSIGNED_INT:e instanceof Float32Array?a.FLOAT:e instanceof Float64Array?a.DOUBLE:void 0},validate:function(e){return t(e)&&(e===a.BYTE||e===a.UNSIGNED_BYTE||e===a.SHORT||e===a.UNSIGNED_SHORT||e===a.INT||e===a.UNSIGNED_INT||e===a.FLOAT||e===a.DOUBLE)},createTypedArray:function(e,n){if(!t(e))throw new r("componentDatatype is required.");if(!t(n))throw new r("valuesOrLength is required.");switch(e){case a.BYTE:return new Int8Array(n);case a.UNSIGNED_BYTE:return new Uint8Array(n);case a.SHORT:return new Int16Array(n);case a.UNSIGNED_SHORT:return new Uint16Array(n);case a.INT:return new Int32Array(n);case a.UNSIGNED_INT:return new Uint32Array(n);case a.FLOAT:return new Float32Array(n);case a.DOUBLE:return new Float64Array(n);default:throw new r("componentDatatype is not a valid value.")}},createArrayBufferView:function(n,i,o,u){if(!t(n))throw new r("componentDatatype is required.");if(!t(i))throw new r("buffer is required.");switch(o=e(o,0),u=e(u,(i.byteLength-o)/a.getSizeInBytes(n)),n){case a.BYTE:return new Int8Array(i,o,u);case a.UNSIGNED_BYTE:return new Uint8Array(i,o,u);case a.SHORT:return new Int16Array(i,o,u);case a.UNSIGNED_SHORT:return new Uint16Array(i,o,u);case a.INT:return new Int32Array(i,o,u);case a.UNSIGNED_INT:return new Uint32Array(i,o,u);case a.FLOAT:return new Float32Array(i,o,u);case a.DOUBLE:return new Float64Array(i,o,u);default:throw new r("componentDatatype is not a valid value.")}},fromName:function(e){switch(e){case"BYTE":return a.BYTE;case"UNSIGNED_BYTE":return a.UNSIGNED_BYTE;case"SHORT":return a.SHORT;case"UNSIGNED_SHORT":return a.UNSIGNED_SHORT;case"INT":return a.INT;case"UNSIGNED_INT":return a.UNSIGNED_INT;case"FLOAT":return a.FLOAT;case"DOUBLE":return a.DOUBLE;default:throw new r("name is not a valid value.")}}};return i(a)})),define("Core/AxisAlignedBoundingBox",["./Cartesian3","./Check","./defaultValue","./defined","./Intersect"],(function(e,t,r,n,i){"use strict";function o(t,i,o){this.minimum=e.clone(r(t,e.ZERO)),this.maximum=e.clone(r(i,e.ZERO)),o=n(o)?e.clone(o):e.midpoint(this.minimum,this.maximum,new e),this.center=o}o.fromPoints=function(t,r){if(n(r)||(r=new o),!n(t)||0===t.length)return r.minimum=e.clone(e.ZERO,r.minimum),r.maximum=e.clone(e.ZERO,r.maximum),r.center=e.clone(e.ZERO,r.center),r;for(var i=t[0].x,a=t[0].y,u=t[0].z,s=t[0].x,c=t[0].y,l=t[0].z,f=t.length,p=1;p<f;p++){var h=t[p],d=h.x,y=h.y,m=h.z;i=Math.min(d,i),s=Math.max(d,s),a=Math.min(y,a),c=Math.max(y,c),u=Math.min(m,u),l=Math.max(m,l)}var E=r.minimum;E.x=i,E.y=a,E.z=u;var O=r.maximum;return O.x=s,O.y=c,O.z=l,r.center=e.midpoint(E,O,r.center),r},o.clone=function(t,r){if(n(t))return n(r)?(r.minimum=e.clone(t.minimum,r.minimum),r.maximum=e.clone(t.maximum,r.maximum),r.center=e.clone(t.center,r.center),r):new o(t.minimum,t.maximum,t.center)},o.equals=function(t,r){return t===r||n(t)&&n(r)&&e.equals(t.center,r.center)&&e.equals(t.minimum,r.minimum)&&e.equals(t.maximum,r.maximum)};var a=new e;return o.intersectPlane=function(r,n){t.defined("box",r),t.defined("plane",n),a=e.subtract(r.maximum,r.minimum,a);var o=e.multiplyByScalar(a,.5,a),u=n.normal,s=o.x*Math.abs(u.x)+o.y*Math.abs(u.y)+o.z*Math.abs(u.z),c=e.dot(r.center,u)+n.distance;return c-s>0?i.INSIDE:c+s<0?i.OUTSIDE:i.INTERSECTING},o.prototype.clone=function(e){return o.clone(this,e)},o.prototype.intersectPlane=function(e){return o.intersectPlane(this,e)},o.prototype.equals=function(e){return o.equals(this,e)},o})),define("Core/QuadraticRealPolynomial",["./DeveloperError","./Math"],(function(e,t){"use strict";var r={};function n(e,r,n){var i=e+r;return t.sign(e)!==t.sign(r)&&Math.abs(i/Math.max(Math.abs(e),Math.abs(r)))<n?0:i}return r.computeDiscriminant=function(t,r,n){if("number"!=typeof t)throw new e("a is a required number.");if("number"!=typeof r)throw new e("b is a required number.");if("number"!=typeof n)throw new e("c is a required number.");return r*r-4*t*n},r.computeRealRoots=function(r,i,o){if("number"!=typeof r)throw new e("a is a required number.");if("number"!=typeof i)throw new e("b is a required number.");if("number"!=typeof o)throw new e("c is a required number.");var a;if(0===r)return 0===i?[]:[-o/i];if(0===i){if(0===o)return[0,0];var u=Math.abs(o),s=Math.abs(r);if(u<s&&u/s<t.EPSILON14)return[0,0];if(u>s&&s/u<t.EPSILON14)return[];if((a=-o/r)<0)return[];var c=Math.sqrt(a);return[-c,c]}if(0===o)return(a=-i/r)<0?[a,0]:[0,a];var l=n(i*i,-4*r*o,t.EPSILON14);if(l<0)return[];var f=-.5*n(i,t.sign(i)*Math.sqrt(l),t.EPSILON14);return i>0?[f/r,o/f]:[o/f,f/r]},r})),define("Core/CubicRealPolynomial",["./DeveloperError","./QuadraticRealPolynomial"],(function(e,t){"use strict";var r={};function n(e,t,r,n){var i,o,a=e,u=t/3,s=r/3,c=n,l=a*s,f=u*c,p=u*u,h=s*s,d=a*s-p,y=a*c-u*s,m=u*c-h,E=4*d*m-y*y;if(E<0){var O,v,w;p*f>=l*h?(O=a,v=d,w=-2*u*d+a*y):(O=c,v=m,w=-c*y+2*s*m);var _=-(w<0?-1:1)*Math.abs(O)*Math.sqrt(-E),g=(o=-w+_)/2,T=g<0?-Math.pow(-g,1/3):Math.pow(g,1/3),b=o===_?-T:-v/T;return i=v<=0?T+b:-w/(T*T+b*b+v),p*f>=l*h?[(i-u)/a]:[-c/(i+s)]}var R=d,A=-2*u*d+a*y,x=m,S=-c*y+2*s*m,N=Math.sqrt(E),I=Math.sqrt(3)/2,M=Math.abs(Math.atan2(a*N,-A)/3);i=2*Math.sqrt(-R);var C=Math.cos(M);o=i*C;var P=i*(-C/2-I*Math.sin(M)),D=o+P>2*u?o-u:P-u,U=a,L=D/U;M=Math.abs(Math.atan2(c*N,-S)/3);var q=-c,F=(o=(i=2*Math.sqrt(-x))*(C=Math.cos(M)))+(P=i*(-C/2-I*Math.sin(M)))<2*s?o+s:P+s,j=q/F,B=-D*F-U*q,z=(s*B-u*(D*q))/(-u*B+s*(U*F));return L<=z?L<=j?z<=j?[L,z,j]:[L,j,z]:[j,L,z]:L<=j?[z,L,j]:z<=j?[z,j,L]:[j,z,L]}return r.computeDiscriminant=function(t,r,n,i){if("number"!=typeof t)throw new e("a is a required number.");if("number"!=typeof r)throw new e("b is a required number.");if("number"!=typeof n)throw new e("c is a required number.");if("number"!=typeof i)throw new e("d is a required number.");var o=r*r,a=n*n;return 18*t*r*n*i+o*a-t*t*27*(i*i)-4*(t*a*n+o*r*i)},r.computeRealRoots=function(r,i,o,a){if("number"!=typeof r)throw new e("a is a required number.");if("number"!=typeof i)throw new e("b is a required number.");if("number"!=typeof o)throw new e("c is a required number.");if("number"!=typeof a)throw new e("d is a required number.");var u,s;if(0===r)return t.computeRealRoots(i,o,a);if(0===i){if(0===o){if(0===a)return[0,0,0];var c=(s=-a/r)<0?-Math.pow(-s,1/3):Math.pow(s,1/3);return[c,c,c]}return 0===a?0===(u=t.computeRealRoots(r,0,o)).Length?[0]:[u[0],0,u[1]]:n(r,0,o,a)}return 0===o?0===a?(s=-i/r)<0?[s,0,0]:[0,0,s]:n(r,i,0,a):0===a?0===(u=t.computeRealRoots(r,i,o)).length?[0]:u[1]<=0?[u[0],u[1],0]:u[0]>=0?[0,u[0],u[1]]:[u[0],0,u[1]]:n(r,i,o,a)},r})),define("Core/QuarticRealPolynomial",["./CubicRealPolynomial","./DeveloperError","./Math","./QuadraticRealPolynomial"],(function(e,t,r,n){"use strict";var i={};function o(t,i,o,a){var u=t*t,s=i-3*u/8,c=o-i*t/2+u*t/8,l=a-o*t/4+i*u/16-3*u*u/256,f=e.computeRealRoots(1,2*s,s*s-4*l,-c*c);if(f.length>0){var p=-t/4,h=f[f.length-1];if(Math.abs(h)<r.EPSILON14){var d=n.computeRealRoots(1,s,l);if(2===d.length){var y,m=d[0],E=d[1];if(m>=0&&E>=0){var O=Math.sqrt(m),v=Math.sqrt(E);return[p-v,p-O,p+O,p+v]}if(m>=0&&E<0)return[p-(y=Math.sqrt(m)),p+y];if(m<0&&E>=0)return[p-(y=Math.sqrt(E)),p+y]}return[]}if(h>0){var w=Math.sqrt(h),_=(s+h-c/w)/2,g=(s+h+c/w)/2,T=n.computeRealRoots(1,w,_),b=n.computeRealRoots(1,-w,g);return 0!==T.length?(T[0]+=p,T[1]+=p,0!==b.length?(b[0]+=p,b[1]+=p,T[1]<=b[0]?[T[0],T[1],b[0],b[1]]:b[1]<=T[0]?[b[0],b[1],T[0],T[1]]:T[0]>=b[0]&&T[1]<=b[1]?[b[0],T[0],T[1],b[1]]:b[0]>=T[0]&&b[1]<=T[1]?[T[0],b[0],b[1],T[1]]:T[0]>b[0]&&T[0]<b[1]?[b[0],T[0],b[1],T[1]]:[T[0],b[0],T[1],b[1]]):T):0!==b.length?(b[0]+=p,b[1]+=p,b):[]}}return[]}function a(t,i,o,a){var u=t*t,s=-2*i,c=o*t+i*i-4*a,l=u*a-o*i*t+o*o,f=e.computeRealRoots(1,s,c,l);if(f.length>0){var p,h,d,y,m,E,O=f[0],v=i-O,w=v*v,_=t/2,g=v/2,T=w-4*a,b=w+4*Math.abs(a),R=u-4*O,A=u+4*Math.abs(O);if(O<0||T*A<R*b){var x=Math.sqrt(R);p=x/2,h=0===x?0:(t*g-o)/x}else{var S=Math.sqrt(T);p=0===S?0:(t*g-o)/S,h=S/2}0===_&&0===p?(d=0,y=0):r.sign(_)===r.sign(p)?y=O/(d=_+p):d=O/(y=_-p),0===g&&0===h?(m=0,E=0):r.sign(g)===r.sign(h)?E=a/(m=g+h):m=a/(E=g-h);var N=n.computeRealRoots(1,d,m),I=n.computeRealRoots(1,y,E);if(0!==N.length)return 0!==I.length?N[1]<=I[0]?[N[0],N[1],I[0],I[1]]:I[1]<=N[0]?[I[0],I[1],N[0],N[1]]:N[0]>=I[0]&&N[1]<=I[1]?[I[0],N[0],N[1],I[1]]:I[0]>=N[0]&&I[1]<=N[1]?[N[0],I[0],I[1],N[1]]:N[0]>I[0]&&N[0]<I[1]?[I[0],N[0],I[1],N[1]]:[N[0],I[0],N[1],I[1]]:N;if(0!==I.length)return I}return[]}return i.computeDiscriminant=function(e,r,n,i,o){if("number"!=typeof e)throw new t("a is a required number.");if("number"!=typeof r)throw new t("b is a required number.");if("number"!=typeof n)throw new t("c is a required number.");if("number"!=typeof i)throw new t("d is a required number.");if("number"!=typeof o)throw new t("e is a required number.");var a=e*e,u=r*r,s=u*r,c=n*n,l=c*n,f=i*i,p=f*i,h=o*o;return u*c*f-4*s*p-4*e*l*f+18*e*r*n*p-27*a*f*f+a*e*256*(h*o)+o*(18*s*n*i-4*u*l+16*e*c*c-80*e*r*c*i-6*e*u*f+144*a*n*f)+h*(144*e*u*n-27*u*u-128*a*c-192*a*r*i)},i.computeRealRoots=function(n,i,u,s,c){if("number"!=typeof n)throw new t("a is a required number.");if("number"!=typeof i)throw new t("b is a required number.");if("number"!=typeof u)throw new t("c is a required number.");if("number"!=typeof s)throw new t("d is a required number.");if("number"!=typeof c)throw new t("e is a required number.");if(Math.abs(n)<r.EPSILON15)return e.computeRealRoots(i,u,s,c);var l=i/n,f=u/n,p=s/n,h=c/n,d=l<0?1:0;switch(d+=f<0?d+1:d,d+=p<0?d+1:d,d+=h<0?d+1:d){case 0:return o(l,f,p,h);case 1:case 2:return a(l,f,p,h);case 3:case 4:return o(l,f,p,h);case 5:return a(l,f,p,h);case 6:case 7:return o(l,f,p,h);case 8:return a(l,f,p,h);case 9:case 10:return o(l,f,p,h);case 11:return a(l,f,p,h);case 12:case 13:case 14:case 15:return o(l,f,p,h);default:return}},i})),define("Core/Ray",["./Cartesian3","./Check","./defaultValue","./defined"],(function(e,t,r,n){"use strict";function i(t,n){n=e.clone(r(n,e.ZERO)),e.equals(n,e.ZERO)||e.normalize(n,n),this.origin=e.clone(r(t,e.ZERO)),this.direction=n}return i.clone=function(t,r){if(n(t))return n(r)?(r.origin=e.clone(t.origin),r.direction=e.clone(t.direction),r):new i(t.origin,t.direction)},i.getPoint=function(r,i,o){return t.typeOf.object("ray",r),t.typeOf.number("t",i),n(o)||(o=new e),o=e.multiplyByScalar(r.direction,i,o),e.add(r.origin,o,o)},i})),define("Core/IntersectionTests",["./Cartesian3","./Cartographic","./defaultValue","./defined","./DeveloperError","./Interval","./Math","./Matrix3","./QuadraticRealPolynomial","./QuarticRealPolynomial","./Ray"],(function(e,t,r,n,i,o,a,u,s,c,l){"use strict";var f={rayPlane:function(t,r,o){if(!n(t))throw new i("ray is required.");if(!n(r))throw new i("plane is required.");n(o)||(o=new e);var u=t.origin,s=t.direction,c=r.normal,l=e.dot(c,s);if(!(Math.abs(l)<a.EPSILON15)){var f=(-r.distance-e.dot(c,u))/l;if(!(f<0))return o=e.multiplyByScalar(s,f,o),e.add(u,o,o)}}},p=new e,h=new e,d=new e,y=new e,m=new e;f.rayTriangleParametric=function(t,o,u,s,c){if(!n(t))throw new i("ray is required.");if(!n(o))throw new i("p0 is required.");if(!n(u))throw new i("p1 is required.");if(!n(s))throw new i("p2 is required.");c=r(c,!1);var l,f,E,O,v,w=t.origin,_=t.direction,g=e.subtract(u,o,p),T=e.subtract(s,o,h),b=e.cross(_,T,d),R=e.dot(g,b);if(c){if(R<a.EPSILON6)return;if(l=e.subtract(w,o,y),(E=e.dot(l,b))<0||E>R)return;if(f=e.cross(l,g,m),(O=e.dot(_,f))<0||E+O>R)return;v=e.dot(T,f)/R}else{if(Math.abs(R)<a.EPSILON6)return;var A=1/R;if(l=e.subtract(w,o,y),(E=e.dot(l,b)*A)<0||E>1)return;if(f=e.cross(l,g,m),(O=e.dot(_,f)*A)<0||E+O>1)return;v=e.dot(T,f)*A}return v},f.rayTriangle=function(t,r,i,o,a,u){var s=f.rayTriangleParametric(t,r,i,o,a);if(n(s)&&!(s<0))return n(u)||(u=new e),e.multiplyByScalar(t.direction,s,u),e.add(t.origin,u,u)};var E=new l;f.lineSegmentTriangle=function(t,r,o,a,u,s,c){if(!n(t))throw new i("v0 is required.");if(!n(r))throw new i("v1 is required.");if(!n(o))throw new i("p0 is required.");if(!n(a))throw new i("p1 is required.");if(!n(u))throw new i("p2 is required.");var l=E;e.clone(t,l.origin),e.subtract(r,t,l.direction),e.normalize(l.direction,l.direction);var p=f.rayTriangleParametric(l,o,a,u,s);if(!(!n(p)||p<0||p>e.distance(t,r)))return n(c)||(c=new e),e.multiplyByScalar(l.direction,p,c),e.add(l.origin,c,c)};var O={root0:0,root1:0};function v(t,r,i){n(i)||(i=new o);var a=t.origin,u=t.direction,s=r.center,c=r.radius*r.radius,l=e.subtract(a,s,d),f=function(e,t,r,n){var i=t*t-4*e*r;if(!(i<0)){if(i>0){var o=1/(2*e),a=Math.sqrt(i),u=(-t+a)*o,s=(-t-a)*o;return u<s?(n.root0=u,n.root1=s):(n.root0=s,n.root1=u),n}var c=-t/(2*e);if(0!==c)return n.root0=n.root1=c,n}}(e.dot(u,u),2*e.dot(u,l),e.magnitudeSquared(l)-c,O);if(n(f))return i.start=f.root0,i.stop=f.root1,i}f.raySphere=function(e,t,r){if(!n(e))throw new i("ray is required.");if(!n(t))throw new i("sphere is required.");if(r=v(e,t,r),n(r)&&!(r.stop<0))return r.start=Math.max(r.start,0),r};var w=new l;f.lineSegmentSphere=function(t,r,o,a){if(!n(t))throw new i("p0 is required.");if(!n(r))throw new i("p1 is required.");if(!n(o))throw new i("sphere is required.");var u=w;e.clone(t,u.origin);var s=e.subtract(r,t,u.direction),c=e.magnitude(s);if(e.normalize(s,s),a=v(u,o,a),!(!n(a)||a.stop<0||a.start>c))return a.start=Math.max(a.start,0),a.stop=Math.min(a.stop,c),a};var _=new e,g=new e;function T(e,t,r){var n=e+t;return a.sign(e)!==a.sign(t)&&Math.abs(n/Math.max(Math.abs(e),Math.abs(t)))<r?0:n}f.rayEllipsoid=function(t,r){if(!n(t))throw new i("ray is required.");if(!n(r))throw new i("ellipsoid is required.");var a,u,s,c,l,f=r.oneOverRadii,p=e.multiplyComponents(f,t.origin,_),h=e.multiplyComponents(f,t.direction,g),d=e.magnitudeSquared(p),y=e.dot(p,h);if(d>1){if(y>=0)return;var m=y*y;if(a=d-1,m<(s=(u=e.magnitudeSquared(h))*a))return;if(m>s){c=y*y-s;var E=(l=-y+Math.sqrt(c))/u,O=a/l;return E<O?new o(E,O):{start:O,stop:E}}var v=Math.sqrt(a/u);return new o(v,v)}return d<1?(a=d-1,c=y*y-(s=(u=e.magnitudeSquared(h))*a),l=-y+Math.sqrt(c),new o(0,l/u)):y<0?(u=e.magnitudeSquared(h),new o(0,-y/u)):void 0};var b=new e,R=new e,A=new e,x=new e,S=new e,N=new u,I=new u,M=new u,C=new u,P=new u,D=new u,U=new u,L=new e,q=new e,F=new t;f.grazingAltitudeLocation=function(t,r){if(!n(t))throw new i("ray is required.");if(!n(r))throw new i("ellipsoid is required.");var o=t.origin,l=t.direction;if(!e.equals(o,e.ZERO)){var f=r.geodeticSurfaceNormal(o,b);if(e.dot(l,f)>=0)return o}var p=n(this.rayEllipsoid(t,r)),h=r.transformPositionToScaledSpace(l,b),d=e.normalize(h,h),y=e.mostOrthogonalAxis(h,x),m=e.normalize(e.cross(y,d,R),R),E=e.normalize(e.cross(d,m,A),A),O=N;O[0]=d.x,O[1]=d.y,O[2]=d.z,O[3]=m.x,O[4]=m.y,O[5]=m.z,O[6]=E.x,O[7]=E.y,O[8]=E.z;var v=u.transpose(O,I),w=u.fromScale(r.radii,M),_=u.fromScale(r.oneOverRadii,C),g=P;g[0]=0,g[1]=-l.z,g[2]=l.y,g[3]=l.z,g[4]=0,g[5]=-l.x,g[6]=-l.y,g[7]=l.x,g[8]=0;var j,B,z=u.multiply(u.multiply(v,_,D),g,D),G=u.multiply(u.multiply(z,w,U),O,U),V=u.multiplyByVector(z,o,S),H=function(t,r,n,i,o){var l,f=i*i,p=o*o,h=(t[u.COLUMN1ROW1]-t[u.COLUMN2ROW2])*p,d=o*(i*T(t[u.COLUMN1ROW0],t[u.COLUMN0ROW1],a.EPSILON15)+r.y),y=t[u.COLUMN0ROW0]*f+t[u.COLUMN2ROW2]*p+i*r.x+n,m=p*T(t[u.COLUMN2ROW1],t[u.COLUMN1ROW2],a.EPSILON15),E=o*(i*T(t[u.COLUMN2ROW0],t[u.COLUMN0ROW2])+r.z),O=[];if(0===E&&0===m){if(0===(l=s.computeRealRoots(h,d,y)).length)return O;var v=l[0],w=Math.sqrt(Math.max(1-v*v,0));if(O.push(new e(i,o*v,o*-w)),O.push(new e(i,o*v,o*w)),2===l.length){var _=l[1],g=Math.sqrt(Math.max(1-_*_,0));O.push(new e(i,o*_,o*-g)),O.push(new e(i,o*_,o*g))}return O}var b=E*E,R=m*m,A=E*m,x=h*h+R,S=2*(d*h+A),N=2*y*h+d*d-R+b,I=2*(y*d-A),M=y*y-b;if(0===x&&0===S&&0===N&&0===I)return O;var C=(l=c.computeRealRoots(x,S,N,I,M)).length;if(0===C)return O;for(var P=0;P<C;++P){var D=l[P],U=D*D,L=Math.max(1-U,0),q=Math.sqrt(L),F=(a.sign(h)===a.sign(y)?T(h*U+y,d*D,a.EPSILON12):a.sign(y)===a.sign(d*D)?T(h*U,d*D+y,a.EPSILON12):T(h*U+d*D,y,a.EPSILON12))*T(m*D,E,a.EPSILON15);F<0?O.push(new e(i,o*D,o*q)):F>0?O.push(new e(i,o*D,o*-q)):0!==q?(O.push(new e(i,o*D,o*-q)),O.push(new e(i,o*D,o*q)),++P):O.push(new e(i,o*D,o*q))}return O}(G,e.negate(V,b),0,0,1),W=H.length;if(W>0){for(var X=e.clone(e.ZERO,q),k=Number.NEGATIVE_INFINITY,Y=0;Y<W;++Y){j=u.multiplyByVector(w,u.multiplyByVector(O,H[Y],L),L);var Z=e.normalize(e.subtract(j,o,x),x),K=e.dot(Z,l);K>k&&(k=K,X=e.clone(j,X))}var Q=r.cartesianToCartographic(X,F);return k=a.clamp(k,0,1),B=e.magnitude(e.subtract(X,o,x))*Math.sqrt(1-k*k),B=p?-B:B,Q.height=B,r.cartographicToCartesian(Q,new e)}};var j=new e;return f.lineSegmentPlane=function(t,r,o,u){if(!n(t))throw new i("endPoint0 is required.");if(!n(r))throw new i("endPoint1 is required.");if(!n(o))throw new i("plane is required.");n(u)||(u=new e);var s=e.subtract(r,t,j),c=o.normal,l=e.dot(c,s);if(!(Math.abs(l)<a.EPSILON6)){var f=e.dot(c,t),p=-(o.distance+f)/l;if(!(p<0||p>1))return e.multiplyByScalar(s,p,u),e.add(t,u,u),u}},f.trianglePlaneIntersection=function(t,r,o,a){if(!(n(t)&&n(r)&&n(o)&&n(a)))throw new i("p0, p1, p2, and plane are required.");var u,s,c=a.normal,l=a.distance,p=e.dot(c,t)+l<0,h=e.dot(c,r)+l<0,d=e.dot(c,o)+l<0,y=0;if(y+=p?1:0,y+=h?1:0,1!==(y+=d?1:0)&&2!==y||(u=new e,s=new e),1===y){if(p)return f.lineSegmentPlane(t,r,a,u),f.lineSegmentPlane(t,o,a,s),{positions:[t,r,o,u,s],indices:[0,3,4,1,2,4,1,4,3]};if(h)return f.lineSegmentPlane(r,o,a,u),f.lineSegmentPlane(r,t,a,s),{positions:[t,r,o,u,s],indices:[1,3,4,2,0,4,2,4,3]};if(d)return f.lineSegmentPlane(o,t,a,u),f.lineSegmentPlane(o,r,a,s),{positions:[t,r,o,u,s],indices:[2,3,4,0,1,4,0,4,3]}}else if(2===y){if(!p)return f.lineSegmentPlane(r,t,a,u),f.lineSegmentPlane(o,t,a,s),{positions:[t,r,o,u,s],indices:[1,2,4,1,4,3,0,3,4]};if(!h)return f.lineSegmentPlane(o,r,a,u),f.lineSegmentPlane(t,r,a,s),{positions:[t,r,o,u,s],indices:[2,0,4,2,4,3,1,3,4]};if(!d)return f.lineSegmentPlane(t,o,a,u),f.lineSegmentPlane(r,o,a,s),{positions:[t,r,o,u,s],indices:[0,1,4,0,4,3,2,3,4]}}},f})),define("Core/Plane",["./Cartesian3","./Check","./defined","./DeveloperError","./freezeObject","./Math","./Matrix4"],(function(e,t,r,n,i,o,a){"use strict";function u(r,i){if(t.typeOf.object("normal",r),!o.equalsEpsilon(e.magnitude(r),1,o.EPSILON6))throw new n("normal must be normalized.");t.typeOf.number("distance",i),this.normal=e.clone(r),this.distance=i}u.fromPointNormal=function(i,a,s){if(t.typeOf.object("point",i),t.typeOf.object("normal",a),!o.equalsEpsilon(e.magnitude(a),1,o.EPSILON6))throw new n("normal must be normalized.");var c=-e.dot(a,i);return r(s)?(e.clone(a,s.normal),s.distance=c,s):new u(a,c)};var s=new e;u.fromCartesian4=function(i,a){t.typeOf.object("coefficients",i);var c=e.fromCartesian4(i,s),l=i.w;if(!o.equalsEpsilon(e.magnitude(c),1,o.EPSILON6))throw new n("normal must be normalized.");return r(a)?(e.clone(c,a.normal),a.distance=l,a):new u(c,l)},u.getPointDistance=function(r,n){return t.typeOf.object("plane",r),t.typeOf.object("point",n),e.dot(r.normal,n)+r.distance};var c=new e;u.projectPointOntoPlane=function(n,i,o){t.typeOf.object("plane",n),t.typeOf.object("point",i),r(o)||(o=new e);var a=u.getPointDistance(n,i),s=e.multiplyByScalar(n.normal,a,c);return e.subtract(i,s,o)};var l=new e;return u.transform=function(r,n,i){return t.typeOf.object("plane",r),t.typeOf.object("transform",n),a.multiplyByPointAsVector(n,r.normal,s),e.normalize(s,s),e.multiplyByScalar(r.normal,-r.distance,l),a.multiplyByPoint(n,l,l),u.fromPointNormal(l,s,i)},u.clone=function(n,i){return t.typeOf.object("plane",n),r(i)?(e.clone(n.normal,i.normal),i.distance=n.distance,i):new u(n.normal,n.distance)},u.equals=function(r,n){return t.typeOf.object("left",r),t.typeOf.object("right",n),r.distance===n.distance&&e.equals(r.normal,n.normal)},u.ORIGIN_XY_PLANE=i(new u(e.UNIT_Z,0)),u.ORIGIN_YZ_PLANE=i(new u(e.UNIT_X,0)),u.ORIGIN_ZX_PLANE=i(new u(e.UNIT_Y,0)),u})),
/**
  @license
  when.js - https://github.com/cujojs/when

  MIT License (c) copyright B Cavalier & J Hann

 * A lightweight CommonJS Promises/A and when() implementation
 * when is part of the cujo.js family of libraries (http://cujojs.com/)
 *
 * Licensed under the MIT License at:
 * http://www.opensource.org/licenses/mit-license.php
 *
 * @version 1.7.1
 */
function(e){"use strict";e("ThirdParty/when",[],(function(){var e,t;function r(e,t,r,i){return n(e).then(t,r,i)}function n(e){var t,r,s;return e instanceof i?t=e:u(e)?(r=a(),e.then((function(e){r.resolve(e)}),(function(e){r.reject(e)}),(function(e){r.progress(e)})),t=r.promise):(s=e,t=new i((function(e){try{return n(e?e(s):s)}catch(e){return o(e)}}))),t}function i(e){this.then=e}function o(e){return new i((function(t,r){try{return r?n(r(e)):o(e)}catch(e){return o(e)}}))}function a(){var e,t,r,u,s,c;return e=new i(l),t=[],r=[],u=function(e,n,i){var o,u;return o=a(),u="function"==typeof i?function(e){try{o.progress(i(e))}catch(e){o.progress(e)}}:function(e){o.progress(e)},t.push((function(t){t.then(e,n).then(o.resolve,o.reject,u)})),r.push(u),o.promise},s=function(e){return f(r,e),e},c=function(e){return e=n(e),u=e.then,c=n,s=h,f(t,e),r=t=void 0,e},{then:l,resolve:p,reject:d,progress:y,promise:e,resolver:{resolve:p,reject:d,progress:y}};function l(e,t,r){return u(e,t,r)}function p(e){return c(e)}function d(e){return c(o(e))}function y(e){return s(e)}}function u(e){return e&&"function"==typeof e.then}function s(e,t,n,i,o){return p(2,arguments),r(e,(function(e){var u,s,c,l,f,p,d,y,m,E;if(m=e.length>>>0,u=Math.max(0,Math.min(t,m)),c=[],s=m-u+1,l=[],f=a(),u)for(y=f.progress,d=function(e){l.push(e),--s||(p=d=h,f.reject(l))},p=function(e){c.push(e),--u||(p=d=h,f.resolve(c))},E=0;E<m;++E)E in e&&r(e[E],v,O,y);else f.resolve(c);return f.then(n,i,o);function O(e){d(e)}function v(e){p(e)}}))}function c(e,t,r,n){return p(1,arguments),l(e,d).then(t,r,n)}function l(e,t){return r(e,(function(e){var n,i,o,u,s,c;if(o=i=e.length>>>0,n=[],c=a(),o)for(u=function(e,i){r(e,t).then((function(e){n[i]=e,--o||c.resolve(n)}),c.reject)},s=0;s<i;s++)s in e?u(e[s],s):--o;else c.resolve(n);return c.promise}))}function f(e,t){for(var r,n=0;r=e[n++];)r(t)}function p(e,t){for(var r,n=t.length;n>e;)if(null!=(r=t[--n])&&"function"!=typeof r)throw new Error("arg "+n+" must be a function")}function h(){}function d(e){return e}return r.defer=a,r.resolve=n,r.reject=function(e){return r(e,o)},r.join=function(){return l(arguments,d)},r.all=c,r.map=l,r.reduce=function(n,i){var o=t.call(arguments,1);return r(n,(function(t){var n;return n=t.length,o[0]=function(e,t,o){return r(e,(function(e){return r(t,(function(t){return i(e,t,o,n)}))}))},e.apply(t,o)}))},r.any=function(e,t,r,n){return s(e,1,(function(e){return t?t(e[0]):e[0]}),r,n)},r.some=s,r.chain=function(e,t,n){var i=arguments.length>2;return r(e,(function(e){return e=i?n:e,t.resolve(e),e}),(function(e){return t.reject(e),o(e)}),t.progress)},r.isPromise=u,i.prototype={always:function(e,t){return this.then(e,e,t)},otherwise:function(e){return this.then(void 0,e)},yield:function(e){return this.then((function(){return e}))},spread:function(e){return this.then((function(t){return c(t,(function(t){return e.apply(void 0,t)}))}))}},t=[].slice,e=[].reduce||function(e){var t,r,n,i,o;if(o=0,i=(t=Object(this)).length>>>0,(r=arguments).length<=1)for(;;){if(o in t){n=t[o++];break}if(++o>=i)throw new TypeError}else n=r[1];for(;o<i;++o)o in t&&(n=e(n,t[o],o,t));return n},r}))}("function"==typeof define&&define.amd?define:function(e){"object"==typeof exports?module.exports=e():this.when=e()}),define("Core/binarySearch",["./Check"],(function(e){"use strict";return function(t,r,n){e.defined("array",t),e.defined("itemToFind",r),e.defined("comparator",n);for(var i,o,a=0,u=t.length-1;a<=u;)if((o=n(t[i=~~((a+u)/2)],r))<0)a=i+1;else{if(!(o>0))return i;u=i-1}return~(u+1)}})),define("Core/EarthOrientationParametersSample",[],(function(){"use strict";return function(e,t,r,n,i){this.xPoleWander=e,this.yPoleWander=t,this.xPoleOffset=r,this.yPoleOffset=n,this.ut1MinusUtc=i}})),
/**
@license
sprintf.js from the php.js project - https://github.com/kvz/phpjs
Directly from https://github.com/kvz/phpjs/blob/master/functions/strings/sprintf.js

php.js is copyright 2012 Kevin van Zonneveld.

Portions copyright Brett Zamir (http://brett-zamir.me), Kevin van Zonneveld
(http://kevin.vanzonneveld.net), Onno Marsman, Theriault, Michael White
(http://getsprink.com), Waldo Malqui Silva, Paulo Freitas, Jack, Jonas
Raoni Soares Silva (http://www.jsfromhell.com), Philip Peterson, Legaev
Andrey, Ates Goral (http://magnetiq.com), Alex, Ratheous, Martijn Wieringa,
Rafa? Kukawski (http://blog.kukawski.pl), lmeyrick
(https://sourceforge.net/projects/bcmath-js/), Nate, Philippe Baumann,
Enrique Gonzalez, Webtoolkit.info (http://www.webtoolkit.info/), Carlos R.
L. Rodrigues (http://www.jsfromhell.com), Ash Searle
(http://hexmen.com/blog/), Jani Hartikainen, travc, Ole Vrijenhoek,
Erkekjetter, Michael Grier, Rafa? Kukawski (http://kukawski.pl), Johnny
Mast (http://www.phpvrouwen.nl), T.Wild, d3x,
http://stackoverflow.com/questions/57803/how-to-convert-decimal-to-hex-in-javascript,
Rafa? Kukawski (http://blog.kukawski.pl/), stag019, pilus, WebDevHobo
(http://webdevhobo.blogspot.com/), marrtins, GeekFG
(http://geekfg.blogspot.com), Andrea Giammarchi
(http://webreflection.blogspot.com), Arpad Ray (mailto:arpad@php.net),
gorthaur, Paul Smith, Tim de Koning (http://www.kingsquare.nl), Joris, Oleg
Eremeev, Steve Hilder, majak, gettimeofday, KELAN, Josh Fraser
(http://onlineaspect.com/2007/06/08/auto-detect-a-time-zone-with-javascript/),
Marc Palau, Martin
(http://www.erlenwiese.de/), Breaking Par Consulting Inc
(http://www.breakingpar.com/bkp/home.nsf/0/87256B280015193F87256CFB006C45F7),
Chris, Mirek Slugen, saulius, Alfonso Jimenez
(http://www.alfonsojimenez.com), Diplom@t (http://difane.com/), felix,
Mailfaker (http://www.weedem.fr/), Tyler Akins (http://rumkin.com), Caio
Ariede (http://caioariede.com), Robin, Kankrelune
(http://www.webfaktory.info/), Karol Kowalski, Imgen Tata
(http://www.myipdf.com/), mdsjack (http://www.mdsjack.bo.it), Dreamer,
Felix Geisendoerfer (http://www.debuggable.com/felix), Lars Fischer, AJ,
David, Aman Gupta, Michael White, Public Domain
(http://www.json.org/json2.js), Steven Levithan
(http://blog.stevenlevithan.com), Sakimori, Pellentesque Malesuada,
Thunder.m, Dj (http://phpjs.org/functions/htmlentities:425#comment_134018),
Steve Clay, David James, Francois, class_exists, nobbler, T. Wild, Itsacon
(http://www.itsacon.net/), date, Ole Vrijenhoek (http://www.nervous.nl/),
Fox, Raphael (Ao RUDLER), Marco, noname, Mateusz "loonquawl" Zalega, Frank
Forte, Arno, ger, mktime, john (http://www.jd-tech.net), Nick Kolosov
(http://sammy.ru), marc andreu, Scott Cariss, Douglas Crockford
(http://javascript.crockford.com), madipta, Slawomir Kaniecki,
ReverseSyntax, Nathan, Alex Wilson, kenneth, Bayron Guevara, Adam Wallner
(http://web2.bitbaro.hu/), paulo kuong, jmweb, Lincoln Ramsay, djmix,
Pyerre, Jon Hohle, Thiago Mata (http://thiagomata.blog.com), lmeyrick
(https://sourceforge.net/projects/bcmath-js/this.), Linuxworld, duncan,
Gilbert, Sanjoy Roy, Shingo, sankai, Oskar Larsson H?gfeldt
(http://oskar-lh.name/), Denny Wardhana, 0m3r, Everlasto, Subhasis Deb,
josh, jd, Pier Paolo Ramon (http://www.mastersoup.com/), P, merabi, Soren
Hansen, Eugene Bulkin (http://doubleaw.com/), Der Simon
(http://innerdom.sourceforge.net/), echo is bad, Ozh, XoraX
(http://www.xorax.info), EdorFaus, JB, J A R, Marc Jansen, Francesco, LH,
Stoyan Kyosev (http://www.svest.org/), nord_ua, omid
(http://phpjs.org/functions/380:380#comment_137122), Brad Touesnard, MeEtc
(http://yass.meetcweb.com), Peter-Paul Koch
(http://www.quirksmode.org/js/beat.html), Olivier Louvignes
(http://mg-crea.com/), T0bsn, Tim Wiel, Bryan Elliott, Jalal Berrami,
Martin, JT, David Randall, Thomas Beaucourt (http://www.webapp.fr), taith,
vlado houba, Pierre-Luc Paour, Kristof Coomans (SCK-CEN Belgian Nucleair
Research Centre), Martin Pool, Kirk Strobeck, Rick Waldron, Brant Messenger
(http://www.brantmessenger.com/), Devan Penner-Woelk, Saulo Vallory, Wagner
B. Soares, Artur Tchernychev, Valentina De Rosa, Jason Wong
(http://carrot.org/), Christoph, Daniel Esteban, strftime, Mick@el, rezna,
Simon Willison (http://simonwillison.net), Anton Ongson, Gabriel Paderni,
Marco van Oort, penutbutterjelly, Philipp Lenssen, Bjorn Roesbeke
(http://www.bjornroesbeke.be/), Bug?, Eric Nagel, Tomasz Wesolowski,
Evertjan Garretsen, Bobby Drake, Blues (http://tech.bluesmoon.info/), Luke
Godfrey, Pul, uestla, Alan C, Ulrich, Rafal Kukawski, Yves Sucaet,
sowberry, Norman "zEh" Fuchs, hitwork, Zahlii, johnrembo, Nick Callen,
Steven Levithan (stevenlevithan.com), ejsanders, Scott Baker, Brian Tafoya
(http://www.premasolutions.com/), Philippe Jausions
(http://pear.php.net/user/jausions), Aidan Lister
(http://aidanlister.com/), Rob, e-mike, HKM, ChaosNo1, metjay, strcasecmp,
strcmp, Taras Bogach, jpfle, Alexander Ermolaev
(http://snippets.dzone.com/user/AlexanderErmolaev), DxGx, kilops, Orlando,
dptr1988, Le Torbi, James (http://www.james-bell.co.uk/), Pedro Tainha
(http://www.pedrotainha.com), James, Arnout Kazemier
(http://www.3rd-Eden.com), Chris McMacken, gabriel paderni, Yannoo,
FGFEmperor, baris ozdil, Tod Gentille, Greg Frazier, jakes, 3D-GRAF, Allan
Jensen (http://www.winternet.no), Howard Yeend, Benjamin Lupton, davook,
daniel airton wermann (http://wermann.com.br), Atli T¨®r, Maximusya, Ryan
W Tenney (http://ryan.10e.us), Alexander M Beedie, fearphage
(http://http/my.opera.com/fearphage/), Nathan Sepulveda, Victor, Matteo,
Billy, stensi, Cord, Manish, T.J. Leahy, Riddler
(http://www.frontierwebdev.com/), Rafa? Kukawski, FremyCompany, Matt
Bradley, Tim de Koning, Luis Salazar (http://www.freaky-media.com/), Diogo
Resende, Rival, Andrej Pavlovic, Garagoth, Le Torbi
(http://www.letorbi.de/), Dino, Josep Sanz (http://www.ws3.es/), rem,
Russell Walker (http://www.nbill.co.uk/), Jamie Beck
(http://www.terabit.ca/), setcookie, Michael, YUI Library:
http://developer.yahoo.com/yui/docs/YAHOO.util.DateLocale.html, Blues at
http://hacks.bluesmoon.info/strftime/strftime.js, Ben
(http://benblume.co.uk/), DtTvB
(http://dt.in.th/2008-09-16.string-length-in-bytes.html), Andreas, William,
meo, incidence, Cagri Ekin, Amirouche, Amir Habibi
(http://www.residence-mixte.com/), Luke Smith (http://lucassmith.name),
Kheang Hok Chin (http://www.distantia.ca/), Jay Klehr, Lorenzo Pisani,
Tony, Yen-Wei Liu, Greenseed, mk.keck, Leslie Hoare, dude, booeyOH, Ben
Bryan

Licensed under the MIT (MIT-LICENSE.txt) license.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL KEVIN VAN ZONNEVELD BE LIABLE FOR ANY CLAIM, DAMAGES
OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.
*/
define("ThirdParty/sprintf",[],(function(){return function(){var e=/%%|%(\d+\$)?([-+\'#0 ]*)(\*\d+\$|\*|\d+)?(\.(\*\d+\$|\*|\d+))?([scboxXuideEfFgG])/g,t=arguments,r=0,n=t[r++],i=function(e,t,r,n){r||(r=" ");var i=e.length>=t?"":Array(1+t-e.length>>>0).join(r);return n?e+i:i+e},o=function(e,t,r,n,o,a){var u=n-e.length;return u>0&&(e=r||!o?i(e,n,a,r):e.slice(0,t.length)+i("",u,"0",!0)+e.slice(t.length)),e},a=function(e,t,r,n,a,u,s){var c=e>>>0;return e=(r=r&&c&&{2:"0b",8:"0",16:"0x"}[t]||"")+i(c.toString(t),u||0,"0",!1),o(e,r,n,a,s)},u=function(e,t,r,n,i,a){return null!=n&&(e=e.slice(0,n)),o(e,"",t,r,i,a)},s=function(e,n,s,c,l,f,p){var h,d,y,m,E;if("%%"==e)return"%";for(var O=!1,v="",w=!1,_=!1,g=" ",T=s.length,b=0;s&&b<T;b++)switch(s.charAt(b)){case" ":v=" ";break;case"+":v="+";break;case"-":O=!0;break;case"'":g=s.charAt(b+1);break;case"0":w=!0;break;case"#":_=!0}if((c=c?"*"==c?+t[r++]:"*"==c.charAt(0)?+t[c.slice(1,-1)]:+c:0)<0&&(c=-c,O=!0),!isFinite(c))throw new Error("sprintf: (minimum-)width must be finite");switch(f=f?"*"==f?+t[r++]:"*"==f.charAt(0)?+t[f.slice(1,-1)]:+f:"fFeE".indexOf(p)>-1?6:"d"==p?0:void 0,E=n?t[n.slice(0,-1)]:t[r++],p){case"s":return u(String(E),O,c,f,w,g);case"c":return u(String.fromCharCode(+E),O,c,f,w);case"b":return a(E,2,_,O,c,f,w);case"o":return a(E,8,_,O,c,f,w);case"x":return a(E,16,_,O,c,f,w);case"X":return a(E,16,_,O,c,f,w).toUpperCase();case"u":return a(E,10,_,O,c,f,w);case"i":case"d":return h=+E||0,E=(d=(h=Math.round(h-h%1))<0?"-":v)+i(String(Math.abs(h)),f,"0",!1),o(E,d,O,c,w);case"e":case"E":case"f":case"F":case"g":case"G":return d=(h=+E)<0?"-":v,y=["toExponential","toFixed","toPrecision"]["efg".indexOf(p.toLowerCase())],m=["toString","toUpperCase"]["eEfFgG".indexOf(p)%2],E=d+Math.abs(h)[y](f),o(E,d,O,c,w)[m]();default:return e}};return n.replace(e,s)}})),define("Core/GregorianDate",[],(function(){"use strict";return function(e,t,r,n,i,o,a,u){this.year=e,this.month=t,this.day=r,this.hour=n,this.minute=i,this.second=o,this.millisecond=a,this.isLeapSecond=u}})),define("Core/isLeapYear",["./DeveloperError"],(function(e){"use strict";return function(t){if(null===t||isNaN(t))throw new e("year is required and must be a number.");return t%4==0&&t%100!=0||t%400==0}})),define("Core/LeapSecond",[],(function(){"use strict";return function(e,t){this.julianDate=e,this.offset=t}})),define("Core/TimeConstants",["./freezeObject"],(function(e){"use strict";return e({SECONDS_PER_MILLISECOND:.001,SECONDS_PER_MINUTE:60,MINUTES_PER_HOUR:60,HOURS_PER_DAY:24,SECONDS_PER_HOUR:3600,MINUTES_PER_DAY:1440,SECONDS_PER_DAY:86400,DAYS_PER_JULIAN_CENTURY:36525,PICOSECOND:1e-9,MODIFIED_JULIAN_DATE_DIFFERENCE:2400000.5})})),define("Core/TimeStandard",["./freezeObject"],(function(e){"use strict";return e({UTC:0,TAI:1})})),define("Core/JulianDate",["../ThirdParty/sprintf","./binarySearch","./defaultValue","./defined","./DeveloperError","./GregorianDate","./isLeapYear","./LeapSecond","./TimeConstants","./TimeStandard"],(function(e,t,r,n,i,o,a,u,s,c){"use strict";var l=new o,f=[31,28,31,30,31,30,31,31,30,31,30,31];function p(e,t){return S.compare(e.julianDate,t.julianDate)}var h=new u;function d(e){h.julianDate=e;var r=S.leapSeconds,n=t(r,h,p);n<0&&(n=~n),n>=r.length&&(n=r.length-1);var i=r[n].offset;n>0&&S.secondsDifference(r[n].julianDate,e)>i&&(i=r[--n].offset),S.addSeconds(e,i,e)}function y(e,r){h.julianDate=e;var n=S.leapSeconds,i=t(n,h,p);if(i<0&&(i=~i),0===i)return S.addSeconds(e,-n[0].offset,r);if(i>=n.length)return S.addSeconds(e,-n[i-1].offset,r);var o=S.secondsDifference(n[i].julianDate,e);return 0===o?S.addSeconds(e,-n[i].offset,r):o<=1?void 0:S.addSeconds(e,-n[--i].offset,r)}function m(e,t,r){var n=t/s.SECONDS_PER_DAY|0;return e+=n,(t-=s.SECONDS_PER_DAY*n)<0&&(e--,t+=s.SECONDS_PER_DAY),r.dayNumber=e,r.secondsOfDay=t,r}function E(e,t,r,n,i,o,a){var u=(t-14)/12|0,c=e+4800+u,l=(1461*c/4|0)+(367*(t-2-12*u)/12|0)-(3*((c+100)/100|0)/4|0)+r-32075;(n-=12)<0&&(n+=24);var f=o+(n*s.SECONDS_PER_HOUR+i*s.SECONDS_PER_MINUTE+a*s.SECONDS_PER_MILLISECOND);return f>=43200&&(l-=1),[l,f]}var O=/^(\d{4})$/,v=/^(\d{4})-(\d{2})$/,w=/^(\d{4})-?(\d{3})$/,_=/^(\d{4})-?W(\d{2})-?(\d{1})?$/,g=/^(\d{4})-?(\d{2})-?(\d{2})$/,T=/([Z+\-])?(\d{2})?:?(\d{2})?$/,b=/^(\d{2})(\.\d+)?/.source+T.source,R=/^(\d{2}):?(\d{2})(\.\d+)?/.source+T.source,A=/^(\d{2}):?(\d{2}):?(\d{2})(\.\d+)?/.source+T.source,x="Invalid ISO 8601 date.";function S(e,t,n){this.dayNumber=void 0,this.secondsOfDay=void 0,e=r(e,0),t=r(t,0),n=r(n,c.UTC);var i=0|e;m(i,t+=(e-i)*s.SECONDS_PER_DAY,this),n===c.UTC&&d(this)}S.fromGregorianDate=function(e,t){if(!(e instanceof o))throw new i("date must be a valid GregorianDate.");var r=E(e.year,e.month,e.day,e.hour,e.minute,e.second,e.millisecond);return n(t)?(m(r[0],r[1],t),d(t),t):new S(r[0],r[1],c.UTC)},S.fromDate=function(e,t){if(!(e instanceof Date)||isNaN(e.getTime()))throw new i("date must be a valid JavaScript Date.");var r=E(e.getUTCFullYear(),e.getUTCMonth()+1,e.getUTCDate(),e.getUTCHours(),e.getUTCMinutes(),e.getUTCSeconds(),e.getUTCMilliseconds());return n(t)?(m(r[0],r[1],t),d(t),t):new S(r[0],r[1],c.UTC)},S.fromIso8601=function(e,t){if("string"!=typeof e)throw new i(x);var r,o,u,s,l,p=(e=e.replace(",",".")).split("T"),h=1,y=1,T=0,N=0,I=0,M=0,C=p[0],P=p[1];if(!n(C))throw new i(x);if(null!==(p=C.match(g))){if((s=C.split("-").length-1)>0&&2!==s)throw new i(x);r=+p[1],h=+p[2],y=+p[3]}else if(null!==(p=C.match(v)))r=+p[1],h=+p[2];else if(null!==(p=C.match(O)))r=+p[1];else{var D;if(null!==(p=C.match(w))){if(r=+p[1],D=+p[2],u=a(r),D<1||u&&D>366||!u&&D>365)throw new i(x)}else{if(null===(p=C.match(_)))throw new i(x);r=+p[1];var U=+p[2],L=+p[3]||0;if((s=C.split("-").length-1)>0&&(!n(p[3])&&1!==s||n(p[3])&&2!==s))throw new i(x);D=7*U+L-new Date(Date.UTC(r,0,4)).getUTCDay()-3}(o=new Date(Date.UTC(r,0,1))).setUTCDate(D),h=o.getUTCMonth()+1,y=o.getUTCDate()}if(u=a(r),h<1||h>12||y<1||(2!==h||!u)&&y>f[h-1]||u&&2===h&&y>29)throw new i(x);if(n(P)){if(null!==(p=P.match(A))){if((s=P.split(":").length-1)>0&&2!==s&&3!==s)throw new i(x);T=+p[1],N=+p[2],I=+p[3],M=1e3*+(p[4]||0),l=5}else if(null!==(p=P.match(R))){if((s=P.split(":").length-1)>2)throw new i(x);T=+p[1],N=+p[2],I=60*+(p[3]||0),l=4}else{if(null===(p=P.match(b)))throw new i(x);T=+p[1],N=60*+(p[2]||0),l=3}if(N>=60||I>=61||T>24||24===T&&(N>0||I>0||M>0))throw new i(x);var q=p[l],F=+p[l+1],j=+(p[l+2]||0);switch(q){case"+":T-=F,N-=j;break;case"-":T+=F,N+=j;break;case"Z":break;default:N+=new Date(Date.UTC(r,h-1,y,T,N)).getTimezoneOffset()}}var B=60===I;for(B&&I--;N>=60;)N-=60,T++;for(;T>=24;)T-=24,y++;for(o=u&&2===h?29:f[h-1];y>o;)y-=o,++h>12&&(h-=12,r++),o=u&&2===h?29:f[h-1];for(;N<0;)N+=60,T--;for(;T<0;)T+=24,y--;for(;y<1;)--h<1&&(h+=12,r--),y+=o=u&&2===h?29:f[h-1];var z=E(r,h,y,T,N,I,M);return n(t)?(m(z[0],z[1],t),d(t)):t=new S(z[0],z[1],c.UTC),B&&S.addSeconds(t,1,t),t},S.now=function(e){return S.fromDate(new Date,e)};var N=new S(0,0,c.TAI);return S.toGregorianDate=function(e,t){if(!n(e))throw new i("julianDate is required.");var r=!1,a=y(e,N);n(a)||(S.addSeconds(e,-1,N),a=y(N,N),r=!0);var u=a.dayNumber,c=a.secondsOfDay;c>=43200&&(u+=1);var l=u+68569|0,f=4*l/146097|0,p=4e3*(1+(l=l-((146097*f+3)/4|0)|0))/1461001|0,h=80*(l=l-(1461*p/4|0)+31|0)/2447|0,d=l-(2447*h/80|0)|0,m=h+2-12*(l=h/11|0)|0,E=100*(f-49)+p+l|0,O=c/s.SECONDS_PER_HOUR|0,v=c-O*s.SECONDS_PER_HOUR,w=v/s.SECONDS_PER_MINUTE|0,_=0|(v-=w*s.SECONDS_PER_MINUTE),g=(v-_)/s.SECONDS_PER_MILLISECOND;return(O+=12)>23&&(O-=24),r&&(_+=1),n(t)?(t.year=E,t.month=m,t.day=d,t.hour=O,t.minute=w,t.second=_,t.millisecond=g,t.isLeapSecond=r,t):new o(E,m,d,O,w,_,g,r)},S.toDate=function(e){if(!n(e))throw new i("julianDate is required.");var t=S.toGregorianDate(e,l),r=t.second;return t.isLeapSecond&&(r-=1),new Date(Date.UTC(t.year,t.month-1,t.day,t.hour,t.minute,r,t.millisecond))},S.toIso8601=function(t,r){if(!n(t))throw new i("julianDate is required.");var o,a=S.toGregorianDate(t,l),u=a.year,s=a.month,c=a.day,f=a.hour,p=a.minute,h=a.second,d=a.millisecond;return 1e4===u&&1===s&&1===c&&0===f&&0===p&&0===h&&0===d&&(u=9999,s=12,c=31,f=24),n(r)||0===d?n(r)&&0!==r?(o=(.01*d).toFixed(r).replace(".","").slice(0,r),e("%04d-%02d-%02dT%02d:%02d:%02d.%sZ",u,s,c,f,p,h,o)):e("%04d-%02d-%02dT%02d:%02d:%02dZ",u,s,c,f,p,h):(o=(.01*d).toString().replace(".",""),e("%04d-%02d-%02dT%02d:%02d:%02d.%sZ",u,s,c,f,p,h,o))},S.clone=function(e,t){if(n(e))return n(t)?(t.dayNumber=e.dayNumber,t.secondsOfDay=e.secondsOfDay,t):new S(e.dayNumber,e.secondsOfDay,c.TAI)},S.compare=function(e,t){if(!n(e))throw new i("left is required.");if(!n(t))throw new i("right is required.");var r=e.dayNumber-t.dayNumber;return 0!==r?r:e.secondsOfDay-t.secondsOfDay},S.equals=function(e,t){return e===t||n(e)&&n(t)&&e.dayNumber===t.dayNumber&&e.secondsOfDay===t.secondsOfDay},S.equalsEpsilon=function(e,t,r){if(!n(r))throw new i("epsilon is required.");return e===t||n(e)&&n(t)&&Math.abs(S.secondsDifference(e,t))<=r},S.totalDays=function(e){if(!n(e))throw new i("julianDate is required.");return e.dayNumber+e.secondsOfDay/s.SECONDS_PER_DAY},S.secondsDifference=function(e,t){if(!n(e))throw new i("left is required.");if(!n(t))throw new i("right is required.");return(e.dayNumber-t.dayNumber)*s.SECONDS_PER_DAY+(e.secondsOfDay-t.secondsOfDay)},S.daysDifference=function(e,t){if(!n(e))throw new i("left is required.");if(!n(t))throw new i("right is required.");return e.dayNumber-t.dayNumber+(e.secondsOfDay-t.secondsOfDay)/s.SECONDS_PER_DAY},S.computeTaiMinusUtc=function(e){h.julianDate=e;var r=S.leapSeconds,n=t(r,h,p);return n<0&&(n=~n,--n<0&&(n=0)),r[n].offset},S.addSeconds=function(e,t,r){if(!n(e))throw new i("julianDate is required.");if(!n(t))throw new i("seconds is required.");if(!n(r))throw new i("result is required.");return m(e.dayNumber,e.secondsOfDay+t,r)},S.addMinutes=function(e,t,r){if(!n(e))throw new i("julianDate is required.");if(!n(t))throw new i("minutes is required.");if(!n(r))throw new i("result is required.");var o=e.secondsOfDay+t*s.SECONDS_PER_MINUTE;return m(e.dayNumber,o,r)},S.addHours=function(e,t,r){if(!n(e))throw new i("julianDate is required.");if(!n(t))throw new i("hours is required.");if(!n(r))throw new i("result is required.");var o=e.secondsOfDay+t*s.SECONDS_PER_HOUR;return m(e.dayNumber,o,r)},S.addDays=function(e,t,r){if(!n(e))throw new i("julianDate is required.");if(!n(t))throw new i("days is required.");if(!n(r))throw new i("result is required.");return m(e.dayNumber+t,e.secondsOfDay,r)},S.lessThan=function(e,t){return S.compare(e,t)<0},S.lessThanOrEquals=function(e,t){return S.compare(e,t)<=0},S.greaterThan=function(e,t){return S.compare(e,t)>0},S.greaterThanOrEquals=function(e,t){return S.compare(e,t)>=0},S.prototype.clone=function(e){return S.clone(this,e)},S.prototype.equals=function(e){return S.equals(this,e)},S.prototype.equalsEpsilon=function(e,t){return S.equalsEpsilon(this,e,t)},S.prototype.toString=function(){return S.toIso8601(this)},S.leapSeconds=[new u(new S(2441317,43210,c.TAI),10),new u(new S(2441499,43211,c.TAI),11),new u(new S(2441683,43212,c.TAI),12),new u(new S(2442048,43213,c.TAI),13),new u(new S(2442413,43214,c.TAI),14),new u(new S(2442778,43215,c.TAI),15),new u(new S(2443144,43216,c.TAI),16),new u(new S(2443509,43217,c.TAI),17),new u(new S(2443874,43218,c.TAI),18),new u(new S(2444239,43219,c.TAI),19),new u(new S(2444786,43220,c.TAI),20),new u(new S(2445151,43221,c.TAI),21),new u(new S(2445516,43222,c.TAI),22),new u(new S(2446247,43223,c.TAI),23),new u(new S(2447161,43224,c.TAI),24),new u(new S(2447892,43225,c.TAI),25),new u(new S(2448257,43226,c.TAI),26),new u(new S(2448804,43227,c.TAI),27),new u(new S(2449169,43228,c.TAI),28),new u(new S(2449534,43229,c.TAI),29),new u(new S(2450083,43230,c.TAI),30),new u(new S(2450630,43231,c.TAI),31),new u(new S(2451179,43232,c.TAI),32),new u(new S(2453736,43233,c.TAI),33),new u(new S(2454832,43234,c.TAI),34),new u(new S(2456109,43235,c.TAI),35),new u(new S(2457204,43236,c.TAI),36),new u(new S(2457754,43237,c.TAI),37)],S})),
/**
 * @license
 *
 * Grauw URI utilities
 *
 * See: http://hg.grauw.nl/grauw-lib/file/tip/src/uri.js
 *
 * @author Laurens Holst (http://www.grauw.nl/)
 *
 *   Copyright 2012 Laurens Holst
 *
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License.
 *
 */
define("ThirdParty/Uri",[],(function(){function e(r){if(r instanceof e)this.scheme=r.scheme,this.authority=r.authority,this.path=r.path,this.query=r.query,this.fragment=r.fragment;else if(r){var n=t.exec(r);this.scheme=n[1],this.authority=n[2],this.path=n[3],this.query=n[4],this.fragment=n[5]}}e.prototype.scheme=null,e.prototype.authority=null,e.prototype.path="",e.prototype.query=null,e.prototype.fragment=null;var t=new RegExp("^(?:([^:/?#]+):)?(?://([^/?#]*))?([^?#]*)(?:\\?([^#]*))?(?:#(.*))?$");e.prototype.getScheme=function(){return this.scheme},e.prototype.getAuthority=function(){return this.authority},e.prototype.getPath=function(){return this.path},e.prototype.getQuery=function(){return this.query},e.prototype.getFragment=function(){return this.fragment},e.prototype.isAbsolute=function(){return!!this.scheme&&!this.fragment},e.prototype.isSameDocumentAs=function(e){return e.scheme==this.scheme&&e.authority==this.authority&&e.path==this.path&&e.query==this.query},e.prototype.equals=function(e){return this.isSameDocumentAs(e)&&e.fragment==this.fragment},e.prototype.normalize=function(){this.removeDotSegments(),this.scheme&&(this.scheme=this.scheme.toLowerCase()),this.authority&&(this.authority=this.authority.replace(i,a).replace(r,o)),this.path&&(this.path=this.path.replace(r,o)),this.query&&(this.query=this.query.replace(r,o)),this.fragment&&(this.fragment=this.fragment.replace(r,o))};var r=/%[0-9a-z]{2}/gi,n=/[a-zA-Z0-9\-\._~]/,i=/(.*@)?([^@:]*)(:.*)?/;function o(e){var t=unescape(e);return n.test(t)?t:e.toUpperCase()}function a(e,t,r,n){return(t||"")+r.toLowerCase()+(n||"")}return e.prototype.resolve=function(t){var r=new e;return this.scheme?(r.scheme=this.scheme,r.authority=this.authority,r.path=this.path,r.query=this.query):(r.scheme=t.scheme,this.authority?(r.authority=this.authority,r.path=this.path,r.query=this.query):(r.authority=t.authority,""==this.path?(r.path=t.path,r.query=this.query||t.query):("/"==this.path.charAt(0)?(r.path=this.path,r.removeDotSegments()):(t.authority&&""==t.path?r.path="/"+this.path:r.path=t.path.substring(0,t.path.lastIndexOf("/")+1)+this.path,r.removeDotSegments()),r.query=this.query))),r.fragment=this.fragment,r},e.prototype.removeDotSegments=function(){var e,t=this.path.split("/"),r=[],n=""==t[0];for(n&&t.shift(),""==t[0]&&t.shift();t.length;)".."==(e=t.shift())?r.pop():"."!=e&&r.push(e);"."!=e&&".."!=e||r.push(""),n&&r.unshift(""),this.path=r.join("/")},e.prototype.toString=function(){var e="";return this.scheme&&(e+=this.scheme+":"),this.authority&&(e+="//"+this.authority),e+=this.path,this.query&&(e+="?"+this.query),this.fragment&&(e+="#"+this.fragment),e},e})),define("Core/appendForwardSlash",[],(function(){"use strict";return function(e){return 0!==e.length&&"/"===e[e.length-1]||(e+="/"),e}})),define("Core/clone",["./defaultValue"],(function(e){"use strict";return function t(r,n){if(null===r||"object"!=typeof r)return r;n=e(n,!1);var i=new r.constructor;for(var o in r)if(r.hasOwnProperty(o)){var a=r[o];n&&(a=t(a,n)),i[o]=a}return i}})),define("Core/combine",["./defaultValue","./defined"],(function(e,t){"use strict";return function r(n,i,o){o=e(o,!1);var a,u,s,c={},l=t(n),f=t(i);if(l)for(a in n)n.hasOwnProperty(a)&&(u=n[a],f&&o&&"object"==typeof u&&i.hasOwnProperty(a)?(s=i[a],c[a]="object"==typeof s?r(u,s,o):u):c[a]=u);if(f)for(a in i)i.hasOwnProperty(a)&&!c.hasOwnProperty(a)&&(s=i[a],c[a]=s);return c}})),define("Core/oneTimeWarning",["./defaultValue","./defined","./DeveloperError"],(function(e,t,r){"use strict";var n={};function i(i,o){if(!t(i))throw new r("identifier is required.");t(n[i])||(n[i]=!0,console.warn(e(o,i)))}return i.geometryOutlines="Entity geometry outlines are unsupported on terrain. Outlines will be disabled. To enable outlines, disable geometry terrain clamping by explicitly setting height to 0.",i.geometryZIndex="Entity geometry with zIndex are unsupported when height or extrudedHeight are defined.  zIndex will be ignored",i.geometryHeightReference="Entity corridor, ellipse, polygon or rectangle with heightReference must also have a defined height.  heightReference will be ignored",i.geometryExtrudedHeightReference="Entity corridor, ellipse, polygon or rectangle with extrudedHeightReference must also have a defined extrudedHeight.  extrudedHeightReference will be ignored",i})),define("Core/deprecationWarning",["./defined","./DeveloperError","./oneTimeWarning"],(function(e,t,r){"use strict";return function(n,i){if(!e(n)||!e(i))throw new t("identifier and message are required.");r(n,i)}})),define("Core/getAbsoluteUri",["../ThirdParty/Uri","./defaultValue","./defined","./DeveloperError"],(function(e,t,r,n){"use strict";function i(e,t){var r;return"undefined"!=typeof document&&(r=document),i._implementation(e,t,r)}return i._implementation=function(i,o,a){if(!r(i))throw new n("relative uri is required.");if(!r(o)){if(void 0===a)return i;o=t(a.baseURI,a.location.href)}var u=new e(o);return new e(i).resolve(u).toString()},i})),define("Core/getBaseUri",["../ThirdParty/Uri","./defined","./DeveloperError"],(function(e,t,r){"use strict";return function(n,i){if(!t(n))throw new r("uri is required.");var o="",a=n.lastIndexOf("/");return-1!==a&&(o=n.substring(0,a+1)),i?(n=new e(n),t(n.query)&&(o+="?"+n.query),t(n.fragment)&&(o+="#"+n.fragment),o):o}})),define("Core/getExtensionFromUri",["../ThirdParty/Uri","./defined","./DeveloperError"],(function(e,t,r){"use strict";return function(n){if(!t(n))throw new r("uri is required.");var i=new e(n);i.normalize();var o=i.path,a=o.lastIndexOf("/");return-1!==a&&(o=o.substr(a+1)),a=o.lastIndexOf("."),o=-1===a?"":o.substr(a+1)}})),define("Core/isBlobUri",["./Check"],(function(e){"use strict";var t=/^blob:/i;return function(r){return e.typeOf.string("uri",r),t.test(r)}})),define("Core/isCrossOriginUrl",["./defined"],(function(e){"use strict";var t;return function(r){e(t)||(t=document.createElement("a")),t.href=window.location.href;var n=t.host,i=t.protocol;return t.href=r,t.href=t.href,i!==t.protocol||n!==t.host}})),define("Core/isDataUri",["./Check"],(function(e){"use strict";var t=/^data:/i;return function(r){return e.typeOf.string("uri",r),t.test(r)}})),define("Core/loadAndExecuteScript",["../ThirdParty/when"],(function(e){"use strict";return function(t){var r=e.defer(),n=document.createElement("script");n.async=!0,n.src=t;var i=document.getElementsByTagName("head")[0];return n.onload=function(){n.onload=void 0,i.removeChild(n),r.resolve()},n.onerror=function(e){r.reject(e)},i.appendChild(n),r.promise}})),define("Core/isArray",["./defined"],(function(e){"use strict";var t=Array.isArray;return e(t)||(t=function(e){return"[object Array]"===Object.prototype.toString.call(e)}),t})),define("Core/objectToQuery",["./defined","./DeveloperError","./isArray"],(function(e,t,r){"use strict";return function(n){if(!e(n))throw new t("obj is required.");var i="";for(var o in n)if(n.hasOwnProperty(o)){var a=n[o],u=encodeURIComponent(o)+"=";if(r(a))for(var s=0,c=a.length;s<c;++s)i+=u+encodeURIComponent(a[s])+"&";else i+=u+encodeURIComponent(a)+"&"}return i=i.slice(0,-1)}})),define("Core/queryToObject",["./defined","./DeveloperError","./isArray"],(function(e,t,r){"use strict";return function(n){if(!e(n))throw new t("queryString is required.");var i={};if(""===n)return i;for(var o=n.replace(/\+/g,"%20").split(/[&;]/),a=0,u=o.length;a<u;++a){var s=o[a].split("="),c=decodeURIComponent(s[0]),l=s[1];l=e(l)?decodeURIComponent(l):"";var f=i[c];"string"==typeof f?i[c]=[f,l]:r(f)?f.push(l):i[c]=l}return i}})),define("Core/RequestState",["../Core/freezeObject"],(function(e){"use strict";return e({UNISSUED:0,ISSUED:1,ACTIVE:2,RECEIVED:3,CANCELLED:4,FAILED:5})})),define("Core/RequestType",["../Core/freezeObject"],(function(e){"use strict";return e({TERRAIN:0,IMAGERY:1,TILES3D:2,OTHER:3})})),define("Core/Request",["./defaultValue","./defined","./RequestState","./RequestType"],(function(e,t,r,n){"use strict";function i(t){t=e(t,e.EMPTY_OBJECT);var i=e(t.throttleByServer,!1),o=i||e(t.throttle,!1);this.url=t.url,this.requestFunction=t.requestFunction,this.cancelFunction=t.cancelFunction,this.priorityFunction=t.priorityFunction,this.priority=e(t.priority,0),this.throttle=o,this.throttleByServer=i,this.type=e(t.type,n.OTHER),this.serverKey=void 0,this.state=r.UNISSUED,this.deferred=void 0,this.cancelled=!1}return i.prototype.cancel=function(){this.cancelled=!0},i.prototype.clone=function(e){return t(e)?(e.url=this.url,e.requestFunction=this.requestFunction,e.cancelFunction=this.cancelFunction,e.priorityFunction=this.priorityFunction,e.priority=this.priority,e.throttle=this.throttle,e.throttleByServer=this.throttleByServer,e.type=this.type,e.serverKey=this.serverKey,e.state=this.RequestState.UNISSUED,e.deferred=void 0,e.cancelled=!1,e):new i(this)},i})),define("Core/parseResponseHeaders",[],(function(){"use strict";return function(e){var t={};if(!e)return t;for(var r=e.split("\r\n"),n=0;n<r.length;++n){var i=r[n],o=i.indexOf(": ");if(o>0){var a=i.substring(0,o),u=i.substring(o+2);t[a]=u}}return t}})),define("Core/RequestErrorEvent",["./defined","./parseResponseHeaders"],(function(e,t){"use strict";function r(e,r,n){this.statusCode=e,this.response=r,this.responseHeaders=n,"string"==typeof this.responseHeaders&&(this.responseHeaders=t(this.responseHeaders))}return r.prototype.toString=function(){var t="Request has failed.";return e(this.statusCode)&&(t+=" Status Code: "+this.statusCode),t},r})),define("Core/Event",["./Check","./defined","./defineProperties"],(function(e,t,r){"use strict";function n(){this._listeners=[],this._scopes=[],this._toRemove=[],this._insideRaiseEvent=!1}function i(e,t){return t-e}return r(n.prototype,{numberOfListeners:{get:function(){return this._listeners.length-this._toRemove.length}}}),n.prototype.addEventListener=function(t,r){e.typeOf.func("listener",t),this._listeners.push(t),this._scopes.push(r);var n=this;return function(){n.removeEventListener(t,r)}},n.prototype.removeEventListener=function(t,r){e.typeOf.func("listener",t);for(var n=this._listeners,i=this._scopes,o=-1,a=0;a<n.length;a++)if(n[a]===t&&i[a]===r){o=a;break}return-1!==o&&(this._insideRaiseEvent?(this._toRemove.push(o),n[o]=void 0,i[o]=void 0):(n.splice(o,1),i.splice(o,1)),!0)},n.prototype.raiseEvent=function(){var e;this._insideRaiseEvent=!0;var r=this._listeners,n=this._scopes,o=r.length;for(e=0;e<o;e++){var a=r[e];t(a)&&r[e].apply(n[e],arguments)}var u=this._toRemove;if((o=u.length)>0){for(u.sort(i),e=0;e<o;e++){var s=u[e];r.splice(s,1),n.splice(s,1)}u.length=0}this._insideRaiseEvent=!1},n})),define("Core/Heap",["./Check","./defaultValue","./defined","./defineProperties"],(function(e,t,r,n){"use strict";function i(t){e.typeOf.object("options",t),e.defined("options.comparator",t.comparator),this._comparator=t.comparator,this._array=[],this._length=0,this._maximumLength=void 0}function o(e,t,r){var n=e[t];e[t]=e[r],e[r]=n}return n(i.prototype,{length:{get:function(){return this._length}},internalArray:{get:function(){return this._array}},maximumLength:{get:function(){return this._maximumLength},set:function(e){this._maximumLength=e,this._length>e&&e>0&&(this._length=e,this._array.length=e)}},comparator:{get:function(){return this._comparator}}}),i.prototype.reserve=function(e){e=t(e,this._length),this._array.length=e},i.prototype.heapify=function(e){e=t(e,0);for(var r=this._length,n=this._comparator,i=this._array,a=-1,u=!0;u;){var s=2*(e+1),c=s-1;a=c<r&&n(i[c],i[e])<0?c:e,s<r&&n(i[s],i[a])<0&&(a=s),a!==e?(o(i,a,e),e=a):u=!1}},i.prototype.resort=function(){for(var e=this._length,t=Math.ceil(e/2);t>=0;--t)this.heapify(t)},i.prototype.insert=function(t){e.defined("element",t);var n,i=this._array,a=this._comparator,u=this._maximumLength,s=this._length++;for(s<i.length?i[s]=t:i.push(t);0!==s;){var c=Math.floor((s-1)/2);if(!(a(i[s],i[c])<0))break;o(i,s,c),s=c}return r(u)&&this._length>u&&(n=i[u],this._length=u),n},i.prototype.pop=function(r){if(r=t(r,0),0!==this._length){e.typeOf.number.lessThan("index",r,this._length);var n=this._array,i=n[r];return o(n,r,--this._length),this.heapify(r),i}},i})),define("Core/RequestScheduler",["../ThirdParty/Uri","../ThirdParty/when","./Check","./defaultValue","./defined","./defineProperties","./Event","./Heap","./isBlobUri","./isDataUri","./RequestState"],(function(e,t,r,n,i,o,a,u,s,c,l){"use strict";var f={numberOfAttemptedRequests:0,numberOfActiveRequests:0,numberOfCancelledRequests:0,numberOfCancelledActiveRequests:0,numberOfFailedRequests:0,numberOfActiveRequestsEver:0},p=20,h=new u({comparator:function(e,t){return e.priority-t.priority}});h.maximumLength=p,h.reserve(p);var d=[],y={},m="undefined"!=typeof document?new e(document.location.href):new e,E=new a;function O(){}function v(e){i(e.priorityFunction)&&(e.priority=e.priorityFunction())}function w(e){var t=n(O.requestsByServer[e],O.maximumRequestsPerServer);return y[e]<t}function _(e){return e.state===l.UNISSUED&&(e.state=l.ISSUED,e.deferred=t.defer()),e.deferred.promise}function g(e){var t=_(e);return e.state=l.ACTIVE,d.push(e),++f.numberOfActiveRequests,++f.numberOfActiveRequestsEver,++y[e.serverKey],e.requestFunction().then(function(e){return function(t){e.state!==l.CANCELLED&&(--f.numberOfActiveRequests,--y[e.serverKey],E.raiseEvent(),e.state=l.RECEIVED,e.deferred.resolve(t))}}(e)).otherwise(function(e){return function(t){e.state!==l.CANCELLED&&(++f.numberOfFailedRequests,--f.numberOfActiveRequests,--y[e.serverKey],E.raiseEvent(t),e.state=l.FAILED,e.deferred.reject(t))}}(e)),t}function T(e){var t=e.state===l.ACTIVE;e.state=l.CANCELLED,++f.numberOfCancelledRequests,e.deferred.reject(),t&&(--f.numberOfActiveRequests,--y[e.serverKey],++f.numberOfCancelledActiveRequests),i(e.cancelFunction)&&e.cancelFunction()}return O.maximumRequests=50,O.maximumRequestsPerServer=6,O.requestsByServer={"api.cesium.com:443":18,"assets.cesium.com:443":18},O.throttleRequests=!0,O.debugShowStatistics=!1,O.requestCompletedEvent=E,o(O,{statistics:{get:function(){return f}},priorityHeapLength:{get:function(){return p},set:function(e){if(e<p)for(;h.length>e;)T(h.pop());p=e,h.maximumLength=e,h.reserve(e)}}}),O.update=function(){var e,t,r=0,n=d.length;for(e=0;e<n;++e)(t=d[e]).cancelled&&T(t),t.state===l.ACTIVE?r>0&&(d[e-r]=t):++r;d.length-=r;var i=h.internalArray,o=h.length;for(e=0;e<o;++e)v(i[e]);h.resort();for(var a=Math.max(O.maximumRequests-d.length,0),u=0;u<a&&h.length>0;)(t=h.pop()).cancelled?T(t):!t.throttleByServer||w(t.serverKey)?(g(t),++u):T(t);O.debugShowStatistics&&(f.numberOfAttemptedRequests>0&&console.log("Number of attempted requests: "+f.numberOfAttemptedRequests),f.numberOfActiveRequests>0&&console.log("Number of active requests: "+f.numberOfActiveRequests),f.numberOfCancelledRequests>0&&console.log("Number of cancelled requests: "+f.numberOfCancelledRequests),f.numberOfCancelledActiveRequests>0&&console.log("Number of cancelled active requests: "+f.numberOfCancelledActiveRequests),f.numberOfFailedRequests>0&&console.log("Number of failed requests: "+f.numberOfFailedRequests),f.numberOfAttemptedRequests=0,f.numberOfCancelledRequests=0,f.numberOfCancelledActiveRequests=0)},O.getServerKey=function(t){r.typeOf.string("url",t);var n=new e(t).resolve(m);n.normalize();var o=n.authority;/:/.test(o)||(o=o+":"+("https"===n.scheme?"443":"80"));var a=y[o];return i(a)||(y[o]=0),o},O.request=function(e){if(r.typeOf.object("request",e),r.typeOf.string("request.url",e.url),r.typeOf.func("request.requestFunction",e.requestFunction),c(e.url)||s(e.url))return E.raiseEvent(),e.state=l.RECEIVED,e.requestFunction();if(++f.numberOfAttemptedRequests,i(e.serverKey)||(e.serverKey=O.getServerKey(e.url)),!O.throttleRequests||!e.throttle)return g(e);if(!(d.length>=O.maximumRequests)&&(!e.throttleByServer||w(e.serverKey))){v(e);var t=h.insert(e);if(i(t)){if(t===e)return;T(t)}return _(e)}},O.clearForSpecs=function(){for(;h.length>0;)T(h.pop());for(var e=d.length,t=0;t<e;++t)T(d[t]);d.length=0,y={},f.numberOfAttemptedRequests=0,f.numberOfActiveRequests=0,f.numberOfCancelledRequests=0,f.numberOfCancelledActiveRequests=0,f.numberOfFailedRequests=0,f.numberOfActiveRequestsEver=0},O.numberOfActiveRequestsByServer=function(e){return y[e]},O.requestHeap=h,O})),define("Core/TrustedServers",["../ThirdParty/Uri","./defined","./DeveloperError"],(function(e,t,r){"use strict";var n={},i={};return n.add=function(e,n){if(!t(e))throw new r("host is required.");if(!t(n)||n<=0)throw new r("port is required to be greater than 0.");var o=e.toLowerCase()+":"+n;t(i[o])||(i[o]=!0)},n.remove=function(e,n){if(!t(e))throw new r("host is required.");if(!t(n)||n<=0)throw new r("port is required to be greater than 0.");var o=e.toLowerCase()+":"+n;t(i[o])&&delete i[o]},n.contains=function(n){if(!t(n))throw new r("url is required.");var o=function(r){var n=new e(r);n.normalize();var i=n.getAuthority();if(t(i)){if(-1!==i.indexOf("@")){var o=i.split("@");i=o[1]}if(-1===i.indexOf(":")){var a=n.getScheme();if(t(a)||(a=(a=window.location.protocol).substring(0,a.length-1)),"http"===a)i+=":80";else{if("https"!==a)return;i+=":443"}}return i}}(n);return!(!t(o)||!t(i[o]))},n.clear=function(){i={}},n})),define("Core/Resource",["../ThirdParty/Uri","../ThirdParty/when","./appendForwardSlash","./Check","./clone","./combine","./defaultValue","./defined","./defineProperties","./deprecationWarning","./DeveloperError","./freezeObject","./getAbsoluteUri","./getBaseUri","./getExtensionFromUri","./isBlobUri","./isCrossOriginUrl","./isDataUri","./loadAndExecuteScript","./objectToQuery","./queryToObject","./Request","./RequestErrorEvent","./RequestScheduler","./RequestState","./RuntimeError","./TrustedServers"],(function(e,t,r,n,i,o,a,u,s,c,l,f,p,h,d,y,m,E,O,v,w,_,g,T,b,R,A){"use strict";var x=function(){try{var e=new XMLHttpRequest;return e.open("GET","#",!0),e.responseType="blob","blob"===e.responseType}catch(e){return!1}}();function S(e,t,r,n){var i,o=e.query;if(!u(o)||0===o.length)return{};if(-1===o.indexOf("=")){var a={};a[o]=void 0,i=a}else i=w(o);t._queryParameters=r?M(i,t._queryParameters,n):i,e.query=void 0}function N(e,t){return u(e)?u(e.clone)?e.clone():i(e):t}function I(e){if(e.state===b.ISSUED||e.state===b.ACTIVE)throw new R("The Resource is already being fetched.");e.state=b.UNISSUED,e.deferred=void 0}function M(e,t,r){if(!r)return o(e,t);var n=i(e,!0);for(var a in t)if(t.hasOwnProperty(a)){var s=n[a],c=t[a];u(s)?(Array.isArray(s)||(s=n[a]=[s]),n[a]=s.concat(c)):n[a]=Array.isArray(c)?c.slice():c}return n}function C(t){"string"==typeof(t=a(t,a.EMPTY_OBJECT))&&(t={url:t}),n.typeOf.string("options.url",t.url),this._url=void 0,this._templateValues=N(t.templateValues,{}),this._queryParameters=N(t.queryParameters,{}),this.headers=N(t.headers,{}),this.request=a(t.request,new _),this.proxy=t.proxy,this.retryCallback=t.retryCallback,this.retryAttempts=a(t.retryAttempts,0),this._retryCount=0;var r=new e(t.url);S(r,this,!0,!0),r.fragment=void 0,this._url=r.toString()}function P(e){var r=e.request;r.url=e.url,r.requestFunction=function(){var r=e.url,n=!1;e.isDataUri||e.isBlobUri||(n=e.isCrossOriginUrl);var i=t.defer();return C._Implementations.createImage(r,n,i),i.promise};var n=T.request(r);if(u(n))return n.otherwise((function(n){return r.state!==b.FAILED?t.reject(n):e.retryOnError(n).then((function(i){return i?(r.state=b.UNISSUED,r.deferred=void 0,P(e)):t.reject(n)}))}))}C.createIfNeeded=function(e){return e instanceof C?e.getDerivedResource({request:e.request}):"string"!=typeof e?e:new C({url:e})},s(C,{isBlobSupported:{get:function(){return x}}}),s(C.prototype,{queryParameters:{get:function(){return this._queryParameters}},templateValues:{get:function(){return this._templateValues}},url:{get:function(){return this.getUrlComponent(!0,!0)},set:function(t){var r=new e(t);S(r,this,!1),r.fragment=void 0,this._url=r.toString()}},extension:{get:function(){return d(this._url)}},isDataUri:{get:function(){return E(this._url)}},isBlobUri:{get:function(){return y(this._url)}},isCrossOriginUrl:{get:function(){return m(this._url)}},hasHeaders:{get:function(){return Object.keys(this.headers).length>0}}}),C.prototype.getUrlComponent=function(t,r){if(this.isDataUri)return this._url;var n=new e(this._url);t&&function(e,t){var r=t._queryParameters,n=Object.keys(r);1!==n.length||u(r[n[0]])?e.query=v(r):e.query=n[0]}(n,this);var i=n.toString().replace(/%7B/g,"{").replace(/%7D/g,"}"),o=this._templateValues,a=Object.keys(o);if(a.length>0)for(var s=0;s<a.length;s++){var c=a[s],l=o[c];i=i.replace(new RegExp("{"+c+"}","g"),encodeURIComponent(l))}return r&&u(this.proxy)&&(i=this.proxy.getURL(i)),i},C.prototype.setQueryParameters=function(e,t){this._queryParameters=t?M(this._queryParameters,e,!1):M(e,this._queryParameters,!1)},C.prototype.addQueryParameters=function(e,t){return c("Resource.addQueryParameters","addQueryParameters has been deprecated and will be removed 1.45. Use setQueryParameters or appendQueryParameters instead."),this.setQueryParameters(e,t)},C.prototype.appendQueryParameters=function(e){this._queryParameters=M(e,this._queryParameters,!0)},C.prototype.setTemplateValues=function(e,t){this._templateValues=t?o(this._templateValues,e):o(e,this._templateValues)},C.prototype.addTemplateValues=function(e,t){return c("Resource.addTemplateValues","addTemplateValues has been deprecated and will be removed 1.45. Use setTemplateValues."),this.setTemplateValues(e,t)},C.prototype.getDerivedResource=function(t){var r=this.clone();if(r._retryCount=0,u(t.url)){var n=new e(t.url);S(n,r,!0,a(t.preserveQueryParameters,!1)),n.fragment=void 0,r._url=n.resolve(new e(p(this._url))).toString()}return u(t.queryParameters)&&(r._queryParameters=o(t.queryParameters,r._queryParameters)),u(t.templateValues)&&(r._templateValues=o(t.templateValues,r.templateValues)),u(t.headers)&&(r.headers=o(t.headers,r.headers)),u(t.proxy)&&(r.proxy=t.proxy),u(t.request)&&(r.request=t.request),u(t.retryCallback)&&(r.retryCallback=t.retryCallback),u(t.retryAttempts)&&(r.retryAttempts=t.retryAttempts),r},C.prototype.retryOnError=function(e){var r=this.retryCallback;if("function"!=typeof r||this._retryCount>=this.retryAttempts)return t(!1);var n=this;return t(r(this,e)).then((function(e){return++n._retryCount,e}))},C.prototype.clone=function(e){return u(e)||(e=new C({url:this._url})),e._url=this._url,e._queryParameters=i(this._queryParameters),e._templateValues=i(this._templateValues),e.headers=i(this.headers),e.proxy=this.proxy,e.retryCallback=this.retryCallback,e.retryAttempts=this.retryAttempts,e._retryCount=0,e.request=this.request.clone(),e},C.prototype.getBaseUri=function(e){return h(this.getUrlComponent(e),e)},C.prototype.appendForwardSlash=function(){this._url=r(this._url)},C.prototype.fetchArrayBuffer=function(){return this.fetch({responseType:"arraybuffer"})},C.fetchArrayBuffer=function(e){return new C(e).fetchArrayBuffer()},C.prototype.fetchBlob=function(){return this.fetch({responseType:"blob"})},C.fetchBlob=function(e){return new C(e).fetchBlob()},C.prototype.fetchImage=function(e){if(e=a(e,!1),I(this.request),!x||this.isDataUri||this.isBlobUri||!this.hasHeaders&&!e)return P(this);var r,n,i=this.fetchBlob();return u(i)?i.then((function(e){if(u(e)){n=e;var t=window.URL.createObjectURL(e);return P(r=new C({url:t}))}})).then((function(e){if(u(e))return window.URL.revokeObjectURL(r.url),e.blob=n,e})).otherwise((function(e){return u(r)&&window.URL.revokeObjectURL(r.url),t.reject(e)})):void 0},C.fetchImage=function(e){return new C(e).fetchImage(e.preferBlob)},C.prototype.fetchText=function(){return this.fetch({responseType:"text"})},C.fetchText=function(e){return new C(e).fetchText()},C.prototype.fetchJson=function(){var e=this.fetch({responseType:"text",headers:{Accept:"application/json,*/*;q=0.01"}});if(u(e))return e.then((function(e){if(u(e))return JSON.parse(e)}))},C.fetchJson=function(e){return new C(e).fetchJson()},C.prototype.fetchXML=function(){return this.fetch({responseType:"document",overrideMimeType:"text/xml"})},C.fetchXML=function(e){return new C(e).fetchXML()},C.prototype.fetchJsonp=function(e){var r;e=a(e,"callback"),I(this.request);do{r="loadJsonp"+Math.random().toString().substring(2,8)}while(u(window[r]));return function e(r,n,i){var o={};o[n]=i,r.setQueryParameters(o);var a=r.request;a.url=r.url,a.requestFunction=function(){var e=t.defer();return window[i]=function(t){e.resolve(t);try{delete window[i]}catch(e){window[i]=void 0}},C._Implementations.loadAndExecuteScript(r.url,i,e),e.promise};var s=T.request(a);if(u(s))return s.otherwise((function(o){return a.state!==b.FAILED?t.reject(o):r.retryOnError(o).then((function(u){return u?(a.state=b.UNISSUED,a.deferred=void 0,e(r,n,i)):t.reject(o)}))}))}(this,e,r)},C.fetchJsonp=function(e){return new C(e).fetchJsonp(e.callbackParameterName)},C.prototype._makeRequest=function(e){var r=this;I(r.request);var n=r.request;n.url=r.url,n.requestFunction=function(){var i=e.responseType,a=o(e.headers,r.headers),s=e.overrideMimeType,c=e.method,l=e.data,f=t.defer(),p=C._Implementations.loadWithXhr(r.url,i,c,l,a,f,s);return u(p)&&u(p.abort)&&(n.cancelFunction=function(){p.abort()}),f.promise};var i=T.request(n);if(u(i))return i.then((function(e){return e})).otherwise((function(i){return n.state!==b.FAILED?t.reject(i):r.retryOnError(i).then((function(o){return o?(n.state=b.UNISSUED,n.deferred=void 0,r.fetch(e)):t.reject(i)}))}))};var D=/^data:(.*?)(;base64)?,(.*)$/;function U(e,t){var r=decodeURIComponent(t);return e?atob(r):r}function L(e,t){for(var r=U(e,t),n=new ArrayBuffer(r.length),i=new Uint8Array(n),o=0;o<r.length;o++)i[o]=r.charCodeAt(o);return n}function q(e,t){switch(t){case"text":return e.toString("utf8");case"json":return JSON.parse(e.toString("utf8"));default:return new Uint8Array(e).buffer}}C.prototype.fetch=function(e){return(e=N(e,{})).method="GET",this._makeRequest(e)},C.fetch=function(e){return new C(e).fetch({responseType:e.responseType,overrideMimeType:e.overrideMimeType})},C.prototype.delete=function(e){return(e=N(e,{})).method="DELETE",this._makeRequest(e)},C.delete=function(e){return new C(e).delete({responseType:e.responseType,overrideMimeType:e.overrideMimeType,data:e.data})},C.prototype.head=function(e){return(e=N(e,{})).method="HEAD",this._makeRequest(e)},C.head=function(e){return new C(e).head({responseType:e.responseType,overrideMimeType:e.overrideMimeType})},C.prototype.options=function(e){return(e=N(e,{})).method="OPTIONS",this._makeRequest(e)},C.options=function(e){return new C(e).options({responseType:e.responseType,overrideMimeType:e.overrideMimeType})},C.prototype.post=function(e,t){return n.defined("data",e),(t=N(t,{})).method="POST",t.data=e,this._makeRequest(t)},C.post=function(e){return new C(e).post(e.data,{responseType:e.responseType,overrideMimeType:e.overrideMimeType})},C.prototype.put=function(e,t){return n.defined("data",e),(t=N(t,{})).method="PUT",t.data=e,this._makeRequest(t)},C.put=function(e){return new C(e).put(e.data,{responseType:e.responseType,overrideMimeType:e.overrideMimeType})},C.prototype.patch=function(e,t){return n.defined("data",e),(t=N(t,{})).method="PATCH",t.data=e,this._makeRequest(t)},C.patch=function(e){return new C(e).patch(e.data,{responseType:e.responseType,overrideMimeType:e.overrideMimeType})},C._Implementations={},C._Implementations.createImage=function(e,t,r){var n=new Image;n.onload=function(){r.resolve(n)},n.onerror=function(e){r.reject(e)},t&&(A.contains(e)?n.crossOrigin="use-credentials":n.crossOrigin=""),n.src=e};var F="undefined"==typeof XMLHttpRequest;return C._Implementations.loadWithXhr=function(e,t,r,n,i,o,s){var c=D.exec(e);if(null===c){if(!F){var f=new XMLHttpRequest;if(A.contains(e)&&(f.withCredentials=!0),f.open(r,e,!0),u(s)&&u(f.overrideMimeType)&&f.overrideMimeType(s),u(i))for(var p in i)i.hasOwnProperty(p)&&f.setRequestHeader(p,i[p]);u(t)&&(f.responseType=t);var h=!1;return"string"==typeof e&&(h=0===e.indexOf("file://")||"undefined"!=typeof window&&"file://"===window.location.origin),f.onload=function(){if(!(f.status<200||f.status>=300)||h&&0===f.status){var e=f.response,n=f.responseType;if("HEAD"===r||"OPTIONS"===r){var i=f.getAllResponseHeaders().trim().split(/[\r\n]+/),a={};return i.forEach((function(e){var t=e.split(": "),r=t.shift();a[r]=t.join(": ")})),void o.resolve(a)}if(204===f.status)o.resolve();else if(!u(e)||u(t)&&n!==t)if("json"===t&&"string"==typeof e)try{o.resolve(JSON.parse(e))}catch(e){o.reject(e)}else(""===n||"document"===n)&&u(f.responseXML)&&f.responseXML.hasChildNodes()?o.resolve(f.responseXML):""!==n&&"text"!==n||!u(f.responseText)?o.reject(new R("Invalid XMLHttpRequest response type.")):o.resolve(f.responseText);else o.resolve(e)}else o.reject(new g(f.status,f.response,f.getAllResponseHeaders()))},f.onerror=function(e){o.reject(new g)},f.send(n),f}!function(e,t,r,n,i,o,a){var u=require("url").parse(e),s="https:"===u.protocol?require("https"):require("http"),c=require("zlib"),l={protocol:u.protocol,hostname:u.hostname,port:u.port,path:u.path,query:u.query,method:r,headers:i};s.request(l).on("response",(function(e){if(e.statusCode<200||e.statusCode>=300)o.reject(new g(e.statusCode,e,e.headers));else{var r=[];e.on("data",(function(e){r.push(e)})),e.on("end",(function(){var n=Buffer.concat(r);"gzip"===e.headers["content-encoding"]?c.gunzip(n,(function(e,r){e?o.reject(new R("Error decompressing response.")):o.resolve(q(r,t))})):o.resolve(q(n,t))}))}})).on("error",(function(e){o.reject(new g)})).end()}(e,t,r,0,i,o)}else o.resolve(function(e,t){t=a(t,"");var r=e[1],n=!!e[2],i=e[3];switch(t){case"":case"text":return U(n,i);case"arraybuffer":return L(n,i);case"blob":var o=L(n,i);return new Blob([o],{type:r});case"document":return(new DOMParser).parseFromString(U(n,i),r);case"json":return JSON.parse(U(n,i));default:throw new l("Unhandled responseType: "+t)}}(c,t))},C._Implementations.loadAndExecuteScript=function(e,t,r){return O(e,t).otherwise(r.reject)},C._DefaultImplementations={},C._DefaultImplementations.createImage=C._Implementations.createImage,C._DefaultImplementations.loadWithXhr=C._Implementations.loadWithXhr,C._DefaultImplementations.loadAndExecuteScript=C._Implementations.loadAndExecuteScript,C.DEFAULT=f(new C({url:"undefined"==typeof document?"":document.location.href.split("?")[0]})),C})),define("Core/EarthOrientationParameters",["../ThirdParty/when","./binarySearch","./defaultValue","./defined","./EarthOrientationParametersSample","./freezeObject","./JulianDate","./LeapSecond","./Resource","./RuntimeError","./TimeConstants","./TimeStandard"],(function(e,t,r,n,i,o,a,u,s,c,l,f){"use strict";function p(t){if(t=r(t,r.EMPTY_OBJECT),this._dates=void 0,this._samples=void 0,this._dateColumn=-1,this._xPoleWanderRadiansColumn=-1,this._yPoleWanderRadiansColumn=-1,this._ut1MinusUtcSecondsColumn=-1,this._xCelestialPoleOffsetRadiansColumn=-1,this._yCelestialPoleOffsetRadiansColumn=-1,this._taiMinusUtcSecondsColumn=-1,this._columnCount=0,this._lastIndex=-1,this._downloadPromise=void 0,this._dataError=void 0,this._addNewLeapSeconds=r(t.addNewLeapSeconds,!0),n(t.data))d(this,t.data);else if(n(t.url)){var i=s.createIfNeeded(t.url),o=this;this._downloadPromise=e(i.fetchJson(),(function(e){d(o,e)}),(function(){o._dataError="An error occurred while retrieving the EOP data from the URL "+i.url+"."}))}else d(this,{columnNames:["dateIso8601","modifiedJulianDateUtc","xPoleWanderRadians","yPoleWanderRadians","ut1MinusUtcSeconds","lengthOfDayCorrectionSeconds","xCelestialPoleOffsetRadians","yCelestialPoleOffsetRadians","taiMinusUtcSeconds"],samples:[]})}function h(e,t){return a.compare(e.julianDate,t)}function d(e,r){if(n(r.columnNames))if(n(r.samples)){var i=r.columnNames.indexOf("modifiedJulianDateUtc"),o=r.columnNames.indexOf("xPoleWanderRadians"),s=r.columnNames.indexOf("yPoleWanderRadians"),c=r.columnNames.indexOf("ut1MinusUtcSeconds"),p=r.columnNames.indexOf("xCelestialPoleOffsetRadians"),d=r.columnNames.indexOf("yCelestialPoleOffsetRadians"),y=r.columnNames.indexOf("taiMinusUtcSeconds");if(i<0||o<0||s<0||c<0||p<0||d<0||y<0)e._dataError="Error in loaded EOP data: The columnNames property must include modifiedJulianDateUtc, xPoleWanderRadians, yPoleWanderRadians, ut1MinusUtcSeconds, xCelestialPoleOffsetRadians, yCelestialPoleOffsetRadians, and taiMinusUtcSeconds columns";else{var m,E=e._samples=r.samples,O=e._dates=[];e._dateColumn=i,e._xPoleWanderRadiansColumn=o,e._yPoleWanderRadiansColumn=s,e._ut1MinusUtcSecondsColumn=c,e._xCelestialPoleOffsetRadiansColumn=p,e._yCelestialPoleOffsetRadiansColumn=d,e._taiMinusUtcSecondsColumn=y,e._columnCount=r.columnNames.length,e._lastIndex=void 0;for(var v=e._addNewLeapSeconds,w=0,_=E.length;w<_;w+=e._columnCount){var g=E[w+i],T=E[w+y],b=g+l.MODIFIED_JULIAN_DATE_DIFFERENCE,R=new a(b,T,f.TAI);if(O.push(R),v){if(T!==m&&n(m)){var A=a.leapSeconds,x=t(A,R,h);if(x<0){var S=new u(R,T);A.splice(~x,0,S)}}m=T}}}}else e._dataError="Error in loaded EOP data: The samples property is required.";else e._dataError="Error in loaded EOP data: The columnNames property is required."}function y(e,t,r,n,i){var o=r*n;i.xPoleWander=t[o+e._xPoleWanderRadiansColumn],i.yPoleWander=t[o+e._yPoleWanderRadiansColumn],i.xPoleOffset=t[o+e._xCelestialPoleOffsetRadiansColumn],i.yPoleOffset=t[o+e._yCelestialPoleOffsetRadiansColumn],i.ut1MinusUtc=t[o+e._ut1MinusUtcSecondsColumn]}function m(e,t,r){return t+e*(r-t)}function E(e,t,r,n,i,o,u){var s=e._columnCount;if(o>t.length-1)return u.xPoleWander=0,u.yPoleWander=0,u.xPoleOffset=0,u.yPoleOffset=0,u.ut1MinusUtc=0,u;var c=t[i],l=t[o];if(c.equals(l)||n.equals(c))return y(e,r,i,s,u),u;if(n.equals(l))return y(e,r,o,s,u),u;var f=a.secondsDifference(n,c)/a.secondsDifference(l,c),p=i*s,h=o*s,d=r[p+e._ut1MinusUtcSecondsColumn],E=r[h+e._ut1MinusUtcSecondsColumn],O=E-d;if(O>.5||O<-.5){var v=r[p+e._taiMinusUtcSecondsColumn],w=r[h+e._taiMinusUtcSecondsColumn];v!==w&&(l.equals(n)?d=E:E-=w-v)}return u.xPoleWander=m(f,r[p+e._xPoleWanderRadiansColumn],r[h+e._xPoleWanderRadiansColumn]),u.yPoleWander=m(f,r[p+e._yPoleWanderRadiansColumn],r[h+e._yPoleWanderRadiansColumn]),u.xPoleOffset=m(f,r[p+e._xCelestialPoleOffsetRadiansColumn],r[h+e._xCelestialPoleOffsetRadiansColumn]),u.yPoleOffset=m(f,r[p+e._yCelestialPoleOffsetRadiansColumn],r[h+e._yCelestialPoleOffsetRadiansColumn]),u.ut1MinusUtc=m(f,d,E),u}return p.NONE=o({getPromiseToLoad:function(){return e()},compute:function(e,t){return n(t)?(t.xPoleWander=0,t.yPoleWander=0,t.xPoleOffset=0,t.yPoleOffset=0,t.ut1MinusUtc=0):t=new i(0,0,0,0,0),t}}),p.prototype.getPromiseToLoad=function(){return e(this._downloadPromise)},p.prototype.compute=function(e,r){if(n(this._samples)){if(n(r)||(r=new i(0,0,0,0,0)),0===this._samples.length)return r.xPoleWander=0,r.yPoleWander=0,r.xPoleOffset=0,r.yPoleOffset=0,r.ut1MinusUtc=0,r;var o=this._dates,u=this._lastIndex,s=0,l=0;if(n(u)){var f=o[u],p=o[u+1],h=a.lessThanOrEquals(f,e),d=!n(p),y=d||a.greaterThanOrEquals(p,e);if(h&&y)return s=u,!d&&p.equals(e)&&++s,l=s+1,E(this,o,this._samples,e,s,l,r),r}var m=t(o,e,a.compare,this._dateColumn);return m>=0?(m<o.length-1&&o[m+1].equals(e)&&++m,s=m,l=m):(s=(l=~m)-1)<0&&(s=0),this._lastIndex=s,E(this,o,this._samples,e,s,l,r),r}if(n(this._dataError))throw new c(this._dataError)},p})),define("Core/HeadingPitchRoll",["./defaultValue","./defined","./DeveloperError","./Math"],(function(e,t,r,n){"use strict";function i(t,r,n){this.heading=e(t,0),this.pitch=e(r,0),this.roll=e(n,0)}return i.fromQuaternion=function(e,n){if(!t(e))throw new r("quaternion is required");t(n)||(n=new i);var o=2*(e.w*e.y-e.z*e.x),a=1-2*(e.x*e.x+e.y*e.y),u=2*(e.w*e.x+e.y*e.z),s=1-2*(e.y*e.y+e.z*e.z),c=2*(e.w*e.z+e.x*e.y);return n.heading=-Math.atan2(c,s),n.roll=Math.atan2(u,a),n.pitch=-Math.asin(o),n},i.fromDegrees=function(e,o,a,u){if(!t(e))throw new r("heading is required");if(!t(o))throw new r("pitch is required");if(!t(a))throw new r("roll is required");return t(u)||(u=new i),u.heading=e*n.RADIANS_PER_DEGREE,u.pitch=o*n.RADIANS_PER_DEGREE,u.roll=a*n.RADIANS_PER_DEGREE,u},i.clone=function(e,r){if(t(e))return t(r)?(r.heading=e.heading,r.pitch=e.pitch,r.roll=e.roll,r):new i(e.heading,e.pitch,e.roll)},i.equals=function(e,r){return e===r||t(e)&&t(r)&&e.heading===r.heading&&e.pitch===r.pitch&&e.roll===r.roll},i.equalsEpsilon=function(e,r,i,o){return e===r||t(e)&&t(r)&&n.equalsEpsilon(e.heading,r.heading,i,o)&&n.equalsEpsilon(e.pitch,r.pitch,i,o)&&n.equalsEpsilon(e.roll,r.roll,i,o)},i.prototype.clone=function(e){return i.clone(this,e)},i.prototype.equals=function(e){return i.equals(this,e)},i.prototype.equalsEpsilon=function(e,t,r){return i.equalsEpsilon(this,e,t,r)},i.prototype.toString=function(){return"("+this.heading+", "+this.pitch+", "+this.roll+")"},i})),define("Core/buildModuleUrl",["./defined","./DeveloperError","./getAbsoluteUri","./Resource","require"],(function(e,t,r,n,i){"use strict";var o,a,u,s=/((?:.*\/)|^)cesium[\w-]*\.js(?:\W|$)/i;function c(t){return"undefined"==typeof document?t:(e(o)||(o=document.createElement("a")),o.href=t,o.href=o.href,o.href)}function l(){if(e(a))return a;var o;if(o="undefined"!=typeof CESIUM_BASE_URL?CESIUM_BASE_URL:e(define.amd)&&!define.amd.toUrlUndefined&&e(i.toUrl)?r("..",h("Core/buildModuleUrl.js")):function(){for(var e=document.getElementsByTagName("script"),t=0,r=e.length;t<r;++t){var n=e[t].getAttribute("src"),i=s.exec(n);if(null!==i)return i[1]}}(),!e(o))throw new t("Unable to determine Cesium base URL automatically, try defining a global variable called CESIUM_BASE_URL.");return(a=new n({url:c(o)})).appendForwardSlash(),a}function f(e){return c(i.toUrl("../"+e))}function p(e){return l().getDerivedResource({url:e}).url}function h(t){return e(u)||(u=e(define.amd)&&!define.amd.toUrlUndefined&&e(i.toUrl)?f:p),u(t)}return h._cesiumScriptRegex=s,h._buildModuleUrlFromBaseUrl=p,h._clearBaseResource=function(){a=void 0},h.setBaseUrl=function(e){a=n.DEFAULT.getDerivedResource({url:e})},h.getCesiumBaseUrl=l,h})),define("Core/Iau2006XysSample",[],(function(){"use strict";return function(e,t,r){this.x=e,this.y=t,this.s=r}})),define("Core/Iau2006XysData",["../ThirdParty/when","./buildModuleUrl","./defaultValue","./defined","./Iau2006XysSample","./JulianDate","./Resource","./TimeStandard"],(function(e,t,r,n,i,o,a,u){"use strict";function s(e){e=r(e,r.EMPTY_OBJECT),this._xysFileUrlTemplate=a.createIfNeeded(e.xysFileUrlTemplate),this._interpolationOrder=r(e.interpolationOrder,9),this._sampleZeroJulianEphemerisDate=r(e.sampleZeroJulianEphemerisDate,2442396.5),this._sampleZeroDateTT=new o(this._sampleZeroJulianEphemerisDate,0,u.TAI),this._stepSizeDays=r(e.stepSizeDays,1),this._samplesPerXysFile=r(e.samplesPerXysFile,1e3),this._totalSamples=r(e.totalSamples,27426),this._samples=new Array(3*this._totalSamples),this._chunkDownloadsInProgress=[];for(var t=this._interpolationOrder,n=this._denominators=new Array(t+1),i=this._xTable=new Array(t+1),s=Math.pow(this._stepSizeDays,t),c=0;c<=t;++c){n[c]=s,i[c]=c*this._stepSizeDays;for(var l=0;l<=t;++l)l!==c&&(n[c]*=c-l);n[c]=1/n[c]}this._work=new Array(t+1),this._coef=new Array(t+1)}var c=new o(0,0,u.TAI);function l(e,t,r){var n=c;return n.dayNumber=t,n.secondsOfDay=r,o.daysDifference(n,e._sampleZeroDateTT)}function f(r,i){if(r._chunkDownloadsInProgress[i])return r._chunkDownloadsInProgress[i];var o,u=e.defer();r._chunkDownloadsInProgress[i]=u;var s=r._xysFileUrlTemplate;return o=n(s)?s.getDerivedResource({templateValues:{0:i}}):new a({url:t("Assets/IAU2006_XYS/IAU2006_XYS_"+i+".json")}),e(o.fetchJson(),(function(e){r._chunkDownloadsInProgress[i]=!1;for(var t=r._samples,n=e.samples,o=i*r._samplesPerXysFile*3,a=0,s=n.length;a<s;++a)t[o+a]=n[a];u.resolve()})),u.promise}return s.prototype.preload=function(t,r,n,i){var o=l(this,t,r),a=l(this,n,i),u=o/this._stepSizeDays-this._interpolationOrder/2|0;u<0&&(u=0);var s=a/this._stepSizeDays-this._interpolationOrder/2|0+this._interpolationOrder;s>=this._totalSamples&&(s=this._totalSamples-1);for(var c=u/this._samplesPerXysFile|0,p=s/this._samplesPerXysFile|0,h=[],d=c;d<=p;++d)h.push(f(this,d));return e.all(h)},s.prototype.computeXysRadians=function(e,t,r){var o=l(this,e,t);if(!(o<0)){var a=o/this._stepSizeDays|0;if(!(a>=this._totalSamples)){var u=this._interpolationOrder,s=a-(u/2|0);s<0&&(s=0);var c=s+u;c>=this._totalSamples&&(s=(c=this._totalSamples-1)-u)<0&&(s=0);var p=!1,h=this._samples;if(n(h[3*s])||(f(this,s/this._samplesPerXysFile|0),p=!0),n(h[3*c])||(f(this,c/this._samplesPerXysFile|0),p=!0),!p){n(r)?(r.x=0,r.y=0,r.s=0):r=new i(0,0,0);var d,y,m=o-s*this._stepSizeDays,E=this._work,O=this._denominators,v=this._coef,w=this._xTable;for(d=0;d<=u;++d)E[d]=m-w[d];for(d=0;d<=u;++d){for(v[d]=1,y=0;y<=u;++y)y!==d&&(v[d]*=E[y]);v[d]*=O[d];var _=3*(s+d);r.x+=v[d]*h[_++],r.y+=v[d]*h[_++],r.s+=v[d]*h[_]}return r}}}},s})),define("Core/Quaternion",["./Cartesian3","./Check","./defaultValue","./defined","./FeatureDetection","./freezeObject","./Math","./Matrix3"],(function(e,t,r,n,i,o,a,u){"use strict";function s(e,t,n,i){this.x=r(e,0),this.y=r(t,0),this.z=r(n,0),this.w=r(i,0)}var c=new e;s.fromAxisAngle=function(r,i,o){t.typeOf.object("axis",r),t.typeOf.number("angle",i);var a=i/2,u=Math.sin(a),l=(c=e.normalize(r,c)).x*u,f=c.y*u,p=c.z*u,h=Math.cos(a);return n(o)?(o.x=l,o.y=f,o.z=p,o.w=h,o):new s(l,f,p,h)};var l=[1,2,0],f=new Array(3);s.fromRotationMatrix=function(e,r){var i,o,a,c,p;t.typeOf.object("matrix",e);var h=e[u.COLUMN0ROW0],d=e[u.COLUMN1ROW1],y=e[u.COLUMN2ROW2],m=h+d+y;if(m>0)p=.5*(i=Math.sqrt(m+1)),i=.5/i,o=(e[u.COLUMN1ROW2]-e[u.COLUMN2ROW1])*i,a=(e[u.COLUMN2ROW0]-e[u.COLUMN0ROW2])*i,c=(e[u.COLUMN0ROW1]-e[u.COLUMN1ROW0])*i;else{var E=0;d>h&&(E=1),y>h&&y>d&&(E=2);var O=l[E],v=l[O];i=Math.sqrt(e[u.getElementIndex(E,E)]-e[u.getElementIndex(O,O)]-e[u.getElementIndex(v,v)]+1);var w=f;w[E]=.5*i,i=.5/i,p=(e[u.getElementIndex(v,O)]-e[u.getElementIndex(O,v)])*i,w[O]=(e[u.getElementIndex(O,E)]+e[u.getElementIndex(E,O)])*i,w[v]=(e[u.getElementIndex(v,E)]+e[u.getElementIndex(E,v)])*i,o=-w[0],a=-w[1],c=-w[2]}return n(r)?(r.x=o,r.y=a,r.z=c,r.w=p,r):new s(o,a,c,p)};var p=new s,h=new s,d=new s,y=new s;s.fromHeadingPitchRoll=function(r,n){return t.typeOf.object("headingPitchRoll",r),y=s.fromAxisAngle(e.UNIT_X,r.roll,p),d=s.fromAxisAngle(e.UNIT_Y,-r.pitch,n),n=s.multiply(d,y,d),h=s.fromAxisAngle(e.UNIT_Z,-r.heading,p),s.multiply(h,n,n)};var m=new e,E=new e,O=new s,v=new s,w=new s;s.packedLength=4,s.pack=function(e,n,i){return t.typeOf.object("value",e),t.defined("array",n),i=r(i,0),n[i++]=e.x,n[i++]=e.y,n[i++]=e.z,n[i]=e.w,n},s.unpack=function(e,i,o){return t.defined("array",e),i=r(i,0),n(o)||(o=new s),o.x=e[i],o.y=e[i+1],o.z=e[i+2],o.w=e[i+3],o},s.packedInterpolationLength=3,s.convertPackedArrayForInterpolation=function(e,t,r,n){s.unpack(e,4*r,w),s.conjugate(w,w);for(var i=0,o=r-t+1;i<o;i++){var a=3*i;s.unpack(e,4*(t+i),O),s.multiply(O,w,O),O.w<0&&s.negate(O,O),s.computeAxis(O,m);var u=s.computeAngle(O);n[a]=m.x*u,n[a+1]=m.y*u,n[a+2]=m.z*u}},s.unpackInterpolationResult=function(t,r,i,o,a){n(a)||(a=new s),e.fromArray(t,0,E);var u=e.magnitude(E);return s.unpack(r,4*o,v),0===u?s.clone(s.IDENTITY,O):s.fromAxisAngle(E,u,O),s.multiply(O,v,a)},s.clone=function(e,t){if(n(e))return n(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t.w=e.w,t):new s(e.x,e.y,e.z,e.w)},s.conjugate=function(e,r){return t.typeOf.object("quaternion",e),t.typeOf.object("result",r),r.x=-e.x,r.y=-e.y,r.z=-e.z,r.w=e.w,r},s.magnitudeSquared=function(e){return t.typeOf.object("quaternion",e),e.x*e.x+e.y*e.y+e.z*e.z+e.w*e.w},s.magnitude=function(e){return Math.sqrt(s.magnitudeSquared(e))},s.normalize=function(e,r){t.typeOf.object("result",r);var n=1/s.magnitude(e),i=e.x*n,o=e.y*n,a=e.z*n,u=e.w*n;return r.x=i,r.y=o,r.z=a,r.w=u,r},s.inverse=function(e,r){t.typeOf.object("result",r);var n=s.magnitudeSquared(e);return r=s.conjugate(e,r),s.multiplyByScalar(r,1/n,r)},s.add=function(e,r,n){return t.typeOf.object("left",e),t.typeOf.object("right",r),t.typeOf.object("result",n),n.x=e.x+r.x,n.y=e.y+r.y,n.z=e.z+r.z,n.w=e.w+r.w,n},s.subtract=function(e,r,n){return t.typeOf.object("left",e),t.typeOf.object("right",r),t.typeOf.object("result",n),n.x=e.x-r.x,n.y=e.y-r.y,n.z=e.z-r.z,n.w=e.w-r.w,n},s.negate=function(e,r){return t.typeOf.object("quaternion",e),t.typeOf.object("result",r),r.x=-e.x,r.y=-e.y,r.z=-e.z,r.w=-e.w,r},s.dot=function(e,r){return t.typeOf.object("left",e),t.typeOf.object("right",r),e.x*r.x+e.y*r.y+e.z*r.z+e.w*r.w},s.multiply=function(e,r,n){t.typeOf.object("left",e),t.typeOf.object("right",r),t.typeOf.object("result",n);var i=e.x,o=e.y,a=e.z,u=e.w,s=r.x,c=r.y,l=r.z,f=r.w,p=u*s+i*f+o*l-a*c,h=u*c-i*l+o*f+a*s,d=u*l+i*c-o*s+a*f,y=u*f-i*s-o*c-a*l;return n.x=p,n.y=h,n.z=d,n.w=y,n},s.multiplyByScalar=function(e,r,n){return t.typeOf.object("quaternion",e),t.typeOf.number("scalar",r),t.typeOf.object("result",n),n.x=e.x*r,n.y=e.y*r,n.z=e.z*r,n.w=e.w*r,n},s.divideByScalar=function(e,r,n){return t.typeOf.object("quaternion",e),t.typeOf.number("scalar",r),t.typeOf.object("result",n),n.x=e.x/r,n.y=e.y/r,n.z=e.z/r,n.w=e.w/r,n},s.computeAxis=function(e,r){t.typeOf.object("quaternion",e),t.typeOf.object("result",r);var n=e.w;if(Math.abs(n-1)<a.EPSILON6)return r.x=r.y=r.z=0,r;var i=1/Math.sqrt(1-n*n);return r.x=e.x*i,r.y=e.y*i,r.z=e.z*i,r},s.computeAngle=function(e){return t.typeOf.object("quaternion",e),Math.abs(e.w-1)<a.EPSILON6?0:2*Math.acos(e.w)};var _=new s;s.lerp=function(e,r,n,i){return t.typeOf.object("start",e),t.typeOf.object("end",r),t.typeOf.number("t",n),t.typeOf.object("result",i),_=s.multiplyByScalar(r,n,_),i=s.multiplyByScalar(e,1-n,i),s.add(_,i,i)};var g=new s,T=new s,b=new s;s.slerp=function(e,r,n,i){t.typeOf.object("start",e),t.typeOf.object("end",r),t.typeOf.number("t",n),t.typeOf.object("result",i);var o=s.dot(e,r),u=r;if(o<0&&(o=-o,u=g=s.negate(r,g)),1-o<a.EPSILON6)return s.lerp(e,u,n,i);var c=Math.acos(o);return T=s.multiplyByScalar(e,Math.sin((1-n)*c),T),b=s.multiplyByScalar(u,Math.sin(n*c),b),i=s.add(T,b,i),s.multiplyByScalar(i,1/Math.sin(c),i)},s.log=function(r,n){t.typeOf.object("quaternion",r),t.typeOf.object("result",n);var i=a.acosClamped(r.w),o=0;return 0!==i&&(o=i/Math.sin(i)),e.multiplyByScalar(r,o,n)},s.exp=function(r,n){t.typeOf.object("cartesian",r),t.typeOf.object("result",n);var i=e.magnitude(r),o=0;return 0!==i&&(o=Math.sin(i)/i),n.x=r.x*o,n.y=r.y*o,n.z=r.z*o,n.w=Math.cos(i),n};var R=new e,A=new e,x=new s,S=new s;s.computeInnerQuadrangle=function(r,n,i,o){t.typeOf.object("q0",r),t.typeOf.object("q1",n),t.typeOf.object("q2",i),t.typeOf.object("result",o);var a=s.conjugate(n,x);s.multiply(a,i,S);var u=s.log(S,R);s.multiply(a,r,S);var c=s.log(S,A);return e.add(u,c,u),e.multiplyByScalar(u,.25,u),e.negate(u,u),s.exp(u,x),s.multiply(n,x,o)},s.squad=function(e,r,n,i,o,a){t.typeOf.object("q0",e),t.typeOf.object("q1",r),t.typeOf.object("s0",n),t.typeOf.object("s1",i),t.typeOf.number("t",o),t.typeOf.object("result",a);var u=s.slerp(e,r,o,x),c=s.slerp(n,i,o,S);return s.slerp(u,c,2*o*(1-o),a)};for(var N=new s,I=1.9011074535173003,M=i.supportsTypedArrays()?new Float32Array(8):[],C=i.supportsTypedArrays()?new Float32Array(8):[],P=i.supportsTypedArrays()?new Float32Array(8):[],D=i.supportsTypedArrays()?new Float32Array(8):[],U=0;U<7;++U){var L=U+1,q=2*L+1;M[U]=1/(L*q),C[U]=L/q}return M[7]=I/136,C[7]=8*I/17,s.fastSlerp=function(e,r,n,i){t.typeOf.object("start",e),t.typeOf.object("end",r),t.typeOf.number("t",n),t.typeOf.object("result",i);var o,a=s.dot(e,r);a>=0?o=1:(o=-1,a=-a);for(var u=a-1,c=1-n,l=n*n,f=c*c,p=7;p>=0;--p)P[p]=(M[p]*l-C[p])*u,D[p]=(M[p]*f-C[p])*u;var h=o*n*(1+P[0]*(1+P[1]*(1+P[2]*(1+P[3]*(1+P[4]*(1+P[5]*(1+P[6]*(1+P[7])))))))),d=c*(1+D[0]*(1+D[1]*(1+D[2]*(1+D[3]*(1+D[4]*(1+D[5]*(1+D[6]*(1+D[7])))))))),y=s.multiplyByScalar(e,d,N);return s.multiplyByScalar(r,h,i),s.add(y,i,i)},s.fastSquad=function(e,r,n,i,o,a){t.typeOf.object("q0",e),t.typeOf.object("q1",r),t.typeOf.object("s0",n),t.typeOf.object("s1",i),t.typeOf.number("t",o),t.typeOf.object("result",a);var u=s.fastSlerp(e,r,o,x),c=s.fastSlerp(n,i,o,S);return s.fastSlerp(u,c,2*o*(1-o),a)},s.equals=function(e,t){return e===t||n(e)&&n(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z&&e.w===t.w},s.equalsEpsilon=function(e,r,i){return t.typeOf.number("epsilon",i),e===r||n(e)&&n(r)&&Math.abs(e.x-r.x)<=i&&Math.abs(e.y-r.y)<=i&&Math.abs(e.z-r.z)<=i&&Math.abs(e.w-r.w)<=i},s.ZERO=o(new s(0,0,0,0)),s.IDENTITY=o(new s(0,0,0,1)),s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s.prototype.equalsEpsilon=function(e,t){return s.equalsEpsilon(this,e,t)},s.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"},s})),define("Core/Transforms",["../ThirdParty/when","./Cartesian2","./Cartesian3","./Cartesian4","./Cartographic","./Check","./defaultValue","./defined","./DeveloperError","./EarthOrientationParameters","./EarthOrientationParametersSample","./Ellipsoid","./HeadingPitchRoll","./Iau2006XysData","./Iau2006XysSample","./JulianDate","./Math","./Matrix3","./Matrix4","./Quaternion","./TimeConstants"],(function(e,t,r,n,i,o,a,u,s,c,l,f,p,h,d,y,m,E,O,v,w){"use strict";var _={},g={up:{south:"east",north:"west",west:"south",east:"north"},down:{south:"west",north:"east",west:"north",east:"south"},south:{up:"west",down:"east",west:"down",east:"up"},north:{up:"east",down:"west",west:"up",east:"down"},west:{up:"north",down:"south",north:"down",south:"up"},east:{up:"south",down:"north",north:"up",south:"down"}},T={north:[-1,0,0],east:[0,1,0],up:[0,0,1],south:[1,0,0],west:[0,-1,0],down:[0,0,-1]},b={},R={east:new r,north:new r,up:new r,west:new r,south:new r,down:new r},A=new r,x=new r,S=new r;_.localFrameToFixedFrameGenerator=function(e,t){if(!g.hasOwnProperty(e)||!g[e].hasOwnProperty(t))throw new s("firstAxis and secondAxis must be east, north, up, west, south or down.");var n,i=g[e][t],o=e+t;return u(b[o])?n=b[o]:(n=function(n,o,c){if(!u(n))throw new s("origin is required.");if(u(c)||(c=new O),m.equalsEpsilon(n.x,0,m.EPSILON14)&&m.equalsEpsilon(n.y,0,m.EPSILON14)){var l=m.sign(n.z);r.unpack(T[e],0,A),"east"!==e&&"west"!==e&&r.multiplyByScalar(A,l,A),r.unpack(T[t],0,x),"east"!==t&&"west"!==t&&r.multiplyByScalar(x,l,x),r.unpack(T[i],0,S),"east"!==i&&"west"!==i&&r.multiplyByScalar(S,l,S)}else{(o=a(o,f.WGS84)).geodeticSurfaceNormal(n,R.up);var p=R.up,h=R.east;h.x=-n.y,h.y=n.x,h.z=0,r.normalize(h,R.east),r.cross(p,h,R.north),r.multiplyByScalar(R.up,-1,R.down),r.multiplyByScalar(R.east,-1,R.west),r.multiplyByScalar(R.north,-1,R.south),A=R[e],x=R[t],S=R[i]}return c[0]=A.x,c[1]=A.y,c[2]=A.z,c[3]=0,c[4]=x.x,c[5]=x.y,c[6]=x.z,c[7]=0,c[8]=S.x,c[9]=S.y,c[10]=S.z,c[11]=0,c[12]=n.x,c[13]=n.y,c[14]=n.z,c[15]=1,c},b[o]=n),n},_.eastNorthUpToFixedFrame=_.localFrameToFixedFrameGenerator("east","north"),_.northEastDownToFixedFrame=_.localFrameToFixedFrameGenerator("north","east"),_.northUpEastToFixedFrame=_.localFrameToFixedFrameGenerator("north","up"),_.northWestUpToFixedFrame=_.localFrameToFixedFrameGenerator("north","west");var N=new v,I=new r(1,1,1),M=new O;_.headingPitchRollToFixedFrame=function(e,t,n,i,u){o.typeOf.object("HeadingPitchRoll",t),i=a(i,_.eastNorthUpToFixedFrame);var s=v.fromHeadingPitchRoll(t,N),c=O.fromTranslationQuaternionRotationScale(r.ZERO,s,I,M);return u=i(e,n,u),O.multiply(u,c,u)};var C=new O,P=new E;_.headingPitchRollQuaternion=function(e,t,r,n,i){o.typeOf.object("HeadingPitchRoll",t);var a=_.headingPitchRollToFixedFrame(e,t,r,n,C),u=O.getRotation(a,P);return v.fromRotationMatrix(u,i)};var D=new r(1,1,1),U=new r,L=new O,q=new O,F=new E,j=new v;_.fixedFrameToHeadingPitchRoll=function(e,t,n,i){o.defined("transform",e),t=a(t,f.WGS84),n=a(n,_.eastNorthUpToFixedFrame),u(i)||(i=new p);var s=O.getTranslation(e,U);if(r.equals(s,r.ZERO))return i.heading=0,i.pitch=0,i.roll=0,i;var c=O.inverseTransformation(n(s,t,L),L),l=O.setScale(e,D,q);l=O.setTranslation(l,r.ZERO,l),c=O.multiply(c,l,c);var h=v.fromRotationMatrix(O.getRotation(c,F),j);return h=v.normalize(h,h),p.fromQuaternion(h,i)};var B=m.TWO_PI/86400,z=new y;_.computeTemeToPseudoFixedMatrix=function(e,t){if(!u(e))throw new s("date is required.");var r,n=(z=y.addSeconds(e,-y.computeTaiMinusUtc(e),z)).dayNumber,i=z.secondsOfDay,o=n-2451545,a=(24110.54841+(r=i>=43200?(o+.5)/w.DAYS_PER_JULIAN_CENTURY:(o-.5)/w.DAYS_PER_JULIAN_CENTURY)*(8640184.812866+r*(.093104+-62e-7*r)))*B%m.TWO_PI+(72921158553e-15+11772758384668e-32*(n-2451545.5))*((i+.5*w.SECONDS_PER_DAY)%w.SECONDS_PER_DAY),c=Math.cos(a),l=Math.sin(a);return u(t)?(t[0]=c,t[1]=-l,t[2]=0,t[3]=l,t[4]=c,t[5]=0,t[6]=0,t[7]=0,t[8]=1,t):new E(c,l,0,-l,c,0,0,0,1)},_.iau2006XysData=new h,_.earthOrientationParameters=c.NONE,_.preloadIcrfFixed=function(t){var r=t.start.dayNumber,n=t.start.secondsOfDay+32.184,i=t.stop.dayNumber,o=t.stop.secondsOfDay+32.184,a=_.iau2006XysData.preload(r,n,i,o),u=_.earthOrientationParameters.getPromiseToLoad();return e.all([a,u])},_.computeIcrfToFixedMatrix=function(e,t){if(!u(e))throw new s("date is required.");u(t)||(t=new E);var r=_.computeFixedToIcrfMatrix(e,t);if(u(r))return E.transpose(r,t)};var G=new d(0,0,0),V=new l(0,0,0,0,0,0),H=new E,W=new E;_.computeFixedToIcrfMatrix=function(e,t){if(!u(e))throw new s("date is required.");u(t)||(t=new E);var r=_.earthOrientationParameters.compute(e,V);if(u(r)){var n=e.dayNumber,i=e.secondsOfDay+32.184,o=_.iau2006XysData.computeXysRadians(n,i,G);if(u(o)){var a=o.x+r.xPoleOffset,c=o.y+r.yPoleOffset,l=1/(1+Math.sqrt(1-a*a-c*c)),f=H;f[0]=1-l*a*a,f[3]=-l*a*c,f[6]=a,f[1]=-l*a*c,f[4]=1-l*c*c,f[7]=c,f[2]=-a,f[5]=-c,f[8]=1-l*(a*a+c*c);var p=E.fromRotationZ(-o.s,W),h=E.multiply(f,p,H),d=e.dayNumber-2451545,O=(e.secondsOfDay-y.computeTaiMinusUtc(e)+r.ut1MinusUtc)/w.SECONDS_PER_DAY,v=.779057273264+O+.00273781191135448*(d+O);v=v%1*m.TWO_PI;var g=E.fromRotationZ(v,W),T=E.multiply(h,g,H),b=Math.cos(r.xPoleWander),R=Math.cos(r.yPoleWander),A=Math.sin(r.xPoleWander),x=Math.sin(r.yPoleWander),S=n-2451545+i/w.SECONDS_PER_DAY,N=-47e-6*(S/=36525)*m.RADIANS_PER_DEGREE/3600,I=Math.cos(N),M=Math.sin(N),C=W;return C[0]=b*I,C[1]=b*M,C[2]=A,C[3]=-R*M+x*A*I,C[4]=R*I+x*A*M,C[5]=-x*b,C[6]=-x*M-R*A*I,C[7]=x*I-R*A*M,C[8]=R*b,E.multiply(T,C,t)}}};var X=new n;_.pointToWindowCoordinates=function(e,t,r,n){return(n=_.pointToGLWindowCoordinates(e,t,r,n)).y=2*t[5]-n.y,n},_.pointToGLWindowCoordinates=function(e,r,i,o){if(!u(e))throw new s("modelViewProjectionMatrix is required.");if(!u(r))throw new s("viewportTransformation is required.");if(!u(i))throw new s("point is required.");u(o)||(o=new t);var a=X;return O.multiplyByVector(e,n.fromElements(i.x,i.y,i.z,1,a),a),n.multiplyByScalar(a,1/a.w,a),O.multiplyByVector(r,a,a),t.fromCartesian4(a,o)};var k=new r,Y=new r,Z=new r;_.rotationMatrixFromPositionVelocity=function(e,t,n,i){if(!u(e))throw new s("position is required.");if(!u(t))throw new s("velocity is required.");var o=a(n,f.WGS84).geodeticSurfaceNormal(e,k),c=r.cross(t,o,Y);r.equalsEpsilon(c,r.ZERO,m.EPSILON6)&&(c=r.clone(r.UNIT_X,c));var l=r.cross(c,t,Z);return r.normalize(l,l),r.cross(t,l,c),r.negate(c,c),r.normalize(c,c),u(i)||(i=new E),i[0]=t.x,i[1]=t.y,i[2]=t.z,i[3]=c.x,i[4]=c.y,i[5]=c.z,i[6]=l.x,i[7]=l.y,i[8]=l.z,i};var K=new O(0,0,1,0,1,0,0,0,0,1,0,0,0,0,0,1),Q=new i,J=new r,$=new r,ee=new E,te=new O,re=new O;return _.basisTo2D=function(e,t,n){if(!u(e))throw new s("projection is required.");if(!u(t))throw new s("matrix is required.");if(!u(n))throw new s("result is required.");var i=O.getTranslation(t,$),o=e.ellipsoid,a=o.cartesianToCartographic(i,Q),c=e.project(a,J);r.fromElements(c.z,c.x,c.y,c);var l=_.eastNorthUpToFixedFrame(i,o,te),f=O.inverseTransformation(l,re),p=O.getRotation(t,ee),h=O.multiplyByMatrix3(f,p,n);return O.multiply(K,h,n),O.setTranslation(n,c,n),n},_.wgs84To2DModelMatrix=function(e,t,n){if(!u(e))throw new s("projection is required.");if(!u(t))throw new s("center is required.");if(!u(n))throw new s("result is required.");var i=e.ellipsoid,o=_.eastNorthUpToFixedFrame(t,i,te),a=O.inverseTransformation(o,re),c=i.cartesianToCartographic(t,Q),l=e.project(c,J);r.fromElements(l.z,l.x,l.y,l);var f=O.fromTranslation(l,te);return O.multiply(K,a,n),O.multiply(f,n,n),n},_})),define("Core/EllipsoidTangentPlane",["./AxisAlignedBoundingBox","./Cartesian2","./Cartesian3","./Cartesian4","./Check","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid","./IntersectionTests","./Matrix4","./Plane","./Ray","./Transforms"],(function(e,t,r,n,i,o,a,u,s,c,l,f,p,h,d){"use strict";var y=new n;function m(e,t){if(i.defined("origin",e),e=(t=o(t,c.WGS84)).scaleToGeodeticSurface(e),!a(e))throw new s("origin must not be at the center of the ellipsoid.");var n=d.eastNorthUpToFixedFrame(e,t);this._ellipsoid=t,this._origin=e,this._xAxis=r.fromCartesian4(f.getColumn(n,0,y)),this._yAxis=r.fromCartesian4(f.getColumn(n,1,y));var u=r.fromCartesian4(f.getColumn(n,2,y));this._plane=p.fromPointNormal(e,u)}u(m.prototype,{ellipsoid:{get:function(){return this._ellipsoid}},origin:{get:function(){return this._origin}},plane:{get:function(){return this._plane}},xAxis:{get:function(){return this._xAxis}},yAxis:{get:function(){return this._yAxis}},zAxis:{get:function(){return this._plane.normal}}});var E=new e;m.fromPoints=function(t,r){return i.defined("cartesians",t),new m(e.fromPoints(t,E).center,r)};var O=new h,v=new r;m.prototype.projectPointOntoPlane=function(e,n){i.defined("cartesian",e);var o=O;o.origin=e,r.normalize(e,o.direction);var u=l.rayPlane(o,this._plane,v);if(a(u)||(r.negate(o.direction,o.direction),u=l.rayPlane(o,this._plane,v)),a(u)){var s=r.subtract(u,this._origin,u),c=r.dot(this._xAxis,s),f=r.dot(this._yAxis,s);return a(n)?(n.x=c,n.y=f,n):new t(c,f)}},m.prototype.projectPointsOntoPlane=function(e,t){i.defined("cartesians",e),a(t)||(t=[]);for(var r=0,n=e.length,o=0;o<n;o++){var u=this.projectPointOntoPlane(e[o],t[r]);a(u)&&(t[r]=u,r++)}return t.length=r,t},m.prototype.projectPointToNearestOnPlane=function(e,n){i.defined("cartesian",e),a(n)||(n=new t);var o=O;o.origin=e,r.clone(this._plane.normal,o.direction);var u=l.rayPlane(o,this._plane,v);a(u)||(r.negate(o.direction,o.direction),u=l.rayPlane(o,this._plane,v));var s=r.subtract(u,this._origin,u),c=r.dot(this._xAxis,s),f=r.dot(this._yAxis,s);return n.x=c,n.y=f,n},m.prototype.projectPointsToNearestOnPlane=function(e,t){i.defined("cartesians",e),a(t)||(t=[]);var r=e.length;t.length=r;for(var n=0;n<r;n++)t[n]=this.projectPointToNearestOnPlane(e[n],t[n]);return t};var w=new r;return m.prototype.projectPointOntoEllipsoid=function(e,t){i.defined("cartesian",e),a(t)||(t=new r);var n=this._ellipsoid,o=this._origin,u=this._xAxis,s=this._yAxis,c=w;return r.multiplyByScalar(u,e.x,c),t=r.add(o,c,t),r.multiplyByScalar(s,e.y,c),r.add(t,c,t),n.scaleToGeocentricSurface(t,t),t},m.prototype.projectPointsOntoEllipsoid=function(e,t){i.defined("cartesians",e);var r=e.length;a(t)?t.length=r:t=new Array(r);for(var n=0;n<r;++n)t[n]=this.projectPointOntoEllipsoid(e[n],t[n]);return t},m})),define("Core/GeometryOffsetAttribute",["../Core/freezeObject"],(function(e){"use strict";return e({NONE:0,TOP:1,ALL:2})})),define("Core/GeometryType",["./freezeObject"],(function(e){"use strict";return e({NONE:0,TRIANGLES:1,LINES:2,POLYLINES:3})})),define("Core/Matrix2",["./Cartesian2","./Check","./defaultValue","./defined","./defineProperties","./freezeObject"],(function(e,t,r,n,i,o){"use strict";function a(e,t,n,i){this[0]=r(e,0),this[1]=r(n,0),this[2]=r(t,0),this[3]=r(i,0)}a.packedLength=4,a.pack=function(e,n,i){return t.typeOf.object("value",e),t.defined("array",n),i=r(i,0),n[i++]=e[0],n[i++]=e[1],n[i++]=e[2],n[i++]=e[3],n},a.unpack=function(e,i,o){return t.defined("array",e),i=r(i,0),n(o)||(o=new a),o[0]=e[i++],o[1]=e[i++],o[2]=e[i++],o[3]=e[i++],o},a.clone=function(e,t){if(n(e))return n(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t):new a(e[0],e[2],e[1],e[3])},a.fromArray=function(e,i,o){return t.defined("array",e),i=r(i,0),n(o)||(o=new a),o[0]=e[i],o[1]=e[i+1],o[2]=e[i+2],o[3]=e[i+3],o},a.fromColumnMajorArray=function(e,r){return t.defined("values",e),a.clone(e,r)},a.fromRowMajorArray=function(e,r){return t.defined("values",e),n(r)?(r[0]=e[0],r[1]=e[2],r[2]=e[1],r[3]=e[3],r):new a(e[0],e[1],e[2],e[3])},a.fromScale=function(e,r){return t.typeOf.object("scale",e),n(r)?(r[0]=e.x,r[1]=0,r[2]=0,r[3]=e.y,r):new a(e.x,0,0,e.y)},a.fromUniformScale=function(e,r){return t.typeOf.number("scale",e),n(r)?(r[0]=e,r[1]=0,r[2]=0,r[3]=e,r):new a(e,0,0,e)},a.fromRotation=function(e,r){t.typeOf.number("angle",e);var i=Math.cos(e),o=Math.sin(e);return n(r)?(r[0]=i,r[1]=o,r[2]=-o,r[3]=i,r):new a(i,-o,o,i)},a.toArray=function(e,r){return t.typeOf.object("matrix",e),n(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r):[e[0],e[1],e[2],e[3]]},a.getElementIndex=function(e,r){return t.typeOf.number.greaterThanOrEquals("row",r,0),t.typeOf.number.lessThanOrEquals("row",r,1),t.typeOf.number.greaterThanOrEquals("column",e,0),t.typeOf.number.lessThanOrEquals("column",e,1),2*e+r},a.getColumn=function(e,r,n){t.typeOf.object("matrix",e),t.typeOf.number.greaterThanOrEquals("index",r,0),t.typeOf.number.lessThanOrEquals("index",r,1),t.typeOf.object("result",n);var i=2*r,o=e[i],a=e[i+1];return n.x=o,n.y=a,n},a.setColumn=function(e,r,n,i){t.typeOf.object("matrix",e),t.typeOf.number.greaterThanOrEquals("index",r,0),t.typeOf.number.lessThanOrEquals("index",r,1),t.typeOf.object("cartesian",n),t.typeOf.object("result",i);var o=2*r;return(i=a.clone(e,i))[o]=n.x,i[o+1]=n.y,i},a.getRow=function(e,r,n){t.typeOf.object("matrix",e),t.typeOf.number.greaterThanOrEquals("index",r,0),t.typeOf.number.lessThanOrEquals("index",r,1),t.typeOf.object("result",n);var i=e[r],o=e[r+2];return n.x=i,n.y=o,n},a.setRow=function(e,r,n,i){return t.typeOf.object("matrix",e),t.typeOf.number.greaterThanOrEquals("index",r,0),t.typeOf.number.lessThanOrEquals("index",r,1),t.typeOf.object("cartesian",n),t.typeOf.object("result",i),(i=a.clone(e,i))[r]=n.x,i[r+2]=n.y,i};var u=new e;a.getScale=function(r,n){return t.typeOf.object("matrix",r),t.typeOf.object("result",n),n.x=e.magnitude(e.fromElements(r[0],r[1],u)),n.y=e.magnitude(e.fromElements(r[2],r[3],u)),n};var s=new e;return a.getMaximumScale=function(t){return a.getScale(t,s),e.maximumComponent(s)},a.multiply=function(e,r,n){t.typeOf.object("left",e),t.typeOf.object("right",r),t.typeOf.object("result",n);var i=e[0]*r[0]+e[2]*r[1],o=e[0]*r[2]+e[2]*r[3],a=e[1]*r[0]+e[3]*r[1],u=e[1]*r[2]+e[3]*r[3];return n[0]=i,n[1]=a,n[2]=o,n[3]=u,n},a.add=function(e,r,n){return t.typeOf.object("left",e),t.typeOf.object("right",r),t.typeOf.object("result",n),n[0]=e[0]+r[0],n[1]=e[1]+r[1],n[2]=e[2]+r[2],n[3]=e[3]+r[3],n},a.subtract=function(e,r,n){return t.typeOf.object("left",e),t.typeOf.object("right",r),t.typeOf.object("result",n),n[0]=e[0]-r[0],n[1]=e[1]-r[1],n[2]=e[2]-r[2],n[3]=e[3]-r[3],n},a.multiplyByVector=function(e,r,n){t.typeOf.object("matrix",e),t.typeOf.object("cartesian",r),t.typeOf.object("result",n);var i=e[0]*r.x+e[2]*r.y,o=e[1]*r.x+e[3]*r.y;return n.x=i,n.y=o,n},a.multiplyByScalar=function(e,r,n){return t.typeOf.object("matrix",e),t.typeOf.number("scalar",r),t.typeOf.object("result",n),n[0]=e[0]*r,n[1]=e[1]*r,n[2]=e[2]*r,n[3]=e[3]*r,n},a.multiplyByScale=function(e,r,n){return t.typeOf.object("matrix",e),t.typeOf.object("scale",r),t.typeOf.object("result",n),n[0]=e[0]*r.x,n[1]=e[1]*r.x,n[2]=e[2]*r.y,n[3]=e[3]*r.y,n},a.negate=function(e,r){return t.typeOf.object("matrix",e),t.typeOf.object("result",r),r[0]=-e[0],r[1]=-e[1],r[2]=-e[2],r[3]=-e[3],r},a.transpose=function(e,r){t.typeOf.object("matrix",e),t.typeOf.object("result",r);var n=e[0],i=e[2],o=e[1],a=e[3];return r[0]=n,r[1]=i,r[2]=o,r[3]=a,r},a.abs=function(e,r){return t.typeOf.object("matrix",e),t.typeOf.object("result",r),r[0]=Math.abs(e[0]),r[1]=Math.abs(e[1]),r[2]=Math.abs(e[2]),r[3]=Math.abs(e[3]),r},a.equals=function(e,t){return e===t||n(e)&&n(t)&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[3]===t[3]},a.equalsArray=function(e,t,r){return e[0]===t[r]&&e[1]===t[r+1]&&e[2]===t[r+2]&&e[3]===t[r+3]},a.equalsEpsilon=function(e,r,i){return t.typeOf.number("epsilon",i),e===r||n(e)&&n(r)&&Math.abs(e[0]-r[0])<=i&&Math.abs(e[1]-r[1])<=i&&Math.abs(e[2]-r[2])<=i&&Math.abs(e[3]-r[3])<=i},a.IDENTITY=o(new a(1,0,0,1)),a.ZERO=o(new a(0,0,0,0)),a.COLUMN0ROW0=0,a.COLUMN0ROW1=1,a.COLUMN1ROW0=2,a.COLUMN1ROW1=3,i(a.prototype,{length:{get:function(){return a.packedLength}}}),a.prototype.clone=function(e){return a.clone(this,e)},a.prototype.equals=function(e){return a.equals(this,e)},a.prototype.equalsEpsilon=function(e,t){return a.equalsEpsilon(this,e,t)},a.prototype.toString=function(){return"("+this[0]+", "+this[2]+")\n("+this[1]+", "+this[3]+")"},a})),define("Core/PrimitiveType",["./freezeObject","./WebGLConstants"],(function(e,t){"use strict";var r={POINTS:t.POINTS,LINES:t.LINES,LINE_LOOP:t.LINE_LOOP,LINE_STRIP:t.LINE_STRIP,TRIANGLES:t.TRIANGLES,TRIANGLE_STRIP:t.TRIANGLE_STRIP,TRIANGLE_FAN:t.TRIANGLE_FAN,validate:function(e){return e===r.POINTS||e===r.LINES||e===r.LINE_LOOP||e===r.LINE_STRIP||e===r.TRIANGLES||e===r.TRIANGLE_STRIP||e===r.TRIANGLE_FAN}};return e(r)})),define("Core/Geometry",["./Cartesian2","./Cartesian3","./Cartographic","./Check","./defaultValue","./defined","./DeveloperError","./GeometryOffsetAttribute","./GeometryType","./Matrix2","./Matrix3","./Matrix4","./PrimitiveType","./Quaternion","./Rectangle","./Transforms"],(function(e,t,r,n,i,o,a,u,s,c,l,f,p,h,d,y){"use strict";function m(e){e=i(e,i.EMPTY_OBJECT),n.typeOf.object("options.attributes",e.attributes),this.attributes=e.attributes,this.indices=e.indices,this.primitiveType=i(e.primitiveType,p.TRIANGLES),this.boundingSphere=e.boundingSphere,this.geometryType=i(e.geometryType,s.NONE),this.boundingSphereCV=e.boundingSphereCV,this.offsetAttribute=e.offsetAttribute}m.computeNumberOfVertices=function(e){n.typeOf.object("geometry",e);var t=-1;for(var r in e.attributes)if(e.attributes.hasOwnProperty(r)&&o(e.attributes[r])&&o(e.attributes[r].values)){var i=e.attributes[r],u=i.values.length/i.componentsPerAttribute;if(t!==u&&-1!==t)throw new a("All attribute lists must have the same number of attributes.");t=u}return t};var E=new r,O=new t,v=new f,w=[new r,new r,new r],_=[new e,new e,new e],g=[new e,new e,new e],T=new t,b=new h,R=new f,A=new c;return m._textureCoordinateRotationPoints=function(n,i,o,a){var u,s=d.center(a,E),p=r.toCartesian(s,o,O),m=y.eastNorthUpToFixedFrame(p,o,v),x=f.inverse(m,v),S=_,N=w;N[0].longitude=a.west,N[0].latitude=a.south,N[1].longitude=a.west,N[1].latitude=a.north,N[2].longitude=a.east,N[2].latitude=a.south;var I=T;for(u=0;u<3;u++)r.toCartesian(N[u],o,I),I=f.multiplyByPointAsVector(x,I,I),S[u].x=I.x,S[u].y=I.y;var M=h.fromAxisAngle(t.UNIT_Z,-i,b),C=l.fromQuaternion(M,R),P=n.length,D=Number.POSITIVE_INFINITY,U=Number.POSITIVE_INFINITY,L=Number.NEGATIVE_INFINITY,q=Number.NEGATIVE_INFINITY;for(u=0;u<P;u++)I=f.multiplyByPointAsVector(x,n[u],I),I=l.multiplyByVector(C,I,I),D=Math.min(D,I.x),U=Math.min(U,I.y),L=Math.max(L,I.x),q=Math.max(q,I.y);var F=c.fromRotation(i,A),j=g;j[0].x=D,j[0].y=U,j[1].x=D,j[1].y=q,j[2].x=L,j[2].y=U;var B=S[0],z=S[2].x-B.x,G=S[1].y-B.y;for(u=0;u<3;u++){var V=j[u];c.multiplyByVector(F,V,V),V.x=(V.x-B.x)/z,V.y=(V.y-B.y)/G}var H=j[0],W=j[1],X=j[2],k=new Array(6);return e.pack(H,k),e.pack(W,k,2),e.pack(X,k,4),k},m})),define("Core/GeometryAttribute",["./defaultValue","./defined","./DeveloperError"],(function(e,t,r){"use strict";return function(n){if(n=e(n,e.EMPTY_OBJECT),!t(n.componentDatatype))throw new r("options.componentDatatype is required.");if(!t(n.componentsPerAttribute))throw new r("options.componentsPerAttribute is required.");if(n.componentsPerAttribute<1||n.componentsPerAttribute>4)throw new r("options.componentsPerAttribute must be between 1 and 4.");if(!t(n.values))throw new r("options.values is required.");this.componentDatatype=n.componentDatatype,this.componentsPerAttribute=n.componentsPerAttribute,this.normalize=e(n.normalize,!1),this.values=n.values}})),define("Core/GeometryInstance",["./defaultValue","./defined","./DeveloperError","./Matrix4"],(function(e,t,r,n){"use strict";return function(i){if(i=e(i,e.EMPTY_OBJECT),!t(i.geometry))throw new r("options.geometry is required.");this.geometry=i.geometry,this.modelMatrix=n.clone(e(i.modelMatrix,n.IDENTITY)),this.id=i.id,this.pickPrimitive=i.pickPrimitive,this.attributes=e(i.attributes,{}),this.westHemisphereGeometry=void 0,this.eastHemisphereGeometry=void 0}})),define("Core/AttributeCompression",["./Cartesian2","./Cartesian3","./Check","./defined","./DeveloperError","./Math"],(function(e,t,r,n,i,o){"use strict";var a={octEncodeInRange:function(e,n,a){r.defined("vector",e),r.defined("result",a);var u=t.magnitudeSquared(e);if(Math.abs(u-1)>o.EPSILON6)throw new i("vector must be normalized.");if(a.x=e.x/(Math.abs(e.x)+Math.abs(e.y)+Math.abs(e.z)),a.y=e.y/(Math.abs(e.x)+Math.abs(e.y)+Math.abs(e.z)),e.z<0){var s=a.x,c=a.y;a.x=(1-Math.abs(c))*o.signNotZero(s),a.y=(1-Math.abs(s))*o.signNotZero(c)}return a.x=o.toSNorm(a.x,n),a.y=o.toSNorm(a.y,n),a},octEncode:function(e,t){return a.octEncodeInRange(e,255,t)}},u=new e,s=new Uint8Array(1);function c(e){return s[0]=e,s[0]}a.octEncodeToCartesian4=function(e,t){return a.octEncodeInRange(e,65535,u),t.x=c(u.x*(1/256)),t.y=c(u.x),t.z=c(u.y*(1/256)),t.w=c(u.y),t},a.octDecodeInRange=function(e,n,a,u){if(r.defined("result",u),e<0||e>a||n<0||n>a)throw new i("x and y must be unsigned normalized integers between 0 and "+a);if(u.x=o.fromSNorm(e,a),u.y=o.fromSNorm(n,a),u.z=1-(Math.abs(u.x)+Math.abs(u.y)),u.z<0){var s=u.x;u.x=(1-Math.abs(u.y))*o.signNotZero(s),u.y=(1-Math.abs(s))*o.signNotZero(u.y)}return t.normalize(u,u)},a.octDecode=function(e,t,r){return a.octDecodeInRange(e,t,255,r)},a.octDecodeFromCartesian4=function(e,t){r.typeOf.object("encoded",e),r.typeOf.object("result",t);var n=e.x,o=e.y,u=e.z,s=e.w;if(n<0||n>255||o<0||o>255||u<0||u>255||s<0||s>255)throw new i("x, y, z, and w must be unsigned normalized integers between 0 and 255");var c=256*n+o,l=256*u+s;return a.octDecodeInRange(c,l,65535,t)},a.octPackFloat=function(e){return r.defined("encoded",e),256*e.x+e.y};var l=new e;function f(e){return e>>1^-(1&e)}return a.octEncodeFloat=function(e){return a.octEncode(e,l),a.octPackFloat(l)},a.octDecodeFloat=function(e,t){r.defined("value",e);var n=e/256,i=Math.floor(n),o=256*(n-i);return a.octDecode(i,o,t)},a.octPack=function(e,t,n,i){r.defined("v1",e),r.defined("v2",t),r.defined("v3",n),r.defined("result",i);var o=a.octEncodeFloat(e),u=a.octEncodeFloat(t),s=a.octEncode(n,l);return i.x=65536*s.x+o,i.y=65536*s.y+u,i},a.octUnpack=function(e,t,n,i){r.defined("packed",e),r.defined("v1",t),r.defined("v2",n),r.defined("v3",i);var o=e.x/65536,u=Math.floor(o),s=65536*(o-u);o=e.y/65536;var c=Math.floor(o),l=65536*(o-c);a.octDecodeFloat(s,t),a.octDecodeFloat(l,n),a.octDecode(u,c,i)},a.compressTextureCoordinates=function(e){return r.defined("textureCoordinates",e),4096*(4095*e.x|0)+(4095*e.y|0)},a.decompressTextureCoordinates=function(e,t){r.defined("compressed",e),r.defined("result",t);var n=e/4096,i=Math.floor(n);return t.x=i/4095,t.y=(e-4096*i)/4095,t},a.zigZagDeltaDecode=function(e,t,i){r.defined("uBuffer",e),r.defined("vBuffer",t),r.typeOf.number.equals("uBuffer.length","vBuffer.length",e.length,t.length),n(i)&&r.typeOf.number.equals("uBuffer.length","heightBuffer.length",e.length,i.length);for(var o=e.length,a=0,u=0,s=0,c=0;c<o;++c)a+=f(e[c]),u+=f(t[c]),e[c]=a,t[c]=u,n(i)&&(s+=f(i[c]),i[c]=s)},a})),define("Core/barycentricCoordinates",["./Cartesian2","./Cartesian3","./Check","./defined","./Math"],(function(e,t,r,n,i){"use strict";var o=new t,a=new t,u=new t;return function(s,c,l,f,p){var h,d,y,m,E,O,v,w;if(r.defined("point",s),r.defined("p0",c),r.defined("p1",l),r.defined("p2",f),n(p)||(p=new t),n(c.z)){if(t.equalsEpsilon(s,c,i.EPSILON14))return t.clone(t.UNIT_X,p);if(t.equalsEpsilon(s,l,i.EPSILON14))return t.clone(t.UNIT_Y,p);if(t.equalsEpsilon(s,f,i.EPSILON14))return t.clone(t.UNIT_Z,p);h=t.subtract(l,c,o),d=t.subtract(f,c,a),y=t.subtract(s,c,u),m=t.dot(h,h),E=t.dot(h,d),O=t.dot(h,y),v=t.dot(d,d),w=t.dot(d,y)}else{if(e.equalsEpsilon(s,c,i.EPSILON14))return t.clone(t.UNIT_X,p);if(e.equalsEpsilon(s,l,i.EPSILON14))return t.clone(t.UNIT_Y,p);if(e.equalsEpsilon(s,f,i.EPSILON14))return t.clone(t.UNIT_Z,p);h=e.subtract(l,c,o),d=e.subtract(f,c,a),y=e.subtract(s,c,u),m=e.dot(h,h),E=e.dot(h,d),O=e.dot(h,y),v=e.dot(d,d),w=e.dot(d,y)}var _=1/(m*v-E*E);return p.y=(v*O-E*w)*_,p.z=(m*w-E*O)*_,p.x=1-p.y-p.z,p}})),define("Core/EncodedCartesian3",["./Cartesian3","./Check","./defined"],(function(e,t,r){"use strict";function n(){this.high=e.clone(e.ZERO),this.low=e.clone(e.ZERO)}n.encode=function(e,n){var i;return t.typeOf.number("value",e),r(n)||(n={high:0,low:0}),e>=0?(i=65536*Math.floor(e/65536),n.high=i,n.low=e-i):(i=65536*Math.floor(-e/65536),n.high=-i,n.low=e+i),n};var i={high:0,low:0};n.fromCartesian=function(e,o){t.typeOf.object("cartesian",e),r(o)||(o=new n);var a=o.high,u=o.low;return n.encode(e.x,i),a.x=i.high,u.x=i.low,n.encode(e.y,i),a.y=i.high,u.y=i.low,n.encode(e.z,i),a.z=i.high,u.z=i.low,o};var o=new n;return n.writeElements=function(e,r,i){t.defined("cartesianArray",r),t.typeOf.number("index",i),t.typeOf.number.greaterThanOrEquals("index",i,0),n.fromCartesian(e,o);var a=o.high,u=o.low;r[i]=a.x,r[i+1]=a.y,r[i+2]=a.z,r[i+3]=u.x,r[i+4]=u.y,r[i+5]=u.z},n})),define("Core/IndexDatatype",["./defined","./DeveloperError","./freezeObject","./Math","./WebGLConstants"],(function(e,t,r,n,i){"use strict";var o={UNSIGNED_BYTE:i.UNSIGNED_BYTE,UNSIGNED_SHORT:i.UNSIGNED_SHORT,UNSIGNED_INT:i.UNSIGNED_INT,getSizeInBytes:function(e){switch(e){case o.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case o.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case o.UNSIGNED_INT:return Uint32Array.BYTES_PER_ELEMENT}throw new t("indexDatatype is required and must be a valid IndexDatatype constant.")},validate:function(t){return e(t)&&(t===o.UNSIGNED_BYTE||t===o.UNSIGNED_SHORT||t===o.UNSIGNED_INT)},createTypedArray:function(r,i){if(!e(r))throw new t("numberOfVertices is required.");return r>=n.SIXTY_FOUR_KILOBYTES?new Uint32Array(i):new Uint16Array(i)},createTypedArrayFromArrayBuffer:function(r,i,o,a){if(!e(r))throw new t("numberOfVertices is required.");if(!e(i))throw new t("sourceArray is required.");if(!e(o))throw new t("byteOffset is required.");return r>=n.SIXTY_FOUR_KILOBYTES?new Uint32Array(i,o,a):new Uint16Array(i,o,a)}};return r(o)})),define("Core/Tipsify",["./defaultValue","./defined","./DeveloperError"],(function(e,t,r){"use strict";var n={calculateACMR:function(n){var i=(n=e(n,e.EMPTY_OBJECT)).indices,o=n.maximumIndex,a=e(n.cacheSize,24);if(!t(i))throw new r("indices is required.");var u=i.length;if(u<3||u%3!=0)throw new r("indices length must be a multiple of three.");if(o<=0)throw new r("maximumIndex must be greater than zero.");if(a<3)throw new r("cacheSize must be greater than two.");if(!t(o)){o=0;for(var s=0,c=i[s];s<u;)c>o&&(o=c),c=i[++s]}for(var l=[],f=0;f<o+1;f++)l[f]=0;for(var p=a+1,h=0;h<u;++h)p-l[i[h]]>a&&(l[i[h]]=p,++p);return(p-a+1)/(u/3)},tipsify:function(n){var i,o=(n=e(n,e.EMPTY_OBJECT)).indices,a=n.maximumIndex,u=e(n.cacheSize,24);function s(e,t,r,n,o,a,u){for(var s,c=-1,l=-1,f=0;f<r.length;){var p=r[f];n[p].numLiveTriangles&&(s=0,o-n[p].timeStamp+2*n[p].numLiveTriangles<=t&&(s=o-n[p].timeStamp),(s>l||-1===l)&&(l=s,c=p)),++f}return-1===c?function(e,t,r,n){for(;t.length>=1;){var o=t[t.length-1];if(t.splice(t.length-1,1),e[o].numLiveTriangles>0)return o}for(;i<n;){if(e[i].numLiveTriangles>0)return++i-1;++i}return-1}(n,a,0,u):c}if(!t(o))throw new r("indices is required.");var c=o.length;if(c<3||c%3!=0)throw new r("indices length must be a multiple of three.");if(a<=0)throw new r("maximumIndex must be greater than zero.");if(u<3)throw new r("cacheSize must be greater than two.");var l=0,f=0,p=o[f],h=c;if(t(a))l=a+1;else{for(;f<h;)p>l&&(l=p),p=o[++f];if(-1===l)return 0;++l}var d,y=[];for(d=0;d<l;d++)y[d]={numLiveTriangles:0,timeStamp:0,vertexTriangles:[]};f=0;for(var m=0;f<h;)y[o[f]].vertexTriangles.push(m),++y[o[f]].numLiveTriangles,y[o[f+1]].vertexTriangles.push(m),++y[o[f+1]].numLiveTriangles,y[o[f+2]].vertexTriangles.push(m),++y[o[f+2]].numLiveTriangles,++m,f+=3;var E=0,O=u+1;i=1;var v,w,_,g,T=[],b=[],R=0,A=[],x=c/3,S=[];for(d=0;d<x;d++)S[d]=!1;for(;-1!==E;){T=[],g=(w=y[E]).vertexTriangles.length;for(var N=0;N<g;++N)if(!S[m=w.vertexTriangles[N]]){S[m]=!0,f=m+m+m;for(var I=0;I<3;++I)_=o[f],T.push(_),b.push(_),A[R]=_,++R,--(v=y[_]).numLiveTriangles,O-v.timeStamp>u&&(v.timeStamp=O,++O),++f}E=s(0,u,T,y,O,b,l)}return A}};return n})),define("Core/GeometryPipeline",["./AttributeCompression","./barycentricCoordinates","./BoundingSphere","./Cartesian2","./Cartesian3","./Cartesian4","./Cartographic","./ComponentDatatype","./defaultValue","./defined","./DeveloperError","./EncodedCartesian3","./GeographicProjection","./Geometry","./GeometryAttribute","./GeometryType","./IndexDatatype","./Intersect","./IntersectionTests","./Math","./Matrix3","./Matrix4","./Plane","./PrimitiveType","./Tipsify"],(function(e,t,r,n,i,o,a,u,s,c,l,f,p,h,d,y,m,E,O,v,w,_,g,T,b){"use strict";var R={};function A(e,t,r,n,i){e[t++]=r,e[t++]=n,e[t++]=n,e[t++]=i,e[t++]=i,e[t]=r}function x(e){var t={};for(var r in e)if(e.hasOwnProperty(r)&&c(e[r])&&c(e[r].values)){var n=e[r];t[r]=new d({componentDatatype:n.componentDatatype,componentsPerAttribute:n.componentsPerAttribute,normalize:n.normalize,values:[]})}return t}function S(e,t,r){for(var n in t)if(t.hasOwnProperty(n)&&c(t[n])&&c(t[n].values))for(var i=t[n],o=0;o<i.componentsPerAttribute;++o)e[n].values.push(i.values[r*i.componentsPerAttribute+o])}R.toWireframe=function(e){if(!c(e))throw new l("geometry is required.");var t=e.indices;if(c(t)){switch(e.primitiveType){case T.TRIANGLES:e.indices=function(e){for(var t=e.length,r=t/3*6,n=m.createTypedArray(t,r),i=0,o=0;o<t;o+=3,i+=6)A(n,i,e[o],e[o+1],e[o+2]);return n}(t);break;case T.TRIANGLE_STRIP:e.indices=function(e){var t=e.length;if(t>=3){var r=6*(t-2),n=m.createTypedArray(t,r);A(n,0,e[0],e[1],e[2]);for(var i=6,o=3;o<t;++o,i+=6)A(n,i,e[o-1],e[o],e[o-2]);return n}return new Uint16Array}(t);break;case T.TRIANGLE_FAN:e.indices=function(e){if(e.length>0){for(var t=e.length-1,r=6*(t-1),n=m.createTypedArray(t,r),i=e[0],o=0,a=1;a<t;++a,o+=6)A(n,o,i,e[a],e[a+1]);return n}return new Uint16Array}(t);break;default:throw new l("geometry.primitiveType must be TRIANGLES, TRIANGLE_STRIP, or TRIANGLE_FAN.")}e.primitiveType=T.LINES}return e},R.createLineSegmentsForVectors=function(e,t,n){if(t=s(t,"normal"),!c(e))throw new l("geometry is required.");if(!c(e.attributes.position))throw new l("geometry.attributes.position is required.");if(!c(e.attributes[t]))throw new l("geometry.attributes must have an attribute with the same name as the attributeName parameter, "+t+".");n=s(n,1e4);for(var i,o=e.attributes.position.values,a=e.attributes[t].values,f=o.length,p=new Float64Array(2*f),y=0,m=0;m<f;m+=3)p[y++]=o[m],p[y++]=o[m+1],p[y++]=o[m+2],p[y++]=o[m]+a[m]*n,p[y++]=o[m+1]+a[m+1]*n,p[y++]=o[m+2]+a[m+2]*n;var E=e.boundingSphere;return c(E)&&(i=new r(E.center,E.radius+n)),new h({attributes:{position:new d({componentDatatype:u.DOUBLE,componentsPerAttribute:3,values:p})},primitiveType:T.LINES,boundingSphere:i})},R.createAttributeLocations=function(e){if(!c(e))throw new l("geometry is required.");var t,r=["position","positionHigh","positionLow","position3DHigh","position3DLow","position2DHigh","position2DLow","pickColor","normal","st","tangent","bitangent","extrudeDirection","compressedAttributes"],n=e.attributes,i={},o=0,a=r.length;for(t=0;t<a;++t){var u=r[t];c(n[u])&&(i[u]=o++)}for(var s in n)n.hasOwnProperty(s)&&!c(i[s])&&(i[s]=o++);return i},R.reorderForPreVertexCache=function(e){if(!c(e))throw new l("geometry is required.");var t=h.computeNumberOfVertices(e),r=e.indices;if(c(r)){for(var n=new Int32Array(t),i=0;i<t;i++)n[i]=-1;for(var o,a=r,s=a.length,f=m.createTypedArray(t,s),p=0,d=0,y=0;p<s;)-1!==(o=n[a[p]])?f[d]=o:(n[o=a[p]]=y,f[d]=y,++y),++p,++d;e.indices=f;var E=e.attributes;for(var O in E)if(E.hasOwnProperty(O)&&c(E[O])&&c(E[O].values)){for(var v=E[O],w=v.values,_=0,g=v.componentsPerAttribute,T=u.createTypedArray(v.componentDatatype,y*g);_<t;){var b=n[_];if(-1!==b)for(var R=0;R<g;R++)T[g*b+R]=w[g*_+R];++_}v.values=T}}return e},R.reorderForPostVertexCache=function(e,t){if(!c(e))throw new l("geometry is required.");var r=e.indices;if(e.primitiveType===T.TRIANGLES&&c(r)){for(var n=r.length,i=0,o=0;o<n;o++)r[o]>i&&(i=r[o]);e.indices=b.tipsify({indices:r,maximumIndex:i,cacheSize:t})}return e},R.fitToUnsignedShortIndices=function(e){if(!c(e))throw new l("geometry is required.");if(c(e.indices)&&e.primitiveType!==T.TRIANGLES&&e.primitiveType!==T.LINES&&e.primitiveType!==T.POINTS)throw new l("geometry.primitiveType must equal to PrimitiveType.TRIANGLES, PrimitiveType.LINES, or PrimitiveType.POINTS.");var t=[],r=h.computeNumberOfVertices(e);if(c(e.indices)&&r>=v.SIXTY_FOUR_KILOBYTES){var n,i=[],o=[],a=0,u=x(e.attributes),s=e.indices,f=s.length;e.primitiveType===T.TRIANGLES?n=3:e.primitiveType===T.LINES?n=2:e.primitiveType===T.POINTS&&(n=1);for(var p=0;p<f;p+=n){for(var d=0;d<n;++d){var y=s[p+d],m=i[y];c(m)||(m=a++,i[y]=m,S(u,e.attributes,y)),o.push(m)}a+n>=v.SIXTY_FOUR_KILOBYTES&&(t.push(new h({attributes:u,indices:o,primitiveType:e.primitiveType,boundingSphere:e.boundingSphere,boundingSphereCV:e.boundingSphereCV})),i=[],o=[],a=0,u=x(e.attributes))}0!==o.length&&t.push(new h({attributes:u,indices:o,primitiveType:e.primitiveType,boundingSphere:e.boundingSphere,boundingSphereCV:e.boundingSphereCV}))}else t.push(e);return t};var N=new i,I=new a;R.projectTo2D=function(e,t,r,n,o){if(!c(e))throw new l("geometry is required.");if(!c(t))throw new l("attributeName is required.");if(!c(r))throw new l("attributeName3D is required.");if(!c(n))throw new l("attributeName2D is required.");if(!c(e.attributes[t]))throw new l("geometry must have attribute matching the attributeName argument: "+t+".");if(e.attributes[t].componentDatatype!==u.DOUBLE)throw new l("The attribute componentDatatype must be ComponentDatatype.DOUBLE.");for(var a=e.attributes[t],s=(o=c(o)?o:new p).ellipsoid,f=a.values,h=new Float64Array(f.length),y=0,m=0;m<f.length;m+=3){var E=i.fromArray(f,m,N),O=s.cartesianToCartographic(E,I);if(!c(O))throw new l("Could not project point ("+E.x+", "+E.y+", "+E.z+") to 2D.");var v=o.project(O,N);h[y++]=v.x,h[y++]=v.y,h[y++]=v.z}return e.attributes[r]=a,e.attributes[n]=new d({componentDatatype:u.DOUBLE,componentsPerAttribute:3,values:h}),delete e.attributes[t],e};var M={high:0,low:0};R.encodeAttribute=function(e,t,r,n){if(!c(e))throw new l("geometry is required.");if(!c(t))throw new l("attributeName is required.");if(!c(r))throw new l("attributeHighName is required.");if(!c(n))throw new l("attributeLowName is required.");if(!c(e.attributes[t]))throw new l("geometry must have attribute matching the attributeName argument: "+t+".");if(e.attributes[t].componentDatatype!==u.DOUBLE)throw new l("The attribute componentDatatype must be ComponentDatatype.DOUBLE.");for(var i=e.attributes[t],o=i.values,a=o.length,s=new Float32Array(a),p=new Float32Array(a),h=0;h<a;++h)f.encode(o[h],M),s[h]=M.high,p[h]=M.low;var y=i.componentsPerAttribute;return e.attributes[r]=new d({componentDatatype:u.FLOAT,componentsPerAttribute:y,values:s}),e.attributes[n]=new d({componentDatatype:u.FLOAT,componentsPerAttribute:y,values:p}),delete e.attributes[t],e};var C=new i;function P(e,t){if(c(t))for(var r=t.values,n=r.length,o=0;o<n;o+=3)i.unpack(r,o,C),_.multiplyByPoint(e,C,C),i.pack(C,r,o)}function D(e,t){if(c(t))for(var r=t.values,n=r.length,o=0;o<n;o+=3)i.unpack(r,o,C),w.multiplyByVector(e,C,C),C=i.normalize(C,C),i.pack(C,r,o)}var U=new _,L=new w;R.transformToWorldCoordinates=function(e){if(!c(e))throw new l("instance is required.");var t=e.modelMatrix;if(_.equals(t,_.IDENTITY))return e;var n=e.geometry.attributes;P(t,n.position),P(t,n.prevPosition),P(t,n.nextPosition),(c(n.normal)||c(n.tangent)||c(n.bitangent))&&(_.inverse(t,U),_.transpose(U,U),_.getRotation(U,L),D(L,n.normal),D(L,n.tangent),D(L,n.bitangent));var i=e.geometry.boundingSphere;return c(i)&&(e.geometry.boundingSphere=r.transform(i,t,i)),e.modelMatrix=_.clone(_.IDENTITY),e};var q=new i;function F(e,t){var n,o,a,s,f=e.length,p=e[0].modelMatrix,y=c(e[0][t].indices),E=e[0][t].primitiveType;for(o=1;o<f;++o){if(!_.equals(e[o].modelMatrix,p))throw new l("All instances must have the same modelMatrix.");if(c(e[o][t].indices)!==y)throw new l("All instance geometries must have an indices or not have one.");if(e[o][t].primitiveType!==E)throw new l("All instance geometries must have the same primitiveType.")}var O,v,w,g,b=function(e,t){var r,n=e.length,i={},o=e[0][t].attributes;for(r in o)if(o.hasOwnProperty(r)&&c(o[r])&&c(o[r].values)){for(var a=o[r],s=a.values.length,l=!0,f=1;f<n;++f){var p=e[f][t].attributes[r];if(!c(p)||a.componentDatatype!==p.componentDatatype||a.componentsPerAttribute!==p.componentsPerAttribute||a.normalize!==p.normalize){l=!1;break}s+=p.values.length}l&&(i[r]=new d({componentDatatype:a.componentDatatype,componentsPerAttribute:a.componentsPerAttribute,normalize:a.normalize,values:u.createTypedArray(a.componentDatatype,s)}))}return i}(e,t);for(n in b)if(b.hasOwnProperty(n))for(O=b[n].values,s=0,o=0;o<f;++o)for(w=(v=e[o][t].attributes[n].values).length,a=0;a<w;++a)O[s++]=v[a];if(y){var R=0;for(o=0;o<f;++o)R+=e[o][t].indices.length;var A=h.computeNumberOfVertices(new h({attributes:b,primitiveType:T.POINTS})),x=m.createTypedArray(A,R),S=0,N=0;for(o=0;o<f;++o){var I=e[o][t].indices,M=I.length;for(s=0;s<M;++s)x[S++]=N+I[s];N+=h.computeNumberOfVertices(e[o][t])}g=x}var C,P=new i,D=0;for(o=0;o<f;++o){if(C=e[o][t].boundingSphere,!c(C)){P=void 0;break}i.add(C.center,P,P)}if(c(P))for(i.divideByScalar(P,f,P),o=0;o<f;++o){C=e[o][t].boundingSphere;var U=i.magnitude(i.subtract(C.center,P,q))+C.radius;U>D&&(D=U)}return new h({attributes:b,indices:g,primitiveType:E,boundingSphere:c(P)?new r(P,D):void 0})}R.combineInstances=function(e){if(!c(e)||e.length<1)throw new l("instances is required and must have length greater than zero.");for(var t=[],r=[],n=e.length,i=0;i<n;++i){var o=e[i];c(o.geometry)?t.push(o):c(o.westHemisphereGeometry)&&c(o.eastHemisphereGeometry)&&r.push(o)}var a=[];return t.length>0&&a.push(F(t,"geometry")),r.length>0&&(a.push(F(r,"westHemisphereGeometry")),a.push(F(r,"eastHemisphereGeometry"))),a};var j=new i,B=new i,z=new i,G=new i;R.computeNormal=function(e){if(!c(e))throw new l("geometry is required.");if(!c(e.attributes.position)||!c(e.attributes.position.values))throw new l("geometry.attributes.position.values is required.");if(!c(e.indices))throw new l("geometry.indices is required.");if(e.indices.length<2||e.indices.length%3!=0)throw new l("geometry.indices length must be greater than 0 and be a multiple of 3.");if(e.primitiveType!==T.TRIANGLES)throw new l("geometry.primitiveType must be PrimitiveType.TRIANGLES.");var t,r=e.indices,n=e.attributes,o=n.position.values,a=n.position.values.length/3,s=r.length,f=new Array(a),p=new Array(s/3),h=new Array(s);for(t=0;t<a;t++)f[t]={indexOffset:0,count:0,currentCount:0};var y=0;for(t=0;t<s;t+=3){var m=r[t],E=r[t+1],O=r[t+2],w=3*m,_=3*E,g=3*O;B.x=o[w],B.y=o[w+1],B.z=o[w+2],z.x=o[_],z.y=o[_+1],z.z=o[_+2],G.x=o[g],G.y=o[g+1],G.z=o[g+2],f[m].count++,f[E].count++,f[O].count++,i.subtract(z,B,z),i.subtract(G,B,G),p[y]=i.cross(z,G,new i),y++}var b,R=0;for(t=0;t<a;t++)f[t].indexOffset+=R,R+=f[t].count;for(y=0,t=0;t<s;t+=3){var A=(b=f[r[t]]).indexOffset+b.currentCount;h[A]=y,b.currentCount++,h[A=(b=f[r[t+1]]).indexOffset+b.currentCount]=y,b.currentCount++,h[A=(b=f[r[t+2]]).indexOffset+b.currentCount]=y,b.currentCount++,y++}var x=new Float32Array(3*a);for(t=0;t<a;t++){var S=3*t;if(b=f[t],i.clone(i.ZERO,j),b.count>0){for(y=0;y<b.count;y++)i.add(j,p[h[b.indexOffset+y]],j);i.equalsEpsilon(i.ZERO,j,v.EPSILON10)&&i.clone(p[h[b.indexOffset]],j)}i.equalsEpsilon(i.ZERO,j,v.EPSILON10)&&(j.z=1),i.normalize(j,j),x[S]=j.x,x[S+1]=j.y,x[S+2]=j.z}return e.attributes.normal=new d({componentDatatype:u.FLOAT,componentsPerAttribute:3,values:x}),e};var V=new i,H=new i,W=new i;R.computeTangentAndBitangent=function(e){if(!c(e))throw new l("geometry is required.");var t=e.attributes,r=e.indices;if(!c(t.position)||!c(t.position.values))throw new l("geometry.attributes.position.values is required.");if(!c(t.normal)||!c(t.normal.values))throw new l("geometry.attributes.normal.values is required.");if(!c(t.st)||!c(t.st.values))throw new l("geometry.attributes.st.values is required.");if(!c(r))throw new l("geometry.indices is required.");if(r.length<2||r.length%3!=0)throw new l("geometry.indices length must be greater than 0 and be a multiple of 3.");if(e.primitiveType!==T.TRIANGLES)throw new l("geometry.primitiveType must be PrimitiveType.TRIANGLES.");var n,o,a,s,f=e.attributes.position.values,p=e.attributes.normal.values,h=e.attributes.st.values,y=e.attributes.position.values.length/3,m=r.length,E=new Array(3*y);for(n=0;n<E.length;n++)E[n]=0;for(n=0;n<m;n+=3){var O=r[n],v=r[n+1],w=r[n+2];a=3*v,s=3*w;var _=2*O,g=2*v,b=2*w,R=f[o=3*O],A=f[o+1],x=f[o+2],S=h[_],N=h[_+1],I=h[g+1]-N,M=h[b+1]-N,C=1/((h[g]-S)*M-(h[b]-S)*I),P=(M*(f[a]-R)-I*(f[s]-R))*C,D=(M*(f[a+1]-A)-I*(f[s+1]-A))*C,U=(M*(f[a+2]-x)-I*(f[s+2]-x))*C;E[o]+=P,E[o+1]+=D,E[o+2]+=U,E[a]+=P,E[a+1]+=D,E[a+2]+=U,E[s]+=P,E[s+1]+=D,E[s+2]+=U}var L=new Float32Array(3*y),q=new Float32Array(3*y);for(n=0;n<y;n++){a=1+(o=3*n),s=o+2;var F=i.fromArray(p,o,V),j=i.fromArray(E,o,W),B=i.dot(F,j);i.multiplyByScalar(F,B,H),i.normalize(i.subtract(j,H,j),j),L[o]=j.x,L[a]=j.y,L[s]=j.z,i.normalize(i.cross(F,j,j),j),q[o]=j.x,q[a]=j.y,q[s]=j.z}return e.attributes.tangent=new d({componentDatatype:u.FLOAT,componentsPerAttribute:3,values:L}),e.attributes.bitangent=new d({componentDatatype:u.FLOAT,componentsPerAttribute:3,values:q}),e};var X=new n,k=new i,Y=new i,Z=new i,K=new n;function Q(e){switch(e.primitiveType){case T.TRIANGLE_FAN:return function(e){var t=h.computeNumberOfVertices(e);if(t<3)throw new l("The number of vertices must be at least three.");var r=m.createTypedArray(t,3*(t-2));r[0]=1,r[1]=0,r[2]=2;for(var n=3,i=3;i<t;++i)r[n++]=i-1,r[n++]=0,r[n++]=i;return e.indices=r,e.primitiveType=T.TRIANGLES,e}(e);case T.TRIANGLE_STRIP:return function(e){var t=h.computeNumberOfVertices(e);if(t<3)throw new l("The number of vertices must be at least 3.");var r=m.createTypedArray(t,3*(t-2));r[0]=0,r[1]=1,r[2]=2,t>3&&(r[3]=0,r[4]=2,r[5]=3);for(var n=6,i=3;i<t-1;i+=2)r[n++]=i,r[n++]=i-1,r[n++]=i+1,i+2<t&&(r[n++]=i,r[n++]=i+1,r[n++]=i+2);return e.indices=r,e.primitiveType=T.TRIANGLES,e}(e);case T.TRIANGLES:return function(e){if(c(e.indices))return e;var t=h.computeNumberOfVertices(e);if(t<3)throw new l("The number of vertices must be at least three.");if(t%3!=0)throw new l("The number of vertices must be a multiple of three.");for(var r=m.createTypedArray(t,t),n=0;n<t;++n)r[n]=n;return e.indices=r,e}(e);case T.LINE_STRIP:return function(e){var t=h.computeNumberOfVertices(e);if(t<2)throw new l("The number of vertices must be at least two.");var r=m.createTypedArray(t,2*(t-1));r[0]=0,r[1]=1;for(var n=2,i=2;i<t;++i)r[n++]=i-1,r[n++]=i;return e.indices=r,e.primitiveType=T.LINES,e}(e);case T.LINE_LOOP:return function(e){var t=h.computeNumberOfVertices(e);if(t<2)throw new l("The number of vertices must be at least two.");var r=m.createTypedArray(t,2*t);r[0]=0,r[1]=1;for(var n=2,i=2;i<t;++i)r[n++]=i-1,r[n++]=i;return r[n++]=t-1,r[n]=0,e.indices=r,e.primitiveType=T.LINES,e}(e);case T.LINES:return function(e){if(c(e.indices))return e;var t=h.computeNumberOfVertices(e);if(t<2)throw new l("The number of vertices must be at least two.");if(t%2!=0)throw new l("The number of vertices must be a multiple of 2.");for(var r=m.createTypedArray(t,t),n=0;n<t;++n)r[n]=n;return e.indices=r,e}(e)}return e}function J(e,t){Math.abs(e.y)<v.EPSILON6&&(e.y=t?-v.EPSILON6:v.EPSILON6)}R.compressVertices=function(t){if(!c(t))throw new l("geometry is required.");var r,o,a=t.attributes.extrudeDirection;if(c(a)){var s=a.values;o=s.length/3;var f=new Float32Array(2*o),p=0;for(r=0;r<o;++r)i.fromArray(s,3*r,k),i.equals(k,i.ZERO)?p+=2:(K=e.octEncodeInRange(k,65535,K),f[p++]=K.x,f[p++]=K.y);return t.attributes.compressedAttributes=new d({componentDatatype:u.FLOAT,componentsPerAttribute:2,values:f}),delete t.attributes.extrudeDirection,t}var h=t.attributes.normal,y=t.attributes.st,m=c(h),E=c(y);if(!m&&!E)return t;var O,v,w,_,g=t.attributes.tangent,T=t.attributes.bitangent,b=c(g),R=c(T);m&&(O=h.values),E&&(v=y.values),b&&(w=g.values),R&&(_=T.values);var A=o=(m?O.length:v.length)/(m?3:2),x=E&&m?2:1;x+=b||R?1:0;var S=new Float32Array(A*=x),N=0;for(r=0;r<o;++r){E&&(n.fromArray(v,2*r,X),S[N++]=e.compressTextureCoordinates(X));var I=3*r;m&&c(w)&&c(_)?(i.fromArray(O,I,k),i.fromArray(w,I,Y),i.fromArray(_,I,Z),e.octPack(k,Y,Z,X),S[N++]=X.x,S[N++]=X.y):(m&&(i.fromArray(O,I,k),S[N++]=e.octEncodeFloat(k)),b&&(i.fromArray(w,I,k),S[N++]=e.octEncodeFloat(k)),R&&(i.fromArray(_,I,k),S[N++]=e.octEncodeFloat(k)))}return t.attributes.compressedAttributes=new d({componentDatatype:u.FLOAT,componentsPerAttribute:x,values:S}),m&&delete t.attributes.normal,E&&delete t.attributes.st,R&&delete t.attributes.bitangent,b&&delete t.attributes.tangent,t};var $=new i;function ee(e,t,r,n){i.add(e,i.multiplyByScalar(i.subtract(t,e,$),e.y/(e.y-t.y),$),r),i.clone(r,n),J(r,!0),J(n,!1)}var te=new i,re=new i,ne=new i,ie=new i,oe={positions:new Array(7),indices:new Array(9)};function ae(e,t,r){if(!(e.x>=0||t.x>=0||r.x>=0)){!function(e,t,r){if(0!==e.y&&0!==t.y&&0!==r.y)return J(e,e.y<0),J(t,t.y<0),void J(r,r.y<0);var n=Math.abs(e.y),i=Math.abs(t.y),o=Math.abs(r.y),a=(n>i?n>o?v.sign(e.y):v.sign(r.y):i>o?v.sign(t.y):v.sign(r.y))<0;J(e,a),J(t,a),J(r,a)}(e,t,r);var n=e.y<0,i=t.y<0,o=r.y<0,a=0;a+=n?1:0,a+=i?1:0;var u=oe.indices;1===(a+=o?1:0)?(u[1]=3,u[2]=4,u[5]=6,u[7]=6,u[8]=5,n?(ee(e,t,te,ne),ee(e,r,re,ie),u[0]=0,u[3]=1,u[4]=2,u[6]=1):i?(ee(t,r,te,ne),ee(t,e,re,ie),u[0]=1,u[3]=2,u[4]=0,u[6]=2):o&&(ee(r,e,te,ne),ee(r,t,re,ie),u[0]=2,u[3]=0,u[4]=1,u[6]=0)):2===a&&(u[2]=4,u[4]=4,u[5]=3,u[7]=5,u[8]=6,n?i?o||(ee(r,e,te,ne),ee(r,t,re,ie),u[0]=0,u[1]=1,u[3]=0,u[6]=2):(ee(t,r,te,ne),ee(t,e,re,ie),u[0]=2,u[1]=0,u[3]=2,u[6]=1):(ee(e,t,te,ne),ee(e,r,re,ie),u[0]=1,u[1]=2,u[3]=1,u[6]=0));var s=oe.positions;return s[0]=e,s[1]=t,s[2]=r,s.length=3,1!==a&&2!==a||(s[3]=te,s[4]=re,s[5]=ne,s[6]=ie,s.length=7),oe}}function ue(e,t){var n=e.attributes;if(0!==n.position.values.length){for(var i in n)if(n.hasOwnProperty(i)&&c(n[i])&&c(n[i].values)){var o=n[i];o.values=u.createTypedArray(o.componentDatatype,o.values)}var a=h.computeNumberOfVertices(e);return e.indices=m.createTypedArray(a,e.indices),t&&(e.boundingSphere=r.fromVertices(n.position.values)),e}}function se(e){var t=e.attributes,r={};for(var n in t)if(t.hasOwnProperty(n)&&c(t[n])&&c(t[n].values)){var i=t[n];r[n]=new d({componentDatatype:i.componentDatatype,componentsPerAttribute:i.componentsPerAttribute,normalize:i.normalize,values:[]})}return new h({attributes:r,indices:[],primitiveType:e.primitiveType})}function ce(e,t,r){var n=c(e.geometry.boundingSphere);t=ue(t,n),r=ue(r,n),c(r)&&!c(t)?e.geometry=r:!c(r)&&c(t)?e.geometry=t:(e.westHemisphereGeometry=t,e.eastHemisphereGeometry=r,e.geometry=void 0)}function le(e,t){var r=new e,n=new e,i=new e;return function(o,a,u,s,c,l,f,p){var h=e.fromArray(c,o*t,r),d=e.fromArray(c,a*t,n),y=e.fromArray(c,u*t,i);e.multiplyByScalar(h,s.x,h),e.multiplyByScalar(d,s.y,d),e.multiplyByScalar(y,s.z,y);var m=e.add(h,d,h);e.add(m,y,m),p&&e.normalize(m,m),e.pack(m,l,f*t)}}var fe=le(o,4),pe=le(i,3),he=le(n,2),de=new i,ye=new i,me=new i,Ee=new i;function Oe(e,r,n,o,a,u,s,l,f,p,h,d,y,m,E,O){if(c(u)||c(s)||c(l)||c(f)||c(p)||0!==m){var w=i.fromArray(a,3*e,de),_=i.fromArray(a,3*r,ye),g=i.fromArray(a,3*n,me),T=t(o,w,_,g,Ee);if(c(u)&&pe(e,r,n,T,u,d.normal.values,O,!0),c(p)){var b,R=i.fromArray(p,3*e,de),A=i.fromArray(p,3*r,ye),x=i.fromArray(p,3*n,me);i.multiplyByScalar(R,T.x,R),i.multiplyByScalar(A,T.y,A),i.multiplyByScalar(x,T.z,x),i.equals(R,i.ZERO)&&i.equals(A,i.ZERO)&&i.equals(x,i.ZERO)?((b=de).x=0,b.y=0,b.z=0):(b=i.add(R,A,R),i.add(b,x,b),i.normalize(b,b)),i.pack(b,d.extrudeDirection.values,3*O)}if(c(h)&&function(e,t,r,n,i,o,a){var u=i[e]*n.x,s=i[t]*n.y,c=i[r]*n.z;o[a]=u+s+c>v.EPSILON6?1:0}(e,r,n,T,h,d.applyOffset.values,O),c(s)&&pe(e,r,n,T,s,d.tangent.values,O,!0),c(l)&&pe(e,r,n,T,l,d.bitangent.values,O,!0),c(f)&&he(e,r,n,T,f,d.st.values,O),m>0)for(var S=0;S<m;S++){var N=y[S];ve(e,r,n,T,O,E[N],d[N])}}}function ve(e,t,r,n,i,o,a){var u=o.componentsPerAttribute,s=o.values,c=a.values;switch(u){case 4:fe(e,t,r,n,s,c,i,!1);break;case 3:pe(e,t,r,n,s,c,i,!1);break;case 2:he(e,t,r,n,s,c,i,!1);break;default:c[i]=s[e]*n.x+s[t]*n.y+s[r]*n.z}}function we(e,t,r,n,i,o){var a=e.position.values.length/3;if(-1!==i){var u=n[i],s=r[u];return-1===s?(r[u]=a,e.position.values.push(o.x,o.y,o.z),t.push(a),a):(t.push(s),s)}return e.position.values.push(o.x,o.y,o.z),t.push(a),a}var _e={position:!0,normal:!0,bitangent:!0,tangent:!0,st:!0,extrudeDirection:!0,applyOffset:!0};function ge(e){var t=e.geometry,r=t.attributes,n=r.position.values,o=c(r.normal)?r.normal.values:void 0,a=c(r.bitangent)?r.bitangent.values:void 0,u=c(r.tangent)?r.tangent.values:void 0,s=c(r.st)?r.st.values:void 0,l=c(r.extrudeDirection)?r.extrudeDirection.values:void 0,f=c(r.applyOffset)?r.applyOffset.values:void 0,p=t.indices,h=[];for(var d in r)r.hasOwnProperty(d)&&!_e[d]&&c(r[d])&&h.push(d);var y,m,E,O,v=h.length,w=se(t),_=se(t),g=[];g.length=n.length/3;var T=[];for(T.length=n.length/3,O=0;O<g.length;++O)g[O]=-1,T[O]=-1;var b=p.length;for(O=0;O<b;O+=3){var R=p[O],A=p[O+1],x=p[O+2],S=i.fromArray(n,3*R),N=i.fromArray(n,3*A),I=i.fromArray(n,3*x),M=ae(S,N,I);if(c(M)&&M.positions.length>3)for(var C=M.positions,P=M.indices,D=P.length,U=0;U<D;++U){var L=P[U],q=C[L];q.y<0?(y=_.attributes,m=_.indices,E=g):(y=w.attributes,m=w.indices,E=T),Oe(R,A,x,q,n,o,u,a,s,l,f,y,h,v,r,we(y,m,E,p,L<3?O+L:-1,q))}else c(M)&&(S=M.positions[0],N=M.positions[1],I=M.positions[2]),S.y<0?(y=_.attributes,m=_.indices,E=g):(y=w.attributes,m=w.indices,E=T),Oe(R,A,x,S,n,o,u,a,s,l,f,y,h,v,r,we(y,m,E,p,O,S)),Oe(R,A,x,N,n,o,u,a,s,l,f,y,h,v,r,we(y,m,E,p,O+1,N)),Oe(R,A,x,I,n,o,u,a,s,l,f,y,h,v,r,we(y,m,E,p,O+2,I))}ce(e,_,w)}var Te=g.fromPointNormal(i.ZERO,i.UNIT_Y),be=new i,Re=new i;function Ae(e,t,r,n,o,a,u){if(c(u)){var s=i.fromArray(n,3*e,de);i.equalsEpsilon(s,r,v.EPSILON10)?a.applyOffset.values[o]=u[e]:a.applyOffset.values[o]=u[t]}}function xe(e){var t,r=e.geometry,n=r.attributes,o=n.position.values,a=c(n.applyOffset)?n.applyOffset.values:void 0,u=r.indices,s=se(r),l=se(r),f=u.length,p=[];p.length=o.length/3;var h=[];for(h.length=o.length/3,t=0;t<p.length;++t)p[t]=-1,h[t]=-1;for(t=0;t<f;t+=2){var d=u[t],y=u[t+1],m=i.fromArray(o,3*d,de),E=i.fromArray(o,3*y,ye);Math.abs(m.y)<v.EPSILON6&&(m.y<0?m.y=-v.EPSILON6:m.y=v.EPSILON6),Math.abs(E.y)<v.EPSILON6&&(E.y<0?E.y=-v.EPSILON6:E.y=v.EPSILON6);var w=s.attributes,_=s.indices,g=h,T=l.attributes,b=l.indices,R=p,A=O.lineSegmentPlane(m,E,Te,me);if(c(A)){var x=i.multiplyByScalar(i.UNIT_Y,5*v.EPSILON9,be);m.y<0&&(i.negate(x,x),w=l.attributes,_=l.indices,g=p,T=s.attributes,b=s.indices,R=h);var S=i.add(A,x,Re);Ae(d,y,m,o,we(w,_,g,u,t,m),w,a),Ae(d,y,S,o,we(w,_,g,u,-1,S),w,a),i.negate(x,x),i.add(A,x,S),Ae(d,y,S,o,we(T,b,R,u,-1,S),T,a),Ae(d,y,E,o,we(T,b,R,u,t+1,E),T,a)}else{var N,I,M;m.y<0?(N=l.attributes,I=l.indices,M=p):(N=s.attributes,I=s.indices,M=h),Ae(d,y,m,o,we(N,I,M,u,t,m),N,a),Ae(d,y,E,o,we(N,I,M,u,t+1,E),N,a)}}ce(e,l,s)}var Se=new n,Ne=new n,Ie=new i,Me=new i,Ce=new i,Pe=new i,De=new i,Ue=new i,Le=new o;function qe(e){for(var t=e.attributes,r=t.position.values,n=t.prevPosition.values,o=t.nextPosition.values,a=r.length,u=0;u<a;u+=3){var s=i.unpack(r,u,Ie);if(!(s.x>0)){var c=i.unpack(n,u,Me);(s.y<0&&c.y>0||s.y>0&&c.y<0)&&(u-3>0?(n[u]=r[u-3],n[u+1]=r[u-2],n[u+2]=r[u-1]):i.pack(s,n,u));var l=i.unpack(o,u,Ce);(s.y<0&&l.y>0||s.y>0&&l.y<0)&&(u+3<a?(o[u]=r[u+3],o[u+1]=r[u+4],o[u+2]=r[u+5]):i.pack(s,o,u))}}}var Fe=5*v.EPSILON9,je=v.EPSILON6;return R.splitLongitude=function(e){if(!c(e))throw new l("instance is required.");var t=e.geometry,a=t.boundingSphere;if(c(a)&&(a.center.x-a.radius>0||r.intersectPlane(a,g.ORIGIN_ZX_PLANE)!==E.INTERSECTING))return e;if(t.geometryType!==y.NONE)switch(t.geometryType){case y.POLYLINES:!function(e){var t,r,a,u=e.geometry,s=u.attributes,l=s.position.values,f=s.prevPosition.values,p=s.nextPosition.values,h=s.expandAndWidth.values,d=c(s.st)?s.st.values:void 0,y=c(s.color)?s.color.values:void 0,m=se(u),E=se(u),w=!1,_=l.length/3;for(t=0;t<_;t+=4){var g=t,T=t+2,b=i.fromArray(l,3*g,Ie),R=i.fromArray(l,3*T,Me);if(Math.abs(b.y)<je)for(b.y=je*(R.y<0?-1:1),l[3*t+1]=b.y,l[3*(t+1)+1]=b.y,r=3*g;r<3*g+12;r+=3)f[r]=l[3*t],f[r+1]=l[3*t+1],f[r+2]=l[3*t+2];if(Math.abs(R.y)<je)for(R.y=je*(b.y<0?-1:1),l[3*(t+2)+1]=R.y,l[3*(t+3)+1]=R.y,r=3*g;r<3*g+12;r+=3)p[r]=l[3*(t+2)],p[r+1]=l[3*(t+2)+1],p[r+2]=l[3*(t+2)+2];var A=m.attributes,x=m.indices,S=E.attributes,N=E.indices,I=O.lineSegmentPlane(b,R,Te,Pe);if(c(I)){w=!0;var M=i.multiplyByScalar(i.UNIT_Y,Fe,De);b.y<0&&(i.negate(M,M),A=E.attributes,x=E.indices,S=m.attributes,N=m.indices);var C=i.add(I,M,Ue);A.position.values.push(b.x,b.y,b.z,b.x,b.y,b.z),A.position.values.push(C.x,C.y,C.z),A.position.values.push(C.x,C.y,C.z),A.prevPosition.values.push(f[3*g],f[3*g+1],f[3*g+2]),A.prevPosition.values.push(f[3*g+3],f[3*g+4],f[3*g+5]),A.prevPosition.values.push(b.x,b.y,b.z,b.x,b.y,b.z),A.nextPosition.values.push(C.x,C.y,C.z),A.nextPosition.values.push(C.x,C.y,C.z),A.nextPosition.values.push(C.x,C.y,C.z),A.nextPosition.values.push(C.x,C.y,C.z),i.negate(M,M),i.add(I,M,C),S.position.values.push(C.x,C.y,C.z),S.position.values.push(C.x,C.y,C.z),S.position.values.push(R.x,R.y,R.z,R.x,R.y,R.z),S.prevPosition.values.push(C.x,C.y,C.z),S.prevPosition.values.push(C.x,C.y,C.z),S.prevPosition.values.push(C.x,C.y,C.z),S.prevPosition.values.push(C.x,C.y,C.z),S.nextPosition.values.push(R.x,R.y,R.z,R.x,R.y,R.z),S.nextPosition.values.push(p[3*T],p[3*T+1],p[3*T+2]),S.nextPosition.values.push(p[3*T+3],p[3*T+4],p[3*T+5]);var P=n.fromArray(h,2*g,Se),D=Math.abs(P.y);A.expandAndWidth.values.push(-1,D,1,D),A.expandAndWidth.values.push(-1,-D,1,-D),S.expandAndWidth.values.push(-1,D,1,D),S.expandAndWidth.values.push(-1,-D,1,-D);var U=i.magnitudeSquared(i.subtract(I,b,Ce));if(U/=i.magnitudeSquared(i.subtract(R,b,Ce)),c(y)){var L=o.fromArray(y,4*g,Le),q=o.fromArray(y,4*T,Le),F=v.lerp(L.x,q.x,U),j=v.lerp(L.y,q.y,U),B=v.lerp(L.z,q.z,U),z=v.lerp(L.w,q.w,U);for(r=4*g;r<4*g+8;++r)A.color.values.push(y[r]);for(A.color.values.push(F,j,B,z),A.color.values.push(F,j,B,z),S.color.values.push(F,j,B,z),S.color.values.push(F,j,B,z),r=4*T;r<4*T+8;++r)S.color.values.push(y[r])}if(c(d)){var G=n.fromArray(d,2*g,Se),V=n.fromArray(d,2*(t+3),Ne),H=v.lerp(G.x,V.x,U);for(r=2*g;r<2*g+4;++r)A.st.values.push(d[r]);for(A.st.values.push(H,G.y),A.st.values.push(H,V.y),S.st.values.push(H,G.y),S.st.values.push(H,V.y),r=2*T;r<2*T+4;++r)S.st.values.push(d[r])}a=A.position.values.length/3-4,x.push(a,a+2,a+1),x.push(a+1,a+2,a+3),a=S.position.values.length/3-4,N.push(a,a+2,a+1),N.push(a+1,a+2,a+3)}else{var W,X;for(b.y<0?(W=E.attributes,X=E.indices):(W=m.attributes,X=m.indices),W.position.values.push(b.x,b.y,b.z),W.position.values.push(b.x,b.y,b.z),W.position.values.push(R.x,R.y,R.z),W.position.values.push(R.x,R.y,R.z),r=3*t;r<3*t+12;++r)W.prevPosition.values.push(f[r]),W.nextPosition.values.push(p[r]);for(r=2*t;r<2*t+8;++r)W.expandAndWidth.values.push(h[r]),c(d)&&W.st.values.push(d[r]);if(c(y))for(r=4*t;r<4*t+16;++r)W.color.values.push(y[r]);a=W.position.values.length/3-4,X.push(a,a+2,a+1),X.push(a+1,a+2,a+3)}}w&&(qe(E),qe(m)),ce(e,E,m)}(e);break;case y.TRIANGLES:ge(e);break;case y.LINES:xe(e)}else Q(t),t.primitiveType===T.TRIANGLES?ge(e):t.primitiveType===T.LINES&&xe(e);return e},R})),define("Core/arrayRemoveDuplicates",["./Check","./defaultValue","./defined","./Math"],(function(e,t,r,n){"use strict";var i=n.EPSILON10;return function(n,o,a){if(e.defined("equalsEpsilon",o),r(n)){a=t(a,!1);var u,s,c,l=n.length;if(l<2)return n;for(u=1;u<l&&!o(s=n[u-1],c=n[u],i);++u);if(u===l)return a&&o(n[0],n[n.length-1],i)?n.slice(1):n;for(var f=n.slice(0,u);u<l;++u)o(s,c=n[u],i)||(f.push(c),s=c);return a&&f.length>1&&o(f[0],f[f.length-1],i)&&f.shift(),f}}})),define("Core/GeometryAttributes",["./defaultValue"],(function(e){"use strict";return function(t){t=e(t,e.EMPTY_OBJECT),this.position=t.position,this.normal=t.normal,this.st=t.st,this.bitangent=t.bitangent,this.tangent=t.tangent,this.color=t.color}})),define("ThirdParty/earcut-2.1.1",[],(function(){"use strict";function e(e,i,o){o=o||2;var a,u,l,p,h,d,y,m=i&&i.length,E=m?i[0]*o:e.length,O=t(e,0,E,o,!0),v=[];if(!O)return v;if(m&&(O=function(e,n,i,o){var a,u,l,p,h,d=[];for(a=0,u=n.length;a<u;a++)l=n[a]*o,p=a<u-1?n[a+1]*o:e.length,(h=t(e,l,p,o,!1))===h.next&&(h.steiner=!0),d.push(f(h));for(d.sort(s),a=0;a<d.length;a++)c(d[a],i),i=r(i,i.next);return i}(e,i,O,o)),e.length>80*o){a=l=e[0],u=p=e[1];for(var w=o;w<E;w+=o)(h=e[w])<a&&(a=h),(d=e[w+1])<u&&(u=d),h>l&&(l=h),d>p&&(p=d);y=Math.max(l-a,p-u)}return n(O,v,o,a,u,y),v}function t(e,t,r,n,i){var o,a;if(i===g(e,t,r,n)>0)for(o=t;o<r;o+=n)a=v(o,e[o],e[o+1],a);else for(o=r-n;o>=t;o-=n)a=v(o,e[o],e[o+1],a);return a&&y(a,a.next)&&(w(a),a=a.next),a}function r(e,t){if(!e)return e;t||(t=e);var r,n=e;do{if(r=!1,n.steiner||!y(n,n.next)&&0!==d(n.prev,n,n.next))n=n.next;else{if(w(n),(n=t=n.prev)===n.next)return null;r=!0}}while(r||n!==t);return t}function n(e,t,s,c,f,p,h){if(e){!h&&p&&function(e,t,r,n){var i=e;do{null===i.z&&(i.z=l(i.x,i.y,t,r,n)),i.prevZ=i.prev,i.nextZ=i.next,i=i.next}while(i!==e);i.prevZ.nextZ=null,i.prevZ=null,function(e){var t,r,n,i,o,a,u,s,c=1;do{for(r=e,e=null,o=null,a=0;r;){for(a++,n=r,u=0,t=0;t<c&&(u++,n=n.nextZ);t++);for(s=c;u>0||s>0&&n;)0===u?(i=n,n=n.nextZ,s--):0!==s&&n?r.z<=n.z?(i=r,r=r.nextZ,u--):(i=n,n=n.nextZ,s--):(i=r,r=r.nextZ,u--),o?o.nextZ=i:e=i,i.prevZ=o,o=i;r=n}o.nextZ=null,c*=2}while(a>1)}(i)}(e,c,f,p);for(var d,y,m=e;e.prev!==e.next;)if(d=e.prev,y=e.next,p?o(e,c,f,p):i(e))t.push(d.i/s),t.push(e.i/s),t.push(y.i/s),w(e),e=y.next,m=y.next;else if((e=y)===m){h?1===h?n(e=a(e,t,s),t,s,c,f,p,2):2===h&&u(e,t,s,c,f,p):n(r(e),t,s,c,f,p,1);break}}}function i(e){var t=e.prev,r=e,n=e.next;if(d(t,r,n)>=0)return!1;for(var i=e.next.next;i!==e.prev;){if(p(t.x,t.y,r.x,r.y,n.x,n.y,i.x,i.y)&&d(i.prev,i,i.next)>=0)return!1;i=i.next}return!0}function o(e,t,r,n){var i=e.prev,o=e,a=e.next;if(d(i,o,a)>=0)return!1;for(var u=i.x<o.x?i.x<a.x?i.x:a.x:o.x<a.x?o.x:a.x,s=i.y<o.y?i.y<a.y?i.y:a.y:o.y<a.y?o.y:a.y,c=i.x>o.x?i.x>a.x?i.x:a.x:o.x>a.x?o.x:a.x,f=i.y>o.y?i.y>a.y?i.y:a.y:o.y>a.y?o.y:a.y,h=l(u,s,t,r,n),y=l(c,f,t,r,n),m=e.nextZ;m&&m.z<=y;){if(m!==e.prev&&m!==e.next&&p(i.x,i.y,o.x,o.y,a.x,a.y,m.x,m.y)&&d(m.prev,m,m.next)>=0)return!1;m=m.nextZ}for(m=e.prevZ;m&&m.z>=h;){if(m!==e.prev&&m!==e.next&&p(i.x,i.y,o.x,o.y,a.x,a.y,m.x,m.y)&&d(m.prev,m,m.next)>=0)return!1;m=m.prevZ}return!0}function a(e,t,r){var n=e;do{var i=n.prev,o=n.next.next;!y(i,o)&&m(i,n,n.next,o)&&E(i,o)&&E(o,i)&&(t.push(i.i/r),t.push(n.i/r),t.push(o.i/r),w(n),w(n.next),n=e=o),n=n.next}while(n!==e);return n}function u(e,t,i,o,a,u){var s=e;do{for(var c=s.next.next;c!==s.prev;){if(s.i!==c.i&&h(s,c)){var l=O(s,c);return s=r(s,s.next),l=r(l,l.next),n(s,t,i,o,a,u),void n(l,t,i,o,a,u)}c=c.next}s=s.next}while(s!==e)}function s(e,t){return e.x-t.x}function c(e,t){if(t=function(e,t){var r,n=t,i=e.x,o=e.y,a=-1/0;do{if(o<=n.y&&o>=n.next.y){var u=n.x+(o-n.y)*(n.next.x-n.x)/(n.next.y-n.y);if(u<=i&&u>a){if(a=u,u===i){if(o===n.y)return n;if(o===n.next.y)return n.next}r=n.x<n.next.x?n:n.next}}n=n.next}while(n!==t);if(!r)return null;if(i===a)return r.prev;var s,c=r,l=r.x,f=r.y,h=1/0;for(n=r.next;n!==c;)i>=n.x&&n.x>=l&&p(o<f?i:a,o,l,f,o<f?a:i,o,n.x,n.y)&&((s=Math.abs(o-n.y)/(i-n.x))<h||s===h&&n.x>r.x)&&E(n,e)&&(r=n,h=s),n=n.next;return r}(e,t)){var n=O(t,e);r(n,n.next)}}function l(e,t,r,n,i){return(e=1431655765&((e=858993459&((e=252645135&((e=16711935&((e=32767*(e-r)/i)|e<<8))|e<<4))|e<<2))|e<<1))|(t=1431655765&((t=858993459&((t=252645135&((t=16711935&((t=32767*(t-n)/i)|t<<8))|t<<4))|t<<2))|t<<1))<<1}function f(e){var t=e,r=e;do{t.x<r.x&&(r=t),t=t.next}while(t!==e);return r}function p(e,t,r,n,i,o,a,u){return(i-a)*(t-u)-(e-a)*(o-u)>=0&&(e-a)*(n-u)-(r-a)*(t-u)>=0&&(r-a)*(o-u)-(i-a)*(n-u)>=0}function h(e,t){return e.next.i!==t.i&&e.prev.i!==t.i&&!function(e,t){var r=e;do{if(r.i!==e.i&&r.next.i!==e.i&&r.i!==t.i&&r.next.i!==t.i&&m(r,r.next,e,t))return!0;r=r.next}while(r!==e);return!1}(e,t)&&E(e,t)&&E(t,e)&&function(e,t){var r=e,n=!1,i=(e.x+t.x)/2,o=(e.y+t.y)/2;do{r.y>o!=r.next.y>o&&i<(r.next.x-r.x)*(o-r.y)/(r.next.y-r.y)+r.x&&(n=!n),r=r.next}while(r!==e);return n}(e,t)}function d(e,t,r){return(t.y-e.y)*(r.x-t.x)-(t.x-e.x)*(r.y-t.y)}function y(e,t){return e.x===t.x&&e.y===t.y}function m(e,t,r,n){return!!(y(e,t)&&y(r,n)||y(e,n)&&y(r,t))||d(e,t,r)>0!=d(e,t,n)>0&&d(r,n,e)>0!=d(r,n,t)>0}function E(e,t){return d(e.prev,e,e.next)<0?d(e,t,e.next)>=0&&d(e,e.prev,t)>=0:d(e,t,e.prev)<0||d(e,e.next,t)<0}function O(e,t){var r=new _(e.i,e.x,e.y),n=new _(t.i,t.x,t.y),i=e.next,o=t.prev;return e.next=t,t.prev=e,r.next=i,i.prev=r,n.next=r,r.prev=n,o.next=n,n.prev=o,n}function v(e,t,r,n){var i=new _(e,t,r);return n?(i.next=n.next,i.prev=n,n.next.prev=i,n.next=i):(i.prev=i,i.next=i),i}function w(e){e.next.prev=e.prev,e.prev.next=e.next,e.prevZ&&(e.prevZ.nextZ=e.nextZ),e.nextZ&&(e.nextZ.prevZ=e.prevZ)}function _(e,t,r){this.i=e,this.x=t,this.y=r,this.prev=null,this.next=null,this.z=null,this.prevZ=null,this.nextZ=null,this.steiner=!1}function g(e,t,r,n){for(var i=0,o=t,a=r-n;o<r;o+=n)i+=(e[a]-e[o])*(e[o+1]+e[a+1]),a=o;return i}return e.deviation=function(e,t,r,n){var i=t&&t.length,o=i?t[0]*r:e.length,a=Math.abs(g(e,0,o,r));if(i)for(var u=0,s=t.length;u<s;u++){var c=t[u]*r,l=u<s-1?t[u+1]*r:e.length;a-=Math.abs(g(e,c,l,r))}var f=0;for(u=0;u<n.length;u+=3){var p=n[u]*r,h=n[u+1]*r,d=n[u+2]*r;f+=Math.abs((e[p]-e[d])*(e[h+1]-e[p+1])-(e[p]-e[h])*(e[d+1]-e[p+1]))}return 0===a&&0===f?0:Math.abs((f-a)/a)},e.flatten=function(e){for(var t=e[0][0].length,r={vertices:[],holes:[],dimensions:t},n=0,i=0;i<e.length;i++){for(var o=0;o<e[i].length;o++)for(var a=0;a<t;a++)r.vertices.push(e[i][o][a]);i>0&&(n+=e[i-1].length,r.holes.push(n))}return r},e})),define("Core/WindingOrder",["./freezeObject","./WebGLConstants"],(function(e,t){"use strict";var r={CLOCKWISE:t.CW,COUNTER_CLOCKWISE:t.CCW,validate:function(e){return e===r.CLOCKWISE||e===r.COUNTER_CLOCKWISE}};return e(r)})),define("Core/PolygonPipeline",["../ThirdParty/earcut-2.1.1","./Cartesian2","./Cartesian3","./Check","./ComponentDatatype","./defaultValue","./defined","./Ellipsoid","./Geometry","./GeometryAttribute","./Math","./PrimitiveType","./WindingOrder"],(function(e,t,r,n,i,o,a,u,s,c,l,f,p){"use strict";var h=new r,d=new r,y={computeArea2D:function(e){n.defined("positions",e),n.typeOf.number.greaterThanOrEquals("positions.length",e.length,3);for(var t=e.length,r=0,i=t-1,o=0;o<t;i=o++){var a=e[i],u=e[o];r+=a.x*u.y-u.x*a.y}return.5*r},computeWindingOrder2D:function(e){return y.computeArea2D(e)>0?p.COUNTER_CLOCKWISE:p.CLOCKWISE},triangulate:function(r,i){n.defined("positions",r);var o=t.packArray(r);return e(o,i,2)}},m=new r,E=new r,O=new r,v=new r,w=new r,_=new r,g=new r;return y.computeSubdivision=function(e,t,u,p){p=o(p,l.RADIANS_PER_DEGREE),n.typeOf.object("ellipsoid",e),n.defined("positions",t),n.defined("indices",u),n.typeOf.number.greaterThanOrEquals("indices.length",u.length,3),n.typeOf.number.equals("indices.length % 3","0",u.length%3,0),n.typeOf.number.greaterThan("granularity",p,0);var h,d=u.slice(0),y=t.length,T=new Array(3*y),b=0;for(h=0;h<y;h++){var R=t[h];T[b++]=R.x,T[b++]=R.y,T[b++]=R.z}for(var A=[],x={},S=e.maximumRadius,N=l.chordLength(p,S),I=N*N;d.length>0;){var M,C,P=d.pop(),D=d.pop(),U=d.pop(),L=r.fromArray(T,3*U,m),q=r.fromArray(T,3*D,E),F=r.fromArray(T,3*P,O),j=r.multiplyByScalar(r.normalize(L,v),S,v),B=r.multiplyByScalar(r.normalize(q,w),S,w),z=r.multiplyByScalar(r.normalize(F,_),S,_),G=r.magnitudeSquared(r.subtract(j,B,g)),V=r.magnitudeSquared(r.subtract(B,z,g)),H=r.magnitudeSquared(r.subtract(z,j,g)),W=Math.max(G,V,H);W>I?G===W?(h=x[M=Math.min(U,D)+" "+Math.max(U,D)],a(h)||(C=r.add(L,q,g),r.multiplyByScalar(C,.5,C),T.push(C.x,C.y,C.z),h=T.length/3-1,x[M]=h),d.push(U,h,P),d.push(h,D,P)):V===W?(h=x[M=Math.min(D,P)+" "+Math.max(D,P)],a(h)||(C=r.add(q,F,g),r.multiplyByScalar(C,.5,C),T.push(C.x,C.y,C.z),h=T.length/3-1,x[M]=h),d.push(D,h,U),d.push(h,P,U)):H===W&&(h=x[M=Math.min(P,U)+" "+Math.max(P,U)],a(h)||(C=r.add(F,L,g),r.multiplyByScalar(C,.5,C),T.push(C.x,C.y,C.z),h=T.length/3-1,x[M]=h),d.push(P,h,D),d.push(h,U,D)):(A.push(U),A.push(D),A.push(P))}return new s({attributes:{position:new c({componentDatatype:i.DOUBLE,componentsPerAttribute:3,values:T})},indices:A,primitiveType:f.TRIANGLES})},y.scaleToGeodeticHeight=function(e,t,n,i){n=o(n,u.WGS84);var s=h,c=d;if(t=o(t,0),i=o(i,!0),a(e))for(var l=e.length,f=0;f<l;f+=3)r.fromArray(e,f,c),i&&(c=n.scaleToGeodeticSurface(c,c)),0!==t&&(s=n.geodeticSurfaceNormal(c,s),r.multiplyByScalar(s,t,s),r.add(c,s,c)),e[f]=c.x,e[f+1]=c.y,e[f+2]=c.z;return e},y})),define("Core/Queue",["./defineProperties"],(function(e){"use strict";function t(){this._array=[],this._offset=0,this._length=0}return e(t.prototype,{length:{get:function(){return this._length}}}),t.prototype.enqueue=function(e){this._array.push(e),this._length++},t.prototype.dequeue=function(){if(0!==this._length){var e=this._array,t=this._offset,r=e[t];return e[t]=void 0,++t>10&&2*t>e.length&&(this._array=e.slice(t),t=0),this._offset=t,this._length--,r}},t.prototype.peek=function(){if(0!==this._length)return this._array[this._offset]},t.prototype.contains=function(e){return-1!==this._array.indexOf(e)},t.prototype.clear=function(){this._array.length=this._offset=this._length=0},t.prototype.sort=function(e){this._offset>0&&(this._array=this._array.slice(this._offset),this._offset=0),this._array.sort(e)},t})),define("Core/PolygonGeometryLibrary",["./arrayRemoveDuplicates","./Cartesian2","./Cartesian3","./ComponentDatatype","./defaultValue","./defined","./Ellipsoid","./Geometry","./GeometryAttribute","./GeometryAttributes","./GeometryPipeline","./IndexDatatype","./Math","./Matrix3","./PolygonPipeline","./PrimitiveType","./Quaternion","./Queue","./WindingOrder"],(function(e,t,r,n,i,o,a,u,s,c,l,f,p,h,d,y,m,E,O){"use strict";var v={computeHierarchyPackedLength:function(e){for(var t=0,n=[e];n.length>0;){var i=n.pop();if(o(i)){t+=2;var a=i.positions,u=i.holes;if(o(a)&&(t+=a.length*r.packedLength),o(u))for(var s=u.length,c=0;c<s;++c)n.push(u[c])}}return t},packPolygonHierarchy:function(e,t,n){for(var i=[e];i.length>0;){var a=i.pop();if(o(a)){var u=a.positions,s=a.holes;if(t[n++]=o(u)?u.length:0,t[n++]=o(s)?s.length:0,o(u))for(var c=u.length,l=0;l<c;++l,n+=3)r.pack(u[l],t,n);if(o(s))for(var f=s.length,p=0;p<f;++p)i.push(s[p])}}return n},unpackPolygonHierarchy:function(e,t){for(var n=e[t++],i=e[t++],o=new Array(n),a=i>0?new Array(i):void 0,u=0;u<n;++u,t+=r.packedLength)o[u]=r.unpack(e,t);for(var s=0;s<i;++s)a[s]=v.unpackPolygonHierarchy(e,t),t=a[s].startingIndex,delete a[s].startingIndex;return{positions:o,holes:a,startingIndex:t}}},w=new r;function _(e,t,n,i){return r.subtract(t,e,w),r.multiplyByScalar(w,n/i,w),r.add(e,w,w),[w.x,w.y,w.z]}v.subdivideLineCount=function(e,t,n){var i=r.distance(e,t)/n,o=Math.max(0,Math.ceil(Math.log(i)/Math.log(2)));return Math.pow(2,o)},v.subdivideLine=function(e,t,n,i){var a=v.subdivideLineCount(e,t,n),u=r.distance(e,t),s=u/a;o(i)||(i=[]);var c=i;c.length=3*a;for(var l=0,f=0;f<a;f++){var p=_(e,t,f*s,u);c[l++]=p[0],c[l++]=p[1],c[l++]=p[2]}return c};var g=new r,T=new r,b=new r,R=new r;v.scaleToGeodeticHeightExtruded=function(e,t,n,u,s){u=i(u,a.WGS84);var c=g,l=T,f=b,p=R;if(o(e)&&o(e.attributes)&&o(e.attributes.position))for(var h=e.attributes.position.values,d=h.length/2,y=0;y<d;y+=3)r.fromArray(h,y,f),u.geodeticSurfaceNormal(f,c),p=u.scaleToGeodeticSurface(f,p),l=r.multiplyByScalar(c,n,l),l=r.add(p,l,l),h[y+d]=l.x,h[y+1+d]=l.y,h[y+2+d]=l.z,s&&(p=r.clone(f,p)),l=r.multiplyByScalar(c,t,l),l=r.add(p,l,l),h[y]=l.x,h[y+1]=l.y,h[y+2]=l.z;return e},v.polygonOutlinesFromHierarchy=function(t,n,i){var a,u,s,c=[],l=new E;for(l.enqueue(t);0!==l.length;){var f=l.dequeue(),p=f.positions;if(n)for(s=p.length,a=0;a<s;a++)i.scaleToGeodeticSurface(p[a],p[a]);if(!((p=e(p,r.equalsEpsilon,!0)).length<3)){var h=f.holes?f.holes.length:0;for(a=0;a<h;a++){var d=f.holes[a],y=d.positions;if(n)for(s=y.length,u=0;u<s;++u)i.scaleToGeodeticSurface(y[u],y[u]);if(!((y=e(y,r.equalsEpsilon,!0)).length<3)){c.push(y);var m=0;for(o(d.holes)&&(m=d.holes.length),u=0;u<m;u++)l.enqueue(d.holes[u])}}c.push(p)}}return c},v.polygonsFromHierarchy=function(t,n,i,a){var u=[],s=[],c=new E;for(c.enqueue(t);0!==c.length;){var l,f,p=c.dequeue(),h=p.positions,y=p.holes;if(i)for(f=h.length,l=0;l<f;l++)a.scaleToGeodeticSurface(h[l],h[l]);if(!((h=e(h,r.equalsEpsilon,!0)).length<3)){var m=n(h);if(o(m)){var v=[],w=d.computeWindingOrder2D(m);w===O.CLOCKWISE&&(m.reverse(),h=h.slice().reverse());var _,g=h.slice(),T=o(y)?y.length:0,b=[];for(l=0;l<T;l++){var R=y[l],A=R.positions;if(i)for(f=A.length,_=0;_<f;++_)a.scaleToGeodeticSurface(A[_],A[_]);if(!((A=e(A,r.equalsEpsilon,!0)).length<3)){var x=n(A);if(o(x)){(w=d.computeWindingOrder2D(x))===O.CLOCKWISE&&(x.reverse(),A=A.slice().reverse()),b.push(A),v.push(g.length),g=g.concat(A),m=m.concat(x);var S=0;for(o(R.holes)&&(S=R.holes.length),_=0;_<S;_++)c.enqueue(R.holes[_])}}}u.push({outerRing:h,holes:b}),s.push({positions:g,positions2D:m,holes:v})}}}return{hierarchy:u,polygons:s}};var A=new t,x=new r,S=new m,N=new h;v.computeBoundingRectangle=function(e,t,n,i,a){for(var u=m.fromAxisAngle(e,i,S),s=h.fromQuaternion(u,N),c=Number.POSITIVE_INFINITY,l=Number.NEGATIVE_INFINITY,f=Number.POSITIVE_INFINITY,p=Number.NEGATIVE_INFINITY,d=n.length,y=0;y<d;++y){var E=r.clone(n[y],x);h.multiplyByVector(s,E,E);var O=t(E,A);o(O)&&(c=Math.min(c,O.x),l=Math.max(l,O.x),f=Math.min(f,O.y),p=Math.max(p,O.y))}return a.x=c,a.y=f,a.width=l-c,a.height=p-f,a},v.createGeometryFromPositions=function(e,t,r,i,o){var a=d.triangulate(t.positions2D,t.holes);a.length<3&&(a=[0,1,2]);var c=t.positions;if(i){for(var f=c.length,p=new Array(3*f),h=0,m=0;m<f;m++){var E=c[m];p[h++]=E.x,p[h++]=E.y,p[h++]=E.z}var O=new u({attributes:{position:new s({componentDatatype:n.DOUBLE,componentsPerAttribute:3,values:p})},indices:a,primitiveType:y.TRIANGLES});return o.normal?l.computeNormal(O):O}return d.computeSubdivision(e,c,a,r)};var I=[],M=new r,C=new r;return v.computeWallGeometry=function(e,t,i,o){var a,l,h,d,m,E=e.length,O=0;if(o)for(l=3*E*2,a=new Array(2*l),h=0;h<E;h++)d=e[h],m=e[(h+1)%E],a[O]=a[O+l]=d.x,a[++O]=a[O+l]=d.y,a[++O]=a[O+l]=d.z,a[++O]=a[O+l]=m.x,a[++O]=a[O+l]=m.y,a[++O]=a[O+l]=m.z,++O;else{var w=p.chordLength(i,t.maximumRadius),_=0;for(h=0;h<E;h++)_+=v.subdivideLineCount(e[h],e[(h+1)%E],w);for(l=3*(_+E),a=new Array(2*l),h=0;h<E;h++){d=e[h],m=e[(h+1)%E];for(var g=v.subdivideLine(d,m,w,I),T=g.length,b=0;b<T;++b,++O)a[O]=g[b],a[O+l]=g[b];a[O]=m.x,a[O+l]=m.x,a[++O]=m.y,a[O+l]=m.y,a[++O]=m.z,a[O+l]=m.z,++O}}E=a.length;var R=f.createTypedArray(E/3,E-6*e.length),A=0;for(E/=6,h=0;h<E;h++){var x=h,S=x+1,N=x+E,P=N+1;d=r.fromArray(a,3*x,M),m=r.fromArray(a,3*S,C),r.equalsEpsilon(d,m,p.EPSILON14)||(R[A++]=x,R[A++]=N,R[A++]=S,R[A++]=S,R[A++]=N,R[A++]=P)}return new u({attributes:new c({position:new s({componentDatatype:n.DOUBLE,componentsPerAttribute:3,values:a})}),indices:R,primitiveType:y.TRIANGLES})},v})),define("Core/VertexFormat",["./defaultValue","./defined","./DeveloperError","./freezeObject"],(function(e,t,r,n){"use strict";function i(t){t=e(t,e.EMPTY_OBJECT),this.position=e(t.position,!1),this.normal=e(t.normal,!1),this.st=e(t.st,!1),this.bitangent=e(t.bitangent,!1),this.tangent=e(t.tangent,!1),this.color=e(t.color,!1)}return i.POSITION_ONLY=n(new i({position:!0})),i.POSITION_AND_NORMAL=n(new i({position:!0,normal:!0})),i.POSITION_NORMAL_AND_ST=n(new i({position:!0,normal:!0,st:!0})),i.POSITION_AND_ST=n(new i({position:!0,st:!0})),i.POSITION_AND_COLOR=n(new i({position:!0,color:!0})),i.ALL=n(new i({position:!0,normal:!0,st:!0,tangent:!0,bitangent:!0})),i.DEFAULT=i.POSITION_NORMAL_AND_ST,i.packedLength=6,i.pack=function(n,i,o){if(!t(n))throw new r("value is required");if(!t(i))throw new r("array is required");return o=e(o,0),i[o++]=n.position?1:0,i[o++]=n.normal?1:0,i[o++]=n.st?1:0,i[o++]=n.tangent?1:0,i[o++]=n.bitangent?1:0,i[o]=n.color?1:0,i},i.unpack=function(n,o,a){if(!t(n))throw new r("array is required");return o=e(o,0),t(a)||(a=new i),a.position=1===n[o++],a.normal=1===n[o++],a.st=1===n[o++],a.tangent=1===n[o++],a.bitangent=1===n[o++],a.color=1===n[o],a},i.clone=function(e,r){if(t(e))return t(r)||(r=new i),r.position=e.position,r.normal=e.normal,r.st=e.st,r.tangent=e.tangent,r.bitangent=e.bitangent,r.color=e.color,r},i})),define("Core/PolygonGeometry",["./arrayFill","./BoundingRectangle","./BoundingSphere","./Cartesian2","./Cartesian3","./Cartographic","./Check","./ComponentDatatype","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid","./EllipsoidTangentPlane","./Geometry","./GeometryAttribute","./GeometryInstance","./GeometryOffsetAttribute","./GeometryPipeline","./IndexDatatype","./Math","./Matrix2","./Matrix3","./PolygonGeometryLibrary","./PolygonPipeline","./Quaternion","./Rectangle","./VertexFormat","./WindingOrder"],(function(e,t,r,n,i,o,a,u,s,c,l,f,p,h,d,y,m,E,O,v,w,_,g,T,b,R,A,x,S){"use strict";var N=new o,I=new o;function M(e,t,r,n){var i=n.cartesianToCartographic(e,N).height,o=n.cartesianToCartographic(t,I);o.height=i,n.cartographicToCartesian(o,t);var a=n.cartesianToCartographic(r,I);a.height=i-100,n.cartographicToCartesian(a,r)}var C=new t,P=new i,D=new i,U=new i,L=new i,q=new i,F=new i,j=new i,B=new i,z=new i,G=new n,V=new n,H=new i,W=new R,X=new g,k=new g;function Y(t){var r=t.vertexFormat,o=t.geometry,a=t.shadowVolume,s=o.attributes.position.values,l=s.length,f=t.wall,p=t.top||f,h=t.bottom||f;if(r.st||r.normal||r.tangent||r.bitangent||a){var d=t.boundingRectangle,m=t.tangentPlane,O=t.ellipsoid,v=t.stRotation,_=t.perPositionHeight,T=G;T.x=d.x,T.y=d.y;var b,A=r.st?new Float32Array(l/3*2):void 0;r.normal&&(b=_&&p&&!f?o.attributes.normal.values:new Float32Array(l));var x=r.tangent?new Float32Array(l):void 0,S=r.bitangent?new Float32Array(l):void 0,N=a?new Float32Array(l):void 0,I=0,C=0,Y=D,Z=U,K=L,Q=!0,J=X,$=k;if(0!==v){var ee=R.fromAxisAngle(m._plane.normal,v,W);J=g.fromQuaternion(ee,J),ee=R.fromAxisAngle(m._plane.normal,-v,W),$=g.fromQuaternion(ee,$)}else J=g.clone(g.IDENTITY,J),$=g.clone(g.IDENTITY,$);var te=0,re=0;p&&h&&(te=l/2,re=l/3,l/=2);for(var ne=0;ne<l;ne+=3){var ie=i.fromArray(s,ne,H);if(r.st){var oe=g.multiplyByVector(J,ie,P);oe=O.scaleToGeodeticSurface(oe,oe);var ae=m.projectPointOntoPlane(oe,V);n.subtract(ae,T,ae);var ue=w.clamp(ae.x/d.width,0,1),se=w.clamp(ae.y/d.height,0,1);h&&(A[I+re]=ue,A[I+1+re]=se),p&&(A[I]=ue,A[I+1]=se),I+=2}if(r.normal||r.tangent||r.bitangent||a){var ce=C+1,le=C+2;if(f){if(ne+3<l){var fe=i.fromArray(s,ne+3,q);if(Q){var pe=i.fromArray(s,ne+l,F);_&&M(ie,fe,pe,O),i.subtract(fe,ie,fe),i.subtract(pe,ie,pe),Y=i.normalize(i.cross(pe,fe,Y),Y),Q=!1}i.equalsEpsilon(fe,ie,w.EPSILON10)&&(Q=!0)}(r.tangent||r.bitangent)&&(K=O.geodeticSurfaceNormal(ie,K),r.tangent&&(Z=i.normalize(i.cross(K,Y,Z),Z)))}else Y=O.geodeticSurfaceNormal(ie,Y),(r.tangent||r.bitangent)&&(_&&(j=i.fromArray(b,C,j),B=i.cross(i.UNIT_Z,j,B),B=i.normalize(g.multiplyByVector($,B,B),B),r.bitangent&&(z=i.normalize(i.cross(j,B,z),z))),Z=i.cross(i.UNIT_Z,Y,Z),Z=i.normalize(g.multiplyByVector($,Z,Z),Z),r.bitangent&&(K=i.normalize(i.cross(Y,Z,K),K)));r.normal&&(t.wall?(b[C+te]=Y.x,b[ce+te]=Y.y,b[le+te]=Y.z):h&&(b[C+te]=-Y.x,b[ce+te]=-Y.y,b[le+te]=-Y.z),(p&&!_||f)&&(b[C]=Y.x,b[ce]=Y.y,b[le]=Y.z)),a&&(f&&(Y=O.geodeticSurfaceNormal(ie,Y)),N[C+te]=-Y.x,N[ce+te]=-Y.y,N[le+te]=-Y.z),r.tangent&&(t.wall?(x[C+te]=Z.x,x[ce+te]=Z.y,x[le+te]=Z.z):h&&(x[C+te]=-Z.x,x[ce+te]=-Z.y,x[le+te]=-Z.z),p&&(_?(x[C]=B.x,x[ce]=B.y,x[le]=B.z):(x[C]=Z.x,x[ce]=Z.y,x[le]=Z.z))),r.bitangent&&(h&&(S[C+te]=K.x,S[ce+te]=K.y,S[le+te]=K.z),p&&(_?(S[C]=z.x,S[ce]=z.y,S[le]=z.z):(S[C]=K.x,S[ce]=K.y,S[le]=K.z))),C+=3}}r.st&&(o.attributes.st=new y({componentDatatype:u.FLOAT,componentsPerAttribute:2,values:A})),r.normal&&(o.attributes.normal=new y({componentDatatype:u.FLOAT,componentsPerAttribute:3,values:b})),r.tangent&&(o.attributes.tangent=new y({componentDatatype:u.FLOAT,componentsPerAttribute:3,values:x})),r.bitangent&&(o.attributes.bitangent=new y({componentDatatype:u.FLOAT,componentsPerAttribute:3,values:S})),a&&(o.attributes.extrudeDirection=new y({componentDatatype:u.FLOAT,componentsPerAttribute:3,values:N}))}if(t.extrude&&c(t.offsetAttribute)){var he=s.length/3,de=new Uint8Array(he);if(t.offsetAttribute===E.TOP)p&&h||f?de=e(de,1,0,he/2):p&&(de=e(de,1));else{var ye=t.offsetAttribute===E.NONE?0:1;de=e(de,ye)}o.attributes.applyOffset=new y({componentDatatype:u.UNSIGNED_BYTE,componentsPerAttribute:1,values:de})}return o}function Z(e,t,r){return!c(e)||e.length<3?c(r)?(r.west=0,r.north=0,r.south=0,r.east=0,r):new A:A.fromCartesianArray(e,t,r)}var K=[];function Q(e,t,r,n,i,o,a,u){var s,c={walls:[]};if(o||a){var l,f,p=T.createGeometryFromPositions(e,t,r,i,u),d=p.attributes.position.values,y=p.indices;if(o&&a){var E=d.concat(d);l=E.length/3,(f=v.createTypedArray(l,2*y.length)).set(y);var O=y.length,w=l/2;for(s=0;s<O;s+=3){var _=f[s]+w,g=f[s+1]+w,R=f[s+2]+w;f[s+O]=R,f[s+1+O]=g,f[s+2+O]=_}if(p.attributes.position.values=E,i&&u.normal){var A=p.attributes.normal.values;p.attributes.normal.values=new Float32Array(E.length),p.attributes.normal.values.set(A)}p.indices=f}else if(a){for(l=d.length/3,f=v.createTypedArray(l,y.length),s=0;s<y.length;s+=3)f[s]=y[s+2],f[s+1]=y[s+1],f[s+2]=y[s];p.indices=f}c.topAndBottom=new m({geometry:p})}var x=n.outerRing,N=h.fromPoints(x,e),I=N.projectPointsOntoPlane(x,K),M=b.computeWindingOrder2D(I);M===S.CLOCKWISE&&(x=x.slice().reverse());var C=T.computeWallGeometry(x,e,r,i);c.walls.push(new m({geometry:C}));var P=n.holes;for(s=0;s<P.length;s++){var D=P[s];I=(N=h.fromPoints(D,e)).projectPointsOntoPlane(D,K),(M=b.computeWindingOrder2D(I))===S.COUNTER_CLOCKWISE&&(D=D.slice().reverse()),C=T.computeWallGeometry(D,e,r),c.walls.push(new m({geometry:C}))}return c}function J(e){if(a.typeOf.object("options",e),a.typeOf.object("options.polygonHierarchy",e.polygonHierarchy),c(e.perPositionHeight)&&e.perPositionHeight&&c(e.height))throw new f("Cannot use both options.perPositionHeight and options.height");var t=e.polygonHierarchy,r=s(e.vertexFormat,x.DEFAULT),n=s(e.ellipsoid,p.WGS84),i=s(e.granularity,w.RADIANS_PER_DEGREE),o=s(e.stRotation,0),u=s(e.perPositionHeight,!1),l=u&&c(e.extrudedHeight),h=s(e.height,0),d=s(e.extrudedHeight,h);if(!l){var y=Math.max(h,d);d=Math.min(h,d),h=y}this._vertexFormat=x.clone(r),this._ellipsoid=p.clone(n),this._granularity=i,this._stRotation=o,this._height=h,this._extrudedHeight=d,this._closeTop=s(e.closeTop,!0),this._closeBottom=s(e.closeBottom,!0),this._polygonHierarchy=t,this._perPositionHeight=u,this._perPositionHeightExtrude=l,this._shadowVolume=s(e.shadowVolume,!1),this._workerName="createPolygonGeometry",this._offsetAttribute=e.offsetAttribute,this._rectangle=void 0,this._textureCoordinateRotationPoints=void 0,this.packedLength=T.computeHierarchyPackedLength(t)+p.packedLength+x.packedLength+11}J.fromPositions=function(e){return e=s(e,s.EMPTY_OBJECT),a.defined("options.positions",e.positions),new J({polygonHierarchy:{positions:e.positions},height:e.height,extrudedHeight:e.extrudedHeight,vertexFormat:e.vertexFormat,stRotation:e.stRotation,ellipsoid:e.ellipsoid,granularity:e.granularity,perPositionHeight:e.perPositionHeight,closeTop:e.closeTop,closeBottom:e.closeBottom,offsetAttribute:e.offsetAttribute})},J.pack=function(e,t,r){return a.typeOf.object("value",e),a.defined("array",t),r=s(r,0),r=T.packPolygonHierarchy(e._polygonHierarchy,t,r),p.pack(e._ellipsoid,t,r),r+=p.packedLength,x.pack(e._vertexFormat,t,r),r+=x.packedLength,t[r++]=e._height,t[r++]=e._extrudedHeight,t[r++]=e._granularity,t[r++]=e._stRotation,t[r++]=e._perPositionHeightExtrude?1:0,t[r++]=e._perPositionHeight?1:0,t[r++]=e._closeTop?1:0,t[r++]=e._closeBottom?1:0,t[r++]=e._shadowVolume?1:0,t[r++]=s(e._offsetAttribute,-1),t[r]=e.packedLength,t};var $=p.clone(p.UNIT_SPHERE),ee=new x,te={polygonHierarchy:{}};return J.unpack=function(e,t,r){a.defined("array",e),t=s(t,0);var n=T.unpackPolygonHierarchy(e,t);t=n.startingIndex,delete n.startingIndex;var i=p.unpack(e,t,$);t+=p.packedLength;var o=x.unpack(e,t,ee);t+=x.packedLength;var u=e[t++],l=e[t++],f=e[t++],h=e[t++],d=1===e[t++],y=1===e[t++],m=1===e[t++],E=1===e[t++],O=1===e[t++],v=e[t++],w=e[t];return c(r)||(r=new J(te)),r._polygonHierarchy=n,r._ellipsoid=p.clone(i,r._ellipsoid),r._vertexFormat=x.clone(o,r._vertexFormat),r._height=u,r._extrudedHeight=l,r._granularity=f,r._stRotation=h,r._perPositionHeightExtrude=d,r._perPositionHeight=y,r._closeTop=m,r._closeBottom=E,r._shadowVolume=O,r._offsetAttribute=-1===v?void 0:v,r.packedLength=w,r},J.computeRectangle=function(e,t){a.typeOf.object("options",e),a.typeOf.object("options.polygonHierarchy",e.polygonHierarchy);var r=e.polygonHierarchy,n=s(e.ellipsoid,p.WGS84);return Z(r.positions,n,t)},J.createGeometry=function(t){var n=t._vertexFormat,i=t._ellipsoid,o=t._granularity,a=t._stRotation,s=t._polygonHierarchy,l=t._perPositionHeight,f=t._closeTop,p=t._closeBottom,_=s.positions;if(!(_.length<3)){var g=h.fromPoints(_,i),R=T.polygonsFromHierarchy(s,g.projectPointsOntoPlane.bind(g),!l,i),A=R.hierarchy,x=R.polygons;if(0!==A.length){_=A[0].outerRing;var S,N=T.computeBoundingRectangle(g.plane.normal,g.projectPointOntoPlane.bind(g),_,a,C),I=[],M=t._height,P=t._extrudedHeight,D={perPositionHeight:l,vertexFormat:n,geometry:void 0,tangentPlane:g,boundingRectangle:N,ellipsoid:i,stRotation:a,bottom:!1,top:!0,wall:!1,extrude:!1};if(t._perPositionHeightExtrude||!w.equalsEpsilon(M,P,0,w.EPSILON2))for(D.extrude=!0,D.top=f,D.bottom=p,D.shadowVolume=t._shadowVolume,D.offsetAttribute=t._offsetAttribute,S=0;S<x.length;S++){var U,L=Q(i,x[S],o,A[S],l,f,p,n);f&&p?(U=L.topAndBottom,D.geometry=T.scaleToGeodeticHeightExtruded(U.geometry,M,P,i,l)):f?((U=L.topAndBottom).geometry.attributes.position.values=b.scaleToGeodeticHeight(U.geometry.attributes.position.values,M,i,!l),D.geometry=U.geometry):p&&((U=L.topAndBottom).geometry.attributes.position.values=b.scaleToGeodeticHeight(U.geometry.attributes.position.values,P,i,!0),D.geometry=U.geometry),(f||p)&&(D.wall=!1,U.geometry=Y(D),I.push(U));var q=L.walls;D.wall=!0;for(var F=0;F<q.length;F++){var j=q[F];D.geometry=T.scaleToGeodeticHeightExtruded(j.geometry,M,P,i,l),j.geometry=Y(D),I.push(j)}}else for(S=0;S<x.length;S++){var B=new m({geometry:T.createGeometryFromPositions(i,x[S],o,l,n)});if(B.geometry.attributes.position.values=b.scaleToGeodeticHeight(B.geometry.attributes.position.values,M,i,!l),D.geometry=B.geometry,B.geometry=Y(D),c(t._offsetAttribute)){var z=B.geometry.attributes.position.values.length,G=new Uint8Array(z/3),V=t._offsetAttribute===E.NONE?0:1;e(G,V),B.geometry.attributes.applyOffset=new y({componentDatatype:u.UNSIGNED_BYTE,componentsPerAttribute:1,values:G})}I.push(B)}var H=O.combineInstances(I)[0];H.attributes.position.values=new Float64Array(H.attributes.position.values),H.indices=v.createTypedArray(H.attributes.position.values.length/3,H.indices);var W=H.attributes,X=r.fromVertices(W.position.values);return n.position||delete W.position,new d({attributes:W,indices:H.indices,primitiveType:H.primitiveType,boundingSphere:X,offsetAttribute:t._offsetAttribute})}}},J.createShadowVolume=function(e,t,r){var n=e._granularity,i=e._ellipsoid,o=t(n,i),a=r(n,i);return new J({polygonHierarchy:e._polygonHierarchy,ellipsoid:i,stRotation:e._stRotation,granularity:n,perPositionHeight:!1,extrudedHeight:o,height:a,vertexFormat:x.POSITION_ONLY,shadowVolume:!0})},l(J.prototype,{rectangle:{get:function(){if(!c(this._rectangle)){var e=this._polygonHierarchy.positions;this._rectangle=Z(e,this._ellipsoid)}return this._rectangle}},textureCoordinateRotationPoints:{get:function(){return c(this._textureCoordinateRotationPoints)||(this._textureCoordinateRotationPoints=function(e){var t=-e._stRotation;if(0===t)return[0,0,0,1,1,0];var r=e._ellipsoid,n=e._polygonHierarchy.positions,i=e.rectangle;return d._textureCoordinateRotationPoints(n,t,r,i)}(this)),this._textureCoordinateRotationPoints}}}),J})),define("Workers/createPolygonGeometry",["../Core/defined","../Core/Ellipsoid","../Core/PolygonGeometry"],(function(e,t,r){"use strict";return function(n,i){return e(i)&&(n=r.unpack(n,i)),n._ellipsoid=t.clone(n._ellipsoid),r.createGeometry(n)}}));