define("Core/defined",[],(function(){"use strict";return function(e){return null!=e}})),define("Core/DeveloperError",["./defined"],(function(e){"use strict";function t(e){var t;this.name="DeveloperError",this.message=e;try{throw new Error}catch(e){t=e.stack}this.stack=t}return e(Object.create)&&(t.prototype=Object.create(Error.prototype),t.prototype.constructor=t),t.prototype.toString=function(){var t=this.name+": "+this.message;return e(this.stack)&&(t+="\n"+this.stack.toString()),t},t.throwInstantiationError=function(){throw new t("This function defines an interface and should not be called directly.")},t})),define("Core/Check",["./defined","./DeveloperError"],(function(e,t){"use strict";var r={};function n(e,t,r){return"Expected "+r+" to be typeof "+t+", actual typeof was "+e}return r.typeOf={},r.defined=function(r,n){if(!e(n))throw new t(function(e){return e+" is required, actual value was undefined"}(r))},r.typeOf.func=function(e,r){if("function"!=typeof r)throw new t(n(typeof r,"function",e))},r.typeOf.string=function(e,r){if("string"!=typeof r)throw new t(n(typeof r,"string",e))},r.typeOf.number=function(e,r){if("number"!=typeof r)throw new t(n(typeof r,"number",e))},r.typeOf.number.lessThan=function(e,n,o){if(r.typeOf.number(e,n),n>=o)throw new t("Expected "+e+" to be less than "+o+", actual value was "+n)},r.typeOf.number.lessThanOrEquals=function(e,n,o){if(r.typeOf.number(e,n),n>o)throw new t("Expected "+e+" to be less than or equal to "+o+", actual value was "+n)},r.typeOf.number.greaterThan=function(e,n,o){if(r.typeOf.number(e,n),n<=o)throw new t("Expected "+e+" to be greater than "+o+", actual value was "+n)},r.typeOf.number.greaterThanOrEquals=function(e,n,o){if(r.typeOf.number(e,n),n<o)throw new t("Expected "+e+" to be greater than or equal to"+o+", actual value was "+n)},r.typeOf.object=function(e,r){if("object"!=typeof r)throw new t(n(typeof r,"object",e))},r.typeOf.bool=function(e,r){if("boolean"!=typeof r)throw new t(n(typeof r,"boolean",e))},r.typeOf.number.equals=function(e,n,o,i){if(r.typeOf.number(e,o),r.typeOf.number(n,i),o!==i)throw new t(e+" must be equal to "+n+", the actual values are "+o+" and "+i)},r})),define("Core/freezeObject",["./defined"],(function(e){"use strict";var t=Object.freeze;return e(t)||(t=function(e){return e}),t})),define("Core/defaultValue",["./freezeObject"],(function(e){"use strict";function t(e,t){return null!=e?e:t}return t.EMPTY_OBJECT=e({}),t})),
/**
@license
mersenne-twister.js - https://gist.github.com/banksean/300494

   Copyright (C) 1997 - 2002, Makoto Matsumoto and Takuji Nishimura,
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:

     1. Redistributions of source code must retain the above copyright
        notice, this list of conditions and the following disclaimer.

     2. Redistributions in binary form must reproduce the above copyright
        notice, this list of conditions and the following disclaimer in the
        documentation and/or other materials provided with the distribution.

     3. The names of its contributors may not be used to endorse or promote
        products derived from this software without specific prior written
        permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
   A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
   EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
   PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
define("ThirdParty/mersenne-twister",[],(function(){var e=function(e){null==e&&(e=(new Date).getTime()),this.N=624,this.M=397,this.MATRIX_A=2567483615,this.UPPER_MASK=2147483648,this.LOWER_MASK=2147483647,this.mt=new Array(this.N),this.mti=this.N+1,this.init_genrand(e)};return e.prototype.init_genrand=function(e){for(this.mt[0]=e>>>0,this.mti=1;this.mti<this.N;this.mti++)e=this.mt[this.mti-1]^this.mt[this.mti-1]>>>30,this.mt[this.mti]=(1812433253*((4294901760&e)>>>16)<<16)+1812433253*(65535&e)+this.mti,this.mt[this.mti]>>>=0},e.prototype.genrand_int32=function(){var e,t=new Array(0,this.MATRIX_A);if(this.mti>=this.N){var r;for(this.mti==this.N+1&&this.init_genrand(5489),r=0;r<this.N-this.M;r++)e=this.mt[r]&this.UPPER_MASK|this.mt[r+1]&this.LOWER_MASK,this.mt[r]=this.mt[r+this.M]^e>>>1^t[1&e];for(;r<this.N-1;r++)e=this.mt[r]&this.UPPER_MASK|this.mt[r+1]&this.LOWER_MASK,this.mt[r]=this.mt[r+(this.M-this.N)]^e>>>1^t[1&e];e=this.mt[this.N-1]&this.UPPER_MASK|this.mt[0]&this.LOWER_MASK,this.mt[this.N-1]=this.mt[this.M-1]^e>>>1^t[1&e],this.mti=0}return e=this.mt[this.mti++],e^=e>>>11,e^=e<<7&2636928640,e^=e<<15&4022730752,(e^=e>>>18)>>>0},e.prototype.random=function(){return this.genrand_int32()*(1/4294967296)},e})),define("Core/Math",["../ThirdParty/mersenne-twister","./Check","./defaultValue","./defined","./DeveloperError"],(function(e,t,r,n,o){"use strict";var i={EPSILON1:.1,EPSILON2:.01,EPSILON3:.001,EPSILON4:1e-4,EPSILON5:1e-5,EPSILON6:1e-6,EPSILON7:1e-7,EPSILON8:1e-8,EPSILON9:1e-9,EPSILON10:1e-10,EPSILON11:1e-11,EPSILON12:1e-12,EPSILON13:1e-13,EPSILON14:1e-14,EPSILON15:1e-15,EPSILON16:1e-16,EPSILON17:1e-17,EPSILON18:1e-18,EPSILON19:1e-19,EPSILON20:1e-20,EPSILON21:1e-21,GRAVITATIONALPARAMETER:3986004418e5,SOLAR_RADIUS:6955e5,LUNAR_RADIUS:1737400,SIXTY_FOUR_KILOBYTES:65536};i.sign=r(Math.sign,(function(e){return 0==(e=+e)||e!=e?e:e>0?1:-1})),i.signNotZero=function(e){return e<0?-1:1},i.toSNorm=function(e,t){return t=r(t,255),Math.round((.5*i.clamp(e,-1,1)+.5)*t)},i.fromSNorm=function(e,t){return t=r(t,255),i.clamp(e,0,t)/t*2-1},i.sinh=r(Math.sinh,(function(e){return(Math.exp(e)-Math.exp(-e))/2})),i.cosh=r(Math.cosh,(function(e){return(Math.exp(e)+Math.exp(-e))/2})),i.lerp=function(e,t,r){return(1-r)*e+r*t},i.PI=Math.PI,i.ONE_OVER_PI=1/Math.PI,i.PI_OVER_TWO=Math.PI/2,i.PI_OVER_THREE=Math.PI/3,i.PI_OVER_FOUR=Math.PI/4,i.PI_OVER_SIX=Math.PI/6,i.THREE_PI_OVER_TWO=3*Math.PI/2,i.TWO_PI=2*Math.PI,i.ONE_OVER_TWO_PI=1/(2*Math.PI),i.RADIANS_PER_DEGREE=Math.PI/180,i.DEGREES_PER_RADIAN=180/Math.PI,i.RADIANS_PER_ARCSECOND=i.RADIANS_PER_DEGREE/3600,i.toRadians=function(e){if(!n(e))throw new o("degrees is required.");return e*i.RADIANS_PER_DEGREE},i.toDegrees=function(e){if(!n(e))throw new o("radians is required.");return e*i.DEGREES_PER_RADIAN},i.convertLongitudeRange=function(e){if(!n(e))throw new o("angle is required.");var t=i.TWO_PI,r=e-Math.floor(e/t)*t;return r<-Math.PI?r+t:r>=Math.PI?r-t:r},i.clampToLatitudeRange=function(e){if(!n(e))throw new o("angle is required.");return i.clamp(e,-1*i.PI_OVER_TWO,i.PI_OVER_TWO)},i.negativePiToPi=function(e){if(!n(e))throw new o("angle is required.");return i.zeroToTwoPi(e+i.PI)-i.PI},i.zeroToTwoPi=function(e){if(!n(e))throw new o("angle is required.");var t=i.mod(e,i.TWO_PI);return Math.abs(t)<i.EPSILON14&&Math.abs(e)>i.EPSILON14?i.TWO_PI:t},i.mod=function(e,t){if(!n(e))throw new o("m is required.");if(!n(t))throw new o("n is required.");return(e%t+t)%t},i.equalsEpsilon=function(e,t,i,a){if(!n(e))throw new o("left is required.");if(!n(t))throw new o("right is required.");if(!n(i))throw new o("relativeEpsilon is required.");a=r(a,i);var s=Math.abs(e-t);return s<=a||s<=i*Math.max(Math.abs(e),Math.abs(t))};var a=[1];i.factorial=function(e){if("number"!=typeof e||e<0)throw new o("A number greater than or equal to 0 is required.");var t=a.length;if(e>=t)for(var r=a[t-1],n=t;n<=e;n++)a.push(r*n);return a[e]},i.incrementWrap=function(e,t,i){if(i=r(i,0),!n(e))throw new o("n is required.");if(t<=i)throw new o("maximumValue must be greater than minimumValue.");return++e>t&&(e=i),e},i.isPowerOfTwo=function(e){if("number"!=typeof e||e<0)throw new o("A number greater than or equal to 0 is required.");return 0!==e&&0==(e&e-1)},i.nextPowerOfTwo=function(e){if("number"!=typeof e||e<0)throw new o("A number greater than or equal to 0 is required.");return--e,e|=e>>1,e|=e>>2,e|=e>>4,e|=e>>8,e|=e>>16,++e},i.clamp=function(e,t,r){if(!n(e))throw new o("value is required");if(!n(t))throw new o("min is required.");if(!n(r))throw new o("max is required.");return e<t?t:e>r?r:e};var s=new e;return i.setRandomNumberSeed=function(t){if(!n(t))throw new o("seed is required.");s=new e(t)},i.nextRandomNumber=function(){return s.random()},i.randomBetween=function(e,t){return i.nextRandomNumber()*(t-e)+e},i.acosClamped=function(e){if(!n(e))throw new o("value is required.");return Math.acos(i.clamp(e,-1,1))},i.asinClamped=function(e){if(!n(e))throw new o("value is required.");return Math.asin(i.clamp(e,-1,1))},i.chordLength=function(e,t){if(!n(e))throw new o("angle is required.");if(!n(t))throw new o("radius is required.");return 2*t*Math.sin(.5*e)},i.logBase=function(e,t){if(!n(e))throw new o("number is required.");if(!n(t))throw new o("base is required.");return Math.log(e)/Math.log(t)},i.cbrt=r(Math.cbrt,(function(e){var t=Math.pow(Math.abs(e),1/3);return e<0?-t:t})),i.log2=r(Math.log2,(function(e){return Math.log(e)*Math.LOG2E})),i.fog=function(e,t){var r=e*t;return 1-Math.exp(-r*r)},i.fastApproximateAtan=function(e){return t.typeOf.number("x",e),e*(-.1784*Math.abs(e)-.0663*e*e+1.0301)},i.fastApproximateAtan2=function(e,r){var n,a;t.typeOf.number("x",e),t.typeOf.number("y",r);var s=Math.abs(e);n=Math.abs(r),a=Math.max(s,n);var u=(n=Math.min(s,n))/a;if(isNaN(u))throw new o("either x or y must be nonzero");return s=i.fastApproximateAtan(u),s=Math.abs(r)>Math.abs(e)?i.PI_OVER_TWO-s:s,s=e<0?i.PI-s:s,s=r<0?-s:s},i})),define("Core/Cartesian3",["./Check","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],(function(e,t,r,n,o,i){"use strict";function a(e,r,n){this.x=t(e,0),this.y=t(r,0),this.z=t(n,0)}a.fromSpherical=function(n,o){e.typeOf.object("spherical",n),r(o)||(o=new a);var i=n.clock,s=n.cone,u=t(n.magnitude,1),c=u*Math.sin(s);return o.x=c*Math.cos(i),o.y=c*Math.sin(i),o.z=u*Math.cos(s),o},a.fromElements=function(e,t,n,o){return r(o)?(o.x=e,o.y=t,o.z=n,o):new a(e,t,n)},a.clone=function(e,t){if(r(e))return r(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t):new a(e.x,e.y,e.z)},a.fromCartesian4=a.clone,a.packedLength=3,a.pack=function(r,n,o){return e.typeOf.object("value",r),e.defined("array",n),o=t(o,0),n[o++]=r.x,n[o++]=r.y,n[o]=r.z,n},a.unpack=function(n,o,i){return e.defined("array",n),o=t(o,0),r(i)||(i=new a),i.x=n[o++],i.y=n[o++],i.z=n[o],i},a.packArray=function(t,n){e.defined("array",t);var o=t.length;r(n)?n.length=3*o:n=new Array(3*o);for(var i=0;i<o;++i)a.pack(t[i],n,3*i);return n},a.unpackArray=function(t,o){if(e.defined("array",t),e.typeOf.number.greaterThanOrEquals("array.length",t.length,3),t.length%3!=0)throw new n("array length must be a multiple of 3.");var i=t.length;r(o)?o.length=i/3:o=new Array(i/3);for(var s=0;s<i;s+=3){var u=s/3;o[u]=a.unpack(t,s,o[u])}return o},a.fromArray=a.unpack,a.maximumComponent=function(t){return e.typeOf.object("cartesian",t),Math.max(t.x,t.y,t.z)},a.minimumComponent=function(t){return e.typeOf.object("cartesian",t),Math.min(t.x,t.y,t.z)},a.minimumByComponent=function(t,r,n){return e.typeOf.object("first",t),e.typeOf.object("second",r),e.typeOf.object("result",n),n.x=Math.min(t.x,r.x),n.y=Math.min(t.y,r.y),n.z=Math.min(t.z,r.z),n},a.maximumByComponent=function(t,r,n){return e.typeOf.object("first",t),e.typeOf.object("second",r),e.typeOf.object("result",n),n.x=Math.max(t.x,r.x),n.y=Math.max(t.y,r.y),n.z=Math.max(t.z,r.z),n},a.magnitudeSquared=function(t){return e.typeOf.object("cartesian",t),t.x*t.x+t.y*t.y+t.z*t.z},a.magnitude=function(e){return Math.sqrt(a.magnitudeSquared(e))};var s=new a;a.distance=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),a.subtract(t,r,s),a.magnitude(s)},a.distanceSquared=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),a.subtract(t,r,s),a.magnitudeSquared(s)},a.normalize=function(t,r){e.typeOf.object("cartesian",t),e.typeOf.object("result",r);var o=a.magnitude(t);if(r.x=t.x/o,r.y=t.y/o,r.z=t.z/o,isNaN(r.x)||isNaN(r.y)||isNaN(r.z))throw new n("normalized result is not a number");return r},a.dot=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),t.x*r.x+t.y*r.y+t.z*r.z},a.multiplyComponents=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x*r.x,n.y=t.y*r.y,n.z=t.z*r.z,n},a.divideComponents=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x/r.x,n.y=t.y/r.y,n.z=t.z/r.z,n},a.add=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x+r.x,n.y=t.y+r.y,n.z=t.z+r.z,n},a.subtract=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x-r.x,n.y=t.y-r.y,n.z=t.z-r.z,n},a.multiplyByScalar=function(t,r,n){return e.typeOf.object("cartesian",t),e.typeOf.number("scalar",r),e.typeOf.object("result",n),n.x=t.x*r,n.y=t.y*r,n.z=t.z*r,n},a.divideByScalar=function(t,r,n){return e.typeOf.object("cartesian",t),e.typeOf.number("scalar",r),e.typeOf.object("result",n),n.x=t.x/r,n.y=t.y/r,n.z=t.z/r,n},a.negate=function(t,r){return e.typeOf.object("cartesian",t),e.typeOf.object("result",r),r.x=-t.x,r.y=-t.y,r.z=-t.z,r},a.abs=function(t,r){return e.typeOf.object("cartesian",t),e.typeOf.object("result",r),r.x=Math.abs(t.x),r.y=Math.abs(t.y),r.z=Math.abs(t.z),r};var u=new a;a.lerp=function(t,r,n,o){return e.typeOf.object("start",t),e.typeOf.object("end",r),e.typeOf.number("t",n),e.typeOf.object("result",o),a.multiplyByScalar(r,n,u),o=a.multiplyByScalar(t,1-n,o),a.add(u,o,o)};var c=new a,f=new a;a.angleBetween=function(t,r){e.typeOf.object("left",t),e.typeOf.object("right",r),a.normalize(t,c),a.normalize(r,f);var n=a.dot(c,f),o=a.magnitude(a.cross(c,f,c));return Math.atan2(o,n)};var l=new a;a.mostOrthogonalAxis=function(t,r){e.typeOf.object("cartesian",t),e.typeOf.object("result",r);var n=a.normalize(t,l);return a.abs(n,n),r=n.x<=n.y?n.x<=n.z?a.clone(a.UNIT_X,r):a.clone(a.UNIT_Z,r):n.y<=n.z?a.clone(a.UNIT_Y,r):a.clone(a.UNIT_Z,r)},a.projectVector=function(t,r,n){e.defined("a",t),e.defined("b",r),e.defined("result",n);var o=a.dot(t,r)/a.dot(r,r);return a.multiplyByScalar(r,o,n)},a.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z},a.equalsArray=function(e,t,r){return e.x===t[r]&&e.y===t[r+1]&&e.z===t[r+2]},a.equalsEpsilon=function(e,t,n,o){return e===t||r(e)&&r(t)&&i.equalsEpsilon(e.x,t.x,n,o)&&i.equalsEpsilon(e.y,t.y,n,o)&&i.equalsEpsilon(e.z,t.z,n,o)},a.cross=function(t,r,n){e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n);var o=t.x,i=t.y,a=t.z,s=r.x,u=r.y,c=r.z,f=i*c-a*u,l=a*s-o*c,h=o*u-i*s;return n.x=f,n.y=l,n.z=h,n},a.midpoint=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=.5*(t.x+r.x),n.y=.5*(t.y+r.y),n.z=.5*(t.z+r.z),n},a.fromDegrees=function(t,r,n,o,s){return e.typeOf.number("longitude",t),e.typeOf.number("latitude",r),t=i.toRadians(t),r=i.toRadians(r),a.fromRadians(t,r,n,o,s)};var h=new a,p=new a,d=new a(40680631590769,40680631590769,40408299984661.445);return a.fromRadians=function(n,o,i,s,u){e.typeOf.number("longitude",n),e.typeOf.number("latitude",o),i=t(i,0);var c=r(s)?s.radiiSquared:d,f=Math.cos(o);h.x=f*Math.cos(n),h.y=f*Math.sin(n),h.z=Math.sin(o),h=a.normalize(h,h),a.multiplyComponents(c,h,p);var l=Math.sqrt(a.dot(h,p));return p=a.divideByScalar(p,l,p),h=a.multiplyByScalar(h,i,h),r(u)||(u=new a),a.add(p,h,u)},a.fromDegreesArray=function(t,o,i){if(e.defined("coordinates",t),t.length<2||t.length%2!=0)throw new n("the number of coordinates must be a multiple of 2 and at least 2");var s=t.length;r(i)?i.length=s/2:i=new Array(s/2);for(var u=0;u<s;u+=2){var c=t[u],f=t[u+1],l=u/2;i[l]=a.fromDegrees(c,f,0,o,i[l])}return i},a.fromRadiansArray=function(t,o,i){if(e.defined("coordinates",t),t.length<2||t.length%2!=0)throw new n("the number of coordinates must be a multiple of 2 and at least 2");var s=t.length;r(i)?i.length=s/2:i=new Array(s/2);for(var u=0;u<s;u+=2){var c=t[u],f=t[u+1],l=u/2;i[l]=a.fromRadians(c,f,0,o,i[l])}return i},a.fromDegreesArrayHeights=function(t,o,i){if(e.defined("coordinates",t),t.length<3||t.length%3!=0)throw new n("the number of coordinates must be a multiple of 3 and at least 3");var s=t.length;r(i)?i.length=s/3:i=new Array(s/3);for(var u=0;u<s;u+=3){var c=t[u],f=t[u+1],l=t[u+2],h=u/3;i[h]=a.fromDegrees(c,f,l,o,i[h])}return i},a.fromRadiansArrayHeights=function(t,o,i){if(e.defined("coordinates",t),t.length<3||t.length%3!=0)throw new n("the number of coordinates must be a multiple of 3 and at least 3");var s=t.length;r(i)?i.length=s/3:i=new Array(s/3);for(var u=0;u<s;u+=3){var c=t[u],f=t[u+1],l=t[u+2],h=u/3;i[h]=a.fromRadians(c,f,l,o,i[h])}return i},a.ZERO=o(new a(0,0,0)),a.UNIT_X=o(new a(1,0,0)),a.UNIT_Y=o(new a(0,1,0)),a.UNIT_Z=o(new a(0,0,1)),a.prototype.clone=function(e){return a.clone(this,e)},a.prototype.equals=function(e){return a.equals(this,e)},a.prototype.equalsEpsilon=function(e,t,r){return a.equalsEpsilon(this,e,t,r)},a.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+")"},a})),define("Core/scaleToGeodeticSurface",["./Cartesian3","./defined","./DeveloperError","./Math"],(function(e,t,r,n){"use strict";var o=new e,i=new e;return function(a,s,u,c,f){if(!t(a))throw new r("cartesian is required.");if(!t(s))throw new r("oneOverRadii is required.");if(!t(u))throw new r("oneOverRadiiSquared is required.");if(!t(c))throw new r("centerToleranceSquared is required.");var l=a.x,h=a.y,p=a.z,d=s.x,y=s.y,m=s.z,E=l*l*d*d,O=h*h*y*y,_=p*p*m*m,T=E+O+_,R=Math.sqrt(1/T),w=e.multiplyByScalar(a,R,o);if(T<c)return isFinite(R)?e.clone(w,f):void 0;var g=u.x,A=u.y,S=u.z,b=i;b.x=w.x*g*2,b.y=w.y*A*2,b.z=w.z*S*2;var C,v,N,I,M,x,P,D=(1-R)*e.magnitude(a)/(.5*e.magnitude(b)),F=0;do{F=(C=E*(M=(v=1/(1+(D-=F)*g))*v)+O*(x=(N=1/(1+D*A))*N)+_*(P=(I=1/(1+D*S))*I)-1)/(-2*(E*(M*v)*g+O*(x*N)*A+_*(P*I)*S))}while(Math.abs(C)>n.EPSILON12);return t(f)?(f.x=l*v,f.y=h*N,f.z=p*I,f):new e(l*v,h*N,p*I)}})),define("Core/Cartographic",["./Cartesian3","./Check","./defaultValue","./defined","./freezeObject","./Math","./scaleToGeodeticSurface"],(function(e,t,r,n,o,i,a){"use strict";function s(e,t,n){this.longitude=r(e,0),this.latitude=r(t,0),this.height=r(n,0)}s.fromRadians=function(e,o,i,a){return t.typeOf.number("longitude",e),t.typeOf.number("latitude",o),i=r(i,0),n(a)?(a.longitude=e,a.latitude=o,a.height=i,a):new s(e,o,i)},s.fromDegrees=function(e,r,n,o){return t.typeOf.number("longitude",e),t.typeOf.number("latitude",r),e=i.toRadians(e),r=i.toRadians(r),s.fromRadians(e,r,n,o)};var u=new e,c=new e,f=new e,l=new e(1/6378137,1/6378137,1/6356752.314245179),h=new e(1/40680631590769,1/40680631590769,1/40408299984661.445),p=i.EPSILON1;return s.fromCartesian=function(t,r,o){var d=n(r)?r.oneOverRadii:l,y=n(r)?r.oneOverRadiiSquared:h,m=n(r)?r._centerToleranceSquared:p,E=a(t,d,y,m,c);if(n(E)){var O=e.multiplyComponents(E,y,u);O=e.normalize(O,O);var _=e.subtract(t,E,f),T=Math.atan2(O.y,O.x),R=Math.asin(O.z),w=i.sign(e.dot(_,t))*e.magnitude(_);return n(o)?(o.longitude=T,o.latitude=R,o.height=w,o):new s(T,R,w)}},s.toCartesian=function(r,n,o){return t.defined("cartographic",r),e.fromRadians(r.longitude,r.latitude,r.height,n,o)},s.clone=function(e,t){if(n(e))return n(t)?(t.longitude=e.longitude,t.latitude=e.latitude,t.height=e.height,t):new s(e.longitude,e.latitude,e.height)},s.equals=function(e,t){return e===t||n(e)&&n(t)&&e.longitude===t.longitude&&e.latitude===t.latitude&&e.height===t.height},s.equalsEpsilon=function(e,r,o){return t.typeOf.number("epsilon",o),e===r||n(e)&&n(r)&&Math.abs(e.longitude-r.longitude)<=o&&Math.abs(e.latitude-r.latitude)<=o&&Math.abs(e.height-r.height)<=o},s.ZERO=o(new s(0,0,0)),s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s.prototype.equalsEpsilon=function(e,t){return s.equalsEpsilon(this,e,t)},s.prototype.toString=function(){return"("+this.longitude+", "+this.latitude+", "+this.height+")"},s})),define("Core/defineProperties",["./defined"],(function(e){"use strict";var t=function(){try{return"x"in Object.defineProperty({},"x",{})}catch(e){return!1}}(),r=Object.defineProperties;return t&&e(r)||(r=function(e){return e}),r})),define("Core/Ellipsoid",["./Cartesian3","./Cartographic","./Check","./defaultValue","./defined","./defineProperties","./DeveloperError","./freezeObject","./Math","./scaleToGeodeticSurface"],(function(e,t,r,n,o,i,a,s,u,c){"use strict";function f(t,o,i,a){o=n(o,0),i=n(i,0),a=n(a,0),r.typeOf.number.greaterThanOrEquals("x",o,0),r.typeOf.number.greaterThanOrEquals("y",i,0),r.typeOf.number.greaterThanOrEquals("z",a,0),t._radii=new e(o,i,a),t._radiiSquared=new e(o*o,i*i,a*a),t._radiiToTheFourth=new e(o*o*o*o,i*i*i*i,a*a*a*a),t._oneOverRadii=new e(0===o?0:1/o,0===i?0:1/i,0===a?0:1/a),t._oneOverRadiiSquared=new e(0===o?0:1/(o*o),0===i?0:1/(i*i),0===a?0:1/(a*a)),t._minimumRadius=Math.min(o,i,a),t._maximumRadius=Math.max(o,i,a),t._centerToleranceSquared=u.EPSILON1,0!==t._radiiSquared.z&&(t._squaredXOverSquaredZ=t._radiiSquared.x/t._radiiSquared.z)}function l(e,t,r){this._radii=void 0,this._radiiSquared=void 0,this._radiiToTheFourth=void 0,this._oneOverRadii=void 0,this._oneOverRadiiSquared=void 0,this._minimumRadius=void 0,this._maximumRadius=void 0,this._centerToleranceSquared=void 0,this._squaredXOverSquaredZ=void 0,f(this,e,t,r)}i(l.prototype,{radii:{get:function(){return this._radii}},radiiSquared:{get:function(){return this._radiiSquared}},radiiToTheFourth:{get:function(){return this._radiiToTheFourth}},oneOverRadii:{get:function(){return this._oneOverRadii}},oneOverRadiiSquared:{get:function(){return this._oneOverRadiiSquared}},minimumRadius:{get:function(){return this._minimumRadius}},maximumRadius:{get:function(){return this._maximumRadius}}}),l.clone=function(t,r){if(o(t)){var n=t._radii;return o(r)?(e.clone(n,r._radii),e.clone(t._radiiSquared,r._radiiSquared),e.clone(t._radiiToTheFourth,r._radiiToTheFourth),e.clone(t._oneOverRadii,r._oneOverRadii),e.clone(t._oneOverRadiiSquared,r._oneOverRadiiSquared),r._minimumRadius=t._minimumRadius,r._maximumRadius=t._maximumRadius,r._centerToleranceSquared=t._centerToleranceSquared,r):new l(n.x,n.y,n.z)}},l.fromCartesian3=function(e,t){return o(t)||(t=new l),o(e)?(f(t,e.x,e.y,e.z),t):t},l.WGS84=s(new l(6378137,6378137,6356752.314245179)),l.UNIT_SPHERE=s(new l(1,1,1)),l.MOON=s(new l(u.LUNAR_RADIUS,u.LUNAR_RADIUS,u.LUNAR_RADIUS)),l.prototype.clone=function(e){return l.clone(this,e)},l.packedLength=e.packedLength,l.pack=function(t,o,i){return r.typeOf.object("value",t),r.defined("array",o),i=n(i,0),e.pack(t._radii,o,i),o},l.unpack=function(t,o,i){r.defined("array",t),o=n(o,0);var a=e.unpack(t,o);return l.fromCartesian3(a,i)},l.prototype.geocentricSurfaceNormal=e.normalize,l.prototype.geodeticSurfaceNormalCartographic=function(t,n){r.typeOf.object("cartographic",t);var i=t.longitude,a=t.latitude,s=Math.cos(a),u=s*Math.cos(i),c=s*Math.sin(i),f=Math.sin(a);return o(n)||(n=new e),n.x=u,n.y=c,n.z=f,e.normalize(n,n)},l.prototype.geodeticSurfaceNormal=function(t,r){return o(r)||(r=new e),r=e.multiplyComponents(t,this._oneOverRadiiSquared,r),e.normalize(r,r)};var h=new e,p=new e;l.prototype.cartographicToCartesian=function(t,r){var n=h,i=p;this.geodeticSurfaceNormalCartographic(t,n),e.multiplyComponents(this._radiiSquared,n,i);var a=Math.sqrt(e.dot(n,i));return e.divideByScalar(i,a,i),e.multiplyByScalar(n,t.height,n),o(r)||(r=new e),e.add(i,n,r)},l.prototype.cartographicArrayToCartesianArray=function(e,t){r.defined("cartographics",e);var n=e.length;o(t)?t.length=n:t=new Array(n);for(var i=0;i<n;i++)t[i]=this.cartographicToCartesian(e[i],t[i]);return t};var d=new e,y=new e,m=new e;return l.prototype.cartesianToCartographic=function(r,n){var i=this.scaleToGeodeticSurface(r,y);if(o(i)){var a=this.geodeticSurfaceNormal(i,d),s=e.subtract(r,i,m),c=Math.atan2(a.y,a.x),f=Math.asin(a.z),l=u.sign(e.dot(s,r))*e.magnitude(s);return o(n)?(n.longitude=c,n.latitude=f,n.height=l,n):new t(c,f,l)}},l.prototype.cartesianArrayToCartographicArray=function(e,t){r.defined("cartesians",e);var n=e.length;o(t)?t.length=n:t=new Array(n);for(var i=0;i<n;++i)t[i]=this.cartesianToCartographic(e[i],t[i]);return t},l.prototype.scaleToGeodeticSurface=function(e,t){return c(e,this._oneOverRadii,this._oneOverRadiiSquared,this._centerToleranceSquared,t)},l.prototype.scaleToGeocentricSurface=function(t,n){r.typeOf.object("cartesian",t),o(n)||(n=new e);var i=t.x,a=t.y,s=t.z,u=this._oneOverRadiiSquared,c=1/Math.sqrt(i*i*u.x+a*a*u.y+s*s*u.z);return e.multiplyByScalar(t,c,n)},l.prototype.transformPositionToScaledSpace=function(t,r){return o(r)||(r=new e),e.multiplyComponents(t,this._oneOverRadii,r)},l.prototype.transformPositionFromScaledSpace=function(t,r){return o(r)||(r=new e),e.multiplyComponents(t,this._radii,r)},l.prototype.equals=function(t){return this===t||o(t)&&e.equals(this._radii,t._radii)},l.prototype.toString=function(){return this._radii.toString()},l.prototype.getSurfaceNormalIntersectionWithZAxis=function(t,i,s){if(r.typeOf.object("position",t),!u.equalsEpsilon(this._radii.x,this._radii.y,u.EPSILON15))throw new a("Ellipsoid must be an ellipsoid of revolution (radii.x == radii.y)");r.typeOf.number.greaterThan("Ellipsoid.radii.z",this._radii.z,0),i=n(i,0);var c=this._squaredXOverSquaredZ;if(o(s)||(s=new e),s.x=0,s.y=0,s.z=t.z*(1-c),!(Math.abs(s.z)>=this._radii.z-i))return s},l})),define("Core/arrayRemoveDuplicates",["./Check","./defaultValue","./defined","./Math"],(function(e,t,r,n){"use strict";var o=n.EPSILON10;return function(n,i,a){if(e.defined("equalsEpsilon",i),r(n)){a=t(a,!1);var s,u,c,f=n.length;if(f<2)return n;for(s=1;s<f&&!i(u=n[s-1],c=n[s],o);++s);if(s===f)return a&&i(n[0],n[n.length-1],o)?n.slice(1):n;for(var l=n.slice(0,s);s<f;++s)i(u,c=n[s],o)||(l.push(c),u=c);return a&&l.length>1&&i(l[0],l[l.length-1],o)&&l.shift(),l}}})),define("Core/GeographicProjection",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid"],(function(e,t,r,n,o,i,a){"use strict";function s(e){this._ellipsoid=r(e,a.WGS84),this._semimajorAxis=this._ellipsoid.maximumRadius,this._oneOverSemimajorAxis=1/this._semimajorAxis}return o(s.prototype,{ellipsoid:{get:function(){return this._ellipsoid}}}),s.prototype.project=function(t,r){var o=this._semimajorAxis,i=t.longitude*o,a=t.latitude*o,s=t.height;return n(r)?(r.x=i,r.y=a,r.z=s,r):new e(i,a,s)},s.prototype.unproject=function(e,r){if(!n(e))throw new i("cartesian is required");var o=this._oneOverSemimajorAxis,a=e.x*o,s=e.y*o,u=e.z;return n(r)?(r.longitude=a,r.latitude=s,r.height=u,r):new t(a,s,u)},s})),define("Core/Intersect",["./freezeObject"],(function(e){"use strict";return e({OUTSIDE:-1,INTERSECTING:0,INSIDE:1})})),define("Core/Interval",["./defaultValue"],(function(e){"use strict";return function(t,r){this.start=e(t,0),this.stop=e(r,0)}})),define("Core/Matrix3",["./Cartesian3","./Check","./defaultValue","./defined","./defineProperties","./DeveloperError","./freezeObject","./Math"],(function(e,t,r,n,o,i,a,s){"use strict";function u(e,t,n,o,i,a,s,u,c){this[0]=r(e,0),this[1]=r(o,0),this[2]=r(s,0),this[3]=r(t,0),this[4]=r(i,0),this[5]=r(u,0),this[6]=r(n,0),this[7]=r(a,0),this[8]=r(c,0)}u.packedLength=9,u.pack=function(e,n,o){return t.typeOf.object("value",e),t.defined("array",n),o=r(o,0),n[o++]=e[0],n[o++]=e[1],n[o++]=e[2],n[o++]=e[3],n[o++]=e[4],n[o++]=e[5],n[o++]=e[6],n[o++]=e[7],n[o++]=e[8],n},u.unpack=function(e,o,i){return t.defined("array",e),o=r(o,0),n(i)||(i=new u),i[0]=e[o++],i[1]=e[o++],i[2]=e[o++],i[3]=e[o++],i[4]=e[o++],i[5]=e[o++],i[6]=e[o++],i[7]=e[o++],i[8]=e[o++],i},u.clone=function(e,t){if(n(e))return n(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t):new u(e[0],e[3],e[6],e[1],e[4],e[7],e[2],e[5],e[8])},u.fromArray=function(e,o,i){return t.defined("array",e),o=r(o,0),n(i)||(i=new u),i[0]=e[o],i[1]=e[o+1],i[2]=e[o+2],i[3]=e[o+3],i[4]=e[o+4],i[5]=e[o+5],i[6]=e[o+6],i[7]=e[o+7],i[8]=e[o+8],i},u.fromColumnMajorArray=function(e,r){return t.defined("values",e),u.clone(e,r)},u.fromRowMajorArray=function(e,r){return t.defined("values",e),n(r)?(r[0]=e[0],r[1]=e[3],r[2]=e[6],r[3]=e[1],r[4]=e[4],r[5]=e[7],r[6]=e[2],r[7]=e[5],r[8]=e[8],r):new u(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8])},u.fromQuaternion=function(e,r){t.typeOf.object("quaternion",e);var o=e.x*e.x,i=e.x*e.y,a=e.x*e.z,s=e.x*e.w,c=e.y*e.y,f=e.y*e.z,l=e.y*e.w,h=e.z*e.z,p=e.z*e.w,d=e.w*e.w,y=o-c-h+d,m=2*(i-p),E=2*(a+l),O=2*(i+p),_=-o+c-h+d,T=2*(f-s),R=2*(a-l),w=2*(f+s),g=-o-c+h+d;return n(r)?(r[0]=y,r[1]=O,r[2]=R,r[3]=m,r[4]=_,r[5]=w,r[6]=E,r[7]=T,r[8]=g,r):new u(y,m,E,O,_,T,R,w,g)},u.fromHeadingPitchRoll=function(e,r){t.typeOf.object("headingPitchRoll",e);var o=Math.cos(-e.pitch),i=Math.cos(-e.heading),a=Math.cos(e.roll),s=Math.sin(-e.pitch),c=Math.sin(-e.heading),f=Math.sin(e.roll),l=o*i,h=-a*c+f*s*i,p=f*c+a*s*i,d=o*c,y=a*i+f*s*c,m=-f*i+a*s*c,E=-s,O=f*o,_=a*o;return n(r)?(r[0]=l,r[1]=d,r[2]=E,r[3]=h,r[4]=y,r[5]=O,r[6]=p,r[7]=m,r[8]=_,r):new u(l,h,p,d,y,m,E,O,_)},u.fromScale=function(e,r){return t.typeOf.object("scale",e),n(r)?(r[0]=e.x,r[1]=0,r[2]=0,r[3]=0,r[4]=e.y,r[5]=0,r[6]=0,r[7]=0,r[8]=e.z,r):new u(e.x,0,0,0,e.y,0,0,0,e.z)},u.fromUniformScale=function(e,r){return t.typeOf.number("scale",e),n(r)?(r[0]=e,r[1]=0,r[2]=0,r[3]=0,r[4]=e,r[5]=0,r[6]=0,r[7]=0,r[8]=e,r):new u(e,0,0,0,e,0,0,0,e)},u.fromCrossProduct=function(e,r){return t.typeOf.object("vector",e),n(r)?(r[0]=0,r[1]=e.z,r[2]=-e.y,r[3]=-e.z,r[4]=0,r[5]=e.x,r[6]=e.y,r[7]=-e.x,r[8]=0,r):new u(0,-e.z,e.y,e.z,0,-e.x,-e.y,e.x,0)},u.fromRotationX=function(e,r){t.typeOf.number("angle",e);var o=Math.cos(e),i=Math.sin(e);return n(r)?(r[0]=1,r[1]=0,r[2]=0,r[3]=0,r[4]=o,r[5]=i,r[6]=0,r[7]=-i,r[8]=o,r):new u(1,0,0,0,o,-i,0,i,o)},u.fromRotationY=function(e,r){t.typeOf.number("angle",e);var o=Math.cos(e),i=Math.sin(e);return n(r)?(r[0]=o,r[1]=0,r[2]=-i,r[3]=0,r[4]=1,r[5]=0,r[6]=i,r[7]=0,r[8]=o,r):new u(o,0,i,0,1,0,-i,0,o)},u.fromRotationZ=function(e,r){t.typeOf.number("angle",e);var o=Math.cos(e),i=Math.sin(e);return n(r)?(r[0]=o,r[1]=i,r[2]=0,r[3]=-i,r[4]=o,r[5]=0,r[6]=0,r[7]=0,r[8]=1,r):new u(o,-i,0,i,o,0,0,0,1)},u.toArray=function(e,r){return t.typeOf.object("matrix",e),n(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8]]},u.getElementIndex=function(e,r){return t.typeOf.number.greaterThanOrEquals("row",r,0),t.typeOf.number.lessThanOrEquals("row",r,2),t.typeOf.number.greaterThanOrEquals("column",e,0),t.typeOf.number.lessThanOrEquals("column",e,2),3*e+r},u.getColumn=function(e,r,n){t.typeOf.object("matrix",e),t.typeOf.number.greaterThanOrEquals("index",r,0),t.typeOf.number.lessThanOrEquals("index",r,2),t.typeOf.object("result",n);var o=3*r,i=e[o],a=e[o+1],s=e[o+2];return n.x=i,n.y=a,n.z=s,n},u.setColumn=function(e,r,n,o){t.typeOf.object("matrix",e),t.typeOf.number.greaterThanOrEquals("index",r,0),t.typeOf.number.lessThanOrEquals("index",r,2),t.typeOf.object("cartesian",n),t.typeOf.object("result",o);var i=3*r;return(o=u.clone(e,o))[i]=n.x,o[i+1]=n.y,o[i+2]=n.z,o},u.getRow=function(e,r,n){t.typeOf.object("matrix",e),t.typeOf.number.greaterThanOrEquals("index",r,0),t.typeOf.number.lessThanOrEquals("index",r,2),t.typeOf.object("result",n);var o=e[r],i=e[r+3],a=e[r+6];return n.x=o,n.y=i,n.z=a,n},u.setRow=function(e,r,n,o){return t.typeOf.object("matrix",e),t.typeOf.number.greaterThanOrEquals("index",r,0),t.typeOf.number.lessThanOrEquals("index",r,2),t.typeOf.object("cartesian",n),t.typeOf.object("result",o),(o=u.clone(e,o))[r]=n.x,o[r+3]=n.y,o[r+6]=n.z,o};var c=new e;u.getScale=function(r,n){return t.typeOf.object("matrix",r),t.typeOf.object("result",n),n.x=e.magnitude(e.fromElements(r[0],r[1],r[2],c)),n.y=e.magnitude(e.fromElements(r[3],r[4],r[5],c)),n.z=e.magnitude(e.fromElements(r[6],r[7],r[8],c)),n};var f=new e;u.getMaximumScale=function(t){return u.getScale(t,f),e.maximumComponent(f)},u.multiply=function(e,r,n){t.typeOf.object("left",e),t.typeOf.object("right",r),t.typeOf.object("result",n);var o=e[0]*r[0]+e[3]*r[1]+e[6]*r[2],i=e[1]*r[0]+e[4]*r[1]+e[7]*r[2],a=e[2]*r[0]+e[5]*r[1]+e[8]*r[2],s=e[0]*r[3]+e[3]*r[4]+e[6]*r[5],u=e[1]*r[3]+e[4]*r[4]+e[7]*r[5],c=e[2]*r[3]+e[5]*r[4]+e[8]*r[5],f=e[0]*r[6]+e[3]*r[7]+e[6]*r[8],l=e[1]*r[6]+e[4]*r[7]+e[7]*r[8],h=e[2]*r[6]+e[5]*r[7]+e[8]*r[8];return n[0]=o,n[1]=i,n[2]=a,n[3]=s,n[4]=u,n[5]=c,n[6]=f,n[7]=l,n[8]=h,n},u.add=function(e,r,n){return t.typeOf.object("left",e),t.typeOf.object("right",r),t.typeOf.object("result",n),n[0]=e[0]+r[0],n[1]=e[1]+r[1],n[2]=e[2]+r[2],n[3]=e[3]+r[3],n[4]=e[4]+r[4],n[5]=e[5]+r[5],n[6]=e[6]+r[6],n[7]=e[7]+r[7],n[8]=e[8]+r[8],n},u.subtract=function(e,r,n){return t.typeOf.object("left",e),t.typeOf.object("right",r),t.typeOf.object("result",n),n[0]=e[0]-r[0],n[1]=e[1]-r[1],n[2]=e[2]-r[2],n[3]=e[3]-r[3],n[4]=e[4]-r[4],n[5]=e[5]-r[5],n[6]=e[6]-r[6],n[7]=e[7]-r[7],n[8]=e[8]-r[8],n},u.multiplyByVector=function(e,r,n){t.typeOf.object("matrix",e),t.typeOf.object("cartesian",r),t.typeOf.object("result",n);var o=r.x,i=r.y,a=r.z,s=e[0]*o+e[3]*i+e[6]*a,u=e[1]*o+e[4]*i+e[7]*a,c=e[2]*o+e[5]*i+e[8]*a;return n.x=s,n.y=u,n.z=c,n},u.multiplyByScalar=function(e,r,n){return t.typeOf.object("matrix",e),t.typeOf.number("scalar",r),t.typeOf.object("result",n),n[0]=e[0]*r,n[1]=e[1]*r,n[2]=e[2]*r,n[3]=e[3]*r,n[4]=e[4]*r,n[5]=e[5]*r,n[6]=e[6]*r,n[7]=e[7]*r,n[8]=e[8]*r,n},u.multiplyByScale=function(e,r,n){return t.typeOf.object("matrix",e),t.typeOf.object("scale",r),t.typeOf.object("result",n),n[0]=e[0]*r.x,n[1]=e[1]*r.x,n[2]=e[2]*r.x,n[3]=e[3]*r.y,n[4]=e[4]*r.y,n[5]=e[5]*r.y,n[6]=e[6]*r.z,n[7]=e[7]*r.z,n[8]=e[8]*r.z,n},u.negate=function(e,r){return t.typeOf.object("matrix",e),t.typeOf.object("result",r),r[0]=-e[0],r[1]=-e[1],r[2]=-e[2],r[3]=-e[3],r[4]=-e[4],r[5]=-e[5],r[6]=-e[6],r[7]=-e[7],r[8]=-e[8],r},u.transpose=function(e,r){t.typeOf.object("matrix",e),t.typeOf.object("result",r);var n=e[0],o=e[3],i=e[6],a=e[1],s=e[4],u=e[7],c=e[2],f=e[5],l=e[8];return r[0]=n,r[1]=o,r[2]=i,r[3]=a,r[4]=s,r[5]=u,r[6]=c,r[7]=f,r[8]=l,r};var l=[1,0,0],h=[2,2,1];function p(e){for(var t=0,r=0;r<3;++r){var n=e[u.getElementIndex(h[r],l[r])];t+=2*n*n}return Math.sqrt(t)}function d(e,t){for(var r=s.EPSILON15,n=0,o=1,i=0;i<3;++i){var a=Math.abs(e[u.getElementIndex(h[i],l[i])]);a>n&&(o=i,n=a)}var c=1,f=0,p=l[o],d=h[o];if(Math.abs(e[u.getElementIndex(d,p)])>r){var y,m=(e[u.getElementIndex(d,d)]-e[u.getElementIndex(p,p)])/2/e[u.getElementIndex(d,p)];f=(y=m<0?-1/(-m+Math.sqrt(1+m*m)):1/(m+Math.sqrt(1+m*m)))*(c=1/Math.sqrt(1+y*y))}return(t=u.clone(u.IDENTITY,t))[u.getElementIndex(p,p)]=t[u.getElementIndex(d,d)]=c,t[u.getElementIndex(d,p)]=f,t[u.getElementIndex(p,d)]=-f,t}var y=new u,m=new u;return u.computeEigenDecomposition=function(e,r){t.typeOf.object("matrix",e);var o=s.EPSILON20,i=0,a=0;n(r)||(r={});for(var c=r.unitary=u.clone(u.IDENTITY,r.unitary),f=r.diagonal=u.clone(e,r.diagonal),l=o*function(e){for(var t=0,r=0;r<9;++r){var n=e[r];t+=n*n}return Math.sqrt(t)}(f);a<10&&p(f)>l;)d(f,y),u.transpose(y,m),u.multiply(f,y,f),u.multiply(m,f,f),u.multiply(c,y,c),++i>2&&(++a,i=0);return r},u.abs=function(e,r){return t.typeOf.object("matrix",e),t.typeOf.object("result",r),r[0]=Math.abs(e[0]),r[1]=Math.abs(e[1]),r[2]=Math.abs(e[2]),r[3]=Math.abs(e[3]),r[4]=Math.abs(e[4]),r[5]=Math.abs(e[5]),r[6]=Math.abs(e[6]),r[7]=Math.abs(e[7]),r[8]=Math.abs(e[8]),r},u.determinant=function(e){t.typeOf.object("matrix",e);var r=e[0],n=e[3],o=e[6],i=e[1],a=e[4],s=e[7],u=e[2],c=e[5],f=e[8];return r*(a*f-c*s)+i*(c*o-n*f)+u*(n*s-a*o)},u.inverse=function(e,r){t.typeOf.object("matrix",e),t.typeOf.object("result",r);var n=e[0],o=e[1],a=e[2],c=e[3],f=e[4],l=e[5],h=e[6],p=e[7],d=e[8],y=u.determinant(e);if(Math.abs(y)<=s.EPSILON15)throw new i("matrix is not invertible");r[0]=f*d-p*l,r[1]=p*a-o*d,r[2]=o*l-f*a,r[3]=h*l-c*d,r[4]=n*d-h*a,r[5]=c*a-n*l,r[6]=c*p-h*f,r[7]=h*o-n*p,r[8]=n*f-c*o;var m=1/y;return u.multiplyByScalar(r,m,r)},u.equals=function(e,t){return e===t||n(e)&&n(t)&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[3]===t[3]&&e[4]===t[4]&&e[5]===t[5]&&e[6]===t[6]&&e[7]===t[7]&&e[8]===t[8]},u.equalsEpsilon=function(e,r,o){return t.typeOf.number("epsilon",o),e===r||n(e)&&n(r)&&Math.abs(e[0]-r[0])<=o&&Math.abs(e[1]-r[1])<=o&&Math.abs(e[2]-r[2])<=o&&Math.abs(e[3]-r[3])<=o&&Math.abs(e[4]-r[4])<=o&&Math.abs(e[5]-r[5])<=o&&Math.abs(e[6]-r[6])<=o&&Math.abs(e[7]-r[7])<=o&&Math.abs(e[8]-r[8])<=o},u.IDENTITY=a(new u(1,0,0,0,1,0,0,0,1)),u.ZERO=a(new u(0,0,0,0,0,0,0,0,0)),u.COLUMN0ROW0=0,u.COLUMN0ROW1=1,u.COLUMN0ROW2=2,u.COLUMN1ROW0=3,u.COLUMN1ROW1=4,u.COLUMN1ROW2=5,u.COLUMN2ROW0=6,u.COLUMN2ROW1=7,u.COLUMN2ROW2=8,o(u.prototype,{length:{get:function(){return u.packedLength}}}),u.prototype.clone=function(e){return u.clone(this,e)},u.prototype.equals=function(e){return u.equals(this,e)},u.equalsArray=function(e,t,r){return e[0]===t[r]&&e[1]===t[r+1]&&e[2]===t[r+2]&&e[3]===t[r+3]&&e[4]===t[r+4]&&e[5]===t[r+5]&&e[6]===t[r+6]&&e[7]===t[r+7]&&e[8]===t[r+8]},u.prototype.equalsEpsilon=function(e,t){return u.equalsEpsilon(this,e,t)},u.prototype.toString=function(){return"("+this[0]+", "+this[3]+", "+this[6]+")\n("+this[1]+", "+this[4]+", "+this[7]+")\n("+this[2]+", "+this[5]+", "+this[8]+")"},u})),define("Core/Cartesian4",["./Check","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],(function(e,t,r,n,o,i){"use strict";function a(e,r,n,o){this.x=t(e,0),this.y=t(r,0),this.z=t(n,0),this.w=t(o,0)}a.fromElements=function(e,t,n,o,i){return r(i)?(i.x=e,i.y=t,i.z=n,i.w=o,i):new a(e,t,n,o)},a.fromColor=function(t,n){return e.typeOf.object("color",t),r(n)?(n.x=t.red,n.y=t.green,n.z=t.blue,n.w=t.alpha,n):new a(t.red,t.green,t.blue,t.alpha)},a.clone=function(e,t){if(r(e))return r(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t.w=e.w,t):new a(e.x,e.y,e.z,e.w)},a.packedLength=4,a.pack=function(r,n,o){return e.typeOf.object("value",r),e.defined("array",n),o=t(o,0),n[o++]=r.x,n[o++]=r.y,n[o++]=r.z,n[o]=r.w,n},a.unpack=function(n,o,i){return e.defined("array",n),o=t(o,0),r(i)||(i=new a),i.x=n[o++],i.y=n[o++],i.z=n[o++],i.w=n[o],i},a.packArray=function(t,n){e.defined("array",t);var o=t.length;r(n)?n.length=4*o:n=new Array(4*o);for(var i=0;i<o;++i)a.pack(t[i],n,4*i);return n},a.unpackArray=function(t,n){e.defined("array",t);var o=t.length;r(n)?n.length=o/4:n=new Array(o/4);for(var i=0;i<o;i+=4){var s=i/4;n[s]=a.unpack(t,i,n[s])}return n},a.fromArray=a.unpack,a.maximumComponent=function(t){return e.typeOf.object("cartesian",t),Math.max(t.x,t.y,t.z,t.w)},a.minimumComponent=function(t){return e.typeOf.object("cartesian",t),Math.min(t.x,t.y,t.z,t.w)},a.minimumByComponent=function(t,r,n){return e.typeOf.object("first",t),e.typeOf.object("second",r),e.typeOf.object("result",n),n.x=Math.min(t.x,r.x),n.y=Math.min(t.y,r.y),n.z=Math.min(t.z,r.z),n.w=Math.min(t.w,r.w),n},a.maximumByComponent=function(t,r,n){return e.typeOf.object("first",t),e.typeOf.object("second",r),e.typeOf.object("result",n),n.x=Math.max(t.x,r.x),n.y=Math.max(t.y,r.y),n.z=Math.max(t.z,r.z),n.w=Math.max(t.w,r.w),n},a.magnitudeSquared=function(t){return e.typeOf.object("cartesian",t),t.x*t.x+t.y*t.y+t.z*t.z+t.w*t.w},a.magnitude=function(e){return Math.sqrt(a.magnitudeSquared(e))};var s=new a;a.distance=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),a.subtract(t,r,s),a.magnitude(s)},a.distanceSquared=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),a.subtract(t,r,s),a.magnitudeSquared(s)},a.normalize=function(t,r){e.typeOf.object("cartesian",t),e.typeOf.object("result",r);var o=a.magnitude(t);if(r.x=t.x/o,r.y=t.y/o,r.z=t.z/o,r.w=t.w/o,isNaN(r.x)||isNaN(r.y)||isNaN(r.z)||isNaN(r.w))throw new n("normalized result is not a number");return r},a.dot=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),t.x*r.x+t.y*r.y+t.z*r.z+t.w*r.w},a.multiplyComponents=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x*r.x,n.y=t.y*r.y,n.z=t.z*r.z,n.w=t.w*r.w,n},a.divideComponents=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x/r.x,n.y=t.y/r.y,n.z=t.z/r.z,n.w=t.w/r.w,n},a.add=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x+r.x,n.y=t.y+r.y,n.z=t.z+r.z,n.w=t.w+r.w,n},a.subtract=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x-r.x,n.y=t.y-r.y,n.z=t.z-r.z,n.w=t.w-r.w,n},a.multiplyByScalar=function(t,r,n){return e.typeOf.object("cartesian",t),e.typeOf.number("scalar",r),e.typeOf.object("result",n),n.x=t.x*r,n.y=t.y*r,n.z=t.z*r,n.w=t.w*r,n},a.divideByScalar=function(t,r,n){return e.typeOf.object("cartesian",t),e.typeOf.number("scalar",r),e.typeOf.object("result",n),n.x=t.x/r,n.y=t.y/r,n.z=t.z/r,n.w=t.w/r,n},a.negate=function(t,r){return e.typeOf.object("cartesian",t),e.typeOf.object("result",r),r.x=-t.x,r.y=-t.y,r.z=-t.z,r.w=-t.w,r},a.abs=function(t,r){return e.typeOf.object("cartesian",t),e.typeOf.object("result",r),r.x=Math.abs(t.x),r.y=Math.abs(t.y),r.z=Math.abs(t.z),r.w=Math.abs(t.w),r};var u=new a;a.lerp=function(t,r,n,o){return e.typeOf.object("start",t),e.typeOf.object("end",r),e.typeOf.number("t",n),e.typeOf.object("result",o),a.multiplyByScalar(r,n,u),o=a.multiplyByScalar(t,1-n,o),a.add(u,o,o)};var c=new a;a.mostOrthogonalAxis=function(t,r){e.typeOf.object("cartesian",t),e.typeOf.object("result",r);var n=a.normalize(t,c);return a.abs(n,n),r=n.x<=n.y?n.x<=n.z?n.x<=n.w?a.clone(a.UNIT_X,r):a.clone(a.UNIT_W,r):n.z<=n.w?a.clone(a.UNIT_Z,r):a.clone(a.UNIT_W,r):n.y<=n.z?n.y<=n.w?a.clone(a.UNIT_Y,r):a.clone(a.UNIT_W,r):n.z<=n.w?a.clone(a.UNIT_Z,r):a.clone(a.UNIT_W,r)},a.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z&&e.w===t.w},a.equalsArray=function(e,t,r){return e.x===t[r]&&e.y===t[r+1]&&e.z===t[r+2]&&e.w===t[r+3]},a.equalsEpsilon=function(e,t,n,o){return e===t||r(e)&&r(t)&&i.equalsEpsilon(e.x,t.x,n,o)&&i.equalsEpsilon(e.y,t.y,n,o)&&i.equalsEpsilon(e.z,t.z,n,o)&&i.equalsEpsilon(e.w,t.w,n,o)},a.ZERO=o(new a(0,0,0,0)),a.UNIT_X=o(new a(1,0,0,0)),a.UNIT_Y=o(new a(0,1,0,0)),a.UNIT_Z=o(new a(0,0,1,0)),a.UNIT_W=o(new a(0,0,0,1)),a.prototype.clone=function(e){return a.clone(this,e)},a.prototype.equals=function(e){return a.equals(this,e)},a.prototype.equalsEpsilon=function(e,t,r){return a.equalsEpsilon(this,e,t,r)},a.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"};var f=new Float32Array(1);return a.packFloat=function(t,n){if(e.typeOf.number("value",t),r(n)||(n=new a),f[0]=t,0===(t=f[0]))return a.clone(a.ZERO,n);var o,s=t<0?1:0;isFinite(t)?(t=Math.abs(t),o=Math.floor(i.logBase(t,10))+1,t/=Math.pow(10,o)):(t=.1,o=38);var u=256*t;return n.x=Math.floor(u),u=256*(u-n.x),n.y=Math.floor(u),u=256*(u-n.y),n.z=Math.floor(u),n.w=2*(o+38)+s,n},a.unpackFloat=function(t){e.typeOf.object("packedFloat",t);var r=t.w/2,n=Math.floor(r),o=2*(r-n);if(o=-(o=2*o-1),(n-=38)>=38)return o<0?Number.NEGATIVE_INFINITY:Number.POSITIVE_INFINITY;var i=o*t.x*(1/256);return i+=o*t.y*(1/65536),(i+=o*t.z*(1/16777216))*Math.pow(10,n)},a})),define("Core/RuntimeError",["./defined"],(function(e){"use strict";function t(e){var t;this.name="RuntimeError",this.message=e;try{throw new Error}catch(e){t=e.stack}this.stack=t}return e(Object.create)&&(t.prototype=Object.create(Error.prototype),t.prototype.constructor=t),t.prototype.toString=function(){var t=this.name+": "+this.message;return e(this.stack)&&(t+="\n"+this.stack.toString()),t},t})),define("Core/Matrix4",["./Cartesian3","./Cartesian4","./Check","./defaultValue","./defined","./defineProperties","./freezeObject","./Math","./Matrix3","./RuntimeError"],(function(e,t,r,n,o,i,a,s,u,c){"use strict";function f(e,t,r,o,i,a,s,u,c,f,l,h,p,d,y,m){this[0]=n(e,0),this[1]=n(i,0),this[2]=n(c,0),this[3]=n(p,0),this[4]=n(t,0),this[5]=n(a,0),this[6]=n(f,0),this[7]=n(d,0),this[8]=n(r,0),this[9]=n(s,0),this[10]=n(l,0),this[11]=n(y,0),this[12]=n(o,0),this[13]=n(u,0),this[14]=n(h,0),this[15]=n(m,0)}f.packedLength=16,f.pack=function(e,t,o){return r.typeOf.object("value",e),r.defined("array",t),o=n(o,0),t[o++]=e[0],t[o++]=e[1],t[o++]=e[2],t[o++]=e[3],t[o++]=e[4],t[o++]=e[5],t[o++]=e[6],t[o++]=e[7],t[o++]=e[8],t[o++]=e[9],t[o++]=e[10],t[o++]=e[11],t[o++]=e[12],t[o++]=e[13],t[o++]=e[14],t[o]=e[15],t},f.unpack=function(e,t,i){return r.defined("array",e),t=n(t,0),o(i)||(i=new f),i[0]=e[t++],i[1]=e[t++],i[2]=e[t++],i[3]=e[t++],i[4]=e[t++],i[5]=e[t++],i[6]=e[t++],i[7]=e[t++],i[8]=e[t++],i[9]=e[t++],i[10]=e[t++],i[11]=e[t++],i[12]=e[t++],i[13]=e[t++],i[14]=e[t++],i[15]=e[t],i},f.clone=function(e,t){if(o(e))return o(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t):new f(e[0],e[4],e[8],e[12],e[1],e[5],e[9],e[13],e[2],e[6],e[10],e[14],e[3],e[7],e[11],e[15])},f.fromArray=f.unpack,f.fromColumnMajorArray=function(e,t){return r.defined("values",e),f.clone(e,t)},f.fromRowMajorArray=function(e,t){return r.defined("values",e),o(t)?(t[0]=e[0],t[1]=e[4],t[2]=e[8],t[3]=e[12],t[4]=e[1],t[5]=e[5],t[6]=e[9],t[7]=e[13],t[8]=e[2],t[9]=e[6],t[10]=e[10],t[11]=e[14],t[12]=e[3],t[13]=e[7],t[14]=e[11],t[15]=e[15],t):new f(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15])},f.fromRotationTranslation=function(t,i,a){return r.typeOf.object("rotation",t),i=n(i,e.ZERO),o(a)?(a[0]=t[0],a[1]=t[1],a[2]=t[2],a[3]=0,a[4]=t[3],a[5]=t[4],a[6]=t[5],a[7]=0,a[8]=t[6],a[9]=t[7],a[10]=t[8],a[11]=0,a[12]=i.x,a[13]=i.y,a[14]=i.z,a[15]=1,a):new f(t[0],t[3],t[6],i.x,t[1],t[4],t[7],i.y,t[2],t[5],t[8],i.z,0,0,0,1)},f.fromTranslationQuaternionRotationScale=function(e,t,n,i){r.typeOf.object("translation",e),r.typeOf.object("rotation",t),r.typeOf.object("scale",n),o(i)||(i=new f);var a=n.x,s=n.y,u=n.z,c=t.x*t.x,l=t.x*t.y,h=t.x*t.z,p=t.x*t.w,d=t.y*t.y,y=t.y*t.z,m=t.y*t.w,E=t.z*t.z,O=t.z*t.w,_=t.w*t.w,T=c-d-E+_,R=2*(l-O),w=2*(h+m),g=2*(l+O),A=-c+d-E+_,S=2*(y-p),b=2*(h-m),C=2*(y+p),v=-c-d+E+_;return i[0]=T*a,i[1]=g*a,i[2]=b*a,i[3]=0,i[4]=R*s,i[5]=A*s,i[6]=C*s,i[7]=0,i[8]=w*u,i[9]=S*u,i[10]=v*u,i[11]=0,i[12]=e.x,i[13]=e.y,i[14]=e.z,i[15]=1,i},f.fromTranslationRotationScale=function(e,t){return r.typeOf.object("translationRotationScale",e),f.fromTranslationQuaternionRotationScale(e.translation,e.rotation,e.scale,t)},f.fromTranslation=function(e,t){return r.typeOf.object("translation",e),f.fromRotationTranslation(u.IDENTITY,e,t)},f.fromScale=function(e,t){return r.typeOf.object("scale",e),o(t)?(t[0]=e.x,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=e.y,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=e.z,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t):new f(e.x,0,0,0,0,e.y,0,0,0,0,e.z,0,0,0,0,1)},f.fromUniformScale=function(e,t){return r.typeOf.number("scale",e),o(t)?(t[0]=e,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=e,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=e,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t):new f(e,0,0,0,0,e,0,0,0,0,e,0,0,0,0,1)};var l=new e,h=new e,p=new e;f.fromCamera=function(t,n){r.typeOf.object("camera",t);var i=t.position,a=t.direction,s=t.up;r.typeOf.object("camera.position",i),r.typeOf.object("camera.direction",a),r.typeOf.object("camera.up",s),e.normalize(a,l),e.normalize(e.cross(l,s,h),h),e.normalize(e.cross(h,l,p),p);var u=h.x,c=h.y,d=h.z,y=l.x,m=l.y,E=l.z,O=p.x,_=p.y,T=p.z,R=i.x,w=i.y,g=i.z,A=u*-R+c*-w+d*-g,S=O*-R+_*-w+T*-g,b=y*R+m*w+E*g;return o(n)?(n[0]=u,n[1]=O,n[2]=-y,n[3]=0,n[4]=c,n[5]=_,n[6]=-m,n[7]=0,n[8]=d,n[9]=T,n[10]=-E,n[11]=0,n[12]=A,n[13]=S,n[14]=b,n[15]=1,n):new f(u,c,d,A,O,_,T,S,-y,-m,-E,b,0,0,0,1)},f.computePerspectiveFieldOfView=function(e,t,n,o,i){r.typeOf.number.greaterThan("fovY",e,0),r.typeOf.number.lessThan("fovY",e,Math.PI),r.typeOf.number.greaterThan("near",n,0),r.typeOf.number.greaterThan("far",o,0),r.typeOf.object("result",i);var a=1/Math.tan(.5*e),s=a/t,u=(o+n)/(n-o),c=2*o*n/(n-o);return i[0]=s,i[1]=0,i[2]=0,i[3]=0,i[4]=0,i[5]=a,i[6]=0,i[7]=0,i[8]=0,i[9]=0,i[10]=u,i[11]=-1,i[12]=0,i[13]=0,i[14]=c,i[15]=0,i},f.computeOrthographicOffCenter=function(e,t,n,o,i,a,s){r.typeOf.number("left",e),r.typeOf.number("right",t),r.typeOf.number("bottom",n),r.typeOf.number("top",o),r.typeOf.number("near",i),r.typeOf.number("far",a),r.typeOf.object("result",s);var u=1/(t-e),c=1/(o-n),f=1/(a-i),l=-(t+e)*u,h=-(o+n)*c,p=-(a+i)*f;return u*=2,c*=2,f*=-2,s[0]=u,s[1]=0,s[2]=0,s[3]=0,s[4]=0,s[5]=c,s[6]=0,s[7]=0,s[8]=0,s[9]=0,s[10]=f,s[11]=0,s[12]=l,s[13]=h,s[14]=p,s[15]=1,s},f.computePerspectiveOffCenter=function(e,t,n,o,i,a,s){r.typeOf.number("left",e),r.typeOf.number("right",t),r.typeOf.number("bottom",n),r.typeOf.number("top",o),r.typeOf.number("near",i),r.typeOf.number("far",a),r.typeOf.object("result",s);var u=2*i/(t-e),c=2*i/(o-n),f=(t+e)/(t-e),l=(o+n)/(o-n),h=-(a+i)/(a-i),p=-2*a*i/(a-i);return s[0]=u,s[1]=0,s[2]=0,s[3]=0,s[4]=0,s[5]=c,s[6]=0,s[7]=0,s[8]=f,s[9]=l,s[10]=h,s[11]=-1,s[12]=0,s[13]=0,s[14]=p,s[15]=0,s},f.computeInfinitePerspectiveOffCenter=function(e,t,n,o,i,a){r.typeOf.number("left",e),r.typeOf.number("right",t),r.typeOf.number("bottom",n),r.typeOf.number("top",o),r.typeOf.number("near",i),r.typeOf.object("result",a);var s=2*i/(t-e),u=2*i/(o-n),c=(t+e)/(t-e),f=(o+n)/(o-n),l=-2*i;return a[0]=s,a[1]=0,a[2]=0,a[3]=0,a[4]=0,a[5]=u,a[6]=0,a[7]=0,a[8]=c,a[9]=f,a[10]=-1,a[11]=-1,a[12]=0,a[13]=0,a[14]=l,a[15]=0,a},f.computeViewportTransformation=function(e,t,o,i){r.typeOf.object("result",i),e=n(e,n.EMPTY_OBJECT);var a=n(e.x,0),s=n(e.y,0),u=n(e.width,0),c=n(e.height,0);t=n(t,0);var f=.5*u,l=.5*c,h=.5*((o=n(o,1))-t),p=f,d=l,y=h,m=a+f,E=s+l,O=t+h;return i[0]=p,i[1]=0,i[2]=0,i[3]=0,i[4]=0,i[5]=d,i[6]=0,i[7]=0,i[8]=0,i[9]=0,i[10]=y,i[11]=0,i[12]=m,i[13]=E,i[14]=O,i[15]=1,i},f.computeView=function(t,n,o,i,a){return r.typeOf.object("position",t),r.typeOf.object("direction",n),r.typeOf.object("up",o),r.typeOf.object("right",i),r.typeOf.object("result",a),a[0]=i.x,a[1]=o.x,a[2]=-n.x,a[3]=0,a[4]=i.y,a[5]=o.y,a[6]=-n.y,a[7]=0,a[8]=i.z,a[9]=o.z,a[10]=-n.z,a[11]=0,a[12]=-e.dot(i,t),a[13]=-e.dot(o,t),a[14]=e.dot(n,t),a[15]=1,a},f.toArray=function(e,t){return r.typeOf.object("matrix",e),o(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15]]},f.getElementIndex=function(e,t){return r.typeOf.number.greaterThanOrEquals("row",t,0),r.typeOf.number.lessThanOrEquals("row",t,3),r.typeOf.number.greaterThanOrEquals("column",e,0),r.typeOf.number.lessThanOrEquals("column",e,3),4*e+t},f.getColumn=function(e,t,n){r.typeOf.object("matrix",e),r.typeOf.number.greaterThanOrEquals("index",t,0),r.typeOf.number.lessThanOrEquals("index",t,3),r.typeOf.object("result",n);var o=4*t,i=e[o],a=e[o+1],s=e[o+2],u=e[o+3];return n.x=i,n.y=a,n.z=s,n.w=u,n},f.setColumn=function(e,t,n,o){r.typeOf.object("matrix",e),r.typeOf.number.greaterThanOrEquals("index",t,0),r.typeOf.number.lessThanOrEquals("index",t,3),r.typeOf.object("cartesian",n),r.typeOf.object("result",o);var i=4*t;return(o=f.clone(e,o))[i]=n.x,o[i+1]=n.y,o[i+2]=n.z,o[i+3]=n.w,o},f.setTranslation=function(e,t,n){return r.typeOf.object("matrix",e),r.typeOf.object("translation",t),r.typeOf.object("result",n),n[0]=e[0],n[1]=e[1],n[2]=e[2],n[3]=e[3],n[4]=e[4],n[5]=e[5],n[6]=e[6],n[7]=e[7],n[8]=e[8],n[9]=e[9],n[10]=e[10],n[11]=e[11],n[12]=t.x,n[13]=t.y,n[14]=t.z,n[15]=e[15],n};var d=new e;f.setScale=function(t,n,o){r.typeOf.object("matrix",t),r.typeOf.object("scale",n),r.typeOf.object("result",o);var i=f.getScale(t,d),a=e.divideComponents(n,i,d);return f.multiplyByScale(t,a,o)},f.getRow=function(e,t,n){r.typeOf.object("matrix",e),r.typeOf.number.greaterThanOrEquals("index",t,0),r.typeOf.number.lessThanOrEquals("index",t,3),r.typeOf.object("result",n);var o=e[t],i=e[t+4],a=e[t+8],s=e[t+12];return n.x=o,n.y=i,n.z=a,n.w=s,n},f.setRow=function(e,t,n,o){return r.typeOf.object("matrix",e),r.typeOf.number.greaterThanOrEquals("index",t,0),r.typeOf.number.lessThanOrEquals("index",t,3),r.typeOf.object("cartesian",n),r.typeOf.object("result",o),(o=f.clone(e,o))[t]=n.x,o[t+4]=n.y,o[t+8]=n.z,o[t+12]=n.w,o};var y=new e;f.getScale=function(t,n){return r.typeOf.object("matrix",t),r.typeOf.object("result",n),n.x=e.magnitude(e.fromElements(t[0],t[1],t[2],y)),n.y=e.magnitude(e.fromElements(t[4],t[5],t[6],y)),n.z=e.magnitude(e.fromElements(t[8],t[9],t[10],y)),n};var m=new e;f.getMaximumScale=function(t){return f.getScale(t,m),e.maximumComponent(m)},f.multiply=function(e,t,n){r.typeOf.object("left",e),r.typeOf.object("right",t),r.typeOf.object("result",n);var o=e[0],i=e[1],a=e[2],s=e[3],u=e[4],c=e[5],f=e[6],l=e[7],h=e[8],p=e[9],d=e[10],y=e[11],m=e[12],E=e[13],O=e[14],_=e[15],T=t[0],R=t[1],w=t[2],g=t[3],A=t[4],S=t[5],b=t[6],C=t[7],v=t[8],N=t[9],I=t[10],M=t[11],x=t[12],P=t[13],D=t[14],F=t[15],U=o*T+u*R+h*w+m*g,L=i*T+c*R+p*w+E*g,q=a*T+f*R+d*w+O*g,B=s*T+l*R+y*w+_*g,j=o*A+u*S+h*b+m*C,z=i*A+c*S+p*b+E*C,G=a*A+f*S+d*b+O*C,V=s*A+l*S+y*b+_*C,H=o*v+u*N+h*I+m*M,W=i*v+c*N+p*I+E*M,X=a*v+f*N+d*I+O*M,Y=s*v+l*N+y*I+_*M,k=o*x+u*P+h*D+m*F,K=i*x+c*P+p*D+E*F,Z=a*x+f*P+d*D+O*F,Q=s*x+l*P+y*D+_*F;return n[0]=U,n[1]=L,n[2]=q,n[3]=B,n[4]=j,n[5]=z,n[6]=G,n[7]=V,n[8]=H,n[9]=W,n[10]=X,n[11]=Y,n[12]=k,n[13]=K,n[14]=Z,n[15]=Q,n},f.add=function(e,t,n){return r.typeOf.object("left",e),r.typeOf.object("right",t),r.typeOf.object("result",n),n[0]=e[0]+t[0],n[1]=e[1]+t[1],n[2]=e[2]+t[2],n[3]=e[3]+t[3],n[4]=e[4]+t[4],n[5]=e[5]+t[5],n[6]=e[6]+t[6],n[7]=e[7]+t[7],n[8]=e[8]+t[8],n[9]=e[9]+t[9],n[10]=e[10]+t[10],n[11]=e[11]+t[11],n[12]=e[12]+t[12],n[13]=e[13]+t[13],n[14]=e[14]+t[14],n[15]=e[15]+t[15],n},f.subtract=function(e,t,n){return r.typeOf.object("left",e),r.typeOf.object("right",t),r.typeOf.object("result",n),n[0]=e[0]-t[0],n[1]=e[1]-t[1],n[2]=e[2]-t[2],n[3]=e[3]-t[3],n[4]=e[4]-t[4],n[5]=e[5]-t[5],n[6]=e[6]-t[6],n[7]=e[7]-t[7],n[8]=e[8]-t[8],n[9]=e[9]-t[9],n[10]=e[10]-t[10],n[11]=e[11]-t[11],n[12]=e[12]-t[12],n[13]=e[13]-t[13],n[14]=e[14]-t[14],n[15]=e[15]-t[15],n},f.multiplyTransformation=function(e,t,n){r.typeOf.object("left",e),r.typeOf.object("right",t),r.typeOf.object("result",n);var o=e[0],i=e[1],a=e[2],s=e[4],u=e[5],c=e[6],f=e[8],l=e[9],h=e[10],p=e[12],d=e[13],y=e[14],m=t[0],E=t[1],O=t[2],_=t[4],T=t[5],R=t[6],w=t[8],g=t[9],A=t[10],S=t[12],b=t[13],C=t[14],v=o*m+s*E+f*O,N=i*m+u*E+l*O,I=a*m+c*E+h*O,M=o*_+s*T+f*R,x=i*_+u*T+l*R,P=a*_+c*T+h*R,D=o*w+s*g+f*A,F=i*w+u*g+l*A,U=a*w+c*g+h*A,L=o*S+s*b+f*C+p,q=i*S+u*b+l*C+d,B=a*S+c*b+h*C+y;return n[0]=v,n[1]=N,n[2]=I,n[3]=0,n[4]=M,n[5]=x,n[6]=P,n[7]=0,n[8]=D,n[9]=F,n[10]=U,n[11]=0,n[12]=L,n[13]=q,n[14]=B,n[15]=1,n},f.multiplyByMatrix3=function(e,t,n){r.typeOf.object("matrix",e),r.typeOf.object("rotation",t),r.typeOf.object("result",n);var o=e[0],i=e[1],a=e[2],s=e[4],u=e[5],c=e[6],f=e[8],l=e[9],h=e[10],p=t[0],d=t[1],y=t[2],m=t[3],E=t[4],O=t[5],_=t[6],T=t[7],R=t[8],w=o*p+s*d+f*y,g=i*p+u*d+l*y,A=a*p+c*d+h*y,S=o*m+s*E+f*O,b=i*m+u*E+l*O,C=a*m+c*E+h*O,v=o*_+s*T+f*R,N=i*_+u*T+l*R,I=a*_+c*T+h*R;return n[0]=w,n[1]=g,n[2]=A,n[3]=0,n[4]=S,n[5]=b,n[6]=C,n[7]=0,n[8]=v,n[9]=N,n[10]=I,n[11]=0,n[12]=e[12],n[13]=e[13],n[14]=e[14],n[15]=e[15],n},f.multiplyByTranslation=function(e,t,n){r.typeOf.object("matrix",e),r.typeOf.object("translation",t),r.typeOf.object("result",n);var o=t.x,i=t.y,a=t.z,s=o*e[0]+i*e[4]+a*e[8]+e[12],u=o*e[1]+i*e[5]+a*e[9]+e[13],c=o*e[2]+i*e[6]+a*e[10]+e[14];return n[0]=e[0],n[1]=e[1],n[2]=e[2],n[3]=e[3],n[4]=e[4],n[5]=e[5],n[6]=e[6],n[7]=e[7],n[8]=e[8],n[9]=e[9],n[10]=e[10],n[11]=e[11],n[12]=s,n[13]=u,n[14]=c,n[15]=e[15],n};var E=new e;f.multiplyByUniformScale=function(e,t,n){return r.typeOf.object("matrix",e),r.typeOf.number("scale",t),r.typeOf.object("result",n),E.x=t,E.y=t,E.z=t,f.multiplyByScale(e,E,n)},f.multiplyByScale=function(e,t,n){r.typeOf.object("matrix",e),r.typeOf.object("scale",t),r.typeOf.object("result",n);var o=t.x,i=t.y,a=t.z;return 1===o&&1===i&&1===a?f.clone(e,n):(n[0]=o*e[0],n[1]=o*e[1],n[2]=o*e[2],n[3]=0,n[4]=i*e[4],n[5]=i*e[5],n[6]=i*e[6],n[7]=0,n[8]=a*e[8],n[9]=a*e[9],n[10]=a*e[10],n[11]=0,n[12]=e[12],n[13]=e[13],n[14]=e[14],n[15]=1,n)},f.multiplyByVector=function(e,t,n){r.typeOf.object("matrix",e),r.typeOf.object("cartesian",t),r.typeOf.object("result",n);var o=t.x,i=t.y,a=t.z,s=t.w,u=e[0]*o+e[4]*i+e[8]*a+e[12]*s,c=e[1]*o+e[5]*i+e[9]*a+e[13]*s,f=e[2]*o+e[6]*i+e[10]*a+e[14]*s,l=e[3]*o+e[7]*i+e[11]*a+e[15]*s;return n.x=u,n.y=c,n.z=f,n.w=l,n},f.multiplyByPointAsVector=function(e,t,n){r.typeOf.object("matrix",e),r.typeOf.object("cartesian",t),r.typeOf.object("result",n);var o=t.x,i=t.y,a=t.z,s=e[0]*o+e[4]*i+e[8]*a,u=e[1]*o+e[5]*i+e[9]*a,c=e[2]*o+e[6]*i+e[10]*a;return n.x=s,n.y=u,n.z=c,n},f.multiplyByPoint=function(e,t,n){r.typeOf.object("matrix",e),r.typeOf.object("cartesian",t),r.typeOf.object("result",n);var o=t.x,i=t.y,a=t.z,s=e[0]*o+e[4]*i+e[8]*a+e[12],u=e[1]*o+e[5]*i+e[9]*a+e[13],c=e[2]*o+e[6]*i+e[10]*a+e[14];return n.x=s,n.y=u,n.z=c,n},f.multiplyByScalar=function(e,t,n){return r.typeOf.object("matrix",e),r.typeOf.number("scalar",t),r.typeOf.object("result",n),n[0]=e[0]*t,n[1]=e[1]*t,n[2]=e[2]*t,n[3]=e[3]*t,n[4]=e[4]*t,n[5]=e[5]*t,n[6]=e[6]*t,n[7]=e[7]*t,n[8]=e[8]*t,n[9]=e[9]*t,n[10]=e[10]*t,n[11]=e[11]*t,n[12]=e[12]*t,n[13]=e[13]*t,n[14]=e[14]*t,n[15]=e[15]*t,n},f.negate=function(e,t){return r.typeOf.object("matrix",e),r.typeOf.object("result",t),t[0]=-e[0],t[1]=-e[1],t[2]=-e[2],t[3]=-e[3],t[4]=-e[4],t[5]=-e[5],t[6]=-e[6],t[7]=-e[7],t[8]=-e[8],t[9]=-e[9],t[10]=-e[10],t[11]=-e[11],t[12]=-e[12],t[13]=-e[13],t[14]=-e[14],t[15]=-e[15],t},f.transpose=function(e,t){r.typeOf.object("matrix",e),r.typeOf.object("result",t);var n=e[1],o=e[2],i=e[3],a=e[6],s=e[7],u=e[11];return t[0]=e[0],t[1]=e[4],t[2]=e[8],t[3]=e[12],t[4]=n,t[5]=e[5],t[6]=e[9],t[7]=e[13],t[8]=o,t[9]=a,t[10]=e[10],t[11]=e[14],t[12]=i,t[13]=s,t[14]=u,t[15]=e[15],t},f.abs=function(e,t){return r.typeOf.object("matrix",e),r.typeOf.object("result",t),t[0]=Math.abs(e[0]),t[1]=Math.abs(e[1]),t[2]=Math.abs(e[2]),t[3]=Math.abs(e[3]),t[4]=Math.abs(e[4]),t[5]=Math.abs(e[5]),t[6]=Math.abs(e[6]),t[7]=Math.abs(e[7]),t[8]=Math.abs(e[8]),t[9]=Math.abs(e[9]),t[10]=Math.abs(e[10]),t[11]=Math.abs(e[11]),t[12]=Math.abs(e[12]),t[13]=Math.abs(e[13]),t[14]=Math.abs(e[14]),t[15]=Math.abs(e[15]),t},f.equals=function(e,t){return e===t||o(e)&&o(t)&&e[12]===t[12]&&e[13]===t[13]&&e[14]===t[14]&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[4]===t[4]&&e[5]===t[5]&&e[6]===t[6]&&e[8]===t[8]&&e[9]===t[9]&&e[10]===t[10]&&e[3]===t[3]&&e[7]===t[7]&&e[11]===t[11]&&e[15]===t[15]},f.equalsEpsilon=function(e,t,n){return r.typeOf.number("epsilon",n),e===t||o(e)&&o(t)&&Math.abs(e[0]-t[0])<=n&&Math.abs(e[1]-t[1])<=n&&Math.abs(e[2]-t[2])<=n&&Math.abs(e[3]-t[3])<=n&&Math.abs(e[4]-t[4])<=n&&Math.abs(e[5]-t[5])<=n&&Math.abs(e[6]-t[6])<=n&&Math.abs(e[7]-t[7])<=n&&Math.abs(e[8]-t[8])<=n&&Math.abs(e[9]-t[9])<=n&&Math.abs(e[10]-t[10])<=n&&Math.abs(e[11]-t[11])<=n&&Math.abs(e[12]-t[12])<=n&&Math.abs(e[13]-t[13])<=n&&Math.abs(e[14]-t[14])<=n&&Math.abs(e[15]-t[15])<=n},f.getTranslation=function(e,t){return r.typeOf.object("matrix",e),r.typeOf.object("result",t),t.x=e[12],t.y=e[13],t.z=e[14],t},f.getRotation=function(e,t){return r.typeOf.object("matrix",e),r.typeOf.object("result",t),t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[4],t[4]=e[5],t[5]=e[6],t[6]=e[8],t[7]=e[9],t[8]=e[10],t};var O=new u,_=new u,T=new t,R=new t(0,0,0,1);return f.inverse=function(e,n){r.typeOf.object("matrix",e),r.typeOf.object("result",n);var o=e[0],i=e[4],a=e[8],l=e[12],h=e[1],p=e[5],d=e[9],y=e[13],m=e[2],E=e[6],w=e[10],g=e[14],A=e[3],S=e[7],b=e[11],C=e[15],v=w*C,N=g*b,I=E*C,M=g*S,x=E*b,P=w*S,D=m*C,F=g*A,U=m*b,L=w*A,q=m*S,B=E*A,j=v*p+M*d+x*y-(N*p+I*d+P*y),z=N*h+D*d+L*y-(v*h+F*d+U*y),G=I*h+F*p+q*y-(M*h+D*p+B*y),V=P*h+U*p+B*d-(x*h+L*p+q*d),H=N*i+I*a+P*l-(v*i+M*a+x*l),W=v*o+F*a+U*l-(N*o+D*a+L*l),X=M*o+D*i+B*l-(I*o+F*i+q*l),Y=x*o+L*i+q*a-(P*o+U*i+B*a),k=(v=a*y)*S+(M=l*p)*b+(x=i*d)*C-((N=l*d)*S+(I=i*y)*b+(P=a*p)*C),K=N*A+(D=o*y)*b+(L=a*h)*C-(v*A+(F=l*h)*b+(U=o*d)*C),Z=I*A+F*S+(q=o*p)*C-(M*A+D*S+(B=i*h)*C),Q=P*A+U*S+B*b-(x*A+L*S+q*b),J=I*w+P*g+N*E-(x*g+v*E+M*w),$=U*g+v*m+F*w-(D*w+L*g+N*m),ee=D*E+B*g+M*m-(q*g+I*m+F*E),te=q*w+x*m+L*E-(U*E+B*w+P*m),re=o*j+i*z+a*G+l*V;if(Math.abs(re)<s.EPSILON21){if(u.equalsEpsilon(f.getRotation(e,O),_,s.EPSILON7)&&t.equals(f.getRow(e,3,T),R))return n[0]=0,n[1]=0,n[2]=0,n[3]=0,n[4]=0,n[5]=0,n[6]=0,n[7]=0,n[8]=0,n[9]=0,n[10]=0,n[11]=0,n[12]=-e[12],n[13]=-e[13],n[14]=-e[14],n[15]=1,n;throw new c("matrix is not invertible because its determinate is zero.")}return re=1/re,n[0]=j*re,n[1]=z*re,n[2]=G*re,n[3]=V*re,n[4]=H*re,n[5]=W*re,n[6]=X*re,n[7]=Y*re,n[8]=k*re,n[9]=K*re,n[10]=Z*re,n[11]=Q*re,n[12]=J*re,n[13]=$*re,n[14]=ee*re,n[15]=te*re,n},f.inverseTransformation=function(e,t){r.typeOf.object("matrix",e),r.typeOf.object("result",t);var n=e[0],o=e[1],i=e[2],a=e[4],s=e[5],u=e[6],c=e[8],f=e[9],l=e[10],h=e[12],p=e[13],d=e[14],y=-n*h-o*p-i*d,m=-a*h-s*p-u*d,E=-c*h-f*p-l*d;return t[0]=n,t[1]=a,t[2]=c,t[3]=0,t[4]=o,t[5]=s,t[6]=f,t[7]=0,t[8]=i,t[9]=u,t[10]=l,t[11]=0,t[12]=y,t[13]=m,t[14]=E,t[15]=1,t},f.IDENTITY=a(new f(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1)),f.ZERO=a(new f(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0)),f.COLUMN0ROW0=0,f.COLUMN0ROW1=1,f.COLUMN0ROW2=2,f.COLUMN0ROW3=3,f.COLUMN1ROW0=4,f.COLUMN1ROW1=5,f.COLUMN1ROW2=6,f.COLUMN1ROW3=7,f.COLUMN2ROW0=8,f.COLUMN2ROW1=9,f.COLUMN2ROW2=10,f.COLUMN2ROW3=11,f.COLUMN3ROW0=12,f.COLUMN3ROW1=13,f.COLUMN3ROW2=14,f.COLUMN3ROW3=15,i(f.prototype,{length:{get:function(){return f.packedLength}}}),f.prototype.clone=function(e){return f.clone(this,e)},f.prototype.equals=function(e){return f.equals(this,e)},f.equalsArray=function(e,t,r){return e[0]===t[r]&&e[1]===t[r+1]&&e[2]===t[r+2]&&e[3]===t[r+3]&&e[4]===t[r+4]&&e[5]===t[r+5]&&e[6]===t[r+6]&&e[7]===t[r+7]&&e[8]===t[r+8]&&e[9]===t[r+9]&&e[10]===t[r+10]&&e[11]===t[r+11]&&e[12]===t[r+12]&&e[13]===t[r+13]&&e[14]===t[r+14]&&e[15]===t[r+15]},f.prototype.equalsEpsilon=function(e,t){return f.equalsEpsilon(this,e,t)},f.prototype.toString=function(){return"("+this[0]+", "+this[4]+", "+this[8]+", "+this[12]+")\n("+this[1]+", "+this[5]+", "+this[9]+", "+this[13]+")\n("+this[2]+", "+this[6]+", "+this[10]+", "+this[14]+")\n("+this[3]+", "+this[7]+", "+this[11]+", "+this[15]+")"},f})),define("Core/Rectangle",["./Cartographic","./Check","./defaultValue","./defined","./defineProperties","./Ellipsoid","./freezeObject","./Math"],(function(e,t,r,n,o,i,a,s){"use strict";function u(e,t,n,o){this.west=r(e,0),this.south=r(t,0),this.east=r(n,0),this.north=r(o,0)}o(u.prototype,{width:{get:function(){return u.computeWidth(this)}},height:{get:function(){return u.computeHeight(this)}}}),u.packedLength=4,u.pack=function(e,n,o){return t.typeOf.object("value",e),t.defined("array",n),o=r(o,0),n[o++]=e.west,n[o++]=e.south,n[o++]=e.east,n[o]=e.north,n},u.unpack=function(e,o,i){return t.defined("array",e),o=r(o,0),n(i)||(i=new u),i.west=e[o++],i.south=e[o++],i.east=e[o++],i.north=e[o],i},u.computeWidth=function(e){t.typeOf.object("rectangle",e);var r=e.east,n=e.west;return r<n&&(r+=s.TWO_PI),r-n},u.computeHeight=function(e){return t.typeOf.object("rectangle",e),e.north-e.south},u.fromDegrees=function(e,t,o,i,a){return e=s.toRadians(r(e,0)),t=s.toRadians(r(t,0)),o=s.toRadians(r(o,0)),i=s.toRadians(r(i,0)),n(a)?(a.west=e,a.south=t,a.east=o,a.north=i,a):new u(e,t,o,i)},u.fromRadians=function(e,t,o,i,a){return n(a)?(a.west=r(e,0),a.south=r(t,0),a.east=r(o,0),a.north=r(i,0),a):new u(e,t,o,i)},u.fromCartographicArray=function(e,r){t.defined("cartographics",e);for(var o=Number.MAX_VALUE,i=-Number.MAX_VALUE,a=Number.MAX_VALUE,c=-Number.MAX_VALUE,f=Number.MAX_VALUE,l=-Number.MAX_VALUE,h=0,p=e.length;h<p;h++){var d=e[h];o=Math.min(o,d.longitude),i=Math.max(i,d.longitude),f=Math.min(f,d.latitude),l=Math.max(l,d.latitude);var y=d.longitude>=0?d.longitude:d.longitude+s.TWO_PI;a=Math.min(a,y),c=Math.max(c,y)}return i-o>c-a&&(o=a,(i=c)>s.PI&&(i-=s.TWO_PI),o>s.PI&&(o-=s.TWO_PI)),n(r)?(r.west=o,r.south=f,r.east=i,r.north=l,r):new u(o,f,i,l)},u.fromCartesianArray=function(e,o,a){t.defined("cartesians",e),o=r(o,i.WGS84);for(var c=Number.MAX_VALUE,f=-Number.MAX_VALUE,l=Number.MAX_VALUE,h=-Number.MAX_VALUE,p=Number.MAX_VALUE,d=-Number.MAX_VALUE,y=0,m=e.length;y<m;y++){var E=o.cartesianToCartographic(e[y]);c=Math.min(c,E.longitude),f=Math.max(f,E.longitude),p=Math.min(p,E.latitude),d=Math.max(d,E.latitude);var O=E.longitude>=0?E.longitude:E.longitude+s.TWO_PI;l=Math.min(l,O),h=Math.max(h,O)}return f-c>h-l&&(c=l,(f=h)>s.PI&&(f-=s.TWO_PI),c>s.PI&&(c-=s.TWO_PI)),n(a)?(a.west=c,a.south=p,a.east=f,a.north=d,a):new u(c,p,f,d)},u.clone=function(e,t){if(n(e))return n(t)?(t.west=e.west,t.south=e.south,t.east=e.east,t.north=e.north,t):new u(e.west,e.south,e.east,e.north)},u.equalsEpsilon=function(e,r,o){return t.typeOf.number("absoluteEpsilon",o),e===r||n(e)&&n(r)&&Math.abs(e.west-r.west)<=o&&Math.abs(e.south-r.south)<=o&&Math.abs(e.east-r.east)<=o&&Math.abs(e.north-r.north)<=o},u.prototype.clone=function(e){return u.clone(this,e)},u.prototype.equals=function(e){return u.equals(this,e)},u.equals=function(e,t){return e===t||n(e)&&n(t)&&e.west===t.west&&e.south===t.south&&e.east===t.east&&e.north===t.north},u.prototype.equalsEpsilon=function(e,r){return t.typeOf.number("epsilon",r),u.equalsEpsilon(this,e,r)},u.validate=function(e){t.typeOf.object("rectangle",e);var r=e.north;t.typeOf.number.greaterThanOrEquals("north",r,-s.PI_OVER_TWO),t.typeOf.number.lessThanOrEquals("north",r,s.PI_OVER_TWO);var n=e.south;t.typeOf.number.greaterThanOrEquals("south",n,-s.PI_OVER_TWO),t.typeOf.number.lessThanOrEquals("south",n,s.PI_OVER_TWO);var o=e.west;t.typeOf.number.greaterThanOrEquals("west",o,-Math.PI),t.typeOf.number.lessThanOrEquals("west",o,Math.PI);var i=e.east;t.typeOf.number.greaterThanOrEquals("east",i,-Math.PI),t.typeOf.number.lessThanOrEquals("east",i,Math.PI)},u.southwest=function(r,o){return t.typeOf.object("rectangle",r),n(o)?(o.longitude=r.west,o.latitude=r.south,o.height=0,o):new e(r.west,r.south)},u.northwest=function(r,o){return t.typeOf.object("rectangle",r),n(o)?(o.longitude=r.west,o.latitude=r.north,o.height=0,o):new e(r.west,r.north)},u.northeast=function(r,o){return t.typeOf.object("rectangle",r),n(o)?(o.longitude=r.east,o.latitude=r.north,o.height=0,o):new e(r.east,r.north)},u.southeast=function(r,o){return t.typeOf.object("rectangle",r),n(o)?(o.longitude=r.east,o.latitude=r.south,o.height=0,o):new e(r.east,r.south)},u.center=function(r,o){t.typeOf.object("rectangle",r);var i=r.east,a=r.west;i<a&&(i+=s.TWO_PI);var u=s.negativePiToPi(.5*(a+i)),c=.5*(r.south+r.north);return n(o)?(o.longitude=u,o.latitude=c,o.height=0,o):new e(u,c)},u.intersection=function(e,r,o){t.typeOf.object("rectangle",e),t.typeOf.object("otherRectangle",r);var i=e.east,a=e.west,c=r.east,f=r.west;i<a&&c>0?i+=s.TWO_PI:c<f&&i>0&&(c+=s.TWO_PI),i<a&&f<0?f+=s.TWO_PI:c<f&&a<0&&(a+=s.TWO_PI);var l=s.negativePiToPi(Math.max(a,f)),h=s.negativePiToPi(Math.min(i,c));if(!((e.west<e.east||r.west<r.east)&&h<=l)){var p=Math.max(e.south,r.south),d=Math.min(e.north,r.north);if(!(p>=d))return n(o)?(o.west=l,o.south=p,o.east=h,o.north=d,o):new u(l,p,h,d)}},u.simpleIntersection=function(e,r,o){t.typeOf.object("rectangle",e),t.typeOf.object("otherRectangle",r);var i=Math.max(e.west,r.west),a=Math.max(e.south,r.south),s=Math.min(e.east,r.east),c=Math.min(e.north,r.north);if(!(a>=c||i>=s))return n(o)?(o.west=i,o.south=a,o.east=s,o.north=c,o):new u(i,a,s,c)},u.union=function(e,r,o){t.typeOf.object("rectangle",e),t.typeOf.object("otherRectangle",r),n(o)||(o=new u);var i=e.east,a=e.west,c=r.east,f=r.west;i<a&&c>0?i+=s.TWO_PI:c<f&&i>0&&(c+=s.TWO_PI),i<a&&f<0?f+=s.TWO_PI:c<f&&a<0&&(a+=s.TWO_PI);var l=s.convertLongitudeRange(Math.min(a,f)),h=s.convertLongitudeRange(Math.max(i,c));return o.west=l,o.south=Math.min(e.south,r.south),o.east=h,o.north=Math.max(e.north,r.north),o},u.expand=function(e,r,o){return t.typeOf.object("rectangle",e),t.typeOf.object("cartographic",r),n(o)||(o=new u),o.west=Math.min(e.west,r.longitude),o.south=Math.min(e.south,r.latitude),o.east=Math.max(e.east,r.longitude),o.north=Math.max(e.north,r.latitude),o},u.contains=function(e,r){t.typeOf.object("rectangle",e),t.typeOf.object("cartographic",r);var n=r.longitude,o=r.latitude,i=e.west,a=e.east;return a<i&&(a+=s.TWO_PI,n<0&&(n+=s.TWO_PI)),(n>i||s.equalsEpsilon(n,i,s.EPSILON14))&&(n<a||s.equalsEpsilon(n,a,s.EPSILON14))&&o>=e.south&&o<=e.north};var c=new e;return u.subsample=function(e,o,a,f){t.typeOf.object("rectangle",e),o=r(o,i.WGS84),a=r(a,0),n(f)||(f=[]);var l=0,h=e.north,p=e.south,d=e.east,y=e.west,m=c;m.height=a,m.longitude=y,m.latitude=h,f[l]=o.cartographicToCartesian(m,f[l]),l++,m.longitude=d,f[l]=o.cartographicToCartesian(m,f[l]),l++,m.latitude=p,f[l]=o.cartographicToCartesian(m,f[l]),l++,m.longitude=y,f[l]=o.cartographicToCartesian(m,f[l]),l++,m.latitude=h<0?h:p>0?p:0;for(var E=1;E<8;++E)m.longitude=-Math.PI+E*s.PI_OVER_TWO,u.contains(e,m)&&(f[l]=o.cartographicToCartesian(m,f[l]),l++);return 0===m.latitude&&(m.longitude=y,f[l]=o.cartographicToCartesian(m,f[l]),l++,m.longitude=d,f[l]=o.cartographicToCartesian(m,f[l]),l++),f.length=l,f},u.MAX_VALUE=a(new u(-Math.PI,-s.PI_OVER_TWO,Math.PI,s.PI_OVER_TWO)),u})),define("Core/BoundingSphere",["./Cartesian3","./Cartographic","./Check","./defaultValue","./defined","./Ellipsoid","./GeographicProjection","./Intersect","./Interval","./Math","./Matrix3","./Matrix4","./Rectangle"],(function(e,t,r,n,o,i,a,s,u,c,f,l,h){"use strict";function p(t,r){this.center=e.clone(n(t,e.ZERO)),this.radius=n(r,0)}var d=new e,y=new e,m=new e,E=new e,O=new e,_=new e,T=new e,R=new e,w=new e,g=new e,A=new e,S=new e,b=4/3*c.PI;p.fromPoints=function(t,r){if(o(r)||(r=new p),!o(t)||0===t.length)return r.center=e.clone(e.ZERO,r.center),r.radius=0,r;var n,i=e.clone(t[0],T),a=e.clone(i,d),s=e.clone(i,y),u=e.clone(i,m),c=e.clone(i,E),f=e.clone(i,O),l=e.clone(i,_),h=t.length;for(n=1;n<h;n++){e.clone(t[n],i);var b=i.x,C=i.y,v=i.z;b<a.x&&e.clone(i,a),b>c.x&&e.clone(i,c),C<s.y&&e.clone(i,s),C>f.y&&e.clone(i,f),v<u.z&&e.clone(i,u),v>l.z&&e.clone(i,l)}var N=e.magnitudeSquared(e.subtract(c,a,R)),I=e.magnitudeSquared(e.subtract(f,s,R)),M=e.magnitudeSquared(e.subtract(l,u,R)),x=a,P=c,D=N;I>D&&(D=I,x=s,P=f),M>D&&(D=M,x=u,P=l);var F=w;F.x=.5*(x.x+P.x),F.y=.5*(x.y+P.y),F.z=.5*(x.z+P.z);var U=e.magnitudeSquared(e.subtract(P,F,R)),L=Math.sqrt(U),q=g;q.x=a.x,q.y=s.y,q.z=u.z;var B=A;B.x=c.x,B.y=f.y,B.z=l.z;var j=e.midpoint(q,B,S),z=0;for(n=0;n<h;n++){e.clone(t[n],i);var G=e.magnitude(e.subtract(i,j,R));G>z&&(z=G);var V=e.magnitudeSquared(e.subtract(i,F,R));if(V>U){var H=Math.sqrt(V);U=(L=.5*(L+H))*L;var W=H-L;F.x=(L*F.x+W*i.x)/H,F.y=(L*F.y+W*i.y)/H,F.z=(L*F.z+W*i.z)/H}}return L<z?(e.clone(F,r.center),r.radius=L):(e.clone(j,r.center),r.radius=z),r};var C=new a,v=new e,N=new e,I=new t,M=new t;p.fromRectangle2D=function(e,t,r){return p.fromRectangleWithHeights2D(e,t,0,0,r)},p.fromRectangleWithHeights2D=function(t,r,i,a,s){if(o(s)||(s=new p),!o(t))return s.center=e.clone(e.ZERO,s.center),s.radius=0,s;r=n(r,C),h.southwest(t,I),I.height=i,h.northeast(t,M),M.height=a;var u=r.project(I,v),c=r.project(M,N),f=c.x-u.x,l=c.y-u.y,d=c.z-u.z;s.radius=.5*Math.sqrt(f*f+l*l+d*d);var y=s.center;return y.x=u.x+.5*f,y.y=u.y+.5*l,y.z=u.z+.5*d,s};var x=[];p.fromRectangle3D=function(t,r,a,s){if(r=n(r,i.WGS84),a=n(a,0),o(s)||(s=new p),!o(t))return s.center=e.clone(e.ZERO,s.center),s.radius=0,s;var u=h.subsample(t,r,a,x);return p.fromPoints(u,s)},p.fromVertices=function(t,i,a,s){if(o(s)||(s=new p),!o(t)||0===t.length)return s.center=e.clone(e.ZERO,s.center),s.radius=0,s;i=n(i,e.ZERO),a=n(a,3),r.typeOf.number.greaterThanOrEquals("stride",a,3);var u=T;u.x=t[0]+i.x,u.y=t[1]+i.y,u.z=t[2]+i.z;var c,f=e.clone(u,d),l=e.clone(u,y),h=e.clone(u,m),b=e.clone(u,E),C=e.clone(u,O),v=e.clone(u,_),N=t.length;for(c=0;c<N;c+=a){var I=t[c]+i.x,M=t[c+1]+i.y,x=t[c+2]+i.z;u.x=I,u.y=M,u.z=x,I<f.x&&e.clone(u,f),I>b.x&&e.clone(u,b),M<l.y&&e.clone(u,l),M>C.y&&e.clone(u,C),x<h.z&&e.clone(u,h),x>v.z&&e.clone(u,v)}var P=e.magnitudeSquared(e.subtract(b,f,R)),D=e.magnitudeSquared(e.subtract(C,l,R)),F=e.magnitudeSquared(e.subtract(v,h,R)),U=f,L=b,q=P;D>q&&(q=D,U=l,L=C),F>q&&(q=F,U=h,L=v);var B=w;B.x=.5*(U.x+L.x),B.y=.5*(U.y+L.y),B.z=.5*(U.z+L.z);var j=e.magnitudeSquared(e.subtract(L,B,R)),z=Math.sqrt(j),G=g;G.x=f.x,G.y=l.y,G.z=h.z;var V=A;V.x=b.x,V.y=C.y,V.z=v.z;var H=e.midpoint(G,V,S),W=0;for(c=0;c<N;c+=a){u.x=t[c]+i.x,u.y=t[c+1]+i.y,u.z=t[c+2]+i.z;var X=e.magnitude(e.subtract(u,H,R));X>W&&(W=X);var Y=e.magnitudeSquared(e.subtract(u,B,R));if(Y>j){var k=Math.sqrt(Y);j=(z=.5*(z+k))*z;var K=k-z;B.x=(z*B.x+K*u.x)/k,B.y=(z*B.y+K*u.y)/k,B.z=(z*B.z+K*u.z)/k}}return z<W?(e.clone(B,s.center),s.radius=z):(e.clone(H,s.center),s.radius=W),s},p.fromEncodedCartesianVertices=function(t,r,n){if(o(n)||(n=new p),!o(t)||!o(r)||t.length!==r.length||0===t.length)return n.center=e.clone(e.ZERO,n.center),n.radius=0,n;var i=T;i.x=t[0]+r[0],i.y=t[1]+r[1],i.z=t[2]+r[2];var a,s=e.clone(i,d),u=e.clone(i,y),c=e.clone(i,m),f=e.clone(i,E),l=e.clone(i,O),h=e.clone(i,_),b=t.length;for(a=0;a<b;a+=3){var C=t[a]+r[a],v=t[a+1]+r[a+1],N=t[a+2]+r[a+2];i.x=C,i.y=v,i.z=N,C<s.x&&e.clone(i,s),C>f.x&&e.clone(i,f),v<u.y&&e.clone(i,u),v>l.y&&e.clone(i,l),N<c.z&&e.clone(i,c),N>h.z&&e.clone(i,h)}var I=e.magnitudeSquared(e.subtract(f,s,R)),M=e.magnitudeSquared(e.subtract(l,u,R)),x=e.magnitudeSquared(e.subtract(h,c,R)),P=s,D=f,F=I;M>F&&(F=M,P=u,D=l),x>F&&(F=x,P=c,D=h);var U=w;U.x=.5*(P.x+D.x),U.y=.5*(P.y+D.y),U.z=.5*(P.z+D.z);var L=e.magnitudeSquared(e.subtract(D,U,R)),q=Math.sqrt(L),B=g;B.x=s.x,B.y=u.y,B.z=c.z;var j=A;j.x=f.x,j.y=l.y,j.z=h.z;var z=e.midpoint(B,j,S),G=0;for(a=0;a<b;a+=3){i.x=t[a]+r[a],i.y=t[a+1]+r[a+1],i.z=t[a+2]+r[a+2];var V=e.magnitude(e.subtract(i,z,R));V>G&&(G=V);var H=e.magnitudeSquared(e.subtract(i,U,R));if(H>L){var W=Math.sqrt(H);L=(q=.5*(q+W))*q;var X=W-q;U.x=(q*U.x+X*i.x)/W,U.y=(q*U.y+X*i.y)/W,U.z=(q*U.z+X*i.z)/W}}return q<G?(e.clone(U,n.center),n.radius=q):(e.clone(z,n.center),n.radius=G),n},p.fromCornerPoints=function(t,n,i){r.typeOf.object("corner",t),r.typeOf.object("oppositeCorner",n),o(i)||(i=new p);var a=e.midpoint(t,n,i.center);return i.radius=e.distance(a,n),i},p.fromEllipsoid=function(t,n){return r.typeOf.object("ellipsoid",t),o(n)||(n=new p),e.clone(e.ZERO,n.center),n.radius=t.maximumRadius,n};var P=new e;p.fromBoundingSpheres=function(t,r){if(o(r)||(r=new p),!o(t)||0===t.length)return r.center=e.clone(e.ZERO,r.center),r.radius=0,r;var n=t.length;if(1===n)return p.clone(t[0],r);if(2===n)return p.union(t[0],t[1],r);var i,a=[];for(i=0;i<n;i++)a.push(t[i].center);var s=(r=p.fromPoints(a,r)).center,u=r.radius;for(i=0;i<n;i++){var c=t[i];u=Math.max(u,e.distance(s,c.center,P)+c.radius)}return r.radius=u,r};var D=new e,F=new e,U=new e;p.fromOrientedBoundingBox=function(t,n){r.defined("orientedBoundingBox",t),o(n)||(n=new p);var i=t.halfAxes,a=f.getColumn(i,0,D),s=f.getColumn(i,1,F),u=f.getColumn(i,2,U);return e.add(a,s,a),e.add(a,u,a),n.center=e.clone(t.center,n.center),n.radius=e.magnitude(a),n},p.clone=function(t,r){if(o(t))return o(r)?(r.center=e.clone(t.center,r.center),r.radius=t.radius,r):new p(t.center,t.radius)},p.packedLength=4,p.pack=function(e,t,o){r.typeOf.object("value",e),r.defined("array",t),o=n(o,0);var i=e.center;return t[o++]=i.x,t[o++]=i.y,t[o++]=i.z,t[o]=e.radius,t},p.unpack=function(e,t,i){r.defined("array",e),t=n(t,0),o(i)||(i=new p);var a=i.center;return a.x=e[t++],a.y=e[t++],a.z=e[t++],i.radius=e[t],i};var L=new e,q=new e;p.union=function(t,n,i){r.typeOf.object("left",t),r.typeOf.object("right",n),o(i)||(i=new p);var a=t.center,s=t.radius,u=n.center,c=n.radius,f=e.subtract(u,a,L),l=e.magnitude(f);if(s>=l+c)return t.clone(i),i;if(c>=l+s)return n.clone(i),i;var h=.5*(s+l+c),d=e.multiplyByScalar(f,(-s+h)/l,q);return e.add(d,a,d),e.clone(d,i.center),i.radius=h,i};var B=new e;p.expand=function(t,n,o){r.typeOf.object("sphere",t),r.typeOf.object("point",n),o=p.clone(t,o);var i=e.magnitude(e.subtract(n,o.center,B));return i>o.radius&&(o.radius=i),o},p.intersectPlane=function(t,n){r.typeOf.object("sphere",t),r.typeOf.object("plane",n);var o=t.center,i=t.radius,a=n.normal,u=e.dot(a,o)+n.distance;return u<-i?s.OUTSIDE:u<i?s.INTERSECTING:s.INSIDE},p.transform=function(e,t,n){return r.typeOf.object("sphere",e),r.typeOf.object("transform",t),o(n)||(n=new p),n.center=l.multiplyByPoint(t,e.center,n.center),n.radius=l.getMaximumScale(t)*e.radius,n};var j=new e;p.distanceSquaredTo=function(t,n){r.typeOf.object("sphere",t),r.typeOf.object("cartesian",n);var o=e.subtract(t.center,n,j);return e.magnitudeSquared(o)-t.radius*t.radius},p.transformWithoutScale=function(e,t,n){return r.typeOf.object("sphere",e),r.typeOf.object("transform",t),o(n)||(n=new p),n.center=l.multiplyByPoint(t,e.center,n.center),n.radius=e.radius,n};var z=new e;p.computePlaneDistances=function(t,n,i,a){r.typeOf.object("sphere",t),r.typeOf.object("position",n),r.typeOf.object("direction",i),o(a)||(a=new u);var s=e.subtract(t.center,n,z),c=e.dot(i,s);return a.start=c-t.radius,a.stop=c+t.radius,a};for(var G=new e,V=new e,H=new e,W=new e,X=new e,Y=new t,k=new Array(8),K=0;K<8;++K)k[K]=new e;var Z=new a;return p.projectTo2D=function(t,o,i){r.typeOf.object("sphere",t);var a=(o=n(o,Z)).ellipsoid,s=t.center,u=t.radius,c=a.geodeticSurfaceNormal(s,G),f=e.cross(e.UNIT_Z,c,V);e.normalize(f,f);var l=e.cross(c,f,H);e.normalize(l,l),e.multiplyByScalar(c,u,c),e.multiplyByScalar(l,u,l),e.multiplyByScalar(f,u,f);var h=e.negate(l,X),d=e.negate(f,W),y=k,m=y[0];e.add(c,l,m),e.add(m,f,m),m=y[1],e.add(c,l,m),e.add(m,d,m),m=y[2],e.add(c,h,m),e.add(m,d,m),m=y[3],e.add(c,h,m),e.add(m,f,m),e.negate(c,c),m=y[4],e.add(c,l,m),e.add(m,f,m),m=y[5],e.add(c,l,m),e.add(m,d,m),m=y[6],e.add(c,h,m),e.add(m,d,m),m=y[7],e.add(c,h,m),e.add(m,f,m);for(var E=y.length,O=0;O<E;++O){var _=y[O];e.add(s,_,_);var T=a.cartesianToCartographic(_,Y);o.project(T,_)}var R=(s=(i=p.fromPoints(y,i)).center).x,w=s.y,g=s.z;return s.x=g,s.y=R,s.z=w,i},p.isOccluded=function(e,t){return r.typeOf.object("sphere",e),r.typeOf.object("occluder",t),!t.isBoundingSphereVisible(e)},p.equals=function(t,r){return t===r||o(t)&&o(r)&&e.equals(t.center,r.center)&&t.radius===r.radius},p.prototype.intersectPlane=function(e){return p.intersectPlane(this,e)},p.prototype.distanceSquaredTo=function(e){return p.distanceSquaredTo(this,e)},p.prototype.computePlaneDistances=function(e,t,r){return p.computePlaneDistances(this,e,t,r)},p.prototype.isOccluded=function(e){return p.isOccluded(this,e)},p.prototype.equals=function(e){return p.equals(this,e)},p.prototype.clone=function(e){return p.clone(this,e)},p.prototype.volume=function(){var e=this.radius;return b*e*e*e},p})),define("Core/Fullscreen",["./defined","./defineProperties"],(function(e,t){"use strict";var r,n={requestFullscreen:void 0,exitFullscreen:void 0,fullscreenEnabled:void 0,fullscreenElement:void 0,fullscreenchange:void 0,fullscreenerror:void 0},o={};return t(o,{element:{get:function(){if(o.supportsFullscreen())return document[n.fullscreenElement]}},changeEventName:{get:function(){if(o.supportsFullscreen())return n.fullscreenchange}},errorEventName:{get:function(){if(o.supportsFullscreen())return n.fullscreenerror}},enabled:{get:function(){if(o.supportsFullscreen())return document[n.fullscreenEnabled]}},fullscreen:{get:function(){if(o.supportsFullscreen())return null!==o.element}}}),o.supportsFullscreen=function(){if(e(r))return r;r=!1;var t=document.body;if("function"==typeof t.requestFullscreen)return n.requestFullscreen="requestFullscreen",n.exitFullscreen="exitFullscreen",n.fullscreenEnabled="fullscreenEnabled",n.fullscreenElement="fullscreenElement",n.fullscreenchange="fullscreenchange",n.fullscreenerror="fullscreenerror",r=!0;for(var o,i=["webkit","moz","o","ms","khtml"],a=0,s=i.length;a<s;++a){var u=i[a];("function"==typeof t[o=u+"RequestFullscreen"]||"function"==typeof t[o=u+"RequestFullScreen"])&&(n.requestFullscreen=o,r=!0),o=u+"ExitFullscreen","function"==typeof document[o]?n.exitFullscreen=o:(o=u+"CancelFullScreen","function"==typeof document[o]&&(n.exitFullscreen=o)),o=u+"FullscreenEnabled",void 0!==document[o]?n.fullscreenEnabled=o:(o=u+"FullScreenEnabled",void 0!==document[o]&&(n.fullscreenEnabled=o)),o=u+"FullscreenElement",void 0!==document[o]?n.fullscreenElement=o:(o=u+"FullScreenElement",void 0!==document[o]&&(n.fullscreenElement=o)),o=u+"fullscreenchange",void 0!==document["on"+o]&&("ms"===u&&(o="MSFullscreenChange"),n.fullscreenchange=o),o=u+"fullscreenerror",void 0!==document["on"+o]&&("ms"===u&&(o="MSFullscreenError"),n.fullscreenerror=o)}return r},o.requestFullscreen=function(e,t){o.supportsFullscreen()&&e[n.requestFullscreen]({vrDisplay:t})},o.exitFullscreen=function(){o.supportsFullscreen()&&document[n.exitFullscreen]()},o})),define("Core/FeatureDetection",["./defaultValue","./defined","./Fullscreen"],(function(e,t,r){"use strict";var n,o,i,a,s,u,c,f,l,h,p,d,y,m,E,O,_;function T(e){for(var t=e.split("."),r=0,n=t.length;r<n;++r)t[r]=parseInt(t[r],10);return t}function R(){if(!t(o)&&(o=!1,!S())){var e=/ Chrome\/([\.0-9]+)/.exec(n.userAgent);null!==e&&(o=!0,i=T(e[1]))}return o}function w(){if(!t(a)&&(a=!1,!R()&&!S()&&/ Safari\/[\.0-9]+/.test(n.userAgent))){var e=/ Version\/([\.0-9]+)/.exec(n.userAgent);null!==e&&(a=!0,s=T(e[1]))}return a}function g(){if(!t(u)){u=!1;var e=/ AppleWebKit\/([\.0-9]+)(\+?)/.exec(n.userAgent);null!==e&&(u=!0,(c=T(e[1])).isNightly=!!e[2])}return u}function A(){var e;return t(f)||(f=!1,"Microsoft Internet Explorer"===n.appName?null!==(e=/MSIE ([0-9]{1,}[\.0-9]{0,})/.exec(n.userAgent))&&(f=!0,l=T(e[1])):"Netscape"===n.appName&&null!==(e=/Trident\/.*rv:([0-9]{1,}[\.0-9]{0,})/.exec(n.userAgent))&&(f=!0,l=T(e[1]))),f}function S(){if(!t(h)){h=!1;var e=/ Edge\/([\.0-9]+)/.exec(n.userAgent);null!==e&&(h=!0,p=T(e[1]))}return h}function b(){if(!t(d)){d=!1;var e=/Firefox\/([\.0-9]+)/.exec(n.userAgent);null!==e&&(d=!0,y=T(e[1]))}return d}function C(){if(!t(_)){var e=document.createElement("canvas");e.setAttribute("style","image-rendering: -moz-crisp-edges;image-rendering: pixelated;");var r=e.style.imageRendering;(_=t(r)&&""!==r)&&(O=r)}return _}n="undefined"!=typeof navigator?navigator:{};var v=[];"undefined"!=typeof ArrayBuffer&&(v.push(Int8Array,Uint8Array,Int16Array,Uint16Array,Int32Array,Uint32Array,Float32Array,Float64Array),"undefined"!=typeof Uint8ClampedArray&&v.push(Uint8ClampedArray),"undefined"!=typeof CanvasPixelArray&&v.push(CanvasPixelArray));var N={isChrome:R,chromeVersion:function(){return R()&&i},isSafari:w,safariVersion:function(){return w()&&s},isWebkit:g,webkitVersion:function(){return g()&&c},isInternetExplorer:A,internetExplorerVersion:function(){return A()&&l},isEdge:S,edgeVersion:function(){return S()&&p},isFirefox:b,firefoxVersion:function(){return b()&&y},isWindows:function(){return t(m)||(m=/Windows/i.test(n.appVersion)),m},hardwareConcurrency:e(n.hardwareConcurrency,3),supportsPointerEvents:function(){return t(E)||(E=!b()&&"undefined"!=typeof PointerEvent&&(!t(n.pointerEnabled)||n.pointerEnabled)),E},supportsImageRenderingPixelated:C,imageRenderingValue:function(){return C()?O:void 0},typedArrayTypes:v,supportsFullscreen:function(){return r.supportsFullscreen()},supportsTypedArrays:function(){return"undefined"!=typeof ArrayBuffer},supportsWebWorkers:function(){return"undefined"!=typeof Worker},supportsWebAssembly:function(){return"undefined"!=typeof WebAssembly&&!N.isEdge()}};return N})),define("Core/Color",["./Check","./defaultValue","./defined","./FeatureDetection","./freezeObject","./Math"],(function(e,t,r,n,o,i){"use strict";function a(e,t,r){return r<0&&(r+=1),r>1&&(r-=1),6*r<1?e+6*(t-e)*r:2*r<1?t:3*r<2?e+(t-e)*(2/3-r)*6:e}function s(e,r,n,o){this.red=t(e,1),this.green=t(r,1),this.blue=t(n,1),this.alpha=t(o,1)}var u,c,f;s.fromCartesian4=function(t,n){return e.typeOf.object("cartesian",t),r(n)?(n.red=t.x,n.green=t.y,n.blue=t.z,n.alpha=t.w,n):new s(t.x,t.y,t.z,t.w)},s.fromBytes=function(e,n,o,i,a){return e=s.byteToFloat(t(e,255)),n=s.byteToFloat(t(n,255)),o=s.byteToFloat(t(o,255)),i=s.byteToFloat(t(i,255)),r(a)?(a.red=e,a.green=n,a.blue=o,a.alpha=i,a):new s(e,n,o,i)},s.fromAlpha=function(t,n,o){return e.typeOf.object("color",t),e.typeOf.number("alpha",n),r(o)?(o.red=t.red,o.green=t.green,o.blue=t.blue,o.alpha=n,o):new s(t.red,t.green,t.blue,n)},n.supportsTypedArrays()&&(u=new ArrayBuffer(4),c=new Uint32Array(u),f=new Uint8Array(u)),s.fromRgba=function(e,t){return c[0]=e,s.fromBytes(f[0],f[1],f[2],f[3],t)},s.fromHsl=function(e,n,o,i,u){e=t(e,0)%1,n=t(n,0),o=t(o,0),i=t(i,1);var c=o,f=o,l=o;if(0!==n){var h,p=2*o-(h=o<.5?o*(1+n):o+n-o*n);c=a(p,h,e+1/3),f=a(p,h,e),l=a(p,h,e-1/3)}return r(u)?(u.red=c,u.green=f,u.blue=l,u.alpha=i,u):new s(c,f,l,i)},s.fromRandom=function(n,o){var a=(n=t(n,t.EMPTY_OBJECT)).red;if(!r(a)){var u=t(n.minimumRed,0),c=t(n.maximumRed,1);e.typeOf.number.lessThanOrEquals("minimumRed",u,c),a=u+i.nextRandomNumber()*(c-u)}var f=n.green;if(!r(f)){var l=t(n.minimumGreen,0),h=t(n.maximumGreen,1);e.typeOf.number.lessThanOrEquals("minimumGreen",l,h),f=l+i.nextRandomNumber()*(h-l)}var p=n.blue;if(!r(p)){var d=t(n.minimumBlue,0),y=t(n.maximumBlue,1);e.typeOf.number.lessThanOrEquals("minimumBlue",d,y),p=d+i.nextRandomNumber()*(y-d)}var m=n.alpha;if(!r(m)){var E=t(n.minimumAlpha,0),O=t(n.maximumAlpha,1);e.typeOf.number.lessThanOrEquals("minumumAlpha",E,O),m=E+i.nextRandomNumber()*(O-E)}return r(o)?(o.red=a,o.green=f,o.blue=p,o.alpha=m,o):new s(a,f,p,m)};var l=/^#([0-9a-f])([0-9a-f])([0-9a-f])$/i,h=/^#([0-9a-f]{2})([0-9a-f]{2})([0-9a-f]{2})$/i,p=/^rgba?\(\s*([0-9.]+%?)\s*,\s*([0-9.]+%?)\s*,\s*([0-9.]+%?)(?:\s*,\s*([0-9.]+))?\s*\)$/i,d=/^hsla?\(\s*([0-9.]+)\s*,\s*([0-9.]+%)\s*,\s*([0-9.]+%)(?:\s*,\s*([0-9.]+))?\s*\)$/i;return s.fromCssColorString=function(n,o){e.typeOf.string("color",n),r(o)||(o=new s);var i=s[n.toUpperCase()];if(r(i))return s.clone(i,o),o;var a=l.exec(n);return null!==a?(o.red=parseInt(a[1],16)/15,o.green=parseInt(a[2],16)/15,o.blue=parseInt(a[3],16)/15,o.alpha=1,o):null!==(a=h.exec(n))?(o.red=parseInt(a[1],16)/255,o.green=parseInt(a[2],16)/255,o.blue=parseInt(a[3],16)/255,o.alpha=1,o):null!==(a=p.exec(n))?(o.red=parseFloat(a[1])/("%"===a[1].substr(-1)?100:255),o.green=parseFloat(a[2])/("%"===a[2].substr(-1)?100:255),o.blue=parseFloat(a[3])/("%"===a[3].substr(-1)?100:255),o.alpha=parseFloat(t(a[4],"1.0")),o):null!==(a=d.exec(n))?s.fromHsl(parseFloat(a[1])/360,parseFloat(a[2])/100,parseFloat(a[3])/100,parseFloat(t(a[4],"1.0")),o):o=void 0},s.packedLength=4,s.pack=function(r,n,o){return e.typeOf.object("value",r),e.defined("array",n),o=t(o,0),n[o++]=r.red,n[o++]=r.green,n[o++]=r.blue,n[o]=r.alpha,n},s.unpack=function(n,o,i){return e.defined("array",n),o=t(o,0),r(i)||(i=new s),i.red=n[o++],i.green=n[o++],i.blue=n[o++],i.alpha=n[o],i},s.byteToFloat=function(e){return e/255},s.floatToByte=function(e){return 1===e?255:256*e|0},s.clone=function(e,t){if(r(e))return r(t)?(t.red=e.red,t.green=e.green,t.blue=e.blue,t.alpha=e.alpha,t):new s(e.red,e.green,e.blue,e.alpha)},s.equals=function(e,t){return e===t||r(e)&&r(t)&&e.red===t.red&&e.green===t.green&&e.blue===t.blue&&e.alpha===t.alpha},s.equalsArray=function(e,t,r){return e.red===t[r]&&e.green===t[r+1]&&e.blue===t[r+2]&&e.alpha===t[r+3]},s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s.prototype.equalsEpsilon=function(e,t){return this===e||r(e)&&Math.abs(this.red-e.red)<=t&&Math.abs(this.green-e.green)<=t&&Math.abs(this.blue-e.blue)<=t&&Math.abs(this.alpha-e.alpha)<=t},s.prototype.toString=function(){return"("+this.red+", "+this.green+", "+this.blue+", "+this.alpha+")"},s.prototype.toCssColorString=function(){var e=s.floatToByte(this.red),t=s.floatToByte(this.green),r=s.floatToByte(this.blue);return 1===this.alpha?"rgb("+e+","+t+","+r+")":"rgba("+e+","+t+","+r+","+this.alpha+")"},s.prototype.toBytes=function(e){var t=s.floatToByte(this.red),n=s.floatToByte(this.green),o=s.floatToByte(this.blue),i=s.floatToByte(this.alpha);return r(e)?(e[0]=t,e[1]=n,e[2]=o,e[3]=i,e):[t,n,o,i]},s.prototype.toRgba=function(){return f[0]=s.floatToByte(this.red),f[1]=s.floatToByte(this.green),f[2]=s.floatToByte(this.blue),f[3]=s.floatToByte(this.alpha),c[0]},s.prototype.brighten=function(t,r){return e.typeOf.number("magnitude",t),e.typeOf.number.greaterThanOrEquals("magnitude",t,0),e.typeOf.object("result",r),t=1-t,r.red=1-(1-this.red)*t,r.green=1-(1-this.green)*t,r.blue=1-(1-this.blue)*t,r.alpha=this.alpha,r},s.prototype.darken=function(t,r){return e.typeOf.number("magnitude",t),e.typeOf.number.greaterThanOrEquals("magnitude",t,0),e.typeOf.object("result",r),t=1-t,r.red=this.red*t,r.green=this.green*t,r.blue=this.blue*t,r.alpha=this.alpha,r},s.prototype.withAlpha=function(e,t){return s.fromAlpha(this,e,t)},s.add=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.red=t.red+r.red,n.green=t.green+r.green,n.blue=t.blue+r.blue,n.alpha=t.alpha+r.alpha,n},s.subtract=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.red=t.red-r.red,n.green=t.green-r.green,n.blue=t.blue-r.blue,n.alpha=t.alpha-r.alpha,n},s.multiply=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.red=t.red*r.red,n.green=t.green*r.green,n.blue=t.blue*r.blue,n.alpha=t.alpha*r.alpha,n},s.divide=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.red=t.red/r.red,n.green=t.green/r.green,n.blue=t.blue/r.blue,n.alpha=t.alpha/r.alpha,n},s.mod=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.red=t.red%r.red,n.green=t.green%r.green,n.blue=t.blue%r.blue,n.alpha=t.alpha%r.alpha,n},s.multiplyByScalar=function(t,r,n){return e.typeOf.object("color",t),e.typeOf.number("scalar",r),e.typeOf.object("result",n),n.red=t.red*r,n.green=t.green*r,n.blue=t.blue*r,n.alpha=t.alpha*r,n},s.divideByScalar=function(t,r,n){return e.typeOf.object("color",t),e.typeOf.number("scalar",r),e.typeOf.object("result",n),n.red=t.red/r,n.green=t.green/r,n.blue=t.blue/r,n.alpha=t.alpha/r,n},s.ALICEBLUE=o(s.fromCssColorString("#F0F8FF")),s.ANTIQUEWHITE=o(s.fromCssColorString("#FAEBD7")),s.AQUA=o(s.fromCssColorString("#00FFFF")),s.AQUAMARINE=o(s.fromCssColorString("#7FFFD4")),s.AZURE=o(s.fromCssColorString("#F0FFFF")),s.BEIGE=o(s.fromCssColorString("#F5F5DC")),s.BISQUE=o(s.fromCssColorString("#FFE4C4")),s.BLACK=o(s.fromCssColorString("#000000")),s.BLANCHEDALMOND=o(s.fromCssColorString("#FFEBCD")),s.BLUE=o(s.fromCssColorString("#0000FF")),s.BLUEVIOLET=o(s.fromCssColorString("#8A2BE2")),s.BROWN=o(s.fromCssColorString("#A52A2A")),s.BURLYWOOD=o(s.fromCssColorString("#DEB887")),s.CADETBLUE=o(s.fromCssColorString("#5F9EA0")),s.CHARTREUSE=o(s.fromCssColorString("#7FFF00")),s.CHOCOLATE=o(s.fromCssColorString("#D2691E")),s.CORAL=o(s.fromCssColorString("#FF7F50")),s.CORNFLOWERBLUE=o(s.fromCssColorString("#6495ED")),s.CORNSILK=o(s.fromCssColorString("#FFF8DC")),s.CRIMSON=o(s.fromCssColorString("#DC143C")),s.CYAN=o(s.fromCssColorString("#00FFFF")),s.DARKBLUE=o(s.fromCssColorString("#00008B")),s.DARKCYAN=o(s.fromCssColorString("#008B8B")),s.DARKGOLDENROD=o(s.fromCssColorString("#B8860B")),s.DARKGRAY=o(s.fromCssColorString("#A9A9A9")),s.DARKGREEN=o(s.fromCssColorString("#006400")),s.DARKGREY=s.DARKGRAY,s.DARKKHAKI=o(s.fromCssColorString("#BDB76B")),s.DARKMAGENTA=o(s.fromCssColorString("#8B008B")),s.DARKOLIVEGREEN=o(s.fromCssColorString("#556B2F")),s.DARKORANGE=o(s.fromCssColorString("#FF8C00")),s.DARKORCHID=o(s.fromCssColorString("#9932CC")),s.DARKRED=o(s.fromCssColorString("#8B0000")),s.DARKSALMON=o(s.fromCssColorString("#E9967A")),s.DARKSEAGREEN=o(s.fromCssColorString("#8FBC8F")),s.DARKSLATEBLUE=o(s.fromCssColorString("#483D8B")),s.DARKSLATEGRAY=o(s.fromCssColorString("#2F4F4F")),s.DARKSLATEGREY=s.DARKSLATEGRAY,s.DARKTURQUOISE=o(s.fromCssColorString("#00CED1")),s.DARKVIOLET=o(s.fromCssColorString("#9400D3")),s.DEEPPINK=o(s.fromCssColorString("#FF1493")),s.DEEPSKYBLUE=o(s.fromCssColorString("#00BFFF")),s.DIMGRAY=o(s.fromCssColorString("#696969")),s.DIMGREY=s.DIMGRAY,s.DODGERBLUE=o(s.fromCssColorString("#1E90FF")),s.FIREBRICK=o(s.fromCssColorString("#B22222")),s.FLORALWHITE=o(s.fromCssColorString("#FFFAF0")),s.FORESTGREEN=o(s.fromCssColorString("#228B22")),s.FUCHSIA=o(s.fromCssColorString("#FF00FF")),s.GAINSBORO=o(s.fromCssColorString("#DCDCDC")),s.GHOSTWHITE=o(s.fromCssColorString("#F8F8FF")),s.GOLD=o(s.fromCssColorString("#FFD700")),s.GOLDENROD=o(s.fromCssColorString("#DAA520")),s.GRAY=o(s.fromCssColorString("#808080")),s.GREEN=o(s.fromCssColorString("#008000")),s.GREENYELLOW=o(s.fromCssColorString("#ADFF2F")),s.GREY=s.GRAY,s.HONEYDEW=o(s.fromCssColorString("#F0FFF0")),s.HOTPINK=o(s.fromCssColorString("#FF69B4")),s.INDIANRED=o(s.fromCssColorString("#CD5C5C")),s.INDIGO=o(s.fromCssColorString("#4B0082")),s.IVORY=o(s.fromCssColorString("#FFFFF0")),s.KHAKI=o(s.fromCssColorString("#F0E68C")),s.LAVENDER=o(s.fromCssColorString("#E6E6FA")),s.LAVENDAR_BLUSH=o(s.fromCssColorString("#FFF0F5")),s.LAWNGREEN=o(s.fromCssColorString("#7CFC00")),s.LEMONCHIFFON=o(s.fromCssColorString("#FFFACD")),s.LIGHTBLUE=o(s.fromCssColorString("#ADD8E6")),s.LIGHTCORAL=o(s.fromCssColorString("#F08080")),s.LIGHTCYAN=o(s.fromCssColorString("#E0FFFF")),s.LIGHTGOLDENRODYELLOW=o(s.fromCssColorString("#FAFAD2")),s.LIGHTGRAY=o(s.fromCssColorString("#D3D3D3")),s.LIGHTGREEN=o(s.fromCssColorString("#90EE90")),s.LIGHTGREY=s.LIGHTGRAY,s.LIGHTPINK=o(s.fromCssColorString("#FFB6C1")),s.LIGHTSEAGREEN=o(s.fromCssColorString("#20B2AA")),s.LIGHTSKYBLUE=o(s.fromCssColorString("#87CEFA")),s.LIGHTSLATEGRAY=o(s.fromCssColorString("#778899")),s.LIGHTSLATEGREY=s.LIGHTSLATEGRAY,s.LIGHTSTEELBLUE=o(s.fromCssColorString("#B0C4DE")),s.LIGHTYELLOW=o(s.fromCssColorString("#FFFFE0")),s.LIME=o(s.fromCssColorString("#00FF00")),s.LIMEGREEN=o(s.fromCssColorString("#32CD32")),s.LINEN=o(s.fromCssColorString("#FAF0E6")),s.MAGENTA=o(s.fromCssColorString("#FF00FF")),s.MAROON=o(s.fromCssColorString("#800000")),s.MEDIUMAQUAMARINE=o(s.fromCssColorString("#66CDAA")),s.MEDIUMBLUE=o(s.fromCssColorString("#0000CD")),s.MEDIUMORCHID=o(s.fromCssColorString("#BA55D3")),s.MEDIUMPURPLE=o(s.fromCssColorString("#9370DB")),s.MEDIUMSEAGREEN=o(s.fromCssColorString("#3CB371")),s.MEDIUMSLATEBLUE=o(s.fromCssColorString("#7B68EE")),s.MEDIUMSPRINGGREEN=o(s.fromCssColorString("#00FA9A")),s.MEDIUMTURQUOISE=o(s.fromCssColorString("#48D1CC")),s.MEDIUMVIOLETRED=o(s.fromCssColorString("#C71585")),s.MIDNIGHTBLUE=o(s.fromCssColorString("#191970")),s.MINTCREAM=o(s.fromCssColorString("#F5FFFA")),s.MISTYROSE=o(s.fromCssColorString("#FFE4E1")),s.MOCCASIN=o(s.fromCssColorString("#FFE4B5")),s.NAVAJOWHITE=o(s.fromCssColorString("#FFDEAD")),s.NAVY=o(s.fromCssColorString("#000080")),s.OLDLACE=o(s.fromCssColorString("#FDF5E6")),s.OLIVE=o(s.fromCssColorString("#808000")),s.OLIVEDRAB=o(s.fromCssColorString("#6B8E23")),s.ORANGE=o(s.fromCssColorString("#FFA500")),s.ORANGERED=o(s.fromCssColorString("#FF4500")),s.ORCHID=o(s.fromCssColorString("#DA70D6")),s.PALEGOLDENROD=o(s.fromCssColorString("#EEE8AA")),s.PALEGREEN=o(s.fromCssColorString("#98FB98")),s.PALETURQUOISE=o(s.fromCssColorString("#AFEEEE")),s.PALEVIOLETRED=o(s.fromCssColorString("#DB7093")),s.PAPAYAWHIP=o(s.fromCssColorString("#FFEFD5")),s.PEACHPUFF=o(s.fromCssColorString("#FFDAB9")),s.PERU=o(s.fromCssColorString("#CD853F")),s.PINK=o(s.fromCssColorString("#FFC0CB")),s.PLUM=o(s.fromCssColorString("#DDA0DD")),s.POWDERBLUE=o(s.fromCssColorString("#B0E0E6")),s.PURPLE=o(s.fromCssColorString("#800080")),s.RED=o(s.fromCssColorString("#FF0000")),s.ROSYBROWN=o(s.fromCssColorString("#BC8F8F")),s.ROYALBLUE=o(s.fromCssColorString("#4169E1")),s.SADDLEBROWN=o(s.fromCssColorString("#8B4513")),s.SALMON=o(s.fromCssColorString("#FA8072")),s.SANDYBROWN=o(s.fromCssColorString("#F4A460")),s.SEAGREEN=o(s.fromCssColorString("#2E8B57")),s.SEASHELL=o(s.fromCssColorString("#FFF5EE")),s.SIENNA=o(s.fromCssColorString("#A0522D")),s.SILVER=o(s.fromCssColorString("#C0C0C0")),s.SKYBLUE=o(s.fromCssColorString("#87CEEB")),s.SLATEBLUE=o(s.fromCssColorString("#6A5ACD")),s.SLATEGRAY=o(s.fromCssColorString("#708090")),s.SLATEGREY=s.SLATEGRAY,s.SNOW=o(s.fromCssColorString("#FFFAFA")),s.SPRINGGREEN=o(s.fromCssColorString("#00FF7F")),s.STEELBLUE=o(s.fromCssColorString("#4682B4")),s.TAN=o(s.fromCssColorString("#D2B48C")),s.TEAL=o(s.fromCssColorString("#008080")),s.THISTLE=o(s.fromCssColorString("#D8BFD8")),s.TOMATO=o(s.fromCssColorString("#FF6347")),s.TURQUOISE=o(s.fromCssColorString("#40E0D0")),s.VIOLET=o(s.fromCssColorString("#EE82EE")),s.WHEAT=o(s.fromCssColorString("#F5DEB3")),s.WHITE=o(s.fromCssColorString("#FFFFFF")),s.WHITESMOKE=o(s.fromCssColorString("#F5F5F5")),s.YELLOW=o(s.fromCssColorString("#FFFF00")),s.YELLOWGREEN=o(s.fromCssColorString("#9ACD32")),s.TRANSPARENT=o(new s(0,0,0,0)),s})),define("Core/WebGLConstants",["./freezeObject"],(function(e){"use strict";return e({DEPTH_BUFFER_BIT:256,STENCIL_BUFFER_BIT:1024,COLOR_BUFFER_BIT:16384,POINTS:0,LINES:1,LINE_LOOP:2,LINE_STRIP:3,TRIANGLES:4,TRIANGLE_STRIP:5,TRIANGLE_FAN:6,ZERO:0,ONE:1,SRC_COLOR:768,ONE_MINUS_SRC_COLOR:769,SRC_ALPHA:770,ONE_MINUS_SRC_ALPHA:771,DST_ALPHA:772,ONE_MINUS_DST_ALPHA:773,DST_COLOR:774,ONE_MINUS_DST_COLOR:775,SRC_ALPHA_SATURATE:776,FUNC_ADD:32774,BLEND_EQUATION:32777,BLEND_EQUATION_RGB:32777,BLEND_EQUATION_ALPHA:34877,FUNC_SUBTRACT:32778,FUNC_REVERSE_SUBTRACT:32779,BLEND_DST_RGB:32968,BLEND_SRC_RGB:32969,BLEND_DST_ALPHA:32970,BLEND_SRC_ALPHA:32971,CONSTANT_COLOR:32769,ONE_MINUS_CONSTANT_COLOR:32770,CONSTANT_ALPHA:32771,ONE_MINUS_CONSTANT_ALPHA:32772,BLEND_COLOR:32773,ARRAY_BUFFER:34962,ELEMENT_ARRAY_BUFFER:34963,ARRAY_BUFFER_BINDING:34964,ELEMENT_ARRAY_BUFFER_BINDING:34965,STREAM_DRAW:35040,STATIC_DRAW:35044,DYNAMIC_DRAW:35048,BUFFER_SIZE:34660,BUFFER_USAGE:34661,CURRENT_VERTEX_ATTRIB:34342,FRONT:1028,BACK:1029,FRONT_AND_BACK:1032,CULL_FACE:2884,BLEND:3042,DITHER:3024,STENCIL_TEST:2960,DEPTH_TEST:2929,SCISSOR_TEST:3089,POLYGON_OFFSET_FILL:32823,SAMPLE_ALPHA_TO_COVERAGE:32926,SAMPLE_COVERAGE:32928,NO_ERROR:0,INVALID_ENUM:1280,INVALID_VALUE:1281,INVALID_OPERATION:1282,OUT_OF_MEMORY:1285,CW:2304,CCW:2305,LINE_WIDTH:2849,ALIASED_POINT_SIZE_RANGE:33901,ALIASED_LINE_WIDTH_RANGE:33902,CULL_FACE_MODE:2885,FRONT_FACE:2886,DEPTH_RANGE:2928,DEPTH_WRITEMASK:2930,DEPTH_CLEAR_VALUE:2931,DEPTH_FUNC:2932,STENCIL_CLEAR_VALUE:2961,STENCIL_FUNC:2962,STENCIL_FAIL:2964,STENCIL_PASS_DEPTH_FAIL:2965,STENCIL_PASS_DEPTH_PASS:2966,STENCIL_REF:2967,STENCIL_VALUE_MASK:2963,STENCIL_WRITEMASK:2968,STENCIL_BACK_FUNC:34816,STENCIL_BACK_FAIL:34817,STENCIL_BACK_PASS_DEPTH_FAIL:34818,STENCIL_BACK_PASS_DEPTH_PASS:34819,STENCIL_BACK_REF:36003,STENCIL_BACK_VALUE_MASK:36004,STENCIL_BACK_WRITEMASK:36005,VIEWPORT:2978,SCISSOR_BOX:3088,COLOR_CLEAR_VALUE:3106,COLOR_WRITEMASK:3107,UNPACK_ALIGNMENT:3317,PACK_ALIGNMENT:3333,MAX_TEXTURE_SIZE:3379,MAX_VIEWPORT_DIMS:3386,SUBPIXEL_BITS:3408,RED_BITS:3410,GREEN_BITS:3411,BLUE_BITS:3412,ALPHA_BITS:3413,DEPTH_BITS:3414,STENCIL_BITS:3415,POLYGON_OFFSET_UNITS:10752,POLYGON_OFFSET_FACTOR:32824,TEXTURE_BINDING_2D:32873,SAMPLE_BUFFERS:32936,SAMPLES:32937,SAMPLE_COVERAGE_VALUE:32938,SAMPLE_COVERAGE_INVERT:32939,COMPRESSED_TEXTURE_FORMATS:34467,DONT_CARE:4352,FASTEST:4353,NICEST:4354,GENERATE_MIPMAP_HINT:33170,BYTE:5120,UNSIGNED_BYTE:5121,SHORT:5122,UNSIGNED_SHORT:5123,INT:5124,UNSIGNED_INT:5125,FLOAT:5126,DEPTH_COMPONENT:6402,ALPHA:6406,RGB:6407,RGBA:6408,LUMINANCE:6409,LUMINANCE_ALPHA:6410,UNSIGNED_SHORT_4_4_4_4:32819,UNSIGNED_SHORT_5_5_5_1:32820,UNSIGNED_SHORT_5_6_5:33635,FRAGMENT_SHADER:35632,VERTEX_SHADER:35633,MAX_VERTEX_ATTRIBS:34921,MAX_VERTEX_UNIFORM_VECTORS:36347,MAX_VARYING_VECTORS:36348,MAX_COMBINED_TEXTURE_IMAGE_UNITS:35661,MAX_VERTEX_TEXTURE_IMAGE_UNITS:35660,MAX_TEXTURE_IMAGE_UNITS:34930,MAX_FRAGMENT_UNIFORM_VECTORS:36349,SHADER_TYPE:35663,DELETE_STATUS:35712,LINK_STATUS:35714,VALIDATE_STATUS:35715,ATTACHED_SHADERS:35717,ACTIVE_UNIFORMS:35718,ACTIVE_ATTRIBUTES:35721,SHADING_LANGUAGE_VERSION:35724,CURRENT_PROGRAM:35725,NEVER:512,LESS:513,EQUAL:514,LEQUAL:515,GREATER:516,NOTEQUAL:517,GEQUAL:518,ALWAYS:519,KEEP:7680,REPLACE:7681,INCR:7682,DECR:7683,INVERT:5386,INCR_WRAP:34055,DECR_WRAP:34056,VENDOR:7936,RENDERER:7937,VERSION:7938,NEAREST:9728,LINEAR:9729,NEAREST_MIPMAP_NEAREST:9984,LINEAR_MIPMAP_NEAREST:9985,NEAREST_MIPMAP_LINEAR:9986,LINEAR_MIPMAP_LINEAR:9987,TEXTURE_MAG_FILTER:10240,TEXTURE_MIN_FILTER:10241,TEXTURE_WRAP_S:10242,TEXTURE_WRAP_T:10243,TEXTURE_2D:3553,TEXTURE:5890,TEXTURE_CUBE_MAP:34067,TEXTURE_BINDING_CUBE_MAP:34068,TEXTURE_CUBE_MAP_POSITIVE_X:34069,TEXTURE_CUBE_MAP_NEGATIVE_X:34070,TEXTURE_CUBE_MAP_POSITIVE_Y:34071,TEXTURE_CUBE_MAP_NEGATIVE_Y:34072,TEXTURE_CUBE_MAP_POSITIVE_Z:34073,TEXTURE_CUBE_MAP_NEGATIVE_Z:34074,MAX_CUBE_MAP_TEXTURE_SIZE:34076,TEXTURE0:33984,TEXTURE1:33985,TEXTURE2:33986,TEXTURE3:33987,TEXTURE4:33988,TEXTURE5:33989,TEXTURE6:33990,TEXTURE7:33991,TEXTURE8:33992,TEXTURE9:33993,TEXTURE10:33994,TEXTURE11:33995,TEXTURE12:33996,TEXTURE13:33997,TEXTURE14:33998,TEXTURE15:33999,TEXTURE16:34e3,TEXTURE17:34001,TEXTURE18:34002,TEXTURE19:34003,TEXTURE20:34004,TEXTURE21:34005,TEXTURE22:34006,TEXTURE23:34007,TEXTURE24:34008,TEXTURE25:34009,TEXTURE26:34010,TEXTURE27:34011,TEXTURE28:34012,TEXTURE29:34013,TEXTURE30:34014,TEXTURE31:34015,ACTIVE_TEXTURE:34016,REPEAT:10497,CLAMP_TO_EDGE:33071,MIRRORED_REPEAT:33648,FLOAT_VEC2:35664,FLOAT_VEC3:35665,FLOAT_VEC4:35666,INT_VEC2:35667,INT_VEC3:35668,INT_VEC4:35669,BOOL:35670,BOOL_VEC2:35671,BOOL_VEC3:35672,BOOL_VEC4:35673,FLOAT_MAT2:35674,FLOAT_MAT3:35675,FLOAT_MAT4:35676,SAMPLER_2D:35678,SAMPLER_CUBE:35680,VERTEX_ATTRIB_ARRAY_ENABLED:34338,VERTEX_ATTRIB_ARRAY_SIZE:34339,VERTEX_ATTRIB_ARRAY_STRIDE:34340,VERTEX_ATTRIB_ARRAY_TYPE:34341,VERTEX_ATTRIB_ARRAY_NORMALIZED:34922,VERTEX_ATTRIB_ARRAY_POINTER:34373,VERTEX_ATTRIB_ARRAY_BUFFER_BINDING:34975,IMPLEMENTATION_COLOR_READ_TYPE:35738,IMPLEMENTATION_COLOR_READ_FORMAT:35739,COMPILE_STATUS:35713,LOW_FLOAT:36336,MEDIUM_FLOAT:36337,HIGH_FLOAT:36338,LOW_INT:36339,MEDIUM_INT:36340,HIGH_INT:36341,FRAMEBUFFER:36160,RENDERBUFFER:36161,RGBA4:32854,RGB5_A1:32855,RGB565:36194,DEPTH_COMPONENT16:33189,STENCIL_INDEX:6401,STENCIL_INDEX8:36168,DEPTH_STENCIL:34041,RENDERBUFFER_WIDTH:36162,RENDERBUFFER_HEIGHT:36163,RENDERBUFFER_INTERNAL_FORMAT:36164,RENDERBUFFER_RED_SIZE:36176,RENDERBUFFER_GREEN_SIZE:36177,RENDERBUFFER_BLUE_SIZE:36178,RENDERBUFFER_ALPHA_SIZE:36179,RENDERBUFFER_DEPTH_SIZE:36180,RENDERBUFFER_STENCIL_SIZE:36181,FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE:36048,FRAMEBUFFER_ATTACHMENT_OBJECT_NAME:36049,FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL:36050,FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE:36051,COLOR_ATTACHMENT0:36064,DEPTH_ATTACHMENT:36096,STENCIL_ATTACHMENT:36128,DEPTH_STENCIL_ATTACHMENT:33306,NONE:0,FRAMEBUFFER_COMPLETE:36053,FRAMEBUFFER_INCOMPLETE_ATTACHMENT:36054,FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT:36055,FRAMEBUFFER_INCOMPLETE_DIMENSIONS:36057,FRAMEBUFFER_UNSUPPORTED:36061,FRAMEBUFFER_BINDING:36006,RENDERBUFFER_BINDING:36007,MAX_RENDERBUFFER_SIZE:34024,INVALID_FRAMEBUFFER_OPERATION:1286,UNPACK_FLIP_Y_WEBGL:37440,UNPACK_PREMULTIPLY_ALPHA_WEBGL:37441,CONTEXT_LOST_WEBGL:37442,UNPACK_COLORSPACE_CONVERSION_WEBGL:37443,BROWSER_DEFAULT_WEBGL:37444,COMPRESSED_RGB_S3TC_DXT1_EXT:33776,COMPRESSED_RGBA_S3TC_DXT1_EXT:33777,COMPRESSED_RGBA_S3TC_DXT3_EXT:33778,COMPRESSED_RGBA_S3TC_DXT5_EXT:33779,COMPRESSED_RGB_PVRTC_4BPPV1_IMG:35840,COMPRESSED_RGB_PVRTC_2BPPV1_IMG:35841,COMPRESSED_RGBA_PVRTC_4BPPV1_IMG:35842,COMPRESSED_RGBA_PVRTC_2BPPV1_IMG:35843,COMPRESSED_RGB_ETC1_WEBGL:36196,HALF_FLOAT_OES:36193,DOUBLE:5130,READ_BUFFER:3074,UNPACK_ROW_LENGTH:3314,UNPACK_SKIP_ROWS:3315,UNPACK_SKIP_PIXELS:3316,PACK_ROW_LENGTH:3330,PACK_SKIP_ROWS:3331,PACK_SKIP_PIXELS:3332,COLOR:6144,DEPTH:6145,STENCIL:6146,RED:6403,RGB8:32849,RGBA8:32856,RGB10_A2:32857,TEXTURE_BINDING_3D:32874,UNPACK_SKIP_IMAGES:32877,UNPACK_IMAGE_HEIGHT:32878,TEXTURE_3D:32879,TEXTURE_WRAP_R:32882,MAX_3D_TEXTURE_SIZE:32883,UNSIGNED_INT_2_10_10_10_REV:33640,MAX_ELEMENTS_VERTICES:33e3,MAX_ELEMENTS_INDICES:33001,TEXTURE_MIN_LOD:33082,TEXTURE_MAX_LOD:33083,TEXTURE_BASE_LEVEL:33084,TEXTURE_MAX_LEVEL:33085,MIN:32775,MAX:32776,DEPTH_COMPONENT24:33190,MAX_TEXTURE_LOD_BIAS:34045,TEXTURE_COMPARE_MODE:34892,TEXTURE_COMPARE_FUNC:34893,CURRENT_QUERY:34917,QUERY_RESULT:34918,QUERY_RESULT_AVAILABLE:34919,STREAM_READ:35041,STREAM_COPY:35042,STATIC_READ:35045,STATIC_COPY:35046,DYNAMIC_READ:35049,DYNAMIC_COPY:35050,MAX_DRAW_BUFFERS:34852,DRAW_BUFFER0:34853,DRAW_BUFFER1:34854,DRAW_BUFFER2:34855,DRAW_BUFFER3:34856,DRAW_BUFFER4:34857,DRAW_BUFFER5:34858,DRAW_BUFFER6:34859,DRAW_BUFFER7:34860,DRAW_BUFFER8:34861,DRAW_BUFFER9:34862,DRAW_BUFFER10:34863,DRAW_BUFFER11:34864,DRAW_BUFFER12:34865,DRAW_BUFFER13:34866,DRAW_BUFFER14:34867,DRAW_BUFFER15:34868,MAX_FRAGMENT_UNIFORM_COMPONENTS:35657,MAX_VERTEX_UNIFORM_COMPONENTS:35658,SAMPLER_3D:35679,SAMPLER_2D_SHADOW:35682,FRAGMENT_SHADER_DERIVATIVE_HINT:35723,PIXEL_PACK_BUFFER:35051,PIXEL_UNPACK_BUFFER:35052,PIXEL_PACK_BUFFER_BINDING:35053,PIXEL_UNPACK_BUFFER_BINDING:35055,FLOAT_MAT2x3:35685,FLOAT_MAT2x4:35686,FLOAT_MAT3x2:35687,FLOAT_MAT3x4:35688,FLOAT_MAT4x2:35689,FLOAT_MAT4x3:35690,SRGB:35904,SRGB8:35905,SRGB8_ALPHA8:35907,COMPARE_REF_TO_TEXTURE:34894,RGBA32F:34836,RGB32F:34837,RGBA16F:34842,RGB16F:34843,VERTEX_ATTRIB_ARRAY_INTEGER:35069,MAX_ARRAY_TEXTURE_LAYERS:35071,MIN_PROGRAM_TEXEL_OFFSET:35076,MAX_PROGRAM_TEXEL_OFFSET:35077,MAX_VARYING_COMPONENTS:35659,TEXTURE_2D_ARRAY:35866,TEXTURE_BINDING_2D_ARRAY:35869,R11F_G11F_B10F:35898,UNSIGNED_INT_10F_11F_11F_REV:35899,RGB9_E5:35901,UNSIGNED_INT_5_9_9_9_REV:35902,TRANSFORM_FEEDBACK_BUFFER_MODE:35967,MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS:35968,TRANSFORM_FEEDBACK_VARYINGS:35971,TRANSFORM_FEEDBACK_BUFFER_START:35972,TRANSFORM_FEEDBACK_BUFFER_SIZE:35973,TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN:35976,RASTERIZER_DISCARD:35977,MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS:35978,MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS:35979,INTERLEAVED_ATTRIBS:35980,SEPARATE_ATTRIBS:35981,TRANSFORM_FEEDBACK_BUFFER:35982,TRANSFORM_FEEDBACK_BUFFER_BINDING:35983,RGBA32UI:36208,RGB32UI:36209,RGBA16UI:36214,RGB16UI:36215,RGBA8UI:36220,RGB8UI:36221,RGBA32I:36226,RGB32I:36227,RGBA16I:36232,RGB16I:36233,RGBA8I:36238,RGB8I:36239,RED_INTEGER:36244,RGB_INTEGER:36248,RGBA_INTEGER:36249,SAMPLER_2D_ARRAY:36289,SAMPLER_2D_ARRAY_SHADOW:36292,SAMPLER_CUBE_SHADOW:36293,UNSIGNED_INT_VEC2:36294,UNSIGNED_INT_VEC3:36295,UNSIGNED_INT_VEC4:36296,INT_SAMPLER_2D:36298,INT_SAMPLER_3D:36299,INT_SAMPLER_CUBE:36300,INT_SAMPLER_2D_ARRAY:36303,UNSIGNED_INT_SAMPLER_2D:36306,UNSIGNED_INT_SAMPLER_3D:36307,UNSIGNED_INT_SAMPLER_CUBE:36308,UNSIGNED_INT_SAMPLER_2D_ARRAY:36311,DEPTH_COMPONENT32F:36012,DEPTH32F_STENCIL8:36013,FLOAT_32_UNSIGNED_INT_24_8_REV:36269,FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING:33296,FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE:33297,FRAMEBUFFER_ATTACHMENT_RED_SIZE:33298,FRAMEBUFFER_ATTACHMENT_GREEN_SIZE:33299,FRAMEBUFFER_ATTACHMENT_BLUE_SIZE:33300,FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE:33301,FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE:33302,FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE:33303,FRAMEBUFFER_DEFAULT:33304,UNSIGNED_INT_24_8:34042,DEPTH24_STENCIL8:35056,UNSIGNED_NORMALIZED:35863,DRAW_FRAMEBUFFER_BINDING:36006,READ_FRAMEBUFFER:36008,DRAW_FRAMEBUFFER:36009,READ_FRAMEBUFFER_BINDING:36010,RENDERBUFFER_SAMPLES:36011,FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER:36052,MAX_COLOR_ATTACHMENTS:36063,COLOR_ATTACHMENT1:36065,COLOR_ATTACHMENT2:36066,COLOR_ATTACHMENT3:36067,COLOR_ATTACHMENT4:36068,COLOR_ATTACHMENT5:36069,COLOR_ATTACHMENT6:36070,COLOR_ATTACHMENT7:36071,COLOR_ATTACHMENT8:36072,COLOR_ATTACHMENT9:36073,COLOR_ATTACHMENT10:36074,COLOR_ATTACHMENT11:36075,COLOR_ATTACHMENT12:36076,COLOR_ATTACHMENT13:36077,COLOR_ATTACHMENT14:36078,COLOR_ATTACHMENT15:36079,FRAMEBUFFER_INCOMPLETE_MULTISAMPLE:36182,MAX_SAMPLES:36183,HALF_FLOAT:5131,RG:33319,RG_INTEGER:33320,R8:33321,RG8:33323,R16F:33325,R32F:33326,RG16F:33327,RG32F:33328,R8I:33329,R8UI:33330,R16I:33331,R16UI:33332,R32I:33333,R32UI:33334,RG8I:33335,RG8UI:33336,RG16I:33337,RG16UI:33338,RG32I:33339,RG32UI:33340,VERTEX_ARRAY_BINDING:34229,R8_SNORM:36756,RG8_SNORM:36757,RGB8_SNORM:36758,RGBA8_SNORM:36759,SIGNED_NORMALIZED:36764,COPY_READ_BUFFER:36662,COPY_WRITE_BUFFER:36663,COPY_READ_BUFFER_BINDING:36662,COPY_WRITE_BUFFER_BINDING:36663,UNIFORM_BUFFER:35345,UNIFORM_BUFFER_BINDING:35368,UNIFORM_BUFFER_START:35369,UNIFORM_BUFFER_SIZE:35370,MAX_VERTEX_UNIFORM_BLOCKS:35371,MAX_FRAGMENT_UNIFORM_BLOCKS:35373,MAX_COMBINED_UNIFORM_BLOCKS:35374,MAX_UNIFORM_BUFFER_BINDINGS:35375,MAX_UNIFORM_BLOCK_SIZE:35376,MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS:35377,MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS:35379,UNIFORM_BUFFER_OFFSET_ALIGNMENT:35380,ACTIVE_UNIFORM_BLOCKS:35382,UNIFORM_TYPE:35383,UNIFORM_SIZE:35384,UNIFORM_BLOCK_INDEX:35386,UNIFORM_OFFSET:35387,UNIFORM_ARRAY_STRIDE:35388,UNIFORM_MATRIX_STRIDE:35389,UNIFORM_IS_ROW_MAJOR:35390,UNIFORM_BLOCK_BINDING:35391,UNIFORM_BLOCK_DATA_SIZE:35392,UNIFORM_BLOCK_ACTIVE_UNIFORMS:35394,UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES:35395,UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER:35396,UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER:35398,INVALID_INDEX:4294967295,MAX_VERTEX_OUTPUT_COMPONENTS:37154,MAX_FRAGMENT_INPUT_COMPONENTS:37157,MAX_SERVER_WAIT_TIMEOUT:37137,OBJECT_TYPE:37138,SYNC_CONDITION:37139,SYNC_STATUS:37140,SYNC_FLAGS:37141,SYNC_FENCE:37142,SYNC_GPU_COMMANDS_COMPLETE:37143,UNSIGNALED:37144,SIGNALED:37145,ALREADY_SIGNALED:37146,TIMEOUT_EXPIRED:37147,CONDITION_SATISFIED:37148,WAIT_FAILED:37149,SYNC_FLUSH_COMMANDS_BIT:1,VERTEX_ATTRIB_ARRAY_DIVISOR:35070,ANY_SAMPLES_PASSED:35887,ANY_SAMPLES_PASSED_CONSERVATIVE:36202,SAMPLER_BINDING:35097,RGB10_A2UI:36975,INT_2_10_10_10_REV:36255,TRANSFORM_FEEDBACK:36386,TRANSFORM_FEEDBACK_PAUSED:36387,TRANSFORM_FEEDBACK_ACTIVE:36388,TRANSFORM_FEEDBACK_BINDING:36389,COMPRESSED_R11_EAC:37488,COMPRESSED_SIGNED_R11_EAC:37489,COMPRESSED_RG11_EAC:37490,COMPRESSED_SIGNED_RG11_EAC:37491,COMPRESSED_RGB8_ETC2:37492,COMPRESSED_SRGB8_ETC2:37493,COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2:37494,COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2:37495,COMPRESSED_RGBA8_ETC2_EAC:37496,COMPRESSED_SRGB8_ALPHA8_ETC2_EAC:37497,TEXTURE_IMMUTABLE_FORMAT:37167,MAX_ELEMENT_INDEX:36203,TEXTURE_IMMUTABLE_LEVELS:33503,MAX_TEXTURE_MAX_ANISOTROPY_EXT:34047})})),define("Core/ComponentDatatype",["./defaultValue","./defined","./DeveloperError","./FeatureDetection","./freezeObject","./WebGLConstants"],(function(e,t,r,n,o,i){"use strict";if(!n.supportsTypedArrays())return{};var a={BYTE:i.BYTE,UNSIGNED_BYTE:i.UNSIGNED_BYTE,SHORT:i.SHORT,UNSIGNED_SHORT:i.UNSIGNED_SHORT,INT:i.INT,UNSIGNED_INT:i.UNSIGNED_INT,FLOAT:i.FLOAT,DOUBLE:i.DOUBLE,getSizeInBytes:function(e){if(!t(e))throw new r("value is required.");switch(e){case a.BYTE:return Int8Array.BYTES_PER_ELEMENT;case a.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case a.SHORT:return Int16Array.BYTES_PER_ELEMENT;case a.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case a.INT:return Int32Array.BYTES_PER_ELEMENT;case a.UNSIGNED_INT:return Uint32Array.BYTES_PER_ELEMENT;case a.FLOAT:return Float32Array.BYTES_PER_ELEMENT;case a.DOUBLE:return Float64Array.BYTES_PER_ELEMENT;default:throw new r("componentDatatype is not a valid value.")}},fromTypedArray:function(e){return e instanceof Int8Array?a.BYTE:e instanceof Uint8Array?a.UNSIGNED_BYTE:e instanceof Int16Array?a.SHORT:e instanceof Uint16Array?a.UNSIGNED_SHORT:e instanceof Int32Array?a.INT:e instanceof Uint32Array?a.UNSIGNED_INT:e instanceof Float32Array?a.FLOAT:e instanceof Float64Array?a.DOUBLE:void 0},validate:function(e){return t(e)&&(e===a.BYTE||e===a.UNSIGNED_BYTE||e===a.SHORT||e===a.UNSIGNED_SHORT||e===a.INT||e===a.UNSIGNED_INT||e===a.FLOAT||e===a.DOUBLE)},createTypedArray:function(e,n){if(!t(e))throw new r("componentDatatype is required.");if(!t(n))throw new r("valuesOrLength is required.");switch(e){case a.BYTE:return new Int8Array(n);case a.UNSIGNED_BYTE:return new Uint8Array(n);case a.SHORT:return new Int16Array(n);case a.UNSIGNED_SHORT:return new Uint16Array(n);case a.INT:return new Int32Array(n);case a.UNSIGNED_INT:return new Uint32Array(n);case a.FLOAT:return new Float32Array(n);case a.DOUBLE:return new Float64Array(n);default:throw new r("componentDatatype is not a valid value.")}},createArrayBufferView:function(n,o,i,s){if(!t(n))throw new r("componentDatatype is required.");if(!t(o))throw new r("buffer is required.");switch(i=e(i,0),s=e(s,(o.byteLength-i)/a.getSizeInBytes(n)),n){case a.BYTE:return new Int8Array(o,i,s);case a.UNSIGNED_BYTE:return new Uint8Array(o,i,s);case a.SHORT:return new Int16Array(o,i,s);case a.UNSIGNED_SHORT:return new Uint16Array(o,i,s);case a.INT:return new Int32Array(o,i,s);case a.UNSIGNED_INT:return new Uint32Array(o,i,s);case a.FLOAT:return new Float32Array(o,i,s);case a.DOUBLE:return new Float64Array(o,i,s);default:throw new r("componentDatatype is not a valid value.")}},fromName:function(e){switch(e){case"BYTE":return a.BYTE;case"UNSIGNED_BYTE":return a.UNSIGNED_BYTE;case"SHORT":return a.SHORT;case"UNSIGNED_SHORT":return a.UNSIGNED_SHORT;case"INT":return a.INT;case"UNSIGNED_INT":return a.UNSIGNED_INT;case"FLOAT":return a.FLOAT;case"DOUBLE":return a.DOUBLE;default:throw new r("name is not a valid value.")}}};return o(a)})),define("Core/Cartesian2",["./Check","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],(function(e,t,r,n,o,i){"use strict";function a(e,r){this.x=t(e,0),this.y=t(r,0)}a.fromElements=function(e,t,n){return r(n)?(n.x=e,n.y=t,n):new a(e,t)},a.clone=function(e,t){if(r(e))return r(t)?(t.x=e.x,t.y=e.y,t):new a(e.x,e.y)},a.fromCartesian3=a.clone,a.fromCartesian4=a.clone,a.packedLength=2,a.pack=function(r,n,o){return e.typeOf.object("value",r),e.defined("array",n),o=t(o,0),n[o++]=r.x,n[o]=r.y,n},a.unpack=function(n,o,i){return e.defined("array",n),o=t(o,0),r(i)||(i=new a),i.x=n[o++],i.y=n[o],i},a.packArray=function(t,n){e.defined("array",t);var o=t.length;r(n)?n.length=2*o:n=new Array(2*o);for(var i=0;i<o;++i)a.pack(t[i],n,2*i);return n},a.unpackArray=function(t,n){e.defined("array",t);var o=t.length;r(n)?n.length=o/2:n=new Array(o/2);for(var i=0;i<o;i+=2){var s=i/2;n[s]=a.unpack(t,i,n[s])}return n},a.fromArray=a.unpack,a.maximumComponent=function(t){return e.typeOf.object("cartesian",t),Math.max(t.x,t.y)},a.minimumComponent=function(t){return e.typeOf.object("cartesian",t),Math.min(t.x,t.y)},a.minimumByComponent=function(t,r,n){return e.typeOf.object("first",t),e.typeOf.object("second",r),e.typeOf.object("result",n),n.x=Math.min(t.x,r.x),n.y=Math.min(t.y,r.y),n},a.maximumByComponent=function(t,r,n){return e.typeOf.object("first",t),e.typeOf.object("second",r),e.typeOf.object("result",n),n.x=Math.max(t.x,r.x),n.y=Math.max(t.y,r.y),n},a.magnitudeSquared=function(t){return e.typeOf.object("cartesian",t),t.x*t.x+t.y*t.y},a.magnitude=function(e){return Math.sqrt(a.magnitudeSquared(e))};var s=new a;a.distance=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),a.subtract(t,r,s),a.magnitude(s)},a.distanceSquared=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),a.subtract(t,r,s),a.magnitudeSquared(s)},a.normalize=function(t,r){e.typeOf.object("cartesian",t),e.typeOf.object("result",r);var o=a.magnitude(t);if(r.x=t.x/o,r.y=t.y/o,isNaN(r.x)||isNaN(r.y))throw new n("normalized result is not a number");return r},a.dot=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),t.x*r.x+t.y*r.y},a.multiplyComponents=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x*r.x,n.y=t.y*r.y,n},a.divideComponents=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x/r.x,n.y=t.y/r.y,n},a.add=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x+r.x,n.y=t.y+r.y,n},a.subtract=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x-r.x,n.y=t.y-r.y,n},a.multiplyByScalar=function(t,r,n){return e.typeOf.object("cartesian",t),e.typeOf.number("scalar",r),e.typeOf.object("result",n),n.x=t.x*r,n.y=t.y*r,n},a.divideByScalar=function(t,r,n){return e.typeOf.object("cartesian",t),e.typeOf.number("scalar",r),e.typeOf.object("result",n),n.x=t.x/r,n.y=t.y/r,n},a.negate=function(t,r){return e.typeOf.object("cartesian",t),e.typeOf.object("result",r),r.x=-t.x,r.y=-t.y,r},a.abs=function(t,r){return e.typeOf.object("cartesian",t),e.typeOf.object("result",r),r.x=Math.abs(t.x),r.y=Math.abs(t.y),r};var u=new a;a.lerp=function(t,r,n,o){return e.typeOf.object("start",t),e.typeOf.object("end",r),e.typeOf.number("t",n),e.typeOf.object("result",o),a.multiplyByScalar(r,n,u),o=a.multiplyByScalar(t,1-n,o),a.add(u,o,o)};var c=new a,f=new a;a.angleBetween=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),a.normalize(t,c),a.normalize(r,f),i.acosClamped(a.dot(c,f))};var l=new a;return a.mostOrthogonalAxis=function(t,r){e.typeOf.object("cartesian",t),e.typeOf.object("result",r);var n=a.normalize(t,l);return a.abs(n,n),r=n.x<=n.y?a.clone(a.UNIT_X,r):a.clone(a.UNIT_Y,r)},a.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y},a.equalsArray=function(e,t,r){return e.x===t[r]&&e.y===t[r+1]},a.equalsEpsilon=function(e,t,n,o){return e===t||r(e)&&r(t)&&i.equalsEpsilon(e.x,t.x,n,o)&&i.equalsEpsilon(e.y,t.y,n,o)},a.ZERO=o(new a(0,0)),a.UNIT_X=o(new a(1,0)),a.UNIT_Y=o(new a(0,1)),a.prototype.clone=function(e){return a.clone(this,e)},a.prototype.equals=function(e){return a.equals(this,e)},a.prototype.equalsEpsilon=function(e,t,r){return a.equalsEpsilon(this,e,t,r)},a.prototype.toString=function(){return"("+this.x+", "+this.y+")"},a})),define("Core/GeometryOffsetAttribute",["../Core/freezeObject"],(function(e){"use strict";return e({NONE:0,TOP:1,ALL:2})})),define("Core/GeometryType",["./freezeObject"],(function(e){"use strict";return e({NONE:0,TRIANGLES:1,LINES:2,POLYLINES:3})})),define("Core/Matrix2",["./Cartesian2","./Check","./defaultValue","./defined","./defineProperties","./freezeObject"],(function(e,t,r,n,o,i){"use strict";function a(e,t,n,o){this[0]=r(e,0),this[1]=r(n,0),this[2]=r(t,0),this[3]=r(o,0)}a.packedLength=4,a.pack=function(e,n,o){return t.typeOf.object("value",e),t.defined("array",n),o=r(o,0),n[o++]=e[0],n[o++]=e[1],n[o++]=e[2],n[o++]=e[3],n},a.unpack=function(e,o,i){return t.defined("array",e),o=r(o,0),n(i)||(i=new a),i[0]=e[o++],i[1]=e[o++],i[2]=e[o++],i[3]=e[o++],i},a.clone=function(e,t){if(n(e))return n(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t):new a(e[0],e[2],e[1],e[3])},a.fromArray=function(e,o,i){return t.defined("array",e),o=r(o,0),n(i)||(i=new a),i[0]=e[o],i[1]=e[o+1],i[2]=e[o+2],i[3]=e[o+3],i},a.fromColumnMajorArray=function(e,r){return t.defined("values",e),a.clone(e,r)},a.fromRowMajorArray=function(e,r){return t.defined("values",e),n(r)?(r[0]=e[0],r[1]=e[2],r[2]=e[1],r[3]=e[3],r):new a(e[0],e[1],e[2],e[3])},a.fromScale=function(e,r){return t.typeOf.object("scale",e),n(r)?(r[0]=e.x,r[1]=0,r[2]=0,r[3]=e.y,r):new a(e.x,0,0,e.y)},a.fromUniformScale=function(e,r){return t.typeOf.number("scale",e),n(r)?(r[0]=e,r[1]=0,r[2]=0,r[3]=e,r):new a(e,0,0,e)},a.fromRotation=function(e,r){t.typeOf.number("angle",e);var o=Math.cos(e),i=Math.sin(e);return n(r)?(r[0]=o,r[1]=i,r[2]=-i,r[3]=o,r):new a(o,-i,i,o)},a.toArray=function(e,r){return t.typeOf.object("matrix",e),n(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r):[e[0],e[1],e[2],e[3]]},a.getElementIndex=function(e,r){return t.typeOf.number.greaterThanOrEquals("row",r,0),t.typeOf.number.lessThanOrEquals("row",r,1),t.typeOf.number.greaterThanOrEquals("column",e,0),t.typeOf.number.lessThanOrEquals("column",e,1),2*e+r},a.getColumn=function(e,r,n){t.typeOf.object("matrix",e),t.typeOf.number.greaterThanOrEquals("index",r,0),t.typeOf.number.lessThanOrEquals("index",r,1),t.typeOf.object("result",n);var o=2*r,i=e[o],a=e[o+1];return n.x=i,n.y=a,n},a.setColumn=function(e,r,n,o){t.typeOf.object("matrix",e),t.typeOf.number.greaterThanOrEquals("index",r,0),t.typeOf.number.lessThanOrEquals("index",r,1),t.typeOf.object("cartesian",n),t.typeOf.object("result",o);var i=2*r;return(o=a.clone(e,o))[i]=n.x,o[i+1]=n.y,o},a.getRow=function(e,r,n){t.typeOf.object("matrix",e),t.typeOf.number.greaterThanOrEquals("index",r,0),t.typeOf.number.lessThanOrEquals("index",r,1),t.typeOf.object("result",n);var o=e[r],i=e[r+2];return n.x=o,n.y=i,n},a.setRow=function(e,r,n,o){return t.typeOf.object("matrix",e),t.typeOf.number.greaterThanOrEquals("index",r,0),t.typeOf.number.lessThanOrEquals("index",r,1),t.typeOf.object("cartesian",n),t.typeOf.object("result",o),(o=a.clone(e,o))[r]=n.x,o[r+2]=n.y,o};var s=new e;a.getScale=function(r,n){return t.typeOf.object("matrix",r),t.typeOf.object("result",n),n.x=e.magnitude(e.fromElements(r[0],r[1],s)),n.y=e.magnitude(e.fromElements(r[2],r[3],s)),n};var u=new e;return a.getMaximumScale=function(t){return a.getScale(t,u),e.maximumComponent(u)},a.multiply=function(e,r,n){t.typeOf.object("left",e),t.typeOf.object("right",r),t.typeOf.object("result",n);var o=e[0]*r[0]+e[2]*r[1],i=e[0]*r[2]+e[2]*r[3],a=e[1]*r[0]+e[3]*r[1],s=e[1]*r[2]+e[3]*r[3];return n[0]=o,n[1]=a,n[2]=i,n[3]=s,n},a.add=function(e,r,n){return t.typeOf.object("left",e),t.typeOf.object("right",r),t.typeOf.object("result",n),n[0]=e[0]+r[0],n[1]=e[1]+r[1],n[2]=e[2]+r[2],n[3]=e[3]+r[3],n},a.subtract=function(e,r,n){return t.typeOf.object("left",e),t.typeOf.object("right",r),t.typeOf.object("result",n),n[0]=e[0]-r[0],n[1]=e[1]-r[1],n[2]=e[2]-r[2],n[3]=e[3]-r[3],n},a.multiplyByVector=function(e,r,n){t.typeOf.object("matrix",e),t.typeOf.object("cartesian",r),t.typeOf.object("result",n);var o=e[0]*r.x+e[2]*r.y,i=e[1]*r.x+e[3]*r.y;return n.x=o,n.y=i,n},a.multiplyByScalar=function(e,r,n){return t.typeOf.object("matrix",e),t.typeOf.number("scalar",r),t.typeOf.object("result",n),n[0]=e[0]*r,n[1]=e[1]*r,n[2]=e[2]*r,n[3]=e[3]*r,n},a.multiplyByScale=function(e,r,n){return t.typeOf.object("matrix",e),t.typeOf.object("scale",r),t.typeOf.object("result",n),n[0]=e[0]*r.x,n[1]=e[1]*r.x,n[2]=e[2]*r.y,n[3]=e[3]*r.y,n},a.negate=function(e,r){return t.typeOf.object("matrix",e),t.typeOf.object("result",r),r[0]=-e[0],r[1]=-e[1],r[2]=-e[2],r[3]=-e[3],r},a.transpose=function(e,r){t.typeOf.object("matrix",e),t.typeOf.object("result",r);var n=e[0],o=e[2],i=e[1],a=e[3];return r[0]=n,r[1]=o,r[2]=i,r[3]=a,r},a.abs=function(e,r){return t.typeOf.object("matrix",e),t.typeOf.object("result",r),r[0]=Math.abs(e[0]),r[1]=Math.abs(e[1]),r[2]=Math.abs(e[2]),r[3]=Math.abs(e[3]),r},a.equals=function(e,t){return e===t||n(e)&&n(t)&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[3]===t[3]},a.equalsArray=function(e,t,r){return e[0]===t[r]&&e[1]===t[r+1]&&e[2]===t[r+2]&&e[3]===t[r+3]},a.equalsEpsilon=function(e,r,o){return t.typeOf.number("epsilon",o),e===r||n(e)&&n(r)&&Math.abs(e[0]-r[0])<=o&&Math.abs(e[1]-r[1])<=o&&Math.abs(e[2]-r[2])<=o&&Math.abs(e[3]-r[3])<=o},a.IDENTITY=i(new a(1,0,0,1)),a.ZERO=i(new a(0,0,0,0)),a.COLUMN0ROW0=0,a.COLUMN0ROW1=1,a.COLUMN1ROW0=2,a.COLUMN1ROW1=3,o(a.prototype,{length:{get:function(){return a.packedLength}}}),a.prototype.clone=function(e){return a.clone(this,e)},a.prototype.equals=function(e){return a.equals(this,e)},a.prototype.equalsEpsilon=function(e,t){return a.equalsEpsilon(this,e,t)},a.prototype.toString=function(){return"("+this[0]+", "+this[2]+")\n("+this[1]+", "+this[3]+")"},a})),define("Core/PrimitiveType",["./freezeObject","./WebGLConstants"],(function(e,t){"use strict";var r={POINTS:t.POINTS,LINES:t.LINES,LINE_LOOP:t.LINE_LOOP,LINE_STRIP:t.LINE_STRIP,TRIANGLES:t.TRIANGLES,TRIANGLE_STRIP:t.TRIANGLE_STRIP,TRIANGLE_FAN:t.TRIANGLE_FAN,validate:function(e){return e===r.POINTS||e===r.LINES||e===r.LINE_LOOP||e===r.LINE_STRIP||e===r.TRIANGLES||e===r.TRIANGLE_STRIP||e===r.TRIANGLE_FAN}};return e(r)})),define("Core/Quaternion",["./Cartesian3","./Check","./defaultValue","./defined","./FeatureDetection","./freezeObject","./Math","./Matrix3"],(function(e,t,r,n,o,i,a,s){"use strict";function u(e,t,n,o){this.x=r(e,0),this.y=r(t,0),this.z=r(n,0),this.w=r(o,0)}var c=new e;u.fromAxisAngle=function(r,o,i){t.typeOf.object("axis",r),t.typeOf.number("angle",o);var a=o/2,s=Math.sin(a),f=(c=e.normalize(r,c)).x*s,l=c.y*s,h=c.z*s,p=Math.cos(a);return n(i)?(i.x=f,i.y=l,i.z=h,i.w=p,i):new u(f,l,h,p)};var f=[1,2,0],l=new Array(3);u.fromRotationMatrix=function(e,r){var o,i,a,c,h;t.typeOf.object("matrix",e);var p=e[s.COLUMN0ROW0],d=e[s.COLUMN1ROW1],y=e[s.COLUMN2ROW2],m=p+d+y;if(m>0)h=.5*(o=Math.sqrt(m+1)),o=.5/o,i=(e[s.COLUMN1ROW2]-e[s.COLUMN2ROW1])*o,a=(e[s.COLUMN2ROW0]-e[s.COLUMN0ROW2])*o,c=(e[s.COLUMN0ROW1]-e[s.COLUMN1ROW0])*o;else{var E=0;d>p&&(E=1),y>p&&y>d&&(E=2);var O=f[E],_=f[O];o=Math.sqrt(e[s.getElementIndex(E,E)]-e[s.getElementIndex(O,O)]-e[s.getElementIndex(_,_)]+1);var T=l;T[E]=.5*o,o=.5/o,h=(e[s.getElementIndex(_,O)]-e[s.getElementIndex(O,_)])*o,T[O]=(e[s.getElementIndex(O,E)]+e[s.getElementIndex(E,O)])*o,T[_]=(e[s.getElementIndex(_,E)]+e[s.getElementIndex(E,_)])*o,i=-T[0],a=-T[1],c=-T[2]}return n(r)?(r.x=i,r.y=a,r.z=c,r.w=h,r):new u(i,a,c,h)};var h=new u,p=new u,d=new u,y=new u;u.fromHeadingPitchRoll=function(r,n){return t.typeOf.object("headingPitchRoll",r),y=u.fromAxisAngle(e.UNIT_X,r.roll,h),d=u.fromAxisAngle(e.UNIT_Y,-r.pitch,n),n=u.multiply(d,y,d),p=u.fromAxisAngle(e.UNIT_Z,-r.heading,h),u.multiply(p,n,n)};var m=new e,E=new e,O=new u,_=new u,T=new u;u.packedLength=4,u.pack=function(e,n,o){return t.typeOf.object("value",e),t.defined("array",n),o=r(o,0),n[o++]=e.x,n[o++]=e.y,n[o++]=e.z,n[o]=e.w,n},u.unpack=function(e,o,i){return t.defined("array",e),o=r(o,0),n(i)||(i=new u),i.x=e[o],i.y=e[o+1],i.z=e[o+2],i.w=e[o+3],i},u.packedInterpolationLength=3,u.convertPackedArrayForInterpolation=function(e,t,r,n){u.unpack(e,4*r,T),u.conjugate(T,T);for(var o=0,i=r-t+1;o<i;o++){var a=3*o;u.unpack(e,4*(t+o),O),u.multiply(O,T,O),O.w<0&&u.negate(O,O),u.computeAxis(O,m);var s=u.computeAngle(O);n[a]=m.x*s,n[a+1]=m.y*s,n[a+2]=m.z*s}},u.unpackInterpolationResult=function(t,r,o,i,a){n(a)||(a=new u),e.fromArray(t,0,E);var s=e.magnitude(E);return u.unpack(r,4*i,_),0===s?u.clone(u.IDENTITY,O):u.fromAxisAngle(E,s,O),u.multiply(O,_,a)},u.clone=function(e,t){if(n(e))return n(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t.w=e.w,t):new u(e.x,e.y,e.z,e.w)},u.conjugate=function(e,r){return t.typeOf.object("quaternion",e),t.typeOf.object("result",r),r.x=-e.x,r.y=-e.y,r.z=-e.z,r.w=e.w,r},u.magnitudeSquared=function(e){return t.typeOf.object("quaternion",e),e.x*e.x+e.y*e.y+e.z*e.z+e.w*e.w},u.magnitude=function(e){return Math.sqrt(u.magnitudeSquared(e))},u.normalize=function(e,r){t.typeOf.object("result",r);var n=1/u.magnitude(e),o=e.x*n,i=e.y*n,a=e.z*n,s=e.w*n;return r.x=o,r.y=i,r.z=a,r.w=s,r},u.inverse=function(e,r){t.typeOf.object("result",r);var n=u.magnitudeSquared(e);return r=u.conjugate(e,r),u.multiplyByScalar(r,1/n,r)},u.add=function(e,r,n){return t.typeOf.object("left",e),t.typeOf.object("right",r),t.typeOf.object("result",n),n.x=e.x+r.x,n.y=e.y+r.y,n.z=e.z+r.z,n.w=e.w+r.w,n},u.subtract=function(e,r,n){return t.typeOf.object("left",e),t.typeOf.object("right",r),t.typeOf.object("result",n),n.x=e.x-r.x,n.y=e.y-r.y,n.z=e.z-r.z,n.w=e.w-r.w,n},u.negate=function(e,r){return t.typeOf.object("quaternion",e),t.typeOf.object("result",r),r.x=-e.x,r.y=-e.y,r.z=-e.z,r.w=-e.w,r},u.dot=function(e,r){return t.typeOf.object("left",e),t.typeOf.object("right",r),e.x*r.x+e.y*r.y+e.z*r.z+e.w*r.w},u.multiply=function(e,r,n){t.typeOf.object("left",e),t.typeOf.object("right",r),t.typeOf.object("result",n);var o=e.x,i=e.y,a=e.z,s=e.w,u=r.x,c=r.y,f=r.z,l=r.w,h=s*u+o*l+i*f-a*c,p=s*c-o*f+i*l+a*u,d=s*f+o*c-i*u+a*l,y=s*l-o*u-i*c-a*f;return n.x=h,n.y=p,n.z=d,n.w=y,n},u.multiplyByScalar=function(e,r,n){return t.typeOf.object("quaternion",e),t.typeOf.number("scalar",r),t.typeOf.object("result",n),n.x=e.x*r,n.y=e.y*r,n.z=e.z*r,n.w=e.w*r,n},u.divideByScalar=function(e,r,n){return t.typeOf.object("quaternion",e),t.typeOf.number("scalar",r),t.typeOf.object("result",n),n.x=e.x/r,n.y=e.y/r,n.z=e.z/r,n.w=e.w/r,n},u.computeAxis=function(e,r){t.typeOf.object("quaternion",e),t.typeOf.object("result",r);var n=e.w;if(Math.abs(n-1)<a.EPSILON6)return r.x=r.y=r.z=0,r;var o=1/Math.sqrt(1-n*n);return r.x=e.x*o,r.y=e.y*o,r.z=e.z*o,r},u.computeAngle=function(e){return t.typeOf.object("quaternion",e),Math.abs(e.w-1)<a.EPSILON6?0:2*Math.acos(e.w)};var R=new u;u.lerp=function(e,r,n,o){return t.typeOf.object("start",e),t.typeOf.object("end",r),t.typeOf.number("t",n),t.typeOf.object("result",o),R=u.multiplyByScalar(r,n,R),o=u.multiplyByScalar(e,1-n,o),u.add(R,o,o)};var w=new u,g=new u,A=new u;u.slerp=function(e,r,n,o){t.typeOf.object("start",e),t.typeOf.object("end",r),t.typeOf.number("t",n),t.typeOf.object("result",o);var i=u.dot(e,r),s=r;if(i<0&&(i=-i,s=w=u.negate(r,w)),1-i<a.EPSILON6)return u.lerp(e,s,n,o);var c=Math.acos(i);return g=u.multiplyByScalar(e,Math.sin((1-n)*c),g),A=u.multiplyByScalar(s,Math.sin(n*c),A),o=u.add(g,A,o),u.multiplyByScalar(o,1/Math.sin(c),o)},u.log=function(r,n){t.typeOf.object("quaternion",r),t.typeOf.object("result",n);var o=a.acosClamped(r.w),i=0;return 0!==o&&(i=o/Math.sin(o)),e.multiplyByScalar(r,i,n)},u.exp=function(r,n){t.typeOf.object("cartesian",r),t.typeOf.object("result",n);var o=e.magnitude(r),i=0;return 0!==o&&(i=Math.sin(o)/o),n.x=r.x*i,n.y=r.y*i,n.z=r.z*i,n.w=Math.cos(o),n};var S=new e,b=new e,C=new u,v=new u;u.computeInnerQuadrangle=function(r,n,o,i){t.typeOf.object("q0",r),t.typeOf.object("q1",n),t.typeOf.object("q2",o),t.typeOf.object("result",i);var a=u.conjugate(n,C);u.multiply(a,o,v);var s=u.log(v,S);u.multiply(a,r,v);var c=u.log(v,b);return e.add(s,c,s),e.multiplyByScalar(s,.25,s),e.negate(s,s),u.exp(s,C),u.multiply(n,C,i)},u.squad=function(e,r,n,o,i,a){t.typeOf.object("q0",e),t.typeOf.object("q1",r),t.typeOf.object("s0",n),t.typeOf.object("s1",o),t.typeOf.number("t",i),t.typeOf.object("result",a);var s=u.slerp(e,r,i,C),c=u.slerp(n,o,i,v);return u.slerp(s,c,2*i*(1-i),a)};for(var N=new u,I=1.9011074535173003,M=o.supportsTypedArrays()?new Float32Array(8):[],x=o.supportsTypedArrays()?new Float32Array(8):[],P=o.supportsTypedArrays()?new Float32Array(8):[],D=o.supportsTypedArrays()?new Float32Array(8):[],F=0;F<7;++F){var U=F+1,L=2*U+1;M[F]=1/(U*L),x[F]=U/L}return M[7]=I/136,x[7]=8*I/17,u.fastSlerp=function(e,r,n,o){t.typeOf.object("start",e),t.typeOf.object("end",r),t.typeOf.number("t",n),t.typeOf.object("result",o);var i,a=u.dot(e,r);a>=0?i=1:(i=-1,a=-a);for(var s=a-1,c=1-n,f=n*n,l=c*c,h=7;h>=0;--h)P[h]=(M[h]*f-x[h])*s,D[h]=(M[h]*l-x[h])*s;var p=i*n*(1+P[0]*(1+P[1]*(1+P[2]*(1+P[3]*(1+P[4]*(1+P[5]*(1+P[6]*(1+P[7])))))))),d=c*(1+D[0]*(1+D[1]*(1+D[2]*(1+D[3]*(1+D[4]*(1+D[5]*(1+D[6]*(1+D[7])))))))),y=u.multiplyByScalar(e,d,N);return u.multiplyByScalar(r,p,o),u.add(y,o,o)},u.fastSquad=function(e,r,n,o,i,a){t.typeOf.object("q0",e),t.typeOf.object("q1",r),t.typeOf.object("s0",n),t.typeOf.object("s1",o),t.typeOf.number("t",i),t.typeOf.object("result",a);var s=u.fastSlerp(e,r,i,C),c=u.fastSlerp(n,o,i,v);return u.fastSlerp(s,c,2*i*(1-i),a)},u.equals=function(e,t){return e===t||n(e)&&n(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z&&e.w===t.w},u.equalsEpsilon=function(e,r,o){return t.typeOf.number("epsilon",o),e===r||n(e)&&n(r)&&Math.abs(e.x-r.x)<=o&&Math.abs(e.y-r.y)<=o&&Math.abs(e.z-r.z)<=o&&Math.abs(e.w-r.w)<=o},u.ZERO=i(new u(0,0,0,0)),u.IDENTITY=i(new u(0,0,0,1)),u.prototype.clone=function(e){return u.clone(this,e)},u.prototype.equals=function(e){return u.equals(this,e)},u.prototype.equalsEpsilon=function(e,t){return u.equalsEpsilon(this,e,t)},u.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"},u})),
/**
  @license
  when.js - https://github.com/cujojs/when

  MIT License (c) copyright B Cavalier & J Hann

 * A lightweight CommonJS Promises/A and when() implementation
 * when is part of the cujo.js family of libraries (http://cujojs.com/)
 *
 * Licensed under the MIT License at:
 * http://www.opensource.org/licenses/mit-license.php
 *
 * @version 1.7.1
 */
function(e){"use strict";e("ThirdParty/when",[],(function(){var e,t;function r(e,t,r,o){return n(e).then(t,r,o)}function n(e){var t,r,u;return e instanceof o?t=e:s(e)?(r=a(),e.then((function(e){r.resolve(e)}),(function(e){r.reject(e)}),(function(e){r.progress(e)})),t=r.promise):(u=e,t=new o((function(e){try{return n(e?e(u):u)}catch(e){return i(e)}}))),t}function o(e){this.then=e}function i(e){return new o((function(t,r){try{return r?n(r(e)):i(e)}catch(e){return i(e)}}))}function a(){var e,t,r,s,u,c;return e=new o(f),t=[],r=[],s=function(e,n,o){var i,s;return i=a(),s="function"==typeof o?function(e){try{i.progress(o(e))}catch(e){i.progress(e)}}:function(e){i.progress(e)},t.push((function(t){t.then(e,n).then(i.resolve,i.reject,s)})),r.push(s),i.promise},u=function(e){return l(r,e),e},c=function(e){return e=n(e),s=e.then,c=n,u=p,l(t,e),r=t=void 0,e},{then:f,resolve:h,reject:d,progress:y,promise:e,resolver:{resolve:h,reject:d,progress:y}};function f(e,t,r){return s(e,t,r)}function h(e){return c(e)}function d(e){return c(i(e))}function y(e){return u(e)}}function s(e){return e&&"function"==typeof e.then}function u(e,t,n,o,i){return h(2,arguments),r(e,(function(e){var s,u,c,f,l,h,d,y,m,E;if(m=e.length>>>0,s=Math.max(0,Math.min(t,m)),c=[],u=m-s+1,f=[],l=a(),s)for(y=l.progress,d=function(e){f.push(e),--u||(h=d=p,l.reject(f))},h=function(e){c.push(e),--s||(h=d=p,l.resolve(c))},E=0;E<m;++E)E in e&&r(e[E],_,O,y);else l.resolve(c);return l.then(n,o,i);function O(e){d(e)}function _(e){h(e)}}))}function c(e,t,r,n){return h(1,arguments),f(e,d).then(t,r,n)}function f(e,t){return r(e,(function(e){var n,o,i,s,u,c;if(i=o=e.length>>>0,n=[],c=a(),i)for(s=function(e,o){r(e,t).then((function(e){n[o]=e,--i||c.resolve(n)}),c.reject)},u=0;u<o;u++)u in e?s(e[u],u):--i;else c.resolve(n);return c.promise}))}function l(e,t){for(var r,n=0;r=e[n++];)r(t)}function h(e,t){for(var r,n=t.length;n>e;)if(null!=(r=t[--n])&&"function"!=typeof r)throw new Error("arg "+n+" must be a function")}function p(){}function d(e){return e}return r.defer=a,r.resolve=n,r.reject=function(e){return r(e,i)},r.join=function(){return f(arguments,d)},r.all=c,r.map=f,r.reduce=function(n,o){var i=t.call(arguments,1);return r(n,(function(t){var n;return n=t.length,i[0]=function(e,t,i){return r(e,(function(e){return r(t,(function(t){return o(e,t,i,n)}))}))},e.apply(t,i)}))},r.any=function(e,t,r,n){return u(e,1,(function(e){return t?t(e[0]):e[0]}),r,n)},r.some=u,r.chain=function(e,t,n){var o=arguments.length>2;return r(e,(function(e){return e=o?n:e,t.resolve(e),e}),(function(e){return t.reject(e),i(e)}),t.progress)},r.isPromise=s,o.prototype={always:function(e,t){return this.then(e,e,t)},otherwise:function(e){return this.then(void 0,e)},yield:function(e){return this.then((function(){return e}))},spread:function(e){return this.then((function(t){return c(t,(function(t){return e.apply(void 0,t)}))}))}},t=[].slice,e=[].reduce||function(e){var t,r,n,o,i;if(i=0,o=(t=Object(this)).length>>>0,(r=arguments).length<=1)for(;;){if(i in t){n=t[i++];break}if(++i>=o)throw new TypeError}else n=r[1];for(;i<o;++i)i in t&&(n=e(n,t[i],i,t));return n},r}))}("function"==typeof define&&define.amd?define:function(e){"object"==typeof exports?module.exports=e():this.when=e()}),define("Core/binarySearch",["./Check"],(function(e){"use strict";return function(t,r,n){e.defined("array",t),e.defined("itemToFind",r),e.defined("comparator",n);for(var o,i,a=0,s=t.length-1;a<=s;)if((i=n(t[o=~~((a+s)/2)],r))<0)a=o+1;else{if(!(i>0))return o;s=o-1}return~(s+1)}})),define("Core/EarthOrientationParametersSample",[],(function(){"use strict";return function(e,t,r,n,o){this.xPoleWander=e,this.yPoleWander=t,this.xPoleOffset=r,this.yPoleOffset=n,this.ut1MinusUtc=o}})),
/**
@license
sprintf.js from the php.js project - https://github.com/kvz/phpjs
Directly from https://github.com/kvz/phpjs/blob/master/functions/strings/sprintf.js

php.js is copyright 2012 Kevin van Zonneveld.

Portions copyright Brett Zamir (http://brett-zamir.me), Kevin van Zonneveld
(http://kevin.vanzonneveld.net), Onno Marsman, Theriault, Michael White
(http://getsprink.com), Waldo Malqui Silva, Paulo Freitas, Jack, Jonas
Raoni Soares Silva (http://www.jsfromhell.com), Philip Peterson, Legaev
Andrey, Ates Goral (http://magnetiq.com), Alex, Ratheous, Martijn Wieringa,
Rafa? Kukawski (http://blog.kukawski.pl), lmeyrick
(https://sourceforge.net/projects/bcmath-js/), Nate, Philippe Baumann,
Enrique Gonzalez, Webtoolkit.info (http://www.webtoolkit.info/), Carlos R.
L. Rodrigues (http://www.jsfromhell.com), Ash Searle
(http://hexmen.com/blog/), Jani Hartikainen, travc, Ole Vrijenhoek,
Erkekjetter, Michael Grier, Rafa? Kukawski (http://kukawski.pl), Johnny
Mast (http://www.phpvrouwen.nl), T.Wild, d3x,
http://stackoverflow.com/questions/57803/how-to-convert-decimal-to-hex-in-javascript,
Rafa? Kukawski (http://blog.kukawski.pl/), stag019, pilus, WebDevHobo
(http://webdevhobo.blogspot.com/), marrtins, GeekFG
(http://geekfg.blogspot.com), Andrea Giammarchi
(http://webreflection.blogspot.com), Arpad Ray (mailto:arpad@php.net),
gorthaur, Paul Smith, Tim de Koning (http://www.kingsquare.nl), Joris, Oleg
Eremeev, Steve Hilder, majak, gettimeofday, KELAN, Josh Fraser
(http://onlineaspect.com/2007/06/08/auto-detect-a-time-zone-with-javascript/),
Marc Palau, Martin
(http://www.erlenwiese.de/), Breaking Par Consulting Inc
(http://www.breakingpar.com/bkp/home.nsf/0/87256B280015193F87256CFB006C45F7),
Chris, Mirek Slugen, saulius, Alfonso Jimenez
(http://www.alfonsojimenez.com), Diplom@t (http://difane.com/), felix,
Mailfaker (http://www.weedem.fr/), Tyler Akins (http://rumkin.com), Caio
Ariede (http://caioariede.com), Robin, Kankrelune
(http://www.webfaktory.info/), Karol Kowalski, Imgen Tata
(http://www.myipdf.com/), mdsjack (http://www.mdsjack.bo.it), Dreamer,
Felix Geisendoerfer (http://www.debuggable.com/felix), Lars Fischer, AJ,
David, Aman Gupta, Michael White, Public Domain
(http://www.json.org/json2.js), Steven Levithan
(http://blog.stevenlevithan.com), Sakimori, Pellentesque Malesuada,
Thunder.m, Dj (http://phpjs.org/functions/htmlentities:425#comment_134018),
Steve Clay, David James, Francois, class_exists, nobbler, T. Wild, Itsacon
(http://www.itsacon.net/), date, Ole Vrijenhoek (http://www.nervous.nl/),
Fox, Raphael (Ao RUDLER), Marco, noname, Mateusz "loonquawl" Zalega, Frank
Forte, Arno, ger, mktime, john (http://www.jd-tech.net), Nick Kolosov
(http://sammy.ru), marc andreu, Scott Cariss, Douglas Crockford
(http://javascript.crockford.com), madipta, Slawomir Kaniecki,
ReverseSyntax, Nathan, Alex Wilson, kenneth, Bayron Guevara, Adam Wallner
(http://web2.bitbaro.hu/), paulo kuong, jmweb, Lincoln Ramsay, djmix,
Pyerre, Jon Hohle, Thiago Mata (http://thiagomata.blog.com), lmeyrick
(https://sourceforge.net/projects/bcmath-js/this.), Linuxworld, duncan,
Gilbert, Sanjoy Roy, Shingo, sankai, Oskar Larsson H?gfeldt
(http://oskar-lh.name/), Denny Wardhana, 0m3r, Everlasto, Subhasis Deb,
josh, jd, Pier Paolo Ramon (http://www.mastersoup.com/), P, merabi, Soren
Hansen, Eugene Bulkin (http://doubleaw.com/), Der Simon
(http://innerdom.sourceforge.net/), echo is bad, Ozh, XoraX
(http://www.xorax.info), EdorFaus, JB, J A R, Marc Jansen, Francesco, LH,
Stoyan Kyosev (http://www.svest.org/), nord_ua, omid
(http://phpjs.org/functions/380:380#comment_137122), Brad Touesnard, MeEtc
(http://yass.meetcweb.com), Peter-Paul Koch
(http://www.quirksmode.org/js/beat.html), Olivier Louvignes
(http://mg-crea.com/), T0bsn, Tim Wiel, Bryan Elliott, Jalal Berrami,
Martin, JT, David Randall, Thomas Beaucourt (http://www.webapp.fr), taith,
vlado houba, Pierre-Luc Paour, Kristof Coomans (SCK-CEN Belgian Nucleair
Research Centre), Martin Pool, Kirk Strobeck, Rick Waldron, Brant Messenger
(http://www.brantmessenger.com/), Devan Penner-Woelk, Saulo Vallory, Wagner
B. Soares, Artur Tchernychev, Valentina De Rosa, Jason Wong
(http://carrot.org/), Christoph, Daniel Esteban, strftime, Mick@el, rezna,
Simon Willison (http://simonwillison.net), Anton Ongson, Gabriel Paderni,
Marco van Oort, penutbutterjelly, Philipp Lenssen, Bjorn Roesbeke
(http://www.bjornroesbeke.be/), Bug?, Eric Nagel, Tomasz Wesolowski,
Evertjan Garretsen, Bobby Drake, Blues (http://tech.bluesmoon.info/), Luke
Godfrey, Pul, uestla, Alan C, Ulrich, Rafal Kukawski, Yves Sucaet,
sowberry, Norman "zEh" Fuchs, hitwork, Zahlii, johnrembo, Nick Callen,
Steven Levithan (stevenlevithan.com), ejsanders, Scott Baker, Brian Tafoya
(http://www.premasolutions.com/), Philippe Jausions
(http://pear.php.net/user/jausions), Aidan Lister
(http://aidanlister.com/), Rob, e-mike, HKM, ChaosNo1, metjay, strcasecmp,
strcmp, Taras Bogach, jpfle, Alexander Ermolaev
(http://snippets.dzone.com/user/AlexanderErmolaev), DxGx, kilops, Orlando,
dptr1988, Le Torbi, James (http://www.james-bell.co.uk/), Pedro Tainha
(http://www.pedrotainha.com), James, Arnout Kazemier
(http://www.3rd-Eden.com), Chris McMacken, gabriel paderni, Yannoo,
FGFEmperor, baris ozdil, Tod Gentille, Greg Frazier, jakes, 3D-GRAF, Allan
Jensen (http://www.winternet.no), Howard Yeend, Benjamin Lupton, davook,
daniel airton wermann (http://wermann.com.br), Atli T¨®r, Maximusya, Ryan
W Tenney (http://ryan.10e.us), Alexander M Beedie, fearphage
(http://http/my.opera.com/fearphage/), Nathan Sepulveda, Victor, Matteo,
Billy, stensi, Cord, Manish, T.J. Leahy, Riddler
(http://www.frontierwebdev.com/), Rafa? Kukawski, FremyCompany, Matt
Bradley, Tim de Koning, Luis Salazar (http://www.freaky-media.com/), Diogo
Resende, Rival, Andrej Pavlovic, Garagoth, Le Torbi
(http://www.letorbi.de/), Dino, Josep Sanz (http://www.ws3.es/), rem,
Russell Walker (http://www.nbill.co.uk/), Jamie Beck
(http://www.terabit.ca/), setcookie, Michael, YUI Library:
http://developer.yahoo.com/yui/docs/YAHOO.util.DateLocale.html, Blues at
http://hacks.bluesmoon.info/strftime/strftime.js, Ben
(http://benblume.co.uk/), DtTvB
(http://dt.in.th/2008-09-16.string-length-in-bytes.html), Andreas, William,
meo, incidence, Cagri Ekin, Amirouche, Amir Habibi
(http://www.residence-mixte.com/), Luke Smith (http://lucassmith.name),
Kheang Hok Chin (http://www.distantia.ca/), Jay Klehr, Lorenzo Pisani,
Tony, Yen-Wei Liu, Greenseed, mk.keck, Leslie Hoare, dude, booeyOH, Ben
Bryan

Licensed under the MIT (MIT-LICENSE.txt) license.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL KEVIN VAN ZONNEVELD BE LIABLE FOR ANY CLAIM, DAMAGES
OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.
*/
define("ThirdParty/sprintf",[],(function(){return function(){var e=/%%|%(\d+\$)?([-+\'#0 ]*)(\*\d+\$|\*|\d+)?(\.(\*\d+\$|\*|\d+))?([scboxXuideEfFgG])/g,t=arguments,r=0,n=t[r++],o=function(e,t,r,n){r||(r=" ");var o=e.length>=t?"":Array(1+t-e.length>>>0).join(r);return n?e+o:o+e},i=function(e,t,r,n,i,a){var s=n-e.length;return s>0&&(e=r||!i?o(e,n,a,r):e.slice(0,t.length)+o("",s,"0",!0)+e.slice(t.length)),e},a=function(e,t,r,n,a,s,u){var c=e>>>0;return e=(r=r&&c&&{2:"0b",8:"0",16:"0x"}[t]||"")+o(c.toString(t),s||0,"0",!1),i(e,r,n,a,u)},s=function(e,t,r,n,o,a){return null!=n&&(e=e.slice(0,n)),i(e,"",t,r,o,a)},u=function(e,n,u,c,f,l,h){var p,d,y,m,E;if("%%"==e)return"%";for(var O=!1,_="",T=!1,R=!1,w=" ",g=u.length,A=0;u&&A<g;A++)switch(u.charAt(A)){case" ":_=" ";break;case"+":_="+";break;case"-":O=!0;break;case"'":w=u.charAt(A+1);break;case"0":T=!0;break;case"#":R=!0}if((c=c?"*"==c?+t[r++]:"*"==c.charAt(0)?+t[c.slice(1,-1)]:+c:0)<0&&(c=-c,O=!0),!isFinite(c))throw new Error("sprintf: (minimum-)width must be finite");switch(l=l?"*"==l?+t[r++]:"*"==l.charAt(0)?+t[l.slice(1,-1)]:+l:"fFeE".indexOf(h)>-1?6:"d"==h?0:void 0,E=n?t[n.slice(0,-1)]:t[r++],h){case"s":return s(String(E),O,c,l,T,w);case"c":return s(String.fromCharCode(+E),O,c,l,T);case"b":return a(E,2,R,O,c,l,T);case"o":return a(E,8,R,O,c,l,T);case"x":return a(E,16,R,O,c,l,T);case"X":return a(E,16,R,O,c,l,T).toUpperCase();case"u":return a(E,10,R,O,c,l,T);case"i":case"d":return p=+E||0,E=(d=(p=Math.round(p-p%1))<0?"-":_)+o(String(Math.abs(p)),l,"0",!1),i(E,d,O,c,T);case"e":case"E":case"f":case"F":case"g":case"G":return d=(p=+E)<0?"-":_,y=["toExponential","toFixed","toPrecision"]["efg".indexOf(h.toLowerCase())],m=["toString","toUpperCase"]["eEfFgG".indexOf(h)%2],E=d+Math.abs(p)[y](l),i(E,d,O,c,T)[m]();default:return e}};return n.replace(e,u)}})),define("Core/GregorianDate",[],(function(){"use strict";return function(e,t,r,n,o,i,a,s){this.year=e,this.month=t,this.day=r,this.hour=n,this.minute=o,this.second=i,this.millisecond=a,this.isLeapSecond=s}})),define("Core/isLeapYear",["./DeveloperError"],(function(e){"use strict";return function(t){if(null===t||isNaN(t))throw new e("year is required and must be a number.");return t%4==0&&t%100!=0||t%400==0}})),define("Core/LeapSecond",[],(function(){"use strict";return function(e,t){this.julianDate=e,this.offset=t}})),define("Core/TimeConstants",["./freezeObject"],(function(e){"use strict";return e({SECONDS_PER_MILLISECOND:.001,SECONDS_PER_MINUTE:60,MINUTES_PER_HOUR:60,HOURS_PER_DAY:24,SECONDS_PER_HOUR:3600,MINUTES_PER_DAY:1440,SECONDS_PER_DAY:86400,DAYS_PER_JULIAN_CENTURY:36525,PICOSECOND:1e-9,MODIFIED_JULIAN_DATE_DIFFERENCE:2400000.5})})),define("Core/TimeStandard",["./freezeObject"],(function(e){"use strict";return e({UTC:0,TAI:1})})),define("Core/JulianDate",["../ThirdParty/sprintf","./binarySearch","./defaultValue","./defined","./DeveloperError","./GregorianDate","./isLeapYear","./LeapSecond","./TimeConstants","./TimeStandard"],(function(e,t,r,n,o,i,a,s,u,c){"use strict";var f=new i,l=[31,28,31,30,31,30,31,31,30,31,30,31];function h(e,t){return v.compare(e.julianDate,t.julianDate)}var p=new s;function d(e){p.julianDate=e;var r=v.leapSeconds,n=t(r,p,h);n<0&&(n=~n),n>=r.length&&(n=r.length-1);var o=r[n].offset;n>0&&v.secondsDifference(r[n].julianDate,e)>o&&(o=r[--n].offset),v.addSeconds(e,o,e)}function y(e,r){p.julianDate=e;var n=v.leapSeconds,o=t(n,p,h);if(o<0&&(o=~o),0===o)return v.addSeconds(e,-n[0].offset,r);if(o>=n.length)return v.addSeconds(e,-n[o-1].offset,r);var i=v.secondsDifference(n[o].julianDate,e);return 0===i?v.addSeconds(e,-n[o].offset,r):i<=1?void 0:v.addSeconds(e,-n[--o].offset,r)}function m(e,t,r){var n=t/u.SECONDS_PER_DAY|0;return e+=n,(t-=u.SECONDS_PER_DAY*n)<0&&(e--,t+=u.SECONDS_PER_DAY),r.dayNumber=e,r.secondsOfDay=t,r}function E(e,t,r,n,o,i,a){var s=(t-14)/12|0,c=e+4800+s,f=(1461*c/4|0)+(367*(t-2-12*s)/12|0)-(3*((c+100)/100|0)/4|0)+r-32075;(n-=12)<0&&(n+=24);var l=i+(n*u.SECONDS_PER_HOUR+o*u.SECONDS_PER_MINUTE+a*u.SECONDS_PER_MILLISECOND);return l>=43200&&(f-=1),[f,l]}var O=/^(\d{4})$/,_=/^(\d{4})-(\d{2})$/,T=/^(\d{4})-?(\d{3})$/,R=/^(\d{4})-?W(\d{2})-?(\d{1})?$/,w=/^(\d{4})-?(\d{2})-?(\d{2})$/,g=/([Z+\-])?(\d{2})?:?(\d{2})?$/,A=/^(\d{2})(\.\d+)?/.source+g.source,S=/^(\d{2}):?(\d{2})(\.\d+)?/.source+g.source,b=/^(\d{2}):?(\d{2}):?(\d{2})(\.\d+)?/.source+g.source,C="Invalid ISO 8601 date.";function v(e,t,n){this.dayNumber=void 0,this.secondsOfDay=void 0,e=r(e,0),t=r(t,0),n=r(n,c.UTC);var o=0|e;m(o,t+=(e-o)*u.SECONDS_PER_DAY,this),n===c.UTC&&d(this)}v.fromGregorianDate=function(e,t){if(!(e instanceof i))throw new o("date must be a valid GregorianDate.");var r=E(e.year,e.month,e.day,e.hour,e.minute,e.second,e.millisecond);return n(t)?(m(r[0],r[1],t),d(t),t):new v(r[0],r[1],c.UTC)},v.fromDate=function(e,t){if(!(e instanceof Date)||isNaN(e.getTime()))throw new o("date must be a valid JavaScript Date.");var r=E(e.getUTCFullYear(),e.getUTCMonth()+1,e.getUTCDate(),e.getUTCHours(),e.getUTCMinutes(),e.getUTCSeconds(),e.getUTCMilliseconds());return n(t)?(m(r[0],r[1],t),d(t),t):new v(r[0],r[1],c.UTC)},v.fromIso8601=function(e,t){if("string"!=typeof e)throw new o(C);var r,i,s,u,f,h=(e=e.replace(",",".")).split("T"),p=1,y=1,g=0,N=0,I=0,M=0,x=h[0],P=h[1];if(!n(x))throw new o(C);if(null!==(h=x.match(w))){if((u=x.split("-").length-1)>0&&2!==u)throw new o(C);r=+h[1],p=+h[2],y=+h[3]}else if(null!==(h=x.match(_)))r=+h[1],p=+h[2];else if(null!==(h=x.match(O)))r=+h[1];else{var D;if(null!==(h=x.match(T))){if(r=+h[1],D=+h[2],s=a(r),D<1||s&&D>366||!s&&D>365)throw new o(C)}else{if(null===(h=x.match(R)))throw new o(C);r=+h[1];var F=+h[2],U=+h[3]||0;if((u=x.split("-").length-1)>0&&(!n(h[3])&&1!==u||n(h[3])&&2!==u))throw new o(C);D=7*F+U-new Date(Date.UTC(r,0,4)).getUTCDay()-3}(i=new Date(Date.UTC(r,0,1))).setUTCDate(D),p=i.getUTCMonth()+1,y=i.getUTCDate()}if(s=a(r),p<1||p>12||y<1||(2!==p||!s)&&y>l[p-1]||s&&2===p&&y>29)throw new o(C);if(n(P)){if(null!==(h=P.match(b))){if((u=P.split(":").length-1)>0&&2!==u&&3!==u)throw new o(C);g=+h[1],N=+h[2],I=+h[3],M=1e3*+(h[4]||0),f=5}else if(null!==(h=P.match(S))){if((u=P.split(":").length-1)>2)throw new o(C);g=+h[1],N=+h[2],I=60*+(h[3]||0),f=4}else{if(null===(h=P.match(A)))throw new o(C);g=+h[1],N=60*+(h[2]||0),f=3}if(N>=60||I>=61||g>24||24===g&&(N>0||I>0||M>0))throw new o(C);var L=h[f],q=+h[f+1],B=+(h[f+2]||0);switch(L){case"+":g-=q,N-=B;break;case"-":g+=q,N+=B;break;case"Z":break;default:N+=new Date(Date.UTC(r,p-1,y,g,N)).getTimezoneOffset()}}var j=60===I;for(j&&I--;N>=60;)N-=60,g++;for(;g>=24;)g-=24,y++;for(i=s&&2===p?29:l[p-1];y>i;)y-=i,++p>12&&(p-=12,r++),i=s&&2===p?29:l[p-1];for(;N<0;)N+=60,g--;for(;g<0;)g+=24,y--;for(;y<1;)--p<1&&(p+=12,r--),y+=i=s&&2===p?29:l[p-1];var z=E(r,p,y,g,N,I,M);return n(t)?(m(z[0],z[1],t),d(t)):t=new v(z[0],z[1],c.UTC),j&&v.addSeconds(t,1,t),t},v.now=function(e){return v.fromDate(new Date,e)};var N=new v(0,0,c.TAI);return v.toGregorianDate=function(e,t){if(!n(e))throw new o("julianDate is required.");var r=!1,a=y(e,N);n(a)||(v.addSeconds(e,-1,N),a=y(N,N),r=!0);var s=a.dayNumber,c=a.secondsOfDay;c>=43200&&(s+=1);var f=s+68569|0,l=4*f/146097|0,h=4e3*(1+(f=f-((146097*l+3)/4|0)|0))/1461001|0,p=80*(f=f-(1461*h/4|0)+31|0)/2447|0,d=f-(2447*p/80|0)|0,m=p+2-12*(f=p/11|0)|0,E=100*(l-49)+h+f|0,O=c/u.SECONDS_PER_HOUR|0,_=c-O*u.SECONDS_PER_HOUR,T=_/u.SECONDS_PER_MINUTE|0,R=0|(_-=T*u.SECONDS_PER_MINUTE),w=(_-R)/u.SECONDS_PER_MILLISECOND;return(O+=12)>23&&(O-=24),r&&(R+=1),n(t)?(t.year=E,t.month=m,t.day=d,t.hour=O,t.minute=T,t.second=R,t.millisecond=w,t.isLeapSecond=r,t):new i(E,m,d,O,T,R,w,r)},v.toDate=function(e){if(!n(e))throw new o("julianDate is required.");var t=v.toGregorianDate(e,f),r=t.second;return t.isLeapSecond&&(r-=1),new Date(Date.UTC(t.year,t.month-1,t.day,t.hour,t.minute,r,t.millisecond))},v.toIso8601=function(t,r){if(!n(t))throw new o("julianDate is required.");var i,a=v.toGregorianDate(t,f),s=a.year,u=a.month,c=a.day,l=a.hour,h=a.minute,p=a.second,d=a.millisecond;return 1e4===s&&1===u&&1===c&&0===l&&0===h&&0===p&&0===d&&(s=9999,u=12,c=31,l=24),n(r)||0===d?n(r)&&0!==r?(i=(.01*d).toFixed(r).replace(".","").slice(0,r),e("%04d-%02d-%02dT%02d:%02d:%02d.%sZ",s,u,c,l,h,p,i)):e("%04d-%02d-%02dT%02d:%02d:%02dZ",s,u,c,l,h,p):(i=(.01*d).toString().replace(".",""),e("%04d-%02d-%02dT%02d:%02d:%02d.%sZ",s,u,c,l,h,p,i))},v.clone=function(e,t){if(n(e))return n(t)?(t.dayNumber=e.dayNumber,t.secondsOfDay=e.secondsOfDay,t):new v(e.dayNumber,e.secondsOfDay,c.TAI)},v.compare=function(e,t){if(!n(e))throw new o("left is required.");if(!n(t))throw new o("right is required.");var r=e.dayNumber-t.dayNumber;return 0!==r?r:e.secondsOfDay-t.secondsOfDay},v.equals=function(e,t){return e===t||n(e)&&n(t)&&e.dayNumber===t.dayNumber&&e.secondsOfDay===t.secondsOfDay},v.equalsEpsilon=function(e,t,r){if(!n(r))throw new o("epsilon is required.");return e===t||n(e)&&n(t)&&Math.abs(v.secondsDifference(e,t))<=r},v.totalDays=function(e){if(!n(e))throw new o("julianDate is required.");return e.dayNumber+e.secondsOfDay/u.SECONDS_PER_DAY},v.secondsDifference=function(e,t){if(!n(e))throw new o("left is required.");if(!n(t))throw new o("right is required.");return(e.dayNumber-t.dayNumber)*u.SECONDS_PER_DAY+(e.secondsOfDay-t.secondsOfDay)},v.daysDifference=function(e,t){if(!n(e))throw new o("left is required.");if(!n(t))throw new o("right is required.");return e.dayNumber-t.dayNumber+(e.secondsOfDay-t.secondsOfDay)/u.SECONDS_PER_DAY},v.computeTaiMinusUtc=function(e){p.julianDate=e;var r=v.leapSeconds,n=t(r,p,h);return n<0&&(n=~n,--n<0&&(n=0)),r[n].offset},v.addSeconds=function(e,t,r){if(!n(e))throw new o("julianDate is required.");if(!n(t))throw new o("seconds is required.");if(!n(r))throw new o("result is required.");return m(e.dayNumber,e.secondsOfDay+t,r)},v.addMinutes=function(e,t,r){if(!n(e))throw new o("julianDate is required.");if(!n(t))throw new o("minutes is required.");if(!n(r))throw new o("result is required.");var i=e.secondsOfDay+t*u.SECONDS_PER_MINUTE;return m(e.dayNumber,i,r)},v.addHours=function(e,t,r){if(!n(e))throw new o("julianDate is required.");if(!n(t))throw new o("hours is required.");if(!n(r))throw new o("result is required.");var i=e.secondsOfDay+t*u.SECONDS_PER_HOUR;return m(e.dayNumber,i,r)},v.addDays=function(e,t,r){if(!n(e))throw new o("julianDate is required.");if(!n(t))throw new o("days is required.");if(!n(r))throw new o("result is required.");return m(e.dayNumber+t,e.secondsOfDay,r)},v.lessThan=function(e,t){return v.compare(e,t)<0},v.lessThanOrEquals=function(e,t){return v.compare(e,t)<=0},v.greaterThan=function(e,t){return v.compare(e,t)>0},v.greaterThanOrEquals=function(e,t){return v.compare(e,t)>=0},v.prototype.clone=function(e){return v.clone(this,e)},v.prototype.equals=function(e){return v.equals(this,e)},v.prototype.equalsEpsilon=function(e,t){return v.equalsEpsilon(this,e,t)},v.prototype.toString=function(){return v.toIso8601(this)},v.leapSeconds=[new s(new v(2441317,43210,c.TAI),10),new s(new v(2441499,43211,c.TAI),11),new s(new v(2441683,43212,c.TAI),12),new s(new v(2442048,43213,c.TAI),13),new s(new v(2442413,43214,c.TAI),14),new s(new v(2442778,43215,c.TAI),15),new s(new v(2443144,43216,c.TAI),16),new s(new v(2443509,43217,c.TAI),17),new s(new v(2443874,43218,c.TAI),18),new s(new v(2444239,43219,c.TAI),19),new s(new v(2444786,43220,c.TAI),20),new s(new v(2445151,43221,c.TAI),21),new s(new v(2445516,43222,c.TAI),22),new s(new v(2446247,43223,c.TAI),23),new s(new v(2447161,43224,c.TAI),24),new s(new v(2447892,43225,c.TAI),25),new s(new v(2448257,43226,c.TAI),26),new s(new v(2448804,43227,c.TAI),27),new s(new v(2449169,43228,c.TAI),28),new s(new v(2449534,43229,c.TAI),29),new s(new v(2450083,43230,c.TAI),30),new s(new v(2450630,43231,c.TAI),31),new s(new v(2451179,43232,c.TAI),32),new s(new v(2453736,43233,c.TAI),33),new s(new v(2454832,43234,c.TAI),34),new s(new v(2456109,43235,c.TAI),35),new s(new v(2457204,43236,c.TAI),36),new s(new v(2457754,43237,c.TAI),37)],v})),
/**
 * @license
 *
 * Grauw URI utilities
 *
 * See: http://hg.grauw.nl/grauw-lib/file/tip/src/uri.js
 *
 * @author Laurens Holst (http://www.grauw.nl/)
 *
 *   Copyright 2012 Laurens Holst
 *
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License.
 *
 */
define("ThirdParty/Uri",[],(function(){function e(r){if(r instanceof e)this.scheme=r.scheme,this.authority=r.authority,this.path=r.path,this.query=r.query,this.fragment=r.fragment;else if(r){var n=t.exec(r);this.scheme=n[1],this.authority=n[2],this.path=n[3],this.query=n[4],this.fragment=n[5]}}e.prototype.scheme=null,e.prototype.authority=null,e.prototype.path="",e.prototype.query=null,e.prototype.fragment=null;var t=new RegExp("^(?:([^:/?#]+):)?(?://([^/?#]*))?([^?#]*)(?:\\?([^#]*))?(?:#(.*))?$");e.prototype.getScheme=function(){return this.scheme},e.prototype.getAuthority=function(){return this.authority},e.prototype.getPath=function(){return this.path},e.prototype.getQuery=function(){return this.query},e.prototype.getFragment=function(){return this.fragment},e.prototype.isAbsolute=function(){return!!this.scheme&&!this.fragment},e.prototype.isSameDocumentAs=function(e){return e.scheme==this.scheme&&e.authority==this.authority&&e.path==this.path&&e.query==this.query},e.prototype.equals=function(e){return this.isSameDocumentAs(e)&&e.fragment==this.fragment},e.prototype.normalize=function(){this.removeDotSegments(),this.scheme&&(this.scheme=this.scheme.toLowerCase()),this.authority&&(this.authority=this.authority.replace(o,a).replace(r,i)),this.path&&(this.path=this.path.replace(r,i)),this.query&&(this.query=this.query.replace(r,i)),this.fragment&&(this.fragment=this.fragment.replace(r,i))};var r=/%[0-9a-z]{2}/gi,n=/[a-zA-Z0-9\-\._~]/,o=/(.*@)?([^@:]*)(:.*)?/;function i(e){var t=unescape(e);return n.test(t)?t:e.toUpperCase()}function a(e,t,r,n){return(t||"")+r.toLowerCase()+(n||"")}return e.prototype.resolve=function(t){var r=new e;return this.scheme?(r.scheme=this.scheme,r.authority=this.authority,r.path=this.path,r.query=this.query):(r.scheme=t.scheme,this.authority?(r.authority=this.authority,r.path=this.path,r.query=this.query):(r.authority=t.authority,""==this.path?(r.path=t.path,r.query=this.query||t.query):("/"==this.path.charAt(0)?(r.path=this.path,r.removeDotSegments()):(t.authority&&""==t.path?r.path="/"+this.path:r.path=t.path.substring(0,t.path.lastIndexOf("/")+1)+this.path,r.removeDotSegments()),r.query=this.query))),r.fragment=this.fragment,r},e.prototype.removeDotSegments=function(){var e,t=this.path.split("/"),r=[],n=""==t[0];for(n&&t.shift(),""==t[0]&&t.shift();t.length;)".."==(e=t.shift())?r.pop():"."!=e&&r.push(e);"."!=e&&".."!=e||r.push(""),n&&r.unshift(""),this.path=r.join("/")},e.prototype.toString=function(){var e="";return this.scheme&&(e+=this.scheme+":"),this.authority&&(e+="//"+this.authority),e+=this.path,this.query&&(e+="?"+this.query),this.fragment&&(e+="#"+this.fragment),e},e})),define("Core/appendForwardSlash",[],(function(){"use strict";return function(e){return 0!==e.length&&"/"===e[e.length-1]||(e+="/"),e}})),define("Core/clone",["./defaultValue"],(function(e){"use strict";return function t(r,n){if(null===r||"object"!=typeof r)return r;n=e(n,!1);var o=new r.constructor;for(var i in r)if(r.hasOwnProperty(i)){var a=r[i];n&&(a=t(a,n)),o[i]=a}return o}})),define("Core/combine",["./defaultValue","./defined"],(function(e,t){"use strict";return function r(n,o,i){i=e(i,!1);var a,s,u,c={},f=t(n),l=t(o);if(f)for(a in n)n.hasOwnProperty(a)&&(s=n[a],l&&i&&"object"==typeof s&&o.hasOwnProperty(a)?(u=o[a],c[a]="object"==typeof u?r(s,u,i):s):c[a]=s);if(l)for(a in o)o.hasOwnProperty(a)&&!c.hasOwnProperty(a)&&(u=o[a],c[a]=u);return c}})),define("Core/oneTimeWarning",["./defaultValue","./defined","./DeveloperError"],(function(e,t,r){"use strict";var n={};function o(o,i){if(!t(o))throw new r("identifier is required.");t(n[o])||(n[o]=!0,console.warn(e(i,o)))}return o.geometryOutlines="Entity geometry outlines are unsupported on terrain. Outlines will be disabled. To enable outlines, disable geometry terrain clamping by explicitly setting height to 0.",o.geometryZIndex="Entity geometry with zIndex are unsupported when height or extrudedHeight are defined.  zIndex will be ignored",o.geometryHeightReference="Entity corridor, ellipse, polygon or rectangle with heightReference must also have a defined height.  heightReference will be ignored",o.geometryExtrudedHeightReference="Entity corridor, ellipse, polygon or rectangle with extrudedHeightReference must also have a defined extrudedHeight.  extrudedHeightReference will be ignored",o})),define("Core/deprecationWarning",["./defined","./DeveloperError","./oneTimeWarning"],(function(e,t,r){"use strict";return function(n,o){if(!e(n)||!e(o))throw new t("identifier and message are required.");r(n,o)}})),define("Core/getAbsoluteUri",["../ThirdParty/Uri","./defaultValue","./defined","./DeveloperError"],(function(e,t,r,n){"use strict";function o(e,t){var r;return"undefined"!=typeof document&&(r=document),o._implementation(e,t,r)}return o._implementation=function(o,i,a){if(!r(o))throw new n("relative uri is required.");if(!r(i)){if(void 0===a)return o;i=t(a.baseURI,a.location.href)}var s=new e(i);return new e(o).resolve(s).toString()},o})),define("Core/getBaseUri",["../ThirdParty/Uri","./defined","./DeveloperError"],(function(e,t,r){"use strict";return function(n,o){if(!t(n))throw new r("uri is required.");var i="",a=n.lastIndexOf("/");return-1!==a&&(i=n.substring(0,a+1)),o?(n=new e(n),t(n.query)&&(i+="?"+n.query),t(n.fragment)&&(i+="#"+n.fragment),i):i}})),define("Core/getExtensionFromUri",["../ThirdParty/Uri","./defined","./DeveloperError"],(function(e,t,r){"use strict";return function(n){if(!t(n))throw new r("uri is required.");var o=new e(n);o.normalize();var i=o.path,a=i.lastIndexOf("/");return-1!==a&&(i=i.substr(a+1)),a=i.lastIndexOf("."),i=-1===a?"":i.substr(a+1)}})),define("Core/isBlobUri",["./Check"],(function(e){"use strict";var t=/^blob:/i;return function(r){return e.typeOf.string("uri",r),t.test(r)}})),define("Core/isCrossOriginUrl",["./defined"],(function(e){"use strict";var t;return function(r){e(t)||(t=document.createElement("a")),t.href=window.location.href;var n=t.host,o=t.protocol;return t.href=r,t.href=t.href,o!==t.protocol||n!==t.host}})),define("Core/isDataUri",["./Check"],(function(e){"use strict";var t=/^data:/i;return function(r){return e.typeOf.string("uri",r),t.test(r)}})),define("Core/loadAndExecuteScript",["../ThirdParty/when"],(function(e){"use strict";return function(t){var r=e.defer(),n=document.createElement("script");n.async=!0,n.src=t;var o=document.getElementsByTagName("head")[0];return n.onload=function(){n.onload=void 0,o.removeChild(n),r.resolve()},n.onerror=function(e){r.reject(e)},o.appendChild(n),r.promise}})),define("Core/isArray",["./defined"],(function(e){"use strict";var t=Array.isArray;return e(t)||(t=function(e){return"[object Array]"===Object.prototype.toString.call(e)}),t})),define("Core/objectToQuery",["./defined","./DeveloperError","./isArray"],(function(e,t,r){"use strict";return function(n){if(!e(n))throw new t("obj is required.");var o="";for(var i in n)if(n.hasOwnProperty(i)){var a=n[i],s=encodeURIComponent(i)+"=";if(r(a))for(var u=0,c=a.length;u<c;++u)o+=s+encodeURIComponent(a[u])+"&";else o+=s+encodeURIComponent(a)+"&"}return o=o.slice(0,-1)}})),define("Core/queryToObject",["./defined","./DeveloperError","./isArray"],(function(e,t,r){"use strict";return function(n){if(!e(n))throw new t("queryString is required.");var o={};if(""===n)return o;for(var i=n.replace(/\+/g,"%20").split(/[&;]/),a=0,s=i.length;a<s;++a){var u=i[a].split("="),c=decodeURIComponent(u[0]),f=u[1];f=e(f)?decodeURIComponent(f):"";var l=o[c];"string"==typeof l?o[c]=[l,f]:r(l)?l.push(f):o[c]=f}return o}})),define("Core/RequestState",["../Core/freezeObject"],(function(e){"use strict";return e({UNISSUED:0,ISSUED:1,ACTIVE:2,RECEIVED:3,CANCELLED:4,FAILED:5})})),define("Core/RequestType",["../Core/freezeObject"],(function(e){"use strict";return e({TERRAIN:0,IMAGERY:1,TILES3D:2,OTHER:3})})),define("Core/Request",["./defaultValue","./defined","./RequestState","./RequestType"],(function(e,t,r,n){"use strict";function o(t){t=e(t,e.EMPTY_OBJECT);var o=e(t.throttleByServer,!1),i=o||e(t.throttle,!1);this.url=t.url,this.requestFunction=t.requestFunction,this.cancelFunction=t.cancelFunction,this.priorityFunction=t.priorityFunction,this.priority=e(t.priority,0),this.throttle=i,this.throttleByServer=o,this.type=e(t.type,n.OTHER),this.serverKey=void 0,this.state=r.UNISSUED,this.deferred=void 0,this.cancelled=!1}return o.prototype.cancel=function(){this.cancelled=!0},o.prototype.clone=function(e){return t(e)?(e.url=this.url,e.requestFunction=this.requestFunction,e.cancelFunction=this.cancelFunction,e.priorityFunction=this.priorityFunction,e.priority=this.priority,e.throttle=this.throttle,e.throttleByServer=this.throttleByServer,e.type=this.type,e.serverKey=this.serverKey,e.state=this.RequestState.UNISSUED,e.deferred=void 0,e.cancelled=!1,e):new o(this)},o})),define("Core/parseResponseHeaders",[],(function(){"use strict";return function(e){var t={};if(!e)return t;for(var r=e.split("\r\n"),n=0;n<r.length;++n){var o=r[n],i=o.indexOf(": ");if(i>0){var a=o.substring(0,i),s=o.substring(i+2);t[a]=s}}return t}})),define("Core/RequestErrorEvent",["./defined","./parseResponseHeaders"],(function(e,t){"use strict";function r(e,r,n){this.statusCode=e,this.response=r,this.responseHeaders=n,"string"==typeof this.responseHeaders&&(this.responseHeaders=t(this.responseHeaders))}return r.prototype.toString=function(){var t="Request has failed.";return e(this.statusCode)&&(t+=" Status Code: "+this.statusCode),t},r})),define("Core/Event",["./Check","./defined","./defineProperties"],(function(e,t,r){"use strict";function n(){this._listeners=[],this._scopes=[],this._toRemove=[],this._insideRaiseEvent=!1}function o(e,t){return t-e}return r(n.prototype,{numberOfListeners:{get:function(){return this._listeners.length-this._toRemove.length}}}),n.prototype.addEventListener=function(t,r){e.typeOf.func("listener",t),this._listeners.push(t),this._scopes.push(r);var n=this;return function(){n.removeEventListener(t,r)}},n.prototype.removeEventListener=function(t,r){e.typeOf.func("listener",t);for(var n=this._listeners,o=this._scopes,i=-1,a=0;a<n.length;a++)if(n[a]===t&&o[a]===r){i=a;break}return-1!==i&&(this._insideRaiseEvent?(this._toRemove.push(i),n[i]=void 0,o[i]=void 0):(n.splice(i,1),o.splice(i,1)),!0)},n.prototype.raiseEvent=function(){var e;this._insideRaiseEvent=!0;var r=this._listeners,n=this._scopes,i=r.length;for(e=0;e<i;e++){var a=r[e];t(a)&&r[e].apply(n[e],arguments)}var s=this._toRemove;if((i=s.length)>0){for(s.sort(o),e=0;e<i;e++){var u=s[e];r.splice(u,1),n.splice(u,1)}s.length=0}this._insideRaiseEvent=!1},n})),define("Core/Heap",["./Check","./defaultValue","./defined","./defineProperties"],(function(e,t,r,n){"use strict";function o(t){e.typeOf.object("options",t),e.defined("options.comparator",t.comparator),this._comparator=t.comparator,this._array=[],this._length=0,this._maximumLength=void 0}function i(e,t,r){var n=e[t];e[t]=e[r],e[r]=n}return n(o.prototype,{length:{get:function(){return this._length}},internalArray:{get:function(){return this._array}},maximumLength:{get:function(){return this._maximumLength},set:function(e){this._maximumLength=e,this._length>e&&e>0&&(this._length=e,this._array.length=e)}},comparator:{get:function(){return this._comparator}}}),o.prototype.reserve=function(e){e=t(e,this._length),this._array.length=e},o.prototype.heapify=function(e){e=t(e,0);for(var r=this._length,n=this._comparator,o=this._array,a=-1,s=!0;s;){var u=2*(e+1),c=u-1;a=c<r&&n(o[c],o[e])<0?c:e,u<r&&n(o[u],o[a])<0&&(a=u),a!==e?(i(o,a,e),e=a):s=!1}},o.prototype.resort=function(){for(var e=this._length,t=Math.ceil(e/2);t>=0;--t)this.heapify(t)},o.prototype.insert=function(t){e.defined("element",t);var n,o=this._array,a=this._comparator,s=this._maximumLength,u=this._length++;for(u<o.length?o[u]=t:o.push(t);0!==u;){var c=Math.floor((u-1)/2);if(!(a(o[u],o[c])<0))break;i(o,u,c),u=c}return r(s)&&this._length>s&&(n=o[s],this._length=s),n},o.prototype.pop=function(r){if(r=t(r,0),0!==this._length){e.typeOf.number.lessThan("index",r,this._length);var n=this._array,o=n[r];return i(n,r,--this._length),this.heapify(r),o}},o})),define("Core/RequestScheduler",["../ThirdParty/Uri","../ThirdParty/when","./Check","./defaultValue","./defined","./defineProperties","./Event","./Heap","./isBlobUri","./isDataUri","./RequestState"],(function(e,t,r,n,o,i,a,s,u,c,f){"use strict";var l={numberOfAttemptedRequests:0,numberOfActiveRequests:0,numberOfCancelledRequests:0,numberOfCancelledActiveRequests:0,numberOfFailedRequests:0,numberOfActiveRequestsEver:0},h=20,p=new s({comparator:function(e,t){return e.priority-t.priority}});p.maximumLength=h,p.reserve(h);var d=[],y={},m="undefined"!=typeof document?new e(document.location.href):new e,E=new a;function O(){}function _(e){o(e.priorityFunction)&&(e.priority=e.priorityFunction())}function T(e){var t=n(O.requestsByServer[e],O.maximumRequestsPerServer);return y[e]<t}function R(e){return e.state===f.UNISSUED&&(e.state=f.ISSUED,e.deferred=t.defer()),e.deferred.promise}function w(e){var t=R(e);return e.state=f.ACTIVE,d.push(e),++l.numberOfActiveRequests,++l.numberOfActiveRequestsEver,++y[e.serverKey],e.requestFunction().then(function(e){return function(t){e.state!==f.CANCELLED&&(--l.numberOfActiveRequests,--y[e.serverKey],E.raiseEvent(),e.state=f.RECEIVED,e.deferred.resolve(t))}}(e)).otherwise(function(e){return function(t){e.state!==f.CANCELLED&&(++l.numberOfFailedRequests,--l.numberOfActiveRequests,--y[e.serverKey],E.raiseEvent(t),e.state=f.FAILED,e.deferred.reject(t))}}(e)),t}function g(e){var t=e.state===f.ACTIVE;e.state=f.CANCELLED,++l.numberOfCancelledRequests,e.deferred.reject(),t&&(--l.numberOfActiveRequests,--y[e.serverKey],++l.numberOfCancelledActiveRequests),o(e.cancelFunction)&&e.cancelFunction()}return O.maximumRequests=50,O.maximumRequestsPerServer=6,O.requestsByServer={"api.cesium.com:443":18,"assets.cesium.com:443":18},O.throttleRequests=!0,O.debugShowStatistics=!1,O.requestCompletedEvent=E,i(O,{statistics:{get:function(){return l}},priorityHeapLength:{get:function(){return h},set:function(e){if(e<h)for(;p.length>e;)g(p.pop());h=e,p.maximumLength=e,p.reserve(e)}}}),O.update=function(){var e,t,r=0,n=d.length;for(e=0;e<n;++e)(t=d[e]).cancelled&&g(t),t.state===f.ACTIVE?r>0&&(d[e-r]=t):++r;d.length-=r;var o=p.internalArray,i=p.length;for(e=0;e<i;++e)_(o[e]);p.resort();for(var a=Math.max(O.maximumRequests-d.length,0),s=0;s<a&&p.length>0;)(t=p.pop()).cancelled?g(t):!t.throttleByServer||T(t.serverKey)?(w(t),++s):g(t);O.debugShowStatistics&&(l.numberOfAttemptedRequests>0&&console.log("Number of attempted requests: "+l.numberOfAttemptedRequests),l.numberOfActiveRequests>0&&console.log("Number of active requests: "+l.numberOfActiveRequests),l.numberOfCancelledRequests>0&&console.log("Number of cancelled requests: "+l.numberOfCancelledRequests),l.numberOfCancelledActiveRequests>0&&console.log("Number of cancelled active requests: "+l.numberOfCancelledActiveRequests),l.numberOfFailedRequests>0&&console.log("Number of failed requests: "+l.numberOfFailedRequests),l.numberOfAttemptedRequests=0,l.numberOfCancelledRequests=0,l.numberOfCancelledActiveRequests=0)},O.getServerKey=function(t){r.typeOf.string("url",t);var n=new e(t).resolve(m);n.normalize();var i=n.authority;/:/.test(i)||(i=i+":"+("https"===n.scheme?"443":"80"));var a=y[i];return o(a)||(y[i]=0),i},O.request=function(e){if(r.typeOf.object("request",e),r.typeOf.string("request.url",e.url),r.typeOf.func("request.requestFunction",e.requestFunction),c(e.url)||u(e.url))return E.raiseEvent(),e.state=f.RECEIVED,e.requestFunction();if(++l.numberOfAttemptedRequests,o(e.serverKey)||(e.serverKey=O.getServerKey(e.url)),!O.throttleRequests||!e.throttle)return w(e);if(!(d.length>=O.maximumRequests)&&(!e.throttleByServer||T(e.serverKey))){_(e);var t=p.insert(e);if(o(t)){if(t===e)return;g(t)}return R(e)}},O.clearForSpecs=function(){for(;p.length>0;)g(p.pop());for(var e=d.length,t=0;t<e;++t)g(d[t]);d.length=0,y={},l.numberOfAttemptedRequests=0,l.numberOfActiveRequests=0,l.numberOfCancelledRequests=0,l.numberOfCancelledActiveRequests=0,l.numberOfFailedRequests=0,l.numberOfActiveRequestsEver=0},O.numberOfActiveRequestsByServer=function(e){return y[e]},O.requestHeap=p,O})),define("Core/TrustedServers",["../ThirdParty/Uri","./defined","./DeveloperError"],(function(e,t,r){"use strict";var n={},o={};return n.add=function(e,n){if(!t(e))throw new r("host is required.");if(!t(n)||n<=0)throw new r("port is required to be greater than 0.");var i=e.toLowerCase()+":"+n;t(o[i])||(o[i]=!0)},n.remove=function(e,n){if(!t(e))throw new r("host is required.");if(!t(n)||n<=0)throw new r("port is required to be greater than 0.");var i=e.toLowerCase()+":"+n;t(o[i])&&delete o[i]},n.contains=function(n){if(!t(n))throw new r("url is required.");var i=function(r){var n=new e(r);n.normalize();var o=n.getAuthority();if(t(o)){if(-1!==o.indexOf("@")){var i=o.split("@");o=i[1]}if(-1===o.indexOf(":")){var a=n.getScheme();if(t(a)||(a=(a=window.location.protocol).substring(0,a.length-1)),"http"===a)o+=":80";else{if("https"!==a)return;o+=":443"}}return o}}(n);return!(!t(i)||!t(o[i]))},n.clear=function(){o={}},n})),define("Core/Resource",["../ThirdParty/Uri","../ThirdParty/when","./appendForwardSlash","./Check","./clone","./combine","./defaultValue","./defined","./defineProperties","./deprecationWarning","./DeveloperError","./freezeObject","./getAbsoluteUri","./getBaseUri","./getExtensionFromUri","./isBlobUri","./isCrossOriginUrl","./isDataUri","./loadAndExecuteScript","./objectToQuery","./queryToObject","./Request","./RequestErrorEvent","./RequestScheduler","./RequestState","./RuntimeError","./TrustedServers"],(function(e,t,r,n,o,i,a,s,u,c,f,l,h,p,d,y,m,E,O,_,T,R,w,g,A,S,b){"use strict";var C=function(){try{var e=new XMLHttpRequest;return e.open("GET","#",!0),e.responseType="blob","blob"===e.responseType}catch(e){return!1}}();function v(e,t,r,n){var o,i=e.query;if(!s(i)||0===i.length)return{};if(-1===i.indexOf("=")){var a={};a[i]=void 0,o=a}else o=T(i);t._queryParameters=r?M(o,t._queryParameters,n):o,e.query=void 0}function N(e,t){return s(e)?s(e.clone)?e.clone():o(e):t}function I(e){if(e.state===A.ISSUED||e.state===A.ACTIVE)throw new S("The Resource is already being fetched.");e.state=A.UNISSUED,e.deferred=void 0}function M(e,t,r){if(!r)return i(e,t);var n=o(e,!0);for(var a in t)if(t.hasOwnProperty(a)){var u=n[a],c=t[a];s(u)?(Array.isArray(u)||(u=n[a]=[u]),n[a]=u.concat(c)):n[a]=Array.isArray(c)?c.slice():c}return n}function x(t){"string"==typeof(t=a(t,a.EMPTY_OBJECT))&&(t={url:t}),n.typeOf.string("options.url",t.url),this._url=void 0,this._templateValues=N(t.templateValues,{}),this._queryParameters=N(t.queryParameters,{}),this.headers=N(t.headers,{}),this.request=a(t.request,new R),this.proxy=t.proxy,this.retryCallback=t.retryCallback,this.retryAttempts=a(t.retryAttempts,0),this._retryCount=0;var r=new e(t.url);v(r,this,!0,!0),r.fragment=void 0,this._url=r.toString()}function P(e){var r=e.request;r.url=e.url,r.requestFunction=function(){var r=e.url,n=!1;e.isDataUri||e.isBlobUri||(n=e.isCrossOriginUrl);var o=t.defer();return x._Implementations.createImage(r,n,o),o.promise};var n=g.request(r);if(s(n))return n.otherwise((function(n){return r.state!==A.FAILED?t.reject(n):e.retryOnError(n).then((function(o){return o?(r.state=A.UNISSUED,r.deferred=void 0,P(e)):t.reject(n)}))}))}x.createIfNeeded=function(e){return e instanceof x?e.getDerivedResource({request:e.request}):"string"!=typeof e?e:new x({url:e})},u(x,{isBlobSupported:{get:function(){return C}}}),u(x.prototype,{queryParameters:{get:function(){return this._queryParameters}},templateValues:{get:function(){return this._templateValues}},url:{get:function(){return this.getUrlComponent(!0,!0)},set:function(t){var r=new e(t);v(r,this,!1),r.fragment=void 0,this._url=r.toString()}},extension:{get:function(){return d(this._url)}},isDataUri:{get:function(){return E(this._url)}},isBlobUri:{get:function(){return y(this._url)}},isCrossOriginUrl:{get:function(){return m(this._url)}},hasHeaders:{get:function(){return Object.keys(this.headers).length>0}}}),x.prototype.getUrlComponent=function(t,r){if(this.isDataUri)return this._url;var n=new e(this._url);t&&function(e,t){var r=t._queryParameters,n=Object.keys(r);1!==n.length||s(r[n[0]])?e.query=_(r):e.query=n[0]}(n,this);var o=n.toString().replace(/%7B/g,"{").replace(/%7D/g,"}"),i=this._templateValues,a=Object.keys(i);if(a.length>0)for(var u=0;u<a.length;u++){var c=a[u],f=i[c];o=o.replace(new RegExp("{"+c+"}","g"),encodeURIComponent(f))}return r&&s(this.proxy)&&(o=this.proxy.getURL(o)),o},x.prototype.setQueryParameters=function(e,t){this._queryParameters=t?M(this._queryParameters,e,!1):M(e,this._queryParameters,!1)},x.prototype.addQueryParameters=function(e,t){return c("Resource.addQueryParameters","addQueryParameters has been deprecated and will be removed 1.45. Use setQueryParameters or appendQueryParameters instead."),this.setQueryParameters(e,t)},x.prototype.appendQueryParameters=function(e){this._queryParameters=M(e,this._queryParameters,!0)},x.prototype.setTemplateValues=function(e,t){this._templateValues=t?i(this._templateValues,e):i(e,this._templateValues)},x.prototype.addTemplateValues=function(e,t){return c("Resource.addTemplateValues","addTemplateValues has been deprecated and will be removed 1.45. Use setTemplateValues."),this.setTemplateValues(e,t)},x.prototype.getDerivedResource=function(t){var r=this.clone();if(r._retryCount=0,s(t.url)){var n=new e(t.url);v(n,r,!0,a(t.preserveQueryParameters,!1)),n.fragment=void 0,r._url=n.resolve(new e(h(this._url))).toString()}return s(t.queryParameters)&&(r._queryParameters=i(t.queryParameters,r._queryParameters)),s(t.templateValues)&&(r._templateValues=i(t.templateValues,r.templateValues)),s(t.headers)&&(r.headers=i(t.headers,r.headers)),s(t.proxy)&&(r.proxy=t.proxy),s(t.request)&&(r.request=t.request),s(t.retryCallback)&&(r.retryCallback=t.retryCallback),s(t.retryAttempts)&&(r.retryAttempts=t.retryAttempts),r},x.prototype.retryOnError=function(e){var r=this.retryCallback;if("function"!=typeof r||this._retryCount>=this.retryAttempts)return t(!1);var n=this;return t(r(this,e)).then((function(e){return++n._retryCount,e}))},x.prototype.clone=function(e){return s(e)||(e=new x({url:this._url})),e._url=this._url,e._queryParameters=o(this._queryParameters),e._templateValues=o(this._templateValues),e.headers=o(this.headers),e.proxy=this.proxy,e.retryCallback=this.retryCallback,e.retryAttempts=this.retryAttempts,e._retryCount=0,e.request=this.request.clone(),e},x.prototype.getBaseUri=function(e){return p(this.getUrlComponent(e),e)},x.prototype.appendForwardSlash=function(){this._url=r(this._url)},x.prototype.fetchArrayBuffer=function(){return this.fetch({responseType:"arraybuffer"})},x.fetchArrayBuffer=function(e){return new x(e).fetchArrayBuffer()},x.prototype.fetchBlob=function(){return this.fetch({responseType:"blob"})},x.fetchBlob=function(e){return new x(e).fetchBlob()},x.prototype.fetchImage=function(e){if(e=a(e,!1),I(this.request),!C||this.isDataUri||this.isBlobUri||!this.hasHeaders&&!e)return P(this);var r,n,o=this.fetchBlob();return s(o)?o.then((function(e){if(s(e)){n=e;var t=window.URL.createObjectURL(e);return P(r=new x({url:t}))}})).then((function(e){if(s(e))return window.URL.revokeObjectURL(r.url),e.blob=n,e})).otherwise((function(e){return s(r)&&window.URL.revokeObjectURL(r.url),t.reject(e)})):void 0},x.fetchImage=function(e){return new x(e).fetchImage(e.preferBlob)},x.prototype.fetchText=function(){return this.fetch({responseType:"text"})},x.fetchText=function(e){return new x(e).fetchText()},x.prototype.fetchJson=function(){var e=this.fetch({responseType:"text",headers:{Accept:"application/json,*/*;q=0.01"}});if(s(e))return e.then((function(e){if(s(e))return JSON.parse(e)}))},x.fetchJson=function(e){return new x(e).fetchJson()},x.prototype.fetchXML=function(){return this.fetch({responseType:"document",overrideMimeType:"text/xml"})},x.fetchXML=function(e){return new x(e).fetchXML()},x.prototype.fetchJsonp=function(e){var r;e=a(e,"callback"),I(this.request);do{r="loadJsonp"+Math.random().toString().substring(2,8)}while(s(window[r]));return function e(r,n,o){var i={};i[n]=o,r.setQueryParameters(i);var a=r.request;a.url=r.url,a.requestFunction=function(){var e=t.defer();return window[o]=function(t){e.resolve(t);try{delete window[o]}catch(e){window[o]=void 0}},x._Implementations.loadAndExecuteScript(r.url,o,e),e.promise};var u=g.request(a);if(s(u))return u.otherwise((function(i){return a.state!==A.FAILED?t.reject(i):r.retryOnError(i).then((function(s){return s?(a.state=A.UNISSUED,a.deferred=void 0,e(r,n,o)):t.reject(i)}))}))}(this,e,r)},x.fetchJsonp=function(e){return new x(e).fetchJsonp(e.callbackParameterName)},x.prototype._makeRequest=function(e){var r=this;I(r.request);var n=r.request;n.url=r.url,n.requestFunction=function(){var o=e.responseType,a=i(e.headers,r.headers),u=e.overrideMimeType,c=e.method,f=e.data,l=t.defer(),h=x._Implementations.loadWithXhr(r.url,o,c,f,a,l,u);return s(h)&&s(h.abort)&&(n.cancelFunction=function(){h.abort()}),l.promise};var o=g.request(n);if(s(o))return o.then((function(e){return e})).otherwise((function(o){return n.state!==A.FAILED?t.reject(o):r.retryOnError(o).then((function(i){return i?(n.state=A.UNISSUED,n.deferred=void 0,r.fetch(e)):t.reject(o)}))}))};var D=/^data:(.*?)(;base64)?,(.*)$/;function F(e,t){var r=decodeURIComponent(t);return e?atob(r):r}function U(e,t){for(var r=F(e,t),n=new ArrayBuffer(r.length),o=new Uint8Array(n),i=0;i<r.length;i++)o[i]=r.charCodeAt(i);return n}function L(e,t){switch(t){case"text":return e.toString("utf8");case"json":return JSON.parse(e.toString("utf8"));default:return new Uint8Array(e).buffer}}x.prototype.fetch=function(e){return(e=N(e,{})).method="GET",this._makeRequest(e)},x.fetch=function(e){return new x(e).fetch({responseType:e.responseType,overrideMimeType:e.overrideMimeType})},x.prototype.delete=function(e){return(e=N(e,{})).method="DELETE",this._makeRequest(e)},x.delete=function(e){return new x(e).delete({responseType:e.responseType,overrideMimeType:e.overrideMimeType,data:e.data})},x.prototype.head=function(e){return(e=N(e,{})).method="HEAD",this._makeRequest(e)},x.head=function(e){return new x(e).head({responseType:e.responseType,overrideMimeType:e.overrideMimeType})},x.prototype.options=function(e){return(e=N(e,{})).method="OPTIONS",this._makeRequest(e)},x.options=function(e){return new x(e).options({responseType:e.responseType,overrideMimeType:e.overrideMimeType})},x.prototype.post=function(e,t){return n.defined("data",e),(t=N(t,{})).method="POST",t.data=e,this._makeRequest(t)},x.post=function(e){return new x(e).post(e.data,{responseType:e.responseType,overrideMimeType:e.overrideMimeType})},x.prototype.put=function(e,t){return n.defined("data",e),(t=N(t,{})).method="PUT",t.data=e,this._makeRequest(t)},x.put=function(e){return new x(e).put(e.data,{responseType:e.responseType,overrideMimeType:e.overrideMimeType})},x.prototype.patch=function(e,t){return n.defined("data",e),(t=N(t,{})).method="PATCH",t.data=e,this._makeRequest(t)},x.patch=function(e){return new x(e).patch(e.data,{responseType:e.responseType,overrideMimeType:e.overrideMimeType})},x._Implementations={},x._Implementations.createImage=function(e,t,r){var n=new Image;n.onload=function(){r.resolve(n)},n.onerror=function(e){r.reject(e)},t&&(b.contains(e)?n.crossOrigin="use-credentials":n.crossOrigin=""),n.src=e};var q="undefined"==typeof XMLHttpRequest;return x._Implementations.loadWithXhr=function(e,t,r,n,o,i,u){var c=D.exec(e);if(null===c){if(!q){var l=new XMLHttpRequest;if(b.contains(e)&&(l.withCredentials=!0),l.open(r,e,!0),s(u)&&s(l.overrideMimeType)&&l.overrideMimeType(u),s(o))for(var h in o)o.hasOwnProperty(h)&&l.setRequestHeader(h,o[h]);s(t)&&(l.responseType=t);var p=!1;return"string"==typeof e&&(p=0===e.indexOf("file://")||"undefined"!=typeof window&&"file://"===window.location.origin),l.onload=function(){if(!(l.status<200||l.status>=300)||p&&0===l.status){var e=l.response,n=l.responseType;if("HEAD"===r||"OPTIONS"===r){var o=l.getAllResponseHeaders().trim().split(/[\r\n]+/),a={};return o.forEach((function(e){var t=e.split(": "),r=t.shift();a[r]=t.join(": ")})),void i.resolve(a)}if(204===l.status)i.resolve();else if(!s(e)||s(t)&&n!==t)if("json"===t&&"string"==typeof e)try{i.resolve(JSON.parse(e))}catch(e){i.reject(e)}else(""===n||"document"===n)&&s(l.responseXML)&&l.responseXML.hasChildNodes()?i.resolve(l.responseXML):""!==n&&"text"!==n||!s(l.responseText)?i.reject(new S("Invalid XMLHttpRequest response type.")):i.resolve(l.responseText);else i.resolve(e)}else i.reject(new w(l.status,l.response,l.getAllResponseHeaders()))},l.onerror=function(e){i.reject(new w)},l.send(n),l}!function(e,t,r,n,o,i,a){var s=require("url").parse(e),u="https:"===s.protocol?require("https"):require("http"),c=require("zlib"),f={protocol:s.protocol,hostname:s.hostname,port:s.port,path:s.path,query:s.query,method:r,headers:o};u.request(f).on("response",(function(e){if(e.statusCode<200||e.statusCode>=300)i.reject(new w(e.statusCode,e,e.headers));else{var r=[];e.on("data",(function(e){r.push(e)})),e.on("end",(function(){var n=Buffer.concat(r);"gzip"===e.headers["content-encoding"]?c.gunzip(n,(function(e,r){e?i.reject(new S("Error decompressing response.")):i.resolve(L(r,t))})):i.resolve(L(n,t))}))}})).on("error",(function(e){i.reject(new w)})).end()}(e,t,r,0,o,i)}else i.resolve(function(e,t){t=a(t,"");var r=e[1],n=!!e[2],o=e[3];switch(t){case"":case"text":return F(n,o);case"arraybuffer":return U(n,o);case"blob":var i=U(n,o);return new Blob([i],{type:r});case"document":return(new DOMParser).parseFromString(F(n,o),r);case"json":return JSON.parse(F(n,o));default:throw new f("Unhandled responseType: "+t)}}(c,t))},x._Implementations.loadAndExecuteScript=function(e,t,r){return O(e,t).otherwise(r.reject)},x._DefaultImplementations={},x._DefaultImplementations.createImage=x._Implementations.createImage,x._DefaultImplementations.loadWithXhr=x._Implementations.loadWithXhr,x._DefaultImplementations.loadAndExecuteScript=x._Implementations.loadAndExecuteScript,x.DEFAULT=l(new x({url:"undefined"==typeof document?"":document.location.href.split("?")[0]})),x})),define("Core/EarthOrientationParameters",["../ThirdParty/when","./binarySearch","./defaultValue","./defined","./EarthOrientationParametersSample","./freezeObject","./JulianDate","./LeapSecond","./Resource","./RuntimeError","./TimeConstants","./TimeStandard"],(function(e,t,r,n,o,i,a,s,u,c,f,l){"use strict";function h(t){if(t=r(t,r.EMPTY_OBJECT),this._dates=void 0,this._samples=void 0,this._dateColumn=-1,this._xPoleWanderRadiansColumn=-1,this._yPoleWanderRadiansColumn=-1,this._ut1MinusUtcSecondsColumn=-1,this._xCelestialPoleOffsetRadiansColumn=-1,this._yCelestialPoleOffsetRadiansColumn=-1,this._taiMinusUtcSecondsColumn=-1,this._columnCount=0,this._lastIndex=-1,this._downloadPromise=void 0,this._dataError=void 0,this._addNewLeapSeconds=r(t.addNewLeapSeconds,!0),n(t.data))d(this,t.data);else if(n(t.url)){var o=u.createIfNeeded(t.url),i=this;this._downloadPromise=e(o.fetchJson(),(function(e){d(i,e)}),(function(){i._dataError="An error occurred while retrieving the EOP data from the URL "+o.url+"."}))}else d(this,{columnNames:["dateIso8601","modifiedJulianDateUtc","xPoleWanderRadians","yPoleWanderRadians","ut1MinusUtcSeconds","lengthOfDayCorrectionSeconds","xCelestialPoleOffsetRadians","yCelestialPoleOffsetRadians","taiMinusUtcSeconds"],samples:[]})}function p(e,t){return a.compare(e.julianDate,t)}function d(e,r){if(n(r.columnNames))if(n(r.samples)){var o=r.columnNames.indexOf("modifiedJulianDateUtc"),i=r.columnNames.indexOf("xPoleWanderRadians"),u=r.columnNames.indexOf("yPoleWanderRadians"),c=r.columnNames.indexOf("ut1MinusUtcSeconds"),h=r.columnNames.indexOf("xCelestialPoleOffsetRadians"),d=r.columnNames.indexOf("yCelestialPoleOffsetRadians"),y=r.columnNames.indexOf("taiMinusUtcSeconds");if(o<0||i<0||u<0||c<0||h<0||d<0||y<0)e._dataError="Error in loaded EOP data: The columnNames property must include modifiedJulianDateUtc, xPoleWanderRadians, yPoleWanderRadians, ut1MinusUtcSeconds, xCelestialPoleOffsetRadians, yCelestialPoleOffsetRadians, and taiMinusUtcSeconds columns";else{var m,E=e._samples=r.samples,O=e._dates=[];e._dateColumn=o,e._xPoleWanderRadiansColumn=i,e._yPoleWanderRadiansColumn=u,e._ut1MinusUtcSecondsColumn=c,e._xCelestialPoleOffsetRadiansColumn=h,e._yCelestialPoleOffsetRadiansColumn=d,e._taiMinusUtcSecondsColumn=y,e._columnCount=r.columnNames.length,e._lastIndex=void 0;for(var _=e._addNewLeapSeconds,T=0,R=E.length;T<R;T+=e._columnCount){var w=E[T+o],g=E[T+y],A=w+f.MODIFIED_JULIAN_DATE_DIFFERENCE,S=new a(A,g,l.TAI);if(O.push(S),_){if(g!==m&&n(m)){var b=a.leapSeconds,C=t(b,S,p);if(C<0){var v=new s(S,g);b.splice(~C,0,v)}}m=g}}}}else e._dataError="Error in loaded EOP data: The samples property is required.";else e._dataError="Error in loaded EOP data: The columnNames property is required."}function y(e,t,r,n,o){var i=r*n;o.xPoleWander=t[i+e._xPoleWanderRadiansColumn],o.yPoleWander=t[i+e._yPoleWanderRadiansColumn],o.xPoleOffset=t[i+e._xCelestialPoleOffsetRadiansColumn],o.yPoleOffset=t[i+e._yCelestialPoleOffsetRadiansColumn],o.ut1MinusUtc=t[i+e._ut1MinusUtcSecondsColumn]}function m(e,t,r){return t+e*(r-t)}function E(e,t,r,n,o,i,s){var u=e._columnCount;if(i>t.length-1)return s.xPoleWander=0,s.yPoleWander=0,s.xPoleOffset=0,s.yPoleOffset=0,s.ut1MinusUtc=0,s;var c=t[o],f=t[i];if(c.equals(f)||n.equals(c))return y(e,r,o,u,s),s;if(n.equals(f))return y(e,r,i,u,s),s;var l=a.secondsDifference(n,c)/a.secondsDifference(f,c),h=o*u,p=i*u,d=r[h+e._ut1MinusUtcSecondsColumn],E=r[p+e._ut1MinusUtcSecondsColumn],O=E-d;if(O>.5||O<-.5){var _=r[h+e._taiMinusUtcSecondsColumn],T=r[p+e._taiMinusUtcSecondsColumn];_!==T&&(f.equals(n)?d=E:E-=T-_)}return s.xPoleWander=m(l,r[h+e._xPoleWanderRadiansColumn],r[p+e._xPoleWanderRadiansColumn]),s.yPoleWander=m(l,r[h+e._yPoleWanderRadiansColumn],r[p+e._yPoleWanderRadiansColumn]),s.xPoleOffset=m(l,r[h+e._xCelestialPoleOffsetRadiansColumn],r[p+e._xCelestialPoleOffsetRadiansColumn]),s.yPoleOffset=m(l,r[h+e._yCelestialPoleOffsetRadiansColumn],r[p+e._yCelestialPoleOffsetRadiansColumn]),s.ut1MinusUtc=m(l,d,E),s}return h.NONE=i({getPromiseToLoad:function(){return e()},compute:function(e,t){return n(t)?(t.xPoleWander=0,t.yPoleWander=0,t.xPoleOffset=0,t.yPoleOffset=0,t.ut1MinusUtc=0):t=new o(0,0,0,0,0),t}}),h.prototype.getPromiseToLoad=function(){return e(this._downloadPromise)},h.prototype.compute=function(e,r){if(n(this._samples)){if(n(r)||(r=new o(0,0,0,0,0)),0===this._samples.length)return r.xPoleWander=0,r.yPoleWander=0,r.xPoleOffset=0,r.yPoleOffset=0,r.ut1MinusUtc=0,r;var i=this._dates,s=this._lastIndex,u=0,f=0;if(n(s)){var l=i[s],h=i[s+1],p=a.lessThanOrEquals(l,e),d=!n(h),y=d||a.greaterThanOrEquals(h,e);if(p&&y)return u=s,!d&&h.equals(e)&&++u,f=u+1,E(this,i,this._samples,e,u,f,r),r}var m=t(i,e,a.compare,this._dateColumn);return m>=0?(m<i.length-1&&i[m+1].equals(e)&&++m,u=m,f=m):(u=(f=~m)-1)<0&&(u=0),this._lastIndex=u,E(this,i,this._samples,e,u,f,r),r}if(n(this._dataError))throw new c(this._dataError)},h})),define("Core/HeadingPitchRoll",["./defaultValue","./defined","./DeveloperError","./Math"],(function(e,t,r,n){"use strict";function o(t,r,n){this.heading=e(t,0),this.pitch=e(r,0),this.roll=e(n,0)}return o.fromQuaternion=function(e,n){if(!t(e))throw new r("quaternion is required");t(n)||(n=new o);var i=2*(e.w*e.y-e.z*e.x),a=1-2*(e.x*e.x+e.y*e.y),s=2*(e.w*e.x+e.y*e.z),u=1-2*(e.y*e.y+e.z*e.z),c=2*(e.w*e.z+e.x*e.y);return n.heading=-Math.atan2(c,u),n.roll=Math.atan2(s,a),n.pitch=-Math.asin(i),n},o.fromDegrees=function(e,i,a,s){if(!t(e))throw new r("heading is required");if(!t(i))throw new r("pitch is required");if(!t(a))throw new r("roll is required");return t(s)||(s=new o),s.heading=e*n.RADIANS_PER_DEGREE,s.pitch=i*n.RADIANS_PER_DEGREE,s.roll=a*n.RADIANS_PER_DEGREE,s},o.clone=function(e,r){if(t(e))return t(r)?(r.heading=e.heading,r.pitch=e.pitch,r.roll=e.roll,r):new o(e.heading,e.pitch,e.roll)},o.equals=function(e,r){return e===r||t(e)&&t(r)&&e.heading===r.heading&&e.pitch===r.pitch&&e.roll===r.roll},o.equalsEpsilon=function(e,r,o,i){return e===r||t(e)&&t(r)&&n.equalsEpsilon(e.heading,r.heading,o,i)&&n.equalsEpsilon(e.pitch,r.pitch,o,i)&&n.equalsEpsilon(e.roll,r.roll,o,i)},o.prototype.clone=function(e){return o.clone(this,e)},o.prototype.equals=function(e){return o.equals(this,e)},o.prototype.equalsEpsilon=function(e,t,r){return o.equalsEpsilon(this,e,t,r)},o.prototype.toString=function(){return"("+this.heading+", "+this.pitch+", "+this.roll+")"},o})),define("Core/buildModuleUrl",["./defined","./DeveloperError","./getAbsoluteUri","./Resource","require"],(function(e,t,r,n,o){"use strict";var i,a,s,u=/((?:.*\/)|^)cesium[\w-]*\.js(?:\W|$)/i;function c(t){return"undefined"==typeof document?t:(e(i)||(i=document.createElement("a")),i.href=t,i.href=i.href,i.href)}function f(){if(e(a))return a;var i;if(i="undefined"!=typeof CESIUM_BASE_URL?CESIUM_BASE_URL:e(define.amd)&&!define.amd.toUrlUndefined&&e(o.toUrl)?r("..",p("Core/buildModuleUrl.js")):function(){for(var e=document.getElementsByTagName("script"),t=0,r=e.length;t<r;++t){var n=e[t].getAttribute("src"),o=u.exec(n);if(null!==o)return o[1]}}(),!e(i))throw new t("Unable to determine Cesium base URL automatically, try defining a global variable called CESIUM_BASE_URL.");return(a=new n({url:c(i)})).appendForwardSlash(),a}function l(e){return c(o.toUrl("../"+e))}function h(e){return f().getDerivedResource({url:e}).url}function p(t){return e(s)||(s=e(define.amd)&&!define.amd.toUrlUndefined&&e(o.toUrl)?l:h),s(t)}return p._cesiumScriptRegex=u,p._buildModuleUrlFromBaseUrl=h,p._clearBaseResource=function(){a=void 0},p.setBaseUrl=function(e){a=n.DEFAULT.getDerivedResource({url:e})},p.getCesiumBaseUrl=f,p})),define("Core/Iau2006XysSample",[],(function(){"use strict";return function(e,t,r){this.x=e,this.y=t,this.s=r}})),define("Core/Iau2006XysData",["../ThirdParty/when","./buildModuleUrl","./defaultValue","./defined","./Iau2006XysSample","./JulianDate","./Resource","./TimeStandard"],(function(e,t,r,n,o,i,a,s){"use strict";function u(e){e=r(e,r.EMPTY_OBJECT),this._xysFileUrlTemplate=a.createIfNeeded(e.xysFileUrlTemplate),this._interpolationOrder=r(e.interpolationOrder,9),this._sampleZeroJulianEphemerisDate=r(e.sampleZeroJulianEphemerisDate,2442396.5),this._sampleZeroDateTT=new i(this._sampleZeroJulianEphemerisDate,0,s.TAI),this._stepSizeDays=r(e.stepSizeDays,1),this._samplesPerXysFile=r(e.samplesPerXysFile,1e3),this._totalSamples=r(e.totalSamples,27426),this._samples=new Array(3*this._totalSamples),this._chunkDownloadsInProgress=[];for(var t=this._interpolationOrder,n=this._denominators=new Array(t+1),o=this._xTable=new Array(t+1),u=Math.pow(this._stepSizeDays,t),c=0;c<=t;++c){n[c]=u,o[c]=c*this._stepSizeDays;for(var f=0;f<=t;++f)f!==c&&(n[c]*=c-f);n[c]=1/n[c]}this._work=new Array(t+1),this._coef=new Array(t+1)}var c=new i(0,0,s.TAI);function f(e,t,r){var n=c;return n.dayNumber=t,n.secondsOfDay=r,i.daysDifference(n,e._sampleZeroDateTT)}function l(r,o){if(r._chunkDownloadsInProgress[o])return r._chunkDownloadsInProgress[o];var i,s=e.defer();r._chunkDownloadsInProgress[o]=s;var u=r._xysFileUrlTemplate;return i=n(u)?u.getDerivedResource({templateValues:{0:o}}):new a({url:t("Assets/IAU2006_XYS/IAU2006_XYS_"+o+".json")}),e(i.fetchJson(),(function(e){r._chunkDownloadsInProgress[o]=!1;for(var t=r._samples,n=e.samples,i=o*r._samplesPerXysFile*3,a=0,u=n.length;a<u;++a)t[i+a]=n[a];s.resolve()})),s.promise}return u.prototype.preload=function(t,r,n,o){var i=f(this,t,r),a=f(this,n,o),s=i/this._stepSizeDays-this._interpolationOrder/2|0;s<0&&(s=0);var u=a/this._stepSizeDays-this._interpolationOrder/2|0+this._interpolationOrder;u>=this._totalSamples&&(u=this._totalSamples-1);for(var c=s/this._samplesPerXysFile|0,h=u/this._samplesPerXysFile|0,p=[],d=c;d<=h;++d)p.push(l(this,d));return e.all(p)},u.prototype.computeXysRadians=function(e,t,r){var i=f(this,e,t);if(!(i<0)){var a=i/this._stepSizeDays|0;if(!(a>=this._totalSamples)){var s=this._interpolationOrder,u=a-(s/2|0);u<0&&(u=0);var c=u+s;c>=this._totalSamples&&(u=(c=this._totalSamples-1)-s)<0&&(u=0);var h=!1,p=this._samples;if(n(p[3*u])||(l(this,u/this._samplesPerXysFile|0),h=!0),n(p[3*c])||(l(this,c/this._samplesPerXysFile|0),h=!0),!h){n(r)?(r.x=0,r.y=0,r.s=0):r=new o(0,0,0);var d,y,m=i-u*this._stepSizeDays,E=this._work,O=this._denominators,_=this._coef,T=this._xTable;for(d=0;d<=s;++d)E[d]=m-T[d];for(d=0;d<=s;++d){for(_[d]=1,y=0;y<=s;++y)y!==d&&(_[d]*=E[y]);_[d]*=O[d];var R=3*(u+d);r.x+=_[d]*p[R++],r.y+=_[d]*p[R++],r.s+=_[d]*p[R]}return r}}}},u})),define("Core/Transforms",["../ThirdParty/when","./Cartesian2","./Cartesian3","./Cartesian4","./Cartographic","./Check","./defaultValue","./defined","./DeveloperError","./EarthOrientationParameters","./EarthOrientationParametersSample","./Ellipsoid","./HeadingPitchRoll","./Iau2006XysData","./Iau2006XysSample","./JulianDate","./Math","./Matrix3","./Matrix4","./Quaternion","./TimeConstants"],(function(e,t,r,n,o,i,a,s,u,c,f,l,h,p,d,y,m,E,O,_,T){"use strict";var R={},w={up:{south:"east",north:"west",west:"south",east:"north"},down:{south:"west",north:"east",west:"north",east:"south"},south:{up:"west",down:"east",west:"down",east:"up"},north:{up:"east",down:"west",west:"up",east:"down"},west:{up:"north",down:"south",north:"down",south:"up"},east:{up:"south",down:"north",north:"up",south:"down"}},g={north:[-1,0,0],east:[0,1,0],up:[0,0,1],south:[1,0,0],west:[0,-1,0],down:[0,0,-1]},A={},S={east:new r,north:new r,up:new r,west:new r,south:new r,down:new r},b=new r,C=new r,v=new r;R.localFrameToFixedFrameGenerator=function(e,t){if(!w.hasOwnProperty(e)||!w[e].hasOwnProperty(t))throw new u("firstAxis and secondAxis must be east, north, up, west, south or down.");var n,o=w[e][t],i=e+t;return s(A[i])?n=A[i]:(n=function(n,i,c){if(!s(n))throw new u("origin is required.");if(s(c)||(c=new O),m.equalsEpsilon(n.x,0,m.EPSILON14)&&m.equalsEpsilon(n.y,0,m.EPSILON14)){var f=m.sign(n.z);r.unpack(g[e],0,b),"east"!==e&&"west"!==e&&r.multiplyByScalar(b,f,b),r.unpack(g[t],0,C),"east"!==t&&"west"!==t&&r.multiplyByScalar(C,f,C),r.unpack(g[o],0,v),"east"!==o&&"west"!==o&&r.multiplyByScalar(v,f,v)}else{(i=a(i,l.WGS84)).geodeticSurfaceNormal(n,S.up);var h=S.up,p=S.east;p.x=-n.y,p.y=n.x,p.z=0,r.normalize(p,S.east),r.cross(h,p,S.north),r.multiplyByScalar(S.up,-1,S.down),r.multiplyByScalar(S.east,-1,S.west),r.multiplyByScalar(S.north,-1,S.south),b=S[e],C=S[t],v=S[o]}return c[0]=b.x,c[1]=b.y,c[2]=b.z,c[3]=0,c[4]=C.x,c[5]=C.y,c[6]=C.z,c[7]=0,c[8]=v.x,c[9]=v.y,c[10]=v.z,c[11]=0,c[12]=n.x,c[13]=n.y,c[14]=n.z,c[15]=1,c},A[i]=n),n},R.eastNorthUpToFixedFrame=R.localFrameToFixedFrameGenerator("east","north"),R.northEastDownToFixedFrame=R.localFrameToFixedFrameGenerator("north","east"),R.northUpEastToFixedFrame=R.localFrameToFixedFrameGenerator("north","up"),R.northWestUpToFixedFrame=R.localFrameToFixedFrameGenerator("north","west");var N=new _,I=new r(1,1,1),M=new O;R.headingPitchRollToFixedFrame=function(e,t,n,o,s){i.typeOf.object("HeadingPitchRoll",t),o=a(o,R.eastNorthUpToFixedFrame);var u=_.fromHeadingPitchRoll(t,N),c=O.fromTranslationQuaternionRotationScale(r.ZERO,u,I,M);return s=o(e,n,s),O.multiply(s,c,s)};var x=new O,P=new E;R.headingPitchRollQuaternion=function(e,t,r,n,o){i.typeOf.object("HeadingPitchRoll",t);var a=R.headingPitchRollToFixedFrame(e,t,r,n,x),s=O.getRotation(a,P);return _.fromRotationMatrix(s,o)};var D=new r(1,1,1),F=new r,U=new O,L=new O,q=new E,B=new _;R.fixedFrameToHeadingPitchRoll=function(e,t,n,o){i.defined("transform",e),t=a(t,l.WGS84),n=a(n,R.eastNorthUpToFixedFrame),s(o)||(o=new h);var u=O.getTranslation(e,F);if(r.equals(u,r.ZERO))return o.heading=0,o.pitch=0,o.roll=0,o;var c=O.inverseTransformation(n(u,t,U),U),f=O.setScale(e,D,L);f=O.setTranslation(f,r.ZERO,f),c=O.multiply(c,f,c);var p=_.fromRotationMatrix(O.getRotation(c,q),B);return p=_.normalize(p,p),h.fromQuaternion(p,o)};var j=m.TWO_PI/86400,z=new y;R.computeTemeToPseudoFixedMatrix=function(e,t){if(!s(e))throw new u("date is required.");var r,n=(z=y.addSeconds(e,-y.computeTaiMinusUtc(e),z)).dayNumber,o=z.secondsOfDay,i=n-2451545,a=(24110.54841+(r=o>=43200?(i+.5)/T.DAYS_PER_JULIAN_CENTURY:(i-.5)/T.DAYS_PER_JULIAN_CENTURY)*(8640184.812866+r*(.093104+-62e-7*r)))*j%m.TWO_PI+(72921158553e-15+11772758384668e-32*(n-2451545.5))*((o+.5*T.SECONDS_PER_DAY)%T.SECONDS_PER_DAY),c=Math.cos(a),f=Math.sin(a);return s(t)?(t[0]=c,t[1]=-f,t[2]=0,t[3]=f,t[4]=c,t[5]=0,t[6]=0,t[7]=0,t[8]=1,t):new E(c,f,0,-f,c,0,0,0,1)},R.iau2006XysData=new p,R.earthOrientationParameters=c.NONE,R.preloadIcrfFixed=function(t){var r=t.start.dayNumber,n=t.start.secondsOfDay+32.184,o=t.stop.dayNumber,i=t.stop.secondsOfDay+32.184,a=R.iau2006XysData.preload(r,n,o,i),s=R.earthOrientationParameters.getPromiseToLoad();return e.all([a,s])},R.computeIcrfToFixedMatrix=function(e,t){if(!s(e))throw new u("date is required.");s(t)||(t=new E);var r=R.computeFixedToIcrfMatrix(e,t);if(s(r))return E.transpose(r,t)};var G=new d(0,0,0),V=new f(0,0,0,0,0,0),H=new E,W=new E;R.computeFixedToIcrfMatrix=function(e,t){if(!s(e))throw new u("date is required.");s(t)||(t=new E);var r=R.earthOrientationParameters.compute(e,V);if(s(r)){var n=e.dayNumber,o=e.secondsOfDay+32.184,i=R.iau2006XysData.computeXysRadians(n,o,G);if(s(i)){var a=i.x+r.xPoleOffset,c=i.y+r.yPoleOffset,f=1/(1+Math.sqrt(1-a*a-c*c)),l=H;l[0]=1-f*a*a,l[3]=-f*a*c,l[6]=a,l[1]=-f*a*c,l[4]=1-f*c*c,l[7]=c,l[2]=-a,l[5]=-c,l[8]=1-f*(a*a+c*c);var h=E.fromRotationZ(-i.s,W),p=E.multiply(l,h,H),d=e.dayNumber-2451545,O=(e.secondsOfDay-y.computeTaiMinusUtc(e)+r.ut1MinusUtc)/T.SECONDS_PER_DAY,_=.779057273264+O+.00273781191135448*(d+O);_=_%1*m.TWO_PI;var w=E.fromRotationZ(_,W),g=E.multiply(p,w,H),A=Math.cos(r.xPoleWander),S=Math.cos(r.yPoleWander),b=Math.sin(r.xPoleWander),C=Math.sin(r.yPoleWander),v=n-2451545+o/T.SECONDS_PER_DAY,N=-47e-6*(v/=36525)*m.RADIANS_PER_DEGREE/3600,I=Math.cos(N),M=Math.sin(N),x=W;return x[0]=A*I,x[1]=A*M,x[2]=b,x[3]=-S*M+C*b*I,x[4]=S*I+C*b*M,x[5]=-C*A,x[6]=-C*M-S*b*I,x[7]=C*I-S*b*M,x[8]=S*A,E.multiply(g,x,t)}}};var X=new n;R.pointToWindowCoordinates=function(e,t,r,n){return(n=R.pointToGLWindowCoordinates(e,t,r,n)).y=2*t[5]-n.y,n},R.pointToGLWindowCoordinates=function(e,r,o,i){if(!s(e))throw new u("modelViewProjectionMatrix is required.");if(!s(r))throw new u("viewportTransformation is required.");if(!s(o))throw new u("point is required.");s(i)||(i=new t);var a=X;return O.multiplyByVector(e,n.fromElements(o.x,o.y,o.z,1,a),a),n.multiplyByScalar(a,1/a.w,a),O.multiplyByVector(r,a,a),t.fromCartesian4(a,i)};var Y=new r,k=new r,K=new r;R.rotationMatrixFromPositionVelocity=function(e,t,n,o){if(!s(e))throw new u("position is required.");if(!s(t))throw new u("velocity is required.");var i=a(n,l.WGS84).geodeticSurfaceNormal(e,Y),c=r.cross(t,i,k);r.equalsEpsilon(c,r.ZERO,m.EPSILON6)&&(c=r.clone(r.UNIT_X,c));var f=r.cross(c,t,K);return r.normalize(f,f),r.cross(t,f,c),r.negate(c,c),r.normalize(c,c),s(o)||(o=new E),o[0]=t.x,o[1]=t.y,o[2]=t.z,o[3]=c.x,o[4]=c.y,o[5]=c.z,o[6]=f.x,o[7]=f.y,o[8]=f.z,o};var Z=new O(0,0,1,0,1,0,0,0,0,1,0,0,0,0,0,1),Q=new o,J=new r,$=new r,ee=new E,te=new O,re=new O;return R.basisTo2D=function(e,t,n){if(!s(e))throw new u("projection is required.");if(!s(t))throw new u("matrix is required.");if(!s(n))throw new u("result is required.");var o=O.getTranslation(t,$),i=e.ellipsoid,a=i.cartesianToCartographic(o,Q),c=e.project(a,J);r.fromElements(c.z,c.x,c.y,c);var f=R.eastNorthUpToFixedFrame(o,i,te),l=O.inverseTransformation(f,re),h=O.getRotation(t,ee),p=O.multiplyByMatrix3(l,h,n);return O.multiply(Z,p,n),O.setTranslation(n,c,n),n},R.wgs84To2DModelMatrix=function(e,t,n){if(!s(e))throw new u("projection is required.");if(!s(t))throw new u("center is required.");if(!s(n))throw new u("result is required.");var o=e.ellipsoid,i=R.eastNorthUpToFixedFrame(t,o,te),a=O.inverseTransformation(i,re),c=o.cartesianToCartographic(t,Q),f=e.project(c,J);r.fromElements(f.z,f.x,f.y,f);var l=O.fromTranslation(f,te);return O.multiply(Z,a,n),O.multiply(l,n,n),n},R})),define("Core/Geometry",["./Cartesian2","./Cartesian3","./Cartographic","./Check","./defaultValue","./defined","./DeveloperError","./GeometryOffsetAttribute","./GeometryType","./Matrix2","./Matrix3","./Matrix4","./PrimitiveType","./Quaternion","./Rectangle","./Transforms"],(function(e,t,r,n,o,i,a,s,u,c,f,l,h,p,d,y){"use strict";function m(e){e=o(e,o.EMPTY_OBJECT),n.typeOf.object("options.attributes",e.attributes),this.attributes=e.attributes,this.indices=e.indices,this.primitiveType=o(e.primitiveType,h.TRIANGLES),this.boundingSphere=e.boundingSphere,this.geometryType=o(e.geometryType,u.NONE),this.boundingSphereCV=e.boundingSphereCV,this.offsetAttribute=e.offsetAttribute}m.computeNumberOfVertices=function(e){n.typeOf.object("geometry",e);var t=-1;for(var r in e.attributes)if(e.attributes.hasOwnProperty(r)&&i(e.attributes[r])&&i(e.attributes[r].values)){var o=e.attributes[r],s=o.values.length/o.componentsPerAttribute;if(t!==s&&-1!==t)throw new a("All attribute lists must have the same number of attributes.");t=s}return t};var E=new r,O=new t,_=new l,T=[new r,new r,new r],R=[new e,new e,new e],w=[new e,new e,new e],g=new t,A=new p,S=new l,b=new c;return m._textureCoordinateRotationPoints=function(n,o,i,a){var s,u=d.center(a,E),h=r.toCartesian(u,i,O),m=y.eastNorthUpToFixedFrame(h,i,_),C=l.inverse(m,_),v=R,N=T;N[0].longitude=a.west,N[0].latitude=a.south,N[1].longitude=a.west,N[1].latitude=a.north,N[2].longitude=a.east,N[2].latitude=a.south;var I=g;for(s=0;s<3;s++)r.toCartesian(N[s],i,I),I=l.multiplyByPointAsVector(C,I,I),v[s].x=I.x,v[s].y=I.y;var M=p.fromAxisAngle(t.UNIT_Z,-o,A),x=f.fromQuaternion(M,S),P=n.length,D=Number.POSITIVE_INFINITY,F=Number.POSITIVE_INFINITY,U=Number.NEGATIVE_INFINITY,L=Number.NEGATIVE_INFINITY;for(s=0;s<P;s++)I=l.multiplyByPointAsVector(C,n[s],I),I=f.multiplyByVector(x,I,I),D=Math.min(D,I.x),F=Math.min(F,I.y),U=Math.max(U,I.x),L=Math.max(L,I.y);var q=c.fromRotation(o,b),B=w;B[0].x=D,B[0].y=F,B[1].x=D,B[1].y=L,B[2].x=U,B[2].y=F;var j=v[0],z=v[2].x-j.x,G=v[1].y-j.y;for(s=0;s<3;s++){var V=B[s];c.multiplyByVector(q,V,V),V.x=(V.x-j.x)/z,V.y=(V.y-j.y)/G}var H=B[0],W=B[1],X=B[2],Y=new Array(6);return e.pack(H,Y),e.pack(W,Y,2),e.pack(X,Y,4),Y},m})),define("Core/GeometryAttribute",["./defaultValue","./defined","./DeveloperError"],(function(e,t,r){"use strict";return function(n){if(n=e(n,e.EMPTY_OBJECT),!t(n.componentDatatype))throw new r("options.componentDatatype is required.");if(!t(n.componentsPerAttribute))throw new r("options.componentsPerAttribute is required.");if(n.componentsPerAttribute<1||n.componentsPerAttribute>4)throw new r("options.componentsPerAttribute must be between 1 and 4.");if(!t(n.values))throw new r("options.values is required.");this.componentDatatype=n.componentDatatype,this.componentsPerAttribute=n.componentsPerAttribute,this.normalize=e(n.normalize,!1),this.values=n.values}})),define("Core/GeometryAttributes",["./defaultValue"],(function(e){"use strict";return function(t){t=e(t,e.EMPTY_OBJECT),this.position=t.position,this.normal=t.normal,this.st=t.st,this.bitangent=t.bitangent,this.tangent=t.tangent,this.color=t.color}})),define("Core/IndexDatatype",["./defined","./DeveloperError","./freezeObject","./Math","./WebGLConstants"],(function(e,t,r,n,o){"use strict";var i={UNSIGNED_BYTE:o.UNSIGNED_BYTE,UNSIGNED_SHORT:o.UNSIGNED_SHORT,UNSIGNED_INT:o.UNSIGNED_INT,getSizeInBytes:function(e){switch(e){case i.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case i.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case i.UNSIGNED_INT:return Uint32Array.BYTES_PER_ELEMENT}throw new t("indexDatatype is required and must be a valid IndexDatatype constant.")},validate:function(t){return e(t)&&(t===i.UNSIGNED_BYTE||t===i.UNSIGNED_SHORT||t===i.UNSIGNED_INT)},createTypedArray:function(r,o){if(!e(r))throw new t("numberOfVertices is required.");return r>=n.SIXTY_FOUR_KILOBYTES?new Uint32Array(o):new Uint16Array(o)},createTypedArrayFromArrayBuffer:function(r,o,i,a){if(!e(r))throw new t("numberOfVertices is required.");if(!e(o))throw new t("sourceArray is required.");if(!e(i))throw new t("byteOffset is required.");return r>=n.SIXTY_FOUR_KILOBYTES?new Uint32Array(o,i,a):new Uint16Array(o,i,a)}};return r(i)})),define("Core/EllipsoidGeodesic",["./Cartesian3","./Cartographic","./Check","./defaultValue","./defined","./defineProperties","./Ellipsoid","./Math"],(function(e,t,r,n,o,i,a,s){"use strict";function u(e,t,r,n,o,i,a){var s=function(e,t){return e*t*(4+e*(4-3*t))/16}(e,r);return(1-s)*e*t*(n+s*o*(a+s*i*(2*a*a-1)))}var c=new e,f=new e;function l(n,o,i,a){var l=e.normalize(a.cartographicToCartesian(o,f),c),h=e.normalize(a.cartographicToCartesian(i,f),f);r.typeOf.number.greaterThanOrEquals("value",Math.abs(Math.abs(e.angleBetween(l,h))-Math.PI),.0125),function(e,t,r,n,o,i,a){var c,f,l,h,p,d=(t-r)/t,y=i-n,m=Math.atan((1-d)*Math.tan(o)),E=Math.atan((1-d)*Math.tan(a)),O=Math.cos(m),_=Math.sin(m),T=Math.cos(E),R=Math.sin(E),w=O*T,g=O*R,A=_*R,S=_*T,b=y,C=s.TWO_PI,v=Math.cos(b),N=Math.sin(b);do{v=Math.cos(b),N=Math.sin(b);var I,M=g-S*v;l=Math.sqrt(T*T*N*N+M*M),f=A+w*v,c=Math.atan2(l,f),0===l?(I=0,h=1):h=1-(I=w*N/l)*I,C=b,p=f-2*A/h,isNaN(p)&&(p=0),b=y+u(d,I,h,c,l,f,p)}while(Math.abs(b-C)>s.EPSILON12);var x=h*(t*t-r*r)/(r*r),P=x*(256+x*(x*(74-47*x)-128))/1024,D=p*p,F=r*(1+x*(4096+x*(x*(320-175*x)-768))/16384)*(c-P*l*(p+P*(f*(2*D-1)-P*p*(4*l*l-3)*(4*D-3)/6)/4)),U=Math.atan2(T*N,g-S*v),L=Math.atan2(O*N,g*v-S);e._distance=F,e._startHeading=U,e._endHeading=L,e._uSquared=x}(n,a.maximumRadius,a.minimumRadius,o.longitude,o.latitude,i.longitude,i.latitude),n._start=t.clone(o,n._start),n._end=t.clone(i,n._end),n._start.height=0,n._end.height=0,function(e){var t=e._uSquared,r=e._ellipsoid.maximumRadius,n=e._ellipsoid.minimumRadius,o=(r-n)/r,i=Math.cos(e._startHeading),a=Math.sin(e._startHeading),s=(1-o)*Math.tan(e._start.latitude),u=1/Math.sqrt(1+s*s),c=u*s,f=Math.atan2(s,i),l=u*a,h=l*l,p=1-h,d=Math.sqrt(p),y=t/4,m=y*y,E=m*y,O=m*m,_=1+y-3*m/4+5*E/4-175*O/64,T=1-y+15*m/8-35*E/8,R=1-3*y+35*m/4,w=1-5*y,g=_*f-T*Math.sin(2*f)*y/2-R*Math.sin(4*f)*m/16-w*Math.sin(6*f)*E/48-5*Math.sin(8*f)*O/512,A=e._constants;A.a=r,A.b=n,A.f=o,A.cosineHeading=i,A.sineHeading=a,A.tanU=s,A.cosineU=u,A.sineU=c,A.sigma=f,A.sineAlpha=l,A.sineSquaredAlpha=h,A.cosineSquaredAlpha=p,A.cosineAlpha=d,A.u2Over4=y,A.u4Over16=m,A.u6Over64=E,A.u8Over256=O,A.a0=_,A.a1=T,A.a2=R,A.a3=w,A.distanceRatio=g}(n)}function h(e,r,i){var s=n(i,a.WGS84);this._ellipsoid=s,this._start=new t,this._end=new t,this._constants={},this._startHeading=void 0,this._endHeading=void 0,this._distance=void 0,this._uSquared=void 0,o(e)&&o(r)&&l(this,e,r,s)}return i(h.prototype,{ellipsoid:{get:function(){return this._ellipsoid}},surfaceDistance:{get:function(){return r.defined("distance",this._distance),this._distance}},start:{get:function(){return this._start}},end:{get:function(){return this._end}},startHeading:{get:function(){return r.defined("distance",this._distance),this._startHeading}},endHeading:{get:function(){return r.defined("distance",this._distance),this._endHeading}}}),h.prototype.setEndPoints=function(e,t){r.defined("start",e),r.defined("end",t),l(this,e,t,this._ellipsoid)},h.prototype.interpolateUsingFraction=function(e,t){return this.interpolateUsingSurfaceDistance(this._distance*e,t)},h.prototype.interpolateUsingSurfaceDistance=function(e,n){r.defined("distance",this._distance);var i=this._constants,a=i.distanceRatio+e/i.b,s=Math.cos(2*a),c=Math.cos(4*a),f=Math.cos(6*a),l=Math.sin(2*a),h=Math.sin(4*a),p=Math.sin(6*a),d=Math.sin(8*a),y=a*a,m=a*y,E=i.u8Over256,O=i.u2Over4,_=i.u6Over64,T=i.u4Over16,R=2*m*E*s/3+a*(1-O+7*T/4-15*_/4+579*E/64-(T-15*_/4+187*E/16)*s-(5*_/4-115*E/16)*c-29*E*f/16)+(O/2-T+71*_/32-85*E/16)*l+(5*T/16-5*_/4+383*E/96)*h-y*((_-11*E/2)*l+5*E*h/2)+(29*_/96-29*E/16)*p+539*E*d/1536,w=Math.asin(Math.sin(R)*i.cosineAlpha),g=Math.atan(i.a/i.b*Math.tan(w));R-=i.sigma;var A=Math.cos(2*i.sigma+R),S=Math.sin(R),b=Math.cos(R),C=i.cosineU*b,v=i.sineU*S,N=Math.atan2(S*i.sineHeading,C-v*i.cosineHeading)-u(i.f,i.sineAlpha,i.cosineSquaredAlpha,R,S,b,A);return o(n)?(n.longitude=this._start.longitude+N,n.latitude=g,n.height=0,n):new t(this._start.longitude+N,g,0)},h})),define("Core/QuadraticRealPolynomial",["./DeveloperError","./Math"],(function(e,t){"use strict";var r={};function n(e,r,n){var o=e+r;return t.sign(e)!==t.sign(r)&&Math.abs(o/Math.max(Math.abs(e),Math.abs(r)))<n?0:o}return r.computeDiscriminant=function(t,r,n){if("number"!=typeof t)throw new e("a is a required number.");if("number"!=typeof r)throw new e("b is a required number.");if("number"!=typeof n)throw new e("c is a required number.");return r*r-4*t*n},r.computeRealRoots=function(r,o,i){if("number"!=typeof r)throw new e("a is a required number.");if("number"!=typeof o)throw new e("b is a required number.");if("number"!=typeof i)throw new e("c is a required number.");var a;if(0===r)return 0===o?[]:[-i/o];if(0===o){if(0===i)return[0,0];var s=Math.abs(i),u=Math.abs(r);if(s<u&&s/u<t.EPSILON14)return[0,0];if(s>u&&u/s<t.EPSILON14)return[];if((a=-i/r)<0)return[];var c=Math.sqrt(a);return[-c,c]}if(0===i)return(a=-o/r)<0?[a,0]:[0,a];var f=n(o*o,-4*r*i,t.EPSILON14);if(f<0)return[];var l=-.5*n(o,t.sign(o)*Math.sqrt(f),t.EPSILON14);return o>0?[l/r,i/l]:[i/l,l/r]},r})),define("Core/CubicRealPolynomial",["./DeveloperError","./QuadraticRealPolynomial"],(function(e,t){"use strict";var r={};function n(e,t,r,n){var o,i,a=e,s=t/3,u=r/3,c=n,f=a*u,l=s*c,h=s*s,p=u*u,d=a*u-h,y=a*c-s*u,m=s*c-p,E=4*d*m-y*y;if(E<0){var O,_,T;h*l>=f*p?(O=a,_=d,T=-2*s*d+a*y):(O=c,_=m,T=-c*y+2*u*m);var R=-(T<0?-1:1)*Math.abs(O)*Math.sqrt(-E),w=(i=-T+R)/2,g=w<0?-Math.pow(-w,1/3):Math.pow(w,1/3),A=i===R?-g:-_/g;return o=_<=0?g+A:-T/(g*g+A*A+_),h*l>=f*p?[(o-s)/a]:[-c/(o+u)]}var S=d,b=-2*s*d+a*y,C=m,v=-c*y+2*u*m,N=Math.sqrt(E),I=Math.sqrt(3)/2,M=Math.abs(Math.atan2(a*N,-b)/3);o=2*Math.sqrt(-S);var x=Math.cos(M);i=o*x;var P=o*(-x/2-I*Math.sin(M)),D=i+P>2*s?i-s:P-s,F=a,U=D/F;M=Math.abs(Math.atan2(c*N,-v)/3);var L=-c,q=(i=(o=2*Math.sqrt(-C))*(x=Math.cos(M)))+(P=o*(-x/2-I*Math.sin(M)))<2*u?i+u:P+u,B=L/q,j=-D*q-F*L,z=(u*j-s*(D*L))/(-s*j+u*(F*q));return U<=z?U<=B?z<=B?[U,z,B]:[U,B,z]:[B,U,z]:U<=B?[z,U,B]:z<=B?[z,B,U]:[B,z,U]}return r.computeDiscriminant=function(t,r,n,o){if("number"!=typeof t)throw new e("a is a required number.");if("number"!=typeof r)throw new e("b is a required number.");if("number"!=typeof n)throw new e("c is a required number.");if("number"!=typeof o)throw new e("d is a required number.");var i=r*r,a=n*n;return 18*t*r*n*o+i*a-t*t*27*(o*o)-4*(t*a*n+i*r*o)},r.computeRealRoots=function(r,o,i,a){if("number"!=typeof r)throw new e("a is a required number.");if("number"!=typeof o)throw new e("b is a required number.");if("number"!=typeof i)throw new e("c is a required number.");if("number"!=typeof a)throw new e("d is a required number.");var s,u;if(0===r)return t.computeRealRoots(o,i,a);if(0===o){if(0===i){if(0===a)return[0,0,0];var c=(u=-a/r)<0?-Math.pow(-u,1/3):Math.pow(u,1/3);return[c,c,c]}return 0===a?0===(s=t.computeRealRoots(r,0,i)).Length?[0]:[s[0],0,s[1]]:n(r,0,i,a)}return 0===i?0===a?(u=-o/r)<0?[u,0,0]:[0,0,u]:n(r,o,0,a):0===a?0===(s=t.computeRealRoots(r,o,i)).length?[0]:s[1]<=0?[s[0],s[1],0]:s[0]>=0?[0,s[0],s[1]]:[s[0],0,s[1]]:n(r,o,i,a)},r})),define("Core/QuarticRealPolynomial",["./CubicRealPolynomial","./DeveloperError","./Math","./QuadraticRealPolynomial"],(function(e,t,r,n){"use strict";var o={};function i(t,o,i,a){var s=t*t,u=o-3*s/8,c=i-o*t/2+s*t/8,f=a-i*t/4+o*s/16-3*s*s/256,l=e.computeRealRoots(1,2*u,u*u-4*f,-c*c);if(l.length>0){var h=-t/4,p=l[l.length-1];if(Math.abs(p)<r.EPSILON14){var d=n.computeRealRoots(1,u,f);if(2===d.length){var y,m=d[0],E=d[1];if(m>=0&&E>=0){var O=Math.sqrt(m),_=Math.sqrt(E);return[h-_,h-O,h+O,h+_]}if(m>=0&&E<0)return[h-(y=Math.sqrt(m)),h+y];if(m<0&&E>=0)return[h-(y=Math.sqrt(E)),h+y]}return[]}if(p>0){var T=Math.sqrt(p),R=(u+p-c/T)/2,w=(u+p+c/T)/2,g=n.computeRealRoots(1,T,R),A=n.computeRealRoots(1,-T,w);return 0!==g.length?(g[0]+=h,g[1]+=h,0!==A.length?(A[0]+=h,A[1]+=h,g[1]<=A[0]?[g[0],g[1],A[0],A[1]]:A[1]<=g[0]?[A[0],A[1],g[0],g[1]]:g[0]>=A[0]&&g[1]<=A[1]?[A[0],g[0],g[1],A[1]]:A[0]>=g[0]&&A[1]<=g[1]?[g[0],A[0],A[1],g[1]]:g[0]>A[0]&&g[0]<A[1]?[A[0],g[0],A[1],g[1]]:[g[0],A[0],g[1],A[1]]):g):0!==A.length?(A[0]+=h,A[1]+=h,A):[]}}return[]}function a(t,o,i,a){var s=t*t,u=-2*o,c=i*t+o*o-4*a,f=s*a-i*o*t+i*i,l=e.computeRealRoots(1,u,c,f);if(l.length>0){var h,p,d,y,m,E,O=l[0],_=o-O,T=_*_,R=t/2,w=_/2,g=T-4*a,A=T+4*Math.abs(a),S=s-4*O,b=s+4*Math.abs(O);if(O<0||g*b<S*A){var C=Math.sqrt(S);h=C/2,p=0===C?0:(t*w-i)/C}else{var v=Math.sqrt(g);h=0===v?0:(t*w-i)/v,p=v/2}0===R&&0===h?(d=0,y=0):r.sign(R)===r.sign(h)?y=O/(d=R+h):d=O/(y=R-h),0===w&&0===p?(m=0,E=0):r.sign(w)===r.sign(p)?E=a/(m=w+p):m=a/(E=w-p);var N=n.computeRealRoots(1,d,m),I=n.computeRealRoots(1,y,E);if(0!==N.length)return 0!==I.length?N[1]<=I[0]?[N[0],N[1],I[0],I[1]]:I[1]<=N[0]?[I[0],I[1],N[0],N[1]]:N[0]>=I[0]&&N[1]<=I[1]?[I[0],N[0],N[1],I[1]]:I[0]>=N[0]&&I[1]<=N[1]?[N[0],I[0],I[1],N[1]]:N[0]>I[0]&&N[0]<I[1]?[I[0],N[0],I[1],N[1]]:[N[0],I[0],N[1],I[1]]:N;if(0!==I.length)return I}return[]}return o.computeDiscriminant=function(e,r,n,o,i){if("number"!=typeof e)throw new t("a is a required number.");if("number"!=typeof r)throw new t("b is a required number.");if("number"!=typeof n)throw new t("c is a required number.");if("number"!=typeof o)throw new t("d is a required number.");if("number"!=typeof i)throw new t("e is a required number.");var a=e*e,s=r*r,u=s*r,c=n*n,f=c*n,l=o*o,h=l*o,p=i*i;return s*c*l-4*u*h-4*e*f*l+18*e*r*n*h-27*a*l*l+a*e*256*(p*i)+i*(18*u*n*o-4*s*f+16*e*c*c-80*e*r*c*o-6*e*s*l+144*a*n*l)+p*(144*e*s*n-27*s*s-128*a*c-192*a*r*o)},o.computeRealRoots=function(n,o,s,u,c){if("number"!=typeof n)throw new t("a is a required number.");if("number"!=typeof o)throw new t("b is a required number.");if("number"!=typeof s)throw new t("c is a required number.");if("number"!=typeof u)throw new t("d is a required number.");if("number"!=typeof c)throw new t("e is a required number.");if(Math.abs(n)<r.EPSILON15)return e.computeRealRoots(o,s,u,c);var f=o/n,l=s/n,h=u/n,p=c/n,d=f<0?1:0;switch(d+=l<0?d+1:d,d+=h<0?d+1:d,d+=p<0?d+1:d){case 0:return i(f,l,h,p);case 1:case 2:return a(f,l,h,p);case 3:case 4:return i(f,l,h,p);case 5:return a(f,l,h,p);case 6:case 7:return i(f,l,h,p);case 8:return a(f,l,h,p);case 9:case 10:return i(f,l,h,p);case 11:return a(f,l,h,p);case 12:case 13:case 14:case 15:return i(f,l,h,p);default:return}},o})),define("Core/Ray",["./Cartesian3","./Check","./defaultValue","./defined"],(function(e,t,r,n){"use strict";function o(t,n){n=e.clone(r(n,e.ZERO)),e.equals(n,e.ZERO)||e.normalize(n,n),this.origin=e.clone(r(t,e.ZERO)),this.direction=n}return o.clone=function(t,r){if(n(t))return n(r)?(r.origin=e.clone(t.origin),r.direction=e.clone(t.direction),r):new o(t.origin,t.direction)},o.getPoint=function(r,o,i){return t.typeOf.object("ray",r),t.typeOf.number("t",o),n(i)||(i=new e),i=e.multiplyByScalar(r.direction,o,i),e.add(r.origin,i,i)},o})),define("Core/IntersectionTests",["./Cartesian3","./Cartographic","./defaultValue","./defined","./DeveloperError","./Interval","./Math","./Matrix3","./QuadraticRealPolynomial","./QuarticRealPolynomial","./Ray"],(function(e,t,r,n,o,i,a,s,u,c,f){"use strict";var l={rayPlane:function(t,r,i){if(!n(t))throw new o("ray is required.");if(!n(r))throw new o("plane is required.");n(i)||(i=new e);var s=t.origin,u=t.direction,c=r.normal,f=e.dot(c,u);if(!(Math.abs(f)<a.EPSILON15)){var l=(-r.distance-e.dot(c,s))/f;if(!(l<0))return i=e.multiplyByScalar(u,l,i),e.add(s,i,i)}}},h=new e,p=new e,d=new e,y=new e,m=new e;l.rayTriangleParametric=function(t,i,s,u,c){if(!n(t))throw new o("ray is required.");if(!n(i))throw new o("p0 is required.");if(!n(s))throw new o("p1 is required.");if(!n(u))throw new o("p2 is required.");c=r(c,!1);var f,l,E,O,_,T=t.origin,R=t.direction,w=e.subtract(s,i,h),g=e.subtract(u,i,p),A=e.cross(R,g,d),S=e.dot(w,A);if(c){if(S<a.EPSILON6)return;if(f=e.subtract(T,i,y),(E=e.dot(f,A))<0||E>S)return;if(l=e.cross(f,w,m),(O=e.dot(R,l))<0||E+O>S)return;_=e.dot(g,l)/S}else{if(Math.abs(S)<a.EPSILON6)return;var b=1/S;if(f=e.subtract(T,i,y),(E=e.dot(f,A)*b)<0||E>1)return;if(l=e.cross(f,w,m),(O=e.dot(R,l)*b)<0||E+O>1)return;_=e.dot(g,l)*b}return _},l.rayTriangle=function(t,r,o,i,a,s){var u=l.rayTriangleParametric(t,r,o,i,a);if(n(u)&&!(u<0))return n(s)||(s=new e),e.multiplyByScalar(t.direction,u,s),e.add(t.origin,s,s)};var E=new f;l.lineSegmentTriangle=function(t,r,i,a,s,u,c){if(!n(t))throw new o("v0 is required.");if(!n(r))throw new o("v1 is required.");if(!n(i))throw new o("p0 is required.");if(!n(a))throw new o("p1 is required.");if(!n(s))throw new o("p2 is required.");var f=E;e.clone(t,f.origin),e.subtract(r,t,f.direction),e.normalize(f.direction,f.direction);var h=l.rayTriangleParametric(f,i,a,s,u);if(!(!n(h)||h<0||h>e.distance(t,r)))return n(c)||(c=new e),e.multiplyByScalar(f.direction,h,c),e.add(f.origin,c,c)};var O={root0:0,root1:0};function _(t,r,o){n(o)||(o=new i);var a=t.origin,s=t.direction,u=r.center,c=r.radius*r.radius,f=e.subtract(a,u,d),l=function(e,t,r,n){var o=t*t-4*e*r;if(!(o<0)){if(o>0){var i=1/(2*e),a=Math.sqrt(o),s=(-t+a)*i,u=(-t-a)*i;return s<u?(n.root0=s,n.root1=u):(n.root0=u,n.root1=s),n}var c=-t/(2*e);if(0!==c)return n.root0=n.root1=c,n}}(e.dot(s,s),2*e.dot(s,f),e.magnitudeSquared(f)-c,O);if(n(l))return o.start=l.root0,o.stop=l.root1,o}l.raySphere=function(e,t,r){if(!n(e))throw new o("ray is required.");if(!n(t))throw new o("sphere is required.");if(r=_(e,t,r),n(r)&&!(r.stop<0))return r.start=Math.max(r.start,0),r};var T=new f;l.lineSegmentSphere=function(t,r,i,a){if(!n(t))throw new o("p0 is required.");if(!n(r))throw new o("p1 is required.");if(!n(i))throw new o("sphere is required.");var s=T;e.clone(t,s.origin);var u=e.subtract(r,t,s.direction),c=e.magnitude(u);if(e.normalize(u,u),a=_(s,i,a),!(!n(a)||a.stop<0||a.start>c))return a.start=Math.max(a.start,0),a.stop=Math.min(a.stop,c),a};var R=new e,w=new e;function g(e,t,r){var n=e+t;return a.sign(e)!==a.sign(t)&&Math.abs(n/Math.max(Math.abs(e),Math.abs(t)))<r?0:n}l.rayEllipsoid=function(t,r){if(!n(t))throw new o("ray is required.");if(!n(r))throw new o("ellipsoid is required.");var a,s,u,c,f,l=r.oneOverRadii,h=e.multiplyComponents(l,t.origin,R),p=e.multiplyComponents(l,t.direction,w),d=e.magnitudeSquared(h),y=e.dot(h,p);if(d>1){if(y>=0)return;var m=y*y;if(a=d-1,m<(u=(s=e.magnitudeSquared(p))*a))return;if(m>u){c=y*y-u;var E=(f=-y+Math.sqrt(c))/s,O=a/f;return E<O?new i(E,O):{start:O,stop:E}}var _=Math.sqrt(a/s);return new i(_,_)}return d<1?(a=d-1,c=y*y-(u=(s=e.magnitudeSquared(p))*a),f=-y+Math.sqrt(c),new i(0,f/s)):y<0?(s=e.magnitudeSquared(p),new i(0,-y/s)):void 0};var A=new e,S=new e,b=new e,C=new e,v=new e,N=new s,I=new s,M=new s,x=new s,P=new s,D=new s,F=new s,U=new e,L=new e,q=new t;l.grazingAltitudeLocation=function(t,r){if(!n(t))throw new o("ray is required.");if(!n(r))throw new o("ellipsoid is required.");var i=t.origin,f=t.direction;if(!e.equals(i,e.ZERO)){var l=r.geodeticSurfaceNormal(i,A);if(e.dot(f,l)>=0)return i}var h=n(this.rayEllipsoid(t,r)),p=r.transformPositionToScaledSpace(f,A),d=e.normalize(p,p),y=e.mostOrthogonalAxis(p,C),m=e.normalize(e.cross(y,d,S),S),E=e.normalize(e.cross(d,m,b),b),O=N;O[0]=d.x,O[1]=d.y,O[2]=d.z,O[3]=m.x,O[4]=m.y,O[5]=m.z,O[6]=E.x,O[7]=E.y,O[8]=E.z;var _=s.transpose(O,I),T=s.fromScale(r.radii,M),R=s.fromScale(r.oneOverRadii,x),w=P;w[0]=0,w[1]=-f.z,w[2]=f.y,w[3]=f.z,w[4]=0,w[5]=-f.x,w[6]=-f.y,w[7]=f.x,w[8]=0;var B,j,z=s.multiply(s.multiply(_,R,D),w,D),G=s.multiply(s.multiply(z,T,F),O,F),V=s.multiplyByVector(z,i,v),H=function(t,r,n,o,i){var f,l=o*o,h=i*i,p=(t[s.COLUMN1ROW1]-t[s.COLUMN2ROW2])*h,d=i*(o*g(t[s.COLUMN1ROW0],t[s.COLUMN0ROW1],a.EPSILON15)+r.y),y=t[s.COLUMN0ROW0]*l+t[s.COLUMN2ROW2]*h+o*r.x+n,m=h*g(t[s.COLUMN2ROW1],t[s.COLUMN1ROW2],a.EPSILON15),E=i*(o*g(t[s.COLUMN2ROW0],t[s.COLUMN0ROW2])+r.z),O=[];if(0===E&&0===m){if(0===(f=u.computeRealRoots(p,d,y)).length)return O;var _=f[0],T=Math.sqrt(Math.max(1-_*_,0));if(O.push(new e(o,i*_,i*-T)),O.push(new e(o,i*_,i*T)),2===f.length){var R=f[1],w=Math.sqrt(Math.max(1-R*R,0));O.push(new e(o,i*R,i*-w)),O.push(new e(o,i*R,i*w))}return O}var A=E*E,S=m*m,b=E*m,C=p*p+S,v=2*(d*p+b),N=2*y*p+d*d-S+A,I=2*(y*d-b),M=y*y-A;if(0===C&&0===v&&0===N&&0===I)return O;var x=(f=c.computeRealRoots(C,v,N,I,M)).length;if(0===x)return O;for(var P=0;P<x;++P){var D=f[P],F=D*D,U=Math.max(1-F,0),L=Math.sqrt(U),q=(a.sign(p)===a.sign(y)?g(p*F+y,d*D,a.EPSILON12):a.sign(y)===a.sign(d*D)?g(p*F,d*D+y,a.EPSILON12):g(p*F+d*D,y,a.EPSILON12))*g(m*D,E,a.EPSILON15);q<0?O.push(new e(o,i*D,i*L)):q>0?O.push(new e(o,i*D,i*-L)):0!==L?(O.push(new e(o,i*D,i*-L)),O.push(new e(o,i*D,i*L)),++P):O.push(new e(o,i*D,i*L))}return O}(G,e.negate(V,A),0,0,1),W=H.length;if(W>0){for(var X=e.clone(e.ZERO,L),Y=Number.NEGATIVE_INFINITY,k=0;k<W;++k){B=s.multiplyByVector(T,s.multiplyByVector(O,H[k],U),U);var K=e.normalize(e.subtract(B,i,C),C),Z=e.dot(K,f);Z>Y&&(Y=Z,X=e.clone(B,X))}var Q=r.cartesianToCartographic(X,q);return Y=a.clamp(Y,0,1),j=e.magnitude(e.subtract(X,i,C))*Math.sqrt(1-Y*Y),j=h?-j:j,Q.height=j,r.cartographicToCartesian(Q,new e)}};var B=new e;return l.lineSegmentPlane=function(t,r,i,s){if(!n(t))throw new o("endPoint0 is required.");if(!n(r))throw new o("endPoint1 is required.");if(!n(i))throw new o("plane is required.");n(s)||(s=new e);var u=e.subtract(r,t,B),c=i.normal,f=e.dot(c,u);if(!(Math.abs(f)<a.EPSILON6)){var l=e.dot(c,t),h=-(i.distance+l)/f;if(!(h<0||h>1))return e.multiplyByScalar(u,h,s),e.add(t,s,s),s}},l.trianglePlaneIntersection=function(t,r,i,a){if(!(n(t)&&n(r)&&n(i)&&n(a)))throw new o("p0, p1, p2, and plane are required.");var s,u,c=a.normal,f=a.distance,h=e.dot(c,t)+f<0,p=e.dot(c,r)+f<0,d=e.dot(c,i)+f<0,y=0;if(y+=h?1:0,y+=p?1:0,1!==(y+=d?1:0)&&2!==y||(s=new e,u=new e),1===y){if(h)return l.lineSegmentPlane(t,r,a,s),l.lineSegmentPlane(t,i,a,u),{positions:[t,r,i,s,u],indices:[0,3,4,1,2,4,1,4,3]};if(p)return l.lineSegmentPlane(r,i,a,s),l.lineSegmentPlane(r,t,a,u),{positions:[t,r,i,s,u],indices:[1,3,4,2,0,4,2,4,3]};if(d)return l.lineSegmentPlane(i,t,a,s),l.lineSegmentPlane(i,r,a,u),{positions:[t,r,i,s,u],indices:[2,3,4,0,1,4,0,4,3]}}else if(2===y){if(!h)return l.lineSegmentPlane(r,t,a,s),l.lineSegmentPlane(i,t,a,u),{positions:[t,r,i,s,u],indices:[1,2,4,1,4,3,0,3,4]};if(!p)return l.lineSegmentPlane(i,r,a,s),l.lineSegmentPlane(t,r,a,u),{positions:[t,r,i,s,u],indices:[2,0,4,2,4,3,1,3,4]};if(!d)return l.lineSegmentPlane(t,i,a,s),l.lineSegmentPlane(r,i,a,u),{positions:[t,r,i,s,u],indices:[0,1,4,0,4,3,2,3,4]}}},l})),define("Core/Plane",["./Cartesian3","./Check","./defined","./DeveloperError","./freezeObject","./Math","./Matrix4"],(function(e,t,r,n,o,i,a){"use strict";function s(r,o){if(t.typeOf.object("normal",r),!i.equalsEpsilon(e.magnitude(r),1,i.EPSILON6))throw new n("normal must be normalized.");t.typeOf.number("distance",o),this.normal=e.clone(r),this.distance=o}s.fromPointNormal=function(o,a,u){if(t.typeOf.object("point",o),t.typeOf.object("normal",a),!i.equalsEpsilon(e.magnitude(a),1,i.EPSILON6))throw new n("normal must be normalized.");var c=-e.dot(a,o);return r(u)?(e.clone(a,u.normal),u.distance=c,u):new s(a,c)};var u=new e;s.fromCartesian4=function(o,a){t.typeOf.object("coefficients",o);var c=e.fromCartesian4(o,u),f=o.w;if(!i.equalsEpsilon(e.magnitude(c),1,i.EPSILON6))throw new n("normal must be normalized.");return r(a)?(e.clone(c,a.normal),a.distance=f,a):new s(c,f)},s.getPointDistance=function(r,n){return t.typeOf.object("plane",r),t.typeOf.object("point",n),e.dot(r.normal,n)+r.distance};var c=new e;s.projectPointOntoPlane=function(n,o,i){t.typeOf.object("plane",n),t.typeOf.object("point",o),r(i)||(i=new e);var a=s.getPointDistance(n,o),u=e.multiplyByScalar(n.normal,a,c);return e.subtract(o,u,i)};var f=new e;return s.transform=function(r,n,o){return t.typeOf.object("plane",r),t.typeOf.object("transform",n),a.multiplyByPointAsVector(n,r.normal,u),e.normalize(u,u),e.multiplyByScalar(r.normal,-r.distance,f),a.multiplyByPoint(n,f,f),s.fromPointNormal(f,u,o)},s.clone=function(n,o){return t.typeOf.object("plane",n),r(o)?(e.clone(n.normal,o.normal),o.distance=n.distance,o):new s(n.normal,n.distance)},s.equals=function(r,n){return t.typeOf.object("left",r),t.typeOf.object("right",n),r.distance===n.distance&&e.equals(r.normal,n.normal)},s.ORIGIN_XY_PLANE=o(new s(e.UNIT_Z,0)),s.ORIGIN_YZ_PLANE=o(new s(e.UNIT_X,0)),s.ORIGIN_ZX_PLANE=o(new s(e.UNIT_Y,0)),s})),define("Core/PolylinePipeline",["./Cartesian3","./Cartographic","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./EllipsoidGeodesic","./IntersectionTests","./isArray","./Math","./Matrix4","./Plane"],(function(e,t,r,n,o,i,a,s,u,c,f,l){"use strict";var h={numberOfPoints:function(t,r,n){var o=e.distance(t,r);return Math.ceil(o/n)}},p=new t;h.extractHeights=function(e,t){for(var r=e.length,n=new Array(r),o=0;o<r;o++){var i=e[o];n[o]=t.cartesianToCartographic(i,p).height}return n};var d=new f,y=new e,m=new e,E=new l(e.UNIT_X,0),O=new e,_=new l(e.UNIT_X,0),T=new e,R=new e,w=[],g=new t,A=new t,S=new e,b=new e,C=new e,v=new a;function N(t,r,n,o,i,a,s,u){var c=o.scaleToGeodeticSurface(t,b),f=o.scaleToGeodeticSurface(r,C),l=h.numberOfPoints(t,r,n),p=o.cartesianToCartographic(c,g),d=o.cartesianToCartographic(f,A),y=function(e,t,r){var n,o=w;if(o.length=e,t===r){for(n=0;n<e;n++)o[n]=t;return o}var i=(r-t)/e;for(n=0;n<e;n++){var a=t+n*i;o[n]=a}return o}(l,i,a);v.setEndPoints(p,d);var m=v.surfaceDistance/l,E=u;p.height=i;var O=o.cartographicToCartesian(p,S);e.pack(O,s,E),E+=3;for(var _=1;_<l;_++){var T=v.interpolateUsingSurfaceDistance(_*m,A);T.height=y[_],O=o.cartographicToCartesian(T,S),e.pack(O,s,E),E+=3}return E}return h.wrapLongitude=function(t,o){var i=[],a=[];if(n(t)&&t.length>0){o=r(o,f.IDENTITY);var u=f.inverseTransformation(o,d),c=f.multiplyByPoint(u,e.ZERO,y),h=e.normalize(f.multiplyByPointAsVector(u,e.UNIT_Y,m),m),p=l.fromPointNormal(c,h,E),w=e.normalize(f.multiplyByPointAsVector(u,e.UNIT_X,O),O),g=l.fromPointNormal(c,w,_),A=1;i.push(e.clone(t[0]));for(var S=i[0],b=t.length,C=1;C<b;++C){var v=t[C];if(l.getPointDistance(g,S)<0||l.getPointDistance(g,v)<0){var N=s.lineSegmentPlane(S,v,p,T);if(n(N)){var I=e.multiplyByScalar(h,5e-9,R);l.getPointDistance(p,S)<0&&e.negate(I,I),i.push(e.add(N,I,new e)),a.push(A+1),e.negate(I,I),i.push(e.add(N,I,new e)),A=1}}i.push(e.clone(t[C])),A++,S=v}a.push(A)}return{positions:i,lengths:a}},h.generateArc=function(t){n(t)||(t={});var a=t.positions;if(!n(a))throw new o("options.positions is required.");var s=a.length,f=r(t.ellipsoid,i.WGS84),l=r(t.height,0),p=u(l);if(s<1)return[];if(1===s){var d=f.scaleToGeodeticSurface(a[0],b);if(0!==(l=p?l[0]:l)){var y=f.geodeticSurfaceNormal(d,S);e.multiplyByScalar(y,l,y),e.add(d,y,d)}return[d.x,d.y,d.z]}var m=t.minDistance;if(!n(m)){var E=r(t.granularity,c.RADIANS_PER_DEGREE);m=c.chordLength(E,f.maximumRadius)}var O,_=0;for(O=0;O<s-1;O++)_+=h.numberOfPoints(a[O],a[O+1],m);var T=3*(_+1),R=new Array(T),A=0;for(O=0;O<s-1;O++)A=N(a[O],a[O+1],m,f,p?l[O]:l,p?l[O+1]:l,R,A);w.length=0;var C=a[s-1],v=f.cartesianToCartographic(C,g);v.height=p?l[s-1]:l;var I=f.cartographicToCartesian(v,S);return e.pack(I,R,T-3),R},h.generateCartesianArc=function(t){for(var r=h.generateArc(t),n=r.length/3,o=new Array(n),i=0;i<n;i++)o[i]=e.unpack(r,3*i);return o},h})),define("Core/VertexFormat",["./defaultValue","./defined","./DeveloperError","./freezeObject"],(function(e,t,r,n){"use strict";function o(t){t=e(t,e.EMPTY_OBJECT),this.position=e(t.position,!1),this.normal=e(t.normal,!1),this.st=e(t.st,!1),this.bitangent=e(t.bitangent,!1),this.tangent=e(t.tangent,!1),this.color=e(t.color,!1)}return o.POSITION_ONLY=n(new o({position:!0})),o.POSITION_AND_NORMAL=n(new o({position:!0,normal:!0})),o.POSITION_NORMAL_AND_ST=n(new o({position:!0,normal:!0,st:!0})),o.POSITION_AND_ST=n(new o({position:!0,st:!0})),o.POSITION_AND_COLOR=n(new o({position:!0,color:!0})),o.ALL=n(new o({position:!0,normal:!0,st:!0,tangent:!0,bitangent:!0})),o.DEFAULT=o.POSITION_NORMAL_AND_ST,o.packedLength=6,o.pack=function(n,o,i){if(!t(n))throw new r("value is required");if(!t(o))throw new r("array is required");return i=e(i,0),o[i++]=n.position?1:0,o[i++]=n.normal?1:0,o[i++]=n.st?1:0,o[i++]=n.tangent?1:0,o[i++]=n.bitangent?1:0,o[i]=n.color?1:0,o},o.unpack=function(n,i,a){if(!t(n))throw new r("array is required");return i=e(i,0),t(a)||(a=new o),a.position=1===n[i++],a.normal=1===n[i++],a.st=1===n[i++],a.tangent=1===n[i++],a.bitangent=1===n[i++],a.color=1===n[i],a},o.clone=function(e,r){if(t(e))return t(r)||(r=new o),r.position=e.position,r.normal=e.normal,r.st=e.st,r.tangent=e.tangent,r.bitangent=e.bitangent,r.color=e.color,r},o})),define("Core/PolylineGeometry",["./arrayRemoveDuplicates","./BoundingSphere","./Cartesian3","./Color","./ComponentDatatype","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./Geometry","./GeometryAttribute","./GeometryAttributes","./GeometryType","./IndexDatatype","./Math","./PolylinePipeline","./PrimitiveType","./VertexFormat"],(function(e,t,r,n,o,i,a,s,u,c,f,l,h,p,d,y,m,E){"use strict";var O=[];function _(e,t,r,o,i){var a,s=O;s.length=i;var u=r.red,c=r.green,f=r.blue,l=r.alpha,h=o.red,p=o.green,d=o.blue,y=o.alpha;if(n.equals(r,o)){for(a=0;a<i;a++)s[a]=n.clone(r);return s}var m=(h-u)/i,E=(p-c)/i,_=(d-f)/i,T=(y-l)/i;for(a=0;a<i;a++)s[a]=new n(u+a*m,c+a*E,f+a*_,l+a*T);return s}function T(e){var t=(e=i(e,i.EMPTY_OBJECT)).positions,o=e.colors,c=i(e.width,1),f=i(e.colorsPerVertex,!1);if(!a(t)||t.length<2)throw new s("At least two positions are required.");if("number"!=typeof c)throw new s("width must be a number");if(a(o)&&(f&&o.length<t.length||!f&&o.length<t.length-1))throw new s("colors has an invalid length.");this._positions=t,this._colors=o,this._width=c,this._colorsPerVertex=f,this._vertexFormat=E.clone(i(e.vertexFormat,E.DEFAULT)),this._followSurface=i(e.followSurface,!0),this._granularity=i(e.granularity,d.RADIANS_PER_DEGREE),this._ellipsoid=u.clone(i(e.ellipsoid,u.WGS84)),this._workerName="createPolylineGeometry";var l=1+t.length*r.packedLength;l+=a(o)?1+o.length*n.packedLength:1,this.packedLength=l+u.packedLength+E.packedLength+4}T.pack=function(e,t,o){if(!a(e))throw new s("value is required");if(!a(t))throw new s("array is required");var c;o=i(o,0);var f=e._positions,l=f.length;for(t[o++]=l,c=0;c<l;++c,o+=r.packedLength)r.pack(f[c],t,o);var h=e._colors;for(l=a(h)?h.length:0,t[o++]=l,c=0;c<l;++c,o+=n.packedLength)n.pack(h[c],t,o);return u.pack(e._ellipsoid,t,o),o+=u.packedLength,E.pack(e._vertexFormat,t,o),o+=E.packedLength,t[o++]=e._width,t[o++]=e._colorsPerVertex?1:0,t[o++]=e._followSurface?1:0,t[o]=e._granularity,t};var R=u.clone(u.UNIT_SPHERE),w=new E,g={positions:void 0,colors:void 0,ellipsoid:R,vertexFormat:w,width:void 0,colorsPerVertex:void 0,followSurface:void 0,granularity:void 0};T.unpack=function(e,t,o){if(!a(e))throw new s("array is required");var c;t=i(t,0);var f=e[t++],l=new Array(f);for(c=0;c<f;++c,t+=r.packedLength)l[c]=r.unpack(e,t);var h=(f=e[t++])>0?new Array(f):void 0;for(c=0;c<f;++c,t+=n.packedLength)h[c]=n.unpack(e,t);var p=u.unpack(e,t,R);t+=u.packedLength;var d=E.unpack(e,t,w);t+=E.packedLength;var y=e[t++],m=1===e[t++],O=1===e[t++],_=e[t];return a(o)?(o._positions=l,o._colors=h,o._ellipsoid=u.clone(p,o._ellipsoid),o._vertexFormat=E.clone(d,o._vertexFormat),o._width=y,o._colorsPerVertex=m,o._followSurface=O,o._granularity=_,o):(g.positions=l,g.colors=h,g.width=y,g.colorsPerVertex=m,g.followSurface=O,g.granularity=_,new T(g))};var A=new r,S=new r,b=new r,C=new r;return T.createGeometry=function(i){var s,u,E,T=i._width,R=i._vertexFormat,w=i._colors,g=i._colorsPerVertex,v=i._followSurface,N=i._granularity,I=i._ellipsoid,M=e(i._positions,r.equalsEpsilon),x=M.length;if(!(x<2||T<=0)){if(v){var P=y.extractHeights(M,I),D=d.chordLength(N,I.maximumRadius);if(a(w)){var F=1;for(s=0;s<x-1;++s)F+=y.numberOfPoints(M[s],M[s+1],D);var U=new Array(F),L=0;for(s=0;s<x-1;++s){var q=M[s],B=M[s+1],j=w[s],z=y.numberOfPoints(q,B,D);if(g&&s<F){var G=_(0,0,j,w[s+1],z),V=G.length;for(u=0;u<V;++u)U[L++]=G[u]}else for(u=0;u<z;++u)U[L++]=n.clone(j)}U[L]=n.clone(w[w.length-1]),w=U,O.length=0}M=y.generateCartesianArc({positions:M,minDistance:D,ellipsoid:I,height:P})}var H,W=4*(x=M.length)-4,X=new Float64Array(3*W),Y=new Float64Array(3*W),k=new Float64Array(3*W),K=new Float32Array(2*W),Z=R.st?new Float32Array(2*W):void 0,Q=a(w)?new Uint8Array(4*W):void 0,J=0,$=0,ee=0,te=0;for(u=0;u<x;++u){var re,ne;0===u?(H=A,r.subtract(M[0],M[1],H),r.add(M[0],H,H)):H=M[u-1],r.clone(H,b),r.clone(M[u],S),u===x-1?(H=A,r.subtract(M[x-1],M[x-2],H),r.add(M[x-1],H,H)):H=M[u+1],r.clone(H,C),a(Q)&&(re=0===u||g?w[u]:w[u-1],u!==x-1&&(ne=w[u]));var oe=u===x-1?2:4;for(E=0===u?2:0;E<oe;++E){r.pack(S,X,J),r.pack(b,Y,J),r.pack(C,k,J),J+=3;var ie=E-2<0?-1:1;if(K[$++]=E%2*2-1,K[$++]=ie*T,R.st&&(Z[ee++]=u/(x-1),Z[ee++]=Math.max(K[$-2],0)),a(Q)){var ae=E<2?re:ne;Q[te++]=n.floatToByte(ae.red),Q[te++]=n.floatToByte(ae.green),Q[te++]=n.floatToByte(ae.blue),Q[te++]=n.floatToByte(ae.alpha)}}}var se=new l;se.position=new f({componentDatatype:o.DOUBLE,componentsPerAttribute:3,values:X}),se.prevPosition=new f({componentDatatype:o.DOUBLE,componentsPerAttribute:3,values:Y}),se.nextPosition=new f({componentDatatype:o.DOUBLE,componentsPerAttribute:3,values:k}),se.expandAndWidth=new f({componentDatatype:o.FLOAT,componentsPerAttribute:2,values:K}),R.st&&(se.st=new f({componentDatatype:o.FLOAT,componentsPerAttribute:2,values:Z})),a(Q)&&(se.color=new f({componentDatatype:o.UNSIGNED_BYTE,componentsPerAttribute:4,values:Q,normalize:!0}));var ue=p.createTypedArray(W,6*x-6),ce=0,fe=0,le=x-1;for(u=0;u<le;++u)ue[fe++]=ce,ue[fe++]=ce+2,ue[fe++]=ce+1,ue[fe++]=ce+1,ue[fe++]=ce+2,ue[fe++]=ce+3,ce+=4;return new c({attributes:se,indices:ue,primitiveType:m.TRIANGLES,boundingSphere:t.fromPoints(M),geometryType:h.POLYLINES})}},T})),define("Workers/createPolylineGeometry",["../Core/defined","../Core/Ellipsoid","../Core/PolylineGeometry"],(function(e,t,r){"use strict";return function(n,o){return e(o)&&(n=r.unpack(n,o)),n._ellipsoid=t.clone(n._ellipsoid),r.createGeometry(n)}}));