define("Core/defined",[],(function(){"use strict";return function(e){return null!=e}})),define("Core/DeveloperError",["./defined"],(function(e){"use strict";function t(e){var t;this.name="DeveloperError",this.message=e;try{throw new Error}catch(e){t=e.stack}this.stack=t}return e(Object.create)&&(t.prototype=Object.create(Error.prototype),t.prototype.constructor=t),t.prototype.toString=function(){var t=this.name+": "+this.message;return e(this.stack)&&(t+="\n"+this.stack.toString()),t},t.throwInstantiationError=function(){throw new t("This function defines an interface and should not be called directly.")},t})),define("Core/Check",["./defined","./DeveloperError"],(function(e,t){"use strict";var r={};function n(e,t,r){return"Expected "+r+" to be typeof "+t+", actual typeof was "+e}return r.typeOf={},r.defined=function(r,n){if(!e(n))throw new t(function(e){return e+" is required, actual value was undefined"}(r))},r.typeOf.func=function(e,r){if("function"!=typeof r)throw new t(n(typeof r,"function",e))},r.typeOf.string=function(e,r){if("string"!=typeof r)throw new t(n(typeof r,"string",e))},r.typeOf.number=function(e,r){if("number"!=typeof r)throw new t(n(typeof r,"number",e))},r.typeOf.number.lessThan=function(e,n,o){if(r.typeOf.number(e,n),n>=o)throw new t("Expected "+e+" to be less than "+o+", actual value was "+n)},r.typeOf.number.lessThanOrEquals=function(e,n,o){if(r.typeOf.number(e,n),n>o)throw new t("Expected "+e+" to be less than or equal to "+o+", actual value was "+n)},r.typeOf.number.greaterThan=function(e,n,o){if(r.typeOf.number(e,n),n<=o)throw new t("Expected "+e+" to be greater than "+o+", actual value was "+n)},r.typeOf.number.greaterThanOrEquals=function(e,n,o){if(r.typeOf.number(e,n),n<o)throw new t("Expected "+e+" to be greater than or equal to"+o+", actual value was "+n)},r.typeOf.object=function(e,r){if("object"!=typeof r)throw new t(n(typeof r,"object",e))},r.typeOf.bool=function(e,r){if("boolean"!=typeof r)throw new t(n(typeof r,"boolean",e))},r.typeOf.number.equals=function(e,n,o,i){if(r.typeOf.number(e,o),r.typeOf.number(n,i),o!==i)throw new t(e+" must be equal to "+n+", the actual values are "+o+" and "+i)},r})),define("Core/freezeObject",["./defined"],(function(e){"use strict";var t=Object.freeze;return e(t)||(t=function(e){return e}),t})),define("Core/defaultValue",["./freezeObject"],(function(e){"use strict";function t(e,t){return null!=e?e:t}return t.EMPTY_OBJECT=e({}),t})),
/**
@license
mersenne-twister.js - https://gist.github.com/banksean/300494

   Copyright (C) 1997 - 2002, Makoto Matsumoto and Takuji Nishimura,
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:

     1. Redistributions of source code must retain the above copyright
        notice, this list of conditions and the following disclaimer.

     2. Redistributions in binary form must reproduce the above copyright
        notice, this list of conditions and the following disclaimer in the
        documentation and/or other materials provided with the distribution.

     3. The names of its contributors may not be used to endorse or promote
        products derived from this software without specific prior written
        permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
   A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
   EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
   PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
define("ThirdParty/mersenne-twister",[],(function(){var e=function(e){null==e&&(e=(new Date).getTime()),this.N=624,this.M=397,this.MATRIX_A=2567483615,this.UPPER_MASK=2147483648,this.LOWER_MASK=2147483647,this.mt=new Array(this.N),this.mti=this.N+1,this.init_genrand(e)};return e.prototype.init_genrand=function(e){for(this.mt[0]=e>>>0,this.mti=1;this.mti<this.N;this.mti++)e=this.mt[this.mti-1]^this.mt[this.mti-1]>>>30,this.mt[this.mti]=(1812433253*((4294901760&e)>>>16)<<16)+1812433253*(65535&e)+this.mti,this.mt[this.mti]>>>=0},e.prototype.genrand_int32=function(){var e,t=new Array(0,this.MATRIX_A);if(this.mti>=this.N){var r;for(this.mti==this.N+1&&this.init_genrand(5489),r=0;r<this.N-this.M;r++)e=this.mt[r]&this.UPPER_MASK|this.mt[r+1]&this.LOWER_MASK,this.mt[r]=this.mt[r+this.M]^e>>>1^t[1&e];for(;r<this.N-1;r++)e=this.mt[r]&this.UPPER_MASK|this.mt[r+1]&this.LOWER_MASK,this.mt[r]=this.mt[r+(this.M-this.N)]^e>>>1^t[1&e];e=this.mt[this.N-1]&this.UPPER_MASK|this.mt[0]&this.LOWER_MASK,this.mt[this.N-1]=this.mt[this.M-1]^e>>>1^t[1&e],this.mti=0}return e=this.mt[this.mti++],e^=e>>>11,e^=e<<7&2636928640,e^=e<<15&4022730752,(e^=e>>>18)>>>0},e.prototype.random=function(){return this.genrand_int32()*(1/4294967296)},e})),define("Core/Math",["../ThirdParty/mersenne-twister","./Check","./defaultValue","./defined","./DeveloperError"],(function(e,t,r,n,o){"use strict";var i={EPSILON1:.1,EPSILON2:.01,EPSILON3:.001,EPSILON4:1e-4,EPSILON5:1e-5,EPSILON6:1e-6,EPSILON7:1e-7,EPSILON8:1e-8,EPSILON9:1e-9,EPSILON10:1e-10,EPSILON11:1e-11,EPSILON12:1e-12,EPSILON13:1e-13,EPSILON14:1e-14,EPSILON15:1e-15,EPSILON16:1e-16,EPSILON17:1e-17,EPSILON18:1e-18,EPSILON19:1e-19,EPSILON20:1e-20,EPSILON21:1e-21,GRAVITATIONALPARAMETER:3986004418e5,SOLAR_RADIUS:6955e5,LUNAR_RADIUS:1737400,SIXTY_FOUR_KILOBYTES:65536};i.sign=r(Math.sign,(function(e){return 0==(e=+e)||e!=e?e:e>0?1:-1})),i.signNotZero=function(e){return e<0?-1:1},i.toSNorm=function(e,t){return t=r(t,255),Math.round((.5*i.clamp(e,-1,1)+.5)*t)},i.fromSNorm=function(e,t){return t=r(t,255),i.clamp(e,0,t)/t*2-1},i.sinh=r(Math.sinh,(function(e){return(Math.exp(e)-Math.exp(-e))/2})),i.cosh=r(Math.cosh,(function(e){return(Math.exp(e)+Math.exp(-e))/2})),i.lerp=function(e,t,r){return(1-r)*e+r*t},i.PI=Math.PI,i.ONE_OVER_PI=1/Math.PI,i.PI_OVER_TWO=Math.PI/2,i.PI_OVER_THREE=Math.PI/3,i.PI_OVER_FOUR=Math.PI/4,i.PI_OVER_SIX=Math.PI/6,i.THREE_PI_OVER_TWO=3*Math.PI/2,i.TWO_PI=2*Math.PI,i.ONE_OVER_TWO_PI=1/(2*Math.PI),i.RADIANS_PER_DEGREE=Math.PI/180,i.DEGREES_PER_RADIAN=180/Math.PI,i.RADIANS_PER_ARCSECOND=i.RADIANS_PER_DEGREE/3600,i.toRadians=function(e){if(!n(e))throw new o("degrees is required.");return e*i.RADIANS_PER_DEGREE},i.toDegrees=function(e){if(!n(e))throw new o("radians is required.");return e*i.DEGREES_PER_RADIAN},i.convertLongitudeRange=function(e){if(!n(e))throw new o("angle is required.");var t=i.TWO_PI,r=e-Math.floor(e/t)*t;return r<-Math.PI?r+t:r>=Math.PI?r-t:r},i.clampToLatitudeRange=function(e){if(!n(e))throw new o("angle is required.");return i.clamp(e,-1*i.PI_OVER_TWO,i.PI_OVER_TWO)},i.negativePiToPi=function(e){if(!n(e))throw new o("angle is required.");return i.zeroToTwoPi(e+i.PI)-i.PI},i.zeroToTwoPi=function(e){if(!n(e))throw new o("angle is required.");var t=i.mod(e,i.TWO_PI);return Math.abs(t)<i.EPSILON14&&Math.abs(e)>i.EPSILON14?i.TWO_PI:t},i.mod=function(e,t){if(!n(e))throw new o("m is required.");if(!n(t))throw new o("n is required.");return(e%t+t)%t},i.equalsEpsilon=function(e,t,i,a){if(!n(e))throw new o("left is required.");if(!n(t))throw new o("right is required.");if(!n(i))throw new o("relativeEpsilon is required.");a=r(a,i);var u=Math.abs(e-t);return u<=a||u<=i*Math.max(Math.abs(e),Math.abs(t))};var a=[1];i.factorial=function(e){if("number"!=typeof e||e<0)throw new o("A number greater than or equal to 0 is required.");var t=a.length;if(e>=t)for(var r=a[t-1],n=t;n<=e;n++)a.push(r*n);return a[e]},i.incrementWrap=function(e,t,i){if(i=r(i,0),!n(e))throw new o("n is required.");if(t<=i)throw new o("maximumValue must be greater than minimumValue.");return++e>t&&(e=i),e},i.isPowerOfTwo=function(e){if("number"!=typeof e||e<0)throw new o("A number greater than or equal to 0 is required.");return 0!==e&&0==(e&e-1)},i.nextPowerOfTwo=function(e){if("number"!=typeof e||e<0)throw new o("A number greater than or equal to 0 is required.");return--e,e|=e>>1,e|=e>>2,e|=e>>4,e|=e>>8,e|=e>>16,++e},i.clamp=function(e,t,r){if(!n(e))throw new o("value is required");if(!n(t))throw new o("min is required.");if(!n(r))throw new o("max is required.");return e<t?t:e>r?r:e};var u=new e;return i.setRandomNumberSeed=function(t){if(!n(t))throw new o("seed is required.");u=new e(t)},i.nextRandomNumber=function(){return u.random()},i.randomBetween=function(e,t){return i.nextRandomNumber()*(t-e)+e},i.acosClamped=function(e){if(!n(e))throw new o("value is required.");return Math.acos(i.clamp(e,-1,1))},i.asinClamped=function(e){if(!n(e))throw new o("value is required.");return Math.asin(i.clamp(e,-1,1))},i.chordLength=function(e,t){if(!n(e))throw new o("angle is required.");if(!n(t))throw new o("radius is required.");return 2*t*Math.sin(.5*e)},i.logBase=function(e,t){if(!n(e))throw new o("number is required.");if(!n(t))throw new o("base is required.");return Math.log(e)/Math.log(t)},i.cbrt=r(Math.cbrt,(function(e){var t=Math.pow(Math.abs(e),1/3);return e<0?-t:t})),i.log2=r(Math.log2,(function(e){return Math.log(e)*Math.LOG2E})),i.fog=function(e,t){var r=e*t;return 1-Math.exp(-r*r)},i.fastApproximateAtan=function(e){return t.typeOf.number("x",e),e*(-.1784*Math.abs(e)-.0663*e*e+1.0301)},i.fastApproximateAtan2=function(e,r){var n,a;t.typeOf.number("x",e),t.typeOf.number("y",r);var u=Math.abs(e);n=Math.abs(r),a=Math.max(u,n);var s=(n=Math.min(u,n))/a;if(isNaN(s))throw new o("either x or y must be nonzero");return u=i.fastApproximateAtan(s),u=Math.abs(r)>Math.abs(e)?i.PI_OVER_TWO-u:u,u=e<0?i.PI-u:u,u=r<0?-u:u},i})),define("Core/Cartesian2",["./Check","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],(function(e,t,r,n,o,i){"use strict";function a(e,r){this.x=t(e,0),this.y=t(r,0)}a.fromElements=function(e,t,n){return r(n)?(n.x=e,n.y=t,n):new a(e,t)},a.clone=function(e,t){if(r(e))return r(t)?(t.x=e.x,t.y=e.y,t):new a(e.x,e.y)},a.fromCartesian3=a.clone,a.fromCartesian4=a.clone,a.packedLength=2,a.pack=function(r,n,o){return e.typeOf.object("value",r),e.defined("array",n),o=t(o,0),n[o++]=r.x,n[o]=r.y,n},a.unpack=function(n,o,i){return e.defined("array",n),o=t(o,0),r(i)||(i=new a),i.x=n[o++],i.y=n[o],i},a.packArray=function(t,n){e.defined("array",t);var o=t.length;r(n)?n.length=2*o:n=new Array(2*o);for(var i=0;i<o;++i)a.pack(t[i],n,2*i);return n},a.unpackArray=function(t,n){e.defined("array",t);var o=t.length;r(n)?n.length=o/2:n=new Array(o/2);for(var i=0;i<o;i+=2){var u=i/2;n[u]=a.unpack(t,i,n[u])}return n},a.fromArray=a.unpack,a.maximumComponent=function(t){return e.typeOf.object("cartesian",t),Math.max(t.x,t.y)},a.minimumComponent=function(t){return e.typeOf.object("cartesian",t),Math.min(t.x,t.y)},a.minimumByComponent=function(t,r,n){return e.typeOf.object("first",t),e.typeOf.object("second",r),e.typeOf.object("result",n),n.x=Math.min(t.x,r.x),n.y=Math.min(t.y,r.y),n},a.maximumByComponent=function(t,r,n){return e.typeOf.object("first",t),e.typeOf.object("second",r),e.typeOf.object("result",n),n.x=Math.max(t.x,r.x),n.y=Math.max(t.y,r.y),n},a.magnitudeSquared=function(t){return e.typeOf.object("cartesian",t),t.x*t.x+t.y*t.y},a.magnitude=function(e){return Math.sqrt(a.magnitudeSquared(e))};var u=new a;a.distance=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),a.subtract(t,r,u),a.magnitude(u)},a.distanceSquared=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),a.subtract(t,r,u),a.magnitudeSquared(u)},a.normalize=function(t,r){e.typeOf.object("cartesian",t),e.typeOf.object("result",r);var o=a.magnitude(t);if(r.x=t.x/o,r.y=t.y/o,isNaN(r.x)||isNaN(r.y))throw new n("normalized result is not a number");return r},a.dot=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),t.x*r.x+t.y*r.y},a.multiplyComponents=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x*r.x,n.y=t.y*r.y,n},a.divideComponents=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x/r.x,n.y=t.y/r.y,n},a.add=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x+r.x,n.y=t.y+r.y,n},a.subtract=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x-r.x,n.y=t.y-r.y,n},a.multiplyByScalar=function(t,r,n){return e.typeOf.object("cartesian",t),e.typeOf.number("scalar",r),e.typeOf.object("result",n),n.x=t.x*r,n.y=t.y*r,n},a.divideByScalar=function(t,r,n){return e.typeOf.object("cartesian",t),e.typeOf.number("scalar",r),e.typeOf.object("result",n),n.x=t.x/r,n.y=t.y/r,n},a.negate=function(t,r){return e.typeOf.object("cartesian",t),e.typeOf.object("result",r),r.x=-t.x,r.y=-t.y,r},a.abs=function(t,r){return e.typeOf.object("cartesian",t),e.typeOf.object("result",r),r.x=Math.abs(t.x),r.y=Math.abs(t.y),r};var s=new a;a.lerp=function(t,r,n,o){return e.typeOf.object("start",t),e.typeOf.object("end",r),e.typeOf.number("t",n),e.typeOf.object("result",o),a.multiplyByScalar(r,n,s),o=a.multiplyByScalar(t,1-n,o),a.add(s,o,o)};var c=new a,f=new a;a.angleBetween=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),a.normalize(t,c),a.normalize(r,f),i.acosClamped(a.dot(c,f))};var l=new a;return a.mostOrthogonalAxis=function(t,r){e.typeOf.object("cartesian",t),e.typeOf.object("result",r);var n=a.normalize(t,l);return a.abs(n,n),r=n.x<=n.y?a.clone(a.UNIT_X,r):a.clone(a.UNIT_Y,r)},a.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y},a.equalsArray=function(e,t,r){return e.x===t[r]&&e.y===t[r+1]},a.equalsEpsilon=function(e,t,n,o){return e===t||r(e)&&r(t)&&i.equalsEpsilon(e.x,t.x,n,o)&&i.equalsEpsilon(e.y,t.y,n,o)},a.ZERO=o(new a(0,0)),a.UNIT_X=o(new a(1,0)),a.UNIT_Y=o(new a(0,1)),a.prototype.clone=function(e){return a.clone(this,e)},a.prototype.equals=function(e){return a.equals(this,e)},a.prototype.equalsEpsilon=function(e,t,r){return a.equalsEpsilon(this,e,t,r)},a.prototype.toString=function(){return"("+this.x+", "+this.y+")"},a})),define("Core/Cartesian3",["./Check","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],(function(e,t,r,n,o,i){"use strict";function a(e,r,n){this.x=t(e,0),this.y=t(r,0),this.z=t(n,0)}a.fromSpherical=function(n,o){e.typeOf.object("spherical",n),r(o)||(o=new a);var i=n.clock,u=n.cone,s=t(n.magnitude,1),c=s*Math.sin(u);return o.x=c*Math.cos(i),o.y=c*Math.sin(i),o.z=s*Math.cos(u),o},a.fromElements=function(e,t,n,o){return r(o)?(o.x=e,o.y=t,o.z=n,o):new a(e,t,n)},a.clone=function(e,t){if(r(e))return r(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t):new a(e.x,e.y,e.z)},a.fromCartesian4=a.clone,a.packedLength=3,a.pack=function(r,n,o){return e.typeOf.object("value",r),e.defined("array",n),o=t(o,0),n[o++]=r.x,n[o++]=r.y,n[o]=r.z,n},a.unpack=function(n,o,i){return e.defined("array",n),o=t(o,0),r(i)||(i=new a),i.x=n[o++],i.y=n[o++],i.z=n[o],i},a.packArray=function(t,n){e.defined("array",t);var o=t.length;r(n)?n.length=3*o:n=new Array(3*o);for(var i=0;i<o;++i)a.pack(t[i],n,3*i);return n},a.unpackArray=function(t,o){if(e.defined("array",t),e.typeOf.number.greaterThanOrEquals("array.length",t.length,3),t.length%3!=0)throw new n("array length must be a multiple of 3.");var i=t.length;r(o)?o.length=i/3:o=new Array(i/3);for(var u=0;u<i;u+=3){var s=u/3;o[s]=a.unpack(t,u,o[s])}return o},a.fromArray=a.unpack,a.maximumComponent=function(t){return e.typeOf.object("cartesian",t),Math.max(t.x,t.y,t.z)},a.minimumComponent=function(t){return e.typeOf.object("cartesian",t),Math.min(t.x,t.y,t.z)},a.minimumByComponent=function(t,r,n){return e.typeOf.object("first",t),e.typeOf.object("second",r),e.typeOf.object("result",n),n.x=Math.min(t.x,r.x),n.y=Math.min(t.y,r.y),n.z=Math.min(t.z,r.z),n},a.maximumByComponent=function(t,r,n){return e.typeOf.object("first",t),e.typeOf.object("second",r),e.typeOf.object("result",n),n.x=Math.max(t.x,r.x),n.y=Math.max(t.y,r.y),n.z=Math.max(t.z,r.z),n},a.magnitudeSquared=function(t){return e.typeOf.object("cartesian",t),t.x*t.x+t.y*t.y+t.z*t.z},a.magnitude=function(e){return Math.sqrt(a.magnitudeSquared(e))};var u=new a;a.distance=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),a.subtract(t,r,u),a.magnitude(u)},a.distanceSquared=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),a.subtract(t,r,u),a.magnitudeSquared(u)},a.normalize=function(t,r){e.typeOf.object("cartesian",t),e.typeOf.object("result",r);var o=a.magnitude(t);if(r.x=t.x/o,r.y=t.y/o,r.z=t.z/o,isNaN(r.x)||isNaN(r.y)||isNaN(r.z))throw new n("normalized result is not a number");return r},a.dot=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),t.x*r.x+t.y*r.y+t.z*r.z},a.multiplyComponents=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x*r.x,n.y=t.y*r.y,n.z=t.z*r.z,n},a.divideComponents=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x/r.x,n.y=t.y/r.y,n.z=t.z/r.z,n},a.add=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x+r.x,n.y=t.y+r.y,n.z=t.z+r.z,n},a.subtract=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x-r.x,n.y=t.y-r.y,n.z=t.z-r.z,n},a.multiplyByScalar=function(t,r,n){return e.typeOf.object("cartesian",t),e.typeOf.number("scalar",r),e.typeOf.object("result",n),n.x=t.x*r,n.y=t.y*r,n.z=t.z*r,n},a.divideByScalar=function(t,r,n){return e.typeOf.object("cartesian",t),e.typeOf.number("scalar",r),e.typeOf.object("result",n),n.x=t.x/r,n.y=t.y/r,n.z=t.z/r,n},a.negate=function(t,r){return e.typeOf.object("cartesian",t),e.typeOf.object("result",r),r.x=-t.x,r.y=-t.y,r.z=-t.z,r},a.abs=function(t,r){return e.typeOf.object("cartesian",t),e.typeOf.object("result",r),r.x=Math.abs(t.x),r.y=Math.abs(t.y),r.z=Math.abs(t.z),r};var s=new a;a.lerp=function(t,r,n,o){return e.typeOf.object("start",t),e.typeOf.object("end",r),e.typeOf.number("t",n),e.typeOf.object("result",o),a.multiplyByScalar(r,n,s),o=a.multiplyByScalar(t,1-n,o),a.add(s,o,o)};var c=new a,f=new a;a.angleBetween=function(t,r){e.typeOf.object("left",t),e.typeOf.object("right",r),a.normalize(t,c),a.normalize(r,f);var n=a.dot(c,f),o=a.magnitude(a.cross(c,f,c));return Math.atan2(o,n)};var l=new a;a.mostOrthogonalAxis=function(t,r){e.typeOf.object("cartesian",t),e.typeOf.object("result",r);var n=a.normalize(t,l);return a.abs(n,n),r=n.x<=n.y?n.x<=n.z?a.clone(a.UNIT_X,r):a.clone(a.UNIT_Z,r):n.y<=n.z?a.clone(a.UNIT_Y,r):a.clone(a.UNIT_Z,r)},a.projectVector=function(t,r,n){e.defined("a",t),e.defined("b",r),e.defined("result",n);var o=a.dot(t,r)/a.dot(r,r);return a.multiplyByScalar(r,o,n)},a.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z},a.equalsArray=function(e,t,r){return e.x===t[r]&&e.y===t[r+1]&&e.z===t[r+2]},a.equalsEpsilon=function(e,t,n,o){return e===t||r(e)&&r(t)&&i.equalsEpsilon(e.x,t.x,n,o)&&i.equalsEpsilon(e.y,t.y,n,o)&&i.equalsEpsilon(e.z,t.z,n,o)},a.cross=function(t,r,n){e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n);var o=t.x,i=t.y,a=t.z,u=r.x,s=r.y,c=r.z,f=i*c-a*s,l=a*u-o*c,d=o*s-i*u;return n.x=f,n.y=l,n.z=d,n},a.midpoint=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=.5*(t.x+r.x),n.y=.5*(t.y+r.y),n.z=.5*(t.z+r.z),n},a.fromDegrees=function(t,r,n,o,u){return e.typeOf.number("longitude",t),e.typeOf.number("latitude",r),t=i.toRadians(t),r=i.toRadians(r),a.fromRadians(t,r,n,o,u)};var d=new a,h=new a,p=new a(40680631590769,40680631590769,40408299984661.445);return a.fromRadians=function(n,o,i,u,s){e.typeOf.number("longitude",n),e.typeOf.number("latitude",o),i=t(i,0);var c=r(u)?u.radiiSquared:p,f=Math.cos(o);d.x=f*Math.cos(n),d.y=f*Math.sin(n),d.z=Math.sin(o),d=a.normalize(d,d),a.multiplyComponents(c,d,h);var l=Math.sqrt(a.dot(d,h));return h=a.divideByScalar(h,l,h),d=a.multiplyByScalar(d,i,d),r(s)||(s=new a),a.add(h,d,s)},a.fromDegreesArray=function(t,o,i){if(e.defined("coordinates",t),t.length<2||t.length%2!=0)throw new n("the number of coordinates must be a multiple of 2 and at least 2");var u=t.length;r(i)?i.length=u/2:i=new Array(u/2);for(var s=0;s<u;s+=2){var c=t[s],f=t[s+1],l=s/2;i[l]=a.fromDegrees(c,f,0,o,i[l])}return i},a.fromRadiansArray=function(t,o,i){if(e.defined("coordinates",t),t.length<2||t.length%2!=0)throw new n("the number of coordinates must be a multiple of 2 and at least 2");var u=t.length;r(i)?i.length=u/2:i=new Array(u/2);for(var s=0;s<u;s+=2){var c=t[s],f=t[s+1],l=s/2;i[l]=a.fromRadians(c,f,0,o,i[l])}return i},a.fromDegreesArrayHeights=function(t,o,i){if(e.defined("coordinates",t),t.length<3||t.length%3!=0)throw new n("the number of coordinates must be a multiple of 3 and at least 3");var u=t.length;r(i)?i.length=u/3:i=new Array(u/3);for(var s=0;s<u;s+=3){var c=t[s],f=t[s+1],l=t[s+2],d=s/3;i[d]=a.fromDegrees(c,f,l,o,i[d])}return i},a.fromRadiansArrayHeights=function(t,o,i){if(e.defined("coordinates",t),t.length<3||t.length%3!=0)throw new n("the number of coordinates must be a multiple of 3 and at least 3");var u=t.length;r(i)?i.length=u/3:i=new Array(u/3);for(var s=0;s<u;s+=3){var c=t[s],f=t[s+1],l=t[s+2],d=s/3;i[d]=a.fromRadians(c,f,l,o,i[d])}return i},a.ZERO=o(new a(0,0,0)),a.UNIT_X=o(new a(1,0,0)),a.UNIT_Y=o(new a(0,1,0)),a.UNIT_Z=o(new a(0,0,1)),a.prototype.clone=function(e){return a.clone(this,e)},a.prototype.equals=function(e){return a.equals(this,e)},a.prototype.equalsEpsilon=function(e,t,r){return a.equalsEpsilon(this,e,t,r)},a.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+")"},a})),define("Core/AttributeCompression",["./Cartesian2","./Cartesian3","./Check","./defined","./DeveloperError","./Math"],(function(e,t,r,n,o,i){"use strict";var a={octEncodeInRange:function(e,n,a){r.defined("vector",e),r.defined("result",a);var u=t.magnitudeSquared(e);if(Math.abs(u-1)>i.EPSILON6)throw new o("vector must be normalized.");if(a.x=e.x/(Math.abs(e.x)+Math.abs(e.y)+Math.abs(e.z)),a.y=e.y/(Math.abs(e.x)+Math.abs(e.y)+Math.abs(e.z)),e.z<0){var s=a.x,c=a.y;a.x=(1-Math.abs(c))*i.signNotZero(s),a.y=(1-Math.abs(s))*i.signNotZero(c)}return a.x=i.toSNorm(a.x,n),a.y=i.toSNorm(a.y,n),a},octEncode:function(e,t){return a.octEncodeInRange(e,255,t)}},u=new e,s=new Uint8Array(1);function c(e){return s[0]=e,s[0]}a.octEncodeToCartesian4=function(e,t){return a.octEncodeInRange(e,65535,u),t.x=c(u.x*(1/256)),t.y=c(u.x),t.z=c(u.y*(1/256)),t.w=c(u.y),t},a.octDecodeInRange=function(e,n,a,u){if(r.defined("result",u),e<0||e>a||n<0||n>a)throw new o("x and y must be unsigned normalized integers between 0 and "+a);if(u.x=i.fromSNorm(e,a),u.y=i.fromSNorm(n,a),u.z=1-(Math.abs(u.x)+Math.abs(u.y)),u.z<0){var s=u.x;u.x=(1-Math.abs(u.y))*i.signNotZero(s),u.y=(1-Math.abs(s))*i.signNotZero(u.y)}return t.normalize(u,u)},a.octDecode=function(e,t,r){return a.octDecodeInRange(e,t,255,r)},a.octDecodeFromCartesian4=function(e,t){r.typeOf.object("encoded",e),r.typeOf.object("result",t);var n=e.x,i=e.y,u=e.z,s=e.w;if(n<0||n>255||i<0||i>255||u<0||u>255||s<0||s>255)throw new o("x, y, z, and w must be unsigned normalized integers between 0 and 255");var c=256*n+i,f=256*u+s;return a.octDecodeInRange(c,f,65535,t)},a.octPackFloat=function(e){return r.defined("encoded",e),256*e.x+e.y};var f=new e;function l(e){return e>>1^-(1&e)}return a.octEncodeFloat=function(e){return a.octEncode(e,f),a.octPackFloat(f)},a.octDecodeFloat=function(e,t){r.defined("value",e);var n=e/256,o=Math.floor(n),i=256*(n-o);return a.octDecode(o,i,t)},a.octPack=function(e,t,n,o){r.defined("v1",e),r.defined("v2",t),r.defined("v3",n),r.defined("result",o);var i=a.octEncodeFloat(e),u=a.octEncodeFloat(t),s=a.octEncode(n,f);return o.x=65536*s.x+i,o.y=65536*s.y+u,o},a.octUnpack=function(e,t,n,o){r.defined("packed",e),r.defined("v1",t),r.defined("v2",n),r.defined("v3",o);var i=e.x/65536,u=Math.floor(i),s=65536*(i-u);i=e.y/65536;var c=Math.floor(i),f=65536*(i-c);a.octDecodeFloat(s,t),a.octDecodeFloat(f,n),a.octDecode(u,c,o)},a.compressTextureCoordinates=function(e){return r.defined("textureCoordinates",e),4096*(4095*e.x|0)+(4095*e.y|0)},a.decompressTextureCoordinates=function(e,t){r.defined("compressed",e),r.defined("result",t);var n=e/4096,o=Math.floor(n);return t.x=o/4095,t.y=(e-4096*o)/4095,t},a.zigZagDeltaDecode=function(e,t,o){r.defined("uBuffer",e),r.defined("vBuffer",t),r.typeOf.number.equals("uBuffer.length","vBuffer.length",e.length,t.length),n(o)&&r.typeOf.number.equals("uBuffer.length","heightBuffer.length",e.length,o.length);for(var i=e.length,a=0,u=0,s=0,c=0;c<i;++c)a+=l(e[c]),u+=l(t[c]),e[c]=a,t[c]=u,n(o)&&(s+=l(o[c]),o[c]=s)},a})),define("Core/scaleToGeodeticSurface",["./Cartesian3","./defined","./DeveloperError","./Math"],(function(e,t,r,n){"use strict";var o=new e,i=new e;return function(a,u,s,c,f){if(!t(a))throw new r("cartesian is required.");if(!t(u))throw new r("oneOverRadii is required.");if(!t(s))throw new r("oneOverRadiiSquared is required.");if(!t(c))throw new r("centerToleranceSquared is required.");var l=a.x,d=a.y,h=a.z,p=u.x,m=u.y,y=u.z,E=l*l*p*p,O=d*d*m*m,_=h*h*y*y,R=E+O+_,T=Math.sqrt(1/R),g=e.multiplyByScalar(a,T,o);if(R<c)return isFinite(T)?e.clone(g,f):void 0;var w=s.x,A=s.y,b=s.z,C=i;C.x=g.x*w*2,C.y=g.y*A*2,C.z=g.z*b*2;var S,v,I,N,M,x,P,D=(1-T)*e.magnitude(a)/(.5*e.magnitude(C)),F=0;do{F=(S=E*(M=(v=1/(1+(D-=F)*w))*v)+O*(x=(I=1/(1+D*A))*I)+_*(P=(N=1/(1+D*b))*N)-1)/(-2*(E*(M*v)*w+O*(x*I)*A+_*(P*N)*b))}while(Math.abs(S)>n.EPSILON12);return t(f)?(f.x=l*v,f.y=d*I,f.z=h*N,f):new e(l*v,d*I,h*N)}})),define("Core/Cartographic",["./Cartesian3","./Check","./defaultValue","./defined","./freezeObject","./Math","./scaleToGeodeticSurface"],(function(e,t,r,n,o,i,a){"use strict";function u(e,t,n){this.longitude=r(e,0),this.latitude=r(t,0),this.height=r(n,0)}u.fromRadians=function(e,o,i,a){return t.typeOf.number("longitude",e),t.typeOf.number("latitude",o),i=r(i,0),n(a)?(a.longitude=e,a.latitude=o,a.height=i,a):new u(e,o,i)},u.fromDegrees=function(e,r,n,o){return t.typeOf.number("longitude",e),t.typeOf.number("latitude",r),e=i.toRadians(e),r=i.toRadians(r),u.fromRadians(e,r,n,o)};var s=new e,c=new e,f=new e,l=new e(1/6378137,1/6378137,1/6356752.314245179),d=new e(1/40680631590769,1/40680631590769,1/40408299984661.445),h=i.EPSILON1;return u.fromCartesian=function(t,r,o){var p=n(r)?r.oneOverRadii:l,m=n(r)?r.oneOverRadiiSquared:d,y=n(r)?r._centerToleranceSquared:h,E=a(t,p,m,y,c);if(n(E)){var O=e.multiplyComponents(E,m,s);O=e.normalize(O,O);var _=e.subtract(t,E,f),R=Math.atan2(O.y,O.x),T=Math.asin(O.z),g=i.sign(e.dot(_,t))*e.magnitude(_);return n(o)?(o.longitude=R,o.latitude=T,o.height=g,o):new u(R,T,g)}},u.toCartesian=function(r,n,o){return t.defined("cartographic",r),e.fromRadians(r.longitude,r.latitude,r.height,n,o)},u.clone=function(e,t){if(n(e))return n(t)?(t.longitude=e.longitude,t.latitude=e.latitude,t.height=e.height,t):new u(e.longitude,e.latitude,e.height)},u.equals=function(e,t){return e===t||n(e)&&n(t)&&e.longitude===t.longitude&&e.latitude===t.latitude&&e.height===t.height},u.equalsEpsilon=function(e,r,o){return t.typeOf.number("epsilon",o),e===r||n(e)&&n(r)&&Math.abs(e.longitude-r.longitude)<=o&&Math.abs(e.latitude-r.latitude)<=o&&Math.abs(e.height-r.height)<=o},u.ZERO=o(new u(0,0,0)),u.prototype.clone=function(e){return u.clone(this,e)},u.prototype.equals=function(e){return u.equals(this,e)},u.prototype.equalsEpsilon=function(e,t){return u.equalsEpsilon(this,e,t)},u.prototype.toString=function(){return"("+this.longitude+", "+this.latitude+", "+this.height+")"},u})),define("Core/defineProperties",["./defined"],(function(e){"use strict";var t=function(){try{return"x"in Object.defineProperty({},"x",{})}catch(e){return!1}}(),r=Object.defineProperties;return t&&e(r)||(r=function(e){return e}),r})),define("Core/Fullscreen",["./defined","./defineProperties"],(function(e,t){"use strict";var r,n={requestFullscreen:void 0,exitFullscreen:void 0,fullscreenEnabled:void 0,fullscreenElement:void 0,fullscreenchange:void 0,fullscreenerror:void 0},o={};return t(o,{element:{get:function(){if(o.supportsFullscreen())return document[n.fullscreenElement]}},changeEventName:{get:function(){if(o.supportsFullscreen())return n.fullscreenchange}},errorEventName:{get:function(){if(o.supportsFullscreen())return n.fullscreenerror}},enabled:{get:function(){if(o.supportsFullscreen())return document[n.fullscreenEnabled]}},fullscreen:{get:function(){if(o.supportsFullscreen())return null!==o.element}}}),o.supportsFullscreen=function(){if(e(r))return r;r=!1;var t=document.body;if("function"==typeof t.requestFullscreen)return n.requestFullscreen="requestFullscreen",n.exitFullscreen="exitFullscreen",n.fullscreenEnabled="fullscreenEnabled",n.fullscreenElement="fullscreenElement",n.fullscreenchange="fullscreenchange",n.fullscreenerror="fullscreenerror",r=!0;for(var o,i=["webkit","moz","o","ms","khtml"],a=0,u=i.length;a<u;++a){var s=i[a];("function"==typeof t[o=s+"RequestFullscreen"]||"function"==typeof t[o=s+"RequestFullScreen"])&&(n.requestFullscreen=o,r=!0),o=s+"ExitFullscreen","function"==typeof document[o]?n.exitFullscreen=o:(o=s+"CancelFullScreen","function"==typeof document[o]&&(n.exitFullscreen=o)),o=s+"FullscreenEnabled",void 0!==document[o]?n.fullscreenEnabled=o:(o=s+"FullScreenEnabled",void 0!==document[o]&&(n.fullscreenEnabled=o)),o=s+"FullscreenElement",void 0!==document[o]?n.fullscreenElement=o:(o=s+"FullScreenElement",void 0!==document[o]&&(n.fullscreenElement=o)),o=s+"fullscreenchange",void 0!==document["on"+o]&&("ms"===s&&(o="MSFullscreenChange"),n.fullscreenchange=o),o=s+"fullscreenerror",void 0!==document["on"+o]&&("ms"===s&&(o="MSFullscreenError"),n.fullscreenerror=o)}return r},o.requestFullscreen=function(e,t){o.supportsFullscreen()&&e[n.requestFullscreen]({vrDisplay:t})},o.exitFullscreen=function(){o.supportsFullscreen()&&document[n.exitFullscreen]()},o})),define("Core/FeatureDetection",["./defaultValue","./defined","./Fullscreen"],(function(e,t,r){"use strict";var n,o,i,a,u,s,c,f,l,d,h,p,m,y,E,O,_;function R(e){for(var t=e.split("."),r=0,n=t.length;r<n;++r)t[r]=parseInt(t[r],10);return t}function T(){if(!t(o)&&(o=!1,!b())){var e=/ Chrome\/([\.0-9]+)/.exec(n.userAgent);null!==e&&(o=!0,i=R(e[1]))}return o}function g(){if(!t(a)&&(a=!1,!T()&&!b()&&/ Safari\/[\.0-9]+/.test(n.userAgent))){var e=/ Version\/([\.0-9]+)/.exec(n.userAgent);null!==e&&(a=!0,u=R(e[1]))}return a}function w(){if(!t(s)){s=!1;var e=/ AppleWebKit\/([\.0-9]+)(\+?)/.exec(n.userAgent);null!==e&&(s=!0,(c=R(e[1])).isNightly=!!e[2])}return s}function A(){var e;return t(f)||(f=!1,"Microsoft Internet Explorer"===n.appName?null!==(e=/MSIE ([0-9]{1,}[\.0-9]{0,})/.exec(n.userAgent))&&(f=!0,l=R(e[1])):"Netscape"===n.appName&&null!==(e=/Trident\/.*rv:([0-9]{1,}[\.0-9]{0,})/.exec(n.userAgent))&&(f=!0,l=R(e[1]))),f}function b(){if(!t(d)){d=!1;var e=/ Edge\/([\.0-9]+)/.exec(n.userAgent);null!==e&&(d=!0,h=R(e[1]))}return d}function C(){if(!t(p)){p=!1;var e=/Firefox\/([\.0-9]+)/.exec(n.userAgent);null!==e&&(p=!0,m=R(e[1]))}return p}function S(){if(!t(_)){var e=document.createElement("canvas");e.setAttribute("style","image-rendering: -moz-crisp-edges;image-rendering: pixelated;");var r=e.style.imageRendering;(_=t(r)&&""!==r)&&(O=r)}return _}n="undefined"!=typeof navigator?navigator:{};var v=[];"undefined"!=typeof ArrayBuffer&&(v.push(Int8Array,Uint8Array,Int16Array,Uint16Array,Int32Array,Uint32Array,Float32Array,Float64Array),"undefined"!=typeof Uint8ClampedArray&&v.push(Uint8ClampedArray),"undefined"!=typeof CanvasPixelArray&&v.push(CanvasPixelArray));var I={isChrome:T,chromeVersion:function(){return T()&&i},isSafari:g,safariVersion:function(){return g()&&u},isWebkit:w,webkitVersion:function(){return w()&&c},isInternetExplorer:A,internetExplorerVersion:function(){return A()&&l},isEdge:b,edgeVersion:function(){return b()&&h},isFirefox:C,firefoxVersion:function(){return C()&&m},isWindows:function(){return t(y)||(y=/Windows/i.test(n.appVersion)),y},hardwareConcurrency:e(n.hardwareConcurrency,3),supportsPointerEvents:function(){return t(E)||(E=!C()&&"undefined"!=typeof PointerEvent&&(!t(n.pointerEnabled)||n.pointerEnabled)),E},supportsImageRenderingPixelated:S,imageRenderingValue:function(){return S()?O:void 0},typedArrayTypes:v,supportsFullscreen:function(){return r.supportsFullscreen()},supportsTypedArrays:function(){return"undefined"!=typeof ArrayBuffer},supportsWebWorkers:function(){return"undefined"!=typeof Worker},supportsWebAssembly:function(){return"undefined"!=typeof WebAssembly&&!I.isEdge()}};return I})),define("Core/Color",["./Check","./defaultValue","./defined","./FeatureDetection","./freezeObject","./Math"],(function(e,t,r,n,o,i){"use strict";function a(e,t,r){return r<0&&(r+=1),r>1&&(r-=1),6*r<1?e+6*(t-e)*r:2*r<1?t:3*r<2?e+(t-e)*(2/3-r)*6:e}function u(e,r,n,o){this.red=t(e,1),this.green=t(r,1),this.blue=t(n,1),this.alpha=t(o,1)}var s,c,f;u.fromCartesian4=function(t,n){return e.typeOf.object("cartesian",t),r(n)?(n.red=t.x,n.green=t.y,n.blue=t.z,n.alpha=t.w,n):new u(t.x,t.y,t.z,t.w)},u.fromBytes=function(e,n,o,i,a){return e=u.byteToFloat(t(e,255)),n=u.byteToFloat(t(n,255)),o=u.byteToFloat(t(o,255)),i=u.byteToFloat(t(i,255)),r(a)?(a.red=e,a.green=n,a.blue=o,a.alpha=i,a):new u(e,n,o,i)},u.fromAlpha=function(t,n,o){return e.typeOf.object("color",t),e.typeOf.number("alpha",n),r(o)?(o.red=t.red,o.green=t.green,o.blue=t.blue,o.alpha=n,o):new u(t.red,t.green,t.blue,n)},n.supportsTypedArrays()&&(s=new ArrayBuffer(4),c=new Uint32Array(s),f=new Uint8Array(s)),u.fromRgba=function(e,t){return c[0]=e,u.fromBytes(f[0],f[1],f[2],f[3],t)},u.fromHsl=function(e,n,o,i,s){e=t(e,0)%1,n=t(n,0),o=t(o,0),i=t(i,1);var c=o,f=o,l=o;if(0!==n){var d,h=2*o-(d=o<.5?o*(1+n):o+n-o*n);c=a(h,d,e+1/3),f=a(h,d,e),l=a(h,d,e-1/3)}return r(s)?(s.red=c,s.green=f,s.blue=l,s.alpha=i,s):new u(c,f,l,i)},u.fromRandom=function(n,o){var a=(n=t(n,t.EMPTY_OBJECT)).red;if(!r(a)){var s=t(n.minimumRed,0),c=t(n.maximumRed,1);e.typeOf.number.lessThanOrEquals("minimumRed",s,c),a=s+i.nextRandomNumber()*(c-s)}var f=n.green;if(!r(f)){var l=t(n.minimumGreen,0),d=t(n.maximumGreen,1);e.typeOf.number.lessThanOrEquals("minimumGreen",l,d),f=l+i.nextRandomNumber()*(d-l)}var h=n.blue;if(!r(h)){var p=t(n.minimumBlue,0),m=t(n.maximumBlue,1);e.typeOf.number.lessThanOrEquals("minimumBlue",p,m),h=p+i.nextRandomNumber()*(m-p)}var y=n.alpha;if(!r(y)){var E=t(n.minimumAlpha,0),O=t(n.maximumAlpha,1);e.typeOf.number.lessThanOrEquals("minumumAlpha",E,O),y=E+i.nextRandomNumber()*(O-E)}return r(o)?(o.red=a,o.green=f,o.blue=h,o.alpha=y,o):new u(a,f,h,y)};var l=/^#([0-9a-f])([0-9a-f])([0-9a-f])$/i,d=/^#([0-9a-f]{2})([0-9a-f]{2})([0-9a-f]{2})$/i,h=/^rgba?\(\s*([0-9.]+%?)\s*,\s*([0-9.]+%?)\s*,\s*([0-9.]+%?)(?:\s*,\s*([0-9.]+))?\s*\)$/i,p=/^hsla?\(\s*([0-9.]+)\s*,\s*([0-9.]+%)\s*,\s*([0-9.]+%)(?:\s*,\s*([0-9.]+))?\s*\)$/i;return u.fromCssColorString=function(n,o){e.typeOf.string("color",n),r(o)||(o=new u);var i=u[n.toUpperCase()];if(r(i))return u.clone(i,o),o;var a=l.exec(n);return null!==a?(o.red=parseInt(a[1],16)/15,o.green=parseInt(a[2],16)/15,o.blue=parseInt(a[3],16)/15,o.alpha=1,o):null!==(a=d.exec(n))?(o.red=parseInt(a[1],16)/255,o.green=parseInt(a[2],16)/255,o.blue=parseInt(a[3],16)/255,o.alpha=1,o):null!==(a=h.exec(n))?(o.red=parseFloat(a[1])/("%"===a[1].substr(-1)?100:255),o.green=parseFloat(a[2])/("%"===a[2].substr(-1)?100:255),o.blue=parseFloat(a[3])/("%"===a[3].substr(-1)?100:255),o.alpha=parseFloat(t(a[4],"1.0")),o):null!==(a=p.exec(n))?u.fromHsl(parseFloat(a[1])/360,parseFloat(a[2])/100,parseFloat(a[3])/100,parseFloat(t(a[4],"1.0")),o):o=void 0},u.packedLength=4,u.pack=function(r,n,o){return e.typeOf.object("value",r),e.defined("array",n),o=t(o,0),n[o++]=r.red,n[o++]=r.green,n[o++]=r.blue,n[o]=r.alpha,n},u.unpack=function(n,o,i){return e.defined("array",n),o=t(o,0),r(i)||(i=new u),i.red=n[o++],i.green=n[o++],i.blue=n[o++],i.alpha=n[o],i},u.byteToFloat=function(e){return e/255},u.floatToByte=function(e){return 1===e?255:256*e|0},u.clone=function(e,t){if(r(e))return r(t)?(t.red=e.red,t.green=e.green,t.blue=e.blue,t.alpha=e.alpha,t):new u(e.red,e.green,e.blue,e.alpha)},u.equals=function(e,t){return e===t||r(e)&&r(t)&&e.red===t.red&&e.green===t.green&&e.blue===t.blue&&e.alpha===t.alpha},u.equalsArray=function(e,t,r){return e.red===t[r]&&e.green===t[r+1]&&e.blue===t[r+2]&&e.alpha===t[r+3]},u.prototype.clone=function(e){return u.clone(this,e)},u.prototype.equals=function(e){return u.equals(this,e)},u.prototype.equalsEpsilon=function(e,t){return this===e||r(e)&&Math.abs(this.red-e.red)<=t&&Math.abs(this.green-e.green)<=t&&Math.abs(this.blue-e.blue)<=t&&Math.abs(this.alpha-e.alpha)<=t},u.prototype.toString=function(){return"("+this.red+", "+this.green+", "+this.blue+", "+this.alpha+")"},u.prototype.toCssColorString=function(){var e=u.floatToByte(this.red),t=u.floatToByte(this.green),r=u.floatToByte(this.blue);return 1===this.alpha?"rgb("+e+","+t+","+r+")":"rgba("+e+","+t+","+r+","+this.alpha+")"},u.prototype.toBytes=function(e){var t=u.floatToByte(this.red),n=u.floatToByte(this.green),o=u.floatToByte(this.blue),i=u.floatToByte(this.alpha);return r(e)?(e[0]=t,e[1]=n,e[2]=o,e[3]=i,e):[t,n,o,i]},u.prototype.toRgba=function(){return f[0]=u.floatToByte(this.red),f[1]=u.floatToByte(this.green),f[2]=u.floatToByte(this.blue),f[3]=u.floatToByte(this.alpha),c[0]},u.prototype.brighten=function(t,r){return e.typeOf.number("magnitude",t),e.typeOf.number.greaterThanOrEquals("magnitude",t,0),e.typeOf.object("result",r),t=1-t,r.red=1-(1-this.red)*t,r.green=1-(1-this.green)*t,r.blue=1-(1-this.blue)*t,r.alpha=this.alpha,r},u.prototype.darken=function(t,r){return e.typeOf.number("magnitude",t),e.typeOf.number.greaterThanOrEquals("magnitude",t,0),e.typeOf.object("result",r),t=1-t,r.red=this.red*t,r.green=this.green*t,r.blue=this.blue*t,r.alpha=this.alpha,r},u.prototype.withAlpha=function(e,t){return u.fromAlpha(this,e,t)},u.add=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.red=t.red+r.red,n.green=t.green+r.green,n.blue=t.blue+r.blue,n.alpha=t.alpha+r.alpha,n},u.subtract=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.red=t.red-r.red,n.green=t.green-r.green,n.blue=t.blue-r.blue,n.alpha=t.alpha-r.alpha,n},u.multiply=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.red=t.red*r.red,n.green=t.green*r.green,n.blue=t.blue*r.blue,n.alpha=t.alpha*r.alpha,n},u.divide=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.red=t.red/r.red,n.green=t.green/r.green,n.blue=t.blue/r.blue,n.alpha=t.alpha/r.alpha,n},u.mod=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.red=t.red%r.red,n.green=t.green%r.green,n.blue=t.blue%r.blue,n.alpha=t.alpha%r.alpha,n},u.multiplyByScalar=function(t,r,n){return e.typeOf.object("color",t),e.typeOf.number("scalar",r),e.typeOf.object("result",n),n.red=t.red*r,n.green=t.green*r,n.blue=t.blue*r,n.alpha=t.alpha*r,n},u.divideByScalar=function(t,r,n){return e.typeOf.object("color",t),e.typeOf.number("scalar",r),e.typeOf.object("result",n),n.red=t.red/r,n.green=t.green/r,n.blue=t.blue/r,n.alpha=t.alpha/r,n},u.ALICEBLUE=o(u.fromCssColorString("#F0F8FF")),u.ANTIQUEWHITE=o(u.fromCssColorString("#FAEBD7")),u.AQUA=o(u.fromCssColorString("#00FFFF")),u.AQUAMARINE=o(u.fromCssColorString("#7FFFD4")),u.AZURE=o(u.fromCssColorString("#F0FFFF")),u.BEIGE=o(u.fromCssColorString("#F5F5DC")),u.BISQUE=o(u.fromCssColorString("#FFE4C4")),u.BLACK=o(u.fromCssColorString("#000000")),u.BLANCHEDALMOND=o(u.fromCssColorString("#FFEBCD")),u.BLUE=o(u.fromCssColorString("#0000FF")),u.BLUEVIOLET=o(u.fromCssColorString("#8A2BE2")),u.BROWN=o(u.fromCssColorString("#A52A2A")),u.BURLYWOOD=o(u.fromCssColorString("#DEB887")),u.CADETBLUE=o(u.fromCssColorString("#5F9EA0")),u.CHARTREUSE=o(u.fromCssColorString("#7FFF00")),u.CHOCOLATE=o(u.fromCssColorString("#D2691E")),u.CORAL=o(u.fromCssColorString("#FF7F50")),u.CORNFLOWERBLUE=o(u.fromCssColorString("#6495ED")),u.CORNSILK=o(u.fromCssColorString("#FFF8DC")),u.CRIMSON=o(u.fromCssColorString("#DC143C")),u.CYAN=o(u.fromCssColorString("#00FFFF")),u.DARKBLUE=o(u.fromCssColorString("#00008B")),u.DARKCYAN=o(u.fromCssColorString("#008B8B")),u.DARKGOLDENROD=o(u.fromCssColorString("#B8860B")),u.DARKGRAY=o(u.fromCssColorString("#A9A9A9")),u.DARKGREEN=o(u.fromCssColorString("#006400")),u.DARKGREY=u.DARKGRAY,u.DARKKHAKI=o(u.fromCssColorString("#BDB76B")),u.DARKMAGENTA=o(u.fromCssColorString("#8B008B")),u.DARKOLIVEGREEN=o(u.fromCssColorString("#556B2F")),u.DARKORANGE=o(u.fromCssColorString("#FF8C00")),u.DARKORCHID=o(u.fromCssColorString("#9932CC")),u.DARKRED=o(u.fromCssColorString("#8B0000")),u.DARKSALMON=o(u.fromCssColorString("#E9967A")),u.DARKSEAGREEN=o(u.fromCssColorString("#8FBC8F")),u.DARKSLATEBLUE=o(u.fromCssColorString("#483D8B")),u.DARKSLATEGRAY=o(u.fromCssColorString("#2F4F4F")),u.DARKSLATEGREY=u.DARKSLATEGRAY,u.DARKTURQUOISE=o(u.fromCssColorString("#00CED1")),u.DARKVIOLET=o(u.fromCssColorString("#9400D3")),u.DEEPPINK=o(u.fromCssColorString("#FF1493")),u.DEEPSKYBLUE=o(u.fromCssColorString("#00BFFF")),u.DIMGRAY=o(u.fromCssColorString("#696969")),u.DIMGREY=u.DIMGRAY,u.DODGERBLUE=o(u.fromCssColorString("#1E90FF")),u.FIREBRICK=o(u.fromCssColorString("#B22222")),u.FLORALWHITE=o(u.fromCssColorString("#FFFAF0")),u.FORESTGREEN=o(u.fromCssColorString("#228B22")),u.FUCHSIA=o(u.fromCssColorString("#FF00FF")),u.GAINSBORO=o(u.fromCssColorString("#DCDCDC")),u.GHOSTWHITE=o(u.fromCssColorString("#F8F8FF")),u.GOLD=o(u.fromCssColorString("#FFD700")),u.GOLDENROD=o(u.fromCssColorString("#DAA520")),u.GRAY=o(u.fromCssColorString("#808080")),u.GREEN=o(u.fromCssColorString("#008000")),u.GREENYELLOW=o(u.fromCssColorString("#ADFF2F")),u.GREY=u.GRAY,u.HONEYDEW=o(u.fromCssColorString("#F0FFF0")),u.HOTPINK=o(u.fromCssColorString("#FF69B4")),u.INDIANRED=o(u.fromCssColorString("#CD5C5C")),u.INDIGO=o(u.fromCssColorString("#4B0082")),u.IVORY=o(u.fromCssColorString("#FFFFF0")),u.KHAKI=o(u.fromCssColorString("#F0E68C")),u.LAVENDER=o(u.fromCssColorString("#E6E6FA")),u.LAVENDAR_BLUSH=o(u.fromCssColorString("#FFF0F5")),u.LAWNGREEN=o(u.fromCssColorString("#7CFC00")),u.LEMONCHIFFON=o(u.fromCssColorString("#FFFACD")),u.LIGHTBLUE=o(u.fromCssColorString("#ADD8E6")),u.LIGHTCORAL=o(u.fromCssColorString("#F08080")),u.LIGHTCYAN=o(u.fromCssColorString("#E0FFFF")),u.LIGHTGOLDENRODYELLOW=o(u.fromCssColorString("#FAFAD2")),u.LIGHTGRAY=o(u.fromCssColorString("#D3D3D3")),u.LIGHTGREEN=o(u.fromCssColorString("#90EE90")),u.LIGHTGREY=u.LIGHTGRAY,u.LIGHTPINK=o(u.fromCssColorString("#FFB6C1")),u.LIGHTSEAGREEN=o(u.fromCssColorString("#20B2AA")),u.LIGHTSKYBLUE=o(u.fromCssColorString("#87CEFA")),u.LIGHTSLATEGRAY=o(u.fromCssColorString("#778899")),u.LIGHTSLATEGREY=u.LIGHTSLATEGRAY,u.LIGHTSTEELBLUE=o(u.fromCssColorString("#B0C4DE")),u.LIGHTYELLOW=o(u.fromCssColorString("#FFFFE0")),u.LIME=o(u.fromCssColorString("#00FF00")),u.LIMEGREEN=o(u.fromCssColorString("#32CD32")),u.LINEN=o(u.fromCssColorString("#FAF0E6")),u.MAGENTA=o(u.fromCssColorString("#FF00FF")),u.MAROON=o(u.fromCssColorString("#800000")),u.MEDIUMAQUAMARINE=o(u.fromCssColorString("#66CDAA")),u.MEDIUMBLUE=o(u.fromCssColorString("#0000CD")),u.MEDIUMORCHID=o(u.fromCssColorString("#BA55D3")),u.MEDIUMPURPLE=o(u.fromCssColorString("#9370DB")),u.MEDIUMSEAGREEN=o(u.fromCssColorString("#3CB371")),u.MEDIUMSLATEBLUE=o(u.fromCssColorString("#7B68EE")),u.MEDIUMSPRINGGREEN=o(u.fromCssColorString("#00FA9A")),u.MEDIUMTURQUOISE=o(u.fromCssColorString("#48D1CC")),u.MEDIUMVIOLETRED=o(u.fromCssColorString("#C71585")),u.MIDNIGHTBLUE=o(u.fromCssColorString("#191970")),u.MINTCREAM=o(u.fromCssColorString("#F5FFFA")),u.MISTYROSE=o(u.fromCssColorString("#FFE4E1")),u.MOCCASIN=o(u.fromCssColorString("#FFE4B5")),u.NAVAJOWHITE=o(u.fromCssColorString("#FFDEAD")),u.NAVY=o(u.fromCssColorString("#000080")),u.OLDLACE=o(u.fromCssColorString("#FDF5E6")),u.OLIVE=o(u.fromCssColorString("#808000")),u.OLIVEDRAB=o(u.fromCssColorString("#6B8E23")),u.ORANGE=o(u.fromCssColorString("#FFA500")),u.ORANGERED=o(u.fromCssColorString("#FF4500")),u.ORCHID=o(u.fromCssColorString("#DA70D6")),u.PALEGOLDENROD=o(u.fromCssColorString("#EEE8AA")),u.PALEGREEN=o(u.fromCssColorString("#98FB98")),u.PALETURQUOISE=o(u.fromCssColorString("#AFEEEE")),u.PALEVIOLETRED=o(u.fromCssColorString("#DB7093")),u.PAPAYAWHIP=o(u.fromCssColorString("#FFEFD5")),u.PEACHPUFF=o(u.fromCssColorString("#FFDAB9")),u.PERU=o(u.fromCssColorString("#CD853F")),u.PINK=o(u.fromCssColorString("#FFC0CB")),u.PLUM=o(u.fromCssColorString("#DDA0DD")),u.POWDERBLUE=o(u.fromCssColorString("#B0E0E6")),u.PURPLE=o(u.fromCssColorString("#800080")),u.RED=o(u.fromCssColorString("#FF0000")),u.ROSYBROWN=o(u.fromCssColorString("#BC8F8F")),u.ROYALBLUE=o(u.fromCssColorString("#4169E1")),u.SADDLEBROWN=o(u.fromCssColorString("#8B4513")),u.SALMON=o(u.fromCssColorString("#FA8072")),u.SANDYBROWN=o(u.fromCssColorString("#F4A460")),u.SEAGREEN=o(u.fromCssColorString("#2E8B57")),u.SEASHELL=o(u.fromCssColorString("#FFF5EE")),u.SIENNA=o(u.fromCssColorString("#A0522D")),u.SILVER=o(u.fromCssColorString("#C0C0C0")),u.SKYBLUE=o(u.fromCssColorString("#87CEEB")),u.SLATEBLUE=o(u.fromCssColorString("#6A5ACD")),u.SLATEGRAY=o(u.fromCssColorString("#708090")),u.SLATEGREY=u.SLATEGRAY,u.SNOW=o(u.fromCssColorString("#FFFAFA")),u.SPRINGGREEN=o(u.fromCssColorString("#00FF7F")),u.STEELBLUE=o(u.fromCssColorString("#4682B4")),u.TAN=o(u.fromCssColorString("#D2B48C")),u.TEAL=o(u.fromCssColorString("#008080")),u.THISTLE=o(u.fromCssColorString("#D8BFD8")),u.TOMATO=o(u.fromCssColorString("#FF6347")),u.TURQUOISE=o(u.fromCssColorString("#40E0D0")),u.VIOLET=o(u.fromCssColorString("#EE82EE")),u.WHEAT=o(u.fromCssColorString("#F5DEB3")),u.WHITE=o(u.fromCssColorString("#FFFFFF")),u.WHITESMOKE=o(u.fromCssColorString("#F5F5F5")),u.YELLOW=o(u.fromCssColorString("#FFFF00")),u.YELLOWGREEN=o(u.fromCssColorString("#9ACD32")),u.TRANSPARENT=o(new u(0,0,0,0)),u})),define("Core/Ellipsoid",["./Cartesian3","./Cartographic","./Check","./defaultValue","./defined","./defineProperties","./DeveloperError","./freezeObject","./Math","./scaleToGeodeticSurface"],(function(e,t,r,n,o,i,a,u,s,c){"use strict";function f(t,o,i,a){o=n(o,0),i=n(i,0),a=n(a,0),r.typeOf.number.greaterThanOrEquals("x",o,0),r.typeOf.number.greaterThanOrEquals("y",i,0),r.typeOf.number.greaterThanOrEquals("z",a,0),t._radii=new e(o,i,a),t._radiiSquared=new e(o*o,i*i,a*a),t._radiiToTheFourth=new e(o*o*o*o,i*i*i*i,a*a*a*a),t._oneOverRadii=new e(0===o?0:1/o,0===i?0:1/i,0===a?0:1/a),t._oneOverRadiiSquared=new e(0===o?0:1/(o*o),0===i?0:1/(i*i),0===a?0:1/(a*a)),t._minimumRadius=Math.min(o,i,a),t._maximumRadius=Math.max(o,i,a),t._centerToleranceSquared=s.EPSILON1,0!==t._radiiSquared.z&&(t._squaredXOverSquaredZ=t._radiiSquared.x/t._radiiSquared.z)}function l(e,t,r){this._radii=void 0,this._radiiSquared=void 0,this._radiiToTheFourth=void 0,this._oneOverRadii=void 0,this._oneOverRadiiSquared=void 0,this._minimumRadius=void 0,this._maximumRadius=void 0,this._centerToleranceSquared=void 0,this._squaredXOverSquaredZ=void 0,f(this,e,t,r)}i(l.prototype,{radii:{get:function(){return this._radii}},radiiSquared:{get:function(){return this._radiiSquared}},radiiToTheFourth:{get:function(){return this._radiiToTheFourth}},oneOverRadii:{get:function(){return this._oneOverRadii}},oneOverRadiiSquared:{get:function(){return this._oneOverRadiiSquared}},minimumRadius:{get:function(){return this._minimumRadius}},maximumRadius:{get:function(){return this._maximumRadius}}}),l.clone=function(t,r){if(o(t)){var n=t._radii;return o(r)?(e.clone(n,r._radii),e.clone(t._radiiSquared,r._radiiSquared),e.clone(t._radiiToTheFourth,r._radiiToTheFourth),e.clone(t._oneOverRadii,r._oneOverRadii),e.clone(t._oneOverRadiiSquared,r._oneOverRadiiSquared),r._minimumRadius=t._minimumRadius,r._maximumRadius=t._maximumRadius,r._centerToleranceSquared=t._centerToleranceSquared,r):new l(n.x,n.y,n.z)}},l.fromCartesian3=function(e,t){return o(t)||(t=new l),o(e)?(f(t,e.x,e.y,e.z),t):t},l.WGS84=u(new l(6378137,6378137,6356752.314245179)),l.UNIT_SPHERE=u(new l(1,1,1)),l.MOON=u(new l(s.LUNAR_RADIUS,s.LUNAR_RADIUS,s.LUNAR_RADIUS)),l.prototype.clone=function(e){return l.clone(this,e)},l.packedLength=e.packedLength,l.pack=function(t,o,i){return r.typeOf.object("value",t),r.defined("array",o),i=n(i,0),e.pack(t._radii,o,i),o},l.unpack=function(t,o,i){r.defined("array",t),o=n(o,0);var a=e.unpack(t,o);return l.fromCartesian3(a,i)},l.prototype.geocentricSurfaceNormal=e.normalize,l.prototype.geodeticSurfaceNormalCartographic=function(t,n){r.typeOf.object("cartographic",t);var i=t.longitude,a=t.latitude,u=Math.cos(a),s=u*Math.cos(i),c=u*Math.sin(i),f=Math.sin(a);return o(n)||(n=new e),n.x=s,n.y=c,n.z=f,e.normalize(n,n)},l.prototype.geodeticSurfaceNormal=function(t,r){return o(r)||(r=new e),r=e.multiplyComponents(t,this._oneOverRadiiSquared,r),e.normalize(r,r)};var d=new e,h=new e;l.prototype.cartographicToCartesian=function(t,r){var n=d,i=h;this.geodeticSurfaceNormalCartographic(t,n),e.multiplyComponents(this._radiiSquared,n,i);var a=Math.sqrt(e.dot(n,i));return e.divideByScalar(i,a,i),e.multiplyByScalar(n,t.height,n),o(r)||(r=new e),e.add(i,n,r)},l.prototype.cartographicArrayToCartesianArray=function(e,t){r.defined("cartographics",e);var n=e.length;o(t)?t.length=n:t=new Array(n);for(var i=0;i<n;i++)t[i]=this.cartographicToCartesian(e[i],t[i]);return t};var p=new e,m=new e,y=new e;return l.prototype.cartesianToCartographic=function(r,n){var i=this.scaleToGeodeticSurface(r,m);if(o(i)){var a=this.geodeticSurfaceNormal(i,p),u=e.subtract(r,i,y),c=Math.atan2(a.y,a.x),f=Math.asin(a.z),l=s.sign(e.dot(u,r))*e.magnitude(u);return o(n)?(n.longitude=c,n.latitude=f,n.height=l,n):new t(c,f,l)}},l.prototype.cartesianArrayToCartographicArray=function(e,t){r.defined("cartesians",e);var n=e.length;o(t)?t.length=n:t=new Array(n);for(var i=0;i<n;++i)t[i]=this.cartesianToCartographic(e[i],t[i]);return t},l.prototype.scaleToGeodeticSurface=function(e,t){return c(e,this._oneOverRadii,this._oneOverRadiiSquared,this._centerToleranceSquared,t)},l.prototype.scaleToGeocentricSurface=function(t,n){r.typeOf.object("cartesian",t),o(n)||(n=new e);var i=t.x,a=t.y,u=t.z,s=this._oneOverRadiiSquared,c=1/Math.sqrt(i*i*s.x+a*a*s.y+u*u*s.z);return e.multiplyByScalar(t,c,n)},l.prototype.transformPositionToScaledSpace=function(t,r){return o(r)||(r=new e),e.multiplyComponents(t,this._oneOverRadii,r)},l.prototype.transformPositionFromScaledSpace=function(t,r){return o(r)||(r=new e),e.multiplyComponents(t,this._radii,r)},l.prototype.equals=function(t){return this===t||o(t)&&e.equals(this._radii,t._radii)},l.prototype.toString=function(){return this._radii.toString()},l.prototype.getSurfaceNormalIntersectionWithZAxis=function(t,i,u){if(r.typeOf.object("position",t),!s.equalsEpsilon(this._radii.x,this._radii.y,s.EPSILON15))throw new a("Ellipsoid must be an ellipsoid of revolution (radii.x == radii.y)");r.typeOf.number.greaterThan("Ellipsoid.radii.z",this._radii.z,0),i=n(i,0);var c=this._squaredXOverSquaredZ;if(o(u)||(u=new e),u.x=0,u.y=0,u.z=t.z*(1-c),!(Math.abs(u.z)>=this._radii.z-i))return u},l})),define("Core/WebGLConstants",["./freezeObject"],(function(e){"use strict";return e({DEPTH_BUFFER_BIT:256,STENCIL_BUFFER_BIT:1024,COLOR_BUFFER_BIT:16384,POINTS:0,LINES:1,LINE_LOOP:2,LINE_STRIP:3,TRIANGLES:4,TRIANGLE_STRIP:5,TRIANGLE_FAN:6,ZERO:0,ONE:1,SRC_COLOR:768,ONE_MINUS_SRC_COLOR:769,SRC_ALPHA:770,ONE_MINUS_SRC_ALPHA:771,DST_ALPHA:772,ONE_MINUS_DST_ALPHA:773,DST_COLOR:774,ONE_MINUS_DST_COLOR:775,SRC_ALPHA_SATURATE:776,FUNC_ADD:32774,BLEND_EQUATION:32777,BLEND_EQUATION_RGB:32777,BLEND_EQUATION_ALPHA:34877,FUNC_SUBTRACT:32778,FUNC_REVERSE_SUBTRACT:32779,BLEND_DST_RGB:32968,BLEND_SRC_RGB:32969,BLEND_DST_ALPHA:32970,BLEND_SRC_ALPHA:32971,CONSTANT_COLOR:32769,ONE_MINUS_CONSTANT_COLOR:32770,CONSTANT_ALPHA:32771,ONE_MINUS_CONSTANT_ALPHA:32772,BLEND_COLOR:32773,ARRAY_BUFFER:34962,ELEMENT_ARRAY_BUFFER:34963,ARRAY_BUFFER_BINDING:34964,ELEMENT_ARRAY_BUFFER_BINDING:34965,STREAM_DRAW:35040,STATIC_DRAW:35044,DYNAMIC_DRAW:35048,BUFFER_SIZE:34660,BUFFER_USAGE:34661,CURRENT_VERTEX_ATTRIB:34342,FRONT:1028,BACK:1029,FRONT_AND_BACK:1032,CULL_FACE:2884,BLEND:3042,DITHER:3024,STENCIL_TEST:2960,DEPTH_TEST:2929,SCISSOR_TEST:3089,POLYGON_OFFSET_FILL:32823,SAMPLE_ALPHA_TO_COVERAGE:32926,SAMPLE_COVERAGE:32928,NO_ERROR:0,INVALID_ENUM:1280,INVALID_VALUE:1281,INVALID_OPERATION:1282,OUT_OF_MEMORY:1285,CW:2304,CCW:2305,LINE_WIDTH:2849,ALIASED_POINT_SIZE_RANGE:33901,ALIASED_LINE_WIDTH_RANGE:33902,CULL_FACE_MODE:2885,FRONT_FACE:2886,DEPTH_RANGE:2928,DEPTH_WRITEMASK:2930,DEPTH_CLEAR_VALUE:2931,DEPTH_FUNC:2932,STENCIL_CLEAR_VALUE:2961,STENCIL_FUNC:2962,STENCIL_FAIL:2964,STENCIL_PASS_DEPTH_FAIL:2965,STENCIL_PASS_DEPTH_PASS:2966,STENCIL_REF:2967,STENCIL_VALUE_MASK:2963,STENCIL_WRITEMASK:2968,STENCIL_BACK_FUNC:34816,STENCIL_BACK_FAIL:34817,STENCIL_BACK_PASS_DEPTH_FAIL:34818,STENCIL_BACK_PASS_DEPTH_PASS:34819,STENCIL_BACK_REF:36003,STENCIL_BACK_VALUE_MASK:36004,STENCIL_BACK_WRITEMASK:36005,VIEWPORT:2978,SCISSOR_BOX:3088,COLOR_CLEAR_VALUE:3106,COLOR_WRITEMASK:3107,UNPACK_ALIGNMENT:3317,PACK_ALIGNMENT:3333,MAX_TEXTURE_SIZE:3379,MAX_VIEWPORT_DIMS:3386,SUBPIXEL_BITS:3408,RED_BITS:3410,GREEN_BITS:3411,BLUE_BITS:3412,ALPHA_BITS:3413,DEPTH_BITS:3414,STENCIL_BITS:3415,POLYGON_OFFSET_UNITS:10752,POLYGON_OFFSET_FACTOR:32824,TEXTURE_BINDING_2D:32873,SAMPLE_BUFFERS:32936,SAMPLES:32937,SAMPLE_COVERAGE_VALUE:32938,SAMPLE_COVERAGE_INVERT:32939,COMPRESSED_TEXTURE_FORMATS:34467,DONT_CARE:4352,FASTEST:4353,NICEST:4354,GENERATE_MIPMAP_HINT:33170,BYTE:5120,UNSIGNED_BYTE:5121,SHORT:5122,UNSIGNED_SHORT:5123,INT:5124,UNSIGNED_INT:5125,FLOAT:5126,DEPTH_COMPONENT:6402,ALPHA:6406,RGB:6407,RGBA:6408,LUMINANCE:6409,LUMINANCE_ALPHA:6410,UNSIGNED_SHORT_4_4_4_4:32819,UNSIGNED_SHORT_5_5_5_1:32820,UNSIGNED_SHORT_5_6_5:33635,FRAGMENT_SHADER:35632,VERTEX_SHADER:35633,MAX_VERTEX_ATTRIBS:34921,MAX_VERTEX_UNIFORM_VECTORS:36347,MAX_VARYING_VECTORS:36348,MAX_COMBINED_TEXTURE_IMAGE_UNITS:35661,MAX_VERTEX_TEXTURE_IMAGE_UNITS:35660,MAX_TEXTURE_IMAGE_UNITS:34930,MAX_FRAGMENT_UNIFORM_VECTORS:36349,SHADER_TYPE:35663,DELETE_STATUS:35712,LINK_STATUS:35714,VALIDATE_STATUS:35715,ATTACHED_SHADERS:35717,ACTIVE_UNIFORMS:35718,ACTIVE_ATTRIBUTES:35721,SHADING_LANGUAGE_VERSION:35724,CURRENT_PROGRAM:35725,NEVER:512,LESS:513,EQUAL:514,LEQUAL:515,GREATER:516,NOTEQUAL:517,GEQUAL:518,ALWAYS:519,KEEP:7680,REPLACE:7681,INCR:7682,DECR:7683,INVERT:5386,INCR_WRAP:34055,DECR_WRAP:34056,VENDOR:7936,RENDERER:7937,VERSION:7938,NEAREST:9728,LINEAR:9729,NEAREST_MIPMAP_NEAREST:9984,LINEAR_MIPMAP_NEAREST:9985,NEAREST_MIPMAP_LINEAR:9986,LINEAR_MIPMAP_LINEAR:9987,TEXTURE_MAG_FILTER:10240,TEXTURE_MIN_FILTER:10241,TEXTURE_WRAP_S:10242,TEXTURE_WRAP_T:10243,TEXTURE_2D:3553,TEXTURE:5890,TEXTURE_CUBE_MAP:34067,TEXTURE_BINDING_CUBE_MAP:34068,TEXTURE_CUBE_MAP_POSITIVE_X:34069,TEXTURE_CUBE_MAP_NEGATIVE_X:34070,TEXTURE_CUBE_MAP_POSITIVE_Y:34071,TEXTURE_CUBE_MAP_NEGATIVE_Y:34072,TEXTURE_CUBE_MAP_POSITIVE_Z:34073,TEXTURE_CUBE_MAP_NEGATIVE_Z:34074,MAX_CUBE_MAP_TEXTURE_SIZE:34076,TEXTURE0:33984,TEXTURE1:33985,TEXTURE2:33986,TEXTURE3:33987,TEXTURE4:33988,TEXTURE5:33989,TEXTURE6:33990,TEXTURE7:33991,TEXTURE8:33992,TEXTURE9:33993,TEXTURE10:33994,TEXTURE11:33995,TEXTURE12:33996,TEXTURE13:33997,TEXTURE14:33998,TEXTURE15:33999,TEXTURE16:34e3,TEXTURE17:34001,TEXTURE18:34002,TEXTURE19:34003,TEXTURE20:34004,TEXTURE21:34005,TEXTURE22:34006,TEXTURE23:34007,TEXTURE24:34008,TEXTURE25:34009,TEXTURE26:34010,TEXTURE27:34011,TEXTURE28:34012,TEXTURE29:34013,TEXTURE30:34014,TEXTURE31:34015,ACTIVE_TEXTURE:34016,REPEAT:10497,CLAMP_TO_EDGE:33071,MIRRORED_REPEAT:33648,FLOAT_VEC2:35664,FLOAT_VEC3:35665,FLOAT_VEC4:35666,INT_VEC2:35667,INT_VEC3:35668,INT_VEC4:35669,BOOL:35670,BOOL_VEC2:35671,BOOL_VEC3:35672,BOOL_VEC4:35673,FLOAT_MAT2:35674,FLOAT_MAT3:35675,FLOAT_MAT4:35676,SAMPLER_2D:35678,SAMPLER_CUBE:35680,VERTEX_ATTRIB_ARRAY_ENABLED:34338,VERTEX_ATTRIB_ARRAY_SIZE:34339,VERTEX_ATTRIB_ARRAY_STRIDE:34340,VERTEX_ATTRIB_ARRAY_TYPE:34341,VERTEX_ATTRIB_ARRAY_NORMALIZED:34922,VERTEX_ATTRIB_ARRAY_POINTER:34373,VERTEX_ATTRIB_ARRAY_BUFFER_BINDING:34975,IMPLEMENTATION_COLOR_READ_TYPE:35738,IMPLEMENTATION_COLOR_READ_FORMAT:35739,COMPILE_STATUS:35713,LOW_FLOAT:36336,MEDIUM_FLOAT:36337,HIGH_FLOAT:36338,LOW_INT:36339,MEDIUM_INT:36340,HIGH_INT:36341,FRAMEBUFFER:36160,RENDERBUFFER:36161,RGBA4:32854,RGB5_A1:32855,RGB565:36194,DEPTH_COMPONENT16:33189,STENCIL_INDEX:6401,STENCIL_INDEX8:36168,DEPTH_STENCIL:34041,RENDERBUFFER_WIDTH:36162,RENDERBUFFER_HEIGHT:36163,RENDERBUFFER_INTERNAL_FORMAT:36164,RENDERBUFFER_RED_SIZE:36176,RENDERBUFFER_GREEN_SIZE:36177,RENDERBUFFER_BLUE_SIZE:36178,RENDERBUFFER_ALPHA_SIZE:36179,RENDERBUFFER_DEPTH_SIZE:36180,RENDERBUFFER_STENCIL_SIZE:36181,FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE:36048,FRAMEBUFFER_ATTACHMENT_OBJECT_NAME:36049,FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL:36050,FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE:36051,COLOR_ATTACHMENT0:36064,DEPTH_ATTACHMENT:36096,STENCIL_ATTACHMENT:36128,DEPTH_STENCIL_ATTACHMENT:33306,NONE:0,FRAMEBUFFER_COMPLETE:36053,FRAMEBUFFER_INCOMPLETE_ATTACHMENT:36054,FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT:36055,FRAMEBUFFER_INCOMPLETE_DIMENSIONS:36057,FRAMEBUFFER_UNSUPPORTED:36061,FRAMEBUFFER_BINDING:36006,RENDERBUFFER_BINDING:36007,MAX_RENDERBUFFER_SIZE:34024,INVALID_FRAMEBUFFER_OPERATION:1286,UNPACK_FLIP_Y_WEBGL:37440,UNPACK_PREMULTIPLY_ALPHA_WEBGL:37441,CONTEXT_LOST_WEBGL:37442,UNPACK_COLORSPACE_CONVERSION_WEBGL:37443,BROWSER_DEFAULT_WEBGL:37444,COMPRESSED_RGB_S3TC_DXT1_EXT:33776,COMPRESSED_RGBA_S3TC_DXT1_EXT:33777,COMPRESSED_RGBA_S3TC_DXT3_EXT:33778,COMPRESSED_RGBA_S3TC_DXT5_EXT:33779,COMPRESSED_RGB_PVRTC_4BPPV1_IMG:35840,COMPRESSED_RGB_PVRTC_2BPPV1_IMG:35841,COMPRESSED_RGBA_PVRTC_4BPPV1_IMG:35842,COMPRESSED_RGBA_PVRTC_2BPPV1_IMG:35843,COMPRESSED_RGB_ETC1_WEBGL:36196,HALF_FLOAT_OES:36193,DOUBLE:5130,READ_BUFFER:3074,UNPACK_ROW_LENGTH:3314,UNPACK_SKIP_ROWS:3315,UNPACK_SKIP_PIXELS:3316,PACK_ROW_LENGTH:3330,PACK_SKIP_ROWS:3331,PACK_SKIP_PIXELS:3332,COLOR:6144,DEPTH:6145,STENCIL:6146,RED:6403,RGB8:32849,RGBA8:32856,RGB10_A2:32857,TEXTURE_BINDING_3D:32874,UNPACK_SKIP_IMAGES:32877,UNPACK_IMAGE_HEIGHT:32878,TEXTURE_3D:32879,TEXTURE_WRAP_R:32882,MAX_3D_TEXTURE_SIZE:32883,UNSIGNED_INT_2_10_10_10_REV:33640,MAX_ELEMENTS_VERTICES:33e3,MAX_ELEMENTS_INDICES:33001,TEXTURE_MIN_LOD:33082,TEXTURE_MAX_LOD:33083,TEXTURE_BASE_LEVEL:33084,TEXTURE_MAX_LEVEL:33085,MIN:32775,MAX:32776,DEPTH_COMPONENT24:33190,MAX_TEXTURE_LOD_BIAS:34045,TEXTURE_COMPARE_MODE:34892,TEXTURE_COMPARE_FUNC:34893,CURRENT_QUERY:34917,QUERY_RESULT:34918,QUERY_RESULT_AVAILABLE:34919,STREAM_READ:35041,STREAM_COPY:35042,STATIC_READ:35045,STATIC_COPY:35046,DYNAMIC_READ:35049,DYNAMIC_COPY:35050,MAX_DRAW_BUFFERS:34852,DRAW_BUFFER0:34853,DRAW_BUFFER1:34854,DRAW_BUFFER2:34855,DRAW_BUFFER3:34856,DRAW_BUFFER4:34857,DRAW_BUFFER5:34858,DRAW_BUFFER6:34859,DRAW_BUFFER7:34860,DRAW_BUFFER8:34861,DRAW_BUFFER9:34862,DRAW_BUFFER10:34863,DRAW_BUFFER11:34864,DRAW_BUFFER12:34865,DRAW_BUFFER13:34866,DRAW_BUFFER14:34867,DRAW_BUFFER15:34868,MAX_FRAGMENT_UNIFORM_COMPONENTS:35657,MAX_VERTEX_UNIFORM_COMPONENTS:35658,SAMPLER_3D:35679,SAMPLER_2D_SHADOW:35682,FRAGMENT_SHADER_DERIVATIVE_HINT:35723,PIXEL_PACK_BUFFER:35051,PIXEL_UNPACK_BUFFER:35052,PIXEL_PACK_BUFFER_BINDING:35053,PIXEL_UNPACK_BUFFER_BINDING:35055,FLOAT_MAT2x3:35685,FLOAT_MAT2x4:35686,FLOAT_MAT3x2:35687,FLOAT_MAT3x4:35688,FLOAT_MAT4x2:35689,FLOAT_MAT4x3:35690,SRGB:35904,SRGB8:35905,SRGB8_ALPHA8:35907,COMPARE_REF_TO_TEXTURE:34894,RGBA32F:34836,RGB32F:34837,RGBA16F:34842,RGB16F:34843,VERTEX_ATTRIB_ARRAY_INTEGER:35069,MAX_ARRAY_TEXTURE_LAYERS:35071,MIN_PROGRAM_TEXEL_OFFSET:35076,MAX_PROGRAM_TEXEL_OFFSET:35077,MAX_VARYING_COMPONENTS:35659,TEXTURE_2D_ARRAY:35866,TEXTURE_BINDING_2D_ARRAY:35869,R11F_G11F_B10F:35898,UNSIGNED_INT_10F_11F_11F_REV:35899,RGB9_E5:35901,UNSIGNED_INT_5_9_9_9_REV:35902,TRANSFORM_FEEDBACK_BUFFER_MODE:35967,MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS:35968,TRANSFORM_FEEDBACK_VARYINGS:35971,TRANSFORM_FEEDBACK_BUFFER_START:35972,TRANSFORM_FEEDBACK_BUFFER_SIZE:35973,TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN:35976,RASTERIZER_DISCARD:35977,MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS:35978,MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS:35979,INTERLEAVED_ATTRIBS:35980,SEPARATE_ATTRIBS:35981,TRANSFORM_FEEDBACK_BUFFER:35982,TRANSFORM_FEEDBACK_BUFFER_BINDING:35983,RGBA32UI:36208,RGB32UI:36209,RGBA16UI:36214,RGB16UI:36215,RGBA8UI:36220,RGB8UI:36221,RGBA32I:36226,RGB32I:36227,RGBA16I:36232,RGB16I:36233,RGBA8I:36238,RGB8I:36239,RED_INTEGER:36244,RGB_INTEGER:36248,RGBA_INTEGER:36249,SAMPLER_2D_ARRAY:36289,SAMPLER_2D_ARRAY_SHADOW:36292,SAMPLER_CUBE_SHADOW:36293,UNSIGNED_INT_VEC2:36294,UNSIGNED_INT_VEC3:36295,UNSIGNED_INT_VEC4:36296,INT_SAMPLER_2D:36298,INT_SAMPLER_3D:36299,INT_SAMPLER_CUBE:36300,INT_SAMPLER_2D_ARRAY:36303,UNSIGNED_INT_SAMPLER_2D:36306,UNSIGNED_INT_SAMPLER_3D:36307,UNSIGNED_INT_SAMPLER_CUBE:36308,UNSIGNED_INT_SAMPLER_2D_ARRAY:36311,DEPTH_COMPONENT32F:36012,DEPTH32F_STENCIL8:36013,FLOAT_32_UNSIGNED_INT_24_8_REV:36269,FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING:33296,FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE:33297,FRAMEBUFFER_ATTACHMENT_RED_SIZE:33298,FRAMEBUFFER_ATTACHMENT_GREEN_SIZE:33299,FRAMEBUFFER_ATTACHMENT_BLUE_SIZE:33300,FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE:33301,FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE:33302,FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE:33303,FRAMEBUFFER_DEFAULT:33304,UNSIGNED_INT_24_8:34042,DEPTH24_STENCIL8:35056,UNSIGNED_NORMALIZED:35863,DRAW_FRAMEBUFFER_BINDING:36006,READ_FRAMEBUFFER:36008,DRAW_FRAMEBUFFER:36009,READ_FRAMEBUFFER_BINDING:36010,RENDERBUFFER_SAMPLES:36011,FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER:36052,MAX_COLOR_ATTACHMENTS:36063,COLOR_ATTACHMENT1:36065,COLOR_ATTACHMENT2:36066,COLOR_ATTACHMENT3:36067,COLOR_ATTACHMENT4:36068,COLOR_ATTACHMENT5:36069,COLOR_ATTACHMENT6:36070,COLOR_ATTACHMENT7:36071,COLOR_ATTACHMENT8:36072,COLOR_ATTACHMENT9:36073,COLOR_ATTACHMENT10:36074,COLOR_ATTACHMENT11:36075,COLOR_ATTACHMENT12:36076,COLOR_ATTACHMENT13:36077,COLOR_ATTACHMENT14:36078,COLOR_ATTACHMENT15:36079,FRAMEBUFFER_INCOMPLETE_MULTISAMPLE:36182,MAX_SAMPLES:36183,HALF_FLOAT:5131,RG:33319,RG_INTEGER:33320,R8:33321,RG8:33323,R16F:33325,R32F:33326,RG16F:33327,RG32F:33328,R8I:33329,R8UI:33330,R16I:33331,R16UI:33332,R32I:33333,R32UI:33334,RG8I:33335,RG8UI:33336,RG16I:33337,RG16UI:33338,RG32I:33339,RG32UI:33340,VERTEX_ARRAY_BINDING:34229,R8_SNORM:36756,RG8_SNORM:36757,RGB8_SNORM:36758,RGBA8_SNORM:36759,SIGNED_NORMALIZED:36764,COPY_READ_BUFFER:36662,COPY_WRITE_BUFFER:36663,COPY_READ_BUFFER_BINDING:36662,COPY_WRITE_BUFFER_BINDING:36663,UNIFORM_BUFFER:35345,UNIFORM_BUFFER_BINDING:35368,UNIFORM_BUFFER_START:35369,UNIFORM_BUFFER_SIZE:35370,MAX_VERTEX_UNIFORM_BLOCKS:35371,MAX_FRAGMENT_UNIFORM_BLOCKS:35373,MAX_COMBINED_UNIFORM_BLOCKS:35374,MAX_UNIFORM_BUFFER_BINDINGS:35375,MAX_UNIFORM_BLOCK_SIZE:35376,MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS:35377,MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS:35379,UNIFORM_BUFFER_OFFSET_ALIGNMENT:35380,ACTIVE_UNIFORM_BLOCKS:35382,UNIFORM_TYPE:35383,UNIFORM_SIZE:35384,UNIFORM_BLOCK_INDEX:35386,UNIFORM_OFFSET:35387,UNIFORM_ARRAY_STRIDE:35388,UNIFORM_MATRIX_STRIDE:35389,UNIFORM_IS_ROW_MAJOR:35390,UNIFORM_BLOCK_BINDING:35391,UNIFORM_BLOCK_DATA_SIZE:35392,UNIFORM_BLOCK_ACTIVE_UNIFORMS:35394,UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES:35395,UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER:35396,UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER:35398,INVALID_INDEX:4294967295,MAX_VERTEX_OUTPUT_COMPONENTS:37154,MAX_FRAGMENT_INPUT_COMPONENTS:37157,MAX_SERVER_WAIT_TIMEOUT:37137,OBJECT_TYPE:37138,SYNC_CONDITION:37139,SYNC_STATUS:37140,SYNC_FLAGS:37141,SYNC_FENCE:37142,SYNC_GPU_COMMANDS_COMPLETE:37143,UNSIGNALED:37144,SIGNALED:37145,ALREADY_SIGNALED:37146,TIMEOUT_EXPIRED:37147,CONDITION_SATISFIED:37148,WAIT_FAILED:37149,SYNC_FLUSH_COMMANDS_BIT:1,VERTEX_ATTRIB_ARRAY_DIVISOR:35070,ANY_SAMPLES_PASSED:35887,ANY_SAMPLES_PASSED_CONSERVATIVE:36202,SAMPLER_BINDING:35097,RGB10_A2UI:36975,INT_2_10_10_10_REV:36255,TRANSFORM_FEEDBACK:36386,TRANSFORM_FEEDBACK_PAUSED:36387,TRANSFORM_FEEDBACK_ACTIVE:36388,TRANSFORM_FEEDBACK_BINDING:36389,COMPRESSED_R11_EAC:37488,COMPRESSED_SIGNED_R11_EAC:37489,COMPRESSED_RG11_EAC:37490,COMPRESSED_SIGNED_RG11_EAC:37491,COMPRESSED_RGB8_ETC2:37492,COMPRESSED_SRGB8_ETC2:37493,COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2:37494,COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2:37495,COMPRESSED_RGBA8_ETC2_EAC:37496,COMPRESSED_SRGB8_ALPHA8_ETC2_EAC:37497,TEXTURE_IMMUTABLE_FORMAT:37167,MAX_ELEMENT_INDEX:36203,TEXTURE_IMMUTABLE_LEVELS:33503,MAX_TEXTURE_MAX_ANISOTROPY_EXT:34047})})),define("Core/IndexDatatype",["./defined","./DeveloperError","./freezeObject","./Math","./WebGLConstants"],(function(e,t,r,n,o){"use strict";var i={UNSIGNED_BYTE:o.UNSIGNED_BYTE,UNSIGNED_SHORT:o.UNSIGNED_SHORT,UNSIGNED_INT:o.UNSIGNED_INT,getSizeInBytes:function(e){switch(e){case i.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case i.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case i.UNSIGNED_INT:return Uint32Array.BYTES_PER_ELEMENT}throw new t("indexDatatype is required and must be a valid IndexDatatype constant.")},validate:function(t){return e(t)&&(t===i.UNSIGNED_BYTE||t===i.UNSIGNED_SHORT||t===i.UNSIGNED_INT)},createTypedArray:function(r,o){if(!e(r))throw new t("numberOfVertices is required.");return r>=n.SIXTY_FOUR_KILOBYTES?new Uint32Array(o):new Uint16Array(o)},createTypedArrayFromArrayBuffer:function(r,o,i,a){if(!e(r))throw new t("numberOfVertices is required.");if(!e(o))throw new t("sourceArray is required.");if(!e(i))throw new t("byteOffset is required.");return r>=n.SIXTY_FOUR_KILOBYTES?new Uint32Array(o,i,a):new Uint16Array(o,i,a)}};return r(i)})),define("Core/GeographicProjection",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid"],(function(e,t,r,n,o,i,a){"use strict";function u(e){this._ellipsoid=r(e,a.WGS84),this._semimajorAxis=this._ellipsoid.maximumRadius,this._oneOverSemimajorAxis=1/this._semimajorAxis}return o(u.prototype,{ellipsoid:{get:function(){return this._ellipsoid}}}),u.prototype.project=function(t,r){var o=this._semimajorAxis,i=t.longitude*o,a=t.latitude*o,u=t.height;return n(r)?(r.x=i,r.y=a,r.z=u,r):new e(i,a,u)},u.prototype.unproject=function(e,r){if(!n(e))throw new i("cartesian is required");var o=this._oneOverSemimajorAxis,a=e.x*o,u=e.y*o,s=e.z;return n(r)?(r.longitude=a,r.latitude=u,r.height=s,r):new t(a,u,s)},u})),define("Core/Intersect",["./freezeObject"],(function(e){"use strict";return e({OUTSIDE:-1,INTERSECTING:0,INSIDE:1})})),define("Core/Interval",["./defaultValue"],(function(e){"use strict";return function(t,r){this.start=e(t,0),this.stop=e(r,0)}})),define("Core/Matrix3",["./Cartesian3","./Check","./defaultValue","./defined","./defineProperties","./DeveloperError","./freezeObject","./Math"],(function(e,t,r,n,o,i,a,u){"use strict";function s(e,t,n,o,i,a,u,s,c){this[0]=r(e,0),this[1]=r(o,0),this[2]=r(u,0),this[3]=r(t,0),this[4]=r(i,0),this[5]=r(s,0),this[6]=r(n,0),this[7]=r(a,0),this[8]=r(c,0)}s.packedLength=9,s.pack=function(e,n,o){return t.typeOf.object("value",e),t.defined("array",n),o=r(o,0),n[o++]=e[0],n[o++]=e[1],n[o++]=e[2],n[o++]=e[3],n[o++]=e[4],n[o++]=e[5],n[o++]=e[6],n[o++]=e[7],n[o++]=e[8],n},s.unpack=function(e,o,i){return t.defined("array",e),o=r(o,0),n(i)||(i=new s),i[0]=e[o++],i[1]=e[o++],i[2]=e[o++],i[3]=e[o++],i[4]=e[o++],i[5]=e[o++],i[6]=e[o++],i[7]=e[o++],i[8]=e[o++],i},s.clone=function(e,t){if(n(e))return n(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t):new s(e[0],e[3],e[6],e[1],e[4],e[7],e[2],e[5],e[8])},s.fromArray=function(e,o,i){return t.defined("array",e),o=r(o,0),n(i)||(i=new s),i[0]=e[o],i[1]=e[o+1],i[2]=e[o+2],i[3]=e[o+3],i[4]=e[o+4],i[5]=e[o+5],i[6]=e[o+6],i[7]=e[o+7],i[8]=e[o+8],i},s.fromColumnMajorArray=function(e,r){return t.defined("values",e),s.clone(e,r)},s.fromRowMajorArray=function(e,r){return t.defined("values",e),n(r)?(r[0]=e[0],r[1]=e[3],r[2]=e[6],r[3]=e[1],r[4]=e[4],r[5]=e[7],r[6]=e[2],r[7]=e[5],r[8]=e[8],r):new s(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8])},s.fromQuaternion=function(e,r){t.typeOf.object("quaternion",e);var o=e.x*e.x,i=e.x*e.y,a=e.x*e.z,u=e.x*e.w,c=e.y*e.y,f=e.y*e.z,l=e.y*e.w,d=e.z*e.z,h=e.z*e.w,p=e.w*e.w,m=o-c-d+p,y=2*(i-h),E=2*(a+l),O=2*(i+h),_=-o+c-d+p,R=2*(f-u),T=2*(a-l),g=2*(f+u),w=-o-c+d+p;return n(r)?(r[0]=m,r[1]=O,r[2]=T,r[3]=y,r[4]=_,r[5]=g,r[6]=E,r[7]=R,r[8]=w,r):new s(m,y,E,O,_,R,T,g,w)},s.fromHeadingPitchRoll=function(e,r){t.typeOf.object("headingPitchRoll",e);var o=Math.cos(-e.pitch),i=Math.cos(-e.heading),a=Math.cos(e.roll),u=Math.sin(-e.pitch),c=Math.sin(-e.heading),f=Math.sin(e.roll),l=o*i,d=-a*c+f*u*i,h=f*c+a*u*i,p=o*c,m=a*i+f*u*c,y=-f*i+a*u*c,E=-u,O=f*o,_=a*o;return n(r)?(r[0]=l,r[1]=p,r[2]=E,r[3]=d,r[4]=m,r[5]=O,r[6]=h,r[7]=y,r[8]=_,r):new s(l,d,h,p,m,y,E,O,_)},s.fromScale=function(e,r){return t.typeOf.object("scale",e),n(r)?(r[0]=e.x,r[1]=0,r[2]=0,r[3]=0,r[4]=e.y,r[5]=0,r[6]=0,r[7]=0,r[8]=e.z,r):new s(e.x,0,0,0,e.y,0,0,0,e.z)},s.fromUniformScale=function(e,r){return t.typeOf.number("scale",e),n(r)?(r[0]=e,r[1]=0,r[2]=0,r[3]=0,r[4]=e,r[5]=0,r[6]=0,r[7]=0,r[8]=e,r):new s(e,0,0,0,e,0,0,0,e)},s.fromCrossProduct=function(e,r){return t.typeOf.object("vector",e),n(r)?(r[0]=0,r[1]=e.z,r[2]=-e.y,r[3]=-e.z,r[4]=0,r[5]=e.x,r[6]=e.y,r[7]=-e.x,r[8]=0,r):new s(0,-e.z,e.y,e.z,0,-e.x,-e.y,e.x,0)},s.fromRotationX=function(e,r){t.typeOf.number("angle",e);var o=Math.cos(e),i=Math.sin(e);return n(r)?(r[0]=1,r[1]=0,r[2]=0,r[3]=0,r[4]=o,r[5]=i,r[6]=0,r[7]=-i,r[8]=o,r):new s(1,0,0,0,o,-i,0,i,o)},s.fromRotationY=function(e,r){t.typeOf.number("angle",e);var o=Math.cos(e),i=Math.sin(e);return n(r)?(r[0]=o,r[1]=0,r[2]=-i,r[3]=0,r[4]=1,r[5]=0,r[6]=i,r[7]=0,r[8]=o,r):new s(o,0,i,0,1,0,-i,0,o)},s.fromRotationZ=function(e,r){t.typeOf.number("angle",e);var o=Math.cos(e),i=Math.sin(e);return n(r)?(r[0]=o,r[1]=i,r[2]=0,r[3]=-i,r[4]=o,r[5]=0,r[6]=0,r[7]=0,r[8]=1,r):new s(o,-i,0,i,o,0,0,0,1)},s.toArray=function(e,r){return t.typeOf.object("matrix",e),n(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8]]},s.getElementIndex=function(e,r){return t.typeOf.number.greaterThanOrEquals("row",r,0),t.typeOf.number.lessThanOrEquals("row",r,2),t.typeOf.number.greaterThanOrEquals("column",e,0),t.typeOf.number.lessThanOrEquals("column",e,2),3*e+r},s.getColumn=function(e,r,n){t.typeOf.object("matrix",e),t.typeOf.number.greaterThanOrEquals("index",r,0),t.typeOf.number.lessThanOrEquals("index",r,2),t.typeOf.object("result",n);var o=3*r,i=e[o],a=e[o+1],u=e[o+2];return n.x=i,n.y=a,n.z=u,n},s.setColumn=function(e,r,n,o){t.typeOf.object("matrix",e),t.typeOf.number.greaterThanOrEquals("index",r,0),t.typeOf.number.lessThanOrEquals("index",r,2),t.typeOf.object("cartesian",n),t.typeOf.object("result",o);var i=3*r;return(o=s.clone(e,o))[i]=n.x,o[i+1]=n.y,o[i+2]=n.z,o},s.getRow=function(e,r,n){t.typeOf.object("matrix",e),t.typeOf.number.greaterThanOrEquals("index",r,0),t.typeOf.number.lessThanOrEquals("index",r,2),t.typeOf.object("result",n);var o=e[r],i=e[r+3],a=e[r+6];return n.x=o,n.y=i,n.z=a,n},s.setRow=function(e,r,n,o){return t.typeOf.object("matrix",e),t.typeOf.number.greaterThanOrEquals("index",r,0),t.typeOf.number.lessThanOrEquals("index",r,2),t.typeOf.object("cartesian",n),t.typeOf.object("result",o),(o=s.clone(e,o))[r]=n.x,o[r+3]=n.y,o[r+6]=n.z,o};var c=new e;s.getScale=function(r,n){return t.typeOf.object("matrix",r),t.typeOf.object("result",n),n.x=e.magnitude(e.fromElements(r[0],r[1],r[2],c)),n.y=e.magnitude(e.fromElements(r[3],r[4],r[5],c)),n.z=e.magnitude(e.fromElements(r[6],r[7],r[8],c)),n};var f=new e;s.getMaximumScale=function(t){return s.getScale(t,f),e.maximumComponent(f)},s.multiply=function(e,r,n){t.typeOf.object("left",e),t.typeOf.object("right",r),t.typeOf.object("result",n);var o=e[0]*r[0]+e[3]*r[1]+e[6]*r[2],i=e[1]*r[0]+e[4]*r[1]+e[7]*r[2],a=e[2]*r[0]+e[5]*r[1]+e[8]*r[2],u=e[0]*r[3]+e[3]*r[4]+e[6]*r[5],s=e[1]*r[3]+e[4]*r[4]+e[7]*r[5],c=e[2]*r[3]+e[5]*r[4]+e[8]*r[5],f=e[0]*r[6]+e[3]*r[7]+e[6]*r[8],l=e[1]*r[6]+e[4]*r[7]+e[7]*r[8],d=e[2]*r[6]+e[5]*r[7]+e[8]*r[8];return n[0]=o,n[1]=i,n[2]=a,n[3]=u,n[4]=s,n[5]=c,n[6]=f,n[7]=l,n[8]=d,n},s.add=function(e,r,n){return t.typeOf.object("left",e),t.typeOf.object("right",r),t.typeOf.object("result",n),n[0]=e[0]+r[0],n[1]=e[1]+r[1],n[2]=e[2]+r[2],n[3]=e[3]+r[3],n[4]=e[4]+r[4],n[5]=e[5]+r[5],n[6]=e[6]+r[6],n[7]=e[7]+r[7],n[8]=e[8]+r[8],n},s.subtract=function(e,r,n){return t.typeOf.object("left",e),t.typeOf.object("right",r),t.typeOf.object("result",n),n[0]=e[0]-r[0],n[1]=e[1]-r[1],n[2]=e[2]-r[2],n[3]=e[3]-r[3],n[4]=e[4]-r[4],n[5]=e[5]-r[5],n[6]=e[6]-r[6],n[7]=e[7]-r[7],n[8]=e[8]-r[8],n},s.multiplyByVector=function(e,r,n){t.typeOf.object("matrix",e),t.typeOf.object("cartesian",r),t.typeOf.object("result",n);var o=r.x,i=r.y,a=r.z,u=e[0]*o+e[3]*i+e[6]*a,s=e[1]*o+e[4]*i+e[7]*a,c=e[2]*o+e[5]*i+e[8]*a;return n.x=u,n.y=s,n.z=c,n},s.multiplyByScalar=function(e,r,n){return t.typeOf.object("matrix",e),t.typeOf.number("scalar",r),t.typeOf.object("result",n),n[0]=e[0]*r,n[1]=e[1]*r,n[2]=e[2]*r,n[3]=e[3]*r,n[4]=e[4]*r,n[5]=e[5]*r,n[6]=e[6]*r,n[7]=e[7]*r,n[8]=e[8]*r,n},s.multiplyByScale=function(e,r,n){return t.typeOf.object("matrix",e),t.typeOf.object("scale",r),t.typeOf.object("result",n),n[0]=e[0]*r.x,n[1]=e[1]*r.x,n[2]=e[2]*r.x,n[3]=e[3]*r.y,n[4]=e[4]*r.y,n[5]=e[5]*r.y,n[6]=e[6]*r.z,n[7]=e[7]*r.z,n[8]=e[8]*r.z,n},s.negate=function(e,r){return t.typeOf.object("matrix",e),t.typeOf.object("result",r),r[0]=-e[0],r[1]=-e[1],r[2]=-e[2],r[3]=-e[3],r[4]=-e[4],r[5]=-e[5],r[6]=-e[6],r[7]=-e[7],r[8]=-e[8],r},s.transpose=function(e,r){t.typeOf.object("matrix",e),t.typeOf.object("result",r);var n=e[0],o=e[3],i=e[6],a=e[1],u=e[4],s=e[7],c=e[2],f=e[5],l=e[8];return r[0]=n,r[1]=o,r[2]=i,r[3]=a,r[4]=u,r[5]=s,r[6]=c,r[7]=f,r[8]=l,r};var l=[1,0,0],d=[2,2,1];function h(e){for(var t=0,r=0;r<3;++r){var n=e[s.getElementIndex(d[r],l[r])];t+=2*n*n}return Math.sqrt(t)}function p(e,t){for(var r=u.EPSILON15,n=0,o=1,i=0;i<3;++i){var a=Math.abs(e[s.getElementIndex(d[i],l[i])]);a>n&&(o=i,n=a)}var c=1,f=0,h=l[o],p=d[o];if(Math.abs(e[s.getElementIndex(p,h)])>r){var m,y=(e[s.getElementIndex(p,p)]-e[s.getElementIndex(h,h)])/2/e[s.getElementIndex(p,h)];f=(m=y<0?-1/(-y+Math.sqrt(1+y*y)):1/(y+Math.sqrt(1+y*y)))*(c=1/Math.sqrt(1+m*m))}return(t=s.clone(s.IDENTITY,t))[s.getElementIndex(h,h)]=t[s.getElementIndex(p,p)]=c,t[s.getElementIndex(p,h)]=f,t[s.getElementIndex(h,p)]=-f,t}var m=new s,y=new s;return s.computeEigenDecomposition=function(e,r){t.typeOf.object("matrix",e);var o=u.EPSILON20,i=0,a=0;n(r)||(r={});for(var c=r.unitary=s.clone(s.IDENTITY,r.unitary),f=r.diagonal=s.clone(e,r.diagonal),l=o*function(e){for(var t=0,r=0;r<9;++r){var n=e[r];t+=n*n}return Math.sqrt(t)}(f);a<10&&h(f)>l;)p(f,m),s.transpose(m,y),s.multiply(f,m,f),s.multiply(y,f,f),s.multiply(c,m,c),++i>2&&(++a,i=0);return r},s.abs=function(e,r){return t.typeOf.object("matrix",e),t.typeOf.object("result",r),r[0]=Math.abs(e[0]),r[1]=Math.abs(e[1]),r[2]=Math.abs(e[2]),r[3]=Math.abs(e[3]),r[4]=Math.abs(e[4]),r[5]=Math.abs(e[5]),r[6]=Math.abs(e[6]),r[7]=Math.abs(e[7]),r[8]=Math.abs(e[8]),r},s.determinant=function(e){t.typeOf.object("matrix",e);var r=e[0],n=e[3],o=e[6],i=e[1],a=e[4],u=e[7],s=e[2],c=e[5],f=e[8];return r*(a*f-c*u)+i*(c*o-n*f)+s*(n*u-a*o)},s.inverse=function(e,r){t.typeOf.object("matrix",e),t.typeOf.object("result",r);var n=e[0],o=e[1],a=e[2],c=e[3],f=e[4],l=e[5],d=e[6],h=e[7],p=e[8],m=s.determinant(e);if(Math.abs(m)<=u.EPSILON15)throw new i("matrix is not invertible");r[0]=f*p-h*l,r[1]=h*a-o*p,r[2]=o*l-f*a,r[3]=d*l-c*p,r[4]=n*p-d*a,r[5]=c*a-n*l,r[6]=c*h-d*f,r[7]=d*o-n*h,r[8]=n*f-c*o;var y=1/m;return s.multiplyByScalar(r,y,r)},s.equals=function(e,t){return e===t||n(e)&&n(t)&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[3]===t[3]&&e[4]===t[4]&&e[5]===t[5]&&e[6]===t[6]&&e[7]===t[7]&&e[8]===t[8]},s.equalsEpsilon=function(e,r,o){return t.typeOf.number("epsilon",o),e===r||n(e)&&n(r)&&Math.abs(e[0]-r[0])<=o&&Math.abs(e[1]-r[1])<=o&&Math.abs(e[2]-r[2])<=o&&Math.abs(e[3]-r[3])<=o&&Math.abs(e[4]-r[4])<=o&&Math.abs(e[5]-r[5])<=o&&Math.abs(e[6]-r[6])<=o&&Math.abs(e[7]-r[7])<=o&&Math.abs(e[8]-r[8])<=o},s.IDENTITY=a(new s(1,0,0,0,1,0,0,0,1)),s.ZERO=a(new s(0,0,0,0,0,0,0,0,0)),s.COLUMN0ROW0=0,s.COLUMN0ROW1=1,s.COLUMN0ROW2=2,s.COLUMN1ROW0=3,s.COLUMN1ROW1=4,s.COLUMN1ROW2=5,s.COLUMN2ROW0=6,s.COLUMN2ROW1=7,s.COLUMN2ROW2=8,o(s.prototype,{length:{get:function(){return s.packedLength}}}),s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s.equalsArray=function(e,t,r){return e[0]===t[r]&&e[1]===t[r+1]&&e[2]===t[r+2]&&e[3]===t[r+3]&&e[4]===t[r+4]&&e[5]===t[r+5]&&e[6]===t[r+6]&&e[7]===t[r+7]&&e[8]===t[r+8]},s.prototype.equalsEpsilon=function(e,t){return s.equalsEpsilon(this,e,t)},s.prototype.toString=function(){return"("+this[0]+", "+this[3]+", "+this[6]+")\n("+this[1]+", "+this[4]+", "+this[7]+")\n("+this[2]+", "+this[5]+", "+this[8]+")"},s})),define("Core/Cartesian4",["./Check","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],(function(e,t,r,n,o,i){"use strict";function a(e,r,n,o){this.x=t(e,0),this.y=t(r,0),this.z=t(n,0),this.w=t(o,0)}a.fromElements=function(e,t,n,o,i){return r(i)?(i.x=e,i.y=t,i.z=n,i.w=o,i):new a(e,t,n,o)},a.fromColor=function(t,n){return e.typeOf.object("color",t),r(n)?(n.x=t.red,n.y=t.green,n.z=t.blue,n.w=t.alpha,n):new a(t.red,t.green,t.blue,t.alpha)},a.clone=function(e,t){if(r(e))return r(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t.w=e.w,t):new a(e.x,e.y,e.z,e.w)},a.packedLength=4,a.pack=function(r,n,o){return e.typeOf.object("value",r),e.defined("array",n),o=t(o,0),n[o++]=r.x,n[o++]=r.y,n[o++]=r.z,n[o]=r.w,n},a.unpack=function(n,o,i){return e.defined("array",n),o=t(o,0),r(i)||(i=new a),i.x=n[o++],i.y=n[o++],i.z=n[o++],i.w=n[o],i},a.packArray=function(t,n){e.defined("array",t);var o=t.length;r(n)?n.length=4*o:n=new Array(4*o);for(var i=0;i<o;++i)a.pack(t[i],n,4*i);return n},a.unpackArray=function(t,n){e.defined("array",t);var o=t.length;r(n)?n.length=o/4:n=new Array(o/4);for(var i=0;i<o;i+=4){var u=i/4;n[u]=a.unpack(t,i,n[u])}return n},a.fromArray=a.unpack,a.maximumComponent=function(t){return e.typeOf.object("cartesian",t),Math.max(t.x,t.y,t.z,t.w)},a.minimumComponent=function(t){return e.typeOf.object("cartesian",t),Math.min(t.x,t.y,t.z,t.w)},a.minimumByComponent=function(t,r,n){return e.typeOf.object("first",t),e.typeOf.object("second",r),e.typeOf.object("result",n),n.x=Math.min(t.x,r.x),n.y=Math.min(t.y,r.y),n.z=Math.min(t.z,r.z),n.w=Math.min(t.w,r.w),n},a.maximumByComponent=function(t,r,n){return e.typeOf.object("first",t),e.typeOf.object("second",r),e.typeOf.object("result",n),n.x=Math.max(t.x,r.x),n.y=Math.max(t.y,r.y),n.z=Math.max(t.z,r.z),n.w=Math.max(t.w,r.w),n},a.magnitudeSquared=function(t){return e.typeOf.object("cartesian",t),t.x*t.x+t.y*t.y+t.z*t.z+t.w*t.w},a.magnitude=function(e){return Math.sqrt(a.magnitudeSquared(e))};var u=new a;a.distance=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),a.subtract(t,r,u),a.magnitude(u)},a.distanceSquared=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),a.subtract(t,r,u),a.magnitudeSquared(u)},a.normalize=function(t,r){e.typeOf.object("cartesian",t),e.typeOf.object("result",r);var o=a.magnitude(t);if(r.x=t.x/o,r.y=t.y/o,r.z=t.z/o,r.w=t.w/o,isNaN(r.x)||isNaN(r.y)||isNaN(r.z)||isNaN(r.w))throw new n("normalized result is not a number");return r},a.dot=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),t.x*r.x+t.y*r.y+t.z*r.z+t.w*r.w},a.multiplyComponents=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x*r.x,n.y=t.y*r.y,n.z=t.z*r.z,n.w=t.w*r.w,n},a.divideComponents=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x/r.x,n.y=t.y/r.y,n.z=t.z/r.z,n.w=t.w/r.w,n},a.add=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x+r.x,n.y=t.y+r.y,n.z=t.z+r.z,n.w=t.w+r.w,n},a.subtract=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x-r.x,n.y=t.y-r.y,n.z=t.z-r.z,n.w=t.w-r.w,n},a.multiplyByScalar=function(t,r,n){return e.typeOf.object("cartesian",t),e.typeOf.number("scalar",r),e.typeOf.object("result",n),n.x=t.x*r,n.y=t.y*r,n.z=t.z*r,n.w=t.w*r,n},a.divideByScalar=function(t,r,n){return e.typeOf.object("cartesian",t),e.typeOf.number("scalar",r),e.typeOf.object("result",n),n.x=t.x/r,n.y=t.y/r,n.z=t.z/r,n.w=t.w/r,n},a.negate=function(t,r){return e.typeOf.object("cartesian",t),e.typeOf.object("result",r),r.x=-t.x,r.y=-t.y,r.z=-t.z,r.w=-t.w,r},a.abs=function(t,r){return e.typeOf.object("cartesian",t),e.typeOf.object("result",r),r.x=Math.abs(t.x),r.y=Math.abs(t.y),r.z=Math.abs(t.z),r.w=Math.abs(t.w),r};var s=new a;a.lerp=function(t,r,n,o){return e.typeOf.object("start",t),e.typeOf.object("end",r),e.typeOf.number("t",n),e.typeOf.object("result",o),a.multiplyByScalar(r,n,s),o=a.multiplyByScalar(t,1-n,o),a.add(s,o,o)};var c=new a;a.mostOrthogonalAxis=function(t,r){e.typeOf.object("cartesian",t),e.typeOf.object("result",r);var n=a.normalize(t,c);return a.abs(n,n),r=n.x<=n.y?n.x<=n.z?n.x<=n.w?a.clone(a.UNIT_X,r):a.clone(a.UNIT_W,r):n.z<=n.w?a.clone(a.UNIT_Z,r):a.clone(a.UNIT_W,r):n.y<=n.z?n.y<=n.w?a.clone(a.UNIT_Y,r):a.clone(a.UNIT_W,r):n.z<=n.w?a.clone(a.UNIT_Z,r):a.clone(a.UNIT_W,r)},a.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z&&e.w===t.w},a.equalsArray=function(e,t,r){return e.x===t[r]&&e.y===t[r+1]&&e.z===t[r+2]&&e.w===t[r+3]},a.equalsEpsilon=function(e,t,n,o){return e===t||r(e)&&r(t)&&i.equalsEpsilon(e.x,t.x,n,o)&&i.equalsEpsilon(e.y,t.y,n,o)&&i.equalsEpsilon(e.z,t.z,n,o)&&i.equalsEpsilon(e.w,t.w,n,o)},a.ZERO=o(new a(0,0,0,0)),a.UNIT_X=o(new a(1,0,0,0)),a.UNIT_Y=o(new a(0,1,0,0)),a.UNIT_Z=o(new a(0,0,1,0)),a.UNIT_W=o(new a(0,0,0,1)),a.prototype.clone=function(e){return a.clone(this,e)},a.prototype.equals=function(e){return a.equals(this,e)},a.prototype.equalsEpsilon=function(e,t,r){return a.equalsEpsilon(this,e,t,r)},a.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"};var f=new Float32Array(1);return a.packFloat=function(t,n){if(e.typeOf.number("value",t),r(n)||(n=new a),f[0]=t,0===(t=f[0]))return a.clone(a.ZERO,n);var o,u=t<0?1:0;isFinite(t)?(t=Math.abs(t),o=Math.floor(i.logBase(t,10))+1,t/=Math.pow(10,o)):(t=.1,o=38);var s=256*t;return n.x=Math.floor(s),s=256*(s-n.x),n.y=Math.floor(s),s=256*(s-n.y),n.z=Math.floor(s),n.w=2*(o+38)+u,n},a.unpackFloat=function(t){e.typeOf.object("packedFloat",t);var r=t.w/2,n=Math.floor(r),o=2*(r-n);if(o=-(o=2*o-1),(n-=38)>=38)return o<0?Number.NEGATIVE_INFINITY:Number.POSITIVE_INFINITY;var i=o*t.x*(1/256);return i+=o*t.y*(1/65536),(i+=o*t.z*(1/16777216))*Math.pow(10,n)},a})),define("Core/RuntimeError",["./defined"],(function(e){"use strict";function t(e){var t;this.name="RuntimeError",this.message=e;try{throw new Error}catch(e){t=e.stack}this.stack=t}return e(Object.create)&&(t.prototype=Object.create(Error.prototype),t.prototype.constructor=t),t.prototype.toString=function(){var t=this.name+": "+this.message;return e(this.stack)&&(t+="\n"+this.stack.toString()),t},t})),define("Core/Matrix4",["./Cartesian3","./Cartesian4","./Check","./defaultValue","./defined","./defineProperties","./freezeObject","./Math","./Matrix3","./RuntimeError"],(function(e,t,r,n,o,i,a,u,s,c){"use strict";function f(e,t,r,o,i,a,u,s,c,f,l,d,h,p,m,y){this[0]=n(e,0),this[1]=n(i,0),this[2]=n(c,0),this[3]=n(h,0),this[4]=n(t,0),this[5]=n(a,0),this[6]=n(f,0),this[7]=n(p,0),this[8]=n(r,0),this[9]=n(u,0),this[10]=n(l,0),this[11]=n(m,0),this[12]=n(o,0),this[13]=n(s,0),this[14]=n(d,0),this[15]=n(y,0)}f.packedLength=16,f.pack=function(e,t,o){return r.typeOf.object("value",e),r.defined("array",t),o=n(o,0),t[o++]=e[0],t[o++]=e[1],t[o++]=e[2],t[o++]=e[3],t[o++]=e[4],t[o++]=e[5],t[o++]=e[6],t[o++]=e[7],t[o++]=e[8],t[o++]=e[9],t[o++]=e[10],t[o++]=e[11],t[o++]=e[12],t[o++]=e[13],t[o++]=e[14],t[o]=e[15],t},f.unpack=function(e,t,i){return r.defined("array",e),t=n(t,0),o(i)||(i=new f),i[0]=e[t++],i[1]=e[t++],i[2]=e[t++],i[3]=e[t++],i[4]=e[t++],i[5]=e[t++],i[6]=e[t++],i[7]=e[t++],i[8]=e[t++],i[9]=e[t++],i[10]=e[t++],i[11]=e[t++],i[12]=e[t++],i[13]=e[t++],i[14]=e[t++],i[15]=e[t],i},f.clone=function(e,t){if(o(e))return o(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t):new f(e[0],e[4],e[8],e[12],e[1],e[5],e[9],e[13],e[2],e[6],e[10],e[14],e[3],e[7],e[11],e[15])},f.fromArray=f.unpack,f.fromColumnMajorArray=function(e,t){return r.defined("values",e),f.clone(e,t)},f.fromRowMajorArray=function(e,t){return r.defined("values",e),o(t)?(t[0]=e[0],t[1]=e[4],t[2]=e[8],t[3]=e[12],t[4]=e[1],t[5]=e[5],t[6]=e[9],t[7]=e[13],t[8]=e[2],t[9]=e[6],t[10]=e[10],t[11]=e[14],t[12]=e[3],t[13]=e[7],t[14]=e[11],t[15]=e[15],t):new f(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15])},f.fromRotationTranslation=function(t,i,a){return r.typeOf.object("rotation",t),i=n(i,e.ZERO),o(a)?(a[0]=t[0],a[1]=t[1],a[2]=t[2],a[3]=0,a[4]=t[3],a[5]=t[4],a[6]=t[5],a[7]=0,a[8]=t[6],a[9]=t[7],a[10]=t[8],a[11]=0,a[12]=i.x,a[13]=i.y,a[14]=i.z,a[15]=1,a):new f(t[0],t[3],t[6],i.x,t[1],t[4],t[7],i.y,t[2],t[5],t[8],i.z,0,0,0,1)},f.fromTranslationQuaternionRotationScale=function(e,t,n,i){r.typeOf.object("translation",e),r.typeOf.object("rotation",t),r.typeOf.object("scale",n),o(i)||(i=new f);var a=n.x,u=n.y,s=n.z,c=t.x*t.x,l=t.x*t.y,d=t.x*t.z,h=t.x*t.w,p=t.y*t.y,m=t.y*t.z,y=t.y*t.w,E=t.z*t.z,O=t.z*t.w,_=t.w*t.w,R=c-p-E+_,T=2*(l-O),g=2*(d+y),w=2*(l+O),A=-c+p-E+_,b=2*(m-h),C=2*(d-y),S=2*(m+h),v=-c-p+E+_;return i[0]=R*a,i[1]=w*a,i[2]=C*a,i[3]=0,i[4]=T*u,i[5]=A*u,i[6]=S*u,i[7]=0,i[8]=g*s,i[9]=b*s,i[10]=v*s,i[11]=0,i[12]=e.x,i[13]=e.y,i[14]=e.z,i[15]=1,i},f.fromTranslationRotationScale=function(e,t){return r.typeOf.object("translationRotationScale",e),f.fromTranslationQuaternionRotationScale(e.translation,e.rotation,e.scale,t)},f.fromTranslation=function(e,t){return r.typeOf.object("translation",e),f.fromRotationTranslation(s.IDENTITY,e,t)},f.fromScale=function(e,t){return r.typeOf.object("scale",e),o(t)?(t[0]=e.x,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=e.y,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=e.z,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t):new f(e.x,0,0,0,0,e.y,0,0,0,0,e.z,0,0,0,0,1)},f.fromUniformScale=function(e,t){return r.typeOf.number("scale",e),o(t)?(t[0]=e,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=e,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=e,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t):new f(e,0,0,0,0,e,0,0,0,0,e,0,0,0,0,1)};var l=new e,d=new e,h=new e;f.fromCamera=function(t,n){r.typeOf.object("camera",t);var i=t.position,a=t.direction,u=t.up;r.typeOf.object("camera.position",i),r.typeOf.object("camera.direction",a),r.typeOf.object("camera.up",u),e.normalize(a,l),e.normalize(e.cross(l,u,d),d),e.normalize(e.cross(d,l,h),h);var s=d.x,c=d.y,p=d.z,m=l.x,y=l.y,E=l.z,O=h.x,_=h.y,R=h.z,T=i.x,g=i.y,w=i.z,A=s*-T+c*-g+p*-w,b=O*-T+_*-g+R*-w,C=m*T+y*g+E*w;return o(n)?(n[0]=s,n[1]=O,n[2]=-m,n[3]=0,n[4]=c,n[5]=_,n[6]=-y,n[7]=0,n[8]=p,n[9]=R,n[10]=-E,n[11]=0,n[12]=A,n[13]=b,n[14]=C,n[15]=1,n):new f(s,c,p,A,O,_,R,b,-m,-y,-E,C,0,0,0,1)},f.computePerspectiveFieldOfView=function(e,t,n,o,i){r.typeOf.number.greaterThan("fovY",e,0),r.typeOf.number.lessThan("fovY",e,Math.PI),r.typeOf.number.greaterThan("near",n,0),r.typeOf.number.greaterThan("far",o,0),r.typeOf.object("result",i);var a=1/Math.tan(.5*e),u=a/t,s=(o+n)/(n-o),c=2*o*n/(n-o);return i[0]=u,i[1]=0,i[2]=0,i[3]=0,i[4]=0,i[5]=a,i[6]=0,i[7]=0,i[8]=0,i[9]=0,i[10]=s,i[11]=-1,i[12]=0,i[13]=0,i[14]=c,i[15]=0,i},f.computeOrthographicOffCenter=function(e,t,n,o,i,a,u){r.typeOf.number("left",e),r.typeOf.number("right",t),r.typeOf.number("bottom",n),r.typeOf.number("top",o),r.typeOf.number("near",i),r.typeOf.number("far",a),r.typeOf.object("result",u);var s=1/(t-e),c=1/(o-n),f=1/(a-i),l=-(t+e)*s,d=-(o+n)*c,h=-(a+i)*f;return s*=2,c*=2,f*=-2,u[0]=s,u[1]=0,u[2]=0,u[3]=0,u[4]=0,u[5]=c,u[6]=0,u[7]=0,u[8]=0,u[9]=0,u[10]=f,u[11]=0,u[12]=l,u[13]=d,u[14]=h,u[15]=1,u},f.computePerspectiveOffCenter=function(e,t,n,o,i,a,u){r.typeOf.number("left",e),r.typeOf.number("right",t),r.typeOf.number("bottom",n),r.typeOf.number("top",o),r.typeOf.number("near",i),r.typeOf.number("far",a),r.typeOf.object("result",u);var s=2*i/(t-e),c=2*i/(o-n),f=(t+e)/(t-e),l=(o+n)/(o-n),d=-(a+i)/(a-i),h=-2*a*i/(a-i);return u[0]=s,u[1]=0,u[2]=0,u[3]=0,u[4]=0,u[5]=c,u[6]=0,u[7]=0,u[8]=f,u[9]=l,u[10]=d,u[11]=-1,u[12]=0,u[13]=0,u[14]=h,u[15]=0,u},f.computeInfinitePerspectiveOffCenter=function(e,t,n,o,i,a){r.typeOf.number("left",e),r.typeOf.number("right",t),r.typeOf.number("bottom",n),r.typeOf.number("top",o),r.typeOf.number("near",i),r.typeOf.object("result",a);var u=2*i/(t-e),s=2*i/(o-n),c=(t+e)/(t-e),f=(o+n)/(o-n),l=-2*i;return a[0]=u,a[1]=0,a[2]=0,a[3]=0,a[4]=0,a[5]=s,a[6]=0,a[7]=0,a[8]=c,a[9]=f,a[10]=-1,a[11]=-1,a[12]=0,a[13]=0,a[14]=l,a[15]=0,a},f.computeViewportTransformation=function(e,t,o,i){r.typeOf.object("result",i),e=n(e,n.EMPTY_OBJECT);var a=n(e.x,0),u=n(e.y,0),s=n(e.width,0),c=n(e.height,0);t=n(t,0);var f=.5*s,l=.5*c,d=.5*((o=n(o,1))-t),h=f,p=l,m=d,y=a+f,E=u+l,O=t+d;return i[0]=h,i[1]=0,i[2]=0,i[3]=0,i[4]=0,i[5]=p,i[6]=0,i[7]=0,i[8]=0,i[9]=0,i[10]=m,i[11]=0,i[12]=y,i[13]=E,i[14]=O,i[15]=1,i},f.computeView=function(t,n,o,i,a){return r.typeOf.object("position",t),r.typeOf.object("direction",n),r.typeOf.object("up",o),r.typeOf.object("right",i),r.typeOf.object("result",a),a[0]=i.x,a[1]=o.x,a[2]=-n.x,a[3]=0,a[4]=i.y,a[5]=o.y,a[6]=-n.y,a[7]=0,a[8]=i.z,a[9]=o.z,a[10]=-n.z,a[11]=0,a[12]=-e.dot(i,t),a[13]=-e.dot(o,t),a[14]=e.dot(n,t),a[15]=1,a},f.toArray=function(e,t){return r.typeOf.object("matrix",e),o(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15]]},f.getElementIndex=function(e,t){return r.typeOf.number.greaterThanOrEquals("row",t,0),r.typeOf.number.lessThanOrEquals("row",t,3),r.typeOf.number.greaterThanOrEquals("column",e,0),r.typeOf.number.lessThanOrEquals("column",e,3),4*e+t},f.getColumn=function(e,t,n){r.typeOf.object("matrix",e),r.typeOf.number.greaterThanOrEquals("index",t,0),r.typeOf.number.lessThanOrEquals("index",t,3),r.typeOf.object("result",n);var o=4*t,i=e[o],a=e[o+1],u=e[o+2],s=e[o+3];return n.x=i,n.y=a,n.z=u,n.w=s,n},f.setColumn=function(e,t,n,o){r.typeOf.object("matrix",e),r.typeOf.number.greaterThanOrEquals("index",t,0),r.typeOf.number.lessThanOrEquals("index",t,3),r.typeOf.object("cartesian",n),r.typeOf.object("result",o);var i=4*t;return(o=f.clone(e,o))[i]=n.x,o[i+1]=n.y,o[i+2]=n.z,o[i+3]=n.w,o},f.setTranslation=function(e,t,n){return r.typeOf.object("matrix",e),r.typeOf.object("translation",t),r.typeOf.object("result",n),n[0]=e[0],n[1]=e[1],n[2]=e[2],n[3]=e[3],n[4]=e[4],n[5]=e[5],n[6]=e[6],n[7]=e[7],n[8]=e[8],n[9]=e[9],n[10]=e[10],n[11]=e[11],n[12]=t.x,n[13]=t.y,n[14]=t.z,n[15]=e[15],n};var p=new e;f.setScale=function(t,n,o){r.typeOf.object("matrix",t),r.typeOf.object("scale",n),r.typeOf.object("result",o);var i=f.getScale(t,p),a=e.divideComponents(n,i,p);return f.multiplyByScale(t,a,o)},f.getRow=function(e,t,n){r.typeOf.object("matrix",e),r.typeOf.number.greaterThanOrEquals("index",t,0),r.typeOf.number.lessThanOrEquals("index",t,3),r.typeOf.object("result",n);var o=e[t],i=e[t+4],a=e[t+8],u=e[t+12];return n.x=o,n.y=i,n.z=a,n.w=u,n},f.setRow=function(e,t,n,o){return r.typeOf.object("matrix",e),r.typeOf.number.greaterThanOrEquals("index",t,0),r.typeOf.number.lessThanOrEquals("index",t,3),r.typeOf.object("cartesian",n),r.typeOf.object("result",o),(o=f.clone(e,o))[t]=n.x,o[t+4]=n.y,o[t+8]=n.z,o[t+12]=n.w,o};var m=new e;f.getScale=function(t,n){return r.typeOf.object("matrix",t),r.typeOf.object("result",n),n.x=e.magnitude(e.fromElements(t[0],t[1],t[2],m)),n.y=e.magnitude(e.fromElements(t[4],t[5],t[6],m)),n.z=e.magnitude(e.fromElements(t[8],t[9],t[10],m)),n};var y=new e;f.getMaximumScale=function(t){return f.getScale(t,y),e.maximumComponent(y)},f.multiply=function(e,t,n){r.typeOf.object("left",e),r.typeOf.object("right",t),r.typeOf.object("result",n);var o=e[0],i=e[1],a=e[2],u=e[3],s=e[4],c=e[5],f=e[6],l=e[7],d=e[8],h=e[9],p=e[10],m=e[11],y=e[12],E=e[13],O=e[14],_=e[15],R=t[0],T=t[1],g=t[2],w=t[3],A=t[4],b=t[5],C=t[6],S=t[7],v=t[8],I=t[9],N=t[10],M=t[11],x=t[12],P=t[13],D=t[14],F=t[15],U=o*R+s*T+d*g+y*w,L=i*R+c*T+h*g+E*w,q=a*R+f*T+p*g+O*w,B=u*R+l*T+m*g+_*w,j=o*A+s*b+d*C+y*S,z=i*A+c*b+h*C+E*S,G=a*A+f*b+p*C+O*S,V=u*A+l*b+m*C+_*S,W=o*v+s*I+d*N+y*M,X=i*v+c*I+h*N+E*M,H=a*v+f*I+p*N+O*M,k=u*v+l*I+m*N+_*M,Y=o*x+s*P+d*D+y*F,K=i*x+c*P+h*D+E*F,Z=a*x+f*P+p*D+O*F,Q=u*x+l*P+m*D+_*F;return n[0]=U,n[1]=L,n[2]=q,n[3]=B,n[4]=j,n[5]=z,n[6]=G,n[7]=V,n[8]=W,n[9]=X,n[10]=H,n[11]=k,n[12]=Y,n[13]=K,n[14]=Z,n[15]=Q,n},f.add=function(e,t,n){return r.typeOf.object("left",e),r.typeOf.object("right",t),r.typeOf.object("result",n),n[0]=e[0]+t[0],n[1]=e[1]+t[1],n[2]=e[2]+t[2],n[3]=e[3]+t[3],n[4]=e[4]+t[4],n[5]=e[5]+t[5],n[6]=e[6]+t[6],n[7]=e[7]+t[7],n[8]=e[8]+t[8],n[9]=e[9]+t[9],n[10]=e[10]+t[10],n[11]=e[11]+t[11],n[12]=e[12]+t[12],n[13]=e[13]+t[13],n[14]=e[14]+t[14],n[15]=e[15]+t[15],n},f.subtract=function(e,t,n){return r.typeOf.object("left",e),r.typeOf.object("right",t),r.typeOf.object("result",n),n[0]=e[0]-t[0],n[1]=e[1]-t[1],n[2]=e[2]-t[2],n[3]=e[3]-t[3],n[4]=e[4]-t[4],n[5]=e[5]-t[5],n[6]=e[6]-t[6],n[7]=e[7]-t[7],n[8]=e[8]-t[8],n[9]=e[9]-t[9],n[10]=e[10]-t[10],n[11]=e[11]-t[11],n[12]=e[12]-t[12],n[13]=e[13]-t[13],n[14]=e[14]-t[14],n[15]=e[15]-t[15],n},f.multiplyTransformation=function(e,t,n){r.typeOf.object("left",e),r.typeOf.object("right",t),r.typeOf.object("result",n);var o=e[0],i=e[1],a=e[2],u=e[4],s=e[5],c=e[6],f=e[8],l=e[9],d=e[10],h=e[12],p=e[13],m=e[14],y=t[0],E=t[1],O=t[2],_=t[4],R=t[5],T=t[6],g=t[8],w=t[9],A=t[10],b=t[12],C=t[13],S=t[14],v=o*y+u*E+f*O,I=i*y+s*E+l*O,N=a*y+c*E+d*O,M=o*_+u*R+f*T,x=i*_+s*R+l*T,P=a*_+c*R+d*T,D=o*g+u*w+f*A,F=i*g+s*w+l*A,U=a*g+c*w+d*A,L=o*b+u*C+f*S+h,q=i*b+s*C+l*S+p,B=a*b+c*C+d*S+m;return n[0]=v,n[1]=I,n[2]=N,n[3]=0,n[4]=M,n[5]=x,n[6]=P,n[7]=0,n[8]=D,n[9]=F,n[10]=U,n[11]=0,n[12]=L,n[13]=q,n[14]=B,n[15]=1,n},f.multiplyByMatrix3=function(e,t,n){r.typeOf.object("matrix",e),r.typeOf.object("rotation",t),r.typeOf.object("result",n);var o=e[0],i=e[1],a=e[2],u=e[4],s=e[5],c=e[6],f=e[8],l=e[9],d=e[10],h=t[0],p=t[1],m=t[2],y=t[3],E=t[4],O=t[5],_=t[6],R=t[7],T=t[8],g=o*h+u*p+f*m,w=i*h+s*p+l*m,A=a*h+c*p+d*m,b=o*y+u*E+f*O,C=i*y+s*E+l*O,S=a*y+c*E+d*O,v=o*_+u*R+f*T,I=i*_+s*R+l*T,N=a*_+c*R+d*T;return n[0]=g,n[1]=w,n[2]=A,n[3]=0,n[4]=b,n[5]=C,n[6]=S,n[7]=0,n[8]=v,n[9]=I,n[10]=N,n[11]=0,n[12]=e[12],n[13]=e[13],n[14]=e[14],n[15]=e[15],n},f.multiplyByTranslation=function(e,t,n){r.typeOf.object("matrix",e),r.typeOf.object("translation",t),r.typeOf.object("result",n);var o=t.x,i=t.y,a=t.z,u=o*e[0]+i*e[4]+a*e[8]+e[12],s=o*e[1]+i*e[5]+a*e[9]+e[13],c=o*e[2]+i*e[6]+a*e[10]+e[14];return n[0]=e[0],n[1]=e[1],n[2]=e[2],n[3]=e[3],n[4]=e[4],n[5]=e[5],n[6]=e[6],n[7]=e[7],n[8]=e[8],n[9]=e[9],n[10]=e[10],n[11]=e[11],n[12]=u,n[13]=s,n[14]=c,n[15]=e[15],n};var E=new e;f.multiplyByUniformScale=function(e,t,n){return r.typeOf.object("matrix",e),r.typeOf.number("scale",t),r.typeOf.object("result",n),E.x=t,E.y=t,E.z=t,f.multiplyByScale(e,E,n)},f.multiplyByScale=function(e,t,n){r.typeOf.object("matrix",e),r.typeOf.object("scale",t),r.typeOf.object("result",n);var o=t.x,i=t.y,a=t.z;return 1===o&&1===i&&1===a?f.clone(e,n):(n[0]=o*e[0],n[1]=o*e[1],n[2]=o*e[2],n[3]=0,n[4]=i*e[4],n[5]=i*e[5],n[6]=i*e[6],n[7]=0,n[8]=a*e[8],n[9]=a*e[9],n[10]=a*e[10],n[11]=0,n[12]=e[12],n[13]=e[13],n[14]=e[14],n[15]=1,n)},f.multiplyByVector=function(e,t,n){r.typeOf.object("matrix",e),r.typeOf.object("cartesian",t),r.typeOf.object("result",n);var o=t.x,i=t.y,a=t.z,u=t.w,s=e[0]*o+e[4]*i+e[8]*a+e[12]*u,c=e[1]*o+e[5]*i+e[9]*a+e[13]*u,f=e[2]*o+e[6]*i+e[10]*a+e[14]*u,l=e[3]*o+e[7]*i+e[11]*a+e[15]*u;return n.x=s,n.y=c,n.z=f,n.w=l,n},f.multiplyByPointAsVector=function(e,t,n){r.typeOf.object("matrix",e),r.typeOf.object("cartesian",t),r.typeOf.object("result",n);var o=t.x,i=t.y,a=t.z,u=e[0]*o+e[4]*i+e[8]*a,s=e[1]*o+e[5]*i+e[9]*a,c=e[2]*o+e[6]*i+e[10]*a;return n.x=u,n.y=s,n.z=c,n},f.multiplyByPoint=function(e,t,n){r.typeOf.object("matrix",e),r.typeOf.object("cartesian",t),r.typeOf.object("result",n);var o=t.x,i=t.y,a=t.z,u=e[0]*o+e[4]*i+e[8]*a+e[12],s=e[1]*o+e[5]*i+e[9]*a+e[13],c=e[2]*o+e[6]*i+e[10]*a+e[14];return n.x=u,n.y=s,n.z=c,n},f.multiplyByScalar=function(e,t,n){return r.typeOf.object("matrix",e),r.typeOf.number("scalar",t),r.typeOf.object("result",n),n[0]=e[0]*t,n[1]=e[1]*t,n[2]=e[2]*t,n[3]=e[3]*t,n[4]=e[4]*t,n[5]=e[5]*t,n[6]=e[6]*t,n[7]=e[7]*t,n[8]=e[8]*t,n[9]=e[9]*t,n[10]=e[10]*t,n[11]=e[11]*t,n[12]=e[12]*t,n[13]=e[13]*t,n[14]=e[14]*t,n[15]=e[15]*t,n},f.negate=function(e,t){return r.typeOf.object("matrix",e),r.typeOf.object("result",t),t[0]=-e[0],t[1]=-e[1],t[2]=-e[2],t[3]=-e[3],t[4]=-e[4],t[5]=-e[5],t[6]=-e[6],t[7]=-e[7],t[8]=-e[8],t[9]=-e[9],t[10]=-e[10],t[11]=-e[11],t[12]=-e[12],t[13]=-e[13],t[14]=-e[14],t[15]=-e[15],t},f.transpose=function(e,t){r.typeOf.object("matrix",e),r.typeOf.object("result",t);var n=e[1],o=e[2],i=e[3],a=e[6],u=e[7],s=e[11];return t[0]=e[0],t[1]=e[4],t[2]=e[8],t[3]=e[12],t[4]=n,t[5]=e[5],t[6]=e[9],t[7]=e[13],t[8]=o,t[9]=a,t[10]=e[10],t[11]=e[14],t[12]=i,t[13]=u,t[14]=s,t[15]=e[15],t},f.abs=function(e,t){return r.typeOf.object("matrix",e),r.typeOf.object("result",t),t[0]=Math.abs(e[0]),t[1]=Math.abs(e[1]),t[2]=Math.abs(e[2]),t[3]=Math.abs(e[3]),t[4]=Math.abs(e[4]),t[5]=Math.abs(e[5]),t[6]=Math.abs(e[6]),t[7]=Math.abs(e[7]),t[8]=Math.abs(e[8]),t[9]=Math.abs(e[9]),t[10]=Math.abs(e[10]),t[11]=Math.abs(e[11]),t[12]=Math.abs(e[12]),t[13]=Math.abs(e[13]),t[14]=Math.abs(e[14]),t[15]=Math.abs(e[15]),t},f.equals=function(e,t){return e===t||o(e)&&o(t)&&e[12]===t[12]&&e[13]===t[13]&&e[14]===t[14]&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[4]===t[4]&&e[5]===t[5]&&e[6]===t[6]&&e[8]===t[8]&&e[9]===t[9]&&e[10]===t[10]&&e[3]===t[3]&&e[7]===t[7]&&e[11]===t[11]&&e[15]===t[15]},f.equalsEpsilon=function(e,t,n){return r.typeOf.number("epsilon",n),e===t||o(e)&&o(t)&&Math.abs(e[0]-t[0])<=n&&Math.abs(e[1]-t[1])<=n&&Math.abs(e[2]-t[2])<=n&&Math.abs(e[3]-t[3])<=n&&Math.abs(e[4]-t[4])<=n&&Math.abs(e[5]-t[5])<=n&&Math.abs(e[6]-t[6])<=n&&Math.abs(e[7]-t[7])<=n&&Math.abs(e[8]-t[8])<=n&&Math.abs(e[9]-t[9])<=n&&Math.abs(e[10]-t[10])<=n&&Math.abs(e[11]-t[11])<=n&&Math.abs(e[12]-t[12])<=n&&Math.abs(e[13]-t[13])<=n&&Math.abs(e[14]-t[14])<=n&&Math.abs(e[15]-t[15])<=n},f.getTranslation=function(e,t){return r.typeOf.object("matrix",e),r.typeOf.object("result",t),t.x=e[12],t.y=e[13],t.z=e[14],t},f.getRotation=function(e,t){return r.typeOf.object("matrix",e),r.typeOf.object("result",t),t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[4],t[4]=e[5],t[5]=e[6],t[6]=e[8],t[7]=e[9],t[8]=e[10],t};var O=new s,_=new s,R=new t,T=new t(0,0,0,1);return f.inverse=function(e,n){r.typeOf.object("matrix",e),r.typeOf.object("result",n);var o=e[0],i=e[4],a=e[8],l=e[12],d=e[1],h=e[5],p=e[9],m=e[13],y=e[2],E=e[6],g=e[10],w=e[14],A=e[3],b=e[7],C=e[11],S=e[15],v=g*S,I=w*C,N=E*S,M=w*b,x=E*C,P=g*b,D=y*S,F=w*A,U=y*C,L=g*A,q=y*b,B=E*A,j=v*h+M*p+x*m-(I*h+N*p+P*m),z=I*d+D*p+L*m-(v*d+F*p+U*m),G=N*d+F*h+q*m-(M*d+D*h+B*m),V=P*d+U*h+B*p-(x*d+L*h+q*p),W=I*i+N*a+P*l-(v*i+M*a+x*l),X=v*o+F*a+U*l-(I*o+D*a+L*l),H=M*o+D*i+B*l-(N*o+F*i+q*l),k=x*o+L*i+q*a-(P*o+U*i+B*a),Y=(v=a*m)*b+(M=l*h)*C+(x=i*p)*S-((I=l*p)*b+(N=i*m)*C+(P=a*h)*S),K=I*A+(D=o*m)*C+(L=a*d)*S-(v*A+(F=l*d)*C+(U=o*p)*S),Z=N*A+F*b+(q=o*h)*S-(M*A+D*b+(B=i*d)*S),Q=P*A+U*b+B*C-(x*A+L*b+q*C),J=N*g+P*w+I*E-(x*w+v*E+M*g),$=U*w+v*y+F*g-(D*g+L*w+I*y),ee=D*E+B*w+M*y-(q*w+N*y+F*E),te=q*g+x*y+L*E-(U*E+B*g+P*y),re=o*j+i*z+a*G+l*V;if(Math.abs(re)<u.EPSILON21){if(s.equalsEpsilon(f.getRotation(e,O),_,u.EPSILON7)&&t.equals(f.getRow(e,3,R),T))return n[0]=0,n[1]=0,n[2]=0,n[3]=0,n[4]=0,n[5]=0,n[6]=0,n[7]=0,n[8]=0,n[9]=0,n[10]=0,n[11]=0,n[12]=-e[12],n[13]=-e[13],n[14]=-e[14],n[15]=1,n;throw new c("matrix is not invertible because its determinate is zero.")}return re=1/re,n[0]=j*re,n[1]=z*re,n[2]=G*re,n[3]=V*re,n[4]=W*re,n[5]=X*re,n[6]=H*re,n[7]=k*re,n[8]=Y*re,n[9]=K*re,n[10]=Z*re,n[11]=Q*re,n[12]=J*re,n[13]=$*re,n[14]=ee*re,n[15]=te*re,n},f.inverseTransformation=function(e,t){r.typeOf.object("matrix",e),r.typeOf.object("result",t);var n=e[0],o=e[1],i=e[2],a=e[4],u=e[5],s=e[6],c=e[8],f=e[9],l=e[10],d=e[12],h=e[13],p=e[14],m=-n*d-o*h-i*p,y=-a*d-u*h-s*p,E=-c*d-f*h-l*p;return t[0]=n,t[1]=a,t[2]=c,t[3]=0,t[4]=o,t[5]=u,t[6]=f,t[7]=0,t[8]=i,t[9]=s,t[10]=l,t[11]=0,t[12]=m,t[13]=y,t[14]=E,t[15]=1,t},f.IDENTITY=a(new f(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1)),f.ZERO=a(new f(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0)),f.COLUMN0ROW0=0,f.COLUMN0ROW1=1,f.COLUMN0ROW2=2,f.COLUMN0ROW3=3,f.COLUMN1ROW0=4,f.COLUMN1ROW1=5,f.COLUMN1ROW2=6,f.COLUMN1ROW3=7,f.COLUMN2ROW0=8,f.COLUMN2ROW1=9,f.COLUMN2ROW2=10,f.COLUMN2ROW3=11,f.COLUMN3ROW0=12,f.COLUMN3ROW1=13,f.COLUMN3ROW2=14,f.COLUMN3ROW3=15,i(f.prototype,{length:{get:function(){return f.packedLength}}}),f.prototype.clone=function(e){return f.clone(this,e)},f.prototype.equals=function(e){return f.equals(this,e)},f.equalsArray=function(e,t,r){return e[0]===t[r]&&e[1]===t[r+1]&&e[2]===t[r+2]&&e[3]===t[r+3]&&e[4]===t[r+4]&&e[5]===t[r+5]&&e[6]===t[r+6]&&e[7]===t[r+7]&&e[8]===t[r+8]&&e[9]===t[r+9]&&e[10]===t[r+10]&&e[11]===t[r+11]&&e[12]===t[r+12]&&e[13]===t[r+13]&&e[14]===t[r+14]&&e[15]===t[r+15]},f.prototype.equalsEpsilon=function(e,t){return f.equalsEpsilon(this,e,t)},f.prototype.toString=function(){return"("+this[0]+", "+this[4]+", "+this[8]+", "+this[12]+")\n("+this[1]+", "+this[5]+", "+this[9]+", "+this[13]+")\n("+this[2]+", "+this[6]+", "+this[10]+", "+this[14]+")\n("+this[3]+", "+this[7]+", "+this[11]+", "+this[15]+")"},f})),define("Core/Rectangle",["./Cartographic","./Check","./defaultValue","./defined","./defineProperties","./Ellipsoid","./freezeObject","./Math"],(function(e,t,r,n,o,i,a,u){"use strict";function s(e,t,n,o){this.west=r(e,0),this.south=r(t,0),this.east=r(n,0),this.north=r(o,0)}o(s.prototype,{width:{get:function(){return s.computeWidth(this)}},height:{get:function(){return s.computeHeight(this)}}}),s.packedLength=4,s.pack=function(e,n,o){return t.typeOf.object("value",e),t.defined("array",n),o=r(o,0),n[o++]=e.west,n[o++]=e.south,n[o++]=e.east,n[o]=e.north,n},s.unpack=function(e,o,i){return t.defined("array",e),o=r(o,0),n(i)||(i=new s),i.west=e[o++],i.south=e[o++],i.east=e[o++],i.north=e[o],i},s.computeWidth=function(e){t.typeOf.object("rectangle",e);var r=e.east,n=e.west;return r<n&&(r+=u.TWO_PI),r-n},s.computeHeight=function(e){return t.typeOf.object("rectangle",e),e.north-e.south},s.fromDegrees=function(e,t,o,i,a){return e=u.toRadians(r(e,0)),t=u.toRadians(r(t,0)),o=u.toRadians(r(o,0)),i=u.toRadians(r(i,0)),n(a)?(a.west=e,a.south=t,a.east=o,a.north=i,a):new s(e,t,o,i)},s.fromRadians=function(e,t,o,i,a){return n(a)?(a.west=r(e,0),a.south=r(t,0),a.east=r(o,0),a.north=r(i,0),a):new s(e,t,o,i)},s.fromCartographicArray=function(e,r){t.defined("cartographics",e);for(var o=Number.MAX_VALUE,i=-Number.MAX_VALUE,a=Number.MAX_VALUE,c=-Number.MAX_VALUE,f=Number.MAX_VALUE,l=-Number.MAX_VALUE,d=0,h=e.length;d<h;d++){var p=e[d];o=Math.min(o,p.longitude),i=Math.max(i,p.longitude),f=Math.min(f,p.latitude),l=Math.max(l,p.latitude);var m=p.longitude>=0?p.longitude:p.longitude+u.TWO_PI;a=Math.min(a,m),c=Math.max(c,m)}return i-o>c-a&&(o=a,(i=c)>u.PI&&(i-=u.TWO_PI),o>u.PI&&(o-=u.TWO_PI)),n(r)?(r.west=o,r.south=f,r.east=i,r.north=l,r):new s(o,f,i,l)},s.fromCartesianArray=function(e,o,a){t.defined("cartesians",e),o=r(o,i.WGS84);for(var c=Number.MAX_VALUE,f=-Number.MAX_VALUE,l=Number.MAX_VALUE,d=-Number.MAX_VALUE,h=Number.MAX_VALUE,p=-Number.MAX_VALUE,m=0,y=e.length;m<y;m++){var E=o.cartesianToCartographic(e[m]);c=Math.min(c,E.longitude),f=Math.max(f,E.longitude),h=Math.min(h,E.latitude),p=Math.max(p,E.latitude);var O=E.longitude>=0?E.longitude:E.longitude+u.TWO_PI;l=Math.min(l,O),d=Math.max(d,O)}return f-c>d-l&&(c=l,(f=d)>u.PI&&(f-=u.TWO_PI),c>u.PI&&(c-=u.TWO_PI)),n(a)?(a.west=c,a.south=h,a.east=f,a.north=p,a):new s(c,h,f,p)},s.clone=function(e,t){if(n(e))return n(t)?(t.west=e.west,t.south=e.south,t.east=e.east,t.north=e.north,t):new s(e.west,e.south,e.east,e.north)},s.equalsEpsilon=function(e,r,o){return t.typeOf.number("absoluteEpsilon",o),e===r||n(e)&&n(r)&&Math.abs(e.west-r.west)<=o&&Math.abs(e.south-r.south)<=o&&Math.abs(e.east-r.east)<=o&&Math.abs(e.north-r.north)<=o},s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s.equals=function(e,t){return e===t||n(e)&&n(t)&&e.west===t.west&&e.south===t.south&&e.east===t.east&&e.north===t.north},s.prototype.equalsEpsilon=function(e,r){return t.typeOf.number("epsilon",r),s.equalsEpsilon(this,e,r)},s.validate=function(e){t.typeOf.object("rectangle",e);var r=e.north;t.typeOf.number.greaterThanOrEquals("north",r,-u.PI_OVER_TWO),t.typeOf.number.lessThanOrEquals("north",r,u.PI_OVER_TWO);var n=e.south;t.typeOf.number.greaterThanOrEquals("south",n,-u.PI_OVER_TWO),t.typeOf.number.lessThanOrEquals("south",n,u.PI_OVER_TWO);var o=e.west;t.typeOf.number.greaterThanOrEquals("west",o,-Math.PI),t.typeOf.number.lessThanOrEquals("west",o,Math.PI);var i=e.east;t.typeOf.number.greaterThanOrEquals("east",i,-Math.PI),t.typeOf.number.lessThanOrEquals("east",i,Math.PI)},s.southwest=function(r,o){return t.typeOf.object("rectangle",r),n(o)?(o.longitude=r.west,o.latitude=r.south,o.height=0,o):new e(r.west,r.south)},s.northwest=function(r,o){return t.typeOf.object("rectangle",r),n(o)?(o.longitude=r.west,o.latitude=r.north,o.height=0,o):new e(r.west,r.north)},s.northeast=function(r,o){return t.typeOf.object("rectangle",r),n(o)?(o.longitude=r.east,o.latitude=r.north,o.height=0,o):new e(r.east,r.north)},s.southeast=function(r,o){return t.typeOf.object("rectangle",r),n(o)?(o.longitude=r.east,o.latitude=r.south,o.height=0,o):new e(r.east,r.south)},s.center=function(r,o){t.typeOf.object("rectangle",r);var i=r.east,a=r.west;i<a&&(i+=u.TWO_PI);var s=u.negativePiToPi(.5*(a+i)),c=.5*(r.south+r.north);return n(o)?(o.longitude=s,o.latitude=c,o.height=0,o):new e(s,c)},s.intersection=function(e,r,o){t.typeOf.object("rectangle",e),t.typeOf.object("otherRectangle",r);var i=e.east,a=e.west,c=r.east,f=r.west;i<a&&c>0?i+=u.TWO_PI:c<f&&i>0&&(c+=u.TWO_PI),i<a&&f<0?f+=u.TWO_PI:c<f&&a<0&&(a+=u.TWO_PI);var l=u.negativePiToPi(Math.max(a,f)),d=u.negativePiToPi(Math.min(i,c));if(!((e.west<e.east||r.west<r.east)&&d<=l)){var h=Math.max(e.south,r.south),p=Math.min(e.north,r.north);if(!(h>=p))return n(o)?(o.west=l,o.south=h,o.east=d,o.north=p,o):new s(l,h,d,p)}},s.simpleIntersection=function(e,r,o){t.typeOf.object("rectangle",e),t.typeOf.object("otherRectangle",r);var i=Math.max(e.west,r.west),a=Math.max(e.south,r.south),u=Math.min(e.east,r.east),c=Math.min(e.north,r.north);if(!(a>=c||i>=u))return n(o)?(o.west=i,o.south=a,o.east=u,o.north=c,o):new s(i,a,u,c)},s.union=function(e,r,o){t.typeOf.object("rectangle",e),t.typeOf.object("otherRectangle",r),n(o)||(o=new s);var i=e.east,a=e.west,c=r.east,f=r.west;i<a&&c>0?i+=u.TWO_PI:c<f&&i>0&&(c+=u.TWO_PI),i<a&&f<0?f+=u.TWO_PI:c<f&&a<0&&(a+=u.TWO_PI);var l=u.convertLongitudeRange(Math.min(a,f)),d=u.convertLongitudeRange(Math.max(i,c));return o.west=l,o.south=Math.min(e.south,r.south),o.east=d,o.north=Math.max(e.north,r.north),o},s.expand=function(e,r,o){return t.typeOf.object("rectangle",e),t.typeOf.object("cartographic",r),n(o)||(o=new s),o.west=Math.min(e.west,r.longitude),o.south=Math.min(e.south,r.latitude),o.east=Math.max(e.east,r.longitude),o.north=Math.max(e.north,r.latitude),o},s.contains=function(e,r){t.typeOf.object("rectangle",e),t.typeOf.object("cartographic",r);var n=r.longitude,o=r.latitude,i=e.west,a=e.east;return a<i&&(a+=u.TWO_PI,n<0&&(n+=u.TWO_PI)),(n>i||u.equalsEpsilon(n,i,u.EPSILON14))&&(n<a||u.equalsEpsilon(n,a,u.EPSILON14))&&o>=e.south&&o<=e.north};var c=new e;return s.subsample=function(e,o,a,f){t.typeOf.object("rectangle",e),o=r(o,i.WGS84),a=r(a,0),n(f)||(f=[]);var l=0,d=e.north,h=e.south,p=e.east,m=e.west,y=c;y.height=a,y.longitude=m,y.latitude=d,f[l]=o.cartographicToCartesian(y,f[l]),l++,y.longitude=p,f[l]=o.cartographicToCartesian(y,f[l]),l++,y.latitude=h,f[l]=o.cartographicToCartesian(y,f[l]),l++,y.longitude=m,f[l]=o.cartographicToCartesian(y,f[l]),l++,y.latitude=d<0?d:h>0?h:0;for(var E=1;E<8;++E)y.longitude=-Math.PI+E*u.PI_OVER_TWO,s.contains(e,y)&&(f[l]=o.cartographicToCartesian(y,f[l]),l++);return 0===y.latitude&&(y.longitude=m,f[l]=o.cartographicToCartesian(y,f[l]),l++,y.longitude=p,f[l]=o.cartographicToCartesian(y,f[l]),l++),f.length=l,f},s.MAX_VALUE=a(new s(-Math.PI,-u.PI_OVER_TWO,Math.PI,u.PI_OVER_TWO)),s})),define("Core/BoundingSphere",["./Cartesian3","./Cartographic","./Check","./defaultValue","./defined","./Ellipsoid","./GeographicProjection","./Intersect","./Interval","./Math","./Matrix3","./Matrix4","./Rectangle"],(function(e,t,r,n,o,i,a,u,s,c,f,l,d){"use strict";function h(t,r){this.center=e.clone(n(t,e.ZERO)),this.radius=n(r,0)}var p=new e,m=new e,y=new e,E=new e,O=new e,_=new e,R=new e,T=new e,g=new e,w=new e,A=new e,b=new e,C=4/3*c.PI;h.fromPoints=function(t,r){if(o(r)||(r=new h),!o(t)||0===t.length)return r.center=e.clone(e.ZERO,r.center),r.radius=0,r;var n,i=e.clone(t[0],R),a=e.clone(i,p),u=e.clone(i,m),s=e.clone(i,y),c=e.clone(i,E),f=e.clone(i,O),l=e.clone(i,_),d=t.length;for(n=1;n<d;n++){e.clone(t[n],i);var C=i.x,S=i.y,v=i.z;C<a.x&&e.clone(i,a),C>c.x&&e.clone(i,c),S<u.y&&e.clone(i,u),S>f.y&&e.clone(i,f),v<s.z&&e.clone(i,s),v>l.z&&e.clone(i,l)}var I=e.magnitudeSquared(e.subtract(c,a,T)),N=e.magnitudeSquared(e.subtract(f,u,T)),M=e.magnitudeSquared(e.subtract(l,s,T)),x=a,P=c,D=I;N>D&&(D=N,x=u,P=f),M>D&&(D=M,x=s,P=l);var F=g;F.x=.5*(x.x+P.x),F.y=.5*(x.y+P.y),F.z=.5*(x.z+P.z);var U=e.magnitudeSquared(e.subtract(P,F,T)),L=Math.sqrt(U),q=w;q.x=a.x,q.y=u.y,q.z=s.z;var B=A;B.x=c.x,B.y=f.y,B.z=l.z;var j=e.midpoint(q,B,b),z=0;for(n=0;n<d;n++){e.clone(t[n],i);var G=e.magnitude(e.subtract(i,j,T));G>z&&(z=G);var V=e.magnitudeSquared(e.subtract(i,F,T));if(V>U){var W=Math.sqrt(V);U=(L=.5*(L+W))*L;var X=W-L;F.x=(L*F.x+X*i.x)/W,F.y=(L*F.y+X*i.y)/W,F.z=(L*F.z+X*i.z)/W}}return L<z?(e.clone(F,r.center),r.radius=L):(e.clone(j,r.center),r.radius=z),r};var S=new a,v=new e,I=new e,N=new t,M=new t;h.fromRectangle2D=function(e,t,r){return h.fromRectangleWithHeights2D(e,t,0,0,r)},h.fromRectangleWithHeights2D=function(t,r,i,a,u){if(o(u)||(u=new h),!o(t))return u.center=e.clone(e.ZERO,u.center),u.radius=0,u;r=n(r,S),d.southwest(t,N),N.height=i,d.northeast(t,M),M.height=a;var s=r.project(N,v),c=r.project(M,I),f=c.x-s.x,l=c.y-s.y,p=c.z-s.z;u.radius=.5*Math.sqrt(f*f+l*l+p*p);var m=u.center;return m.x=s.x+.5*f,m.y=s.y+.5*l,m.z=s.z+.5*p,u};var x=[];h.fromRectangle3D=function(t,r,a,u){if(r=n(r,i.WGS84),a=n(a,0),o(u)||(u=new h),!o(t))return u.center=e.clone(e.ZERO,u.center),u.radius=0,u;var s=d.subsample(t,r,a,x);return h.fromPoints(s,u)},h.fromVertices=function(t,i,a,u){if(o(u)||(u=new h),!o(t)||0===t.length)return u.center=e.clone(e.ZERO,u.center),u.radius=0,u;i=n(i,e.ZERO),a=n(a,3),r.typeOf.number.greaterThanOrEquals("stride",a,3);var s=R;s.x=t[0]+i.x,s.y=t[1]+i.y,s.z=t[2]+i.z;var c,f=e.clone(s,p),l=e.clone(s,m),d=e.clone(s,y),C=e.clone(s,E),S=e.clone(s,O),v=e.clone(s,_),I=t.length;for(c=0;c<I;c+=a){var N=t[c]+i.x,M=t[c+1]+i.y,x=t[c+2]+i.z;s.x=N,s.y=M,s.z=x,N<f.x&&e.clone(s,f),N>C.x&&e.clone(s,C),M<l.y&&e.clone(s,l),M>S.y&&e.clone(s,S),x<d.z&&e.clone(s,d),x>v.z&&e.clone(s,v)}var P=e.magnitudeSquared(e.subtract(C,f,T)),D=e.magnitudeSquared(e.subtract(S,l,T)),F=e.magnitudeSquared(e.subtract(v,d,T)),U=f,L=C,q=P;D>q&&(q=D,U=l,L=S),F>q&&(q=F,U=d,L=v);var B=g;B.x=.5*(U.x+L.x),B.y=.5*(U.y+L.y),B.z=.5*(U.z+L.z);var j=e.magnitudeSquared(e.subtract(L,B,T)),z=Math.sqrt(j),G=w;G.x=f.x,G.y=l.y,G.z=d.z;var V=A;V.x=C.x,V.y=S.y,V.z=v.z;var W=e.midpoint(G,V,b),X=0;for(c=0;c<I;c+=a){s.x=t[c]+i.x,s.y=t[c+1]+i.y,s.z=t[c+2]+i.z;var H=e.magnitude(e.subtract(s,W,T));H>X&&(X=H);var k=e.magnitudeSquared(e.subtract(s,B,T));if(k>j){var Y=Math.sqrt(k);j=(z=.5*(z+Y))*z;var K=Y-z;B.x=(z*B.x+K*s.x)/Y,B.y=(z*B.y+K*s.y)/Y,B.z=(z*B.z+K*s.z)/Y}}return z<X?(e.clone(B,u.center),u.radius=z):(e.clone(W,u.center),u.radius=X),u},h.fromEncodedCartesianVertices=function(t,r,n){if(o(n)||(n=new h),!o(t)||!o(r)||t.length!==r.length||0===t.length)return n.center=e.clone(e.ZERO,n.center),n.radius=0,n;var i=R;i.x=t[0]+r[0],i.y=t[1]+r[1],i.z=t[2]+r[2];var a,u=e.clone(i,p),s=e.clone(i,m),c=e.clone(i,y),f=e.clone(i,E),l=e.clone(i,O),d=e.clone(i,_),C=t.length;for(a=0;a<C;a+=3){var S=t[a]+r[a],v=t[a+1]+r[a+1],I=t[a+2]+r[a+2];i.x=S,i.y=v,i.z=I,S<u.x&&e.clone(i,u),S>f.x&&e.clone(i,f),v<s.y&&e.clone(i,s),v>l.y&&e.clone(i,l),I<c.z&&e.clone(i,c),I>d.z&&e.clone(i,d)}var N=e.magnitudeSquared(e.subtract(f,u,T)),M=e.magnitudeSquared(e.subtract(l,s,T)),x=e.magnitudeSquared(e.subtract(d,c,T)),P=u,D=f,F=N;M>F&&(F=M,P=s,D=l),x>F&&(F=x,P=c,D=d);var U=g;U.x=.5*(P.x+D.x),U.y=.5*(P.y+D.y),U.z=.5*(P.z+D.z);var L=e.magnitudeSquared(e.subtract(D,U,T)),q=Math.sqrt(L),B=w;B.x=u.x,B.y=s.y,B.z=c.z;var j=A;j.x=f.x,j.y=l.y,j.z=d.z;var z=e.midpoint(B,j,b),G=0;for(a=0;a<C;a+=3){i.x=t[a]+r[a],i.y=t[a+1]+r[a+1],i.z=t[a+2]+r[a+2];var V=e.magnitude(e.subtract(i,z,T));V>G&&(G=V);var W=e.magnitudeSquared(e.subtract(i,U,T));if(W>L){var X=Math.sqrt(W);L=(q=.5*(q+X))*q;var H=X-q;U.x=(q*U.x+H*i.x)/X,U.y=(q*U.y+H*i.y)/X,U.z=(q*U.z+H*i.z)/X}}return q<G?(e.clone(U,n.center),n.radius=q):(e.clone(z,n.center),n.radius=G),n},h.fromCornerPoints=function(t,n,i){r.typeOf.object("corner",t),r.typeOf.object("oppositeCorner",n),o(i)||(i=new h);var a=e.midpoint(t,n,i.center);return i.radius=e.distance(a,n),i},h.fromEllipsoid=function(t,n){return r.typeOf.object("ellipsoid",t),o(n)||(n=new h),e.clone(e.ZERO,n.center),n.radius=t.maximumRadius,n};var P=new e;h.fromBoundingSpheres=function(t,r){if(o(r)||(r=new h),!o(t)||0===t.length)return r.center=e.clone(e.ZERO,r.center),r.radius=0,r;var n=t.length;if(1===n)return h.clone(t[0],r);if(2===n)return h.union(t[0],t[1],r);var i,a=[];for(i=0;i<n;i++)a.push(t[i].center);var u=(r=h.fromPoints(a,r)).center,s=r.radius;for(i=0;i<n;i++){var c=t[i];s=Math.max(s,e.distance(u,c.center,P)+c.radius)}return r.radius=s,r};var D=new e,F=new e,U=new e;h.fromOrientedBoundingBox=function(t,n){r.defined("orientedBoundingBox",t),o(n)||(n=new h);var i=t.halfAxes,a=f.getColumn(i,0,D),u=f.getColumn(i,1,F),s=f.getColumn(i,2,U);return e.add(a,u,a),e.add(a,s,a),n.center=e.clone(t.center,n.center),n.radius=e.magnitude(a),n},h.clone=function(t,r){if(o(t))return o(r)?(r.center=e.clone(t.center,r.center),r.radius=t.radius,r):new h(t.center,t.radius)},h.packedLength=4,h.pack=function(e,t,o){r.typeOf.object("value",e),r.defined("array",t),o=n(o,0);var i=e.center;return t[o++]=i.x,t[o++]=i.y,t[o++]=i.z,t[o]=e.radius,t},h.unpack=function(e,t,i){r.defined("array",e),t=n(t,0),o(i)||(i=new h);var a=i.center;return a.x=e[t++],a.y=e[t++],a.z=e[t++],i.radius=e[t],i};var L=new e,q=new e;h.union=function(t,n,i){r.typeOf.object("left",t),r.typeOf.object("right",n),o(i)||(i=new h);var a=t.center,u=t.radius,s=n.center,c=n.radius,f=e.subtract(s,a,L),l=e.magnitude(f);if(u>=l+c)return t.clone(i),i;if(c>=l+u)return n.clone(i),i;var d=.5*(u+l+c),p=e.multiplyByScalar(f,(-u+d)/l,q);return e.add(p,a,p),e.clone(p,i.center),i.radius=d,i};var B=new e;h.expand=function(t,n,o){r.typeOf.object("sphere",t),r.typeOf.object("point",n),o=h.clone(t,o);var i=e.magnitude(e.subtract(n,o.center,B));return i>o.radius&&(o.radius=i),o},h.intersectPlane=function(t,n){r.typeOf.object("sphere",t),r.typeOf.object("plane",n);var o=t.center,i=t.radius,a=n.normal,s=e.dot(a,o)+n.distance;return s<-i?u.OUTSIDE:s<i?u.INTERSECTING:u.INSIDE},h.transform=function(e,t,n){return r.typeOf.object("sphere",e),r.typeOf.object("transform",t),o(n)||(n=new h),n.center=l.multiplyByPoint(t,e.center,n.center),n.radius=l.getMaximumScale(t)*e.radius,n};var j=new e;h.distanceSquaredTo=function(t,n){r.typeOf.object("sphere",t),r.typeOf.object("cartesian",n);var o=e.subtract(t.center,n,j);return e.magnitudeSquared(o)-t.radius*t.radius},h.transformWithoutScale=function(e,t,n){return r.typeOf.object("sphere",e),r.typeOf.object("transform",t),o(n)||(n=new h),n.center=l.multiplyByPoint(t,e.center,n.center),n.radius=e.radius,n};var z=new e;h.computePlaneDistances=function(t,n,i,a){r.typeOf.object("sphere",t),r.typeOf.object("position",n),r.typeOf.object("direction",i),o(a)||(a=new s);var u=e.subtract(t.center,n,z),c=e.dot(i,u);return a.start=c-t.radius,a.stop=c+t.radius,a};for(var G=new e,V=new e,W=new e,X=new e,H=new e,k=new t,Y=new Array(8),K=0;K<8;++K)Y[K]=new e;var Z=new a;return h.projectTo2D=function(t,o,i){r.typeOf.object("sphere",t);var a=(o=n(o,Z)).ellipsoid,u=t.center,s=t.radius,c=a.geodeticSurfaceNormal(u,G),f=e.cross(e.UNIT_Z,c,V);e.normalize(f,f);var l=e.cross(c,f,W);e.normalize(l,l),e.multiplyByScalar(c,s,c),e.multiplyByScalar(l,s,l),e.multiplyByScalar(f,s,f);var d=e.negate(l,H),p=e.negate(f,X),m=Y,y=m[0];e.add(c,l,y),e.add(y,f,y),y=m[1],e.add(c,l,y),e.add(y,p,y),y=m[2],e.add(c,d,y),e.add(y,p,y),y=m[3],e.add(c,d,y),e.add(y,f,y),e.negate(c,c),y=m[4],e.add(c,l,y),e.add(y,f,y),y=m[5],e.add(c,l,y),e.add(y,p,y),y=m[6],e.add(c,d,y),e.add(y,p,y),y=m[7],e.add(c,d,y),e.add(y,f,y);for(var E=m.length,O=0;O<E;++O){var _=m[O];e.add(u,_,_);var R=a.cartesianToCartographic(_,k);o.project(R,_)}var T=(u=(i=h.fromPoints(m,i)).center).x,g=u.y,w=u.z;return u.x=w,u.y=T,u.z=g,i},h.isOccluded=function(e,t){return r.typeOf.object("sphere",e),r.typeOf.object("occluder",t),!t.isBoundingSphereVisible(e)},h.equals=function(t,r){return t===r||o(t)&&o(r)&&e.equals(t.center,r.center)&&t.radius===r.radius},h.prototype.intersectPlane=function(e){return h.intersectPlane(this,e)},h.prototype.distanceSquaredTo=function(e){return h.distanceSquaredTo(this,e)},h.prototype.computePlaneDistances=function(e,t,r){return h.computePlaneDistances(this,e,t,r)},h.prototype.isOccluded=function(e){return h.isOccluded(this,e)},h.prototype.equals=function(e){return h.equals(this,e)},h.prototype.clone=function(e){return h.clone(this,e)},h.prototype.volume=function(){var e=this.radius;return C*e*e*e},h})),define("Core/AxisAlignedBoundingBox",["./Cartesian3","./Check","./defaultValue","./defined","./Intersect"],(function(e,t,r,n,o){"use strict";function i(t,o,i){this.minimum=e.clone(r(t,e.ZERO)),this.maximum=e.clone(r(o,e.ZERO)),i=n(i)?e.clone(i):e.midpoint(this.minimum,this.maximum,new e),this.center=i}i.fromPoints=function(t,r){if(n(r)||(r=new i),!n(t)||0===t.length)return r.minimum=e.clone(e.ZERO,r.minimum),r.maximum=e.clone(e.ZERO,r.maximum),r.center=e.clone(e.ZERO,r.center),r;for(var o=t[0].x,a=t[0].y,u=t[0].z,s=t[0].x,c=t[0].y,f=t[0].z,l=t.length,d=1;d<l;d++){var h=t[d],p=h.x,m=h.y,y=h.z;o=Math.min(p,o),s=Math.max(p,s),a=Math.min(m,a),c=Math.max(m,c),u=Math.min(y,u),f=Math.max(y,f)}var E=r.minimum;E.x=o,E.y=a,E.z=u;var O=r.maximum;return O.x=s,O.y=c,O.z=f,r.center=e.midpoint(E,O,r.center),r},i.clone=function(t,r){if(n(t))return n(r)?(r.minimum=e.clone(t.minimum,r.minimum),r.maximum=e.clone(t.maximum,r.maximum),r.center=e.clone(t.center,r.center),r):new i(t.minimum,t.maximum,t.center)},i.equals=function(t,r){return t===r||n(t)&&n(r)&&e.equals(t.center,r.center)&&e.equals(t.minimum,r.minimum)&&e.equals(t.maximum,r.maximum)};var a=new e;return i.intersectPlane=function(r,n){t.defined("box",r),t.defined("plane",n),a=e.subtract(r.maximum,r.minimum,a);var i=e.multiplyByScalar(a,.5,a),u=n.normal,s=i.x*Math.abs(u.x)+i.y*Math.abs(u.y)+i.z*Math.abs(u.z),c=e.dot(r.center,u)+n.distance;return c-s>0?o.INSIDE:c+s<0?o.OUTSIDE:o.INTERSECTING},i.prototype.clone=function(e){return i.clone(this,e)},i.prototype.intersectPlane=function(e){return i.intersectPlane(this,e)},i.prototype.equals=function(e){return i.equals(this,e)},i})),define("Core/QuadraticRealPolynomial",["./DeveloperError","./Math"],(function(e,t){"use strict";var r={};function n(e,r,n){var o=e+r;return t.sign(e)!==t.sign(r)&&Math.abs(o/Math.max(Math.abs(e),Math.abs(r)))<n?0:o}return r.computeDiscriminant=function(t,r,n){if("number"!=typeof t)throw new e("a is a required number.");if("number"!=typeof r)throw new e("b is a required number.");if("number"!=typeof n)throw new e("c is a required number.");return r*r-4*t*n},r.computeRealRoots=function(r,o,i){if("number"!=typeof r)throw new e("a is a required number.");if("number"!=typeof o)throw new e("b is a required number.");if("number"!=typeof i)throw new e("c is a required number.");var a;if(0===r)return 0===o?[]:[-i/o];if(0===o){if(0===i)return[0,0];var u=Math.abs(i),s=Math.abs(r);if(u<s&&u/s<t.EPSILON14)return[0,0];if(u>s&&s/u<t.EPSILON14)return[];if((a=-i/r)<0)return[];var c=Math.sqrt(a);return[-c,c]}if(0===i)return(a=-o/r)<0?[a,0]:[0,a];var f=n(o*o,-4*r*i,t.EPSILON14);if(f<0)return[];var l=-.5*n(o,t.sign(o)*Math.sqrt(f),t.EPSILON14);return o>0?[l/r,i/l]:[i/l,l/r]},r})),define("Core/CubicRealPolynomial",["./DeveloperError","./QuadraticRealPolynomial"],(function(e,t){"use strict";var r={};function n(e,t,r,n){var o,i,a=e,u=t/3,s=r/3,c=n,f=a*s,l=u*c,d=u*u,h=s*s,p=a*s-d,m=a*c-u*s,y=u*c-h,E=4*p*y-m*m;if(E<0){var O,_,R;d*l>=f*h?(O=a,_=p,R=-2*u*p+a*m):(O=c,_=y,R=-c*m+2*s*y);var T=-(R<0?-1:1)*Math.abs(O)*Math.sqrt(-E),g=(i=-R+T)/2,w=g<0?-Math.pow(-g,1/3):Math.pow(g,1/3),A=i===T?-w:-_/w;return o=_<=0?w+A:-R/(w*w+A*A+_),d*l>=f*h?[(o-u)/a]:[-c/(o+s)]}var b=p,C=-2*u*p+a*m,S=y,v=-c*m+2*s*y,I=Math.sqrt(E),N=Math.sqrt(3)/2,M=Math.abs(Math.atan2(a*I,-C)/3);o=2*Math.sqrt(-b);var x=Math.cos(M);i=o*x;var P=o*(-x/2-N*Math.sin(M)),D=i+P>2*u?i-u:P-u,F=a,U=D/F;M=Math.abs(Math.atan2(c*I,-v)/3);var L=-c,q=(i=(o=2*Math.sqrt(-S))*(x=Math.cos(M)))+(P=o*(-x/2-N*Math.sin(M)))<2*s?i+s:P+s,B=L/q,j=-D*q-F*L,z=(s*j-u*(D*L))/(-u*j+s*(F*q));return U<=z?U<=B?z<=B?[U,z,B]:[U,B,z]:[B,U,z]:U<=B?[z,U,B]:z<=B?[z,B,U]:[B,z,U]}return r.computeDiscriminant=function(t,r,n,o){if("number"!=typeof t)throw new e("a is a required number.");if("number"!=typeof r)throw new e("b is a required number.");if("number"!=typeof n)throw new e("c is a required number.");if("number"!=typeof o)throw new e("d is a required number.");var i=r*r,a=n*n;return 18*t*r*n*o+i*a-t*t*27*(o*o)-4*(t*a*n+i*r*o)},r.computeRealRoots=function(r,o,i,a){if("number"!=typeof r)throw new e("a is a required number.");if("number"!=typeof o)throw new e("b is a required number.");if("number"!=typeof i)throw new e("c is a required number.");if("number"!=typeof a)throw new e("d is a required number.");var u,s;if(0===r)return t.computeRealRoots(o,i,a);if(0===o){if(0===i){if(0===a)return[0,0,0];var c=(s=-a/r)<0?-Math.pow(-s,1/3):Math.pow(s,1/3);return[c,c,c]}return 0===a?0===(u=t.computeRealRoots(r,0,i)).Length?[0]:[u[0],0,u[1]]:n(r,0,i,a)}return 0===i?0===a?(s=-o/r)<0?[s,0,0]:[0,0,s]:n(r,o,0,a):0===a?0===(u=t.computeRealRoots(r,o,i)).length?[0]:u[1]<=0?[u[0],u[1],0]:u[0]>=0?[0,u[0],u[1]]:[u[0],0,u[1]]:n(r,o,i,a)},r})),define("Core/QuarticRealPolynomial",["./CubicRealPolynomial","./DeveloperError","./Math","./QuadraticRealPolynomial"],(function(e,t,r,n){"use strict";var o={};function i(t,o,i,a){var u=t*t,s=o-3*u/8,c=i-o*t/2+u*t/8,f=a-i*t/4+o*u/16-3*u*u/256,l=e.computeRealRoots(1,2*s,s*s-4*f,-c*c);if(l.length>0){var d=-t/4,h=l[l.length-1];if(Math.abs(h)<r.EPSILON14){var p=n.computeRealRoots(1,s,f);if(2===p.length){var m,y=p[0],E=p[1];if(y>=0&&E>=0){var O=Math.sqrt(y),_=Math.sqrt(E);return[d-_,d-O,d+O,d+_]}if(y>=0&&E<0)return[d-(m=Math.sqrt(y)),d+m];if(y<0&&E>=0)return[d-(m=Math.sqrt(E)),d+m]}return[]}if(h>0){var R=Math.sqrt(h),T=(s+h-c/R)/2,g=(s+h+c/R)/2,w=n.computeRealRoots(1,R,T),A=n.computeRealRoots(1,-R,g);return 0!==w.length?(w[0]+=d,w[1]+=d,0!==A.length?(A[0]+=d,A[1]+=d,w[1]<=A[0]?[w[0],w[1],A[0],A[1]]:A[1]<=w[0]?[A[0],A[1],w[0],w[1]]:w[0]>=A[0]&&w[1]<=A[1]?[A[0],w[0],w[1],A[1]]:A[0]>=w[0]&&A[1]<=w[1]?[w[0],A[0],A[1],w[1]]:w[0]>A[0]&&w[0]<A[1]?[A[0],w[0],A[1],w[1]]:[w[0],A[0],w[1],A[1]]):w):0!==A.length?(A[0]+=d,A[1]+=d,A):[]}}return[]}function a(t,o,i,a){var u=t*t,s=-2*o,c=i*t+o*o-4*a,f=u*a-i*o*t+i*i,l=e.computeRealRoots(1,s,c,f);if(l.length>0){var d,h,p,m,y,E,O=l[0],_=o-O,R=_*_,T=t/2,g=_/2,w=R-4*a,A=R+4*Math.abs(a),b=u-4*O,C=u+4*Math.abs(O);if(O<0||w*C<b*A){var S=Math.sqrt(b);d=S/2,h=0===S?0:(t*g-i)/S}else{var v=Math.sqrt(w);d=0===v?0:(t*g-i)/v,h=v/2}0===T&&0===d?(p=0,m=0):r.sign(T)===r.sign(d)?m=O/(p=T+d):p=O/(m=T-d),0===g&&0===h?(y=0,E=0):r.sign(g)===r.sign(h)?E=a/(y=g+h):y=a/(E=g-h);var I=n.computeRealRoots(1,p,y),N=n.computeRealRoots(1,m,E);if(0!==I.length)return 0!==N.length?I[1]<=N[0]?[I[0],I[1],N[0],N[1]]:N[1]<=I[0]?[N[0],N[1],I[0],I[1]]:I[0]>=N[0]&&I[1]<=N[1]?[N[0],I[0],I[1],N[1]]:N[0]>=I[0]&&N[1]<=I[1]?[I[0],N[0],N[1],I[1]]:I[0]>N[0]&&I[0]<N[1]?[N[0],I[0],N[1],I[1]]:[I[0],N[0],I[1],N[1]]:I;if(0!==N.length)return N}return[]}return o.computeDiscriminant=function(e,r,n,o,i){if("number"!=typeof e)throw new t("a is a required number.");if("number"!=typeof r)throw new t("b is a required number.");if("number"!=typeof n)throw new t("c is a required number.");if("number"!=typeof o)throw new t("d is a required number.");if("number"!=typeof i)throw new t("e is a required number.");var a=e*e,u=r*r,s=u*r,c=n*n,f=c*n,l=o*o,d=l*o,h=i*i;return u*c*l-4*s*d-4*e*f*l+18*e*r*n*d-27*a*l*l+a*e*256*(h*i)+i*(18*s*n*o-4*u*f+16*e*c*c-80*e*r*c*o-6*e*u*l+144*a*n*l)+h*(144*e*u*n-27*u*u-128*a*c-192*a*r*o)},o.computeRealRoots=function(n,o,u,s,c){if("number"!=typeof n)throw new t("a is a required number.");if("number"!=typeof o)throw new t("b is a required number.");if("number"!=typeof u)throw new t("c is a required number.");if("number"!=typeof s)throw new t("d is a required number.");if("number"!=typeof c)throw new t("e is a required number.");if(Math.abs(n)<r.EPSILON15)return e.computeRealRoots(o,u,s,c);var f=o/n,l=u/n,d=s/n,h=c/n,p=f<0?1:0;switch(p+=l<0?p+1:p,p+=d<0?p+1:p,p+=h<0?p+1:p){case 0:return i(f,l,d,h);case 1:case 2:return a(f,l,d,h);case 3:case 4:return i(f,l,d,h);case 5:return a(f,l,d,h);case 6:case 7:return i(f,l,d,h);case 8:return a(f,l,d,h);case 9:case 10:return i(f,l,d,h);case 11:return a(f,l,d,h);case 12:case 13:case 14:case 15:return i(f,l,d,h);default:return}},o})),define("Core/Ray",["./Cartesian3","./Check","./defaultValue","./defined"],(function(e,t,r,n){"use strict";function o(t,n){n=e.clone(r(n,e.ZERO)),e.equals(n,e.ZERO)||e.normalize(n,n),this.origin=e.clone(r(t,e.ZERO)),this.direction=n}return o.clone=function(t,r){if(n(t))return n(r)?(r.origin=e.clone(t.origin),r.direction=e.clone(t.direction),r):new o(t.origin,t.direction)},o.getPoint=function(r,o,i){return t.typeOf.object("ray",r),t.typeOf.number("t",o),n(i)||(i=new e),i=e.multiplyByScalar(r.direction,o,i),e.add(r.origin,i,i)},o})),define("Core/IntersectionTests",["./Cartesian3","./Cartographic","./defaultValue","./defined","./DeveloperError","./Interval","./Math","./Matrix3","./QuadraticRealPolynomial","./QuarticRealPolynomial","./Ray"],(function(e,t,r,n,o,i,a,u,s,c,f){"use strict";var l={rayPlane:function(t,r,i){if(!n(t))throw new o("ray is required.");if(!n(r))throw new o("plane is required.");n(i)||(i=new e);var u=t.origin,s=t.direction,c=r.normal,f=e.dot(c,s);if(!(Math.abs(f)<a.EPSILON15)){var l=(-r.distance-e.dot(c,u))/f;if(!(l<0))return i=e.multiplyByScalar(s,l,i),e.add(u,i,i)}}},d=new e,h=new e,p=new e,m=new e,y=new e;l.rayTriangleParametric=function(t,i,u,s,c){if(!n(t))throw new o("ray is required.");if(!n(i))throw new o("p0 is required.");if(!n(u))throw new o("p1 is required.");if(!n(s))throw new o("p2 is required.");c=r(c,!1);var f,l,E,O,_,R=t.origin,T=t.direction,g=e.subtract(u,i,d),w=e.subtract(s,i,h),A=e.cross(T,w,p),b=e.dot(g,A);if(c){if(b<a.EPSILON6)return;if(f=e.subtract(R,i,m),(E=e.dot(f,A))<0||E>b)return;if(l=e.cross(f,g,y),(O=e.dot(T,l))<0||E+O>b)return;_=e.dot(w,l)/b}else{if(Math.abs(b)<a.EPSILON6)return;var C=1/b;if(f=e.subtract(R,i,m),(E=e.dot(f,A)*C)<0||E>1)return;if(l=e.cross(f,g,y),(O=e.dot(T,l)*C)<0||E+O>1)return;_=e.dot(w,l)*C}return _},l.rayTriangle=function(t,r,o,i,a,u){var s=l.rayTriangleParametric(t,r,o,i,a);if(n(s)&&!(s<0))return n(u)||(u=new e),e.multiplyByScalar(t.direction,s,u),e.add(t.origin,u,u)};var E=new f;l.lineSegmentTriangle=function(t,r,i,a,u,s,c){if(!n(t))throw new o("v0 is required.");if(!n(r))throw new o("v1 is required.");if(!n(i))throw new o("p0 is required.");if(!n(a))throw new o("p1 is required.");if(!n(u))throw new o("p2 is required.");var f=E;e.clone(t,f.origin),e.subtract(r,t,f.direction),e.normalize(f.direction,f.direction);var d=l.rayTriangleParametric(f,i,a,u,s);if(!(!n(d)||d<0||d>e.distance(t,r)))return n(c)||(c=new e),e.multiplyByScalar(f.direction,d,c),e.add(f.origin,c,c)};var O={root0:0,root1:0};function _(t,r,o){n(o)||(o=new i);var a=t.origin,u=t.direction,s=r.center,c=r.radius*r.radius,f=e.subtract(a,s,p),l=function(e,t,r,n){var o=t*t-4*e*r;if(!(o<0)){if(o>0){var i=1/(2*e),a=Math.sqrt(o),u=(-t+a)*i,s=(-t-a)*i;return u<s?(n.root0=u,n.root1=s):(n.root0=s,n.root1=u),n}var c=-t/(2*e);if(0!==c)return n.root0=n.root1=c,n}}(e.dot(u,u),2*e.dot(u,f),e.magnitudeSquared(f)-c,O);if(n(l))return o.start=l.root0,o.stop=l.root1,o}l.raySphere=function(e,t,r){if(!n(e))throw new o("ray is required.");if(!n(t))throw new o("sphere is required.");if(r=_(e,t,r),n(r)&&!(r.stop<0))return r.start=Math.max(r.start,0),r};var R=new f;l.lineSegmentSphere=function(t,r,i,a){if(!n(t))throw new o("p0 is required.");if(!n(r))throw new o("p1 is required.");if(!n(i))throw new o("sphere is required.");var u=R;e.clone(t,u.origin);var s=e.subtract(r,t,u.direction),c=e.magnitude(s);if(e.normalize(s,s),a=_(u,i,a),!(!n(a)||a.stop<0||a.start>c))return a.start=Math.max(a.start,0),a.stop=Math.min(a.stop,c),a};var T=new e,g=new e;function w(e,t,r){var n=e+t;return a.sign(e)!==a.sign(t)&&Math.abs(n/Math.max(Math.abs(e),Math.abs(t)))<r?0:n}l.rayEllipsoid=function(t,r){if(!n(t))throw new o("ray is required.");if(!n(r))throw new o("ellipsoid is required.");var a,u,s,c,f,l=r.oneOverRadii,d=e.multiplyComponents(l,t.origin,T),h=e.multiplyComponents(l,t.direction,g),p=e.magnitudeSquared(d),m=e.dot(d,h);if(p>1){if(m>=0)return;var y=m*m;if(a=p-1,y<(s=(u=e.magnitudeSquared(h))*a))return;if(y>s){c=m*m-s;var E=(f=-m+Math.sqrt(c))/u,O=a/f;return E<O?new i(E,O):{start:O,stop:E}}var _=Math.sqrt(a/u);return new i(_,_)}return p<1?(a=p-1,c=m*m-(s=(u=e.magnitudeSquared(h))*a),f=-m+Math.sqrt(c),new i(0,f/u)):m<0?(u=e.magnitudeSquared(h),new i(0,-m/u)):void 0};var A=new e,b=new e,C=new e,S=new e,v=new e,I=new u,N=new u,M=new u,x=new u,P=new u,D=new u,F=new u,U=new e,L=new e,q=new t;l.grazingAltitudeLocation=function(t,r){if(!n(t))throw new o("ray is required.");if(!n(r))throw new o("ellipsoid is required.");var i=t.origin,f=t.direction;if(!e.equals(i,e.ZERO)){var l=r.geodeticSurfaceNormal(i,A);if(e.dot(f,l)>=0)return i}var d=n(this.rayEllipsoid(t,r)),h=r.transformPositionToScaledSpace(f,A),p=e.normalize(h,h),m=e.mostOrthogonalAxis(h,S),y=e.normalize(e.cross(m,p,b),b),E=e.normalize(e.cross(p,y,C),C),O=I;O[0]=p.x,O[1]=p.y,O[2]=p.z,O[3]=y.x,O[4]=y.y,O[5]=y.z,O[6]=E.x,O[7]=E.y,O[8]=E.z;var _=u.transpose(O,N),R=u.fromScale(r.radii,M),T=u.fromScale(r.oneOverRadii,x),g=P;g[0]=0,g[1]=-f.z,g[2]=f.y,g[3]=f.z,g[4]=0,g[5]=-f.x,g[6]=-f.y,g[7]=f.x,g[8]=0;var B,j,z=u.multiply(u.multiply(_,T,D),g,D),G=u.multiply(u.multiply(z,R,F),O,F),V=u.multiplyByVector(z,i,v),W=function(t,r,n,o,i){var f,l=o*o,d=i*i,h=(t[u.COLUMN1ROW1]-t[u.COLUMN2ROW2])*d,p=i*(o*w(t[u.COLUMN1ROW0],t[u.COLUMN0ROW1],a.EPSILON15)+r.y),m=t[u.COLUMN0ROW0]*l+t[u.COLUMN2ROW2]*d+o*r.x+n,y=d*w(t[u.COLUMN2ROW1],t[u.COLUMN1ROW2],a.EPSILON15),E=i*(o*w(t[u.COLUMN2ROW0],t[u.COLUMN0ROW2])+r.z),O=[];if(0===E&&0===y){if(0===(f=s.computeRealRoots(h,p,m)).length)return O;var _=f[0],R=Math.sqrt(Math.max(1-_*_,0));if(O.push(new e(o,i*_,i*-R)),O.push(new e(o,i*_,i*R)),2===f.length){var T=f[1],g=Math.sqrt(Math.max(1-T*T,0));O.push(new e(o,i*T,i*-g)),O.push(new e(o,i*T,i*g))}return O}var A=E*E,b=y*y,C=E*y,S=h*h+b,v=2*(p*h+C),I=2*m*h+p*p-b+A,N=2*(m*p-C),M=m*m-A;if(0===S&&0===v&&0===I&&0===N)return O;var x=(f=c.computeRealRoots(S,v,I,N,M)).length;if(0===x)return O;for(var P=0;P<x;++P){var D=f[P],F=D*D,U=Math.max(1-F,0),L=Math.sqrt(U),q=(a.sign(h)===a.sign(m)?w(h*F+m,p*D,a.EPSILON12):a.sign(m)===a.sign(p*D)?w(h*F,p*D+m,a.EPSILON12):w(h*F+p*D,m,a.EPSILON12))*w(y*D,E,a.EPSILON15);q<0?O.push(new e(o,i*D,i*L)):q>0?O.push(new e(o,i*D,i*-L)):0!==L?(O.push(new e(o,i*D,i*-L)),O.push(new e(o,i*D,i*L)),++P):O.push(new e(o,i*D,i*L))}return O}(G,e.negate(V,A),0,0,1),X=W.length;if(X>0){for(var H=e.clone(e.ZERO,L),k=Number.NEGATIVE_INFINITY,Y=0;Y<X;++Y){B=u.multiplyByVector(R,u.multiplyByVector(O,W[Y],U),U);var K=e.normalize(e.subtract(B,i,S),S),Z=e.dot(K,f);Z>k&&(k=Z,H=e.clone(B,H))}var Q=r.cartesianToCartographic(H,q);return k=a.clamp(k,0,1),j=e.magnitude(e.subtract(H,i,S))*Math.sqrt(1-k*k),j=d?-j:j,Q.height=j,r.cartographicToCartesian(Q,new e)}};var B=new e;return l.lineSegmentPlane=function(t,r,i,u){if(!n(t))throw new o("endPoint0 is required.");if(!n(r))throw new o("endPoint1 is required.");if(!n(i))throw new o("plane is required.");n(u)||(u=new e);var s=e.subtract(r,t,B),c=i.normal,f=e.dot(c,s);if(!(Math.abs(f)<a.EPSILON6)){var l=e.dot(c,t),d=-(i.distance+l)/f;if(!(d<0||d>1))return e.multiplyByScalar(s,d,u),e.add(t,u,u),u}},l.trianglePlaneIntersection=function(t,r,i,a){if(!(n(t)&&n(r)&&n(i)&&n(a)))throw new o("p0, p1, p2, and plane are required.");var u,s,c=a.normal,f=a.distance,d=e.dot(c,t)+f<0,h=e.dot(c,r)+f<0,p=e.dot(c,i)+f<0,m=0;if(m+=d?1:0,m+=h?1:0,1!==(m+=p?1:0)&&2!==m||(u=new e,s=new e),1===m){if(d)return l.lineSegmentPlane(t,r,a,u),l.lineSegmentPlane(t,i,a,s),{positions:[t,r,i,u,s],indices:[0,3,4,1,2,4,1,4,3]};if(h)return l.lineSegmentPlane(r,i,a,u),l.lineSegmentPlane(r,t,a,s),{positions:[t,r,i,u,s],indices:[1,3,4,2,0,4,2,4,3]};if(p)return l.lineSegmentPlane(i,t,a,u),l.lineSegmentPlane(i,r,a,s),{positions:[t,r,i,u,s],indices:[2,3,4,0,1,4,0,4,3]}}else if(2===m){if(!d)return l.lineSegmentPlane(r,t,a,u),l.lineSegmentPlane(i,t,a,s),{positions:[t,r,i,u,s],indices:[1,2,4,1,4,3,0,3,4]};if(!h)return l.lineSegmentPlane(i,r,a,u),l.lineSegmentPlane(t,r,a,s),{positions:[t,r,i,u,s],indices:[2,0,4,2,4,3,1,3,4]};if(!p)return l.lineSegmentPlane(t,i,a,u),l.lineSegmentPlane(r,i,a,s),{positions:[t,r,i,u,s],indices:[0,1,4,0,4,3,2,3,4]}}},l})),define("Core/Plane",["./Cartesian3","./Check","./defined","./DeveloperError","./freezeObject","./Math","./Matrix4"],(function(e,t,r,n,o,i,a){"use strict";function u(r,o){if(t.typeOf.object("normal",r),!i.equalsEpsilon(e.magnitude(r),1,i.EPSILON6))throw new n("normal must be normalized.");t.typeOf.number("distance",o),this.normal=e.clone(r),this.distance=o}u.fromPointNormal=function(o,a,s){if(t.typeOf.object("point",o),t.typeOf.object("normal",a),!i.equalsEpsilon(e.magnitude(a),1,i.EPSILON6))throw new n("normal must be normalized.");var c=-e.dot(a,o);return r(s)?(e.clone(a,s.normal),s.distance=c,s):new u(a,c)};var s=new e;u.fromCartesian4=function(o,a){t.typeOf.object("coefficients",o);var c=e.fromCartesian4(o,s),f=o.w;if(!i.equalsEpsilon(e.magnitude(c),1,i.EPSILON6))throw new n("normal must be normalized.");return r(a)?(e.clone(c,a.normal),a.distance=f,a):new u(c,f)},u.getPointDistance=function(r,n){return t.typeOf.object("plane",r),t.typeOf.object("point",n),e.dot(r.normal,n)+r.distance};var c=new e;u.projectPointOntoPlane=function(n,o,i){t.typeOf.object("plane",n),t.typeOf.object("point",o),r(i)||(i=new e);var a=u.getPointDistance(n,o),s=e.multiplyByScalar(n.normal,a,c);return e.subtract(o,s,i)};var f=new e;return u.transform=function(r,n,o){return t.typeOf.object("plane",r),t.typeOf.object("transform",n),a.multiplyByPointAsVector(n,r.normal,s),e.normalize(s,s),e.multiplyByScalar(r.normal,-r.distance,f),a.multiplyByPoint(n,f,f),u.fromPointNormal(f,s,o)},u.clone=function(n,o){return t.typeOf.object("plane",n),r(o)?(e.clone(n.normal,o.normal),o.distance=n.distance,o):new u(n.normal,n.distance)},u.equals=function(r,n){return t.typeOf.object("left",r),t.typeOf.object("right",n),r.distance===n.distance&&e.equals(r.normal,n.normal)},u.ORIGIN_XY_PLANE=o(new u(e.UNIT_Z,0)),u.ORIGIN_YZ_PLANE=o(new u(e.UNIT_X,0)),u.ORIGIN_ZX_PLANE=o(new u(e.UNIT_Y,0)),u})),
/**
  @license
  when.js - https://github.com/cujojs/when

  MIT License (c) copyright B Cavalier & J Hann

 * A lightweight CommonJS Promises/A and when() implementation
 * when is part of the cujo.js family of libraries (http://cujojs.com/)
 *
 * Licensed under the MIT License at:
 * http://www.opensource.org/licenses/mit-license.php
 *
 * @version 1.7.1
 */
function(e){"use strict";e("ThirdParty/when",[],(function(){var e,t;function r(e,t,r,o){return n(e).then(t,r,o)}function n(e){var t,r,s;return e instanceof o?t=e:u(e)?(r=a(),e.then((function(e){r.resolve(e)}),(function(e){r.reject(e)}),(function(e){r.progress(e)})),t=r.promise):(s=e,t=new o((function(e){try{return n(e?e(s):s)}catch(e){return i(e)}}))),t}function o(e){this.then=e}function i(e){return new o((function(t,r){try{return r?n(r(e)):i(e)}catch(e){return i(e)}}))}function a(){var e,t,r,u,s,c;return e=new o(f),t=[],r=[],u=function(e,n,o){var i,u;return i=a(),u="function"==typeof o?function(e){try{i.progress(o(e))}catch(e){i.progress(e)}}:function(e){i.progress(e)},t.push((function(t){t.then(e,n).then(i.resolve,i.reject,u)})),r.push(u),i.promise},s=function(e){return l(r,e),e},c=function(e){return e=n(e),u=e.then,c=n,s=h,l(t,e),r=t=void 0,e},{then:f,resolve:d,reject:p,progress:m,promise:e,resolver:{resolve:d,reject:p,progress:m}};function f(e,t,r){return u(e,t,r)}function d(e){return c(e)}function p(e){return c(i(e))}function m(e){return s(e)}}function u(e){return e&&"function"==typeof e.then}function s(e,t,n,o,i){return d(2,arguments),r(e,(function(e){var u,s,c,f,l,d,p,m,y,E;if(y=e.length>>>0,u=Math.max(0,Math.min(t,y)),c=[],s=y-u+1,f=[],l=a(),u)for(m=l.progress,p=function(e){f.push(e),--s||(d=p=h,l.reject(f))},d=function(e){c.push(e),--u||(d=p=h,l.resolve(c))},E=0;E<y;++E)E in e&&r(e[E],_,O,m);else l.resolve(c);return l.then(n,o,i);function O(e){p(e)}function _(e){d(e)}}))}function c(e,t,r,n){return d(1,arguments),f(e,p).then(t,r,n)}function f(e,t){return r(e,(function(e){var n,o,i,u,s,c;if(i=o=e.length>>>0,n=[],c=a(),i)for(u=function(e,o){r(e,t).then((function(e){n[o]=e,--i||c.resolve(n)}),c.reject)},s=0;s<o;s++)s in e?u(e[s],s):--i;else c.resolve(n);return c.promise}))}function l(e,t){for(var r,n=0;r=e[n++];)r(t)}function d(e,t){for(var r,n=t.length;n>e;)if(null!=(r=t[--n])&&"function"!=typeof r)throw new Error("arg "+n+" must be a function")}function h(){}function p(e){return e}return r.defer=a,r.resolve=n,r.reject=function(e){return r(e,i)},r.join=function(){return f(arguments,p)},r.all=c,r.map=f,r.reduce=function(n,o){var i=t.call(arguments,1);return r(n,(function(t){var n;return n=t.length,i[0]=function(e,t,i){return r(e,(function(e){return r(t,(function(t){return o(e,t,i,n)}))}))},e.apply(t,i)}))},r.any=function(e,t,r,n){return s(e,1,(function(e){return t?t(e[0]):e[0]}),r,n)},r.some=s,r.chain=function(e,t,n){var o=arguments.length>2;return r(e,(function(e){return e=o?n:e,t.resolve(e),e}),(function(e){return t.reject(e),i(e)}),t.progress)},r.isPromise=u,o.prototype={always:function(e,t){return this.then(e,e,t)},otherwise:function(e){return this.then(void 0,e)},yield:function(e){return this.then((function(){return e}))},spread:function(e){return this.then((function(t){return c(t,(function(t){return e.apply(void 0,t)}))}))}},t=[].slice,e=[].reduce||function(e){var t,r,n,o,i;if(i=0,o=(t=Object(this)).length>>>0,(r=arguments).length<=1)for(;;){if(i in t){n=t[i++];break}if(++i>=o)throw new TypeError}else n=r[1];for(;i<o;++i)i in t&&(n=e(n,t[i],i,t));return n},r}))}("function"==typeof define&&define.amd?define:function(e){"object"==typeof exports?module.exports=e():this.when=e()}),define("Core/binarySearch",["./Check"],(function(e){"use strict";return function(t,r,n){e.defined("array",t),e.defined("itemToFind",r),e.defined("comparator",n);for(var o,i,a=0,u=t.length-1;a<=u;)if((i=n(t[o=~~((a+u)/2)],r))<0)a=o+1;else{if(!(i>0))return o;u=o-1}return~(u+1)}})),define("Core/EarthOrientationParametersSample",[],(function(){"use strict";return function(e,t,r,n,o){this.xPoleWander=e,this.yPoleWander=t,this.xPoleOffset=r,this.yPoleOffset=n,this.ut1MinusUtc=o}})),
/**
@license
sprintf.js from the php.js project - https://github.com/kvz/phpjs
Directly from https://github.com/kvz/phpjs/blob/master/functions/strings/sprintf.js

php.js is copyright 2012 Kevin van Zonneveld.

Portions copyright Brett Zamir (http://brett-zamir.me), Kevin van Zonneveld
(http://kevin.vanzonneveld.net), Onno Marsman, Theriault, Michael White
(http://getsprink.com), Waldo Malqui Silva, Paulo Freitas, Jack, Jonas
Raoni Soares Silva (http://www.jsfromhell.com), Philip Peterson, Legaev
Andrey, Ates Goral (http://magnetiq.com), Alex, Ratheous, Martijn Wieringa,
Rafa? Kukawski (http://blog.kukawski.pl), lmeyrick
(https://sourceforge.net/projects/bcmath-js/), Nate, Philippe Baumann,
Enrique Gonzalez, Webtoolkit.info (http://www.webtoolkit.info/), Carlos R.
L. Rodrigues (http://www.jsfromhell.com), Ash Searle
(http://hexmen.com/blog/), Jani Hartikainen, travc, Ole Vrijenhoek,
Erkekjetter, Michael Grier, Rafa? Kukawski (http://kukawski.pl), Johnny
Mast (http://www.phpvrouwen.nl), T.Wild, d3x,
http://stackoverflow.com/questions/57803/how-to-convert-decimal-to-hex-in-javascript,
Rafa? Kukawski (http://blog.kukawski.pl/), stag019, pilus, WebDevHobo
(http://webdevhobo.blogspot.com/), marrtins, GeekFG
(http://geekfg.blogspot.com), Andrea Giammarchi
(http://webreflection.blogspot.com), Arpad Ray (mailto:arpad@php.net),
gorthaur, Paul Smith, Tim de Koning (http://www.kingsquare.nl), Joris, Oleg
Eremeev, Steve Hilder, majak, gettimeofday, KELAN, Josh Fraser
(http://onlineaspect.com/2007/06/08/auto-detect-a-time-zone-with-javascript/),
Marc Palau, Martin
(http://www.erlenwiese.de/), Breaking Par Consulting Inc
(http://www.breakingpar.com/bkp/home.nsf/0/87256B280015193F87256CFB006C45F7),
Chris, Mirek Slugen, saulius, Alfonso Jimenez
(http://www.alfonsojimenez.com), Diplom@t (http://difane.com/), felix,
Mailfaker (http://www.weedem.fr/), Tyler Akins (http://rumkin.com), Caio
Ariede (http://caioariede.com), Robin, Kankrelune
(http://www.webfaktory.info/), Karol Kowalski, Imgen Tata
(http://www.myipdf.com/), mdsjack (http://www.mdsjack.bo.it), Dreamer,
Felix Geisendoerfer (http://www.debuggable.com/felix), Lars Fischer, AJ,
David, Aman Gupta, Michael White, Public Domain
(http://www.json.org/json2.js), Steven Levithan
(http://blog.stevenlevithan.com), Sakimori, Pellentesque Malesuada,
Thunder.m, Dj (http://phpjs.org/functions/htmlentities:425#comment_134018),
Steve Clay, David James, Francois, class_exists, nobbler, T. Wild, Itsacon
(http://www.itsacon.net/), date, Ole Vrijenhoek (http://www.nervous.nl/),
Fox, Raphael (Ao RUDLER), Marco, noname, Mateusz "loonquawl" Zalega, Frank
Forte, Arno, ger, mktime, john (http://www.jd-tech.net), Nick Kolosov
(http://sammy.ru), marc andreu, Scott Cariss, Douglas Crockford
(http://javascript.crockford.com), madipta, Slawomir Kaniecki,
ReverseSyntax, Nathan, Alex Wilson, kenneth, Bayron Guevara, Adam Wallner
(http://web2.bitbaro.hu/), paulo kuong, jmweb, Lincoln Ramsay, djmix,
Pyerre, Jon Hohle, Thiago Mata (http://thiagomata.blog.com), lmeyrick
(https://sourceforge.net/projects/bcmath-js/this.), Linuxworld, duncan,
Gilbert, Sanjoy Roy, Shingo, sankai, Oskar Larsson H?gfeldt
(http://oskar-lh.name/), Denny Wardhana, 0m3r, Everlasto, Subhasis Deb,
josh, jd, Pier Paolo Ramon (http://www.mastersoup.com/), P, merabi, Soren
Hansen, Eugene Bulkin (http://doubleaw.com/), Der Simon
(http://innerdom.sourceforge.net/), echo is bad, Ozh, XoraX
(http://www.xorax.info), EdorFaus, JB, J A R, Marc Jansen, Francesco, LH,
Stoyan Kyosev (http://www.svest.org/), nord_ua, omid
(http://phpjs.org/functions/380:380#comment_137122), Brad Touesnard, MeEtc
(http://yass.meetcweb.com), Peter-Paul Koch
(http://www.quirksmode.org/js/beat.html), Olivier Louvignes
(http://mg-crea.com/), T0bsn, Tim Wiel, Bryan Elliott, Jalal Berrami,
Martin, JT, David Randall, Thomas Beaucourt (http://www.webapp.fr), taith,
vlado houba, Pierre-Luc Paour, Kristof Coomans (SCK-CEN Belgian Nucleair
Research Centre), Martin Pool, Kirk Strobeck, Rick Waldron, Brant Messenger
(http://www.brantmessenger.com/), Devan Penner-Woelk, Saulo Vallory, Wagner
B. Soares, Artur Tchernychev, Valentina De Rosa, Jason Wong
(http://carrot.org/), Christoph, Daniel Esteban, strftime, Mick@el, rezna,
Simon Willison (http://simonwillison.net), Anton Ongson, Gabriel Paderni,
Marco van Oort, penutbutterjelly, Philipp Lenssen, Bjorn Roesbeke
(http://www.bjornroesbeke.be/), Bug?, Eric Nagel, Tomasz Wesolowski,
Evertjan Garretsen, Bobby Drake, Blues (http://tech.bluesmoon.info/), Luke
Godfrey, Pul, uestla, Alan C, Ulrich, Rafal Kukawski, Yves Sucaet,
sowberry, Norman "zEh" Fuchs, hitwork, Zahlii, johnrembo, Nick Callen,
Steven Levithan (stevenlevithan.com), ejsanders, Scott Baker, Brian Tafoya
(http://www.premasolutions.com/), Philippe Jausions
(http://pear.php.net/user/jausions), Aidan Lister
(http://aidanlister.com/), Rob, e-mike, HKM, ChaosNo1, metjay, strcasecmp,
strcmp, Taras Bogach, jpfle, Alexander Ermolaev
(http://snippets.dzone.com/user/AlexanderErmolaev), DxGx, kilops, Orlando,
dptr1988, Le Torbi, James (http://www.james-bell.co.uk/), Pedro Tainha
(http://www.pedrotainha.com), James, Arnout Kazemier
(http://www.3rd-Eden.com), Chris McMacken, gabriel paderni, Yannoo,
FGFEmperor, baris ozdil, Tod Gentille, Greg Frazier, jakes, 3D-GRAF, Allan
Jensen (http://www.winternet.no), Howard Yeend, Benjamin Lupton, davook,
daniel airton wermann (http://wermann.com.br), Atli T¨®r, Maximusya, Ryan
W Tenney (http://ryan.10e.us), Alexander M Beedie, fearphage
(http://http/my.opera.com/fearphage/), Nathan Sepulveda, Victor, Matteo,
Billy, stensi, Cord, Manish, T.J. Leahy, Riddler
(http://www.frontierwebdev.com/), Rafa? Kukawski, FremyCompany, Matt
Bradley, Tim de Koning, Luis Salazar (http://www.freaky-media.com/), Diogo
Resende, Rival, Andrej Pavlovic, Garagoth, Le Torbi
(http://www.letorbi.de/), Dino, Josep Sanz (http://www.ws3.es/), rem,
Russell Walker (http://www.nbill.co.uk/), Jamie Beck
(http://www.terabit.ca/), setcookie, Michael, YUI Library:
http://developer.yahoo.com/yui/docs/YAHOO.util.DateLocale.html, Blues at
http://hacks.bluesmoon.info/strftime/strftime.js, Ben
(http://benblume.co.uk/), DtTvB
(http://dt.in.th/2008-09-16.string-length-in-bytes.html), Andreas, William,
meo, incidence, Cagri Ekin, Amirouche, Amir Habibi
(http://www.residence-mixte.com/), Luke Smith (http://lucassmith.name),
Kheang Hok Chin (http://www.distantia.ca/), Jay Klehr, Lorenzo Pisani,
Tony, Yen-Wei Liu, Greenseed, mk.keck, Leslie Hoare, dude, booeyOH, Ben
Bryan

Licensed under the MIT (MIT-LICENSE.txt) license.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL KEVIN VAN ZONNEVELD BE LIABLE FOR ANY CLAIM, DAMAGES
OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.
*/
define("ThirdParty/sprintf",[],(function(){return function(){var e=/%%|%(\d+\$)?([-+\'#0 ]*)(\*\d+\$|\*|\d+)?(\.(\*\d+\$|\*|\d+))?([scboxXuideEfFgG])/g,t=arguments,r=0,n=t[r++],o=function(e,t,r,n){r||(r=" ");var o=e.length>=t?"":Array(1+t-e.length>>>0).join(r);return n?e+o:o+e},i=function(e,t,r,n,i,a){var u=n-e.length;return u>0&&(e=r||!i?o(e,n,a,r):e.slice(0,t.length)+o("",u,"0",!0)+e.slice(t.length)),e},a=function(e,t,r,n,a,u,s){var c=e>>>0;return e=(r=r&&c&&{2:"0b",8:"0",16:"0x"}[t]||"")+o(c.toString(t),u||0,"0",!1),i(e,r,n,a,s)},u=function(e,t,r,n,o,a){return null!=n&&(e=e.slice(0,n)),i(e,"",t,r,o,a)},s=function(e,n,s,c,f,l,d){var h,p,m,y,E;if("%%"==e)return"%";for(var O=!1,_="",R=!1,T=!1,g=" ",w=s.length,A=0;s&&A<w;A++)switch(s.charAt(A)){case" ":_=" ";break;case"+":_="+";break;case"-":O=!0;break;case"'":g=s.charAt(A+1);break;case"0":R=!0;break;case"#":T=!0}if((c=c?"*"==c?+t[r++]:"*"==c.charAt(0)?+t[c.slice(1,-1)]:+c:0)<0&&(c=-c,O=!0),!isFinite(c))throw new Error("sprintf: (minimum-)width must be finite");switch(l=l?"*"==l?+t[r++]:"*"==l.charAt(0)?+t[l.slice(1,-1)]:+l:"fFeE".indexOf(d)>-1?6:"d"==d?0:void 0,E=n?t[n.slice(0,-1)]:t[r++],d){case"s":return u(String(E),O,c,l,R,g);case"c":return u(String.fromCharCode(+E),O,c,l,R);case"b":return a(E,2,T,O,c,l,R);case"o":return a(E,8,T,O,c,l,R);case"x":return a(E,16,T,O,c,l,R);case"X":return a(E,16,T,O,c,l,R).toUpperCase();case"u":return a(E,10,T,O,c,l,R);case"i":case"d":return h=+E||0,E=(p=(h=Math.round(h-h%1))<0?"-":_)+o(String(Math.abs(h)),l,"0",!1),i(E,p,O,c,R);case"e":case"E":case"f":case"F":case"g":case"G":return p=(h=+E)<0?"-":_,m=["toExponential","toFixed","toPrecision"]["efg".indexOf(d.toLowerCase())],y=["toString","toUpperCase"]["eEfFgG".indexOf(d)%2],E=p+Math.abs(h)[m](l),i(E,p,O,c,R)[y]();default:return e}};return n.replace(e,s)}})),define("Core/GregorianDate",[],(function(){"use strict";return function(e,t,r,n,o,i,a,u){this.year=e,this.month=t,this.day=r,this.hour=n,this.minute=o,this.second=i,this.millisecond=a,this.isLeapSecond=u}})),define("Core/isLeapYear",["./DeveloperError"],(function(e){"use strict";return function(t){if(null===t||isNaN(t))throw new e("year is required and must be a number.");return t%4==0&&t%100!=0||t%400==0}})),define("Core/LeapSecond",[],(function(){"use strict";return function(e,t){this.julianDate=e,this.offset=t}})),define("Core/TimeConstants",["./freezeObject"],(function(e){"use strict";return e({SECONDS_PER_MILLISECOND:.001,SECONDS_PER_MINUTE:60,MINUTES_PER_HOUR:60,HOURS_PER_DAY:24,SECONDS_PER_HOUR:3600,MINUTES_PER_DAY:1440,SECONDS_PER_DAY:86400,DAYS_PER_JULIAN_CENTURY:36525,PICOSECOND:1e-9,MODIFIED_JULIAN_DATE_DIFFERENCE:2400000.5})})),define("Core/TimeStandard",["./freezeObject"],(function(e){"use strict";return e({UTC:0,TAI:1})})),define("Core/JulianDate",["../ThirdParty/sprintf","./binarySearch","./defaultValue","./defined","./DeveloperError","./GregorianDate","./isLeapYear","./LeapSecond","./TimeConstants","./TimeStandard"],(function(e,t,r,n,o,i,a,u,s,c){"use strict";var f=new i,l=[31,28,31,30,31,30,31,31,30,31,30,31];function d(e,t){return v.compare(e.julianDate,t.julianDate)}var h=new u;function p(e){h.julianDate=e;var r=v.leapSeconds,n=t(r,h,d);n<0&&(n=~n),n>=r.length&&(n=r.length-1);var o=r[n].offset;n>0&&v.secondsDifference(r[n].julianDate,e)>o&&(o=r[--n].offset),v.addSeconds(e,o,e)}function m(e,r){h.julianDate=e;var n=v.leapSeconds,o=t(n,h,d);if(o<0&&(o=~o),0===o)return v.addSeconds(e,-n[0].offset,r);if(o>=n.length)return v.addSeconds(e,-n[o-1].offset,r);var i=v.secondsDifference(n[o].julianDate,e);return 0===i?v.addSeconds(e,-n[o].offset,r):i<=1?void 0:v.addSeconds(e,-n[--o].offset,r)}function y(e,t,r){var n=t/s.SECONDS_PER_DAY|0;return e+=n,(t-=s.SECONDS_PER_DAY*n)<0&&(e--,t+=s.SECONDS_PER_DAY),r.dayNumber=e,r.secondsOfDay=t,r}function E(e,t,r,n,o,i,a){var u=(t-14)/12|0,c=e+4800+u,f=(1461*c/4|0)+(367*(t-2-12*u)/12|0)-(3*((c+100)/100|0)/4|0)+r-32075;(n-=12)<0&&(n+=24);var l=i+(n*s.SECONDS_PER_HOUR+o*s.SECONDS_PER_MINUTE+a*s.SECONDS_PER_MILLISECOND);return l>=43200&&(f-=1),[f,l]}var O=/^(\d{4})$/,_=/^(\d{4})-(\d{2})$/,R=/^(\d{4})-?(\d{3})$/,T=/^(\d{4})-?W(\d{2})-?(\d{1})?$/,g=/^(\d{4})-?(\d{2})-?(\d{2})$/,w=/([Z+\-])?(\d{2})?:?(\d{2})?$/,A=/^(\d{2})(\.\d+)?/.source+w.source,b=/^(\d{2}):?(\d{2})(\.\d+)?/.source+w.source,C=/^(\d{2}):?(\d{2}):?(\d{2})(\.\d+)?/.source+w.source,S="Invalid ISO 8601 date.";function v(e,t,n){this.dayNumber=void 0,this.secondsOfDay=void 0,e=r(e,0),t=r(t,0),n=r(n,c.UTC);var o=0|e;y(o,t+=(e-o)*s.SECONDS_PER_DAY,this),n===c.UTC&&p(this)}v.fromGregorianDate=function(e,t){if(!(e instanceof i))throw new o("date must be a valid GregorianDate.");var r=E(e.year,e.month,e.day,e.hour,e.minute,e.second,e.millisecond);return n(t)?(y(r[0],r[1],t),p(t),t):new v(r[0],r[1],c.UTC)},v.fromDate=function(e,t){if(!(e instanceof Date)||isNaN(e.getTime()))throw new o("date must be a valid JavaScript Date.");var r=E(e.getUTCFullYear(),e.getUTCMonth()+1,e.getUTCDate(),e.getUTCHours(),e.getUTCMinutes(),e.getUTCSeconds(),e.getUTCMilliseconds());return n(t)?(y(r[0],r[1],t),p(t),t):new v(r[0],r[1],c.UTC)},v.fromIso8601=function(e,t){if("string"!=typeof e)throw new o(S);var r,i,u,s,f,d=(e=e.replace(",",".")).split("T"),h=1,m=1,w=0,I=0,N=0,M=0,x=d[0],P=d[1];if(!n(x))throw new o(S);if(null!==(d=x.match(g))){if((s=x.split("-").length-1)>0&&2!==s)throw new o(S);r=+d[1],h=+d[2],m=+d[3]}else if(null!==(d=x.match(_)))r=+d[1],h=+d[2];else if(null!==(d=x.match(O)))r=+d[1];else{var D;if(null!==(d=x.match(R))){if(r=+d[1],D=+d[2],u=a(r),D<1||u&&D>366||!u&&D>365)throw new o(S)}else{if(null===(d=x.match(T)))throw new o(S);r=+d[1];var F=+d[2],U=+d[3]||0;if((s=x.split("-").length-1)>0&&(!n(d[3])&&1!==s||n(d[3])&&2!==s))throw new o(S);D=7*F+U-new Date(Date.UTC(r,0,4)).getUTCDay()-3}(i=new Date(Date.UTC(r,0,1))).setUTCDate(D),h=i.getUTCMonth()+1,m=i.getUTCDate()}if(u=a(r),h<1||h>12||m<1||(2!==h||!u)&&m>l[h-1]||u&&2===h&&m>29)throw new o(S);if(n(P)){if(null!==(d=P.match(C))){if((s=P.split(":").length-1)>0&&2!==s&&3!==s)throw new o(S);w=+d[1],I=+d[2],N=+d[3],M=1e3*+(d[4]||0),f=5}else if(null!==(d=P.match(b))){if((s=P.split(":").length-1)>2)throw new o(S);w=+d[1],I=+d[2],N=60*+(d[3]||0),f=4}else{if(null===(d=P.match(A)))throw new o(S);w=+d[1],I=60*+(d[2]||0),f=3}if(I>=60||N>=61||w>24||24===w&&(I>0||N>0||M>0))throw new o(S);var L=d[f],q=+d[f+1],B=+(d[f+2]||0);switch(L){case"+":w-=q,I-=B;break;case"-":w+=q,I+=B;break;case"Z":break;default:I+=new Date(Date.UTC(r,h-1,m,w,I)).getTimezoneOffset()}}var j=60===N;for(j&&N--;I>=60;)I-=60,w++;for(;w>=24;)w-=24,m++;for(i=u&&2===h?29:l[h-1];m>i;)m-=i,++h>12&&(h-=12,r++),i=u&&2===h?29:l[h-1];for(;I<0;)I+=60,w--;for(;w<0;)w+=24,m--;for(;m<1;)--h<1&&(h+=12,r--),m+=i=u&&2===h?29:l[h-1];var z=E(r,h,m,w,I,N,M);return n(t)?(y(z[0],z[1],t),p(t)):t=new v(z[0],z[1],c.UTC),j&&v.addSeconds(t,1,t),t},v.now=function(e){return v.fromDate(new Date,e)};var I=new v(0,0,c.TAI);return v.toGregorianDate=function(e,t){if(!n(e))throw new o("julianDate is required.");var r=!1,a=m(e,I);n(a)||(v.addSeconds(e,-1,I),a=m(I,I),r=!0);var u=a.dayNumber,c=a.secondsOfDay;c>=43200&&(u+=1);var f=u+68569|0,l=4*f/146097|0,d=4e3*(1+(f=f-((146097*l+3)/4|0)|0))/1461001|0,h=80*(f=f-(1461*d/4|0)+31|0)/2447|0,p=f-(2447*h/80|0)|0,y=h+2-12*(f=h/11|0)|0,E=100*(l-49)+d+f|0,O=c/s.SECONDS_PER_HOUR|0,_=c-O*s.SECONDS_PER_HOUR,R=_/s.SECONDS_PER_MINUTE|0,T=0|(_-=R*s.SECONDS_PER_MINUTE),g=(_-T)/s.SECONDS_PER_MILLISECOND;return(O+=12)>23&&(O-=24),r&&(T+=1),n(t)?(t.year=E,t.month=y,t.day=p,t.hour=O,t.minute=R,t.second=T,t.millisecond=g,t.isLeapSecond=r,t):new i(E,y,p,O,R,T,g,r)},v.toDate=function(e){if(!n(e))throw new o("julianDate is required.");var t=v.toGregorianDate(e,f),r=t.second;return t.isLeapSecond&&(r-=1),new Date(Date.UTC(t.year,t.month-1,t.day,t.hour,t.minute,r,t.millisecond))},v.toIso8601=function(t,r){if(!n(t))throw new o("julianDate is required.");var i,a=v.toGregorianDate(t,f),u=a.year,s=a.month,c=a.day,l=a.hour,d=a.minute,h=a.second,p=a.millisecond;return 1e4===u&&1===s&&1===c&&0===l&&0===d&&0===h&&0===p&&(u=9999,s=12,c=31,l=24),n(r)||0===p?n(r)&&0!==r?(i=(.01*p).toFixed(r).replace(".","").slice(0,r),e("%04d-%02d-%02dT%02d:%02d:%02d.%sZ",u,s,c,l,d,h,i)):e("%04d-%02d-%02dT%02d:%02d:%02dZ",u,s,c,l,d,h):(i=(.01*p).toString().replace(".",""),e("%04d-%02d-%02dT%02d:%02d:%02d.%sZ",u,s,c,l,d,h,i))},v.clone=function(e,t){if(n(e))return n(t)?(t.dayNumber=e.dayNumber,t.secondsOfDay=e.secondsOfDay,t):new v(e.dayNumber,e.secondsOfDay,c.TAI)},v.compare=function(e,t){if(!n(e))throw new o("left is required.");if(!n(t))throw new o("right is required.");var r=e.dayNumber-t.dayNumber;return 0!==r?r:e.secondsOfDay-t.secondsOfDay},v.equals=function(e,t){return e===t||n(e)&&n(t)&&e.dayNumber===t.dayNumber&&e.secondsOfDay===t.secondsOfDay},v.equalsEpsilon=function(e,t,r){if(!n(r))throw new o("epsilon is required.");return e===t||n(e)&&n(t)&&Math.abs(v.secondsDifference(e,t))<=r},v.totalDays=function(e){if(!n(e))throw new o("julianDate is required.");return e.dayNumber+e.secondsOfDay/s.SECONDS_PER_DAY},v.secondsDifference=function(e,t){if(!n(e))throw new o("left is required.");if(!n(t))throw new o("right is required.");return(e.dayNumber-t.dayNumber)*s.SECONDS_PER_DAY+(e.secondsOfDay-t.secondsOfDay)},v.daysDifference=function(e,t){if(!n(e))throw new o("left is required.");if(!n(t))throw new o("right is required.");return e.dayNumber-t.dayNumber+(e.secondsOfDay-t.secondsOfDay)/s.SECONDS_PER_DAY},v.computeTaiMinusUtc=function(e){h.julianDate=e;var r=v.leapSeconds,n=t(r,h,d);return n<0&&(n=~n,--n<0&&(n=0)),r[n].offset},v.addSeconds=function(e,t,r){if(!n(e))throw new o("julianDate is required.");if(!n(t))throw new o("seconds is required.");if(!n(r))throw new o("result is required.");return y(e.dayNumber,e.secondsOfDay+t,r)},v.addMinutes=function(e,t,r){if(!n(e))throw new o("julianDate is required.");if(!n(t))throw new o("minutes is required.");if(!n(r))throw new o("result is required.");var i=e.secondsOfDay+t*s.SECONDS_PER_MINUTE;return y(e.dayNumber,i,r)},v.addHours=function(e,t,r){if(!n(e))throw new o("julianDate is required.");if(!n(t))throw new o("hours is required.");if(!n(r))throw new o("result is required.");var i=e.secondsOfDay+t*s.SECONDS_PER_HOUR;return y(e.dayNumber,i,r)},v.addDays=function(e,t,r){if(!n(e))throw new o("julianDate is required.");if(!n(t))throw new o("days is required.");if(!n(r))throw new o("result is required.");return y(e.dayNumber+t,e.secondsOfDay,r)},v.lessThan=function(e,t){return v.compare(e,t)<0},v.lessThanOrEquals=function(e,t){return v.compare(e,t)<=0},v.greaterThan=function(e,t){return v.compare(e,t)>0},v.greaterThanOrEquals=function(e,t){return v.compare(e,t)>=0},v.prototype.clone=function(e){return v.clone(this,e)},v.prototype.equals=function(e){return v.equals(this,e)},v.prototype.equalsEpsilon=function(e,t){return v.equalsEpsilon(this,e,t)},v.prototype.toString=function(){return v.toIso8601(this)},v.leapSeconds=[new u(new v(2441317,43210,c.TAI),10),new u(new v(2441499,43211,c.TAI),11),new u(new v(2441683,43212,c.TAI),12),new u(new v(2442048,43213,c.TAI),13),new u(new v(2442413,43214,c.TAI),14),new u(new v(2442778,43215,c.TAI),15),new u(new v(2443144,43216,c.TAI),16),new u(new v(2443509,43217,c.TAI),17),new u(new v(2443874,43218,c.TAI),18),new u(new v(2444239,43219,c.TAI),19),new u(new v(2444786,43220,c.TAI),20),new u(new v(2445151,43221,c.TAI),21),new u(new v(2445516,43222,c.TAI),22),new u(new v(2446247,43223,c.TAI),23),new u(new v(2447161,43224,c.TAI),24),new u(new v(2447892,43225,c.TAI),25),new u(new v(2448257,43226,c.TAI),26),new u(new v(2448804,43227,c.TAI),27),new u(new v(2449169,43228,c.TAI),28),new u(new v(2449534,43229,c.TAI),29),new u(new v(2450083,43230,c.TAI),30),new u(new v(2450630,43231,c.TAI),31),new u(new v(2451179,43232,c.TAI),32),new u(new v(2453736,43233,c.TAI),33),new u(new v(2454832,43234,c.TAI),34),new u(new v(2456109,43235,c.TAI),35),new u(new v(2457204,43236,c.TAI),36),new u(new v(2457754,43237,c.TAI),37)],v})),
/**
 * @license
 *
 * Grauw URI utilities
 *
 * See: http://hg.grauw.nl/grauw-lib/file/tip/src/uri.js
 *
 * @author Laurens Holst (http://www.grauw.nl/)
 *
 *   Copyright 2012 Laurens Holst
 *
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License.
 *
 */
define("ThirdParty/Uri",[],(function(){function e(r){if(r instanceof e)this.scheme=r.scheme,this.authority=r.authority,this.path=r.path,this.query=r.query,this.fragment=r.fragment;else if(r){var n=t.exec(r);this.scheme=n[1],this.authority=n[2],this.path=n[3],this.query=n[4],this.fragment=n[5]}}e.prototype.scheme=null,e.prototype.authority=null,e.prototype.path="",e.prototype.query=null,e.prototype.fragment=null;var t=new RegExp("^(?:([^:/?#]+):)?(?://([^/?#]*))?([^?#]*)(?:\\?([^#]*))?(?:#(.*))?$");e.prototype.getScheme=function(){return this.scheme},e.prototype.getAuthority=function(){return this.authority},e.prototype.getPath=function(){return this.path},e.prototype.getQuery=function(){return this.query},e.prototype.getFragment=function(){return this.fragment},e.prototype.isAbsolute=function(){return!!this.scheme&&!this.fragment},e.prototype.isSameDocumentAs=function(e){return e.scheme==this.scheme&&e.authority==this.authority&&e.path==this.path&&e.query==this.query},e.prototype.equals=function(e){return this.isSameDocumentAs(e)&&e.fragment==this.fragment},e.prototype.normalize=function(){this.removeDotSegments(),this.scheme&&(this.scheme=this.scheme.toLowerCase()),this.authority&&(this.authority=this.authority.replace(o,a).replace(r,i)),this.path&&(this.path=this.path.replace(r,i)),this.query&&(this.query=this.query.replace(r,i)),this.fragment&&(this.fragment=this.fragment.replace(r,i))};var r=/%[0-9a-z]{2}/gi,n=/[a-zA-Z0-9\-\._~]/,o=/(.*@)?([^@:]*)(:.*)?/;function i(e){var t=unescape(e);return n.test(t)?t:e.toUpperCase()}function a(e,t,r,n){return(t||"")+r.toLowerCase()+(n||"")}return e.prototype.resolve=function(t){var r=new e;return this.scheme?(r.scheme=this.scheme,r.authority=this.authority,r.path=this.path,r.query=this.query):(r.scheme=t.scheme,this.authority?(r.authority=this.authority,r.path=this.path,r.query=this.query):(r.authority=t.authority,""==this.path?(r.path=t.path,r.query=this.query||t.query):("/"==this.path.charAt(0)?(r.path=this.path,r.removeDotSegments()):(t.authority&&""==t.path?r.path="/"+this.path:r.path=t.path.substring(0,t.path.lastIndexOf("/")+1)+this.path,r.removeDotSegments()),r.query=this.query))),r.fragment=this.fragment,r},e.prototype.removeDotSegments=function(){var e,t=this.path.split("/"),r=[],n=""==t[0];for(n&&t.shift(),""==t[0]&&t.shift();t.length;)".."==(e=t.shift())?r.pop():"."!=e&&r.push(e);"."!=e&&".."!=e||r.push(""),n&&r.unshift(""),this.path=r.join("/")},e.prototype.toString=function(){var e="";return this.scheme&&(e+=this.scheme+":"),this.authority&&(e+="//"+this.authority),e+=this.path,this.query&&(e+="?"+this.query),this.fragment&&(e+="#"+this.fragment),e},e})),define("Core/appendForwardSlash",[],(function(){"use strict";return function(e){return 0!==e.length&&"/"===e[e.length-1]||(e+="/"),e}})),define("Core/clone",["./defaultValue"],(function(e){"use strict";return function t(r,n){if(null===r||"object"!=typeof r)return r;n=e(n,!1);var o=new r.constructor;for(var i in r)if(r.hasOwnProperty(i)){var a=r[i];n&&(a=t(a,n)),o[i]=a}return o}})),define("Core/combine",["./defaultValue","./defined"],(function(e,t){"use strict";return function r(n,o,i){i=e(i,!1);var a,u,s,c={},f=t(n),l=t(o);if(f)for(a in n)n.hasOwnProperty(a)&&(u=n[a],l&&i&&"object"==typeof u&&o.hasOwnProperty(a)?(s=o[a],c[a]="object"==typeof s?r(u,s,i):u):c[a]=u);if(l)for(a in o)o.hasOwnProperty(a)&&!c.hasOwnProperty(a)&&(s=o[a],c[a]=s);return c}})),define("Core/oneTimeWarning",["./defaultValue","./defined","./DeveloperError"],(function(e,t,r){"use strict";var n={};function o(o,i){if(!t(o))throw new r("identifier is required.");t(n[o])||(n[o]=!0,console.warn(e(i,o)))}return o.geometryOutlines="Entity geometry outlines are unsupported on terrain. Outlines will be disabled. To enable outlines, disable geometry terrain clamping by explicitly setting height to 0.",o.geometryZIndex="Entity geometry with zIndex are unsupported when height or extrudedHeight are defined.  zIndex will be ignored",o.geometryHeightReference="Entity corridor, ellipse, polygon or rectangle with heightReference must also have a defined height.  heightReference will be ignored",o.geometryExtrudedHeightReference="Entity corridor, ellipse, polygon or rectangle with extrudedHeightReference must also have a defined extrudedHeight.  extrudedHeightReference will be ignored",o})),define("Core/deprecationWarning",["./defined","./DeveloperError","./oneTimeWarning"],(function(e,t,r){"use strict";return function(n,o){if(!e(n)||!e(o))throw new t("identifier and message are required.");r(n,o)}})),define("Core/getAbsoluteUri",["../ThirdParty/Uri","./defaultValue","./defined","./DeveloperError"],(function(e,t,r,n){"use strict";function o(e,t){var r;return"undefined"!=typeof document&&(r=document),o._implementation(e,t,r)}return o._implementation=function(o,i,a){if(!r(o))throw new n("relative uri is required.");if(!r(i)){if(void 0===a)return o;i=t(a.baseURI,a.location.href)}var u=new e(i);return new e(o).resolve(u).toString()},o})),define("Core/getBaseUri",["../ThirdParty/Uri","./defined","./DeveloperError"],(function(e,t,r){"use strict";return function(n,o){if(!t(n))throw new r("uri is required.");var i="",a=n.lastIndexOf("/");return-1!==a&&(i=n.substring(0,a+1)),o?(n=new e(n),t(n.query)&&(i+="?"+n.query),t(n.fragment)&&(i+="#"+n.fragment),i):i}})),define("Core/getExtensionFromUri",["../ThirdParty/Uri","./defined","./DeveloperError"],(function(e,t,r){"use strict";return function(n){if(!t(n))throw new r("uri is required.");var o=new e(n);o.normalize();var i=o.path,a=i.lastIndexOf("/");return-1!==a&&(i=i.substr(a+1)),a=i.lastIndexOf("."),i=-1===a?"":i.substr(a+1)}})),define("Core/isBlobUri",["./Check"],(function(e){"use strict";var t=/^blob:/i;return function(r){return e.typeOf.string("uri",r),t.test(r)}})),define("Core/isCrossOriginUrl",["./defined"],(function(e){"use strict";var t;return function(r){e(t)||(t=document.createElement("a")),t.href=window.location.href;var n=t.host,o=t.protocol;return t.href=r,t.href=t.href,o!==t.protocol||n!==t.host}})),define("Core/isDataUri",["./Check"],(function(e){"use strict";var t=/^data:/i;return function(r){return e.typeOf.string("uri",r),t.test(r)}})),define("Core/loadAndExecuteScript",["../ThirdParty/when"],(function(e){"use strict";return function(t){var r=e.defer(),n=document.createElement("script");n.async=!0,n.src=t;var o=document.getElementsByTagName("head")[0];return n.onload=function(){n.onload=void 0,o.removeChild(n),r.resolve()},n.onerror=function(e){r.reject(e)},o.appendChild(n),r.promise}})),define("Core/isArray",["./defined"],(function(e){"use strict";var t=Array.isArray;return e(t)||(t=function(e){return"[object Array]"===Object.prototype.toString.call(e)}),t})),define("Core/objectToQuery",["./defined","./DeveloperError","./isArray"],(function(e,t,r){"use strict";return function(n){if(!e(n))throw new t("obj is required.");var o="";for(var i in n)if(n.hasOwnProperty(i)){var a=n[i],u=encodeURIComponent(i)+"=";if(r(a))for(var s=0,c=a.length;s<c;++s)o+=u+encodeURIComponent(a[s])+"&";else o+=u+encodeURIComponent(a)+"&"}return o=o.slice(0,-1)}})),define("Core/queryToObject",["./defined","./DeveloperError","./isArray"],(function(e,t,r){"use strict";return function(n){if(!e(n))throw new t("queryString is required.");var o={};if(""===n)return o;for(var i=n.replace(/\+/g,"%20").split(/[&;]/),a=0,u=i.length;a<u;++a){var s=i[a].split("="),c=decodeURIComponent(s[0]),f=s[1];f=e(f)?decodeURIComponent(f):"";var l=o[c];"string"==typeof l?o[c]=[l,f]:r(l)?l.push(f):o[c]=f}return o}})),define("Core/RequestState",["../Core/freezeObject"],(function(e){"use strict";return e({UNISSUED:0,ISSUED:1,ACTIVE:2,RECEIVED:3,CANCELLED:4,FAILED:5})})),define("Core/RequestType",["../Core/freezeObject"],(function(e){"use strict";return e({TERRAIN:0,IMAGERY:1,TILES3D:2,OTHER:3})})),define("Core/Request",["./defaultValue","./defined","./RequestState","./RequestType"],(function(e,t,r,n){"use strict";function o(t){t=e(t,e.EMPTY_OBJECT);var o=e(t.throttleByServer,!1),i=o||e(t.throttle,!1);this.url=t.url,this.requestFunction=t.requestFunction,this.cancelFunction=t.cancelFunction,this.priorityFunction=t.priorityFunction,this.priority=e(t.priority,0),this.throttle=i,this.throttleByServer=o,this.type=e(t.type,n.OTHER),this.serverKey=void 0,this.state=r.UNISSUED,this.deferred=void 0,this.cancelled=!1}return o.prototype.cancel=function(){this.cancelled=!0},o.prototype.clone=function(e){return t(e)?(e.url=this.url,e.requestFunction=this.requestFunction,e.cancelFunction=this.cancelFunction,e.priorityFunction=this.priorityFunction,e.priority=this.priority,e.throttle=this.throttle,e.throttleByServer=this.throttleByServer,e.type=this.type,e.serverKey=this.serverKey,e.state=this.RequestState.UNISSUED,e.deferred=void 0,e.cancelled=!1,e):new o(this)},o})),define("Core/parseResponseHeaders",[],(function(){"use strict";return function(e){var t={};if(!e)return t;for(var r=e.split("\r\n"),n=0;n<r.length;++n){var o=r[n],i=o.indexOf(": ");if(i>0){var a=o.substring(0,i),u=o.substring(i+2);t[a]=u}}return t}})),define("Core/RequestErrorEvent",["./defined","./parseResponseHeaders"],(function(e,t){"use strict";function r(e,r,n){this.statusCode=e,this.response=r,this.responseHeaders=n,"string"==typeof this.responseHeaders&&(this.responseHeaders=t(this.responseHeaders))}return r.prototype.toString=function(){var t="Request has failed.";return e(this.statusCode)&&(t+=" Status Code: "+this.statusCode),t},r})),define("Core/Event",["./Check","./defined","./defineProperties"],(function(e,t,r){"use strict";function n(){this._listeners=[],this._scopes=[],this._toRemove=[],this._insideRaiseEvent=!1}function o(e,t){return t-e}return r(n.prototype,{numberOfListeners:{get:function(){return this._listeners.length-this._toRemove.length}}}),n.prototype.addEventListener=function(t,r){e.typeOf.func("listener",t),this._listeners.push(t),this._scopes.push(r);var n=this;return function(){n.removeEventListener(t,r)}},n.prototype.removeEventListener=function(t,r){e.typeOf.func("listener",t);for(var n=this._listeners,o=this._scopes,i=-1,a=0;a<n.length;a++)if(n[a]===t&&o[a]===r){i=a;break}return-1!==i&&(this._insideRaiseEvent?(this._toRemove.push(i),n[i]=void 0,o[i]=void 0):(n.splice(i,1),o.splice(i,1)),!0)},n.prototype.raiseEvent=function(){var e;this._insideRaiseEvent=!0;var r=this._listeners,n=this._scopes,i=r.length;for(e=0;e<i;e++){var a=r[e];t(a)&&r[e].apply(n[e],arguments)}var u=this._toRemove;if((i=u.length)>0){for(u.sort(o),e=0;e<i;e++){var s=u[e];r.splice(s,1),n.splice(s,1)}u.length=0}this._insideRaiseEvent=!1},n})),define("Core/Heap",["./Check","./defaultValue","./defined","./defineProperties"],(function(e,t,r,n){"use strict";function o(t){e.typeOf.object("options",t),e.defined("options.comparator",t.comparator),this._comparator=t.comparator,this._array=[],this._length=0,this._maximumLength=void 0}function i(e,t,r){var n=e[t];e[t]=e[r],e[r]=n}return n(o.prototype,{length:{get:function(){return this._length}},internalArray:{get:function(){return this._array}},maximumLength:{get:function(){return this._maximumLength},set:function(e){this._maximumLength=e,this._length>e&&e>0&&(this._length=e,this._array.length=e)}},comparator:{get:function(){return this._comparator}}}),o.prototype.reserve=function(e){e=t(e,this._length),this._array.length=e},o.prototype.heapify=function(e){e=t(e,0);for(var r=this._length,n=this._comparator,o=this._array,a=-1,u=!0;u;){var s=2*(e+1),c=s-1;a=c<r&&n(o[c],o[e])<0?c:e,s<r&&n(o[s],o[a])<0&&(a=s),a!==e?(i(o,a,e),e=a):u=!1}},o.prototype.resort=function(){for(var e=this._length,t=Math.ceil(e/2);t>=0;--t)this.heapify(t)},o.prototype.insert=function(t){e.defined("element",t);var n,o=this._array,a=this._comparator,u=this._maximumLength,s=this._length++;for(s<o.length?o[s]=t:o.push(t);0!==s;){var c=Math.floor((s-1)/2);if(!(a(o[s],o[c])<0))break;i(o,s,c),s=c}return r(u)&&this._length>u&&(n=o[u],this._length=u),n},o.prototype.pop=function(r){if(r=t(r,0),0!==this._length){e.typeOf.number.lessThan("index",r,this._length);var n=this._array,o=n[r];return i(n,r,--this._length),this.heapify(r),o}},o})),define("Core/RequestScheduler",["../ThirdParty/Uri","../ThirdParty/when","./Check","./defaultValue","./defined","./defineProperties","./Event","./Heap","./isBlobUri","./isDataUri","./RequestState"],(function(e,t,r,n,o,i,a,u,s,c,f){"use strict";var l={numberOfAttemptedRequests:0,numberOfActiveRequests:0,numberOfCancelledRequests:0,numberOfCancelledActiveRequests:0,numberOfFailedRequests:0,numberOfActiveRequestsEver:0},d=20,h=new u({comparator:function(e,t){return e.priority-t.priority}});h.maximumLength=d,h.reserve(d);var p=[],m={},y="undefined"!=typeof document?new e(document.location.href):new e,E=new a;function O(){}function _(e){o(e.priorityFunction)&&(e.priority=e.priorityFunction())}function R(e){var t=n(O.requestsByServer[e],O.maximumRequestsPerServer);return m[e]<t}function T(e){return e.state===f.UNISSUED&&(e.state=f.ISSUED,e.deferred=t.defer()),e.deferred.promise}function g(e){var t=T(e);return e.state=f.ACTIVE,p.push(e),++l.numberOfActiveRequests,++l.numberOfActiveRequestsEver,++m[e.serverKey],e.requestFunction().then(function(e){return function(t){e.state!==f.CANCELLED&&(--l.numberOfActiveRequests,--m[e.serverKey],E.raiseEvent(),e.state=f.RECEIVED,e.deferred.resolve(t))}}(e)).otherwise(function(e){return function(t){e.state!==f.CANCELLED&&(++l.numberOfFailedRequests,--l.numberOfActiveRequests,--m[e.serverKey],E.raiseEvent(t),e.state=f.FAILED,e.deferred.reject(t))}}(e)),t}function w(e){var t=e.state===f.ACTIVE;e.state=f.CANCELLED,++l.numberOfCancelledRequests,e.deferred.reject(),t&&(--l.numberOfActiveRequests,--m[e.serverKey],++l.numberOfCancelledActiveRequests),o(e.cancelFunction)&&e.cancelFunction()}return O.maximumRequests=50,O.maximumRequestsPerServer=6,O.requestsByServer={"api.cesium.com:443":18,"assets.cesium.com:443":18},O.throttleRequests=!0,O.debugShowStatistics=!1,O.requestCompletedEvent=E,i(O,{statistics:{get:function(){return l}},priorityHeapLength:{get:function(){return d},set:function(e){if(e<d)for(;h.length>e;)w(h.pop());d=e,h.maximumLength=e,h.reserve(e)}}}),O.update=function(){var e,t,r=0,n=p.length;for(e=0;e<n;++e)(t=p[e]).cancelled&&w(t),t.state===f.ACTIVE?r>0&&(p[e-r]=t):++r;p.length-=r;var o=h.internalArray,i=h.length;for(e=0;e<i;++e)_(o[e]);h.resort();for(var a=Math.max(O.maximumRequests-p.length,0),u=0;u<a&&h.length>0;)(t=h.pop()).cancelled?w(t):!t.throttleByServer||R(t.serverKey)?(g(t),++u):w(t);O.debugShowStatistics&&(l.numberOfAttemptedRequests>0&&console.log("Number of attempted requests: "+l.numberOfAttemptedRequests),l.numberOfActiveRequests>0&&console.log("Number of active requests: "+l.numberOfActiveRequests),l.numberOfCancelledRequests>0&&console.log("Number of cancelled requests: "+l.numberOfCancelledRequests),l.numberOfCancelledActiveRequests>0&&console.log("Number of cancelled active requests: "+l.numberOfCancelledActiveRequests),l.numberOfFailedRequests>0&&console.log("Number of failed requests: "+l.numberOfFailedRequests),l.numberOfAttemptedRequests=0,l.numberOfCancelledRequests=0,l.numberOfCancelledActiveRequests=0)},O.getServerKey=function(t){r.typeOf.string("url",t);var n=new e(t).resolve(y);n.normalize();var i=n.authority;/:/.test(i)||(i=i+":"+("https"===n.scheme?"443":"80"));var a=m[i];return o(a)||(m[i]=0),i},O.request=function(e){if(r.typeOf.object("request",e),r.typeOf.string("request.url",e.url),r.typeOf.func("request.requestFunction",e.requestFunction),c(e.url)||s(e.url))return E.raiseEvent(),e.state=f.RECEIVED,e.requestFunction();if(++l.numberOfAttemptedRequests,o(e.serverKey)||(e.serverKey=O.getServerKey(e.url)),!O.throttleRequests||!e.throttle)return g(e);if(!(p.length>=O.maximumRequests)&&(!e.throttleByServer||R(e.serverKey))){_(e);var t=h.insert(e);if(o(t)){if(t===e)return;w(t)}return T(e)}},O.clearForSpecs=function(){for(;h.length>0;)w(h.pop());for(var e=p.length,t=0;t<e;++t)w(p[t]);p.length=0,m={},l.numberOfAttemptedRequests=0,l.numberOfActiveRequests=0,l.numberOfCancelledRequests=0,l.numberOfCancelledActiveRequests=0,l.numberOfFailedRequests=0,l.numberOfActiveRequestsEver=0},O.numberOfActiveRequestsByServer=function(e){return m[e]},O.requestHeap=h,O})),define("Core/TrustedServers",["../ThirdParty/Uri","./defined","./DeveloperError"],(function(e,t,r){"use strict";var n={},o={};return n.add=function(e,n){if(!t(e))throw new r("host is required.");if(!t(n)||n<=0)throw new r("port is required to be greater than 0.");var i=e.toLowerCase()+":"+n;t(o[i])||(o[i]=!0)},n.remove=function(e,n){if(!t(e))throw new r("host is required.");if(!t(n)||n<=0)throw new r("port is required to be greater than 0.");var i=e.toLowerCase()+":"+n;t(o[i])&&delete o[i]},n.contains=function(n){if(!t(n))throw new r("url is required.");var i=function(r){var n=new e(r);n.normalize();var o=n.getAuthority();if(t(o)){if(-1!==o.indexOf("@")){var i=o.split("@");o=i[1]}if(-1===o.indexOf(":")){var a=n.getScheme();if(t(a)||(a=(a=window.location.protocol).substring(0,a.length-1)),"http"===a)o+=":80";else{if("https"!==a)return;o+=":443"}}return o}}(n);return!(!t(i)||!t(o[i]))},n.clear=function(){o={}},n})),define("Core/Resource",["../ThirdParty/Uri","../ThirdParty/when","./appendForwardSlash","./Check","./clone","./combine","./defaultValue","./defined","./defineProperties","./deprecationWarning","./DeveloperError","./freezeObject","./getAbsoluteUri","./getBaseUri","./getExtensionFromUri","./isBlobUri","./isCrossOriginUrl","./isDataUri","./loadAndExecuteScript","./objectToQuery","./queryToObject","./Request","./RequestErrorEvent","./RequestScheduler","./RequestState","./RuntimeError","./TrustedServers"],(function(e,t,r,n,o,i,a,u,s,c,f,l,d,h,p,m,y,E,O,_,R,T,g,w,A,b,C){"use strict";var S=function(){try{var e=new XMLHttpRequest;return e.open("GET","#",!0),e.responseType="blob","blob"===e.responseType}catch(e){return!1}}();function v(e,t,r,n){var o,i=e.query;if(!u(i)||0===i.length)return{};if(-1===i.indexOf("=")){var a={};a[i]=void 0,o=a}else o=R(i);t._queryParameters=r?M(o,t._queryParameters,n):o,e.query=void 0}function I(e,t){return u(e)?u(e.clone)?e.clone():o(e):t}function N(e){if(e.state===A.ISSUED||e.state===A.ACTIVE)throw new b("The Resource is already being fetched.");e.state=A.UNISSUED,e.deferred=void 0}function M(e,t,r){if(!r)return i(e,t);var n=o(e,!0);for(var a in t)if(t.hasOwnProperty(a)){var s=n[a],c=t[a];u(s)?(Array.isArray(s)||(s=n[a]=[s]),n[a]=s.concat(c)):n[a]=Array.isArray(c)?c.slice():c}return n}function x(t){"string"==typeof(t=a(t,a.EMPTY_OBJECT))&&(t={url:t}),n.typeOf.string("options.url",t.url),this._url=void 0,this._templateValues=I(t.templateValues,{}),this._queryParameters=I(t.queryParameters,{}),this.headers=I(t.headers,{}),this.request=a(t.request,new T),this.proxy=t.proxy,this.retryCallback=t.retryCallback,this.retryAttempts=a(t.retryAttempts,0),this._retryCount=0;var r=new e(t.url);v(r,this,!0,!0),r.fragment=void 0,this._url=r.toString()}function P(e){var r=e.request;r.url=e.url,r.requestFunction=function(){var r=e.url,n=!1;e.isDataUri||e.isBlobUri||(n=e.isCrossOriginUrl);var o=t.defer();return x._Implementations.createImage(r,n,o),o.promise};var n=w.request(r);if(u(n))return n.otherwise((function(n){return r.state!==A.FAILED?t.reject(n):e.retryOnError(n).then((function(o){return o?(r.state=A.UNISSUED,r.deferred=void 0,P(e)):t.reject(n)}))}))}x.createIfNeeded=function(e){return e instanceof x?e.getDerivedResource({request:e.request}):"string"!=typeof e?e:new x({url:e})},s(x,{isBlobSupported:{get:function(){return S}}}),s(x.prototype,{queryParameters:{get:function(){return this._queryParameters}},templateValues:{get:function(){return this._templateValues}},url:{get:function(){return this.getUrlComponent(!0,!0)},set:function(t){var r=new e(t);v(r,this,!1),r.fragment=void 0,this._url=r.toString()}},extension:{get:function(){return p(this._url)}},isDataUri:{get:function(){return E(this._url)}},isBlobUri:{get:function(){return m(this._url)}},isCrossOriginUrl:{get:function(){return y(this._url)}},hasHeaders:{get:function(){return Object.keys(this.headers).length>0}}}),x.prototype.getUrlComponent=function(t,r){if(this.isDataUri)return this._url;var n=new e(this._url);t&&function(e,t){var r=t._queryParameters,n=Object.keys(r);1!==n.length||u(r[n[0]])?e.query=_(r):e.query=n[0]}(n,this);var o=n.toString().replace(/%7B/g,"{").replace(/%7D/g,"}"),i=this._templateValues,a=Object.keys(i);if(a.length>0)for(var s=0;s<a.length;s++){var c=a[s],f=i[c];o=o.replace(new RegExp("{"+c+"}","g"),encodeURIComponent(f))}return r&&u(this.proxy)&&(o=this.proxy.getURL(o)),o},x.prototype.setQueryParameters=function(e,t){this._queryParameters=t?M(this._queryParameters,e,!1):M(e,this._queryParameters,!1)},x.prototype.addQueryParameters=function(e,t){return c("Resource.addQueryParameters","addQueryParameters has been deprecated and will be removed 1.45. Use setQueryParameters or appendQueryParameters instead."),this.setQueryParameters(e,t)},x.prototype.appendQueryParameters=function(e){this._queryParameters=M(e,this._queryParameters,!0)},x.prototype.setTemplateValues=function(e,t){this._templateValues=t?i(this._templateValues,e):i(e,this._templateValues)},x.prototype.addTemplateValues=function(e,t){return c("Resource.addTemplateValues","addTemplateValues has been deprecated and will be removed 1.45. Use setTemplateValues."),this.setTemplateValues(e,t)},x.prototype.getDerivedResource=function(t){var r=this.clone();if(r._retryCount=0,u(t.url)){var n=new e(t.url);v(n,r,!0,a(t.preserveQueryParameters,!1)),n.fragment=void 0,r._url=n.resolve(new e(d(this._url))).toString()}return u(t.queryParameters)&&(r._queryParameters=i(t.queryParameters,r._queryParameters)),u(t.templateValues)&&(r._templateValues=i(t.templateValues,r.templateValues)),u(t.headers)&&(r.headers=i(t.headers,r.headers)),u(t.proxy)&&(r.proxy=t.proxy),u(t.request)&&(r.request=t.request),u(t.retryCallback)&&(r.retryCallback=t.retryCallback),u(t.retryAttempts)&&(r.retryAttempts=t.retryAttempts),r},x.prototype.retryOnError=function(e){var r=this.retryCallback;if("function"!=typeof r||this._retryCount>=this.retryAttempts)return t(!1);var n=this;return t(r(this,e)).then((function(e){return++n._retryCount,e}))},x.prototype.clone=function(e){return u(e)||(e=new x({url:this._url})),e._url=this._url,e._queryParameters=o(this._queryParameters),e._templateValues=o(this._templateValues),e.headers=o(this.headers),e.proxy=this.proxy,e.retryCallback=this.retryCallback,e.retryAttempts=this.retryAttempts,e._retryCount=0,e.request=this.request.clone(),e},x.prototype.getBaseUri=function(e){return h(this.getUrlComponent(e),e)},x.prototype.appendForwardSlash=function(){this._url=r(this._url)},x.prototype.fetchArrayBuffer=function(){return this.fetch({responseType:"arraybuffer"})},x.fetchArrayBuffer=function(e){return new x(e).fetchArrayBuffer()},x.prototype.fetchBlob=function(){return this.fetch({responseType:"blob"})},x.fetchBlob=function(e){return new x(e).fetchBlob()},x.prototype.fetchImage=function(e){if(e=a(e,!1),N(this.request),!S||this.isDataUri||this.isBlobUri||!this.hasHeaders&&!e)return P(this);var r,n,o=this.fetchBlob();return u(o)?o.then((function(e){if(u(e)){n=e;var t=window.URL.createObjectURL(e);return P(r=new x({url:t}))}})).then((function(e){if(u(e))return window.URL.revokeObjectURL(r.url),e.blob=n,e})).otherwise((function(e){return u(r)&&window.URL.revokeObjectURL(r.url),t.reject(e)})):void 0},x.fetchImage=function(e){return new x(e).fetchImage(e.preferBlob)},x.prototype.fetchText=function(){return this.fetch({responseType:"text"})},x.fetchText=function(e){return new x(e).fetchText()},x.prototype.fetchJson=function(){var e=this.fetch({responseType:"text",headers:{Accept:"application/json,*/*;q=0.01"}});if(u(e))return e.then((function(e){if(u(e))return JSON.parse(e)}))},x.fetchJson=function(e){return new x(e).fetchJson()},x.prototype.fetchXML=function(){return this.fetch({responseType:"document",overrideMimeType:"text/xml"})},x.fetchXML=function(e){return new x(e).fetchXML()},x.prototype.fetchJsonp=function(e){var r;e=a(e,"callback"),N(this.request);do{r="loadJsonp"+Math.random().toString().substring(2,8)}while(u(window[r]));return function e(r,n,o){var i={};i[n]=o,r.setQueryParameters(i);var a=r.request;a.url=r.url,a.requestFunction=function(){var e=t.defer();return window[o]=function(t){e.resolve(t);try{delete window[o]}catch(e){window[o]=void 0}},x._Implementations.loadAndExecuteScript(r.url,o,e),e.promise};var s=w.request(a);if(u(s))return s.otherwise((function(i){return a.state!==A.FAILED?t.reject(i):r.retryOnError(i).then((function(u){return u?(a.state=A.UNISSUED,a.deferred=void 0,e(r,n,o)):t.reject(i)}))}))}(this,e,r)},x.fetchJsonp=function(e){return new x(e).fetchJsonp(e.callbackParameterName)},x.prototype._makeRequest=function(e){var r=this;N(r.request);var n=r.request;n.url=r.url,n.requestFunction=function(){var o=e.responseType,a=i(e.headers,r.headers),s=e.overrideMimeType,c=e.method,f=e.data,l=t.defer(),d=x._Implementations.loadWithXhr(r.url,o,c,f,a,l,s);return u(d)&&u(d.abort)&&(n.cancelFunction=function(){d.abort()}),l.promise};var o=w.request(n);if(u(o))return o.then((function(e){return e})).otherwise((function(o){return n.state!==A.FAILED?t.reject(o):r.retryOnError(o).then((function(i){return i?(n.state=A.UNISSUED,n.deferred=void 0,r.fetch(e)):t.reject(o)}))}))};var D=/^data:(.*?)(;base64)?,(.*)$/;function F(e,t){var r=decodeURIComponent(t);return e?atob(r):r}function U(e,t){for(var r=F(e,t),n=new ArrayBuffer(r.length),o=new Uint8Array(n),i=0;i<r.length;i++)o[i]=r.charCodeAt(i);return n}function L(e,t){switch(t){case"text":return e.toString("utf8");case"json":return JSON.parse(e.toString("utf8"));default:return new Uint8Array(e).buffer}}x.prototype.fetch=function(e){return(e=I(e,{})).method="GET",this._makeRequest(e)},x.fetch=function(e){return new x(e).fetch({responseType:e.responseType,overrideMimeType:e.overrideMimeType})},x.prototype.delete=function(e){return(e=I(e,{})).method="DELETE",this._makeRequest(e)},x.delete=function(e){return new x(e).delete({responseType:e.responseType,overrideMimeType:e.overrideMimeType,data:e.data})},x.prototype.head=function(e){return(e=I(e,{})).method="HEAD",this._makeRequest(e)},x.head=function(e){return new x(e).head({responseType:e.responseType,overrideMimeType:e.overrideMimeType})},x.prototype.options=function(e){return(e=I(e,{})).method="OPTIONS",this._makeRequest(e)},x.options=function(e){return new x(e).options({responseType:e.responseType,overrideMimeType:e.overrideMimeType})},x.prototype.post=function(e,t){return n.defined("data",e),(t=I(t,{})).method="POST",t.data=e,this._makeRequest(t)},x.post=function(e){return new x(e).post(e.data,{responseType:e.responseType,overrideMimeType:e.overrideMimeType})},x.prototype.put=function(e,t){return n.defined("data",e),(t=I(t,{})).method="PUT",t.data=e,this._makeRequest(t)},x.put=function(e){return new x(e).put(e.data,{responseType:e.responseType,overrideMimeType:e.overrideMimeType})},x.prototype.patch=function(e,t){return n.defined("data",e),(t=I(t,{})).method="PATCH",t.data=e,this._makeRequest(t)},x.patch=function(e){return new x(e).patch(e.data,{responseType:e.responseType,overrideMimeType:e.overrideMimeType})},x._Implementations={},x._Implementations.createImage=function(e,t,r){var n=new Image;n.onload=function(){r.resolve(n)},n.onerror=function(e){r.reject(e)},t&&(C.contains(e)?n.crossOrigin="use-credentials":n.crossOrigin=""),n.src=e};var q="undefined"==typeof XMLHttpRequest;return x._Implementations.loadWithXhr=function(e,t,r,n,o,i,s){var c=D.exec(e);if(null===c){if(!q){var l=new XMLHttpRequest;if(C.contains(e)&&(l.withCredentials=!0),l.open(r,e,!0),u(s)&&u(l.overrideMimeType)&&l.overrideMimeType(s),u(o))for(var d in o)o.hasOwnProperty(d)&&l.setRequestHeader(d,o[d]);u(t)&&(l.responseType=t);var h=!1;return"string"==typeof e&&(h=0===e.indexOf("file://")||"undefined"!=typeof window&&"file://"===window.location.origin),l.onload=function(){if(!(l.status<200||l.status>=300)||h&&0===l.status){var e=l.response,n=l.responseType;if("HEAD"===r||"OPTIONS"===r){var o=l.getAllResponseHeaders().trim().split(/[\r\n]+/),a={};return o.forEach((function(e){var t=e.split(": "),r=t.shift();a[r]=t.join(": ")})),void i.resolve(a)}if(204===l.status)i.resolve();else if(!u(e)||u(t)&&n!==t)if("json"===t&&"string"==typeof e)try{i.resolve(JSON.parse(e))}catch(e){i.reject(e)}else(""===n||"document"===n)&&u(l.responseXML)&&l.responseXML.hasChildNodes()?i.resolve(l.responseXML):""!==n&&"text"!==n||!u(l.responseText)?i.reject(new b("Invalid XMLHttpRequest response type.")):i.resolve(l.responseText);else i.resolve(e)}else i.reject(new g(l.status,l.response,l.getAllResponseHeaders()))},l.onerror=function(e){i.reject(new g)},l.send(n),l}!function(e,t,r,n,o,i,a){var u=require("url").parse(e),s="https:"===u.protocol?require("https"):require("http"),c=require("zlib"),f={protocol:u.protocol,hostname:u.hostname,port:u.port,path:u.path,query:u.query,method:r,headers:o};s.request(f).on("response",(function(e){if(e.statusCode<200||e.statusCode>=300)i.reject(new g(e.statusCode,e,e.headers));else{var r=[];e.on("data",(function(e){r.push(e)})),e.on("end",(function(){var n=Buffer.concat(r);"gzip"===e.headers["content-encoding"]?c.gunzip(n,(function(e,r){e?i.reject(new b("Error decompressing response.")):i.resolve(L(r,t))})):i.resolve(L(n,t))}))}})).on("error",(function(e){i.reject(new g)})).end()}(e,t,r,0,o,i)}else i.resolve(function(e,t){t=a(t,"");var r=e[1],n=!!e[2],o=e[3];switch(t){case"":case"text":return F(n,o);case"arraybuffer":return U(n,o);case"blob":var i=U(n,o);return new Blob([i],{type:r});case"document":return(new DOMParser).parseFromString(F(n,o),r);case"json":return JSON.parse(F(n,o));default:throw new f("Unhandled responseType: "+t)}}(c,t))},x._Implementations.loadAndExecuteScript=function(e,t,r){return O(e,t).otherwise(r.reject)},x._DefaultImplementations={},x._DefaultImplementations.createImage=x._Implementations.createImage,x._DefaultImplementations.loadWithXhr=x._Implementations.loadWithXhr,x._DefaultImplementations.loadAndExecuteScript=x._Implementations.loadAndExecuteScript,x.DEFAULT=l(new x({url:"undefined"==typeof document?"":document.location.href.split("?")[0]})),x})),define("Core/EarthOrientationParameters",["../ThirdParty/when","./binarySearch","./defaultValue","./defined","./EarthOrientationParametersSample","./freezeObject","./JulianDate","./LeapSecond","./Resource","./RuntimeError","./TimeConstants","./TimeStandard"],(function(e,t,r,n,o,i,a,u,s,c,f,l){"use strict";function d(t){if(t=r(t,r.EMPTY_OBJECT),this._dates=void 0,this._samples=void 0,this._dateColumn=-1,this._xPoleWanderRadiansColumn=-1,this._yPoleWanderRadiansColumn=-1,this._ut1MinusUtcSecondsColumn=-1,this._xCelestialPoleOffsetRadiansColumn=-1,this._yCelestialPoleOffsetRadiansColumn=-1,this._taiMinusUtcSecondsColumn=-1,this._columnCount=0,this._lastIndex=-1,this._downloadPromise=void 0,this._dataError=void 0,this._addNewLeapSeconds=r(t.addNewLeapSeconds,!0),n(t.data))p(this,t.data);else if(n(t.url)){var o=s.createIfNeeded(t.url),i=this;this._downloadPromise=e(o.fetchJson(),(function(e){p(i,e)}),(function(){i._dataError="An error occurred while retrieving the EOP data from the URL "+o.url+"."}))}else p(this,{columnNames:["dateIso8601","modifiedJulianDateUtc","xPoleWanderRadians","yPoleWanderRadians","ut1MinusUtcSeconds","lengthOfDayCorrectionSeconds","xCelestialPoleOffsetRadians","yCelestialPoleOffsetRadians","taiMinusUtcSeconds"],samples:[]})}function h(e,t){return a.compare(e.julianDate,t)}function p(e,r){if(n(r.columnNames))if(n(r.samples)){var o=r.columnNames.indexOf("modifiedJulianDateUtc"),i=r.columnNames.indexOf("xPoleWanderRadians"),s=r.columnNames.indexOf("yPoleWanderRadians"),c=r.columnNames.indexOf("ut1MinusUtcSeconds"),d=r.columnNames.indexOf("xCelestialPoleOffsetRadians"),p=r.columnNames.indexOf("yCelestialPoleOffsetRadians"),m=r.columnNames.indexOf("taiMinusUtcSeconds");if(o<0||i<0||s<0||c<0||d<0||p<0||m<0)e._dataError="Error in loaded EOP data: The columnNames property must include modifiedJulianDateUtc, xPoleWanderRadians, yPoleWanderRadians, ut1MinusUtcSeconds, xCelestialPoleOffsetRadians, yCelestialPoleOffsetRadians, and taiMinusUtcSeconds columns";else{var y,E=e._samples=r.samples,O=e._dates=[];e._dateColumn=o,e._xPoleWanderRadiansColumn=i,e._yPoleWanderRadiansColumn=s,e._ut1MinusUtcSecondsColumn=c,e._xCelestialPoleOffsetRadiansColumn=d,e._yCelestialPoleOffsetRadiansColumn=p,e._taiMinusUtcSecondsColumn=m,e._columnCount=r.columnNames.length,e._lastIndex=void 0;for(var _=e._addNewLeapSeconds,R=0,T=E.length;R<T;R+=e._columnCount){var g=E[R+o],w=E[R+m],A=g+f.MODIFIED_JULIAN_DATE_DIFFERENCE,b=new a(A,w,l.TAI);if(O.push(b),_){if(w!==y&&n(y)){var C=a.leapSeconds,S=t(C,b,h);if(S<0){var v=new u(b,w);C.splice(~S,0,v)}}y=w}}}}else e._dataError="Error in loaded EOP data: The samples property is required.";else e._dataError="Error in loaded EOP data: The columnNames property is required."}function m(e,t,r,n,o){var i=r*n;o.xPoleWander=t[i+e._xPoleWanderRadiansColumn],o.yPoleWander=t[i+e._yPoleWanderRadiansColumn],o.xPoleOffset=t[i+e._xCelestialPoleOffsetRadiansColumn],o.yPoleOffset=t[i+e._yCelestialPoleOffsetRadiansColumn],o.ut1MinusUtc=t[i+e._ut1MinusUtcSecondsColumn]}function y(e,t,r){return t+e*(r-t)}function E(e,t,r,n,o,i,u){var s=e._columnCount;if(i>t.length-1)return u.xPoleWander=0,u.yPoleWander=0,u.xPoleOffset=0,u.yPoleOffset=0,u.ut1MinusUtc=0,u;var c=t[o],f=t[i];if(c.equals(f)||n.equals(c))return m(e,r,o,s,u),u;if(n.equals(f))return m(e,r,i,s,u),u;var l=a.secondsDifference(n,c)/a.secondsDifference(f,c),d=o*s,h=i*s,p=r[d+e._ut1MinusUtcSecondsColumn],E=r[h+e._ut1MinusUtcSecondsColumn],O=E-p;if(O>.5||O<-.5){var _=r[d+e._taiMinusUtcSecondsColumn],R=r[h+e._taiMinusUtcSecondsColumn];_!==R&&(f.equals(n)?p=E:E-=R-_)}return u.xPoleWander=y(l,r[d+e._xPoleWanderRadiansColumn],r[h+e._xPoleWanderRadiansColumn]),u.yPoleWander=y(l,r[d+e._yPoleWanderRadiansColumn],r[h+e._yPoleWanderRadiansColumn]),u.xPoleOffset=y(l,r[d+e._xCelestialPoleOffsetRadiansColumn],r[h+e._xCelestialPoleOffsetRadiansColumn]),u.yPoleOffset=y(l,r[d+e._yCelestialPoleOffsetRadiansColumn],r[h+e._yCelestialPoleOffsetRadiansColumn]),u.ut1MinusUtc=y(l,p,E),u}return d.NONE=i({getPromiseToLoad:function(){return e()},compute:function(e,t){return n(t)?(t.xPoleWander=0,t.yPoleWander=0,t.xPoleOffset=0,t.yPoleOffset=0,t.ut1MinusUtc=0):t=new o(0,0,0,0,0),t}}),d.prototype.getPromiseToLoad=function(){return e(this._downloadPromise)},d.prototype.compute=function(e,r){if(n(this._samples)){if(n(r)||(r=new o(0,0,0,0,0)),0===this._samples.length)return r.xPoleWander=0,r.yPoleWander=0,r.xPoleOffset=0,r.yPoleOffset=0,r.ut1MinusUtc=0,r;var i=this._dates,u=this._lastIndex,s=0,f=0;if(n(u)){var l=i[u],d=i[u+1],h=a.lessThanOrEquals(l,e),p=!n(d),m=p||a.greaterThanOrEquals(d,e);if(h&&m)return s=u,!p&&d.equals(e)&&++s,f=s+1,E(this,i,this._samples,e,s,f,r),r}var y=t(i,e,a.compare,this._dateColumn);return y>=0?(y<i.length-1&&i[y+1].equals(e)&&++y,s=y,f=y):(s=(f=~y)-1)<0&&(s=0),this._lastIndex=s,E(this,i,this._samples,e,s,f,r),r}if(n(this._dataError))throw new c(this._dataError)},d})),define("Core/HeadingPitchRoll",["./defaultValue","./defined","./DeveloperError","./Math"],(function(e,t,r,n){"use strict";function o(t,r,n){this.heading=e(t,0),this.pitch=e(r,0),this.roll=e(n,0)}return o.fromQuaternion=function(e,n){if(!t(e))throw new r("quaternion is required");t(n)||(n=new o);var i=2*(e.w*e.y-e.z*e.x),a=1-2*(e.x*e.x+e.y*e.y),u=2*(e.w*e.x+e.y*e.z),s=1-2*(e.y*e.y+e.z*e.z),c=2*(e.w*e.z+e.x*e.y);return n.heading=-Math.atan2(c,s),n.roll=Math.atan2(u,a),n.pitch=-Math.asin(i),n},o.fromDegrees=function(e,i,a,u){if(!t(e))throw new r("heading is required");if(!t(i))throw new r("pitch is required");if(!t(a))throw new r("roll is required");return t(u)||(u=new o),u.heading=e*n.RADIANS_PER_DEGREE,u.pitch=i*n.RADIANS_PER_DEGREE,u.roll=a*n.RADIANS_PER_DEGREE,u},o.clone=function(e,r){if(t(e))return t(r)?(r.heading=e.heading,r.pitch=e.pitch,r.roll=e.roll,r):new o(e.heading,e.pitch,e.roll)},o.equals=function(e,r){return e===r||t(e)&&t(r)&&e.heading===r.heading&&e.pitch===r.pitch&&e.roll===r.roll},o.equalsEpsilon=function(e,r,o,i){return e===r||t(e)&&t(r)&&n.equalsEpsilon(e.heading,r.heading,o,i)&&n.equalsEpsilon(e.pitch,r.pitch,o,i)&&n.equalsEpsilon(e.roll,r.roll,o,i)},o.prototype.clone=function(e){return o.clone(this,e)},o.prototype.equals=function(e){return o.equals(this,e)},o.prototype.equalsEpsilon=function(e,t,r){return o.equalsEpsilon(this,e,t,r)},o.prototype.toString=function(){return"("+this.heading+", "+this.pitch+", "+this.roll+")"},o})),define("Core/buildModuleUrl",["./defined","./DeveloperError","./getAbsoluteUri","./Resource","require"],(function(e,t,r,n,o){"use strict";var i,a,u,s=/((?:.*\/)|^)cesium[\w-]*\.js(?:\W|$)/i;function c(t){return"undefined"==typeof document?t:(e(i)||(i=document.createElement("a")),i.href=t,i.href=i.href,i.href)}function f(){if(e(a))return a;var i;if(i="undefined"!=typeof CESIUM_BASE_URL?CESIUM_BASE_URL:e(define.amd)&&!define.amd.toUrlUndefined&&e(o.toUrl)?r("..",h("Core/buildModuleUrl.js")):function(){for(var e=document.getElementsByTagName("script"),t=0,r=e.length;t<r;++t){var n=e[t].getAttribute("src"),o=s.exec(n);if(null!==o)return o[1]}}(),!e(i))throw new t("Unable to determine Cesium base URL automatically, try defining a global variable called CESIUM_BASE_URL.");return(a=new n({url:c(i)})).appendForwardSlash(),a}function l(e){return c(o.toUrl("../"+e))}function d(e){return f().getDerivedResource({url:e}).url}function h(t){return e(u)||(u=e(define.amd)&&!define.amd.toUrlUndefined&&e(o.toUrl)?l:d),u(t)}return h._cesiumScriptRegex=s,h._buildModuleUrlFromBaseUrl=d,h._clearBaseResource=function(){a=void 0},h.setBaseUrl=function(e){a=n.DEFAULT.getDerivedResource({url:e})},h.getCesiumBaseUrl=f,h})),define("Core/Iau2006XysSample",[],(function(){"use strict";return function(e,t,r){this.x=e,this.y=t,this.s=r}})),define("Core/Iau2006XysData",["../ThirdParty/when","./buildModuleUrl","./defaultValue","./defined","./Iau2006XysSample","./JulianDate","./Resource","./TimeStandard"],(function(e,t,r,n,o,i,a,u){"use strict";function s(e){e=r(e,r.EMPTY_OBJECT),this._xysFileUrlTemplate=a.createIfNeeded(e.xysFileUrlTemplate),this._interpolationOrder=r(e.interpolationOrder,9),this._sampleZeroJulianEphemerisDate=r(e.sampleZeroJulianEphemerisDate,2442396.5),this._sampleZeroDateTT=new i(this._sampleZeroJulianEphemerisDate,0,u.TAI),this._stepSizeDays=r(e.stepSizeDays,1),this._samplesPerXysFile=r(e.samplesPerXysFile,1e3),this._totalSamples=r(e.totalSamples,27426),this._samples=new Array(3*this._totalSamples),this._chunkDownloadsInProgress=[];for(var t=this._interpolationOrder,n=this._denominators=new Array(t+1),o=this._xTable=new Array(t+1),s=Math.pow(this._stepSizeDays,t),c=0;c<=t;++c){n[c]=s,o[c]=c*this._stepSizeDays;for(var f=0;f<=t;++f)f!==c&&(n[c]*=c-f);n[c]=1/n[c]}this._work=new Array(t+1),this._coef=new Array(t+1)}var c=new i(0,0,u.TAI);function f(e,t,r){var n=c;return n.dayNumber=t,n.secondsOfDay=r,i.daysDifference(n,e._sampleZeroDateTT)}function l(r,o){if(r._chunkDownloadsInProgress[o])return r._chunkDownloadsInProgress[o];var i,u=e.defer();r._chunkDownloadsInProgress[o]=u;var s=r._xysFileUrlTemplate;return i=n(s)?s.getDerivedResource({templateValues:{0:o}}):new a({url:t("Assets/IAU2006_XYS/IAU2006_XYS_"+o+".json")}),e(i.fetchJson(),(function(e){r._chunkDownloadsInProgress[o]=!1;for(var t=r._samples,n=e.samples,i=o*r._samplesPerXysFile*3,a=0,s=n.length;a<s;++a)t[i+a]=n[a];u.resolve()})),u.promise}return s.prototype.preload=function(t,r,n,o){var i=f(this,t,r),a=f(this,n,o),u=i/this._stepSizeDays-this._interpolationOrder/2|0;u<0&&(u=0);var s=a/this._stepSizeDays-this._interpolationOrder/2|0+this._interpolationOrder;s>=this._totalSamples&&(s=this._totalSamples-1);for(var c=u/this._samplesPerXysFile|0,d=s/this._samplesPerXysFile|0,h=[],p=c;p<=d;++p)h.push(l(this,p));return e.all(h)},s.prototype.computeXysRadians=function(e,t,r){var i=f(this,e,t);if(!(i<0)){var a=i/this._stepSizeDays|0;if(!(a>=this._totalSamples)){var u=this._interpolationOrder,s=a-(u/2|0);s<0&&(s=0);var c=s+u;c>=this._totalSamples&&(s=(c=this._totalSamples-1)-u)<0&&(s=0);var d=!1,h=this._samples;if(n(h[3*s])||(l(this,s/this._samplesPerXysFile|0),d=!0),n(h[3*c])||(l(this,c/this._samplesPerXysFile|0),d=!0),!d){n(r)?(r.x=0,r.y=0,r.s=0):r=new o(0,0,0);var p,m,y=i-s*this._stepSizeDays,E=this._work,O=this._denominators,_=this._coef,R=this._xTable;for(p=0;p<=u;++p)E[p]=y-R[p];for(p=0;p<=u;++p){for(_[p]=1,m=0;m<=u;++m)m!==p&&(_[p]*=E[m]);_[p]*=O[p];var T=3*(s+p);r.x+=_[p]*h[T++],r.y+=_[p]*h[T++],r.s+=_[p]*h[T]}return r}}}},s})),define("Core/Quaternion",["./Cartesian3","./Check","./defaultValue","./defined","./FeatureDetection","./freezeObject","./Math","./Matrix3"],(function(e,t,r,n,o,i,a,u){"use strict";function s(e,t,n,o){this.x=r(e,0),this.y=r(t,0),this.z=r(n,0),this.w=r(o,0)}var c=new e;s.fromAxisAngle=function(r,o,i){t.typeOf.object("axis",r),t.typeOf.number("angle",o);var a=o/2,u=Math.sin(a),f=(c=e.normalize(r,c)).x*u,l=c.y*u,d=c.z*u,h=Math.cos(a);return n(i)?(i.x=f,i.y=l,i.z=d,i.w=h,i):new s(f,l,d,h)};var f=[1,2,0],l=new Array(3);s.fromRotationMatrix=function(e,r){var o,i,a,c,d;t.typeOf.object("matrix",e);var h=e[u.COLUMN0ROW0],p=e[u.COLUMN1ROW1],m=e[u.COLUMN2ROW2],y=h+p+m;if(y>0)d=.5*(o=Math.sqrt(y+1)),o=.5/o,i=(e[u.COLUMN1ROW2]-e[u.COLUMN2ROW1])*o,a=(e[u.COLUMN2ROW0]-e[u.COLUMN0ROW2])*o,c=(e[u.COLUMN0ROW1]-e[u.COLUMN1ROW0])*o;else{var E=0;p>h&&(E=1),m>h&&m>p&&(E=2);var O=f[E],_=f[O];o=Math.sqrt(e[u.getElementIndex(E,E)]-e[u.getElementIndex(O,O)]-e[u.getElementIndex(_,_)]+1);var R=l;R[E]=.5*o,o=.5/o,d=(e[u.getElementIndex(_,O)]-e[u.getElementIndex(O,_)])*o,R[O]=(e[u.getElementIndex(O,E)]+e[u.getElementIndex(E,O)])*o,R[_]=(e[u.getElementIndex(_,E)]+e[u.getElementIndex(E,_)])*o,i=-R[0],a=-R[1],c=-R[2]}return n(r)?(r.x=i,r.y=a,r.z=c,r.w=d,r):new s(i,a,c,d)};var d=new s,h=new s,p=new s,m=new s;s.fromHeadingPitchRoll=function(r,n){return t.typeOf.object("headingPitchRoll",r),m=s.fromAxisAngle(e.UNIT_X,r.roll,d),p=s.fromAxisAngle(e.UNIT_Y,-r.pitch,n),n=s.multiply(p,m,p),h=s.fromAxisAngle(e.UNIT_Z,-r.heading,d),s.multiply(h,n,n)};var y=new e,E=new e,O=new s,_=new s,R=new s;s.packedLength=4,s.pack=function(e,n,o){return t.typeOf.object("value",e),t.defined("array",n),o=r(o,0),n[o++]=e.x,n[o++]=e.y,n[o++]=e.z,n[o]=e.w,n},s.unpack=function(e,o,i){return t.defined("array",e),o=r(o,0),n(i)||(i=new s),i.x=e[o],i.y=e[o+1],i.z=e[o+2],i.w=e[o+3],i},s.packedInterpolationLength=3,s.convertPackedArrayForInterpolation=function(e,t,r,n){s.unpack(e,4*r,R),s.conjugate(R,R);for(var o=0,i=r-t+1;o<i;o++){var a=3*o;s.unpack(e,4*(t+o),O),s.multiply(O,R,O),O.w<0&&s.negate(O,O),s.computeAxis(O,y);var u=s.computeAngle(O);n[a]=y.x*u,n[a+1]=y.y*u,n[a+2]=y.z*u}},s.unpackInterpolationResult=function(t,r,o,i,a){n(a)||(a=new s),e.fromArray(t,0,E);var u=e.magnitude(E);return s.unpack(r,4*i,_),0===u?s.clone(s.IDENTITY,O):s.fromAxisAngle(E,u,O),s.multiply(O,_,a)},s.clone=function(e,t){if(n(e))return n(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t.w=e.w,t):new s(e.x,e.y,e.z,e.w)},s.conjugate=function(e,r){return t.typeOf.object("quaternion",e),t.typeOf.object("result",r),r.x=-e.x,r.y=-e.y,r.z=-e.z,r.w=e.w,r},s.magnitudeSquared=function(e){return t.typeOf.object("quaternion",e),e.x*e.x+e.y*e.y+e.z*e.z+e.w*e.w},s.magnitude=function(e){return Math.sqrt(s.magnitudeSquared(e))},s.normalize=function(e,r){t.typeOf.object("result",r);var n=1/s.magnitude(e),o=e.x*n,i=e.y*n,a=e.z*n,u=e.w*n;return r.x=o,r.y=i,r.z=a,r.w=u,r},s.inverse=function(e,r){t.typeOf.object("result",r);var n=s.magnitudeSquared(e);return r=s.conjugate(e,r),s.multiplyByScalar(r,1/n,r)},s.add=function(e,r,n){return t.typeOf.object("left",e),t.typeOf.object("right",r),t.typeOf.object("result",n),n.x=e.x+r.x,n.y=e.y+r.y,n.z=e.z+r.z,n.w=e.w+r.w,n},s.subtract=function(e,r,n){return t.typeOf.object("left",e),t.typeOf.object("right",r),t.typeOf.object("result",n),n.x=e.x-r.x,n.y=e.y-r.y,n.z=e.z-r.z,n.w=e.w-r.w,n},s.negate=function(e,r){return t.typeOf.object("quaternion",e),t.typeOf.object("result",r),r.x=-e.x,r.y=-e.y,r.z=-e.z,r.w=-e.w,r},s.dot=function(e,r){return t.typeOf.object("left",e),t.typeOf.object("right",r),e.x*r.x+e.y*r.y+e.z*r.z+e.w*r.w},s.multiply=function(e,r,n){t.typeOf.object("left",e),t.typeOf.object("right",r),t.typeOf.object("result",n);var o=e.x,i=e.y,a=e.z,u=e.w,s=r.x,c=r.y,f=r.z,l=r.w,d=u*s+o*l+i*f-a*c,h=u*c-o*f+i*l+a*s,p=u*f+o*c-i*s+a*l,m=u*l-o*s-i*c-a*f;return n.x=d,n.y=h,n.z=p,n.w=m,n},s.multiplyByScalar=function(e,r,n){return t.typeOf.object("quaternion",e),t.typeOf.number("scalar",r),t.typeOf.object("result",n),n.x=e.x*r,n.y=e.y*r,n.z=e.z*r,n.w=e.w*r,n},s.divideByScalar=function(e,r,n){return t.typeOf.object("quaternion",e),t.typeOf.number("scalar",r),t.typeOf.object("result",n),n.x=e.x/r,n.y=e.y/r,n.z=e.z/r,n.w=e.w/r,n},s.computeAxis=function(e,r){t.typeOf.object("quaternion",e),t.typeOf.object("result",r);var n=e.w;if(Math.abs(n-1)<a.EPSILON6)return r.x=r.y=r.z=0,r;var o=1/Math.sqrt(1-n*n);return r.x=e.x*o,r.y=e.y*o,r.z=e.z*o,r},s.computeAngle=function(e){return t.typeOf.object("quaternion",e),Math.abs(e.w-1)<a.EPSILON6?0:2*Math.acos(e.w)};var T=new s;s.lerp=function(e,r,n,o){return t.typeOf.object("start",e),t.typeOf.object("end",r),t.typeOf.number("t",n),t.typeOf.object("result",o),T=s.multiplyByScalar(r,n,T),o=s.multiplyByScalar(e,1-n,o),s.add(T,o,o)};var g=new s,w=new s,A=new s;s.slerp=function(e,r,n,o){t.typeOf.object("start",e),t.typeOf.object("end",r),t.typeOf.number("t",n),t.typeOf.object("result",o);var i=s.dot(e,r),u=r;if(i<0&&(i=-i,u=g=s.negate(r,g)),1-i<a.EPSILON6)return s.lerp(e,u,n,o);var c=Math.acos(i);return w=s.multiplyByScalar(e,Math.sin((1-n)*c),w),A=s.multiplyByScalar(u,Math.sin(n*c),A),o=s.add(w,A,o),s.multiplyByScalar(o,1/Math.sin(c),o)},s.log=function(r,n){t.typeOf.object("quaternion",r),t.typeOf.object("result",n);var o=a.acosClamped(r.w),i=0;return 0!==o&&(i=o/Math.sin(o)),e.multiplyByScalar(r,i,n)},s.exp=function(r,n){t.typeOf.object("cartesian",r),t.typeOf.object("result",n);var o=e.magnitude(r),i=0;return 0!==o&&(i=Math.sin(o)/o),n.x=r.x*i,n.y=r.y*i,n.z=r.z*i,n.w=Math.cos(o),n};var b=new e,C=new e,S=new s,v=new s;s.computeInnerQuadrangle=function(r,n,o,i){t.typeOf.object("q0",r),t.typeOf.object("q1",n),t.typeOf.object("q2",o),t.typeOf.object("result",i);var a=s.conjugate(n,S);s.multiply(a,o,v);var u=s.log(v,b);s.multiply(a,r,v);var c=s.log(v,C);return e.add(u,c,u),e.multiplyByScalar(u,.25,u),e.negate(u,u),s.exp(u,S),s.multiply(n,S,i)},s.squad=function(e,r,n,o,i,a){t.typeOf.object("q0",e),t.typeOf.object("q1",r),t.typeOf.object("s0",n),t.typeOf.object("s1",o),t.typeOf.number("t",i),t.typeOf.object("result",a);var u=s.slerp(e,r,i,S),c=s.slerp(n,o,i,v);return s.slerp(u,c,2*i*(1-i),a)};for(var I=new s,N=1.9011074535173003,M=o.supportsTypedArrays()?new Float32Array(8):[],x=o.supportsTypedArrays()?new Float32Array(8):[],P=o.supportsTypedArrays()?new Float32Array(8):[],D=o.supportsTypedArrays()?new Float32Array(8):[],F=0;F<7;++F){var U=F+1,L=2*U+1;M[F]=1/(U*L),x[F]=U/L}return M[7]=N/136,x[7]=8*N/17,s.fastSlerp=function(e,r,n,o){t.typeOf.object("start",e),t.typeOf.object("end",r),t.typeOf.number("t",n),t.typeOf.object("result",o);var i,a=s.dot(e,r);a>=0?i=1:(i=-1,a=-a);for(var u=a-1,c=1-n,f=n*n,l=c*c,d=7;d>=0;--d)P[d]=(M[d]*f-x[d])*u,D[d]=(M[d]*l-x[d])*u;var h=i*n*(1+P[0]*(1+P[1]*(1+P[2]*(1+P[3]*(1+P[4]*(1+P[5]*(1+P[6]*(1+P[7])))))))),p=c*(1+D[0]*(1+D[1]*(1+D[2]*(1+D[3]*(1+D[4]*(1+D[5]*(1+D[6]*(1+D[7])))))))),m=s.multiplyByScalar(e,p,I);return s.multiplyByScalar(r,h,o),s.add(m,o,o)},s.fastSquad=function(e,r,n,o,i,a){t.typeOf.object("q0",e),t.typeOf.object("q1",r),t.typeOf.object("s0",n),t.typeOf.object("s1",o),t.typeOf.number("t",i),t.typeOf.object("result",a);var u=s.fastSlerp(e,r,i,S),c=s.fastSlerp(n,o,i,v);return s.fastSlerp(u,c,2*i*(1-i),a)},s.equals=function(e,t){return e===t||n(e)&&n(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z&&e.w===t.w},s.equalsEpsilon=function(e,r,o){return t.typeOf.number("epsilon",o),e===r||n(e)&&n(r)&&Math.abs(e.x-r.x)<=o&&Math.abs(e.y-r.y)<=o&&Math.abs(e.z-r.z)<=o&&Math.abs(e.w-r.w)<=o},s.ZERO=i(new s(0,0,0,0)),s.IDENTITY=i(new s(0,0,0,1)),s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s.prototype.equalsEpsilon=function(e,t){return s.equalsEpsilon(this,e,t)},s.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"},s})),define("Core/Transforms",["../ThirdParty/when","./Cartesian2","./Cartesian3","./Cartesian4","./Cartographic","./Check","./defaultValue","./defined","./DeveloperError","./EarthOrientationParameters","./EarthOrientationParametersSample","./Ellipsoid","./HeadingPitchRoll","./Iau2006XysData","./Iau2006XysSample","./JulianDate","./Math","./Matrix3","./Matrix4","./Quaternion","./TimeConstants"],(function(e,t,r,n,o,i,a,u,s,c,f,l,d,h,p,m,y,E,O,_,R){"use strict";var T={},g={up:{south:"east",north:"west",west:"south",east:"north"},down:{south:"west",north:"east",west:"north",east:"south"},south:{up:"west",down:"east",west:"down",east:"up"},north:{up:"east",down:"west",west:"up",east:"down"},west:{up:"north",down:"south",north:"down",south:"up"},east:{up:"south",down:"north",north:"up",south:"down"}},w={north:[-1,0,0],east:[0,1,0],up:[0,0,1],south:[1,0,0],west:[0,-1,0],down:[0,0,-1]},A={},b={east:new r,north:new r,up:new r,west:new r,south:new r,down:new r},C=new r,S=new r,v=new r;T.localFrameToFixedFrameGenerator=function(e,t){if(!g.hasOwnProperty(e)||!g[e].hasOwnProperty(t))throw new s("firstAxis and secondAxis must be east, north, up, west, south or down.");var n,o=g[e][t],i=e+t;return u(A[i])?n=A[i]:(n=function(n,i,c){if(!u(n))throw new s("origin is required.");if(u(c)||(c=new O),y.equalsEpsilon(n.x,0,y.EPSILON14)&&y.equalsEpsilon(n.y,0,y.EPSILON14)){var f=y.sign(n.z);r.unpack(w[e],0,C),"east"!==e&&"west"!==e&&r.multiplyByScalar(C,f,C),r.unpack(w[t],0,S),"east"!==t&&"west"!==t&&r.multiplyByScalar(S,f,S),r.unpack(w[o],0,v),"east"!==o&&"west"!==o&&r.multiplyByScalar(v,f,v)}else{(i=a(i,l.WGS84)).geodeticSurfaceNormal(n,b.up);var d=b.up,h=b.east;h.x=-n.y,h.y=n.x,h.z=0,r.normalize(h,b.east),r.cross(d,h,b.north),r.multiplyByScalar(b.up,-1,b.down),r.multiplyByScalar(b.east,-1,b.west),r.multiplyByScalar(b.north,-1,b.south),C=b[e],S=b[t],v=b[o]}return c[0]=C.x,c[1]=C.y,c[2]=C.z,c[3]=0,c[4]=S.x,c[5]=S.y,c[6]=S.z,c[7]=0,c[8]=v.x,c[9]=v.y,c[10]=v.z,c[11]=0,c[12]=n.x,c[13]=n.y,c[14]=n.z,c[15]=1,c},A[i]=n),n},T.eastNorthUpToFixedFrame=T.localFrameToFixedFrameGenerator("east","north"),T.northEastDownToFixedFrame=T.localFrameToFixedFrameGenerator("north","east"),T.northUpEastToFixedFrame=T.localFrameToFixedFrameGenerator("north","up"),T.northWestUpToFixedFrame=T.localFrameToFixedFrameGenerator("north","west");var I=new _,N=new r(1,1,1),M=new O;T.headingPitchRollToFixedFrame=function(e,t,n,o,u){i.typeOf.object("HeadingPitchRoll",t),o=a(o,T.eastNorthUpToFixedFrame);var s=_.fromHeadingPitchRoll(t,I),c=O.fromTranslationQuaternionRotationScale(r.ZERO,s,N,M);return u=o(e,n,u),O.multiply(u,c,u)};var x=new O,P=new E;T.headingPitchRollQuaternion=function(e,t,r,n,o){i.typeOf.object("HeadingPitchRoll",t);var a=T.headingPitchRollToFixedFrame(e,t,r,n,x),u=O.getRotation(a,P);return _.fromRotationMatrix(u,o)};var D=new r(1,1,1),F=new r,U=new O,L=new O,q=new E,B=new _;T.fixedFrameToHeadingPitchRoll=function(e,t,n,o){i.defined("transform",e),t=a(t,l.WGS84),n=a(n,T.eastNorthUpToFixedFrame),u(o)||(o=new d);var s=O.getTranslation(e,F);if(r.equals(s,r.ZERO))return o.heading=0,o.pitch=0,o.roll=0,o;var c=O.inverseTransformation(n(s,t,U),U),f=O.setScale(e,D,L);f=O.setTranslation(f,r.ZERO,f),c=O.multiply(c,f,c);var h=_.fromRotationMatrix(O.getRotation(c,q),B);return h=_.normalize(h,h),d.fromQuaternion(h,o)};var j=y.TWO_PI/86400,z=new m;T.computeTemeToPseudoFixedMatrix=function(e,t){if(!u(e))throw new s("date is required.");var r,n=(z=m.addSeconds(e,-m.computeTaiMinusUtc(e),z)).dayNumber,o=z.secondsOfDay,i=n-2451545,a=(24110.54841+(r=o>=43200?(i+.5)/R.DAYS_PER_JULIAN_CENTURY:(i-.5)/R.DAYS_PER_JULIAN_CENTURY)*(8640184.812866+r*(.093104+-62e-7*r)))*j%y.TWO_PI+(72921158553e-15+11772758384668e-32*(n-2451545.5))*((o+.5*R.SECONDS_PER_DAY)%R.SECONDS_PER_DAY),c=Math.cos(a),f=Math.sin(a);return u(t)?(t[0]=c,t[1]=-f,t[2]=0,t[3]=f,t[4]=c,t[5]=0,t[6]=0,t[7]=0,t[8]=1,t):new E(c,f,0,-f,c,0,0,0,1)},T.iau2006XysData=new h,T.earthOrientationParameters=c.NONE,T.preloadIcrfFixed=function(t){var r=t.start.dayNumber,n=t.start.secondsOfDay+32.184,o=t.stop.dayNumber,i=t.stop.secondsOfDay+32.184,a=T.iau2006XysData.preload(r,n,o,i),u=T.earthOrientationParameters.getPromiseToLoad();return e.all([a,u])},T.computeIcrfToFixedMatrix=function(e,t){if(!u(e))throw new s("date is required.");u(t)||(t=new E);var r=T.computeFixedToIcrfMatrix(e,t);if(u(r))return E.transpose(r,t)};var G=new p(0,0,0),V=new f(0,0,0,0,0,0),W=new E,X=new E;T.computeFixedToIcrfMatrix=function(e,t){if(!u(e))throw new s("date is required.");u(t)||(t=new E);var r=T.earthOrientationParameters.compute(e,V);if(u(r)){var n=e.dayNumber,o=e.secondsOfDay+32.184,i=T.iau2006XysData.computeXysRadians(n,o,G);if(u(i)){var a=i.x+r.xPoleOffset,c=i.y+r.yPoleOffset,f=1/(1+Math.sqrt(1-a*a-c*c)),l=W;l[0]=1-f*a*a,l[3]=-f*a*c,l[6]=a,l[1]=-f*a*c,l[4]=1-f*c*c,l[7]=c,l[2]=-a,l[5]=-c,l[8]=1-f*(a*a+c*c);var d=E.fromRotationZ(-i.s,X),h=E.multiply(l,d,W),p=e.dayNumber-2451545,O=(e.secondsOfDay-m.computeTaiMinusUtc(e)+r.ut1MinusUtc)/R.SECONDS_PER_DAY,_=.779057273264+O+.00273781191135448*(p+O);_=_%1*y.TWO_PI;var g=E.fromRotationZ(_,X),w=E.multiply(h,g,W),A=Math.cos(r.xPoleWander),b=Math.cos(r.yPoleWander),C=Math.sin(r.xPoleWander),S=Math.sin(r.yPoleWander),v=n-2451545+o/R.SECONDS_PER_DAY,I=-47e-6*(v/=36525)*y.RADIANS_PER_DEGREE/3600,N=Math.cos(I),M=Math.sin(I),x=X;return x[0]=A*N,x[1]=A*M,x[2]=C,x[3]=-b*M+S*C*N,x[4]=b*N+S*C*M,x[5]=-S*A,x[6]=-S*M-b*C*N,x[7]=S*N-b*C*M,x[8]=b*A,E.multiply(w,x,t)}}};var H=new n;T.pointToWindowCoordinates=function(e,t,r,n){return(n=T.pointToGLWindowCoordinates(e,t,r,n)).y=2*t[5]-n.y,n},T.pointToGLWindowCoordinates=function(e,r,o,i){if(!u(e))throw new s("modelViewProjectionMatrix is required.");if(!u(r))throw new s("viewportTransformation is required.");if(!u(o))throw new s("point is required.");u(i)||(i=new t);var a=H;return O.multiplyByVector(e,n.fromElements(o.x,o.y,o.z,1,a),a),n.multiplyByScalar(a,1/a.w,a),O.multiplyByVector(r,a,a),t.fromCartesian4(a,i)};var k=new r,Y=new r,K=new r;T.rotationMatrixFromPositionVelocity=function(e,t,n,o){if(!u(e))throw new s("position is required.");if(!u(t))throw new s("velocity is required.");var i=a(n,l.WGS84).geodeticSurfaceNormal(e,k),c=r.cross(t,i,Y);r.equalsEpsilon(c,r.ZERO,y.EPSILON6)&&(c=r.clone(r.UNIT_X,c));var f=r.cross(c,t,K);return r.normalize(f,f),r.cross(t,f,c),r.negate(c,c),r.normalize(c,c),u(o)||(o=new E),o[0]=t.x,o[1]=t.y,o[2]=t.z,o[3]=c.x,o[4]=c.y,o[5]=c.z,o[6]=f.x,o[7]=f.y,o[8]=f.z,o};var Z=new O(0,0,1,0,1,0,0,0,0,1,0,0,0,0,0,1),Q=new o,J=new r,$=new r,ee=new E,te=new O,re=new O;return T.basisTo2D=function(e,t,n){if(!u(e))throw new s("projection is required.");if(!u(t))throw new s("matrix is required.");if(!u(n))throw new s("result is required.");var o=O.getTranslation(t,$),i=e.ellipsoid,a=i.cartesianToCartographic(o,Q),c=e.project(a,J);r.fromElements(c.z,c.x,c.y,c);var f=T.eastNorthUpToFixedFrame(o,i,te),l=O.inverseTransformation(f,re),d=O.getRotation(t,ee),h=O.multiplyByMatrix3(l,d,n);return O.multiply(Z,h,n),O.setTranslation(n,c,n),n},T.wgs84To2DModelMatrix=function(e,t,n){if(!u(e))throw new s("projection is required.");if(!u(t))throw new s("center is required.");if(!u(n))throw new s("result is required.");var o=e.ellipsoid,i=T.eastNorthUpToFixedFrame(t,o,te),a=O.inverseTransformation(i,re),c=o.cartesianToCartographic(t,Q),f=e.project(c,J);r.fromElements(f.z,f.x,f.y,f);var l=O.fromTranslation(f,te);return O.multiply(Z,a,n),O.multiply(l,n,n),n},T})),define("Core/EllipsoidTangentPlane",["./AxisAlignedBoundingBox","./Cartesian2","./Cartesian3","./Cartesian4","./Check","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid","./IntersectionTests","./Matrix4","./Plane","./Ray","./Transforms"],(function(e,t,r,n,o,i,a,u,s,c,f,l,d,h,p){"use strict";var m=new n;function y(e,t){if(o.defined("origin",e),e=(t=i(t,c.WGS84)).scaleToGeodeticSurface(e),!a(e))throw new s("origin must not be at the center of the ellipsoid.");var n=p.eastNorthUpToFixedFrame(e,t);this._ellipsoid=t,this._origin=e,this._xAxis=r.fromCartesian4(l.getColumn(n,0,m)),this._yAxis=r.fromCartesian4(l.getColumn(n,1,m));var u=r.fromCartesian4(l.getColumn(n,2,m));this._plane=d.fromPointNormal(e,u)}u(y.prototype,{ellipsoid:{get:function(){return this._ellipsoid}},origin:{get:function(){return this._origin}},plane:{get:function(){return this._plane}},xAxis:{get:function(){return this._xAxis}},yAxis:{get:function(){return this._yAxis}},zAxis:{get:function(){return this._plane.normal}}});var E=new e;y.fromPoints=function(t,r){return o.defined("cartesians",t),new y(e.fromPoints(t,E).center,r)};var O=new h,_=new r;y.prototype.projectPointOntoPlane=function(e,n){o.defined("cartesian",e);var i=O;i.origin=e,r.normalize(e,i.direction);var u=f.rayPlane(i,this._plane,_);if(a(u)||(r.negate(i.direction,i.direction),u=f.rayPlane(i,this._plane,_)),a(u)){var s=r.subtract(u,this._origin,u),c=r.dot(this._xAxis,s),l=r.dot(this._yAxis,s);return a(n)?(n.x=c,n.y=l,n):new t(c,l)}},y.prototype.projectPointsOntoPlane=function(e,t){o.defined("cartesians",e),a(t)||(t=[]);for(var r=0,n=e.length,i=0;i<n;i++){var u=this.projectPointOntoPlane(e[i],t[r]);a(u)&&(t[r]=u,r++)}return t.length=r,t},y.prototype.projectPointToNearestOnPlane=function(e,n){o.defined("cartesian",e),a(n)||(n=new t);var i=O;i.origin=e,r.clone(this._plane.normal,i.direction);var u=f.rayPlane(i,this._plane,_);a(u)||(r.negate(i.direction,i.direction),u=f.rayPlane(i,this._plane,_));var s=r.subtract(u,this._origin,u),c=r.dot(this._xAxis,s),l=r.dot(this._yAxis,s);return n.x=c,n.y=l,n},y.prototype.projectPointsToNearestOnPlane=function(e,t){o.defined("cartesians",e),a(t)||(t=[]);var r=e.length;t.length=r;for(var n=0;n<r;n++)t[n]=this.projectPointToNearestOnPlane(e[n],t[n]);return t};var R=new r;return y.prototype.projectPointOntoEllipsoid=function(e,t){o.defined("cartesian",e),a(t)||(t=new r);var n=this._ellipsoid,i=this._origin,u=this._xAxis,s=this._yAxis,c=R;return r.multiplyByScalar(u,e.x,c),t=r.add(i,c,t),r.multiplyByScalar(s,e.y,c),r.add(t,c,t),n.scaleToGeocentricSurface(t,t),t},y.prototype.projectPointsOntoEllipsoid=function(e,t){o.defined("cartesians",e);var r=e.length;a(t)?t.length=r:t=new Array(r);for(var n=0;n<r;++n)t[n]=this.projectPointOntoEllipsoid(e[n],t[n]);return t},y})),define("Core/OrientedBoundingBox",["./BoundingSphere","./Cartesian2","./Cartesian3","./Cartographic","./Check","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./EllipsoidTangentPlane","./Intersect","./Interval","./Math","./Matrix3","./Plane","./Rectangle"],(function(e,t,r,n,o,i,a,u,s,c,f,l,d,h,p,m){"use strict";function y(e,t){this.center=r.clone(i(e,r.ZERO)),this.halfAxes=h.clone(i(t,h.ZERO))}y.packedLength=r.packedLength+h.packedLength,y.pack=function(e,t,n){return o.typeOf.object("value",e),o.defined("array",t),n=i(n,0),r.pack(e.center,t,n),h.pack(e.halfAxes,t,n+r.packedLength),t},y.unpack=function(e,t,n){return o.defined("array",e),t=i(t,0),a(n)||(n=new y),r.unpack(e,t,n.center),h.unpack(e,t+r.packedLength,n.halfAxes),n};var E=new r,O=new r,_=new r,R=new r,T=new r,g=new r,w=new h,A={unitary:new h,diagonal:new h};y.fromPoints=function(e,t){if(a(t)||(t=new y),!a(e)||0===e.length)return t.halfAxes=h.ZERO,t.center=r.ZERO,t;var n,o=e.length,i=r.clone(e[0],E);for(n=1;n<o;n++)r.add(i,e[n],i);var u=1/o;r.multiplyByScalar(i,u,i);var s,c=0,f=0,l=0,d=0,p=0,m=0;for(n=0;n<o;n++)c+=(s=r.subtract(e[n],i,O)).x*s.x,f+=s.x*s.y,l+=s.x*s.z,d+=s.y*s.y,p+=s.y*s.z,m+=s.z*s.z;c*=u,f*=u,l*=u,d*=u,p*=u,m*=u;var b=w;b[0]=c,b[1]=f,b[2]=l,b[3]=f,b[4]=d,b[5]=p,b[6]=l,b[7]=p,b[8]=m;var C=h.computeEigenDecomposition(b,A),S=h.clone(C.unitary,t.halfAxes),v=h.getColumn(S,0,R),I=h.getColumn(S,1,T),N=h.getColumn(S,2,g),M=-Number.MAX_VALUE,x=-Number.MAX_VALUE,P=-Number.MAX_VALUE,D=Number.MAX_VALUE,F=Number.MAX_VALUE,U=Number.MAX_VALUE;for(n=0;n<o;n++)s=e[n],M=Math.max(r.dot(v,s),M),x=Math.max(r.dot(I,s),x),P=Math.max(r.dot(N,s),P),D=Math.min(r.dot(v,s),D),F=Math.min(r.dot(I,s),F),U=Math.min(r.dot(N,s),U);v=r.multiplyByScalar(v,.5*(D+M),v),I=r.multiplyByScalar(I,.5*(F+x),I),N=r.multiplyByScalar(N,.5*(U+P),N);var L=r.add(v,I,t.center);r.add(L,N,L);var q=_;return q.x=M-D,q.y=x-F,q.z=P-U,r.multiplyByScalar(q,.5,q),h.multiplyByScale(t.halfAxes,q,t.halfAxes),t};var b=new r,C=new r,S=new n,v=new r,I=[new n,new n,new n,new n,new n,new n,new n,new n],N=[new r,new r,new r,new r,new r,new r,new r,new r],M=[new t,new t,new t,new t,new t,new t,new t,new t];y.fromRectangle=function(e,t,n,o,f){if(!a(e))throw new u("rectangle is required");if(e.width<0||e.width>d.TWO_PI)throw new u("Rectangle width must be between 0 and 2*pi");if(e.height<0||e.height>d.PI)throw new u("Rectangle height must be between 0 and pi");if(a(o)&&!d.equalsEpsilon(o.radii.x,o.radii.y,d.EPSILON15))throw new u("Ellipsoid must be an ellipsoid of revolution (radii.x == radii.y)");t=i(t,0),n=i(n,0),o=i(o,s.WGS84);var l=m.center(e,S),E=o.cartographicToCartesian(l,v),O=new c(E,o),_=O.plane,R=I[0],T=I[1],g=I[2],w=I[3],A=I[4],x=I[5],P=I[6],D=I[7],F=l.longitude,U=e.south<0&&e.north>0?0:l.latitude;P.latitude=x.latitude=A.latitude=e.south,D.latitude=w.latitude=U,R.latitude=T.latitude=g.latitude=e.north,P.longitude=D.longitude=R.longitude=e.west,x.longitude=T.longitude=F,A.longitude=w.longitude=g.longitude=e.east,g.height=T.height=R.height=D.height=P.height=x.height=A.height=w.height=n,o.cartographicArrayToCartesianArray(I,N),O.projectPointsToNearestOnPlane(N,M);var L=Math.min(M[6].x,M[7].x,M[0].x),q=Math.max(M[2].x,M[3].x,M[4].x),B=Math.min(M[4].y,M[5].y,M[6].y),j=Math.max(M[0].y,M[1].y,M[2].y);return g.height=R.height=A.height=P.height=t,o.cartographicArrayToCartesianArray(I,N),function(e,t,n,o,i,s,c,f){if(!(a(t)&&a(n)&&a(o)&&a(i)&&a(s)&&a(c)))throw new u("all extents (minimum/maximum X/Y/Z) are required.");a(f)||(f=new y);var l=f.halfAxes;h.setColumn(l,0,e.xAxis,l),h.setColumn(l,1,e.yAxis,l),h.setColumn(l,2,e.zAxis,l);var d=b;d.x=(t+n)/2,d.y=(o+i)/2,d.z=(s+c)/2;var p=C;p.x=(n-t)/2,p.y=(i-o)/2,p.z=(c-s)/2;var m=f.center;return d=h.multiplyByVector(l,d,d),r.add(e.origin,d,m),h.multiplyByScale(l,p,l),f}(O,L,q,B,j,Math.min(p.getPointDistance(_,N[0]),p.getPointDistance(_,N[2]),p.getPointDistance(_,N[4]),p.getPointDistance(_,N[6])),n,f)},y.clone=function(e,t){if(a(e))return a(t)?(r.clone(e.center,t.center),h.clone(e.halfAxes,t.halfAxes),t):new y(e.center,e.halfAxes)},y.intersectPlane=function(e,t){if(!a(e))throw new u("box is required.");if(!a(t))throw new u("plane is required.");var n=e.center,o=t.normal,i=e.halfAxes,s=o.x,c=o.y,l=o.z,d=Math.abs(s*i[h.COLUMN0ROW0]+c*i[h.COLUMN0ROW1]+l*i[h.COLUMN0ROW2])+Math.abs(s*i[h.COLUMN1ROW0]+c*i[h.COLUMN1ROW1]+l*i[h.COLUMN1ROW2])+Math.abs(s*i[h.COLUMN2ROW0]+c*i[h.COLUMN2ROW1]+l*i[h.COLUMN2ROW2]),p=r.dot(o,n)+t.distance;return p<=-d?f.OUTSIDE:p>=d?f.INSIDE:f.INTERSECTING};var x=new r,P=new r,D=new r,F=new r;y.distanceSquaredTo=function(e,t){if(!a(e))throw new u("box is required.");if(!a(t))throw new u("cartesian is required.");var n=r.subtract(t,e.center,b),o=e.halfAxes,i=h.getColumn(o,0,x),s=h.getColumn(o,1,P),c=h.getColumn(o,2,D),f=r.magnitude(i),l=r.magnitude(s),d=r.magnitude(c);r.normalize(i,i),r.normalize(s,s),r.normalize(c,c);var p=F;p.x=r.dot(n,i),p.y=r.dot(n,s),p.z=r.dot(n,c);var m,y=0;return p.x<-f?y+=(m=p.x+f)*m:p.x>f&&(y+=(m=p.x-f)*m),p.y<-l?y+=(m=p.y+l)*m:p.y>l&&(y+=(m=p.y-l)*m),p.z<-d?y+=(m=p.z+d)*m:p.z>d&&(y+=(m=p.z-d)*m),y};var U=new r,L=new r;y.computePlaneDistances=function(e,t,n,o){if(!a(e))throw new u("box is required.");if(!a(t))throw new u("position is required.");if(!a(n))throw new u("direction is required.");a(o)||(o=new l);var i=Number.POSITIVE_INFINITY,s=Number.NEGATIVE_INFINITY,c=e.center,f=e.halfAxes,d=h.getColumn(f,0,x),p=h.getColumn(f,1,P),m=h.getColumn(f,2,D),y=r.add(d,p,U);r.add(y,m,y),r.add(y,c,y);var E=r.subtract(y,t,L),O=r.dot(n,E);return i=Math.min(O,i),s=Math.max(O,s),r.add(c,d,y),r.add(y,p,y),r.subtract(y,m,y),r.subtract(y,t,E),O=r.dot(n,E),i=Math.min(O,i),s=Math.max(O,s),r.add(c,d,y),r.subtract(y,p,y),r.add(y,m,y),r.subtract(y,t,E),O=r.dot(n,E),i=Math.min(O,i),s=Math.max(O,s),r.add(c,d,y),r.subtract(y,p,y),r.subtract(y,m,y),r.subtract(y,t,E),O=r.dot(n,E),i=Math.min(O,i),s=Math.max(O,s),r.subtract(c,d,y),r.add(y,p,y),r.add(y,m,y),r.subtract(y,t,E),O=r.dot(n,E),i=Math.min(O,i),s=Math.max(O,s),r.subtract(c,d,y),r.add(y,p,y),r.subtract(y,m,y),r.subtract(y,t,E),O=r.dot(n,E),i=Math.min(O,i),s=Math.max(O,s),r.subtract(c,d,y),r.subtract(y,p,y),r.add(y,m,y),r.subtract(y,t,E),O=r.dot(n,E),i=Math.min(O,i),s=Math.max(O,s),r.subtract(c,d,y),r.subtract(y,p,y),r.subtract(y,m,y),r.subtract(y,t,E),O=r.dot(n,E),i=Math.min(O,i),s=Math.max(O,s),o.start=i,o.stop=s,o};var q=new e;return y.isOccluded=function(t,r){if(!a(t))throw new u("box is required.");if(!a(r))throw new u("occluder is required.");var n=e.fromOrientedBoundingBox(t,q);return!r.isBoundingSphereVisible(n)},y.prototype.intersectPlane=function(e){return y.intersectPlane(this,e)},y.prototype.distanceSquaredTo=function(e){return y.distanceSquaredTo(this,e)},y.prototype.computePlaneDistances=function(e,t,r){return y.computePlaneDistances(this,e,t,r)},y.prototype.isOccluded=function(e){return y.isOccluded(this,e)},y.equals=function(e,t){return e===t||a(e)&&a(t)&&r.equals(e.center,t.center)&&h.equals(e.halfAxes,t.halfAxes)},y.prototype.clone=function(e){return y.clone(this,e)},y.prototype.equals=function(e){return y.equals(this,e)},y})),define("Core/formatError",["./defined"],(function(e){"use strict";return function(t){var r,n=t.name,o=t.message;r=e(n)&&e(o)?n+": "+o:t.toString();var i=t.stack;return e(i)&&(r+="\n"+i),r}})),define("Workers/createTaskProcessorWorker",["../ThirdParty/when","../Core/defaultValue","../Core/defined","../Core/formatError"],(function(e,t,r,n){"use strict";return function(o){var i;return function(a){var u=a.data,s=[],c={id:u.id,result:void 0,error:void 0};return e(function(t,r,n){try{return t(r,n)}catch(t){return e.reject(t)}}(o,u.parameters,s)).then((function(e){c.result=e})).otherwise((function(e){e instanceof Error?c.error={name:e.name,message:e.message,stack:e.stack}:c.error=e})).always((function(){r(i)||(i=t(self.webkitPostMessage,self.postMessage)),u.canTransferArrayBuffer||(s.length=0);try{i(c,s)}catch(e){c.result=void 0,c.error="postMessage failed with error: "+n(e)+"\n  with responseMessage: "+JSON.stringify(c),i(c)}}))}}})),define("Workers/createVectorTilePolygons",["../Core/AttributeCompression","../Core/Cartesian3","../Core/Cartographic","../Core/Color","../Core/defined","../Core/Ellipsoid","../Core/IndexDatatype","../Core/Math","../Core/OrientedBoundingBox","../Core/Rectangle","./createTaskProcessorWorker"],(function(e,t,r,n,o,i,a,u,s,c,f){"use strict";var l=new t,d=new i,h=new c,p={min:void 0,max:void 0,indexBytesPerElement:void 0};function m(e,t,r){var o=t.length,i=2+o*s.packedLength+1+function(e){for(var t=e.length,r=0,o=0;o<t;++o)r+=n.packedLength+3+e[o].batchIds.length;return r}(r),a=new Float64Array(i),u=0;a[u++]=e,a[u++]=o;for(var c=0;c<o;++c)s.pack(t[c],a,u),u+=s.packedLength;var f=r.length;a[u++]=f;for(var l=0;l<f;++l){var d=r[l];n.pack(d.color,a,u),u+=n.packedLength,a[u++]=d.offset,a[u++]=d.count;var h=d.batchIds,p=h.length;a[u++]=p;for(var m=0;m<p;++m)a[u++]=h[m]}return a}var y=new t,E=new t,O=new t,_=new t,R=new t,T=new r,g=new c;return f((function(f,w){var A;!function(e){var r=new Float64Array(e),n=0;p.indexBytesPerElement=r[n++],p.min=r[n++],p.max=r[n++],t.unpack(r,n,l),n+=t.packedLength,i.unpack(r,n,d),n+=i.packedLength,c.unpack(r,n,h)}(f.packedBuffer),A=2===p.indexBytesPerElement?new Uint16Array(f.indices):new Uint32Array(f.indices);var b,C,S,v=new Uint16Array(f.positions),I=new Uint32Array(f.counts),N=new Uint32Array(f.indexCounts),M=new Uint32Array(f.batchIds),x=new Uint32Array(f.batchTableColors),P=new Array(I.length),D=l,F=d,U=h,L=p.min,q=p.max,B=f.minimumHeights,j=f.maximumHeights;o(B)&&o(j)&&(B=new Float32Array(B),j=new Float32Array(j));var z=v.length/2,G=v.subarray(0,z),V=v.subarray(z,2*z);e.zigZagDeltaDecode(G,V);var W=new Float32Array(3*z);for(b=0;b<z;++b){var X=G[b],H=V[b],k=u.lerp(U.west,U.east,X/32767),Y=u.lerp(U.south,U.north,H/32767),K=r.fromRadians(k,Y,0,T),Z=F.cartographicToCartesian(K,y);t.pack(Z,W,3*b)}var Q=I.length,J=new Array(Q),$=new Array(Q),ee=0,te=0;for(b=0;b<Q;++b)J[b]=ee,$[b]=te,ee+=I[b],te+=N[b];var re,ne=new Float32Array(3*z*2),oe=new Uint16Array(2*z),ie=new Uint32Array($.length),ae=new Uint32Array(N.length),ue=[],se={};for(b=0;b<Q;++b)S=x[b],o(se[S])?(se[S].positionLength+=I[b],se[S].indexLength+=N[b],se[S].batchIds.push(b)):se[S]={positionLength:I[b],indexLength:N[b],offset:0,indexOffset:0,batchIds:[b]};var ce=0,fe=0;for(S in se)if(se.hasOwnProperty(S)){(re=se[S]).offset=ce,re.indexOffset=fe;var le=2*re.positionLength,de=2*re.indexLength+6*re.positionLength;ce+=le,fe+=de,re.indexLength=de}var he=[];for(S in se)se.hasOwnProperty(S)&&(re=se[S],he.push({color:n.fromRgba(parseInt(S)),offset:re.indexOffset,count:re.indexLength,batchIds:re.batchIds}));for(b=0;b<Q;++b){var pe=(re=se[S=x[b]]).offset,me=3*pe,ye=pe,Ee=J[b],Oe=I[b],_e=M[b],Re=L,Te=q;o(B)&&o(j)&&(Re=B[b],Te=j[b]);var ge=Number.POSITIVE_INFINITY,we=Number.NEGATIVE_INFINITY,Ae=Number.POSITIVE_INFINITY,be=Number.NEGATIVE_INFINITY;for(C=0;C<Oe;++C){var Ce=t.unpack(W,3*Ee+3*C,y);F.scaleToGeodeticSurface(Ce,Ce);var Se=F.cartesianToCartographic(Ce,T),ve=Se.latitude,Ie=Se.longitude;ge=Math.min(ve,ge),we=Math.max(ve,we),Ae=Math.min(Ie,Ae),be=Math.max(Ie,be);var Ne=F.geodeticSurfaceNormal(Ce,E),Me=t.multiplyByScalar(Ne,Re,O),xe=t.add(Ce,Me,_);Me=t.multiplyByScalar(Ne,Te,Me);var Pe=t.add(Ce,Me,R);t.subtract(Pe,D,Pe),t.subtract(xe,D,xe),t.pack(Pe,ne,me),t.pack(xe,ne,me+3),oe[ye]=_e,oe[ye+1]=_e,me+=6,ye+=2}(U=g).west=Ae,U.east=be,U.south=ge,U.north=we,P[b]=s.fromRectangle(U,L,q,F);var De=re.indexOffset,Fe=$[b],Ue=N[b];for(ie[b]=De,C=0;C<Ue;C+=3){var Le=A[Fe+C]-Ee,qe=A[Fe+C+1]-Ee,Be=A[Fe+C+2]-Ee;ue[De++]=2*Le+pe,ue[De++]=2*qe+pe,ue[De++]=2*Be+pe,ue[De++]=2*Be+1+pe,ue[De++]=2*qe+1+pe,ue[De++]=2*Le+1+pe}for(C=0;C<Oe;++C){var je=C,ze=(C+1)%Oe;ue[De++]=2*je+1+pe,ue[De++]=2*ze+pe,ue[De++]=2*je+pe,ue[De++]=2*je+1+pe,ue[De++]=2*ze+1+pe,ue[De++]=2*ze+pe}re.offset+=2*Oe,re.indexOffset=De,ae[b]=De-ie[b]}ue=a.createTypedArray(ne.length/3,ue);for(var Ge=he.length,Ve=0;Ve<Ge;++Ve){for(var We=he[Ve].batchIds,Xe=0,He=We.length,ke=0;ke<He;++ke)Xe+=ae[We[ke]];he[Ve].count=Xe}var Ye=m(2===ue.BYTES_PER_ELEMENT?a.UNSIGNED_SHORT:a.UNSIGNED_INT,P,he);return w.push(ne.buffer,ue.buffer,ie.buffer,ae.buffer,oe.buffer,Ye.buffer),{positions:ne.buffer,indices:ue.buffer,indexOffsets:ie.buffer,indexCounts:ae.buffer,batchIds:oe.buffer,packedBuffer:Ye.buffer}}))}));