define("Core/defined",[],(function(){"use strict";return function(e){return null!=e}})),define("Core/DeveloperError",["./defined"],(function(e){"use strict";function t(e){var t;this.name="DeveloperError",this.message=e;try{throw new Error}catch(e){t=e.stack}this.stack=t}return e(Object.create)&&(t.prototype=Object.create(Error.prototype),t.prototype.constructor=t),t.prototype.toString=function(){var t=this.name+": "+this.message;return e(this.stack)&&(t+="\n"+this.stack.toString()),t},t.throwInstantiationError=function(){throw new t("This function defines an interface and should not be called directly.")},t})),define("Core/Check",["./defined","./DeveloperError"],(function(e,t){"use strict";var n={};function r(e,t,n){return"Expected "+n+" to be typeof "+t+", actual typeof was "+e}return n.typeOf={},n.defined=function(n,r){if(!e(r))throw new t(function(e){return e+" is required, actual value was undefined"}(n))},n.typeOf.func=function(e,n){if("function"!=typeof n)throw new t(r(typeof n,"function",e))},n.typeOf.string=function(e,n){if("string"!=typeof n)throw new t(r(typeof n,"string",e))},n.typeOf.number=function(e,n){if("number"!=typeof n)throw new t(r(typeof n,"number",e))},n.typeOf.number.lessThan=function(e,r,i){if(n.typeOf.number(e,r),r>=i)throw new t("Expected "+e+" to be less than "+i+", actual value was "+r)},n.typeOf.number.lessThanOrEquals=function(e,r,i){if(n.typeOf.number(e,r),r>i)throw new t("Expected "+e+" to be less than or equal to "+i+", actual value was "+r)},n.typeOf.number.greaterThan=function(e,r,i){if(n.typeOf.number(e,r),r<=i)throw new t("Expected "+e+" to be greater than "+i+", actual value was "+r)},n.typeOf.number.greaterThanOrEquals=function(e,r,i){if(n.typeOf.number(e,r),r<i)throw new t("Expected "+e+" to be greater than or equal to"+i+", actual value was "+r)},n.typeOf.object=function(e,n){if("object"!=typeof n)throw new t(r(typeof n,"object",e))},n.typeOf.bool=function(e,n){if("boolean"!=typeof n)throw new t(r(typeof n,"boolean",e))},n.typeOf.number.equals=function(e,r,i,a){if(n.typeOf.number(e,i),n.typeOf.number(r,a),i!==a)throw new t(e+" must be equal to "+r+", the actual values are "+i+" and "+a)},n})),define("Core/freezeObject",["./defined"],(function(e){"use strict";var t=Object.freeze;return e(t)||(t=function(e){return e}),t})),define("Core/defaultValue",["./freezeObject"],(function(e){"use strict";function t(e,t){return null!=e?e:t}return t.EMPTY_OBJECT=e({}),t})),
/**
@license
mersenne-twister.js - https://gist.github.com/banksean/300494

   Copyright (C) 1997 - 2002, Makoto Matsumoto and Takuji Nishimura,
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:

     1. Redistributions of source code must retain the above copyright
        notice, this list of conditions and the following disclaimer.

     2. Redistributions in binary form must reproduce the above copyright
        notice, this list of conditions and the following disclaimer in the
        documentation and/or other materials provided with the distribution.

     3. The names of its contributors may not be used to endorse or promote
        products derived from this software without specific prior written
        permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
   A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
   EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
   PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
define("ThirdParty/mersenne-twister",[],(function(){var e=function(e){null==e&&(e=(new Date).getTime()),this.N=624,this.M=397,this.MATRIX_A=2567483615,this.UPPER_MASK=2147483648,this.LOWER_MASK=2147483647,this.mt=new Array(this.N),this.mti=this.N+1,this.init_genrand(e)};return e.prototype.init_genrand=function(e){for(this.mt[0]=e>>>0,this.mti=1;this.mti<this.N;this.mti++)e=this.mt[this.mti-1]^this.mt[this.mti-1]>>>30,this.mt[this.mti]=(1812433253*((4294901760&e)>>>16)<<16)+1812433253*(65535&e)+this.mti,this.mt[this.mti]>>>=0},e.prototype.genrand_int32=function(){var e,t=new Array(0,this.MATRIX_A);if(this.mti>=this.N){var n;for(this.mti==this.N+1&&this.init_genrand(5489),n=0;n<this.N-this.M;n++)e=this.mt[n]&this.UPPER_MASK|this.mt[n+1]&this.LOWER_MASK,this.mt[n]=this.mt[n+this.M]^e>>>1^t[1&e];for(;n<this.N-1;n++)e=this.mt[n]&this.UPPER_MASK|this.mt[n+1]&this.LOWER_MASK,this.mt[n]=this.mt[n+(this.M-this.N)]^e>>>1^t[1&e];e=this.mt[this.N-1]&this.UPPER_MASK|this.mt[0]&this.LOWER_MASK,this.mt[this.N-1]=this.mt[this.M-1]^e>>>1^t[1&e],this.mti=0}return e=this.mt[this.mti++],e^=e>>>11,e^=e<<7&2636928640,e^=e<<15&4022730752,(e^=e>>>18)>>>0},e.prototype.random=function(){return this.genrand_int32()*(1/4294967296)},e})),define("Core/Math",["../ThirdParty/mersenne-twister","./Check","./defaultValue","./defined","./DeveloperError"],(function(e,t,n,r,i){"use strict";var a={EPSILON1:.1,EPSILON2:.01,EPSILON3:.001,EPSILON4:1e-4,EPSILON5:1e-5,EPSILON6:1e-6,EPSILON7:1e-7,EPSILON8:1e-8,EPSILON9:1e-9,EPSILON10:1e-10,EPSILON11:1e-11,EPSILON12:1e-12,EPSILON13:1e-13,EPSILON14:1e-14,EPSILON15:1e-15,EPSILON16:1e-16,EPSILON17:1e-17,EPSILON18:1e-18,EPSILON19:1e-19,EPSILON20:1e-20,EPSILON21:1e-21,GRAVITATIONALPARAMETER:3986004418e5,SOLAR_RADIUS:6955e5,LUNAR_RADIUS:1737400,SIXTY_FOUR_KILOBYTES:65536};a.sign=n(Math.sign,(function(e){return 0==(e=+e)||e!=e?e:e>0?1:-1})),a.signNotZero=function(e){return e<0?-1:1},a.toSNorm=function(e,t){return t=n(t,255),Math.round((.5*a.clamp(e,-1,1)+.5)*t)},a.fromSNorm=function(e,t){return t=n(t,255),a.clamp(e,0,t)/t*2-1},a.sinh=n(Math.sinh,(function(e){return(Math.exp(e)-Math.exp(-e))/2})),a.cosh=n(Math.cosh,(function(e){return(Math.exp(e)+Math.exp(-e))/2})),a.lerp=function(e,t,n){return(1-n)*e+n*t},a.PI=Math.PI,a.ONE_OVER_PI=1/Math.PI,a.PI_OVER_TWO=Math.PI/2,a.PI_OVER_THREE=Math.PI/3,a.PI_OVER_FOUR=Math.PI/4,a.PI_OVER_SIX=Math.PI/6,a.THREE_PI_OVER_TWO=3*Math.PI/2,a.TWO_PI=2*Math.PI,a.ONE_OVER_TWO_PI=1/(2*Math.PI),a.RADIANS_PER_DEGREE=Math.PI/180,a.DEGREES_PER_RADIAN=180/Math.PI,a.RADIANS_PER_ARCSECOND=a.RADIANS_PER_DEGREE/3600,a.toRadians=function(e){if(!r(e))throw new i("degrees is required.");return e*a.RADIANS_PER_DEGREE},a.toDegrees=function(e){if(!r(e))throw new i("radians is required.");return e*a.DEGREES_PER_RADIAN},a.convertLongitudeRange=function(e){if(!r(e))throw new i("angle is required.");var t=a.TWO_PI,n=e-Math.floor(e/t)*t;return n<-Math.PI?n+t:n>=Math.PI?n-t:n},a.clampToLatitudeRange=function(e){if(!r(e))throw new i("angle is required.");return a.clamp(e,-1*a.PI_OVER_TWO,a.PI_OVER_TWO)},a.negativePiToPi=function(e){if(!r(e))throw new i("angle is required.");return a.zeroToTwoPi(e+a.PI)-a.PI},a.zeroToTwoPi=function(e){if(!r(e))throw new i("angle is required.");var t=a.mod(e,a.TWO_PI);return Math.abs(t)<a.EPSILON14&&Math.abs(e)>a.EPSILON14?a.TWO_PI:t},a.mod=function(e,t){if(!r(e))throw new i("m is required.");if(!r(t))throw new i("n is required.");return(e%t+t)%t},a.equalsEpsilon=function(e,t,a,o){if(!r(e))throw new i("left is required.");if(!r(t))throw new i("right is required.");if(!r(a))throw new i("relativeEpsilon is required.");o=n(o,a);var E=Math.abs(e-t);return E<=o||E<=a*Math.max(Math.abs(e),Math.abs(t))};var o=[1];a.factorial=function(e){if("number"!=typeof e||e<0)throw new i("A number greater than or equal to 0 is required.");var t=o.length;if(e>=t)for(var n=o[t-1],r=t;r<=e;r++)o.push(n*r);return o[e]},a.incrementWrap=function(e,t,a){if(a=n(a,0),!r(e))throw new i("n is required.");if(t<=a)throw new i("maximumValue must be greater than minimumValue.");return++e>t&&(e=a),e},a.isPowerOfTwo=function(e){if("number"!=typeof e||e<0)throw new i("A number greater than or equal to 0 is required.");return 0!==e&&0==(e&e-1)},a.nextPowerOfTwo=function(e){if("number"!=typeof e||e<0)throw new i("A number greater than or equal to 0 is required.");return--e,e|=e>>1,e|=e>>2,e|=e>>4,e|=e>>8,e|=e>>16,++e},a.clamp=function(e,t,n){if(!r(e))throw new i("value is required");if(!r(t))throw new i("min is required.");if(!r(n))throw new i("max is required.");return e<t?t:e>n?n:e};var E=new e;return a.setRandomNumberSeed=function(t){if(!r(t))throw new i("seed is required.");E=new e(t)},a.nextRandomNumber=function(){return E.random()},a.randomBetween=function(e,t){return a.nextRandomNumber()*(t-e)+e},a.acosClamped=function(e){if(!r(e))throw new i("value is required.");return Math.acos(a.clamp(e,-1,1))},a.asinClamped=function(e){if(!r(e))throw new i("value is required.");return Math.asin(a.clamp(e,-1,1))},a.chordLength=function(e,t){if(!r(e))throw new i("angle is required.");if(!r(t))throw new i("radius is required.");return 2*t*Math.sin(.5*e)},a.logBase=function(e,t){if(!r(e))throw new i("number is required.");if(!r(t))throw new i("base is required.");return Math.log(e)/Math.log(t)},a.cbrt=n(Math.cbrt,(function(e){var t=Math.pow(Math.abs(e),1/3);return e<0?-t:t})),a.log2=n(Math.log2,(function(e){return Math.log(e)*Math.LOG2E})),a.fog=function(e,t){var n=e*t;return 1-Math.exp(-n*n)},a.fastApproximateAtan=function(e){return t.typeOf.number("x",e),e*(-.1784*Math.abs(e)-.0663*e*e+1.0301)},a.fastApproximateAtan2=function(e,n){var r,o;t.typeOf.number("x",e),t.typeOf.number("y",n);var E=Math.abs(e);r=Math.abs(n),o=Math.max(E,r);var u=(r=Math.min(E,r))/o;if(isNaN(u))throw new i("either x or y must be nonzero");return E=a.fastApproximateAtan(u),E=Math.abs(n)>Math.abs(e)?a.PI_OVER_TWO-E:E,E=e<0?a.PI-E:E,E=n<0?-E:E},a})),define("Core/Cartesian2",["./Check","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],(function(e,t,n,r,i,a){"use strict";function o(e,n){this.x=t(e,0),this.y=t(n,0)}o.fromElements=function(e,t,r){return n(r)?(r.x=e,r.y=t,r):new o(e,t)},o.clone=function(e,t){if(n(e))return n(t)?(t.x=e.x,t.y=e.y,t):new o(e.x,e.y)},o.fromCartesian3=o.clone,o.fromCartesian4=o.clone,o.packedLength=2,o.pack=function(n,r,i){return e.typeOf.object("value",n),e.defined("array",r),i=t(i,0),r[i++]=n.x,r[i]=n.y,r},o.unpack=function(r,i,a){return e.defined("array",r),i=t(i,0),n(a)||(a=new o),a.x=r[i++],a.y=r[i],a},o.packArray=function(t,r){e.defined("array",t);var i=t.length;n(r)?r.length=2*i:r=new Array(2*i);for(var a=0;a<i;++a)o.pack(t[a],r,2*a);return r},o.unpackArray=function(t,r){e.defined("array",t);var i=t.length;n(r)?r.length=i/2:r=new Array(i/2);for(var a=0;a<i;a+=2){var E=a/2;r[E]=o.unpack(t,a,r[E])}return r},o.fromArray=o.unpack,o.maximumComponent=function(t){return e.typeOf.object("cartesian",t),Math.max(t.x,t.y)},o.minimumComponent=function(t){return e.typeOf.object("cartesian",t),Math.min(t.x,t.y)},o.minimumByComponent=function(t,n,r){return e.typeOf.object("first",t),e.typeOf.object("second",n),e.typeOf.object("result",r),r.x=Math.min(t.x,n.x),r.y=Math.min(t.y,n.y),r},o.maximumByComponent=function(t,n,r){return e.typeOf.object("first",t),e.typeOf.object("second",n),e.typeOf.object("result",r),r.x=Math.max(t.x,n.x),r.y=Math.max(t.y,n.y),r},o.magnitudeSquared=function(t){return e.typeOf.object("cartesian",t),t.x*t.x+t.y*t.y},o.magnitude=function(e){return Math.sqrt(o.magnitudeSquared(e))};var E=new o;o.distance=function(t,n){return e.typeOf.object("left",t),e.typeOf.object("right",n),o.subtract(t,n,E),o.magnitude(E)},o.distanceSquared=function(t,n){return e.typeOf.object("left",t),e.typeOf.object("right",n),o.subtract(t,n,E),o.magnitudeSquared(E)},o.normalize=function(t,n){e.typeOf.object("cartesian",t),e.typeOf.object("result",n);var i=o.magnitude(t);if(n.x=t.x/i,n.y=t.y/i,isNaN(n.x)||isNaN(n.y))throw new r("normalized result is not a number");return n},o.dot=function(t,n){return e.typeOf.object("left",t),e.typeOf.object("right",n),t.x*n.x+t.y*n.y},o.multiplyComponents=function(t,n,r){return e.typeOf.object("left",t),e.typeOf.object("right",n),e.typeOf.object("result",r),r.x=t.x*n.x,r.y=t.y*n.y,r},o.divideComponents=function(t,n,r){return e.typeOf.object("left",t),e.typeOf.object("right",n),e.typeOf.object("result",r),r.x=t.x/n.x,r.y=t.y/n.y,r},o.add=function(t,n,r){return e.typeOf.object("left",t),e.typeOf.object("right",n),e.typeOf.object("result",r),r.x=t.x+n.x,r.y=t.y+n.y,r},o.subtract=function(t,n,r){return e.typeOf.object("left",t),e.typeOf.object("right",n),e.typeOf.object("result",r),r.x=t.x-n.x,r.y=t.y-n.y,r},o.multiplyByScalar=function(t,n,r){return e.typeOf.object("cartesian",t),e.typeOf.number("scalar",n),e.typeOf.object("result",r),r.x=t.x*n,r.y=t.y*n,r},o.divideByScalar=function(t,n,r){return e.typeOf.object("cartesian",t),e.typeOf.number("scalar",n),e.typeOf.object("result",r),r.x=t.x/n,r.y=t.y/n,r},o.negate=function(t,n){return e.typeOf.object("cartesian",t),e.typeOf.object("result",n),n.x=-t.x,n.y=-t.y,n},o.abs=function(t,n){return e.typeOf.object("cartesian",t),e.typeOf.object("result",n),n.x=Math.abs(t.x),n.y=Math.abs(t.y),n};var u=new o;o.lerp=function(t,n,r,i){return e.typeOf.object("start",t),e.typeOf.object("end",n),e.typeOf.number("t",r),e.typeOf.object("result",i),o.multiplyByScalar(n,r,u),i=o.multiplyByScalar(t,1-r,i),o.add(u,i,i)};var _=new o,s=new o;o.angleBetween=function(t,n){return e.typeOf.object("left",t),e.typeOf.object("right",n),o.normalize(t,_),o.normalize(n,s),a.acosClamped(o.dot(_,s))};var c=new o;return o.mostOrthogonalAxis=function(t,n){e.typeOf.object("cartesian",t),e.typeOf.object("result",n);var r=o.normalize(t,c);return o.abs(r,r),n=r.x<=r.y?o.clone(o.UNIT_X,n):o.clone(o.UNIT_Y,n)},o.equals=function(e,t){return e===t||n(e)&&n(t)&&e.x===t.x&&e.y===t.y},o.equalsArray=function(e,t,n){return e.x===t[n]&&e.y===t[n+1]},o.equalsEpsilon=function(e,t,r,i){return e===t||n(e)&&n(t)&&a.equalsEpsilon(e.x,t.x,r,i)&&a.equalsEpsilon(e.y,t.y,r,i)},o.ZERO=i(new o(0,0)),o.UNIT_X=i(new o(1,0)),o.UNIT_Y=i(new o(0,1)),o.prototype.clone=function(e){return o.clone(this,e)},o.prototype.equals=function(e){return o.equals(this,e)},o.prototype.equalsEpsilon=function(e,t,n){return o.equalsEpsilon(this,e,t,n)},o.prototype.toString=function(){return"("+this.x+", "+this.y+")"},o})),define("Core/Cartesian3",["./Check","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],(function(e,t,n,r,i,a){"use strict";function o(e,n,r){this.x=t(e,0),this.y=t(n,0),this.z=t(r,0)}o.fromSpherical=function(r,i){e.typeOf.object("spherical",r),n(i)||(i=new o);var a=r.clock,E=r.cone,u=t(r.magnitude,1),_=u*Math.sin(E);return i.x=_*Math.cos(a),i.y=_*Math.sin(a),i.z=u*Math.cos(E),i},o.fromElements=function(e,t,r,i){return n(i)?(i.x=e,i.y=t,i.z=r,i):new o(e,t,r)},o.clone=function(e,t){if(n(e))return n(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t):new o(e.x,e.y,e.z)},o.fromCartesian4=o.clone,o.packedLength=3,o.pack=function(n,r,i){return e.typeOf.object("value",n),e.defined("array",r),i=t(i,0),r[i++]=n.x,r[i++]=n.y,r[i]=n.z,r},o.unpack=function(r,i,a){return e.defined("array",r),i=t(i,0),n(a)||(a=new o),a.x=r[i++],a.y=r[i++],a.z=r[i],a},o.packArray=function(t,r){e.defined("array",t);var i=t.length;n(r)?r.length=3*i:r=new Array(3*i);for(var a=0;a<i;++a)o.pack(t[a],r,3*a);return r},o.unpackArray=function(t,i){if(e.defined("array",t),e.typeOf.number.greaterThanOrEquals("array.length",t.length,3),t.length%3!=0)throw new r("array length must be a multiple of 3.");var a=t.length;n(i)?i.length=a/3:i=new Array(a/3);for(var E=0;E<a;E+=3){var u=E/3;i[u]=o.unpack(t,E,i[u])}return i},o.fromArray=o.unpack,o.maximumComponent=function(t){return e.typeOf.object("cartesian",t),Math.max(t.x,t.y,t.z)},o.minimumComponent=function(t){return e.typeOf.object("cartesian",t),Math.min(t.x,t.y,t.z)},o.minimumByComponent=function(t,n,r){return e.typeOf.object("first",t),e.typeOf.object("second",n),e.typeOf.object("result",r),r.x=Math.min(t.x,n.x),r.y=Math.min(t.y,n.y),r.z=Math.min(t.z,n.z),r},o.maximumByComponent=function(t,n,r){return e.typeOf.object("first",t),e.typeOf.object("second",n),e.typeOf.object("result",r),r.x=Math.max(t.x,n.x),r.y=Math.max(t.y,n.y),r.z=Math.max(t.z,n.z),r},o.magnitudeSquared=function(t){return e.typeOf.object("cartesian",t),t.x*t.x+t.y*t.y+t.z*t.z},o.magnitude=function(e){return Math.sqrt(o.magnitudeSquared(e))};var E=new o;o.distance=function(t,n){return e.typeOf.object("left",t),e.typeOf.object("right",n),o.subtract(t,n,E),o.magnitude(E)},o.distanceSquared=function(t,n){return e.typeOf.object("left",t),e.typeOf.object("right",n),o.subtract(t,n,E),o.magnitudeSquared(E)},o.normalize=function(t,n){e.typeOf.object("cartesian",t),e.typeOf.object("result",n);var i=o.magnitude(t);if(n.x=t.x/i,n.y=t.y/i,n.z=t.z/i,isNaN(n.x)||isNaN(n.y)||isNaN(n.z))throw new r("normalized result is not a number");return n},o.dot=function(t,n){return e.typeOf.object("left",t),e.typeOf.object("right",n),t.x*n.x+t.y*n.y+t.z*n.z},o.multiplyComponents=function(t,n,r){return e.typeOf.object("left",t),e.typeOf.object("right",n),e.typeOf.object("result",r),r.x=t.x*n.x,r.y=t.y*n.y,r.z=t.z*n.z,r},o.divideComponents=function(t,n,r){return e.typeOf.object("left",t),e.typeOf.object("right",n),e.typeOf.object("result",r),r.x=t.x/n.x,r.y=t.y/n.y,r.z=t.z/n.z,r},o.add=function(t,n,r){return e.typeOf.object("left",t),e.typeOf.object("right",n),e.typeOf.object("result",r),r.x=t.x+n.x,r.y=t.y+n.y,r.z=t.z+n.z,r},o.subtract=function(t,n,r){return e.typeOf.object("left",t),e.typeOf.object("right",n),e.typeOf.object("result",r),r.x=t.x-n.x,r.y=t.y-n.y,r.z=t.z-n.z,r},o.multiplyByScalar=function(t,n,r){return e.typeOf.object("cartesian",t),e.typeOf.number("scalar",n),e.typeOf.object("result",r),r.x=t.x*n,r.y=t.y*n,r.z=t.z*n,r},o.divideByScalar=function(t,n,r){return e.typeOf.object("cartesian",t),e.typeOf.number("scalar",n),e.typeOf.object("result",r),r.x=t.x/n,r.y=t.y/n,r.z=t.z/n,r},o.negate=function(t,n){return e.typeOf.object("cartesian",t),e.typeOf.object("result",n),n.x=-t.x,n.y=-t.y,n.z=-t.z,n},o.abs=function(t,n){return e.typeOf.object("cartesian",t),e.typeOf.object("result",n),n.x=Math.abs(t.x),n.y=Math.abs(t.y),n.z=Math.abs(t.z),n};var u=new o;o.lerp=function(t,n,r,i){return e.typeOf.object("start",t),e.typeOf.object("end",n),e.typeOf.number("t",r),e.typeOf.object("result",i),o.multiplyByScalar(n,r,u),i=o.multiplyByScalar(t,1-r,i),o.add(u,i,i)};var _=new o,s=new o;o.angleBetween=function(t,n){e.typeOf.object("left",t),e.typeOf.object("right",n),o.normalize(t,_),o.normalize(n,s);var r=o.dot(_,s),i=o.magnitude(o.cross(_,s,_));return Math.atan2(i,r)};var c=new o;o.mostOrthogonalAxis=function(t,n){e.typeOf.object("cartesian",t),e.typeOf.object("result",n);var r=o.normalize(t,c);return o.abs(r,r),n=r.x<=r.y?r.x<=r.z?o.clone(o.UNIT_X,n):o.clone(o.UNIT_Z,n):r.y<=r.z?o.clone(o.UNIT_Y,n):o.clone(o.UNIT_Z,n)},o.projectVector=function(t,n,r){e.defined("a",t),e.defined("b",n),e.defined("result",r);var i=o.dot(t,n)/o.dot(n,n);return o.multiplyByScalar(n,i,r)},o.equals=function(e,t){return e===t||n(e)&&n(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z},o.equalsArray=function(e,t,n){return e.x===t[n]&&e.y===t[n+1]&&e.z===t[n+2]},o.equalsEpsilon=function(e,t,r,i){return e===t||n(e)&&n(t)&&a.equalsEpsilon(e.x,t.x,r,i)&&a.equalsEpsilon(e.y,t.y,r,i)&&a.equalsEpsilon(e.z,t.z,r,i)},o.cross=function(t,n,r){e.typeOf.object("left",t),e.typeOf.object("right",n),e.typeOf.object("result",r);var i=t.x,a=t.y,o=t.z,E=n.x,u=n.y,_=n.z,s=a*_-o*u,c=o*E-i*_,R=i*u-a*E;return r.x=s,r.y=c,r.z=R,r},o.midpoint=function(t,n,r){return e.typeOf.object("left",t),e.typeOf.object("right",n),e.typeOf.object("result",r),r.x=.5*(t.x+n.x),r.y=.5*(t.y+n.y),r.z=.5*(t.z+n.z),r},o.fromDegrees=function(t,n,r,i,E){return e.typeOf.number("longitude",t),e.typeOf.number("latitude",n),t=a.toRadians(t),n=a.toRadians(n),o.fromRadians(t,n,r,i,E)};var R=new o,f=new o,T=new o(40680631590769,40680631590769,40408299984661.445);return o.fromRadians=function(r,i,a,E,u){e.typeOf.number("longitude",r),e.typeOf.number("latitude",i),a=t(a,0);var _=n(E)?E.radiiSquared:T,s=Math.cos(i);R.x=s*Math.cos(r),R.y=s*Math.sin(r),R.z=Math.sin(i),R=o.normalize(R,R),o.multiplyComponents(_,R,f);var c=Math.sqrt(o.dot(R,f));return f=o.divideByScalar(f,c,f),R=o.multiplyByScalar(R,a,R),n(u)||(u=new o),o.add(f,R,u)},o.fromDegreesArray=function(t,i,a){if(e.defined("coordinates",t),t.length<2||t.length%2!=0)throw new r("the number of coordinates must be a multiple of 2 and at least 2");var E=t.length;n(a)?a.length=E/2:a=new Array(E/2);for(var u=0;u<E;u+=2){var _=t[u],s=t[u+1],c=u/2;a[c]=o.fromDegrees(_,s,0,i,a[c])}return a},o.fromRadiansArray=function(t,i,a){if(e.defined("coordinates",t),t.length<2||t.length%2!=0)throw new r("the number of coordinates must be a multiple of 2 and at least 2");var E=t.length;n(a)?a.length=E/2:a=new Array(E/2);for(var u=0;u<E;u+=2){var _=t[u],s=t[u+1],c=u/2;a[c]=o.fromRadians(_,s,0,i,a[c])}return a},o.fromDegreesArrayHeights=function(t,i,a){if(e.defined("coordinates",t),t.length<3||t.length%3!=0)throw new r("the number of coordinates must be a multiple of 3 and at least 3");var E=t.length;n(a)?a.length=E/3:a=new Array(E/3);for(var u=0;u<E;u+=3){var _=t[u],s=t[u+1],c=t[u+2],R=u/3;a[R]=o.fromDegrees(_,s,c,i,a[R])}return a},o.fromRadiansArrayHeights=function(t,i,a){if(e.defined("coordinates",t),t.length<3||t.length%3!=0)throw new r("the number of coordinates must be a multiple of 3 and at least 3");var E=t.length;n(a)?a.length=E/3:a=new Array(E/3);for(var u=0;u<E;u+=3){var _=t[u],s=t[u+1],c=t[u+2],R=u/3;a[R]=o.fromRadians(_,s,c,i,a[R])}return a},o.ZERO=i(new o(0,0,0)),o.UNIT_X=i(new o(1,0,0)),o.UNIT_Y=i(new o(0,1,0)),o.UNIT_Z=i(new o(0,0,1)),o.prototype.clone=function(e){return o.clone(this,e)},o.prototype.equals=function(e){return o.equals(this,e)},o.prototype.equalsEpsilon=function(e,t,n){return o.equalsEpsilon(this,e,t,n)},o.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+")"},o})),define("Core/AttributeCompression",["./Cartesian2","./Cartesian3","./Check","./defined","./DeveloperError","./Math"],(function(e,t,n,r,i,a){"use strict";var o={octEncodeInRange:function(e,r,o){n.defined("vector",e),n.defined("result",o);var E=t.magnitudeSquared(e);if(Math.abs(E-1)>a.EPSILON6)throw new i("vector must be normalized.");if(o.x=e.x/(Math.abs(e.x)+Math.abs(e.y)+Math.abs(e.z)),o.y=e.y/(Math.abs(e.x)+Math.abs(e.y)+Math.abs(e.z)),e.z<0){var u=o.x,_=o.y;o.x=(1-Math.abs(_))*a.signNotZero(u),o.y=(1-Math.abs(u))*a.signNotZero(_)}return o.x=a.toSNorm(o.x,r),o.y=a.toSNorm(o.y,r),o},octEncode:function(e,t){return o.octEncodeInRange(e,255,t)}},E=new e,u=new Uint8Array(1);function _(e){return u[0]=e,u[0]}o.octEncodeToCartesian4=function(e,t){return o.octEncodeInRange(e,65535,E),t.x=_(E.x*(1/256)),t.y=_(E.x),t.z=_(E.y*(1/256)),t.w=_(E.y),t},o.octDecodeInRange=function(e,r,o,E){if(n.defined("result",E),e<0||e>o||r<0||r>o)throw new i("x and y must be unsigned normalized integers between 0 and "+o);if(E.x=a.fromSNorm(e,o),E.y=a.fromSNorm(r,o),E.z=1-(Math.abs(E.x)+Math.abs(E.y)),E.z<0){var u=E.x;E.x=(1-Math.abs(E.y))*a.signNotZero(u),E.y=(1-Math.abs(u))*a.signNotZero(E.y)}return t.normalize(E,E)},o.octDecode=function(e,t,n){return o.octDecodeInRange(e,t,255,n)},o.octDecodeFromCartesian4=function(e,t){n.typeOf.object("encoded",e),n.typeOf.object("result",t);var r=e.x,a=e.y,E=e.z,u=e.w;if(r<0||r>255||a<0||a>255||E<0||E>255||u<0||u>255)throw new i("x, y, z, and w must be unsigned normalized integers between 0 and 255");var _=256*r+a,s=256*E+u;return o.octDecodeInRange(_,s,65535,t)},o.octPackFloat=function(e){return n.defined("encoded",e),256*e.x+e.y};var s=new e;function c(e){return e>>1^-(1&e)}return o.octEncodeFloat=function(e){return o.octEncode(e,s),o.octPackFloat(s)},o.octDecodeFloat=function(e,t){n.defined("value",e);var r=e/256,i=Math.floor(r),a=256*(r-i);return o.octDecode(i,a,t)},o.octPack=function(e,t,r,i){n.defined("v1",e),n.defined("v2",t),n.defined("v3",r),n.defined("result",i);var a=o.octEncodeFloat(e),E=o.octEncodeFloat(t),u=o.octEncode(r,s);return i.x=65536*u.x+a,i.y=65536*u.y+E,i},o.octUnpack=function(e,t,r,i){n.defined("packed",e),n.defined("v1",t),n.defined("v2",r),n.defined("v3",i);var a=e.x/65536,E=Math.floor(a),u=65536*(a-E);a=e.y/65536;var _=Math.floor(a),s=65536*(a-_);o.octDecodeFloat(u,t),o.octDecodeFloat(s,r),o.octDecode(E,_,i)},o.compressTextureCoordinates=function(e){return n.defined("textureCoordinates",e),4096*(4095*e.x|0)+(4095*e.y|0)},o.decompressTextureCoordinates=function(e,t){n.defined("compressed",e),n.defined("result",t);var r=e/4096,i=Math.floor(r);return t.x=i/4095,t.y=(e-4096*i)/4095,t},o.zigZagDeltaDecode=function(e,t,i){n.defined("uBuffer",e),n.defined("vBuffer",t),n.typeOf.number.equals("uBuffer.length","vBuffer.length",e.length,t.length),r(i)&&n.typeOf.number.equals("uBuffer.length","heightBuffer.length",e.length,i.length);for(var a=e.length,o=0,E=0,u=0,_=0;_<a;++_)o+=c(e[_]),E+=c(t[_]),e[_]=o,t[_]=E,r(i)&&(u+=c(i[_]),i[_]=u)},o})),define("Core/scaleToGeodeticSurface",["./Cartesian3","./defined","./DeveloperError","./Math"],(function(e,t,n,r){"use strict";var i=new e,a=new e;return function(o,E,u,_,s){if(!t(o))throw new n("cartesian is required.");if(!t(E))throw new n("oneOverRadii is required.");if(!t(u))throw new n("oneOverRadiiSquared is required.");if(!t(_))throw new n("centerToleranceSquared is required.");var c=o.x,R=o.y,f=o.z,T=E.x,A=E.y,h=E.z,O=c*c*T*T,N=R*R*A*A,d=f*f*h*h,l=O+N+d,I=Math.sqrt(1/l),S=e.multiplyByScalar(o,I,i);if(l<_)return isFinite(I)?e.clone(S,s):void 0;var M=u.x,p=u.y,y=u.z,C=a;C.x=S.x*M*2,C.y=S.y*p*2,C.z=S.z*y*2;var m,U,P,F,L,D,g,b=(1-I)*e.magnitude(o)/(.5*e.magnitude(C)),B=0;do{B=(m=O*(L=(U=1/(1+(b-=B)*M))*U)+N*(D=(P=1/(1+b*p))*P)+d*(g=(F=1/(1+b*y))*F)-1)/(-2*(O*(L*U)*M+N*(D*P)*p+d*(g*F)*y))}while(Math.abs(m)>r.EPSILON12);return t(s)?(s.x=c*U,s.y=R*P,s.z=f*F,s):new e(c*U,R*P,f*F)}})),define("Core/Cartographic",["./Cartesian3","./Check","./defaultValue","./defined","./freezeObject","./Math","./scaleToGeodeticSurface"],(function(e,t,n,r,i,a,o){"use strict";function E(e,t,r){this.longitude=n(e,0),this.latitude=n(t,0),this.height=n(r,0)}E.fromRadians=function(e,i,a,o){return t.typeOf.number("longitude",e),t.typeOf.number("latitude",i),a=n(a,0),r(o)?(o.longitude=e,o.latitude=i,o.height=a,o):new E(e,i,a)},E.fromDegrees=function(e,n,r,i){return t.typeOf.number("longitude",e),t.typeOf.number("latitude",n),e=a.toRadians(e),n=a.toRadians(n),E.fromRadians(e,n,r,i)};var u=new e,_=new e,s=new e,c=new e(1/6378137,1/6378137,1/6356752.314245179),R=new e(1/40680631590769,1/40680631590769,1/40408299984661.445),f=a.EPSILON1;return E.fromCartesian=function(t,n,i){var T=r(n)?n.oneOverRadii:c,A=r(n)?n.oneOverRadiiSquared:R,h=r(n)?n._centerToleranceSquared:f,O=o(t,T,A,h,_);if(r(O)){var N=e.multiplyComponents(O,A,u);N=e.normalize(N,N);var d=e.subtract(t,O,s),l=Math.atan2(N.y,N.x),I=Math.asin(N.z),S=a.sign(e.dot(d,t))*e.magnitude(d);return r(i)?(i.longitude=l,i.latitude=I,i.height=S,i):new E(l,I,S)}},E.toCartesian=function(n,r,i){return t.defined("cartographic",n),e.fromRadians(n.longitude,n.latitude,n.height,r,i)},E.clone=function(e,t){if(r(e))return r(t)?(t.longitude=e.longitude,t.latitude=e.latitude,t.height=e.height,t):new E(e.longitude,e.latitude,e.height)},E.equals=function(e,t){return e===t||r(e)&&r(t)&&e.longitude===t.longitude&&e.latitude===t.latitude&&e.height===t.height},E.equalsEpsilon=function(e,n,i){return t.typeOf.number("epsilon",i),e===n||r(e)&&r(n)&&Math.abs(e.longitude-n.longitude)<=i&&Math.abs(e.latitude-n.latitude)<=i&&Math.abs(e.height-n.height)<=i},E.ZERO=i(new E(0,0,0)),E.prototype.clone=function(e){return E.clone(this,e)},E.prototype.equals=function(e){return E.equals(this,e)},E.prototype.equalsEpsilon=function(e,t){return E.equalsEpsilon(this,e,t)},E.prototype.toString=function(){return"("+this.longitude+", "+this.latitude+", "+this.height+")"},E})),define("Core/defineProperties",["./defined"],(function(e){"use strict";var t=function(){try{return"x"in Object.defineProperty({},"x",{})}catch(e){return!1}}(),n=Object.defineProperties;return t&&e(n)||(n=function(e){return e}),n})),define("Core/Ellipsoid",["./Cartesian3","./Cartographic","./Check","./defaultValue","./defined","./defineProperties","./DeveloperError","./freezeObject","./Math","./scaleToGeodeticSurface"],(function(e,t,n,r,i,a,o,E,u,_){"use strict";function s(t,i,a,o){i=r(i,0),a=r(a,0),o=r(o,0),n.typeOf.number.greaterThanOrEquals("x",i,0),n.typeOf.number.greaterThanOrEquals("y",a,0),n.typeOf.number.greaterThanOrEquals("z",o,0),t._radii=new e(i,a,o),t._radiiSquared=new e(i*i,a*a,o*o),t._radiiToTheFourth=new e(i*i*i*i,a*a*a*a,o*o*o*o),t._oneOverRadii=new e(0===i?0:1/i,0===a?0:1/a,0===o?0:1/o),t._oneOverRadiiSquared=new e(0===i?0:1/(i*i),0===a?0:1/(a*a),0===o?0:1/(o*o)),t._minimumRadius=Math.min(i,a,o),t._maximumRadius=Math.max(i,a,o),t._centerToleranceSquared=u.EPSILON1,0!==t._radiiSquared.z&&(t._squaredXOverSquaredZ=t._radiiSquared.x/t._radiiSquared.z)}function c(e,t,n){this._radii=void 0,this._radiiSquared=void 0,this._radiiToTheFourth=void 0,this._oneOverRadii=void 0,this._oneOverRadiiSquared=void 0,this._minimumRadius=void 0,this._maximumRadius=void 0,this._centerToleranceSquared=void 0,this._squaredXOverSquaredZ=void 0,s(this,e,t,n)}a(c.prototype,{radii:{get:function(){return this._radii}},radiiSquared:{get:function(){return this._radiiSquared}},radiiToTheFourth:{get:function(){return this._radiiToTheFourth}},oneOverRadii:{get:function(){return this._oneOverRadii}},oneOverRadiiSquared:{get:function(){return this._oneOverRadiiSquared}},minimumRadius:{get:function(){return this._minimumRadius}},maximumRadius:{get:function(){return this._maximumRadius}}}),c.clone=function(t,n){if(i(t)){var r=t._radii;return i(n)?(e.clone(r,n._radii),e.clone(t._radiiSquared,n._radiiSquared),e.clone(t._radiiToTheFourth,n._radiiToTheFourth),e.clone(t._oneOverRadii,n._oneOverRadii),e.clone(t._oneOverRadiiSquared,n._oneOverRadiiSquared),n._minimumRadius=t._minimumRadius,n._maximumRadius=t._maximumRadius,n._centerToleranceSquared=t._centerToleranceSquared,n):new c(r.x,r.y,r.z)}},c.fromCartesian3=function(e,t){return i(t)||(t=new c),i(e)?(s(t,e.x,e.y,e.z),t):t},c.WGS84=E(new c(6378137,6378137,6356752.314245179)),c.UNIT_SPHERE=E(new c(1,1,1)),c.MOON=E(new c(u.LUNAR_RADIUS,u.LUNAR_RADIUS,u.LUNAR_RADIUS)),c.prototype.clone=function(e){return c.clone(this,e)},c.packedLength=e.packedLength,c.pack=function(t,i,a){return n.typeOf.object("value",t),n.defined("array",i),a=r(a,0),e.pack(t._radii,i,a),i},c.unpack=function(t,i,a){n.defined("array",t),i=r(i,0);var o=e.unpack(t,i);return c.fromCartesian3(o,a)},c.prototype.geocentricSurfaceNormal=e.normalize,c.prototype.geodeticSurfaceNormalCartographic=function(t,r){n.typeOf.object("cartographic",t);var a=t.longitude,o=t.latitude,E=Math.cos(o),u=E*Math.cos(a),_=E*Math.sin(a),s=Math.sin(o);return i(r)||(r=new e),r.x=u,r.y=_,r.z=s,e.normalize(r,r)},c.prototype.geodeticSurfaceNormal=function(t,n){return i(n)||(n=new e),n=e.multiplyComponents(t,this._oneOverRadiiSquared,n),e.normalize(n,n)};var R=new e,f=new e;c.prototype.cartographicToCartesian=function(t,n){var r=R,a=f;this.geodeticSurfaceNormalCartographic(t,r),e.multiplyComponents(this._radiiSquared,r,a);var o=Math.sqrt(e.dot(r,a));return e.divideByScalar(a,o,a),e.multiplyByScalar(r,t.height,r),i(n)||(n=new e),e.add(a,r,n)},c.prototype.cartographicArrayToCartesianArray=function(e,t){n.defined("cartographics",e);var r=e.length;i(t)?t.length=r:t=new Array(r);for(var a=0;a<r;a++)t[a]=this.cartographicToCartesian(e[a],t[a]);return t};var T=new e,A=new e,h=new e;return c.prototype.cartesianToCartographic=function(n,r){var a=this.scaleToGeodeticSurface(n,A);if(i(a)){var o=this.geodeticSurfaceNormal(a,T),E=e.subtract(n,a,h),_=Math.atan2(o.y,o.x),s=Math.asin(o.z),c=u.sign(e.dot(E,n))*e.magnitude(E);return i(r)?(r.longitude=_,r.latitude=s,r.height=c,r):new t(_,s,c)}},c.prototype.cartesianArrayToCartographicArray=function(e,t){n.defined("cartesians",e);var r=e.length;i(t)?t.length=r:t=new Array(r);for(var a=0;a<r;++a)t[a]=this.cartesianToCartographic(e[a],t[a]);return t},c.prototype.scaleToGeodeticSurface=function(e,t){return _(e,this._oneOverRadii,this._oneOverRadiiSquared,this._centerToleranceSquared,t)},c.prototype.scaleToGeocentricSurface=function(t,r){n.typeOf.object("cartesian",t),i(r)||(r=new e);var a=t.x,o=t.y,E=t.z,u=this._oneOverRadiiSquared,_=1/Math.sqrt(a*a*u.x+o*o*u.y+E*E*u.z);return e.multiplyByScalar(t,_,r)},c.prototype.transformPositionToScaledSpace=function(t,n){return i(n)||(n=new e),e.multiplyComponents(t,this._oneOverRadii,n)},c.prototype.transformPositionFromScaledSpace=function(t,n){return i(n)||(n=new e),e.multiplyComponents(t,this._radii,n)},c.prototype.equals=function(t){return this===t||i(t)&&e.equals(this._radii,t._radii)},c.prototype.toString=function(){return this._radii.toString()},c.prototype.getSurfaceNormalIntersectionWithZAxis=function(t,a,E){if(n.typeOf.object("position",t),!u.equalsEpsilon(this._radii.x,this._radii.y,u.EPSILON15))throw new o("Ellipsoid must be an ellipsoid of revolution (radii.x == radii.y)");n.typeOf.number.greaterThan("Ellipsoid.radii.z",this._radii.z,0),a=r(a,0);var _=this._squaredXOverSquaredZ;if(i(E)||(E=new e),E.x=0,E.y=0,E.z=t.z*(1-_),!(Math.abs(E.z)>=this._radii.z-a))return E},c})),define("Core/WebGLConstants",["./freezeObject"],(function(e){"use strict";return e({DEPTH_BUFFER_BIT:256,STENCIL_BUFFER_BIT:1024,COLOR_BUFFER_BIT:16384,POINTS:0,LINES:1,LINE_LOOP:2,LINE_STRIP:3,TRIANGLES:4,TRIANGLE_STRIP:5,TRIANGLE_FAN:6,ZERO:0,ONE:1,SRC_COLOR:768,ONE_MINUS_SRC_COLOR:769,SRC_ALPHA:770,ONE_MINUS_SRC_ALPHA:771,DST_ALPHA:772,ONE_MINUS_DST_ALPHA:773,DST_COLOR:774,ONE_MINUS_DST_COLOR:775,SRC_ALPHA_SATURATE:776,FUNC_ADD:32774,BLEND_EQUATION:32777,BLEND_EQUATION_RGB:32777,BLEND_EQUATION_ALPHA:34877,FUNC_SUBTRACT:32778,FUNC_REVERSE_SUBTRACT:32779,BLEND_DST_RGB:32968,BLEND_SRC_RGB:32969,BLEND_DST_ALPHA:32970,BLEND_SRC_ALPHA:32971,CONSTANT_COLOR:32769,ONE_MINUS_CONSTANT_COLOR:32770,CONSTANT_ALPHA:32771,ONE_MINUS_CONSTANT_ALPHA:32772,BLEND_COLOR:32773,ARRAY_BUFFER:34962,ELEMENT_ARRAY_BUFFER:34963,ARRAY_BUFFER_BINDING:34964,ELEMENT_ARRAY_BUFFER_BINDING:34965,STREAM_DRAW:35040,STATIC_DRAW:35044,DYNAMIC_DRAW:35048,BUFFER_SIZE:34660,BUFFER_USAGE:34661,CURRENT_VERTEX_ATTRIB:34342,FRONT:1028,BACK:1029,FRONT_AND_BACK:1032,CULL_FACE:2884,BLEND:3042,DITHER:3024,STENCIL_TEST:2960,DEPTH_TEST:2929,SCISSOR_TEST:3089,POLYGON_OFFSET_FILL:32823,SAMPLE_ALPHA_TO_COVERAGE:32926,SAMPLE_COVERAGE:32928,NO_ERROR:0,INVALID_ENUM:1280,INVALID_VALUE:1281,INVALID_OPERATION:1282,OUT_OF_MEMORY:1285,CW:2304,CCW:2305,LINE_WIDTH:2849,ALIASED_POINT_SIZE_RANGE:33901,ALIASED_LINE_WIDTH_RANGE:33902,CULL_FACE_MODE:2885,FRONT_FACE:2886,DEPTH_RANGE:2928,DEPTH_WRITEMASK:2930,DEPTH_CLEAR_VALUE:2931,DEPTH_FUNC:2932,STENCIL_CLEAR_VALUE:2961,STENCIL_FUNC:2962,STENCIL_FAIL:2964,STENCIL_PASS_DEPTH_FAIL:2965,STENCIL_PASS_DEPTH_PASS:2966,STENCIL_REF:2967,STENCIL_VALUE_MASK:2963,STENCIL_WRITEMASK:2968,STENCIL_BACK_FUNC:34816,STENCIL_BACK_FAIL:34817,STENCIL_BACK_PASS_DEPTH_FAIL:34818,STENCIL_BACK_PASS_DEPTH_PASS:34819,STENCIL_BACK_REF:36003,STENCIL_BACK_VALUE_MASK:36004,STENCIL_BACK_WRITEMASK:36005,VIEWPORT:2978,SCISSOR_BOX:3088,COLOR_CLEAR_VALUE:3106,COLOR_WRITEMASK:3107,UNPACK_ALIGNMENT:3317,PACK_ALIGNMENT:3333,MAX_TEXTURE_SIZE:3379,MAX_VIEWPORT_DIMS:3386,SUBPIXEL_BITS:3408,RED_BITS:3410,GREEN_BITS:3411,BLUE_BITS:3412,ALPHA_BITS:3413,DEPTH_BITS:3414,STENCIL_BITS:3415,POLYGON_OFFSET_UNITS:10752,POLYGON_OFFSET_FACTOR:32824,TEXTURE_BINDING_2D:32873,SAMPLE_BUFFERS:32936,SAMPLES:32937,SAMPLE_COVERAGE_VALUE:32938,SAMPLE_COVERAGE_INVERT:32939,COMPRESSED_TEXTURE_FORMATS:34467,DONT_CARE:4352,FASTEST:4353,NICEST:4354,GENERATE_MIPMAP_HINT:33170,BYTE:5120,UNSIGNED_BYTE:5121,SHORT:5122,UNSIGNED_SHORT:5123,INT:5124,UNSIGNED_INT:5125,FLOAT:5126,DEPTH_COMPONENT:6402,ALPHA:6406,RGB:6407,RGBA:6408,LUMINANCE:6409,LUMINANCE_ALPHA:6410,UNSIGNED_SHORT_4_4_4_4:32819,UNSIGNED_SHORT_5_5_5_1:32820,UNSIGNED_SHORT_5_6_5:33635,FRAGMENT_SHADER:35632,VERTEX_SHADER:35633,MAX_VERTEX_ATTRIBS:34921,MAX_VERTEX_UNIFORM_VECTORS:36347,MAX_VARYING_VECTORS:36348,MAX_COMBINED_TEXTURE_IMAGE_UNITS:35661,MAX_VERTEX_TEXTURE_IMAGE_UNITS:35660,MAX_TEXTURE_IMAGE_UNITS:34930,MAX_FRAGMENT_UNIFORM_VECTORS:36349,SHADER_TYPE:35663,DELETE_STATUS:35712,LINK_STATUS:35714,VALIDATE_STATUS:35715,ATTACHED_SHADERS:35717,ACTIVE_UNIFORMS:35718,ACTIVE_ATTRIBUTES:35721,SHADING_LANGUAGE_VERSION:35724,CURRENT_PROGRAM:35725,NEVER:512,LESS:513,EQUAL:514,LEQUAL:515,GREATER:516,NOTEQUAL:517,GEQUAL:518,ALWAYS:519,KEEP:7680,REPLACE:7681,INCR:7682,DECR:7683,INVERT:5386,INCR_WRAP:34055,DECR_WRAP:34056,VENDOR:7936,RENDERER:7937,VERSION:7938,NEAREST:9728,LINEAR:9729,NEAREST_MIPMAP_NEAREST:9984,LINEAR_MIPMAP_NEAREST:9985,NEAREST_MIPMAP_LINEAR:9986,LINEAR_MIPMAP_LINEAR:9987,TEXTURE_MAG_FILTER:10240,TEXTURE_MIN_FILTER:10241,TEXTURE_WRAP_S:10242,TEXTURE_WRAP_T:10243,TEXTURE_2D:3553,TEXTURE:5890,TEXTURE_CUBE_MAP:34067,TEXTURE_BINDING_CUBE_MAP:34068,TEXTURE_CUBE_MAP_POSITIVE_X:34069,TEXTURE_CUBE_MAP_NEGATIVE_X:34070,TEXTURE_CUBE_MAP_POSITIVE_Y:34071,TEXTURE_CUBE_MAP_NEGATIVE_Y:34072,TEXTURE_CUBE_MAP_POSITIVE_Z:34073,TEXTURE_CUBE_MAP_NEGATIVE_Z:34074,MAX_CUBE_MAP_TEXTURE_SIZE:34076,TEXTURE0:33984,TEXTURE1:33985,TEXTURE2:33986,TEXTURE3:33987,TEXTURE4:33988,TEXTURE5:33989,TEXTURE6:33990,TEXTURE7:33991,TEXTURE8:33992,TEXTURE9:33993,TEXTURE10:33994,TEXTURE11:33995,TEXTURE12:33996,TEXTURE13:33997,TEXTURE14:33998,TEXTURE15:33999,TEXTURE16:34e3,TEXTURE17:34001,TEXTURE18:34002,TEXTURE19:34003,TEXTURE20:34004,TEXTURE21:34005,TEXTURE22:34006,TEXTURE23:34007,TEXTURE24:34008,TEXTURE25:34009,TEXTURE26:34010,TEXTURE27:34011,TEXTURE28:34012,TEXTURE29:34013,TEXTURE30:34014,TEXTURE31:34015,ACTIVE_TEXTURE:34016,REPEAT:10497,CLAMP_TO_EDGE:33071,MIRRORED_REPEAT:33648,FLOAT_VEC2:35664,FLOAT_VEC3:35665,FLOAT_VEC4:35666,INT_VEC2:35667,INT_VEC3:35668,INT_VEC4:35669,BOOL:35670,BOOL_VEC2:35671,BOOL_VEC3:35672,BOOL_VEC4:35673,FLOAT_MAT2:35674,FLOAT_MAT3:35675,FLOAT_MAT4:35676,SAMPLER_2D:35678,SAMPLER_CUBE:35680,VERTEX_ATTRIB_ARRAY_ENABLED:34338,VERTEX_ATTRIB_ARRAY_SIZE:34339,VERTEX_ATTRIB_ARRAY_STRIDE:34340,VERTEX_ATTRIB_ARRAY_TYPE:34341,VERTEX_ATTRIB_ARRAY_NORMALIZED:34922,VERTEX_ATTRIB_ARRAY_POINTER:34373,VERTEX_ATTRIB_ARRAY_BUFFER_BINDING:34975,IMPLEMENTATION_COLOR_READ_TYPE:35738,IMPLEMENTATION_COLOR_READ_FORMAT:35739,COMPILE_STATUS:35713,LOW_FLOAT:36336,MEDIUM_FLOAT:36337,HIGH_FLOAT:36338,LOW_INT:36339,MEDIUM_INT:36340,HIGH_INT:36341,FRAMEBUFFER:36160,RENDERBUFFER:36161,RGBA4:32854,RGB5_A1:32855,RGB565:36194,DEPTH_COMPONENT16:33189,STENCIL_INDEX:6401,STENCIL_INDEX8:36168,DEPTH_STENCIL:34041,RENDERBUFFER_WIDTH:36162,RENDERBUFFER_HEIGHT:36163,RENDERBUFFER_INTERNAL_FORMAT:36164,RENDERBUFFER_RED_SIZE:36176,RENDERBUFFER_GREEN_SIZE:36177,RENDERBUFFER_BLUE_SIZE:36178,RENDERBUFFER_ALPHA_SIZE:36179,RENDERBUFFER_DEPTH_SIZE:36180,RENDERBUFFER_STENCIL_SIZE:36181,FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE:36048,FRAMEBUFFER_ATTACHMENT_OBJECT_NAME:36049,FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL:36050,FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE:36051,COLOR_ATTACHMENT0:36064,DEPTH_ATTACHMENT:36096,STENCIL_ATTACHMENT:36128,DEPTH_STENCIL_ATTACHMENT:33306,NONE:0,FRAMEBUFFER_COMPLETE:36053,FRAMEBUFFER_INCOMPLETE_ATTACHMENT:36054,FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT:36055,FRAMEBUFFER_INCOMPLETE_DIMENSIONS:36057,FRAMEBUFFER_UNSUPPORTED:36061,FRAMEBUFFER_BINDING:36006,RENDERBUFFER_BINDING:36007,MAX_RENDERBUFFER_SIZE:34024,INVALID_FRAMEBUFFER_OPERATION:1286,UNPACK_FLIP_Y_WEBGL:37440,UNPACK_PREMULTIPLY_ALPHA_WEBGL:37441,CONTEXT_LOST_WEBGL:37442,UNPACK_COLORSPACE_CONVERSION_WEBGL:37443,BROWSER_DEFAULT_WEBGL:37444,COMPRESSED_RGB_S3TC_DXT1_EXT:33776,COMPRESSED_RGBA_S3TC_DXT1_EXT:33777,COMPRESSED_RGBA_S3TC_DXT3_EXT:33778,COMPRESSED_RGBA_S3TC_DXT5_EXT:33779,COMPRESSED_RGB_PVRTC_4BPPV1_IMG:35840,COMPRESSED_RGB_PVRTC_2BPPV1_IMG:35841,COMPRESSED_RGBA_PVRTC_4BPPV1_IMG:35842,COMPRESSED_RGBA_PVRTC_2BPPV1_IMG:35843,COMPRESSED_RGB_ETC1_WEBGL:36196,HALF_FLOAT_OES:36193,DOUBLE:5130,READ_BUFFER:3074,UNPACK_ROW_LENGTH:3314,UNPACK_SKIP_ROWS:3315,UNPACK_SKIP_PIXELS:3316,PACK_ROW_LENGTH:3330,PACK_SKIP_ROWS:3331,PACK_SKIP_PIXELS:3332,COLOR:6144,DEPTH:6145,STENCIL:6146,RED:6403,RGB8:32849,RGBA8:32856,RGB10_A2:32857,TEXTURE_BINDING_3D:32874,UNPACK_SKIP_IMAGES:32877,UNPACK_IMAGE_HEIGHT:32878,TEXTURE_3D:32879,TEXTURE_WRAP_R:32882,MAX_3D_TEXTURE_SIZE:32883,UNSIGNED_INT_2_10_10_10_REV:33640,MAX_ELEMENTS_VERTICES:33e3,MAX_ELEMENTS_INDICES:33001,TEXTURE_MIN_LOD:33082,TEXTURE_MAX_LOD:33083,TEXTURE_BASE_LEVEL:33084,TEXTURE_MAX_LEVEL:33085,MIN:32775,MAX:32776,DEPTH_COMPONENT24:33190,MAX_TEXTURE_LOD_BIAS:34045,TEXTURE_COMPARE_MODE:34892,TEXTURE_COMPARE_FUNC:34893,CURRENT_QUERY:34917,QUERY_RESULT:34918,QUERY_RESULT_AVAILABLE:34919,STREAM_READ:35041,STREAM_COPY:35042,STATIC_READ:35045,STATIC_COPY:35046,DYNAMIC_READ:35049,DYNAMIC_COPY:35050,MAX_DRAW_BUFFERS:34852,DRAW_BUFFER0:34853,DRAW_BUFFER1:34854,DRAW_BUFFER2:34855,DRAW_BUFFER3:34856,DRAW_BUFFER4:34857,DRAW_BUFFER5:34858,DRAW_BUFFER6:34859,DRAW_BUFFER7:34860,DRAW_BUFFER8:34861,DRAW_BUFFER9:34862,DRAW_BUFFER10:34863,DRAW_BUFFER11:34864,DRAW_BUFFER12:34865,DRAW_BUFFER13:34866,DRAW_BUFFER14:34867,DRAW_BUFFER15:34868,MAX_FRAGMENT_UNIFORM_COMPONENTS:35657,MAX_VERTEX_UNIFORM_COMPONENTS:35658,SAMPLER_3D:35679,SAMPLER_2D_SHADOW:35682,FRAGMENT_SHADER_DERIVATIVE_HINT:35723,PIXEL_PACK_BUFFER:35051,PIXEL_UNPACK_BUFFER:35052,PIXEL_PACK_BUFFER_BINDING:35053,PIXEL_UNPACK_BUFFER_BINDING:35055,FLOAT_MAT2x3:35685,FLOAT_MAT2x4:35686,FLOAT_MAT3x2:35687,FLOAT_MAT3x4:35688,FLOAT_MAT4x2:35689,FLOAT_MAT4x3:35690,SRGB:35904,SRGB8:35905,SRGB8_ALPHA8:35907,COMPARE_REF_TO_TEXTURE:34894,RGBA32F:34836,RGB32F:34837,RGBA16F:34842,RGB16F:34843,VERTEX_ATTRIB_ARRAY_INTEGER:35069,MAX_ARRAY_TEXTURE_LAYERS:35071,MIN_PROGRAM_TEXEL_OFFSET:35076,MAX_PROGRAM_TEXEL_OFFSET:35077,MAX_VARYING_COMPONENTS:35659,TEXTURE_2D_ARRAY:35866,TEXTURE_BINDING_2D_ARRAY:35869,R11F_G11F_B10F:35898,UNSIGNED_INT_10F_11F_11F_REV:35899,RGB9_E5:35901,UNSIGNED_INT_5_9_9_9_REV:35902,TRANSFORM_FEEDBACK_BUFFER_MODE:35967,MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS:35968,TRANSFORM_FEEDBACK_VARYINGS:35971,TRANSFORM_FEEDBACK_BUFFER_START:35972,TRANSFORM_FEEDBACK_BUFFER_SIZE:35973,TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN:35976,RASTERIZER_DISCARD:35977,MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS:35978,MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS:35979,INTERLEAVED_ATTRIBS:35980,SEPARATE_ATTRIBS:35981,TRANSFORM_FEEDBACK_BUFFER:35982,TRANSFORM_FEEDBACK_BUFFER_BINDING:35983,RGBA32UI:36208,RGB32UI:36209,RGBA16UI:36214,RGB16UI:36215,RGBA8UI:36220,RGB8UI:36221,RGBA32I:36226,RGB32I:36227,RGBA16I:36232,RGB16I:36233,RGBA8I:36238,RGB8I:36239,RED_INTEGER:36244,RGB_INTEGER:36248,RGBA_INTEGER:36249,SAMPLER_2D_ARRAY:36289,SAMPLER_2D_ARRAY_SHADOW:36292,SAMPLER_CUBE_SHADOW:36293,UNSIGNED_INT_VEC2:36294,UNSIGNED_INT_VEC3:36295,UNSIGNED_INT_VEC4:36296,INT_SAMPLER_2D:36298,INT_SAMPLER_3D:36299,INT_SAMPLER_CUBE:36300,INT_SAMPLER_2D_ARRAY:36303,UNSIGNED_INT_SAMPLER_2D:36306,UNSIGNED_INT_SAMPLER_3D:36307,UNSIGNED_INT_SAMPLER_CUBE:36308,UNSIGNED_INT_SAMPLER_2D_ARRAY:36311,DEPTH_COMPONENT32F:36012,DEPTH32F_STENCIL8:36013,FLOAT_32_UNSIGNED_INT_24_8_REV:36269,FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING:33296,FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE:33297,FRAMEBUFFER_ATTACHMENT_RED_SIZE:33298,FRAMEBUFFER_ATTACHMENT_GREEN_SIZE:33299,FRAMEBUFFER_ATTACHMENT_BLUE_SIZE:33300,FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE:33301,FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE:33302,FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE:33303,FRAMEBUFFER_DEFAULT:33304,UNSIGNED_INT_24_8:34042,DEPTH24_STENCIL8:35056,UNSIGNED_NORMALIZED:35863,DRAW_FRAMEBUFFER_BINDING:36006,READ_FRAMEBUFFER:36008,DRAW_FRAMEBUFFER:36009,READ_FRAMEBUFFER_BINDING:36010,RENDERBUFFER_SAMPLES:36011,FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER:36052,MAX_COLOR_ATTACHMENTS:36063,COLOR_ATTACHMENT1:36065,COLOR_ATTACHMENT2:36066,COLOR_ATTACHMENT3:36067,COLOR_ATTACHMENT4:36068,COLOR_ATTACHMENT5:36069,COLOR_ATTACHMENT6:36070,COLOR_ATTACHMENT7:36071,COLOR_ATTACHMENT8:36072,COLOR_ATTACHMENT9:36073,COLOR_ATTACHMENT10:36074,COLOR_ATTACHMENT11:36075,COLOR_ATTACHMENT12:36076,COLOR_ATTACHMENT13:36077,COLOR_ATTACHMENT14:36078,COLOR_ATTACHMENT15:36079,FRAMEBUFFER_INCOMPLETE_MULTISAMPLE:36182,MAX_SAMPLES:36183,HALF_FLOAT:5131,RG:33319,RG_INTEGER:33320,R8:33321,RG8:33323,R16F:33325,R32F:33326,RG16F:33327,RG32F:33328,R8I:33329,R8UI:33330,R16I:33331,R16UI:33332,R32I:33333,R32UI:33334,RG8I:33335,RG8UI:33336,RG16I:33337,RG16UI:33338,RG32I:33339,RG32UI:33340,VERTEX_ARRAY_BINDING:34229,R8_SNORM:36756,RG8_SNORM:36757,RGB8_SNORM:36758,RGBA8_SNORM:36759,SIGNED_NORMALIZED:36764,COPY_READ_BUFFER:36662,COPY_WRITE_BUFFER:36663,COPY_READ_BUFFER_BINDING:36662,COPY_WRITE_BUFFER_BINDING:36663,UNIFORM_BUFFER:35345,UNIFORM_BUFFER_BINDING:35368,UNIFORM_BUFFER_START:35369,UNIFORM_BUFFER_SIZE:35370,MAX_VERTEX_UNIFORM_BLOCKS:35371,MAX_FRAGMENT_UNIFORM_BLOCKS:35373,MAX_COMBINED_UNIFORM_BLOCKS:35374,MAX_UNIFORM_BUFFER_BINDINGS:35375,MAX_UNIFORM_BLOCK_SIZE:35376,MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS:35377,MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS:35379,UNIFORM_BUFFER_OFFSET_ALIGNMENT:35380,ACTIVE_UNIFORM_BLOCKS:35382,UNIFORM_TYPE:35383,UNIFORM_SIZE:35384,UNIFORM_BLOCK_INDEX:35386,UNIFORM_OFFSET:35387,UNIFORM_ARRAY_STRIDE:35388,UNIFORM_MATRIX_STRIDE:35389,UNIFORM_IS_ROW_MAJOR:35390,UNIFORM_BLOCK_BINDING:35391,UNIFORM_BLOCK_DATA_SIZE:35392,UNIFORM_BLOCK_ACTIVE_UNIFORMS:35394,UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES:35395,UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER:35396,UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER:35398,INVALID_INDEX:4294967295,MAX_VERTEX_OUTPUT_COMPONENTS:37154,MAX_FRAGMENT_INPUT_COMPONENTS:37157,MAX_SERVER_WAIT_TIMEOUT:37137,OBJECT_TYPE:37138,SYNC_CONDITION:37139,SYNC_STATUS:37140,SYNC_FLAGS:37141,SYNC_FENCE:37142,SYNC_GPU_COMMANDS_COMPLETE:37143,UNSIGNALED:37144,SIGNALED:37145,ALREADY_SIGNALED:37146,TIMEOUT_EXPIRED:37147,CONDITION_SATISFIED:37148,WAIT_FAILED:37149,SYNC_FLUSH_COMMANDS_BIT:1,VERTEX_ATTRIB_ARRAY_DIVISOR:35070,ANY_SAMPLES_PASSED:35887,ANY_SAMPLES_PASSED_CONSERVATIVE:36202,SAMPLER_BINDING:35097,RGB10_A2UI:36975,INT_2_10_10_10_REV:36255,TRANSFORM_FEEDBACK:36386,TRANSFORM_FEEDBACK_PAUSED:36387,TRANSFORM_FEEDBACK_ACTIVE:36388,TRANSFORM_FEEDBACK_BINDING:36389,COMPRESSED_R11_EAC:37488,COMPRESSED_SIGNED_R11_EAC:37489,COMPRESSED_RG11_EAC:37490,COMPRESSED_SIGNED_RG11_EAC:37491,COMPRESSED_RGB8_ETC2:37492,COMPRESSED_SRGB8_ETC2:37493,COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2:37494,COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2:37495,COMPRESSED_RGBA8_ETC2_EAC:37496,COMPRESSED_SRGB8_ALPHA8_ETC2_EAC:37497,TEXTURE_IMMUTABLE_FORMAT:37167,MAX_ELEMENT_INDEX:36203,TEXTURE_IMMUTABLE_LEVELS:33503,MAX_TEXTURE_MAX_ANISOTROPY_EXT:34047})})),define("Core/IndexDatatype",["./defined","./DeveloperError","./freezeObject","./Math","./WebGLConstants"],(function(e,t,n,r,i){"use strict";var a={UNSIGNED_BYTE:i.UNSIGNED_BYTE,UNSIGNED_SHORT:i.UNSIGNED_SHORT,UNSIGNED_INT:i.UNSIGNED_INT,getSizeInBytes:function(e){switch(e){case a.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case a.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case a.UNSIGNED_INT:return Uint32Array.BYTES_PER_ELEMENT}throw new t("indexDatatype is required and must be a valid IndexDatatype constant.")},validate:function(t){return e(t)&&(t===a.UNSIGNED_BYTE||t===a.UNSIGNED_SHORT||t===a.UNSIGNED_INT)},createTypedArray:function(n,i){if(!e(n))throw new t("numberOfVertices is required.");return n>=r.SIXTY_FOUR_KILOBYTES?new Uint32Array(i):new Uint16Array(i)},createTypedArrayFromArrayBuffer:function(n,i,a,o){if(!e(n))throw new t("numberOfVertices is required.");if(!e(i))throw new t("sourceArray is required.");if(!e(a))throw new t("byteOffset is required.");return n>=r.SIXTY_FOUR_KILOBYTES?new Uint32Array(i,a,o):new Uint16Array(i,a,o)}};return n(a)})),define("Core/Rectangle",["./Cartographic","./Check","./defaultValue","./defined","./defineProperties","./Ellipsoid","./freezeObject","./Math"],(function(e,t,n,r,i,a,o,E){"use strict";function u(e,t,r,i){this.west=n(e,0),this.south=n(t,0),this.east=n(r,0),this.north=n(i,0)}i(u.prototype,{width:{get:function(){return u.computeWidth(this)}},height:{get:function(){return u.computeHeight(this)}}}),u.packedLength=4,u.pack=function(e,r,i){return t.typeOf.object("value",e),t.defined("array",r),i=n(i,0),r[i++]=e.west,r[i++]=e.south,r[i++]=e.east,r[i]=e.north,r},u.unpack=function(e,i,a){return t.defined("array",e),i=n(i,0),r(a)||(a=new u),a.west=e[i++],a.south=e[i++],a.east=e[i++],a.north=e[i],a},u.computeWidth=function(e){t.typeOf.object("rectangle",e);var n=e.east,r=e.west;return n<r&&(n+=E.TWO_PI),n-r},u.computeHeight=function(e){return t.typeOf.object("rectangle",e),e.north-e.south},u.fromDegrees=function(e,t,i,a,o){return e=E.toRadians(n(e,0)),t=E.toRadians(n(t,0)),i=E.toRadians(n(i,0)),a=E.toRadians(n(a,0)),r(o)?(o.west=e,o.south=t,o.east=i,o.north=a,o):new u(e,t,i,a)},u.fromRadians=function(e,t,i,a,o){return r(o)?(o.west=n(e,0),o.south=n(t,0),o.east=n(i,0),o.north=n(a,0),o):new u(e,t,i,a)},u.fromCartographicArray=function(e,n){t.defined("cartographics",e);for(var i=Number.MAX_VALUE,a=-Number.MAX_VALUE,o=Number.MAX_VALUE,_=-Number.MAX_VALUE,s=Number.MAX_VALUE,c=-Number.MAX_VALUE,R=0,f=e.length;R<f;R++){var T=e[R];i=Math.min(i,T.longitude),a=Math.max(a,T.longitude),s=Math.min(s,T.latitude),c=Math.max(c,T.latitude);var A=T.longitude>=0?T.longitude:T.longitude+E.TWO_PI;o=Math.min(o,A),_=Math.max(_,A)}return a-i>_-o&&(i=o,(a=_)>E.PI&&(a-=E.TWO_PI),i>E.PI&&(i-=E.TWO_PI)),r(n)?(n.west=i,n.south=s,n.east=a,n.north=c,n):new u(i,s,a,c)},u.fromCartesianArray=function(e,i,o){t.defined("cartesians",e),i=n(i,a.WGS84);for(var _=Number.MAX_VALUE,s=-Number.MAX_VALUE,c=Number.MAX_VALUE,R=-Number.MAX_VALUE,f=Number.MAX_VALUE,T=-Number.MAX_VALUE,A=0,h=e.length;A<h;A++){var O=i.cartesianToCartographic(e[A]);_=Math.min(_,O.longitude),s=Math.max(s,O.longitude),f=Math.min(f,O.latitude),T=Math.max(T,O.latitude);var N=O.longitude>=0?O.longitude:O.longitude+E.TWO_PI;c=Math.min(c,N),R=Math.max(R,N)}return s-_>R-c&&(_=c,(s=R)>E.PI&&(s-=E.TWO_PI),_>E.PI&&(_-=E.TWO_PI)),r(o)?(o.west=_,o.south=f,o.east=s,o.north=T,o):new u(_,f,s,T)},u.clone=function(e,t){if(r(e))return r(t)?(t.west=e.west,t.south=e.south,t.east=e.east,t.north=e.north,t):new u(e.west,e.south,e.east,e.north)},u.equalsEpsilon=function(e,n,i){return t.typeOf.number("absoluteEpsilon",i),e===n||r(e)&&r(n)&&Math.abs(e.west-n.west)<=i&&Math.abs(e.south-n.south)<=i&&Math.abs(e.east-n.east)<=i&&Math.abs(e.north-n.north)<=i},u.prototype.clone=function(e){return u.clone(this,e)},u.prototype.equals=function(e){return u.equals(this,e)},u.equals=function(e,t){return e===t||r(e)&&r(t)&&e.west===t.west&&e.south===t.south&&e.east===t.east&&e.north===t.north},u.prototype.equalsEpsilon=function(e,n){return t.typeOf.number("epsilon",n),u.equalsEpsilon(this,e,n)},u.validate=function(e){t.typeOf.object("rectangle",e);var n=e.north;t.typeOf.number.greaterThanOrEquals("north",n,-E.PI_OVER_TWO),t.typeOf.number.lessThanOrEquals("north",n,E.PI_OVER_TWO);var r=e.south;t.typeOf.number.greaterThanOrEquals("south",r,-E.PI_OVER_TWO),t.typeOf.number.lessThanOrEquals("south",r,E.PI_OVER_TWO);var i=e.west;t.typeOf.number.greaterThanOrEquals("west",i,-Math.PI),t.typeOf.number.lessThanOrEquals("west",i,Math.PI);var a=e.east;t.typeOf.number.greaterThanOrEquals("east",a,-Math.PI),t.typeOf.number.lessThanOrEquals("east",a,Math.PI)},u.southwest=function(n,i){return t.typeOf.object("rectangle",n),r(i)?(i.longitude=n.west,i.latitude=n.south,i.height=0,i):new e(n.west,n.south)},u.northwest=function(n,i){return t.typeOf.object("rectangle",n),r(i)?(i.longitude=n.west,i.latitude=n.north,i.height=0,i):new e(n.west,n.north)},u.northeast=function(n,i){return t.typeOf.object("rectangle",n),r(i)?(i.longitude=n.east,i.latitude=n.north,i.height=0,i):new e(n.east,n.north)},u.southeast=function(n,i){return t.typeOf.object("rectangle",n),r(i)?(i.longitude=n.east,i.latitude=n.south,i.height=0,i):new e(n.east,n.south)},u.center=function(n,i){t.typeOf.object("rectangle",n);var a=n.east,o=n.west;a<o&&(a+=E.TWO_PI);var u=E.negativePiToPi(.5*(o+a)),_=.5*(n.south+n.north);return r(i)?(i.longitude=u,i.latitude=_,i.height=0,i):new e(u,_)},u.intersection=function(e,n,i){t.typeOf.object("rectangle",e),t.typeOf.object("otherRectangle",n);var a=e.east,o=e.west,_=n.east,s=n.west;a<o&&_>0?a+=E.TWO_PI:_<s&&a>0&&(_+=E.TWO_PI),a<o&&s<0?s+=E.TWO_PI:_<s&&o<0&&(o+=E.TWO_PI);var c=E.negativePiToPi(Math.max(o,s)),R=E.negativePiToPi(Math.min(a,_));if(!((e.west<e.east||n.west<n.east)&&R<=c)){var f=Math.max(e.south,n.south),T=Math.min(e.north,n.north);if(!(f>=T))return r(i)?(i.west=c,i.south=f,i.east=R,i.north=T,i):new u(c,f,R,T)}},u.simpleIntersection=function(e,n,i){t.typeOf.object("rectangle",e),t.typeOf.object("otherRectangle",n);var a=Math.max(e.west,n.west),o=Math.max(e.south,n.south),E=Math.min(e.east,n.east),_=Math.min(e.north,n.north);if(!(o>=_||a>=E))return r(i)?(i.west=a,i.south=o,i.east=E,i.north=_,i):new u(a,o,E,_)},u.union=function(e,n,i){t.typeOf.object("rectangle",e),t.typeOf.object("otherRectangle",n),r(i)||(i=new u);var a=e.east,o=e.west,_=n.east,s=n.west;a<o&&_>0?a+=E.TWO_PI:_<s&&a>0&&(_+=E.TWO_PI),a<o&&s<0?s+=E.TWO_PI:_<s&&o<0&&(o+=E.TWO_PI);var c=E.convertLongitudeRange(Math.min(o,s)),R=E.convertLongitudeRange(Math.max(a,_));return i.west=c,i.south=Math.min(e.south,n.south),i.east=R,i.north=Math.max(e.north,n.north),i},u.expand=function(e,n,i){return t.typeOf.object("rectangle",e),t.typeOf.object("cartographic",n),r(i)||(i=new u),i.west=Math.min(e.west,n.longitude),i.south=Math.min(e.south,n.latitude),i.east=Math.max(e.east,n.longitude),i.north=Math.max(e.north,n.latitude),i},u.contains=function(e,n){t.typeOf.object("rectangle",e),t.typeOf.object("cartographic",n);var r=n.longitude,i=n.latitude,a=e.west,o=e.east;return o<a&&(o+=E.TWO_PI,r<0&&(r+=E.TWO_PI)),(r>a||E.equalsEpsilon(r,a,E.EPSILON14))&&(r<o||E.equalsEpsilon(r,o,E.EPSILON14))&&i>=e.south&&i<=e.north};var _=new e;return u.subsample=function(e,i,o,s){t.typeOf.object("rectangle",e),i=n(i,a.WGS84),o=n(o,0),r(s)||(s=[]);var c=0,R=e.north,f=e.south,T=e.east,A=e.west,h=_;h.height=o,h.longitude=A,h.latitude=R,s[c]=i.cartographicToCartesian(h,s[c]),c++,h.longitude=T,s[c]=i.cartographicToCartesian(h,s[c]),c++,h.latitude=f,s[c]=i.cartographicToCartesian(h,s[c]),c++,h.longitude=A,s[c]=i.cartographicToCartesian(h,s[c]),c++,h.latitude=R<0?R:f>0?f:0;for(var O=1;O<8;++O)h.longitude=-Math.PI+O*E.PI_OVER_TWO,u.contains(e,h)&&(s[c]=i.cartographicToCartesian(h,s[c]),c++);return 0===h.latitude&&(h.longitude=A,s[c]=i.cartographicToCartesian(h,s[c]),c++,h.longitude=T,s[c]=i.cartographicToCartesian(h,s[c]),c++),s.length=c,s},u.MAX_VALUE=o(new u(-Math.PI,-E.PI_OVER_TWO,Math.PI,E.PI_OVER_TWO)),u})),
/**
  @license
  when.js - https://github.com/cujojs/when

  MIT License (c) copyright B Cavalier & J Hann

 * A lightweight CommonJS Promises/A and when() implementation
 * when is part of the cujo.js family of libraries (http://cujojs.com/)
 *
 * Licensed under the MIT License at:
 * http://www.opensource.org/licenses/mit-license.php
 *
 * @version 1.7.1
 */
function(e){"use strict";e("ThirdParty/when",[],(function(){var e,t;function n(e,t,n,i){return r(e).then(t,n,i)}function r(e){var t,n,u;return e instanceof i?t=e:E(e)?(n=o(),e.then((function(e){n.resolve(e)}),(function(e){n.reject(e)}),(function(e){n.progress(e)})),t=n.promise):(u=e,t=new i((function(e){try{return r(e?e(u):u)}catch(e){return a(e)}}))),t}function i(e){this.then=e}function a(e){return new i((function(t,n){try{return n?r(n(e)):a(e)}catch(e){return a(e)}}))}function o(){var e,t,n,E,u,_;return e=new i(s),t=[],n=[],E=function(e,r,i){var a,E;return a=o(),E="function"==typeof i?function(e){try{a.progress(i(e))}catch(e){a.progress(e)}}:function(e){a.progress(e)},t.push((function(t){t.then(e,r).then(a.resolve,a.reject,E)})),n.push(E),a.promise},u=function(e){return c(n,e),e},_=function(e){return e=r(e),E=e.then,_=r,u=f,c(t,e),n=t=void 0,e},{then:s,resolve:R,reject:T,progress:A,promise:e,resolver:{resolve:R,reject:T,progress:A}};function s(e,t,n){return E(e,t,n)}function R(e){return _(e)}function T(e){return _(a(e))}function A(e){return u(e)}}function E(e){return e&&"function"==typeof e.then}function u(e,t,r,i,a){return R(2,arguments),n(e,(function(e){var E,u,_,s,c,R,T,A,h,O;if(h=e.length>>>0,E=Math.max(0,Math.min(t,h)),_=[],u=h-E+1,s=[],c=o(),E)for(A=c.progress,T=function(e){s.push(e),--u||(R=T=f,c.reject(s))},R=function(e){_.push(e),--E||(R=T=f,c.resolve(_))},O=0;O<h;++O)O in e&&n(e[O],d,N,A);else c.resolve(_);return c.then(r,i,a);function N(e){T(e)}function d(e){R(e)}}))}function _(e,t,n,r){return R(1,arguments),s(e,T).then(t,n,r)}function s(e,t){return n(e,(function(e){var r,i,a,E,u,_;if(a=i=e.length>>>0,r=[],_=o(),a)for(E=function(e,i){n(e,t).then((function(e){r[i]=e,--a||_.resolve(r)}),_.reject)},u=0;u<i;u++)u in e?E(e[u],u):--a;else _.resolve(r);return _.promise}))}function c(e,t){for(var n,r=0;n=e[r++];)n(t)}function R(e,t){for(var n,r=t.length;r>e;)if(null!=(n=t[--r])&&"function"!=typeof n)throw new Error("arg "+r+" must be a function")}function f(){}function T(e){return e}return n.defer=o,n.resolve=r,n.reject=function(e){return n(e,a)},n.join=function(){return s(arguments,T)},n.all=_,n.map=s,n.reduce=function(r,i){var a=t.call(arguments,1);return n(r,(function(t){var r;return r=t.length,a[0]=function(e,t,a){return n(e,(function(e){return n(t,(function(t){return i(e,t,a,r)}))}))},e.apply(t,a)}))},n.any=function(e,t,n,r){return u(e,1,(function(e){return t?t(e[0]):e[0]}),n,r)},n.some=u,n.chain=function(e,t,r){var i=arguments.length>2;return n(e,(function(e){return e=i?r:e,t.resolve(e),e}),(function(e){return t.reject(e),a(e)}),t.progress)},n.isPromise=E,i.prototype={always:function(e,t){return this.then(e,e,t)},otherwise:function(e){return this.then(void 0,e)},yield:function(e){return this.then((function(){return e}))},spread:function(e){return this.then((function(t){return _(t,(function(t){return e.apply(void 0,t)}))}))}},t=[].slice,e=[].reduce||function(e){var t,n,r,i,a;if(a=0,i=(t=Object(this)).length>>>0,(n=arguments).length<=1)for(;;){if(a in t){r=t[a++];break}if(++a>=i)throw new TypeError}else r=n[1];for(;a<i;++a)a in t&&(r=e(r,t[a],a,t));return r},n}))}("function"==typeof define&&define.amd?define:function(e){"object"==typeof exports?module.exports=e():this.when=e()}),define("Core/formatError",["./defined"],(function(e){"use strict";return function(t){var n,r=t.name,i=t.message;n=e(r)&&e(i)?r+": "+i:t.toString();var a=t.stack;return e(a)&&(n+="\n"+a),n}})),define("Workers/createTaskProcessorWorker",["../ThirdParty/when","../Core/defaultValue","../Core/defined","../Core/formatError"],(function(e,t,n,r){"use strict";return function(i){var a;return function(o){var E=o.data,u=[],_={id:E.id,result:void 0,error:void 0};return e(function(t,n,r){try{return t(n,r)}catch(t){return e.reject(t)}}(i,E.parameters,u)).then((function(e){_.result=e})).otherwise((function(e){e instanceof Error?_.error={name:e.name,message:e.message,stack:e.stack}:_.error=e})).always((function(){n(a)||(a=t(self.webkitPostMessage,self.postMessage)),E.canTransferArrayBuffer||(u.length=0);try{a(_,u)}catch(e){_.result=void 0,_.error="postMessage failed with error: "+r(e)+"\n  with responseMessage: "+JSON.stringify(_),a(_)}}))}}})),define("Workers/createVectorTilePolylines",["../Core/AttributeCompression","../Core/Cartesian3","../Core/Cartographic","../Core/Ellipsoid","../Core/IndexDatatype","../Core/Math","../Core/Rectangle","./createTaskProcessorWorker"],(function(e,t,n,r,i,a,o,E){"use strict";var u=new n,_=new t,s=new o,c=new r,R=new t,f={min:void 0,max:void 0},T=new t,A=new t,h=new t,O=new t,N=new t;return E((function(E,d){var l=new Uint16Array(E.positions),I=new Uint16Array(E.widths),S=new Uint32Array(E.counts),M=new Uint16Array(E.batchIds);!function(e){e=new Float64Array(e);var n=0;f.min=e[n++],f.max=e[n++],o.unpack(e,n,s),n+=o.packedLength,r.unpack(e,n,c),n+=r.packedLength,t.unpack(e,n,R)}(E.packedBuffer);var p,y=c,C=R,m=function(r,i,o,E,s){var c=r.length/3,R=r.subarray(0,c),f=r.subarray(c,2*c),T=r.subarray(2*c,3*c);e.zigZagDeltaDecode(R,f,T);for(var A=new Float32Array(r.length),h=0;h<c;++h){var O=R[h],N=f[h],d=T[h],l=a.lerp(i.west,i.east,O/32767),I=a.lerp(i.south,i.north,N/32767),S=a.lerp(o,E,d/32767),M=n.fromRadians(l,I,S,u),p=s.cartographicToCartesian(M,_);t.pack(p,A,3*h)}return A}(l,s,f.min,f.max,y),U=m.length/3,P=4*U-4,F=new Float32Array(3*P),L=new Float32Array(3*P),D=new Float32Array(3*P),g=new Float32Array(2*P),b=new Uint16Array(P),B=0,w=0,v=0,x=0,G=S.length;for(p=0;p<G;++p){for(var X=S[p],j=I[p],V=M[p],q=0;q<X;++q){var H;if(0===q){var z=t.unpack(m,3*x,T),W=t.unpack(m,3*(x+1),A);H=t.subtract(z,W,h),t.add(z,H,H)}else H=t.unpack(m,3*(x+q-1),h);var Y,K=t.unpack(m,3*(x+q),O);if(q===X-1){var k=t.unpack(m,3*(x+X-1),T),Z=t.unpack(m,3*(x+X-2),A);Y=t.subtract(k,Z,N),t.add(k,Y,Y)}else Y=t.unpack(m,3*(x+q+1),N);t.subtract(H,C,H),t.subtract(K,C,K),t.subtract(Y,C,Y);for(var Q=q===X-1?2:4,J=0===q?2:0;J<Q;++J){t.pack(K,F,B),t.pack(H,L,B),t.pack(Y,D,B),B+=3;var $=J-2<0?-1:1;g[w++]=J%2*2-1,g[w++]=$*j,b[v++]=V}}x+=X}var ee=i.createTypedArray(P,6*U-6),te=0,ne=0;for(G=U-1,p=0;p<G;++p)ee[ne++]=te,ee[ne++]=te+2,ee[ne++]=te+1,ee[ne++]=te+1,ee[ne++]=te+2,ee[ne++]=te+3,te+=4;return d.push(F.buffer,L.buffer,D.buffer),d.push(g.buffer,b.buffer,ee.buffer),{indexDatatype:2===ee.BYTES_PER_ELEMENT?i.UNSIGNED_SHORT:i.UNSIGNED_INT,currentPositions:F.buffer,previousPositions:L.buffer,nextPositions:D.buffer,expandAndWidth:g.buffer,batchIds:b.buffer,indices:ee.buffer}}))}));