## Add Audit Log Entry

This step adds a record to the Ambience LogAudit collection. Note that if this step is called
when processing many records, a log entry will be added for each. You probably want to do this
once, instead of many times per flow.

### Structure
1 => 1

### Input
The fields in the input will contain information for parts of the log

### Parameters
* `Module` - the name of the module under which this event will be classified, eg "workflow", "dashboard" etc.
* `Component` - the second level of classification, eg. "main", "page3" etc.
* `Success Field` - the incoming boolean field holding the success (true) or failure (false) state. If this is left empty, then success is assumed.
* `Object Field` - the incoming string field holding the object being acted upon
* `Verb Field` - the incoming string field holding the action being taken
* `Info Field` - the optional incoming string field holding extra information about the change

### Output
The input record is passed through unchanged.

#### Notes

* A sample audit record contains standard machine, user and timestamp information along with
module, component, success, object, verb and info. A sample looks like this:

```
{
    "_id" : ObjectId("61a7d1453217e36ceb97fbee"),
    "user" : "admin",
    "when" : { <snipped> }
    "run" : 48,
    "pid" : "14833@coldrum",
    "pidMachine" : "coldrum",
    "module" : "simple-sso",
    "component" : "identity",
    "success" : true,
    "object" : "sso",
    "verb" : "Authenticated",
    "info" : "changeme@example.com"
}
```

#### See Also

* Clean Audit Log
