## Current Credentials

This step adds the current user's credentials to each incoming record.

Credentials is slightly different from roles. It includes all roles, plus the user name, 
plus the global credential `*`. This makes it suitable for configuring Row Security in ETL.
If a row is visible by all, it should be marked with `*` because all users have this credential.

### Structure
1 => 1

### Input
No input requirements

### Parameters
* `Field` - the field to set to the current user credentials array

### Output
The input record is passed through with the addition of the credentials field

#### Notes
* This step uses the current user information for the ETL activity being run. For example, when run from etl-designer
  it is the designer user. When run from scheduler, it is the owner of the trigger that fired the ETL job. When run
  from a report (via a Dataset), it is the user that rendered the report.

#### See Also

* Current Roles

* Row Security
