## Read Database Statistics

This step reads the database statistics for each collection within a MongoDB Database.

Only users with mod-lifecycle privilege can run this step.

### Structure
1 => N

### Input
There are no input requirements. However, calling this step with a stream of input records isn't useful, as the same results will 
likely be produced for each record in.

### Parameters
* `Database` - the name of the database to query. 
 
There are three special cases for the database name:

* "" (blank) will use the configured Ambience database (ambience by default)
* "-logs" will use the configured logs database (ambience-logs by default)
* "-temp" will use the configured temp database (ambience-temp by default)

All other names will use the database mappings table, preventing access to databases that are not listed there.

### Output
The output consists of one record per collection in the queried database. The statistics are taken straight from 
the database implementation - these may vary from MongoDB version to version and based on underlying configuration options.

#### Notes

* See the documentation provided by your database for these fields, they are extracted directly from the `collStats` call
  to the database and are not processed by ETL.

* Any existing fields in the incoming record are passed through to each of the output records, unless overwritten by the statistics

#### See Also
