## Set Lookup Constant

This step stores a constant in the Ambience constant list. It can overwrite existing constants or create new ones. 
A constant may be a single value, eg. 123 or "hello", or it may be a more complex 
nested object or even an array.

```
Limit = 1000
Range = {min: 20, max: 80}
Choices = ["hello", "world"]
```

See the Lookup module: Constants section for more details.

### Structure
1 => 1

### Input

Incoming records have a string field for the name and a value to use as the new constant (which will be stored as Json).

### Parameters

* `Lookup Name Field` - the field holding the lookup constant name
* `Lookup Value Field` - the field holding the lookup constant value
* `Overwrite` - if ticked an existing constant can be overwritten

### Output
Each incoming record will be passed through unchanged on success, or with an added `error` string field on failure.

#### Notes

* There is one global list, so you might choose to prefix constant names to retain distinct categories. 
  You can use the string manipulation steps for this. 

#### See Also

* Lookup Constant
 