## Array Extract Values

This step steps through an array and replaces each item with a value from inside that item. 
(For example a field in a nested document.)

Given:
```
[{"value": 1}, {"value": 2}, {"value": 3, "ignore-this": "discarded" }]
```

if we choose "value" as our value field, we get:

```
[1, 2, 3]
```

whereas if we choose "ignore-this" as our value field, we get:

```
["discarded"]
```

The other items are removed as they do not have a field "ignore-this".

### Structure
1 => 1

### Input
Records that have an array input field to be acted upon

### Parameters
* Array Field - the name of array field to modify
 
* Value Field - the name of value field in the array items to extract to the top level of the array

### Output
The incoming document with the output array field modified to hold only the contents of the value fields

#### Notes
* If the input field is not an array field or doesn't exist, then the record is passed through unchanged.

#### See Also

