## Unwind

This step deconstructs an array from each input record to output a record for each element.
Each output record is the input record with the value of the array field replaced by the element.


### Structure
1 => 0..N

### Input
Records that have an array input field to be acted upon

### Parameters
* Array Field - the field that should be unwound into elements

### Output
For each input record, the same record will be output multiple times, with each subsequent element of the array
in place of the array value


#### Notes
* If the array field does not exist, then the input record will be output

* If the array field exists, but is not an array, then the input record will be output

* If the array field is an empty array, then no record will be output

#### See Also
* MongoDB Aggregation Pipeline $unwind has similar behaviour
