## Simple Encrypt Bytes

This step encrypts binary data using Java AES/CBC/PKCS5Padding and a secret key.  It is assumed that the bytes
will be decrypted by the Simple Decrypt Bytes step as the random IV is transmitted as part of the data.

### Structure
1 ⇒ 1

### Input
* A record with a binary field and a secret string key

### Parameters
* `Bytes Field` - Field which holds the bytes to encrypt.
* `Secret Field` - Field which holds the secret key to use in encryption (a string of any length)
* `Result Field` - Field to store the encrypted binary data.

### Output
The input record with the additional result binary data where encryption was successful.

#### Notes
* The first 16 bytes of the data produced are the random Initialisation Vector for the cipher. This
  step generates a different random IV for each encryption. Therefore repeated encryption
  of the same input will produce a different output each time.

* The Secret Field can be any string - the SHA-256 hash value is used as the actual key, which is the
  correct length for the AES algorithm.

* If the data field or secret key field is missing or has an invalid type, then the incoming record
  is passed through unchanged

#### See Also

* Simple Decrypt Bytes

* Decrypt Bytes

* Encrypt Bytes
