## Binary Store Migrator

This step migrates all binary store contents in a collection to another collection.
It does this by scanning the entire document looking for objects holding "store" and "contentId" fields.
If found, and the store name matches the "fromStore", the migration will be done. The scanning includes
all nested objects and arrays, so there may be many migrations for a single record.

The output record after all migrations is written into a new collection based on the original 
name with "_Migrated" on the end.

This allows you to inspect and verify the contents before backing up the original collection (ie. rename to XX_Old)
before renaming XX_Migrated to XX.

When the toStore is AWS, the original contentId will be preserved and only the store field will be changed.

### Structure

1 => 1

### Inputs

A string field `db` holding the database name
A string field `cltn` holding the collection name
A string field `fromStore` holding the store which we are migrating away from
A string field `toStore` holding the store which we are migrating into

### Parameters

None

### Output

The record is passed through with the addition of a `success` field (boolean) and in the case of failure an error field.

#### Notes

* This step does not delete any contents from the "old" binary store location.
 
* It is expected that this step will be followed by another pass over the _Old collection (after the rename) to remove
  the now obsolete binary store contents. 
