## Read State

This step reads a value previously written to the state by `Write State` and stores it in a named field.

If the named field is empty, and the value is a record, then the value is merged over the record being processed.

The mechanism allows you to read either individual values (eg. integers, strings, even arrays) or entire objects that
have been written into the state. The state persists only for this particular job. If the chain is run by two different
users then each will have an independent state. However, avoid overusing this feature as it is effectively a "global" 
variable for your job.

### Structure
1 => 1

### Input
No requirements

### Parameters
* `Key` - the key of the value in the state.
* `Field` - the field to which the value will be assigned. This may be empty if the value is a record. 

### Output
The input record with the named field added or replaced with the value read from state. If no field is named, 
and the value is an object it will be merged with in the input record, overwriting any shared field names.

#### Notes
* If the key value does not exist, no change is made

* If the field name is empty, only records will be merged, any other kind of value will be ignored

#### See Also
* Write State
