## Date - Standardize

This step standardizes date fields to ISO format

### Structure
1 => 1

### Input
A normal record

### Parameters
 
* `Date Fields` - a list of field names (comma separated) to have date values standardized
 
* `From Date Format` - format of date stored in fields
 
* `Locale` - The locale to use in parsing the input. Default to the server locale.

### Output
The record with the columns having dates in ISO8061 format.

For instance, for input:

```json
{"title":"Red Riding Hood", "dueDate": "01/08/2019"}
```
with parameters:

```
Date Fields - dueDate
From Date Format - dd/MM/yyyy
```

will give

```json
{"title": "Red Riding Hood", "dueDate":"2019-08-01" }
```
#### Notes
* This step assumes that dates are stored as text, not as BsonDate (which should only be used for timestamps)

* If your days and months do not have leading zeros, eg. 1/1/2019 then use pattern d/M/yyyy which will
correctly handle 01/01/2019 and 1/1/2019 (and 25/12/2019 etc).

#### See Also
* Time - Standardize
* Date - Today
* Time - Now
