### Line Delimited File Field Reader

This step takes in a record containing a file location and outputs multiple records derived 
from that file content by separating at newlines.
   
### Structure

1 => N

### Input

A record containing a file location field (identified by the `File Field` parameter)

### Parameters

* `File Field` - the records to be read for the filepath

### Outputs

The input record is copied into the output multiple times, once per line of delimited text, 
including the extra fields:

* `fileName` - the name of the file being read

* `line` - the text of the line.

* `lineNo` - the number of the line in the file

#### Notes

* The default access rights only allow for reading files in `./data/in`, this can be changed in the config.

* An empty file will produce 0 records out, which will effectively stop the chain. 
There is nothing to pass on to the next step.

#### See Also

* File Reader

* File Field Reader

* Line Delimited File Field Reader
