## JDBC Reader

This step performs the reading from JDBC, based on values passed in from incoming records.

The step expects to receive SQL with each incoming record, which will be executed and the results
will be output to the next step in the chain.

### Structure
1 => 0..N

### Input
Each input record should contain the information supplied by JDBC Definition, in other words:

* `pool` (string), 
* `sql` (string), 
* `parameters` (nested document), 
* `base` (nested document). 
 
You can use JDBC Definition to configure these, or derive them yourself.

### Parameters
* `Preserve Nulls` - By default any nulls received will be dropped, so the field will not exist. By preserving nulls,
a null value will be inserted instead.

### Output

The results of running the query. Each record will be merged over the `base` document passed as input, allowing you
to retain information from upstream. Of course, there may be no results, if the query returns no records.

### Notes

See the JDBC Definition step for examples of what information this step requires - you can run that on its own to
see how the output is structured - which is what this step is expecting as input.

### See Also

* JDBC Definition
