## JWT Decoder

This step decodes a string field holding a JWT token in the form <header>.<claims>\[.<signature>\].

The algorithm used is determined from the header. The correct secret/public key (if required) needs 
to be provided in the record, either in string or binary form.

### Structure
1 ⇒ 1

### Input
A record with a JWT string field and optionally a secret/private key field

### Parameters
* `Secret Field` - The field holding the string or bytes from which the secret or private key can be extracted.

* `JWT Field` - The field holding the JWT string for decoding
  
* `Output Field` = The field into which the decoded claims will be written - this will be a nested object.

### Output
The incoming record is passed through with the addition of the `Output Field` being set to the decoded claims.

#### Notes
* With HMAC algorithms, like HS256, a string can be used as a secret key to encode/decode the JWT. 
  Alternatively you can pass in bytes which are expected to be an AES SecretKeySpec.
 
* With Asymmetric algorithms, like RS256, the code will accept a string or bytes representing a public key
  in RSA X509EncodedKeySpec form. This is often the contents of a file starting: "-----BEGIN PUBLIC KEY-----"

#### See Also

* JWT Encoder
