## Line Delimited JSON Reader

This step reads incoming `bytes` - typically data loaded from disk and separates the content at newlines.
It then parses each line as a JSON object and emits one record per JSON object extracted.

### Structure
1 ⇒ 0..N

### Input
A record with a `bytes` binary field

### Parameters

None

### Output
The output is built entirely from the records parsed from the `bytes` incoming.

#### Notes
* If there is no `bytes` binary field, then the input is passed through unchanged.

* If there is a `bytes` binary field, but it isn't valid JSON, an exception is raised and the chain stops.

* The difference between this step and JSON Reader is that JSON Reader has to parse the entire 'bytes' 
  before emitting anything - to ensure the `[` and `]` are seen. The Line Delimited version can emit a record
  as soon as a newline is encountered. Note that this means an error might be seen later in the JSON, 
  after a number of successful records have already been processed. With JSON Reader all is parsed first, so 
  no records will be emitted if there is an error anywhere in the JSON array. 

#### See Also

* JSON Reader

* Line Delimited JSON Writer
