## JSON Reader

This step reads incoming `bytes` - typically data loaded from disk and parses it as a JSON array or object.
An array begins with `[` whereas a record begins with `{`.

If the bytes holds a JSON array, then multiple records are written out, one per array item.
If the bytes holds a JSON object, then a single record is written out.

The incoming record is merged into each output record based on `Merge Order`

### Structure
1 ⇒ 1..N

### Input
A record with a `bytes` binary field

### Parameters
* `Merge Order` = Keep only bytes - discards incoming record data and outputs only the JSON extracted from `bytes` 

* `Merge Order` = Bytes overrides upstream - merge each record in this JSON
  on top of the incoming record, overwriting those fields with the same name
  with the copy in this JSON. The `bytes` field is removed.

* `Merge Order` = Upstream overrides bytes - merge each the upstream record over each record in the
  extracted JSON. The `bytes` field is removed.

### Output
The output is built by combining the upstream records with the extracted JSON according to `Merge Order`.

#### Notes
* In all successful cases, the `bytes` binary data is removed to minimise RAM use.

* If there is no `bytes` binary field, then the input is passed through unchanged.

* If there is a `bytes` binary field, but it isn't valid JSON, an error is logged and no records are emitted.

#### See Also

* JSON String Reader
 