## Layout Content

This step applies a layout to each record that passes through. Collecting all records and 
finally producing a single record out which holds the structured report. 

Each record should typically have a string field called "band" which identifies which band of the layout
should be applied to this particular record. Any records that don't have a band field (or a band 
field that is not a string) will be ignored.
 
This logic allows an equivalent to "render-if" - a record that has no band field will not be rendered.

### Structure
N => 1

### Input
No requirements

### Parameters
* `Layout` - the layout to apply to turn incoming records into a structured report

### Output
A single record holding the report structure, which can then be passed to Render PDF, Render HTML etc.

#### Notes
* Because this is an N=>1 step, if you want to run it to produce multiple reports within a single job
you should separate this out into another chain, so it will be called once for each report. Otherwise
all report records will be concatenated into a single report output.

#### See Also
* Render HTML
* Render PDF
* Render to Mime-Type
