## MongoDB Skip/Limit

This step is a helper to construct a MongoDB aggregation. It is usually used after an Aggregation Definition Step
to introduce a skip and/or limit into the aggregation more easily than via string substitutions.

### Structure
1 => 1

### Input
The input is expected to contain an `aggregation` field holding a valid JSON "\[...\]" aggregation as a String. 
If this isn't found, then an empty "\[\]" will be used instead.

### Parameters

* `Skip Field` - the field holding the integer to insert as a "$skip" step (optional)

* `Limit Field` - the field holding the integer to insert as a "$limit" step (optional)

### Output
A single output record for each input record containing an updated aggregation pipeline (string).

#### Notes
* This step just builds/updates the aggregation field based on the skip and/or limit criteria, if available

* If a skip or limit field name is empty, or the field is missing or the value is not an integer, 
  that step will not be inserted.

* Only non-negative numbers are allowed, negative values will be skipped as if they don't exist.

* Both Integers (BsonInt32) and Long (BsonInt64) values are supported.

* This step is usually followed by the MongoDB Reader which does the work, however other steps may be
  added in between to further customise the structure.

* The aggregation is a string rather than an actual array because MongoDB cannot store aggregation
  pipelines because they have field names beginning with $ which is disallowed.

#### See Also

* MongoDB Aggregation Definition
 
* MongoDB Aggregation Match
