## MongoDB Create Index (Field)

This step creates an index in a MongoDB collection. In this step the collection name is read from a field
from each incoming record.  

### Structure
1 => 1

### Input
Each input record should contain a string field holding the name of a collection

### Parameters

* `Database` - the MongoDB database holding the collection

* `Collection Field` - the name of the string field to read the collection name from

* `Index JSON` - the structure of the index to add (see MongoDB documentation)

* `Options` - the index options (see Notes below and MongoDB documentation)


### Output

All records are passed through unchanged 

#### Notes

The Options record can contain:
* background (boolean)
* unique (boolean)
* name(string)
* sparse(boolean)
* expireAfterSeconds (long)
* version (int)
* weights (nested object)
* defaultLanguage (string)
* languageOverride (string)
* textVersion (int)
* bits (int)
* min (double)
* max (double)
* bucketSize (double)
* storageEngine (nested object)
* partialFilterExpression (nested object)
* collation (nested object)

#### See Also

* MongoDB Create Index (Once)
