## MongoDB Definition

This step is a helper to construct the correct record structure for configuring a MongoDB Reader.
It does not perform the read, it just defines one (providing a chooser for selection etc.). 
You can still add other steps after which manipulate the definition, eg. to make the collection name dynamic.

### Structure
1 => 1

### Input
Any record structure allowed

### Parameters

* `Database` - the MongoDB database holding the collection to read from

* `Collection` - the collection to read

* `Query` - the query filter applied to the read

* `Base JSON` - the structure onto which each record will be merged. 
  This is useful to provide default values where certain records may be missing some fields.


### Output
A single output record for each input record containing:

* `pool` - the name of the MongoDB database

* `collection` - the name of the collection

* `query` - the string holding the query string (optional)

* `base` - the default structure onto which each record read will be merged (empty by default)

#### Notes
* This step just constructs the four fields based on choices made in the dialog

* This step is usually followed by the MongoDB Reader which does the work, however other steps may be 
  added in between to customise the structure.

#### See Also

* MongoDB Aggregation Definition
