## MongoDB Delete All (Once)

This step deletes all MongoDB records in a collection.  The records should only be deleted once, but may be
used within a chain which iterates through multiple records. Therefore, the deletes are constrained
to only happen when the first incoming record is received, before that record is passed on.

If no records are received, the deletes occur when the upstream record flow terminates.

### Structure
1 => 1

### Input

No input requirements

### Parameters

* `Database` - the MongoDB database holding the collection to update

* `Collection` - the collection to delete all records from

### Output

Incoming records are passed through unchanged

#### Notes
* This step deletes records from a collection - it does not drop the collection, 
  so any existing index definitions are retained

#### See Also

* MongoDB Delete All (Field)

* MongoDB Delete Where
