## MongoDB Encrypt

This step encrypts selected fields in all MongoDB records in a collection. 
Only string fields can be encrypted.

### Structure
1 => 1

### Input

The incoming record supplies a collection name, an array of fields and a secret string to use as the encryption key.

### Parameters

* `Database` - the MongoDB database holding the collection to update

* `Collection Field` - the field holding the name of the collection to act on

* `Fields Array` - the field holding an array of strings, which are the field names to encrypt

* `Secret Field` - the field holding the secret string to use as the encryption key

### Output

A single record is output holding the count of records processed and the elapsed time in milliseconds.

#### Notes
* Only string fields can be encrypted
 
* Any missing fields are silently ignored

* A new field _elxEncrypted holding the timestamp at which the operation started is added to each record (same value for every record).

* The value in the secret field can be an {enc:...} encrypted secret from the Secrets API

#### See Also

* MongoDB Decrypt
