## MongoDB TeeWriter

This step writes records into MongoDB, passing them through unchanged to later steps 

### Structure
1 => 1

### Input
Any record structure allowed 

### Parameters

* `Database` - the MongoDB database holding the collection to update

* `Collection` - the collection to update
 
* `Preserve _id` - whether to preserve _id, or move to originalId

### Output
Each input record is passed through unchanged

#### Notes
* The caller must ensure that any fields defined as unique (like _id) are indeed unique. 

* Any fields that begin with dollar sign ($) will be converted. For example "$name" will become <dollar>name, to meet MongoDB field
naming requirements. 

* Any fields that contain a dot (.) will be converted. For example "my.name" will become my<dot>name, to meet MongoDB field requirements.

* Any changes to field names are only for MongoDB storage - they do not affect the records passed to later steps

* If Preserve _id is ticked you need to consider duplicate key errors. Writing the same record
  multiple times will fail because the _id must be unique. To prevent this, preserve _id is turned off
  by default and the original _id will be preserved as originalId, which does not have to be unique 
  (and a new random _id will be generated). 

* Duplicate key errors will be recorded in the job log, but the chain will still proceed.
  Those records with duplicate keys will not be stored in MongoDB, but will continue to pass through
  to later steps.

#### See Also
* MongoDB Updater

* MongoDB Writer
