## MongoDB Writer

This step writes records into MongoDB, outputting a single record summary at the end 

### Structure
N => 1

### Input
Any record structure allowed 

### Parameters

* `Database` - the MongoDB database holding the collection to update

* `Collection` - the collection to update

* `Batch Size` - the number of documents to batch into a single insert
 

### Output
A single record containing: 

* `elapsedTime` - how long the step took to run from the first to last document processed

* `count` - how many records were updated

#### Notes
* The caller must ensure that any fields defined as unique (like _id) are indeed unique. 

* Any fields that begin with dollar sign ($) will be converted. For example "$name" will become <dollar>name, to meet MongoDB field
naming requirements. 

* Any fields that contain a dot (.) will be converted. For example "my.name" will become my<dot>name, to meet MongoDB field requirements. 

#### See Also
* MongoDB Updater

* MongoDB TeeWriter

* MongoDB Writer Field
