## Daemon MQTT Reader

This step is a variant of the MQTT Reader, designed to work with the ETL Daemon mechanism,
allowing control over cancelling and stopping the chain efficiently from the ETL Daemon module.

This step reads messages from a MQTT broker.

### Structure
1 => N

### Input

No special incoming requirements

### Parameters

* `Broker` - the URL of the MQTT broker to read from. This will be either a tcp: or ssl: URL

* `Topic` - the topic to read messages from.

* `QOS` - Quality of service: At most once, At least once, exactly once.

* `Message Arrived Complete` - When to fire completion: On Arrival, Chain End.
 
### Output

On success, the incoming record is passed through once per message received with additional fields added:

* `bytes` (BsonBinary) - the message payload
 
* `topic` (BsonString) - the topic that has been read 

* `msgId` (BsonInt32) - the message id

* `msgQos` (BsonInt32) - Quality of service: At most once, At least once, exactly once.

### Notes

* The session id for the MQTT Broker is set to the value of the elx-daemonId passed in via the ETLDaemon Signature step

* You can follow this step with `Take First Records` to limit how many are read, 
  else it will continue to read forever. 

### See Also

* MQTT Reader

* MQTT Writer

* ETLDaemon Signature
 