## Render to Image

This step extracts pages from a PDF file held in a field called `bytes` and renders them as a series of output records,
each replacing `bytes` with an image of a page.

### Structure
1 ⇒ N

### Input
* The field `bytes` is required - the pdf data


### Parameters
* `Pages` - The comma-separated list of pages (1-based) to be rendered. Leave this blank to render all pages.

* `DPI` - the dots-per-inch resolution of the image (default 72 DPI)

### Output
A series of records, each corresponding to one requested image - the `bytes` field being replaced by the image of that page.
An additional field is added: `page`, holding the page number of that image.

### Notes

* All other fields, except bytes and mimeType pass through unchanged.

### See Also

* Render to TIFF
* Render Page to Image
