## Get Queue Result

This step queries the result of a request given the queueId. If the request has not finished
(ie. the status is not Replied or Completed - see Get Queue Status) no result is available.

### Structure
1 ⇒ 1

### Input
* A queueId is required

### Parameters

* `QueueId Field` - the string field holding the queueId

* `Result Field` - the field to hold the returned result document

### Output

The input record with a result field added, if a result is available.

### Notes

* The incoming record will not be modified if the queueId is not valid or no result is available.
 
* It is often better to include the continuation logic within an ETL chain as part of the request.
  For example, to render a report, use an ETL chain to control the rendering and then the emailing
  of the result (or a link to the result) to a user, rather than try to fetch the report via this 
  step, which would likely require polling which is a burden on system resources. 

### See Also

* Add to Queue 
 
* Get Queue Status
