## File Field Writer

This step takes records with a byte array named `bytes` along with a file location 
and writes the bytes to that location. 

If the record also contains an array named `acl` in this format:

```
 [
    { "by" : "role-63772cfcee6e483c24fe3127", "write" : false },
    { "by" : "user-63472cfcee6e483c24fe3122", "write" : true }
 ]
```
the new ACL will be applied to the created file. The `by` field must consist of either "user-" or "role-"
followed by the userId or roleId. Any items that don't follow this format will be discarded.

### Structure

1 => 1

### Inputs

`bytes` to be written to the file and a field (named by parameter `Field`) containing the target file location

`acl` (optional) the access control list for the new file

### Parameters

* `Field` - The location of the file to be written

### Output

* `_error` - This string field will be added if the operation fails, with details of the issue

On success, the record is passed through unchanged. As a side-effect the bytes have been written to disk.

#### Notes

* The existing repository access rights will determine whether the file can be written.

* If two records have the same file location, the bytes from the second record will overwrite those of the first.

* Any access control list defined by this step is constrained by parent access controls. For example, you can 
  give a user permission to read the file, but if they can't read the parent folder(s) then this file still 
  cannot be seen by the user.

#### See Also

* File Writer
