## S3 Get

This step reads bytes from AWS S3

### Structure
1 => 1

### Input

Each incoming record should contain a path to read.

### Parameters

* `Bucket` - the name of the bucket information to use from System Settings AWS Integration.

* `Path Field` - the incoming string field holding the path to be appended to the bucket path.

### Output

The incoming record with additional fields:

* `bytes` - The binary data loaded from S3

* `length` - The number of bytes loaded from S3
 
* `mimeType` - The mimeType of the bytes (application/octet-stream if unknown)

If the request fails, then an `error` string is added instead

### Notes

* The bucket path and incoming path strings are directly concatenated. If you need a separator slash you should put it
  on the end of the bucket path or on the start of the incoming path string (but not both!).

### See Also

* S3 Delete
 
* S3 List
 
* S3 Put
