## S3 List

This step lists the contents of an AWS S3 bucket location

### Structure
1 => N

### Input

Each incoming record should contain a path to read.

### Parameters

* `Bucket` - the name of the bucket information to use from System Settings AWS Integration.

* `Path Field` - the incoming string field holding the path to be appended to the bucket path.

### Output

The incoming record is returned once for each child of the requested path, with additional fields:

* `name` - The name of the S3 content

* `length` - The size in bytes of the S3 content
 
* `lastModified` - The last modified timestamp of the S3 content (as a BsonDateTime)

If the request fails, then an `error` string is added instead

### Notes

* The bucket path and incoming path strings are directly concatenated. If you need a separator slash you should put it
  on the end of the bucket path or on the start of the incoming path string (but not both!).

* If the combined path is an empty folder then this step can return 0 records, which means 
  downstream steps will not run

### See Also

* S3 Delete

* S3 Get

* S3 Put
