## Dataset Field Reader

This step passes each incoming record as a set of parameters to a Dataset identified by `Dataset Field`
and passes the results of running the Dataset as the output. The original
incoming record is used as a base for the output, so parameters get passed through
as well, unless overwritten by Dataset output that happens to have the same field name.

### Structure
1 ⇒ 0..N

### Input
A record containing a string field named by `Dataset Field`

### Parameters
* `Dataset Field` - The field which identifies the Dataset that will be called to provide the results

### Output
The results of executing the dataset (0..N records) each one merged onto the original 
input record that was used as the parameters (ensuring parameters are still accessible downstream).

#### Notes
* If a record does not have a string field which matches `Dataset Field` then that record will be passed
through unchanged. It can be a useful pattern to expand some records and retain others. An info message
will be recorded the first time this happens in a flow, which is useful for diagnostics, but not for 
every subsequent record, as this could lead to huge logs.

* Be careful not to construct circular references. It is possible to construct an ETL, wrapped
as a Dataset which calls itself, resulting in an endless loop.

#### See Also
* Dataset Reader
