## Remove Suffix

This step removes a fixed suffix from the end of a string field.

### Structure
1 => 1

### Input
A string field is required in the input record

### Parameters
* `Field` - the string field to be modified. 
* `Suffix` - the string to be removed at the end of the current field value.

### Output
The input record with the named field modified to remove the given suffix, if it exists

#### Notes
* If the field value is not a string or does not exist, no change is made

* If the field value does not end in the expected suffix, no change is made

* Because ETL data entry fields are trimmed any whitespace at the beginning 
or end of the suffix will be removed. You cannot use this step to remove a suffix which
begins or ends with whitespace.

#### See Also
* Add Prefix
* Add Suffix
* Remove Prefix
