## Replace RegEx

This step modifies a string field in-place by replacing text that matches `RegEx` with `Value` strings.

### Structure
1 => 1

### Input
A string field is required in the input record

### Parameters
* `Field` - The string field to modify
* `RegEx` - The substring to remove
* `Value` - The replacement string to insert in place of `RegEx` matches. The replacement can include group 
indexes from the regular expression, eg $1 is the first matching group.

### Output
The input record with the string field with text replaced

### Example

| F1 |
|----|
|This is a sample string|
|This is a simple string|

With `Field`="F1", `RegEx`="(s\[ia\]mple)", `Value`="demo $1 result", the output is:

| F1 |
|----|
|This is a demo sample result string|
|This is a demo simple result string|

#### Notes
* If the field value is not a string or does not exist, no change is made

#### See Also
* Replace
