## Add Fields

This step adds additional fields to a record, potentially producing multiple output records.

For each incoming record, the new structure is built (just like Restructure) and merged onto the original record. 
Unlike Restructure, this preserves the original record fields (unless overwritten by the new structure).

### Structure
1 => N

### Input
No special requirements

### Parameters
* `New Structure` - The new structure to output for each incoming record, with values starting with "$" substituted
  from the incoming record.

### Output
The new structure built from each incoming record merged on top of the incoming record.

#### Notes
* Prefer this over Restructure for future-proof steps if you want all upstream fields to pass through by default.
There is no need to include  "sample": "$sample"  for all fields you want to pass through. 

* Fields included in New Structure will overwrite any from upstream with the same name.

* Defining a substitution like "newName": "$oldName" does not mean that oldName is necessarily a string field - the field
  value can be of any type.

#### See Also
* Restructure

* Add Fields (Field)
