## Chain to Array

This step can call another chain for every record received, passing that
record as the parameters to the called chain.

In this step, the name of the called chain is fixed, so each record will 
invoke the same chain. This allows reusable "sub-chains" to be created
and then called in the same way that functions are used in programming.
Calling a chain is like calling a function or subroutine - the results 
of the called chain then continue as records in the main flow.

### Structure
1 => 1

### Input
Each input record is passed as parameters to the called chain, which may 
extract the fields it needs. The called chain decides whether any input
fields are returned at the end of the called chain.

### Parameters
* Chain Name - The name of the chain that will be called for each 
incoming record.

* Array Field - The field which will hold the results (an array) of the
called chain.

### Output
For each record in, 

* if a chain name is specified and is valid, the output will be
the same as the input with one more field - the Array Field (named by the Parameter)
which will hold the results of running the named chain with the input record as parameter.

* if no chain name is specified the record is passed through unchanged

* if the chain name is invalid an error is raised

#### Notes
* The called chain may produce no output, in which case the Array Name 
field will hold an empty array. It may produce a single record or multiple records. 
In every case, the Array Name field will produce an array. Hence this is a 1:1 step - 
for every record in, there will be exactly one record out.


#### See Also
* Chain Call
* Chain Call Field
