## Chain to This

This step can call another chain for every record received, passing that
record as the parameters to the called chain.

In this step, the name of the called chain is fixed, so each record will 
invoke the same chain. This allows reusable "sub-chains" to be created
and then called in the same way that functions are used in programming.

Unlike Chain Call, this step separates each record as a request into a new chain.
Chain Call streams the input records into the same chain. In Chain to This, each record is passed through as distinct call to the chain.
In Chain Call, all records are passed through as a streamed call to the chain.
 
This means in Chain to This, the result is available after each input record, not after a whole set of input records. 
This affects how functions like average work.
Average over a subset (Chain to This), versus average over all (Chain Call). 

Unlike Chain Call, this step preserves the input record in the output, merging the output 
of the called chain into each document. In this sense it is similar to a join. Because this step is
structured around individual record processing, the result is merged into "this" record, rather than forming 
a new record to pass on.

### Structure
1 => 0..N

### Input
Each input record is passed as parameters to the called chain, which may 
extract the fields it needs. The called chain result is merged into the input record at the end, hence it may
overwrite input fields. The chain does not need to preserve the input fields (unlike Chain Call) which can be
hard to achieve, eg. in N=>1 steps.

### Parameters
* Chain Name - The name of the chain that will be called for each 
incoming record.

### Output
For each record in, 

* if a chain name is specified and is valid, the output will be
input merged with each record of the results of running the named chain with the input record as parameter.

* if no chain name is specified the record is passed through unchanged

* if the chain name is invalid an error is raised

#### Notes
* Use this step to avoid duplicating long chains and to provide more 
maintainable chainsets by breaking long sequences down into logical groups.

* If the called chain produces 5 records, there will be five copies of the input record passed through, each
merged with one of the called chain output records.

* If the called chain produces 0 records, there will be no input record passed through. 


#### See Also
* Chain Call
* Chain Call Field
* Chain to Array
