## Chain Call Group

This step can call another chain for every record received, passing that
record as the parameters to the called chain.

In this step, the name of the called chain is fixed, so each record will 
invoke the same chain. This allows reusable "sub-chains" to be created
and then called in the same way that functions are used in programming.

Unlike Chain Call, this step separates each group of consecutive records
(based on a group field) as a request into a new chain.
 
This means in Chain Call Group, any N=>1 steps will see a group as input, unlike Chain Call
which will see all of the records and Chain to This which will see only a single record per call.

This step preserves the group field in the output.

### Structure
N => 0..M

### Input
Each input record is passed as parameters to the called chain, which may 
extract the fields it needs. The called chain result is merged into the input record at the end, hence it may
overwrite input fields. 

### Parameters
* Chain Name - The name of the chain that will be called for each incoming group.

* Group Field - The name of the field used for grouping batches of records to send to the chain

### Output

* output records will be the concatenation of calling the chain with each input group.

* The group field will be added to each output (which may be zero to many records)

* if the chain name is invalid an error is raised

#### Notes
* Unless your called chain uses N=>1 steps, this step will behave almost the same as Chain Call and 
Chain to This (there will be differences in what fields can be output, but the overall flow and count 
will be the same).

* If the called chain produces 0 records, there will be no record passed through. 


#### See Also
* Chain Call
* Chain Call Field
* Chain to Array
