## Chain Concat

This step calls one or more chains, concatenating the results into one output.
Where there is only one chain listed, this step behaves like Chain Call.

Calling a chain is like calling a function or subroutine - the results 
of the called chain then continue as records in the main flow. For each incoming record, 
the named chains are called in order (with the same incoming record as the parameters) 
and the results concatenated into the output. 
The next incoming record is then processed in the same way until all input has been used.  

### Structure
1 => 0..N

### Input
Each input record is passed as parameters to every called chain, which may 
extract the fields it needs. The called chain decides whether any input
fields are returned at the end of the called chain.

### Parameters
* Chain Names - The list of chains that will be called for each 
incoming record.

### Output
For each record in, 

for each chain name listed,

* if a chain name is specified and is valid, the output will be
the results of running the named chain with the input record as parameter.

* if no chain name is specified the record is passed through unchanged

* if the chain name is invalid the chain will be skipped

#### Notes
* Use this step to logically separate individual sections of logic for later concatenation. The original example
is to build a set of fragments for multiple dashboard views to update via polling. Therefore each called chain
is responsible for defining the fragments for a single view, and all chains are then concatenated to produce the
full list of fragments to send to the dashboard.

#### See Also

* Chain Call

* Chain Call Field

* Chain to Array
