## Chain Lock

This step attempts to acquire a lock which can be used to prevent concurrent access to resources. 
For each record received, the step will attempt to acquire the lock. If it succeeds then it runs 
another chain and passes the results of that chain through to the output. Each record will include the value "locked": true.
If it fails to obtain the lock, then the original record is passed on, with value "locked": false

### Structure
1 => N

### Input
Any record can be passed in, it will be used as the parameters for calling the named chain, if the lock is acquired

### Parameters
* `Lock Name` - the name of the lock - for each unique name, only one Chain Lock step will be able to acquire the lock.

* `Chain Name` - the name of the chain to run if the lock is acquired successfully

### Output
In the case of a successful lock, the output will be the results of each chain call with `locked` true.
In the case of a failed lock, because the lock has already been taken, the output will be the input record, with `locked` false.

#### Notes
* The current implementation uses a lockfile on disk. The step will fail if the lock file cannot be created due to invalid characters in the filename

* Because this implementation uses a lockfile on disk, it is not usable in a clustered environment where different jobs may run on different 
machines (with different filesystems).

#### See Also
* Chain Call

