## Flat Concatenate

This step takes list of fields and combines them into a single result array. 
If any of the fields are themselves arrays, the items are themselves concatenated into the result. 

```
{"a": [1,2,3], "b": 4, "c": [5,6], "e": 7}

FlatConcat "a,b,c,d,e"  to "f" will give:

{"a": [1,2,3], "b": 4, "c": [5,6], "e": 7, "f": [1,2,3,4,5,6,7]}

```
Note that it doesn't matter there is no field "d".

### Structure
1 => 1

### Input
No input requuirements

### Parameters
* Fields - The list of fields (comma-separated) to be read and concatenated into the result array

* Result Field - the name of the array field to be produced

### Output
The input record with a new array field holding the results of concatenating the input fields. The input fields are not changed or removed.

#### Notes
* This step skips any missing input fields, and concatenates what remains, in the order they are listed.

* This is a "flat" operation, because any arrays identified are expanded into a single array result.

#### See Also
* Merge Sub-Documents
* Chain to Array
* Array Unwind

