## Rename Field

This step renames a field. 

In the simplest case, field idx: 1 could be renamed to index: 1 by setting `From`: idx, To: `index`.
The old name is removed and the new name with the old value is added.

However, rename also has more dynamic capabilities. By identifying a field with a dollar ($) prefix,
you can identify the From and To names from other parts of the record.

``
{ "idx": 1, "ReadFrom": "idx", "WriteTo": "index" }
`` 
Given From: `$ReadFrom` and To: `$WriteTo` the replace step will look up the from field in
string ReadFrom, and the to field in WriteTo and then rename idx into index.

This dynamic ability means you can determine on a per-record basis which fields get renamed.

### Structure
1 => 1

### Input
No special requirements

### Parameters
* `From` - The field to rename from, or with a $ prefix the field that holds the from name.

* `To` - The field to rename to, or with a $ prefix the field that holds the to name.

### Output
The input record with the identified field renamed.

#### Notes
* If the input field does not exist the output record is unchanged

* If the output field already exists it will be overwritten

#### See Also
* Restructure
