## Add Tasks

This step adds a task (with potentially many subtasks) into an existing Task List. This is particularly useful
for scheduling recurring tasks - eg. a regular sprint cycle sequence, a standard test plan etc.

### Structure
1 => 1

### Input

Each incoming record should contain a Task List id/name to hold the new task, 
an optional parentId (if the task is not at the top level) and a task field holding a (potentially nested)
task definition.

The task definition structure is:

```
{ 
  "name": <a string>,         -- required
  "description": <a string>,  -- optional
  "assignedTo": <a string>,   -- optional, the current user if not defined or blank
  "dueDate": <a string>,      -- optional, may include +3d syntax for "three days from now"
  "children": [ nested task definitions ] -- optional
}
```

### Parameters

* `Task List Field` - a string field holding either the id or the name of the Task List to add to

* `Parent Field` - a string field holding the parentId within the Task List to add to (leave this blank for top-level)

* `Task Field` - a nested document holding the task tree to be added, following the task definition structure.

### Output

On success, the incoming record is passed through with a `taskId` added, holding the id of the highest level task added.

### Notes

* Combine with other steps, eg. String Substitution on Json to parameterise user roles. 
  Json String Writer + String Substitute + Json String Reader are useful for this.  

### See Also

