## Archive Finished Tasks

This step adds archives tasks with Completed or Cancelled status from the "ongoing" task list into an archive.

The end result is two task lists, a current one with ongoing tasks and an archived one with Completed/Cancelled tasks.

The structure is preserved, so where children are completed, a parent may not be completed. The parent exists both
in the archived set (as a structural holder of children) and in the ongoing list. These are separate records, so 
a subsequent change to the parent in the ongoing list will not affect the snapshot in the archived task list.

The intention is that the archiving will typically happen monthly, so the archive is given the name 
<original>-Archive-YYYY-MM using the previous month. Therefore if you run this at the start of a month, all
Completed/Cancelled tasks are archived to keep your ongoing task list smaller.

### Structure
1 => 1

### Input

Each incoming record should contain a Task List name, which is the list to perform archiving on

### Parameters

* `Task List Field` - a string field holding either the id or the name of the Task List to add to

### Output

On success, the number of tasks archived is included in the output as `archiveCount`.

### Notes

If a Task list archive already exists with the same name (eg. XXX-Archive-YYYY-MM) then an archiveError
message is included in the output, and no changes are made.

### See Also
