## Task From Mail Thread

This step adds a task based on an incoming (deconstructed) mail message.
Use the Deconstruct Mail step first, to ensure the HTML has been properly structured for this step to read.
This step tries to reconstruct email threads based on a prefix and counter, adding any replies with matching subject tags 
to existing tasks where possible.

The subject tag is in this format: "<prefix-year-counter>" for example <Elx-2024-0023> The counter is padded to 4 digits
and is managed internally, one counter per Task List.

The return includes information such as the subject tag which has been prefixed on to the message, so that you can
notify the sender that the message has been received and add the prefix to the reply, so that further replies will be threaded.

Be careful to check the `existingThread` value though - you don't want to notify every time a threaded comment is added
and you don't want to keep appending the same prefix over and over again.


### Structure
1 => 1

### Input

Each incoming record should contain fields necessary to configure the added Task, as described in Parameters below.

### Parameters

* `Task List Field` - a string field holding either the id or the name of the Task List to add to

* `Assign To Field` - a string field holding the user name for task assignment (if empty, the task will be assigned to 
  the user running the ETL)

* `Due Date Field` - a string field holding the due date for this task. This string field can use "+3d" syntax for relative dates.

* `Prefix Field` - a string field holding a prefix to use when building unique tags. 

### Output

On success, the incoming record is passed through with: 
 
* `taskId` holding the id of the task. This may be an existing task, or a new task, depending on whether the subject tag is matched

* `subjectPrefix` holding the subject tag that was either found, or else added to the incoming message

* `existingThread` holding a boolean indicating whether this is a new task, or a threaded comment for an existing task
 
### Notes

* This step will add attachments to the configured binary store for tasks, just like adding via the UI  

### See Also

* Task From Mail