## Time Extract Component

This step extracts a component from a time field

### Structure
1 => 1

### Input
Any record with a BsonDateTime field

### Parameters
* `Time Field` - The field containing the time field

* `Extract` - The Component to Extract

* `Output Field` - The field to extract to

#### The following components are supported:
* `Hour (Military)` - Extracts hour in 24H format
* `Hour (Clock)` - Extracts hour as shown on an analog clock
* `Minutes` - Extracts Minutes
* `Seconds` - Extracts Seconds
* `AM/PM` - Extracts `AM` or `PM`

### Output
For timestamp `2019-02-29 15:30:00`, the extractions are shown below:

<table>
<tr><th>Component</th><th>Extracted Value</th><th>Column Type</th></tr>
<tr><td>Hour (Military)</td><td>15</td><td>Int</td></tr>
<tr><td>Hour (Clock)</td><td>3</td><td>Int</td></tr>
<tr><td>Minutes</td><td>30</td><td>Int</td></tr>
<tr><td>Seconds</td><td>0</td><td>Int</td></tr>
<tr><td>AM/PM</td><td>PM</td><td>String</td></tr>
</table>

#### Notes
* Invalid values will not generate anything
* If `Time Field` is identical to `Output Field` the value will be replaced

#### See Also
* Date - Extract Component
* Timestamp - Extract Component
