## Extract with TimeZone Field
This step takes a BSON timestamp and extracts it using an input zoneId into its component units of time.

### Structure
1 => 1

### Input
a record with a BsonDateTime

### Parameters
* `From Field` - the field containing the timestamp.

* `Zone Field` - the field containing the Zone ID. Defaults to 'ZoneId'.

* `To Field Prefix` - the prefix for the output fields.

### Output
The input record with the following output fields prepended with `To Field Prefix`:
* `Year`
* `Quarter`
* `Month`
* `Day`
* `Weekday`
* `Hour`
* `Minute`
* `Second`

#### Notes
* If `Zone Field` does not exist or does not contain a valid Zone ID, no output will be returned.
* the list of valid Zone IDs is derived from java.time.ZoneId.getAvailableZoneIds()

#### See Also
* Extract with Local TimeZone
* Extract with TimeZone
