## Date Range

This step will validate that a field contains a date string and that the date is
in the correct format and within the allowed range.

### Structure
1 => 1

### Input
* A record with a string field holding a date value.

### Parameters
* `Date Field` - The string field holding the date for testing
* `Minimum (yyyy-MM-dd)` - The earliest allowed date (in ISO format)
* `Maximum (yyyy-MM-dd)` - The latest allowed date (in ISO format)
* `Format` - The actual format of the date field

### Output
If the string field holds a valid date, the record is passed through unchanged.

If the string field cannot be parsed as a date in the expected format, a `validationIssue` will be added.

If the string field can be parsed as a date but is outside the allowed range, a `validationIssue` will be added.

#### Notes

* Sometimes a user interface will show a local format, eg. dd/MM/yyyy but internally convert to ISO standard yyyy-MM-dd.
In this case, prefer to use the ISO Date Range variant, as it presents validationIssues based on format, but expects
the input to always be ISO. This step expects the string to hold the local formatted date.

#### See Also
* ISO Date Range
